/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GetPKICertificate struct for GetPKICertificate
type GetPKICertificate struct {
	// The Subject Alternative Names to be included in the PKI certificate (in a comma-separated list) (if CSR is supplied this flag is ignored and any DNS.* names are taken from it)
	AltNames *string `json:"alt-names,omitempty"`
	// The name of the PKI certificate issuer
	CertIssuerName string `json:"cert-issuer-name"`
	// The common name to be included in the PKI certificate (if CSR is supplied this flag is ignored and the CSR subject CN is taken)
	CommonName *string `json:"common-name,omitempty"`
	// Certificate Signing Request contents encoded in base64 to generate the certificate with
	CsrDataBase64 *string `json:"csr-data-base64,omitempty"`
	// A comma-separated list of extended key usage requests which will be used for certificate issuance. Supported values: 'clientauth', 'serverauth'. If critical is present the extension will be marked as critical
	ExtendedKeyUsage *string `json:"extended-key-usage,omitempty"`
	// A json string that defines the requested extra extensions for the certificate
	ExtraExtensions *string `json:"extra-extensions,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// PKI key file contents. If this option is used, the certificate will be printed to stdout
	KeyDataBase64 *string `json:"key-data-base64,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// Updated certificate lifetime in seconds (must be less than the Certificate Issuer default TTL)
	Ttl *string `json:"ttl,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// The URI Subject Alternative Names to be included in the PKI certificate (in a comma-separated list) (if CSR is supplied this flag is ignored and any URI.* names are taken from it)
	UriSans *string `json:"uri-sans,omitempty"`
}

// NewGetPKICertificate instantiates a new GetPKICertificate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGetPKICertificate(certIssuerName string, ) *GetPKICertificate {
	this := GetPKICertificate{}
	this.CertIssuerName = certIssuerName
	var json bool = false
	this.Json = &json
	return &this
}

// NewGetPKICertificateWithDefaults instantiates a new GetPKICertificate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGetPKICertificateWithDefaults() *GetPKICertificate {
	this := GetPKICertificate{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAltNames returns the AltNames field value if set, zero value otherwise.
func (o *GetPKICertificate) GetAltNames() string {
	if o == nil || o.AltNames == nil {
		var ret string
		return ret
	}
	return *o.AltNames
}

// GetAltNamesOk returns a tuple with the AltNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetAltNamesOk() (*string, bool) {
	if o == nil || o.AltNames == nil {
		return nil, false
	}
	return o.AltNames, true
}

// HasAltNames returns a boolean if a field has been set.
func (o *GetPKICertificate) HasAltNames() bool {
	if o != nil && o.AltNames != nil {
		return true
	}

	return false
}

// SetAltNames gets a reference to the given string and assigns it to the AltNames field.
func (o *GetPKICertificate) SetAltNames(v string) {
	o.AltNames = &v
}

// GetCertIssuerName returns the CertIssuerName field value
func (o *GetPKICertificate) GetCertIssuerName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.CertIssuerName
}

// GetCertIssuerNameOk returns a tuple with the CertIssuerName field value
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetCertIssuerNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.CertIssuerName, true
}

// SetCertIssuerName sets field value
func (o *GetPKICertificate) SetCertIssuerName(v string) {
	o.CertIssuerName = v
}

// GetCommonName returns the CommonName field value if set, zero value otherwise.
func (o *GetPKICertificate) GetCommonName() string {
	if o == nil || o.CommonName == nil {
		var ret string
		return ret
	}
	return *o.CommonName
}

// GetCommonNameOk returns a tuple with the CommonName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetCommonNameOk() (*string, bool) {
	if o == nil || o.CommonName == nil {
		return nil, false
	}
	return o.CommonName, true
}

// HasCommonName returns a boolean if a field has been set.
func (o *GetPKICertificate) HasCommonName() bool {
	if o != nil && o.CommonName != nil {
		return true
	}

	return false
}

// SetCommonName gets a reference to the given string and assigns it to the CommonName field.
func (o *GetPKICertificate) SetCommonName(v string) {
	o.CommonName = &v
}

// GetCsrDataBase64 returns the CsrDataBase64 field value if set, zero value otherwise.
func (o *GetPKICertificate) GetCsrDataBase64() string {
	if o == nil || o.CsrDataBase64 == nil {
		var ret string
		return ret
	}
	return *o.CsrDataBase64
}

// GetCsrDataBase64Ok returns a tuple with the CsrDataBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetCsrDataBase64Ok() (*string, bool) {
	if o == nil || o.CsrDataBase64 == nil {
		return nil, false
	}
	return o.CsrDataBase64, true
}

// HasCsrDataBase64 returns a boolean if a field has been set.
func (o *GetPKICertificate) HasCsrDataBase64() bool {
	if o != nil && o.CsrDataBase64 != nil {
		return true
	}

	return false
}

// SetCsrDataBase64 gets a reference to the given string and assigns it to the CsrDataBase64 field.
func (o *GetPKICertificate) SetCsrDataBase64(v string) {
	o.CsrDataBase64 = &v
}

// GetExtendedKeyUsage returns the ExtendedKeyUsage field value if set, zero value otherwise.
func (o *GetPKICertificate) GetExtendedKeyUsage() string {
	if o == nil || o.ExtendedKeyUsage == nil {
		var ret string
		return ret
	}
	return *o.ExtendedKeyUsage
}

// GetExtendedKeyUsageOk returns a tuple with the ExtendedKeyUsage field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetExtendedKeyUsageOk() (*string, bool) {
	if o == nil || o.ExtendedKeyUsage == nil {
		return nil, false
	}
	return o.ExtendedKeyUsage, true
}

// HasExtendedKeyUsage returns a boolean if a field has been set.
func (o *GetPKICertificate) HasExtendedKeyUsage() bool {
	if o != nil && o.ExtendedKeyUsage != nil {
		return true
	}

	return false
}

// SetExtendedKeyUsage gets a reference to the given string and assigns it to the ExtendedKeyUsage field.
func (o *GetPKICertificate) SetExtendedKeyUsage(v string) {
	o.ExtendedKeyUsage = &v
}

// GetExtraExtensions returns the ExtraExtensions field value if set, zero value otherwise.
func (o *GetPKICertificate) GetExtraExtensions() string {
	if o == nil || o.ExtraExtensions == nil {
		var ret string
		return ret
	}
	return *o.ExtraExtensions
}

// GetExtraExtensionsOk returns a tuple with the ExtraExtensions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetExtraExtensionsOk() (*string, bool) {
	if o == nil || o.ExtraExtensions == nil {
		return nil, false
	}
	return o.ExtraExtensions, true
}

// HasExtraExtensions returns a boolean if a field has been set.
func (o *GetPKICertificate) HasExtraExtensions() bool {
	if o != nil && o.ExtraExtensions != nil {
		return true
	}

	return false
}

// SetExtraExtensions gets a reference to the given string and assigns it to the ExtraExtensions field.
func (o *GetPKICertificate) SetExtraExtensions(v string) {
	o.ExtraExtensions = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GetPKICertificate) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GetPKICertificate) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GetPKICertificate) SetJson(v bool) {
	o.Json = &v
}

// GetKeyDataBase64 returns the KeyDataBase64 field value if set, zero value otherwise.
func (o *GetPKICertificate) GetKeyDataBase64() string {
	if o == nil || o.KeyDataBase64 == nil {
		var ret string
		return ret
	}
	return *o.KeyDataBase64
}

// GetKeyDataBase64Ok returns a tuple with the KeyDataBase64 field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetKeyDataBase64Ok() (*string, bool) {
	if o == nil || o.KeyDataBase64 == nil {
		return nil, false
	}
	return o.KeyDataBase64, true
}

// HasKeyDataBase64 returns a boolean if a field has been set.
func (o *GetPKICertificate) HasKeyDataBase64() bool {
	if o != nil && o.KeyDataBase64 != nil {
		return true
	}

	return false
}

// SetKeyDataBase64 gets a reference to the given string and assigns it to the KeyDataBase64 field.
func (o *GetPKICertificate) SetKeyDataBase64(v string) {
	o.KeyDataBase64 = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GetPKICertificate) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GetPKICertificate) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GetPKICertificate) SetToken(v string) {
	o.Token = &v
}

// GetTtl returns the Ttl field value if set, zero value otherwise.
func (o *GetPKICertificate) GetTtl() string {
	if o == nil || o.Ttl == nil {
		var ret string
		return ret
	}
	return *o.Ttl
}

// GetTtlOk returns a tuple with the Ttl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetTtlOk() (*string, bool) {
	if o == nil || o.Ttl == nil {
		return nil, false
	}
	return o.Ttl, true
}

// HasTtl returns a boolean if a field has been set.
func (o *GetPKICertificate) HasTtl() bool {
	if o != nil && o.Ttl != nil {
		return true
	}

	return false
}

// SetTtl gets a reference to the given string and assigns it to the Ttl field.
func (o *GetPKICertificate) SetTtl(v string) {
	o.Ttl = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GetPKICertificate) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GetPKICertificate) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GetPKICertificate) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUriSans returns the UriSans field value if set, zero value otherwise.
func (o *GetPKICertificate) GetUriSans() string {
	if o == nil || o.UriSans == nil {
		var ret string
		return ret
	}
	return *o.UriSans
}

// GetUriSansOk returns a tuple with the UriSans field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetPKICertificate) GetUriSansOk() (*string, bool) {
	if o == nil || o.UriSans == nil {
		return nil, false
	}
	return o.UriSans, true
}

// HasUriSans returns a boolean if a field has been set.
func (o *GetPKICertificate) HasUriSans() bool {
	if o != nil && o.UriSans != nil {
		return true
	}

	return false
}

// SetUriSans gets a reference to the given string and assigns it to the UriSans field.
func (o *GetPKICertificate) SetUriSans(v string) {
	o.UriSans = &v
}

func (o GetPKICertificate) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AltNames != nil {
		toSerialize["alt-names"] = o.AltNames
	}
	if true {
		toSerialize["cert-issuer-name"] = o.CertIssuerName
	}
	if o.CommonName != nil {
		toSerialize["common-name"] = o.CommonName
	}
	if o.CsrDataBase64 != nil {
		toSerialize["csr-data-base64"] = o.CsrDataBase64
	}
	if o.ExtendedKeyUsage != nil {
		toSerialize["extended-key-usage"] = o.ExtendedKeyUsage
	}
	if o.ExtraExtensions != nil {
		toSerialize["extra-extensions"] = o.ExtraExtensions
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeyDataBase64 != nil {
		toSerialize["key-data-base64"] = o.KeyDataBase64
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.Ttl != nil {
		toSerialize["ttl"] = o.Ttl
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UriSans != nil {
		toSerialize["uri-sans"] = o.UriSans
	}
	return json.Marshal(toSerialize)
}

type NullableGetPKICertificate struct {
	value *GetPKICertificate
	isSet bool
}

func (v NullableGetPKICertificate) Get() *GetPKICertificate {
	return v.value
}

func (v *NullableGetPKICertificate) Set(val *GetPKICertificate) {
	v.value = val
	v.isSet = true
}

func (v NullableGetPKICertificate) IsSet() bool {
	return v.isSet
}

func (v *NullableGetPKICertificate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGetPKICertificate(val *GetPKICertificate) *NullableGetPKICertificate {
	return &NullableGetPKICertificate{value: val, isSet: true}
}

func (v NullableGetPKICertificate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGetPKICertificate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


