/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateRemoteAccess gatewayUpdateRemoteAccess is a command that update remote access config
type GatewayUpdateRemoteAccess struct {
	// List of valid URLs to redirect from the Portal back to the remote access server (in a comma-delimited list)
	AllowedUrls *string `json:"allowed-urls,omitempty"`
	// Specifies whether to show/hide if the session is currently recorded [true/false]
	HideSessionRecording *string `json:"hide-session-recording,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Decide which algorithm will be used as part of the SSH initial hand-shake process
	Kexalgs *string `json:"kexalgs,omitempty"`
	// Enable support for additional keyboard layouts
	KeyboardLayout *string `json:"keyboard-layout,omitempty"`
	// Signs SSH certificates using legacy ssh-rsa-cert-01@openssh.com signing algorithm [true/false]
	LegacySshAlgorithm *string `json:"legacy-ssh-algorithm,omitempty"`
	// Specify the usernameSubClaim that exists inside the IDP JWT, e.g. email
	RdpTargetConfiguration *string `json:"rdp-target-configuration,omitempty"`
	// Specify the usernameSubClaim that exists inside the IDP JWT, e.g. email
	SshTargetConfiguration *string `json:"ssh-target-configuration,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateRemoteAccess instantiates a new GatewayUpdateRemoteAccess object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateRemoteAccess() *GatewayUpdateRemoteAccess {
	this := GatewayUpdateRemoteAccess{}
	var allowedUrls string = "use-existing"
	this.AllowedUrls = &allowedUrls
	var json bool = false
	this.Json = &json
	var kexalgs string = "use-existing"
	this.Kexalgs = &kexalgs
	var keyboardLayout string = "use-existing"
	this.KeyboardLayout = &keyboardLayout
	var rdpTargetConfiguration string = "use-existing"
	this.RdpTargetConfiguration = &rdpTargetConfiguration
	var sshTargetConfiguration string = "use-existing"
	this.SshTargetConfiguration = &sshTargetConfiguration
	return &this
}

// NewGatewayUpdateRemoteAccessWithDefaults instantiates a new GatewayUpdateRemoteAccess object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateRemoteAccessWithDefaults() *GatewayUpdateRemoteAccess {
	this := GatewayUpdateRemoteAccess{}
	var allowedUrls string = "use-existing"
	this.AllowedUrls = &allowedUrls
	var json bool = false
	this.Json = &json
	var kexalgs string = "use-existing"
	this.Kexalgs = &kexalgs
	var keyboardLayout string = "use-existing"
	this.KeyboardLayout = &keyboardLayout
	var rdpTargetConfiguration string = "use-existing"
	this.RdpTargetConfiguration = &rdpTargetConfiguration
	var sshTargetConfiguration string = "use-existing"
	this.SshTargetConfiguration = &sshTargetConfiguration
	return &this
}

// GetAllowedUrls returns the AllowedUrls field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetAllowedUrls() string {
	if o == nil || o.AllowedUrls == nil {
		var ret string
		return ret
	}
	return *o.AllowedUrls
}

// GetAllowedUrlsOk returns a tuple with the AllowedUrls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetAllowedUrlsOk() (*string, bool) {
	if o == nil || o.AllowedUrls == nil {
		return nil, false
	}
	return o.AllowedUrls, true
}

// HasAllowedUrls returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasAllowedUrls() bool {
	if o != nil && o.AllowedUrls != nil {
		return true
	}

	return false
}

// SetAllowedUrls gets a reference to the given string and assigns it to the AllowedUrls field.
func (o *GatewayUpdateRemoteAccess) SetAllowedUrls(v string) {
	o.AllowedUrls = &v
}

// GetHideSessionRecording returns the HideSessionRecording field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetHideSessionRecording() string {
	if o == nil || o.HideSessionRecording == nil {
		var ret string
		return ret
	}
	return *o.HideSessionRecording
}

// GetHideSessionRecordingOk returns a tuple with the HideSessionRecording field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetHideSessionRecordingOk() (*string, bool) {
	if o == nil || o.HideSessionRecording == nil {
		return nil, false
	}
	return o.HideSessionRecording, true
}

// HasHideSessionRecording returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasHideSessionRecording() bool {
	if o != nil && o.HideSessionRecording != nil {
		return true
	}

	return false
}

// SetHideSessionRecording gets a reference to the given string and assigns it to the HideSessionRecording field.
func (o *GatewayUpdateRemoteAccess) SetHideSessionRecording(v string) {
	o.HideSessionRecording = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateRemoteAccess) SetJson(v bool) {
	o.Json = &v
}

// GetKexalgs returns the Kexalgs field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetKexalgs() string {
	if o == nil || o.Kexalgs == nil {
		var ret string
		return ret
	}
	return *o.Kexalgs
}

// GetKexalgsOk returns a tuple with the Kexalgs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetKexalgsOk() (*string, bool) {
	if o == nil || o.Kexalgs == nil {
		return nil, false
	}
	return o.Kexalgs, true
}

// HasKexalgs returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasKexalgs() bool {
	if o != nil && o.Kexalgs != nil {
		return true
	}

	return false
}

// SetKexalgs gets a reference to the given string and assigns it to the Kexalgs field.
func (o *GatewayUpdateRemoteAccess) SetKexalgs(v string) {
	o.Kexalgs = &v
}

// GetKeyboardLayout returns the KeyboardLayout field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetKeyboardLayout() string {
	if o == nil || o.KeyboardLayout == nil {
		var ret string
		return ret
	}
	return *o.KeyboardLayout
}

// GetKeyboardLayoutOk returns a tuple with the KeyboardLayout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetKeyboardLayoutOk() (*string, bool) {
	if o == nil || o.KeyboardLayout == nil {
		return nil, false
	}
	return o.KeyboardLayout, true
}

// HasKeyboardLayout returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasKeyboardLayout() bool {
	if o != nil && o.KeyboardLayout != nil {
		return true
	}

	return false
}

// SetKeyboardLayout gets a reference to the given string and assigns it to the KeyboardLayout field.
func (o *GatewayUpdateRemoteAccess) SetKeyboardLayout(v string) {
	o.KeyboardLayout = &v
}

// GetLegacySshAlgorithm returns the LegacySshAlgorithm field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetLegacySshAlgorithm() string {
	if o == nil || o.LegacySshAlgorithm == nil {
		var ret string
		return ret
	}
	return *o.LegacySshAlgorithm
}

// GetLegacySshAlgorithmOk returns a tuple with the LegacySshAlgorithm field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetLegacySshAlgorithmOk() (*string, bool) {
	if o == nil || o.LegacySshAlgorithm == nil {
		return nil, false
	}
	return o.LegacySshAlgorithm, true
}

// HasLegacySshAlgorithm returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasLegacySshAlgorithm() bool {
	if o != nil && o.LegacySshAlgorithm != nil {
		return true
	}

	return false
}

// SetLegacySshAlgorithm gets a reference to the given string and assigns it to the LegacySshAlgorithm field.
func (o *GatewayUpdateRemoteAccess) SetLegacySshAlgorithm(v string) {
	o.LegacySshAlgorithm = &v
}

// GetRdpTargetConfiguration returns the RdpTargetConfiguration field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetRdpTargetConfiguration() string {
	if o == nil || o.RdpTargetConfiguration == nil {
		var ret string
		return ret
	}
	return *o.RdpTargetConfiguration
}

// GetRdpTargetConfigurationOk returns a tuple with the RdpTargetConfiguration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetRdpTargetConfigurationOk() (*string, bool) {
	if o == nil || o.RdpTargetConfiguration == nil {
		return nil, false
	}
	return o.RdpTargetConfiguration, true
}

// HasRdpTargetConfiguration returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasRdpTargetConfiguration() bool {
	if o != nil && o.RdpTargetConfiguration != nil {
		return true
	}

	return false
}

// SetRdpTargetConfiguration gets a reference to the given string and assigns it to the RdpTargetConfiguration field.
func (o *GatewayUpdateRemoteAccess) SetRdpTargetConfiguration(v string) {
	o.RdpTargetConfiguration = &v
}

// GetSshTargetConfiguration returns the SshTargetConfiguration field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetSshTargetConfiguration() string {
	if o == nil || o.SshTargetConfiguration == nil {
		var ret string
		return ret
	}
	return *o.SshTargetConfiguration
}

// GetSshTargetConfigurationOk returns a tuple with the SshTargetConfiguration field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetSshTargetConfigurationOk() (*string, bool) {
	if o == nil || o.SshTargetConfiguration == nil {
		return nil, false
	}
	return o.SshTargetConfiguration, true
}

// HasSshTargetConfiguration returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasSshTargetConfiguration() bool {
	if o != nil && o.SshTargetConfiguration != nil {
		return true
	}

	return false
}

// SetSshTargetConfiguration gets a reference to the given string and assigns it to the SshTargetConfiguration field.
func (o *GatewayUpdateRemoteAccess) SetSshTargetConfiguration(v string) {
	o.SshTargetConfiguration = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateRemoteAccess) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateRemoteAccess) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateRemoteAccess) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateRemoteAccess) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateRemoteAccess) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateRemoteAccess) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowedUrls != nil {
		toSerialize["allowed-urls"] = o.AllowedUrls
	}
	if o.HideSessionRecording != nil {
		toSerialize["hide-session-recording"] = o.HideSessionRecording
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Kexalgs != nil {
		toSerialize["kexalgs"] = o.Kexalgs
	}
	if o.KeyboardLayout != nil {
		toSerialize["keyboard-layout"] = o.KeyboardLayout
	}
	if o.LegacySshAlgorithm != nil {
		toSerialize["legacy-ssh-algorithm"] = o.LegacySshAlgorithm
	}
	if o.RdpTargetConfiguration != nil {
		toSerialize["rdp-target-configuration"] = o.RdpTargetConfiguration
	}
	if o.SshTargetConfiguration != nil {
		toSerialize["ssh-target-configuration"] = o.SshTargetConfiguration
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateRemoteAccess struct {
	value *GatewayUpdateRemoteAccess
	isSet bool
}

func (v NullableGatewayUpdateRemoteAccess) Get() *GatewayUpdateRemoteAccess {
	return v.value
}

func (v *NullableGatewayUpdateRemoteAccess) Set(val *GatewayUpdateRemoteAccess) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateRemoteAccess) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateRemoteAccess) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateRemoteAccess(val *GatewayUpdateRemoteAccess) *NullableGatewayUpdateRemoteAccess {
	return &NullableGatewayUpdateRemoteAccess{value: val, isSet: true}
}

func (v NullableGatewayUpdateRemoteAccess) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateRemoteAccess) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


