/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EsmUpdate esmUpdate is a command that updates a secret in an External Secrets Manager
type EsmUpdate struct {
	// Use this option if the external secret value is a base64 encoded binary
	BinaryValue *bool `json:"binary-value,omitempty"`
	// Description of the external secret
	Description *string `json:"description,omitempty"`
	// Name of the External Secrets Manager item
	EsmName string `json:"esm-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The external secret id (or name, for AWS, Azure or K8s targets) to update
	SecretId string `json:"secret-id"`
	// Tags for the external secret
	Tags *map[string]string `json:"tags,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Value of the external secret item, either text or base64 encoded binary
	Value string `json:"value"`
}

// NewEsmUpdate instantiates a new EsmUpdate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEsmUpdate(esmName string, secretId string, value string, ) *EsmUpdate {
	this := EsmUpdate{}
	this.EsmName = esmName
	var json bool = false
	this.Json = &json
	this.SecretId = secretId
	this.Value = value
	return &this
}

// NewEsmUpdateWithDefaults instantiates a new EsmUpdate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEsmUpdateWithDefaults() *EsmUpdate {
	this := EsmUpdate{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetBinaryValue returns the BinaryValue field value if set, zero value otherwise.
func (o *EsmUpdate) GetBinaryValue() bool {
	if o == nil || o.BinaryValue == nil {
		var ret bool
		return ret
	}
	return *o.BinaryValue
}

// GetBinaryValueOk returns a tuple with the BinaryValue field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetBinaryValueOk() (*bool, bool) {
	if o == nil || o.BinaryValue == nil {
		return nil, false
	}
	return o.BinaryValue, true
}

// HasBinaryValue returns a boolean if a field has been set.
func (o *EsmUpdate) HasBinaryValue() bool {
	if o != nil && o.BinaryValue != nil {
		return true
	}

	return false
}

// SetBinaryValue gets a reference to the given bool and assigns it to the BinaryValue field.
func (o *EsmUpdate) SetBinaryValue(v bool) {
	o.BinaryValue = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *EsmUpdate) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *EsmUpdate) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *EsmUpdate) SetDescription(v string) {
	o.Description = &v
}

// GetEsmName returns the EsmName field value
func (o *EsmUpdate) GetEsmName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EsmName
}

// GetEsmNameOk returns a tuple with the EsmName field value
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetEsmNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EsmName, true
}

// SetEsmName sets field value
func (o *EsmUpdate) SetEsmName(v string) {
	o.EsmName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *EsmUpdate) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *EsmUpdate) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *EsmUpdate) SetJson(v bool) {
	o.Json = &v
}

// GetSecretId returns the SecretId field value
func (o *EsmUpdate) GetSecretId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SecretId
}

// GetSecretIdOk returns a tuple with the SecretId field value
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetSecretIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SecretId, true
}

// SetSecretId sets field value
func (o *EsmUpdate) SetSecretId(v string) {
	o.SecretId = v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *EsmUpdate) GetTags() map[string]string {
	if o == nil || o.Tags == nil {
		var ret map[string]string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetTagsOk() (*map[string]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *EsmUpdate) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given map[string]string and assigns it to the Tags field.
func (o *EsmUpdate) SetTags(v map[string]string) {
	o.Tags = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EsmUpdate) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EsmUpdate) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EsmUpdate) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *EsmUpdate) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *EsmUpdate) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *EsmUpdate) SetUidToken(v string) {
	o.UidToken = &v
}

// GetValue returns the Value field value
func (o *EsmUpdate) GetValue() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Value
}

// GetValueOk returns a tuple with the Value field value
// and a boolean to check if the value has been set.
func (o *EsmUpdate) GetValueOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Value, true
}

// SetValue sets field value
func (o *EsmUpdate) SetValue(v string) {
	o.Value = v
}

func (o EsmUpdate) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.BinaryValue != nil {
		toSerialize["binary-value"] = o.BinaryValue
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["esm-name"] = o.EsmName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["secret-id"] = o.SecretId
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["value"] = o.Value
	}
	return json.Marshal(toSerialize)
}

type NullableEsmUpdate struct {
	value *EsmUpdate
	isSet bool
}

func (v NullableEsmUpdate) Get() *EsmUpdate {
	return v.value
}

func (v *NullableEsmUpdate) Set(val *EsmUpdate) {
	v.value = val
	v.isSet = true
}

func (v NullableEsmUpdate) IsSet() bool {
	return v.isSet
}

func (v *NullableEsmUpdate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEsmUpdate(val *EsmUpdate) *NullableEsmUpdate {
	return &NullableEsmUpdate{value: val, isSet: true}
}

func (v NullableEsmUpdate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEsmUpdate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


