/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EsmList esmList is a command that lists the secrets of an External Secrets Manager
type EsmList struct {
	// Name of the External Secrets Manager item
	EsmName string `json:"esm-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewEsmList instantiates a new EsmList object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEsmList(esmName string, ) *EsmList {
	this := EsmList{}
	this.EsmName = esmName
	var json bool = false
	this.Json = &json
	return &this
}

// NewEsmListWithDefaults instantiates a new EsmList object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEsmListWithDefaults() *EsmList {
	this := EsmList{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetEsmName returns the EsmName field value
func (o *EsmList) GetEsmName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EsmName
}

// GetEsmNameOk returns a tuple with the EsmName field value
// and a boolean to check if the value has been set.
func (o *EsmList) GetEsmNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EsmName, true
}

// SetEsmName sets field value
func (o *EsmList) SetEsmName(v string) {
	o.EsmName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *EsmList) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmList) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *EsmList) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *EsmList) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *EsmList) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmList) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *EsmList) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *EsmList) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *EsmList) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EsmList) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *EsmList) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *EsmList) SetUidToken(v string) {
	o.UidToken = &v
}

func (o EsmList) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["esm-name"] = o.EsmName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableEsmList struct {
	value *EsmList
	isSet bool
}

func (v NullableEsmList) Get() *EsmList {
	return v.value
}

func (v *NullableEsmList) Set(val *EsmList) {
	v.value = val
	v.isSet = true
}

func (v NullableEsmList) IsSet() bool {
	return v.isSet
}

func (v *NullableEsmList) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEsmList(val *EsmList) *NullableEsmList {
	return &NullableEsmList{value: val, isSet: true}
}

func (v NullableEsmList) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEsmList) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


