/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// EmailTokenizerInfo EmailTokenizerInfo represents a tokenizer that specifically tokenizes emails
type EmailTokenizerInfo struct {
	// What length of a random domain suffix to generate used only if FixedDomainSuffix is empty
	DomainSuffixLength *int64 `json:"domain_suffix_length,omitempty"`
	// if FixedDomainSuffix isn't empty, it will be appended to the output
	FixedDomainSuffix *string `json:"fixed_domain_suffix,omitempty"`
	// How many letters of the plaintext to keep in the output
	KeepPrefixLength *int64 `json:"keep_prefix_length,omitempty"`
}

// NewEmailTokenizerInfo instantiates a new EmailTokenizerInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEmailTokenizerInfo() *EmailTokenizerInfo {
	this := EmailTokenizerInfo{}
	return &this
}

// NewEmailTokenizerInfoWithDefaults instantiates a new EmailTokenizerInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEmailTokenizerInfoWithDefaults() *EmailTokenizerInfo {
	this := EmailTokenizerInfo{}
	return &this
}

// GetDomainSuffixLength returns the DomainSuffixLength field value if set, zero value otherwise.
func (o *EmailTokenizerInfo) GetDomainSuffixLength() int64 {
	if o == nil || o.DomainSuffixLength == nil {
		var ret int64
		return ret
	}
	return *o.DomainSuffixLength
}

// GetDomainSuffixLengthOk returns a tuple with the DomainSuffixLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailTokenizerInfo) GetDomainSuffixLengthOk() (*int64, bool) {
	if o == nil || o.DomainSuffixLength == nil {
		return nil, false
	}
	return o.DomainSuffixLength, true
}

// HasDomainSuffixLength returns a boolean if a field has been set.
func (o *EmailTokenizerInfo) HasDomainSuffixLength() bool {
	if o != nil && o.DomainSuffixLength != nil {
		return true
	}

	return false
}

// SetDomainSuffixLength gets a reference to the given int64 and assigns it to the DomainSuffixLength field.
func (o *EmailTokenizerInfo) SetDomainSuffixLength(v int64) {
	o.DomainSuffixLength = &v
}

// GetFixedDomainSuffix returns the FixedDomainSuffix field value if set, zero value otherwise.
func (o *EmailTokenizerInfo) GetFixedDomainSuffix() string {
	if o == nil || o.FixedDomainSuffix == nil {
		var ret string
		return ret
	}
	return *o.FixedDomainSuffix
}

// GetFixedDomainSuffixOk returns a tuple with the FixedDomainSuffix field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailTokenizerInfo) GetFixedDomainSuffixOk() (*string, bool) {
	if o == nil || o.FixedDomainSuffix == nil {
		return nil, false
	}
	return o.FixedDomainSuffix, true
}

// HasFixedDomainSuffix returns a boolean if a field has been set.
func (o *EmailTokenizerInfo) HasFixedDomainSuffix() bool {
	if o != nil && o.FixedDomainSuffix != nil {
		return true
	}

	return false
}

// SetFixedDomainSuffix gets a reference to the given string and assigns it to the FixedDomainSuffix field.
func (o *EmailTokenizerInfo) SetFixedDomainSuffix(v string) {
	o.FixedDomainSuffix = &v
}

// GetKeepPrefixLength returns the KeepPrefixLength field value if set, zero value otherwise.
func (o *EmailTokenizerInfo) GetKeepPrefixLength() int64 {
	if o == nil || o.KeepPrefixLength == nil {
		var ret int64
		return ret
	}
	return *o.KeepPrefixLength
}

// GetKeepPrefixLengthOk returns a tuple with the KeepPrefixLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EmailTokenizerInfo) GetKeepPrefixLengthOk() (*int64, bool) {
	if o == nil || o.KeepPrefixLength == nil {
		return nil, false
	}
	return o.KeepPrefixLength, true
}

// HasKeepPrefixLength returns a boolean if a field has been set.
func (o *EmailTokenizerInfo) HasKeepPrefixLength() bool {
	if o != nil && o.KeepPrefixLength != nil {
		return true
	}

	return false
}

// SetKeepPrefixLength gets a reference to the given int64 and assigns it to the KeepPrefixLength field.
func (o *EmailTokenizerInfo) SetKeepPrefixLength(v int64) {
	o.KeepPrefixLength = &v
}

func (o EmailTokenizerInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DomainSuffixLength != nil {
		toSerialize["domain_suffix_length"] = o.DomainSuffixLength
	}
	if o.FixedDomainSuffix != nil {
		toSerialize["fixed_domain_suffix"] = o.FixedDomainSuffix
	}
	if o.KeepPrefixLength != nil {
		toSerialize["keep_prefix_length"] = o.KeepPrefixLength
	}
	return json.Marshal(toSerialize)
}

type NullableEmailTokenizerInfo struct {
	value *EmailTokenizerInfo
	isSet bool
}

func (v NullableEmailTokenizerInfo) Get() *EmailTokenizerInfo {
	return v.value
}

func (v *NullableEmailTokenizerInfo) Set(val *EmailTokenizerInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableEmailTokenizerInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableEmailTokenizerInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEmailTokenizerInfo(val *EmailTokenizerInfo) *NullableEmailTokenizerInfo {
	return &NullableEmailTokenizerInfo{value: val, isSet: true}
}

func (v NullableEmailTokenizerInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEmailTokenizerInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


