/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateChef dynamicSecretUpdateChef is a command that updates chef dynamic secret
type DynamicSecretUpdateChef struct {
	// Organizations
	ChefOrgs *string `json:"chef-orgs,omitempty"`
	// Server key
	ChefServerKey *string `json:"chef-server-key,omitempty"`
	// Server URL
	ChefServerUrl *string `json:"chef-server-url,omitempty"`
	// Server username
	ChefServerUsername *string `json:"chef-server-username,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Skip SSL
	SkipSsl *bool `json:"skip-ssl,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretUpdateChef instantiates a new DynamicSecretUpdateChef object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateChef(name string, ) *DynamicSecretUpdateChef {
	this := DynamicSecretUpdateChef{}
	var json bool = false
	this.Json = &json
	this.Name = name
	var skipSsl bool = true
	this.SkipSsl = &skipSsl
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretUpdateChefWithDefaults instantiates a new DynamicSecretUpdateChef object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateChefWithDefaults() *DynamicSecretUpdateChef {
	this := DynamicSecretUpdateChef{}
	var json bool = false
	this.Json = &json
	var skipSsl bool = true
	this.SkipSsl = &skipSsl
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetChefOrgs returns the ChefOrgs field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetChefOrgs() string {
	if o == nil || o.ChefOrgs == nil {
		var ret string
		return ret
	}
	return *o.ChefOrgs
}

// GetChefOrgsOk returns a tuple with the ChefOrgs field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetChefOrgsOk() (*string, bool) {
	if o == nil || o.ChefOrgs == nil {
		return nil, false
	}
	return o.ChefOrgs, true
}

// HasChefOrgs returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasChefOrgs() bool {
	if o != nil && o.ChefOrgs != nil {
		return true
	}

	return false
}

// SetChefOrgs gets a reference to the given string and assigns it to the ChefOrgs field.
func (o *DynamicSecretUpdateChef) SetChefOrgs(v string) {
	o.ChefOrgs = &v
}

// GetChefServerKey returns the ChefServerKey field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetChefServerKey() string {
	if o == nil || o.ChefServerKey == nil {
		var ret string
		return ret
	}
	return *o.ChefServerKey
}

// GetChefServerKeyOk returns a tuple with the ChefServerKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetChefServerKeyOk() (*string, bool) {
	if o == nil || o.ChefServerKey == nil {
		return nil, false
	}
	return o.ChefServerKey, true
}

// HasChefServerKey returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasChefServerKey() bool {
	if o != nil && o.ChefServerKey != nil {
		return true
	}

	return false
}

// SetChefServerKey gets a reference to the given string and assigns it to the ChefServerKey field.
func (o *DynamicSecretUpdateChef) SetChefServerKey(v string) {
	o.ChefServerKey = &v
}

// GetChefServerUrl returns the ChefServerUrl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetChefServerUrl() string {
	if o == nil || o.ChefServerUrl == nil {
		var ret string
		return ret
	}
	return *o.ChefServerUrl
}

// GetChefServerUrlOk returns a tuple with the ChefServerUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetChefServerUrlOk() (*string, bool) {
	if o == nil || o.ChefServerUrl == nil {
		return nil, false
	}
	return o.ChefServerUrl, true
}

// HasChefServerUrl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasChefServerUrl() bool {
	if o != nil && o.ChefServerUrl != nil {
		return true
	}

	return false
}

// SetChefServerUrl gets a reference to the given string and assigns it to the ChefServerUrl field.
func (o *DynamicSecretUpdateChef) SetChefServerUrl(v string) {
	o.ChefServerUrl = &v
}

// GetChefServerUsername returns the ChefServerUsername field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetChefServerUsername() string {
	if o == nil || o.ChefServerUsername == nil {
		var ret string
		return ret
	}
	return *o.ChefServerUsername
}

// GetChefServerUsernameOk returns a tuple with the ChefServerUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetChefServerUsernameOk() (*string, bool) {
	if o == nil || o.ChefServerUsername == nil {
		return nil, false
	}
	return o.ChefServerUsername, true
}

// HasChefServerUsername returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasChefServerUsername() bool {
	if o != nil && o.ChefServerUsername != nil {
		return true
	}

	return false
}

// SetChefServerUsername gets a reference to the given string and assigns it to the ChefServerUsername field.
func (o *DynamicSecretUpdateChef) SetChefServerUsername(v string) {
	o.ChefServerUsername = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateChef) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateChef) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateChef) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateChef) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateChef) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateChef) SetNewName(v string) {
	o.NewName = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *DynamicSecretUpdateChef) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretUpdateChef) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetSkipSsl returns the SkipSsl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetSkipSsl() bool {
	if o == nil || o.SkipSsl == nil {
		var ret bool
		return ret
	}
	return *o.SkipSsl
}

// GetSkipSslOk returns a tuple with the SkipSsl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetSkipSslOk() (*bool, bool) {
	if o == nil || o.SkipSsl == nil {
		return nil, false
	}
	return o.SkipSsl, true
}

// HasSkipSsl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasSkipSsl() bool {
	if o != nil && o.SkipSsl != nil {
		return true
	}

	return false
}

// SetSkipSsl gets a reference to the given bool and assigns it to the SkipSsl field.
func (o *DynamicSecretUpdateChef) SetSkipSsl(v bool) {
	o.SkipSsl = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateChef) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateChef) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateChef) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateChef) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateChef) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateChef) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateChef) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretUpdateChef) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretUpdateChef) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ChefOrgs != nil {
		toSerialize["chef-orgs"] = o.ChefOrgs
	}
	if o.ChefServerKey != nil {
		toSerialize["chef-server-key"] = o.ChefServerKey
	}
	if o.ChefServerUrl != nil {
		toSerialize["chef-server-url"] = o.ChefServerUrl
	}
	if o.ChefServerUsername != nil {
		toSerialize["chef-server-username"] = o.ChefServerUsername
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.SkipSsl != nil {
		toSerialize["skip-ssl"] = o.SkipSsl
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateChef struct {
	value *DynamicSecretUpdateChef
	isSet bool
}

func (v NullableDynamicSecretUpdateChef) Get() *DynamicSecretUpdateChef {
	return v.value
}

func (v *NullableDynamicSecretUpdateChef) Set(val *DynamicSecretUpdateChef) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateChef) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateChef) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateChef(val *DynamicSecretUpdateChef) *NullableDynamicSecretUpdateChef {
	return &NullableDynamicSecretUpdateChef{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateChef) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateChef) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


