/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DeleteGatewayAllowedAccessId deleteGatewayAllowedAccessId is a command that deletes access-id
type DeleteGatewayAllowedAccessId struct {
	// The access id to be stripped of access to gateway
	AccessId string `json:"access-id"`
	// The name of the updated cluster, e.g. acc-abcd12345678/p-123456789012/defaultCluster
	ClusterName string `json:"cluster-name"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDeleteGatewayAllowedAccessId instantiates a new DeleteGatewayAllowedAccessId object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDeleteGatewayAllowedAccessId(accessId string, clusterName string, ) *DeleteGatewayAllowedAccessId {
	this := DeleteGatewayAllowedAccessId{}
	this.AccessId = accessId
	this.ClusterName = clusterName
	var json bool = false
	this.Json = &json
	return &this
}

// NewDeleteGatewayAllowedAccessIdWithDefaults instantiates a new DeleteGatewayAllowedAccessId object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDeleteGatewayAllowedAccessIdWithDefaults() *DeleteGatewayAllowedAccessId {
	this := DeleteGatewayAllowedAccessId{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAccessId returns the AccessId field value
func (o *DeleteGatewayAllowedAccessId) GetAccessId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AccessId
}

// GetAccessIdOk returns a tuple with the AccessId field value
// and a boolean to check if the value has been set.
func (o *DeleteGatewayAllowedAccessId) GetAccessIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AccessId, true
}

// SetAccessId sets field value
func (o *DeleteGatewayAllowedAccessId) SetAccessId(v string) {
	o.AccessId = v
}

// GetClusterName returns the ClusterName field value
func (o *DeleteGatewayAllowedAccessId) GetClusterName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ClusterName
}

// GetClusterNameOk returns a tuple with the ClusterName field value
// and a boolean to check if the value has been set.
func (o *DeleteGatewayAllowedAccessId) GetClusterNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ClusterName, true
}

// SetClusterName sets field value
func (o *DeleteGatewayAllowedAccessId) SetClusterName(v string) {
	o.ClusterName = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DeleteGatewayAllowedAccessId) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGatewayAllowedAccessId) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DeleteGatewayAllowedAccessId) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DeleteGatewayAllowedAccessId) SetJson(v bool) {
	o.Json = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DeleteGatewayAllowedAccessId) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGatewayAllowedAccessId) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DeleteGatewayAllowedAccessId) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DeleteGatewayAllowedAccessId) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DeleteGatewayAllowedAccessId) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DeleteGatewayAllowedAccessId) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DeleteGatewayAllowedAccessId) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DeleteGatewayAllowedAccessId) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DeleteGatewayAllowedAccessId) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["access-id"] = o.AccessId
	}
	if true {
		toSerialize["cluster-name"] = o.ClusterName
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDeleteGatewayAllowedAccessId struct {
	value *DeleteGatewayAllowedAccessId
	isSet bool
}

func (v NullableDeleteGatewayAllowedAccessId) Get() *DeleteGatewayAllowedAccessId {
	return v.value
}

func (v *NullableDeleteGatewayAllowedAccessId) Set(val *DeleteGatewayAllowedAccessId) {
	v.value = val
	v.isSet = true
}

func (v NullableDeleteGatewayAllowedAccessId) IsSet() bool {
	return v.isSet
}

func (v *NullableDeleteGatewayAllowedAccessId) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDeleteGatewayAllowedAccessId(val *DeleteGatewayAllowedAccessId) *NullableDeleteGatewayAllowedAccessId {
	return &NullableDeleteGatewayAllowedAccessId{value: val, isSet: true}
}

func (v NullableDeleteGatewayAllowedAccessId) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDeleteGatewayAllowedAccessId) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


