/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateZeroSSLTarget createZeroSSLTarget is a command that creates a new target. [Deprecated: Use target-create-zerossl command]
type CreateZeroSSLTarget struct {
	// API Key of the ZeroSSLTarget account
	ApiKey string `json:"api-key"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// ImapFQDN of the IMAP service, FQDN or IPv4 address. Must be FQDN if the IMAP is using TLS
	ImapFqdn string `json:"imap-fqdn"`
	// ImapPassword to access the IMAP service
	ImapPassword string `json:"imap-password"`
	// ImapPort of the IMAP service
	ImapPort *string `json:"imap-port,omitempty"`
	// ImapValidationEmail to use when asking ZeroSSL to send a validation email, if empty will user imap-username
	ImapTargetEmail *string `json:"imap-target-email,omitempty"`
	// ImapUsername to access the IMAP service
	ImapUsername string `json:"imap-username"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Timeout waiting for certificate validation in Duration format (1h - 1 Hour, 20m - 20 Minutes, 33m3s - 33 Minutes and 3 Seconds), maximum 1h.
	Timeout *string `json:"timeout,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateZeroSSLTarget instantiates a new CreateZeroSSLTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateZeroSSLTarget(apiKey string, imapFqdn string, imapPassword string, imapUsername string, name string, ) *CreateZeroSSLTarget {
	this := CreateZeroSSLTarget{}
	this.ApiKey = apiKey
	this.ImapFqdn = imapFqdn
	this.ImapPassword = imapPassword
	var imapPort string = "993"
	this.ImapPort = &imapPort
	this.ImapUsername = imapUsername
	var json bool = false
	this.Json = &json
	this.Name = name
	var timeout string = "5m"
	this.Timeout = &timeout
	return &this
}

// NewCreateZeroSSLTargetWithDefaults instantiates a new CreateZeroSSLTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateZeroSSLTargetWithDefaults() *CreateZeroSSLTarget {
	this := CreateZeroSSLTarget{}
	var imapPort string = "993"
	this.ImapPort = &imapPort
	var json bool = false
	this.Json = &json
	var timeout string = "5m"
	this.Timeout = &timeout
	return &this
}

// GetApiKey returns the ApiKey field value
func (o *CreateZeroSSLTarget) GetApiKey() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetApiKeyOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ApiKey, true
}

// SetApiKey sets field value
func (o *CreateZeroSSLTarget) SetApiKey(v string) {
	o.ApiKey = v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *CreateZeroSSLTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateZeroSSLTarget) SetDescription(v string) {
	o.Description = &v
}

// GetImapFqdn returns the ImapFqdn field value
func (o *CreateZeroSSLTarget) GetImapFqdn() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ImapFqdn
}

// GetImapFqdnOk returns a tuple with the ImapFqdn field value
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetImapFqdnOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ImapFqdn, true
}

// SetImapFqdn sets field value
func (o *CreateZeroSSLTarget) SetImapFqdn(v string) {
	o.ImapFqdn = v
}

// GetImapPassword returns the ImapPassword field value
func (o *CreateZeroSSLTarget) GetImapPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ImapPassword
}

// GetImapPasswordOk returns a tuple with the ImapPassword field value
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetImapPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ImapPassword, true
}

// SetImapPassword sets field value
func (o *CreateZeroSSLTarget) SetImapPassword(v string) {
	o.ImapPassword = v
}

// GetImapPort returns the ImapPort field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetImapPort() string {
	if o == nil || o.ImapPort == nil {
		var ret string
		return ret
	}
	return *o.ImapPort
}

// GetImapPortOk returns a tuple with the ImapPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetImapPortOk() (*string, bool) {
	if o == nil || o.ImapPort == nil {
		return nil, false
	}
	return o.ImapPort, true
}

// HasImapPort returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasImapPort() bool {
	if o != nil && o.ImapPort != nil {
		return true
	}

	return false
}

// SetImapPort gets a reference to the given string and assigns it to the ImapPort field.
func (o *CreateZeroSSLTarget) SetImapPort(v string) {
	o.ImapPort = &v
}

// GetImapTargetEmail returns the ImapTargetEmail field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetImapTargetEmail() string {
	if o == nil || o.ImapTargetEmail == nil {
		var ret string
		return ret
	}
	return *o.ImapTargetEmail
}

// GetImapTargetEmailOk returns a tuple with the ImapTargetEmail field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetImapTargetEmailOk() (*string, bool) {
	if o == nil || o.ImapTargetEmail == nil {
		return nil, false
	}
	return o.ImapTargetEmail, true
}

// HasImapTargetEmail returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasImapTargetEmail() bool {
	if o != nil && o.ImapTargetEmail != nil {
		return true
	}

	return false
}

// SetImapTargetEmail gets a reference to the given string and assigns it to the ImapTargetEmail field.
func (o *CreateZeroSSLTarget) SetImapTargetEmail(v string) {
	o.ImapTargetEmail = &v
}

// GetImapUsername returns the ImapUsername field value
func (o *CreateZeroSSLTarget) GetImapUsername() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ImapUsername
}

// GetImapUsernameOk returns a tuple with the ImapUsername field value
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetImapUsernameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ImapUsername, true
}

// SetImapUsername sets field value
func (o *CreateZeroSSLTarget) SetImapUsername(v string) {
	o.ImapUsername = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateZeroSSLTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *CreateZeroSSLTarget) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *CreateZeroSSLTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *CreateZeroSSLTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateZeroSSLTarget) SetName(v string) {
	o.Name = v
}

// GetTimeout returns the Timeout field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetTimeout() string {
	if o == nil || o.Timeout == nil {
		var ret string
		return ret
	}
	return *o.Timeout
}

// GetTimeoutOk returns a tuple with the Timeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetTimeoutOk() (*string, bool) {
	if o == nil || o.Timeout == nil {
		return nil, false
	}
	return o.Timeout, true
}

// HasTimeout returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasTimeout() bool {
	if o != nil && o.Timeout != nil {
		return true
	}

	return false
}

// SetTimeout gets a reference to the given string and assigns it to the Timeout field.
func (o *CreateZeroSSLTarget) SetTimeout(v string) {
	o.Timeout = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateZeroSSLTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateZeroSSLTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateZeroSSLTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateZeroSSLTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateZeroSSLTarget) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateZeroSSLTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["api-key"] = o.ApiKey
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["imap-fqdn"] = o.ImapFqdn
	}
	if true {
		toSerialize["imap-password"] = o.ImapPassword
	}
	if o.ImapPort != nil {
		toSerialize["imap-port"] = o.ImapPort
	}
	if o.ImapTargetEmail != nil {
		toSerialize["imap-target-email"] = o.ImapTargetEmail
	}
	if true {
		toSerialize["imap-username"] = o.ImapUsername
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Timeout != nil {
		toSerialize["timeout"] = o.Timeout
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateZeroSSLTarget struct {
	value *CreateZeroSSLTarget
	isSet bool
}

func (v NullableCreateZeroSSLTarget) Get() *CreateZeroSSLTarget {
	return v.value
}

func (v *NullableCreateZeroSSLTarget) Set(val *CreateZeroSSLTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateZeroSSLTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateZeroSSLTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateZeroSSLTarget(val *CreateZeroSSLTarget) *NullableCreateZeroSSLTarget {
	return &NullableCreateZeroSSLTarget{value: val, isSet: true}
}

func (v NullableCreateZeroSSLTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateZeroSSLTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


