/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateSalesforceTarget createSalesforceTarget is a command that creates a new target. [Deprecated: Use target-create-salesforce command]
type CreateSalesforceTarget struct {
	// Base64 encoded PEM of the connected app private key (relevant for JWT auth only)
	AppPrivateKeyData *string `json:"app-private-key-data,omitempty"`
	// type of the auth flow ('jwt' / 'user-password')
	AuthFlow string `json:"auth-flow"`
	// Base64 encoded PEM cert to use when uploading a new key to Salesforce
	CaCertData *string `json:"ca-cert-data,omitempty"`
	// name of the certificate in Salesforce tenant to use when uploading new key
	CaCertName *string `json:"ca-cert-name,omitempty"`
	// Client ID of the oauth2 app to use for connecting to Salesforce
	ClientId string `json:"client-id"`
	// Client secret of the oauth2 app to use for connecting to Salesforce (required for password flow)
	ClientSecret *string `json:"client-secret,omitempty"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// The email of the user attached to the oauth2 app used for connecting to Salesforce
	Email string `json:"email"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// The password of the user attached to the oauth2 app used for connecting to Salesforce (required for user-password flow)
	Password *string `json:"password,omitempty"`
	// The security token of the user attached to the oauth2 app used for connecting to Salesforce  (required for user-password flow)
	SecurityToken *string `json:"security-token,omitempty"`
	// Url of the Salesforce tenant
	TenantUrl string `json:"tenant-url"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateSalesforceTarget instantiates a new CreateSalesforceTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateSalesforceTarget(authFlow string, clientId string, email string, name string, tenantUrl string, ) *CreateSalesforceTarget {
	this := CreateSalesforceTarget{}
	this.AuthFlow = authFlow
	this.ClientId = clientId
	this.Email = email
	var json bool = false
	this.Json = &json
	this.Name = name
	this.TenantUrl = tenantUrl
	return &this
}

// NewCreateSalesforceTargetWithDefaults instantiates a new CreateSalesforceTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateSalesforceTargetWithDefaults() *CreateSalesforceTarget {
	this := CreateSalesforceTarget{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAppPrivateKeyData returns the AppPrivateKeyData field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetAppPrivateKeyData() string {
	if o == nil || o.AppPrivateKeyData == nil {
		var ret string
		return ret
	}
	return *o.AppPrivateKeyData
}

// GetAppPrivateKeyDataOk returns a tuple with the AppPrivateKeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetAppPrivateKeyDataOk() (*string, bool) {
	if o == nil || o.AppPrivateKeyData == nil {
		return nil, false
	}
	return o.AppPrivateKeyData, true
}

// HasAppPrivateKeyData returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasAppPrivateKeyData() bool {
	if o != nil && o.AppPrivateKeyData != nil {
		return true
	}

	return false
}

// SetAppPrivateKeyData gets a reference to the given string and assigns it to the AppPrivateKeyData field.
func (o *CreateSalesforceTarget) SetAppPrivateKeyData(v string) {
	o.AppPrivateKeyData = &v
}

// GetAuthFlow returns the AuthFlow field value
func (o *CreateSalesforceTarget) GetAuthFlow() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AuthFlow
}

// GetAuthFlowOk returns a tuple with the AuthFlow field value
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetAuthFlowOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AuthFlow, true
}

// SetAuthFlow sets field value
func (o *CreateSalesforceTarget) SetAuthFlow(v string) {
	o.AuthFlow = v
}

// GetCaCertData returns the CaCertData field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetCaCertData() string {
	if o == nil || o.CaCertData == nil {
		var ret string
		return ret
	}
	return *o.CaCertData
}

// GetCaCertDataOk returns a tuple with the CaCertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetCaCertDataOk() (*string, bool) {
	if o == nil || o.CaCertData == nil {
		return nil, false
	}
	return o.CaCertData, true
}

// HasCaCertData returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasCaCertData() bool {
	if o != nil && o.CaCertData != nil {
		return true
	}

	return false
}

// SetCaCertData gets a reference to the given string and assigns it to the CaCertData field.
func (o *CreateSalesforceTarget) SetCaCertData(v string) {
	o.CaCertData = &v
}

// GetCaCertName returns the CaCertName field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetCaCertName() string {
	if o == nil || o.CaCertName == nil {
		var ret string
		return ret
	}
	return *o.CaCertName
}

// GetCaCertNameOk returns a tuple with the CaCertName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetCaCertNameOk() (*string, bool) {
	if o == nil || o.CaCertName == nil {
		return nil, false
	}
	return o.CaCertName, true
}

// HasCaCertName returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasCaCertName() bool {
	if o != nil && o.CaCertName != nil {
		return true
	}

	return false
}

// SetCaCertName gets a reference to the given string and assigns it to the CaCertName field.
func (o *CreateSalesforceTarget) SetCaCertName(v string) {
	o.CaCertName = &v
}

// GetClientId returns the ClientId field value
func (o *CreateSalesforceTarget) GetClientId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetClientIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ClientId, true
}

// SetClientId sets field value
func (o *CreateSalesforceTarget) SetClientId(v string) {
	o.ClientId = v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *CreateSalesforceTarget) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *CreateSalesforceTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateSalesforceTarget) SetDescription(v string) {
	o.Description = &v
}

// GetEmail returns the Email field value
func (o *CreateSalesforceTarget) GetEmail() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Email
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetEmailOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Email, true
}

// SetEmail sets field value
func (o *CreateSalesforceTarget) SetEmail(v string) {
	o.Email = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateSalesforceTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *CreateSalesforceTarget) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *CreateSalesforceTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *CreateSalesforceTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateSalesforceTarget) SetName(v string) {
	o.Name = v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *CreateSalesforceTarget) SetPassword(v string) {
	o.Password = &v
}

// GetSecurityToken returns the SecurityToken field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetSecurityToken() string {
	if o == nil || o.SecurityToken == nil {
		var ret string
		return ret
	}
	return *o.SecurityToken
}

// GetSecurityTokenOk returns a tuple with the SecurityToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetSecurityTokenOk() (*string, bool) {
	if o == nil || o.SecurityToken == nil {
		return nil, false
	}
	return o.SecurityToken, true
}

// HasSecurityToken returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasSecurityToken() bool {
	if o != nil && o.SecurityToken != nil {
		return true
	}

	return false
}

// SetSecurityToken gets a reference to the given string and assigns it to the SecurityToken field.
func (o *CreateSalesforceTarget) SetSecurityToken(v string) {
	o.SecurityToken = &v
}

// GetTenantUrl returns the TenantUrl field value
func (o *CreateSalesforceTarget) GetTenantUrl() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.TenantUrl
}

// GetTenantUrlOk returns a tuple with the TenantUrl field value
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetTenantUrlOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.TenantUrl, true
}

// SetTenantUrl sets field value
func (o *CreateSalesforceTarget) SetTenantUrl(v string) {
	o.TenantUrl = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateSalesforceTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateSalesforceTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateSalesforceTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateSalesforceTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateSalesforceTarget) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateSalesforceTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AppPrivateKeyData != nil {
		toSerialize["app-private-key-data"] = o.AppPrivateKeyData
	}
	if true {
		toSerialize["auth-flow"] = o.AuthFlow
	}
	if o.CaCertData != nil {
		toSerialize["ca-cert-data"] = o.CaCertData
	}
	if o.CaCertName != nil {
		toSerialize["ca-cert-name"] = o.CaCertName
	}
	if true {
		toSerialize["client-id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client-secret"] = o.ClientSecret
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["email"] = o.Email
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.SecurityToken != nil {
		toSerialize["security-token"] = o.SecurityToken
	}
	if true {
		toSerialize["tenant-url"] = o.TenantUrl
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateSalesforceTarget struct {
	value *CreateSalesforceTarget
	isSet bool
}

func (v NullableCreateSalesforceTarget) Get() *CreateSalesforceTarget {
	return v.value
}

func (v *NullableCreateSalesforceTarget) Set(val *CreateSalesforceTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateSalesforceTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateSalesforceTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateSalesforceTarget(val *CreateSalesforceTarget) *NullableCreateSalesforceTarget {
	return &NullableCreateSalesforceTarget{value: val, isSet: true}
}

func (v NullableCreateSalesforceTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateSalesforceTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


