/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateEKSTarget createEKSTarget is a command that creates a new target. [Deprecated: Use target-create-eks command]
type CreateEKSTarget struct {
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Access Key ID
	EksAccessKeyId string `json:"eks-access-key-id"`
	// EKS cluster CA certificate
	EksClusterCaCert string `json:"eks-cluster-ca-cert"`
	// EKS cluster URL endpoint
	EksClusterEndpoint string `json:"eks-cluster-endpoint"`
	// EKS cluster name
	EksClusterName string `json:"eks-cluster-name"`
	// Region
	EksRegion *string `json:"eks-region,omitempty"`
	// Secret Access Key
	EksSecretAccessKey string `json:"eks-secret-access-key"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	UseGwCloudIdentity *bool `json:"use-gw-cloud-identity,omitempty"`
}

// NewCreateEKSTarget instantiates a new CreateEKSTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateEKSTarget(eksAccessKeyId string, eksClusterCaCert string, eksClusterEndpoint string, eksClusterName string, eksSecretAccessKey string, name string, ) *CreateEKSTarget {
	this := CreateEKSTarget{}
	this.EksAccessKeyId = eksAccessKeyId
	this.EksClusterCaCert = eksClusterCaCert
	this.EksClusterEndpoint = eksClusterEndpoint
	this.EksClusterName = eksClusterName
	var eksRegion string = "us-east-2"
	this.EksRegion = &eksRegion
	this.EksSecretAccessKey = eksSecretAccessKey
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewCreateEKSTargetWithDefaults instantiates a new CreateEKSTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateEKSTargetWithDefaults() *CreateEKSTarget {
	this := CreateEKSTarget{}
	var eksRegion string = "us-east-2"
	this.EksRegion = &eksRegion
	var json bool = false
	this.Json = &json
	return &this
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *CreateEKSTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateEKSTarget) SetDescription(v string) {
	o.Description = &v
}

// GetEksAccessKeyId returns the EksAccessKeyId field value
func (o *CreateEKSTarget) GetEksAccessKeyId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EksAccessKeyId
}

// GetEksAccessKeyIdOk returns a tuple with the EksAccessKeyId field value
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetEksAccessKeyIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EksAccessKeyId, true
}

// SetEksAccessKeyId sets field value
func (o *CreateEKSTarget) SetEksAccessKeyId(v string) {
	o.EksAccessKeyId = v
}

// GetEksClusterCaCert returns the EksClusterCaCert field value
func (o *CreateEKSTarget) GetEksClusterCaCert() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EksClusterCaCert
}

// GetEksClusterCaCertOk returns a tuple with the EksClusterCaCert field value
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetEksClusterCaCertOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EksClusterCaCert, true
}

// SetEksClusterCaCert sets field value
func (o *CreateEKSTarget) SetEksClusterCaCert(v string) {
	o.EksClusterCaCert = v
}

// GetEksClusterEndpoint returns the EksClusterEndpoint field value
func (o *CreateEKSTarget) GetEksClusterEndpoint() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EksClusterEndpoint
}

// GetEksClusterEndpointOk returns a tuple with the EksClusterEndpoint field value
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetEksClusterEndpointOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EksClusterEndpoint, true
}

// SetEksClusterEndpoint sets field value
func (o *CreateEKSTarget) SetEksClusterEndpoint(v string) {
	o.EksClusterEndpoint = v
}

// GetEksClusterName returns the EksClusterName field value
func (o *CreateEKSTarget) GetEksClusterName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EksClusterName
}

// GetEksClusterNameOk returns a tuple with the EksClusterName field value
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetEksClusterNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EksClusterName, true
}

// SetEksClusterName sets field value
func (o *CreateEKSTarget) SetEksClusterName(v string) {
	o.EksClusterName = v
}

// GetEksRegion returns the EksRegion field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetEksRegion() string {
	if o == nil || o.EksRegion == nil {
		var ret string
		return ret
	}
	return *o.EksRegion
}

// GetEksRegionOk returns a tuple with the EksRegion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetEksRegionOk() (*string, bool) {
	if o == nil || o.EksRegion == nil {
		return nil, false
	}
	return o.EksRegion, true
}

// HasEksRegion returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasEksRegion() bool {
	if o != nil && o.EksRegion != nil {
		return true
	}

	return false
}

// SetEksRegion gets a reference to the given string and assigns it to the EksRegion field.
func (o *CreateEKSTarget) SetEksRegion(v string) {
	o.EksRegion = &v
}

// GetEksSecretAccessKey returns the EksSecretAccessKey field value
func (o *CreateEKSTarget) GetEksSecretAccessKey() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EksSecretAccessKey
}

// GetEksSecretAccessKeyOk returns a tuple with the EksSecretAccessKey field value
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetEksSecretAccessKeyOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EksSecretAccessKey, true
}

// SetEksSecretAccessKey sets field value
func (o *CreateEKSTarget) SetEksSecretAccessKey(v string) {
	o.EksSecretAccessKey = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateEKSTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *CreateEKSTarget) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *CreateEKSTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *CreateEKSTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateEKSTarget) SetName(v string) {
	o.Name = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateEKSTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateEKSTarget) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUseGwCloudIdentity returns the UseGwCloudIdentity field value if set, zero value otherwise.
func (o *CreateEKSTarget) GetUseGwCloudIdentity() bool {
	if o == nil || o.UseGwCloudIdentity == nil {
		var ret bool
		return ret
	}
	return *o.UseGwCloudIdentity
}

// GetUseGwCloudIdentityOk returns a tuple with the UseGwCloudIdentity field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateEKSTarget) GetUseGwCloudIdentityOk() (*bool, bool) {
	if o == nil || o.UseGwCloudIdentity == nil {
		return nil, false
	}
	return o.UseGwCloudIdentity, true
}

// HasUseGwCloudIdentity returns a boolean if a field has been set.
func (o *CreateEKSTarget) HasUseGwCloudIdentity() bool {
	if o != nil && o.UseGwCloudIdentity != nil {
		return true
	}

	return false
}

// SetUseGwCloudIdentity gets a reference to the given bool and assigns it to the UseGwCloudIdentity field.
func (o *CreateEKSTarget) SetUseGwCloudIdentity(v bool) {
	o.UseGwCloudIdentity = &v
}

func (o CreateEKSTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["eks-access-key-id"] = o.EksAccessKeyId
	}
	if true {
		toSerialize["eks-cluster-ca-cert"] = o.EksClusterCaCert
	}
	if true {
		toSerialize["eks-cluster-endpoint"] = o.EksClusterEndpoint
	}
	if true {
		toSerialize["eks-cluster-name"] = o.EksClusterName
	}
	if o.EksRegion != nil {
		toSerialize["eks-region"] = o.EksRegion
	}
	if true {
		toSerialize["eks-secret-access-key"] = o.EksSecretAccessKey
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UseGwCloudIdentity != nil {
		toSerialize["use-gw-cloud-identity"] = o.UseGwCloudIdentity
	}
	return json.Marshal(toSerialize)
}

type NullableCreateEKSTarget struct {
	value *CreateEKSTarget
	isSet bool
}

func (v NullableCreateEKSTarget) Get() *CreateEKSTarget {
	return v.value
}

func (v *NullableCreateEKSTarget) Set(val *CreateEKSTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateEKSTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateEKSTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateEKSTarget(val *CreateEKSTarget) *NullableCreateEKSTarget {
	return &NullableCreateEKSTarget{value: val, isSet: true}
}

func (v NullableCreateEKSTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateEKSTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


