/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ClassicKeyDetailsInfo struct for ClassicKeyDetailsInfo
type ClassicKeyDetailsInfo struct {
	ClassicKeyAttributes *map[string][]string `json:"classic_key_attributes,omitempty"`
	ClassicKeyId *string `json:"classic_key_id,omitempty"`
	CredentialId *string `json:"credential_id,omitempty"`
	GwClusterId *int64 `json:"gw_cluster_id,omitempty"`
	HasCertificate *bool `json:"has_certificate,omitempty"`
	IsProvidedByUser *bool `json:"is_provided_by_user,omitempty"`
	IsUnexportable *bool `json:"is_unexportable,omitempty"`
	// ItemState defines the different states an Item can be in
	KeyState *string `json:"key_state,omitempty"`
	KeyType *string `json:"key_type,omitempty"`
	LastError *string `json:"last_error,omitempty"`
	PublicKey *string `json:"public_key,omitempty"`
	TargetAliasHelper *string `json:"target_alias_helper,omitempty"`
	TargetTypes *[]string `json:"target_types,omitempty"`
	Targets *[]ClassicKeyTargetInfo `json:"targets,omitempty"`
	Username *string `json:"username,omitempty"`
	Websites *[]string `json:"websites,omitempty"`
}

// NewClassicKeyDetailsInfo instantiates a new ClassicKeyDetailsInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewClassicKeyDetailsInfo() *ClassicKeyDetailsInfo {
	this := ClassicKeyDetailsInfo{}
	return &this
}

// NewClassicKeyDetailsInfoWithDefaults instantiates a new ClassicKeyDetailsInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewClassicKeyDetailsInfoWithDefaults() *ClassicKeyDetailsInfo {
	this := ClassicKeyDetailsInfo{}
	return &this
}

// GetClassicKeyAttributes returns the ClassicKeyAttributes field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetClassicKeyAttributes() map[string][]string {
	if o == nil || o.ClassicKeyAttributes == nil {
		var ret map[string][]string
		return ret
	}
	return *o.ClassicKeyAttributes
}

// GetClassicKeyAttributesOk returns a tuple with the ClassicKeyAttributes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetClassicKeyAttributesOk() (*map[string][]string, bool) {
	if o == nil || o.ClassicKeyAttributes == nil {
		return nil, false
	}
	return o.ClassicKeyAttributes, true
}

// HasClassicKeyAttributes returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasClassicKeyAttributes() bool {
	if o != nil && o.ClassicKeyAttributes != nil {
		return true
	}

	return false
}

// SetClassicKeyAttributes gets a reference to the given map[string][]string and assigns it to the ClassicKeyAttributes field.
func (o *ClassicKeyDetailsInfo) SetClassicKeyAttributes(v map[string][]string) {
	o.ClassicKeyAttributes = &v
}

// GetClassicKeyId returns the ClassicKeyId field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetClassicKeyId() string {
	if o == nil || o.ClassicKeyId == nil {
		var ret string
		return ret
	}
	return *o.ClassicKeyId
}

// GetClassicKeyIdOk returns a tuple with the ClassicKeyId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetClassicKeyIdOk() (*string, bool) {
	if o == nil || o.ClassicKeyId == nil {
		return nil, false
	}
	return o.ClassicKeyId, true
}

// HasClassicKeyId returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasClassicKeyId() bool {
	if o != nil && o.ClassicKeyId != nil {
		return true
	}

	return false
}

// SetClassicKeyId gets a reference to the given string and assigns it to the ClassicKeyId field.
func (o *ClassicKeyDetailsInfo) SetClassicKeyId(v string) {
	o.ClassicKeyId = &v
}

// GetCredentialId returns the CredentialId field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetCredentialId() string {
	if o == nil || o.CredentialId == nil {
		var ret string
		return ret
	}
	return *o.CredentialId
}

// GetCredentialIdOk returns a tuple with the CredentialId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetCredentialIdOk() (*string, bool) {
	if o == nil || o.CredentialId == nil {
		return nil, false
	}
	return o.CredentialId, true
}

// HasCredentialId returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasCredentialId() bool {
	if o != nil && o.CredentialId != nil {
		return true
	}

	return false
}

// SetCredentialId gets a reference to the given string and assigns it to the CredentialId field.
func (o *ClassicKeyDetailsInfo) SetCredentialId(v string) {
	o.CredentialId = &v
}

// GetGwClusterId returns the GwClusterId field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetGwClusterId() int64 {
	if o == nil || o.GwClusterId == nil {
		var ret int64
		return ret
	}
	return *o.GwClusterId
}

// GetGwClusterIdOk returns a tuple with the GwClusterId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetGwClusterIdOk() (*int64, bool) {
	if o == nil || o.GwClusterId == nil {
		return nil, false
	}
	return o.GwClusterId, true
}

// HasGwClusterId returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasGwClusterId() bool {
	if o != nil && o.GwClusterId != nil {
		return true
	}

	return false
}

// SetGwClusterId gets a reference to the given int64 and assigns it to the GwClusterId field.
func (o *ClassicKeyDetailsInfo) SetGwClusterId(v int64) {
	o.GwClusterId = &v
}

// GetHasCertificate returns the HasCertificate field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetHasCertificate() bool {
	if o == nil || o.HasCertificate == nil {
		var ret bool
		return ret
	}
	return *o.HasCertificate
}

// GetHasCertificateOk returns a tuple with the HasCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetHasCertificateOk() (*bool, bool) {
	if o == nil || o.HasCertificate == nil {
		return nil, false
	}
	return o.HasCertificate, true
}

// HasHasCertificate returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasHasCertificate() bool {
	if o != nil && o.HasCertificate != nil {
		return true
	}

	return false
}

// SetHasCertificate gets a reference to the given bool and assigns it to the HasCertificate field.
func (o *ClassicKeyDetailsInfo) SetHasCertificate(v bool) {
	o.HasCertificate = &v
}

// GetIsProvidedByUser returns the IsProvidedByUser field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetIsProvidedByUser() bool {
	if o == nil || o.IsProvidedByUser == nil {
		var ret bool
		return ret
	}
	return *o.IsProvidedByUser
}

// GetIsProvidedByUserOk returns a tuple with the IsProvidedByUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetIsProvidedByUserOk() (*bool, bool) {
	if o == nil || o.IsProvidedByUser == nil {
		return nil, false
	}
	return o.IsProvidedByUser, true
}

// HasIsProvidedByUser returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasIsProvidedByUser() bool {
	if o != nil && o.IsProvidedByUser != nil {
		return true
	}

	return false
}

// SetIsProvidedByUser gets a reference to the given bool and assigns it to the IsProvidedByUser field.
func (o *ClassicKeyDetailsInfo) SetIsProvidedByUser(v bool) {
	o.IsProvidedByUser = &v
}

// GetIsUnexportable returns the IsUnexportable field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetIsUnexportable() bool {
	if o == nil || o.IsUnexportable == nil {
		var ret bool
		return ret
	}
	return *o.IsUnexportable
}

// GetIsUnexportableOk returns a tuple with the IsUnexportable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetIsUnexportableOk() (*bool, bool) {
	if o == nil || o.IsUnexportable == nil {
		return nil, false
	}
	return o.IsUnexportable, true
}

// HasIsUnexportable returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasIsUnexportable() bool {
	if o != nil && o.IsUnexportable != nil {
		return true
	}

	return false
}

// SetIsUnexportable gets a reference to the given bool and assigns it to the IsUnexportable field.
func (o *ClassicKeyDetailsInfo) SetIsUnexportable(v bool) {
	o.IsUnexportable = &v
}

// GetKeyState returns the KeyState field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetKeyState() string {
	if o == nil || o.KeyState == nil {
		var ret string
		return ret
	}
	return *o.KeyState
}

// GetKeyStateOk returns a tuple with the KeyState field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetKeyStateOk() (*string, bool) {
	if o == nil || o.KeyState == nil {
		return nil, false
	}
	return o.KeyState, true
}

// HasKeyState returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasKeyState() bool {
	if o != nil && o.KeyState != nil {
		return true
	}

	return false
}

// SetKeyState gets a reference to the given string and assigns it to the KeyState field.
func (o *ClassicKeyDetailsInfo) SetKeyState(v string) {
	o.KeyState = &v
}

// GetKeyType returns the KeyType field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetKeyType() string {
	if o == nil || o.KeyType == nil {
		var ret string
		return ret
	}
	return *o.KeyType
}

// GetKeyTypeOk returns a tuple with the KeyType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetKeyTypeOk() (*string, bool) {
	if o == nil || o.KeyType == nil {
		return nil, false
	}
	return o.KeyType, true
}

// HasKeyType returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasKeyType() bool {
	if o != nil && o.KeyType != nil {
		return true
	}

	return false
}

// SetKeyType gets a reference to the given string and assigns it to the KeyType field.
func (o *ClassicKeyDetailsInfo) SetKeyType(v string) {
	o.KeyType = &v
}

// GetLastError returns the LastError field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetLastError() string {
	if o == nil || o.LastError == nil {
		var ret string
		return ret
	}
	return *o.LastError
}

// GetLastErrorOk returns a tuple with the LastError field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetLastErrorOk() (*string, bool) {
	if o == nil || o.LastError == nil {
		return nil, false
	}
	return o.LastError, true
}

// HasLastError returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasLastError() bool {
	if o != nil && o.LastError != nil {
		return true
	}

	return false
}

// SetLastError gets a reference to the given string and assigns it to the LastError field.
func (o *ClassicKeyDetailsInfo) SetLastError(v string) {
	o.LastError = &v
}

// GetPublicKey returns the PublicKey field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetPublicKey() string {
	if o == nil || o.PublicKey == nil {
		var ret string
		return ret
	}
	return *o.PublicKey
}

// GetPublicKeyOk returns a tuple with the PublicKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetPublicKeyOk() (*string, bool) {
	if o == nil || o.PublicKey == nil {
		return nil, false
	}
	return o.PublicKey, true
}

// HasPublicKey returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasPublicKey() bool {
	if o != nil && o.PublicKey != nil {
		return true
	}

	return false
}

// SetPublicKey gets a reference to the given string and assigns it to the PublicKey field.
func (o *ClassicKeyDetailsInfo) SetPublicKey(v string) {
	o.PublicKey = &v
}

// GetTargetAliasHelper returns the TargetAliasHelper field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetTargetAliasHelper() string {
	if o == nil || o.TargetAliasHelper == nil {
		var ret string
		return ret
	}
	return *o.TargetAliasHelper
}

// GetTargetAliasHelperOk returns a tuple with the TargetAliasHelper field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetTargetAliasHelperOk() (*string, bool) {
	if o == nil || o.TargetAliasHelper == nil {
		return nil, false
	}
	return o.TargetAliasHelper, true
}

// HasTargetAliasHelper returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasTargetAliasHelper() bool {
	if o != nil && o.TargetAliasHelper != nil {
		return true
	}

	return false
}

// SetTargetAliasHelper gets a reference to the given string and assigns it to the TargetAliasHelper field.
func (o *ClassicKeyDetailsInfo) SetTargetAliasHelper(v string) {
	o.TargetAliasHelper = &v
}

// GetTargetTypes returns the TargetTypes field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetTargetTypes() []string {
	if o == nil || o.TargetTypes == nil {
		var ret []string
		return ret
	}
	return *o.TargetTypes
}

// GetTargetTypesOk returns a tuple with the TargetTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetTargetTypesOk() (*[]string, bool) {
	if o == nil || o.TargetTypes == nil {
		return nil, false
	}
	return o.TargetTypes, true
}

// HasTargetTypes returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasTargetTypes() bool {
	if o != nil && o.TargetTypes != nil {
		return true
	}

	return false
}

// SetTargetTypes gets a reference to the given []string and assigns it to the TargetTypes field.
func (o *ClassicKeyDetailsInfo) SetTargetTypes(v []string) {
	o.TargetTypes = &v
}

// GetTargets returns the Targets field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetTargets() []ClassicKeyTargetInfo {
	if o == nil || o.Targets == nil {
		var ret []ClassicKeyTargetInfo
		return ret
	}
	return *o.Targets
}

// GetTargetsOk returns a tuple with the Targets field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetTargetsOk() (*[]ClassicKeyTargetInfo, bool) {
	if o == nil || o.Targets == nil {
		return nil, false
	}
	return o.Targets, true
}

// HasTargets returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasTargets() bool {
	if o != nil && o.Targets != nil {
		return true
	}

	return false
}

// SetTargets gets a reference to the given []ClassicKeyTargetInfo and assigns it to the Targets field.
func (o *ClassicKeyDetailsInfo) SetTargets(v []ClassicKeyTargetInfo) {
	o.Targets = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetUsername() string {
	if o == nil || o.Username == nil {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetUsernameOk() (*string, bool) {
	if o == nil || o.Username == nil {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasUsername() bool {
	if o != nil && o.Username != nil {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *ClassicKeyDetailsInfo) SetUsername(v string) {
	o.Username = &v
}

// GetWebsites returns the Websites field value if set, zero value otherwise.
func (o *ClassicKeyDetailsInfo) GetWebsites() []string {
	if o == nil || o.Websites == nil {
		var ret []string
		return ret
	}
	return *o.Websites
}

// GetWebsitesOk returns a tuple with the Websites field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ClassicKeyDetailsInfo) GetWebsitesOk() (*[]string, bool) {
	if o == nil || o.Websites == nil {
		return nil, false
	}
	return o.Websites, true
}

// HasWebsites returns a boolean if a field has been set.
func (o *ClassicKeyDetailsInfo) HasWebsites() bool {
	if o != nil && o.Websites != nil {
		return true
	}

	return false
}

// SetWebsites gets a reference to the given []string and assigns it to the Websites field.
func (o *ClassicKeyDetailsInfo) SetWebsites(v []string) {
	o.Websites = &v
}

func (o ClassicKeyDetailsInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ClassicKeyAttributes != nil {
		toSerialize["classic_key_attributes"] = o.ClassicKeyAttributes
	}
	if o.ClassicKeyId != nil {
		toSerialize["classic_key_id"] = o.ClassicKeyId
	}
	if o.CredentialId != nil {
		toSerialize["credential_id"] = o.CredentialId
	}
	if o.GwClusterId != nil {
		toSerialize["gw_cluster_id"] = o.GwClusterId
	}
	if o.HasCertificate != nil {
		toSerialize["has_certificate"] = o.HasCertificate
	}
	if o.IsProvidedByUser != nil {
		toSerialize["is_provided_by_user"] = o.IsProvidedByUser
	}
	if o.IsUnexportable != nil {
		toSerialize["is_unexportable"] = o.IsUnexportable
	}
	if o.KeyState != nil {
		toSerialize["key_state"] = o.KeyState
	}
	if o.KeyType != nil {
		toSerialize["key_type"] = o.KeyType
	}
	if o.LastError != nil {
		toSerialize["last_error"] = o.LastError
	}
	if o.PublicKey != nil {
		toSerialize["public_key"] = o.PublicKey
	}
	if o.TargetAliasHelper != nil {
		toSerialize["target_alias_helper"] = o.TargetAliasHelper
	}
	if o.TargetTypes != nil {
		toSerialize["target_types"] = o.TargetTypes
	}
	if o.Targets != nil {
		toSerialize["targets"] = o.Targets
	}
	if o.Username != nil {
		toSerialize["username"] = o.Username
	}
	if o.Websites != nil {
		toSerialize["websites"] = o.Websites
	}
	return json.Marshal(toSerialize)
}

type NullableClassicKeyDetailsInfo struct {
	value *ClassicKeyDetailsInfo
	isSet bool
}

func (v NullableClassicKeyDetailsInfo) Get() *ClassicKeyDetailsInfo {
	return v.value
}

func (v *NullableClassicKeyDetailsInfo) Set(val *ClassicKeyDetailsInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableClassicKeyDetailsInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableClassicKeyDetailsInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableClassicKeyDetailsInfo(val *ClassicKeyDetailsInfo) *NullableClassicKeyDetailsInfo {
	return &NullableClassicKeyDetailsInfo{value: val, isSet: true}
}

func (v NullableClassicKeyDetailsInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableClassicKeyDetailsInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


