/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// ActiveDirectoryPayload struct for ActiveDirectoryPayload
type ActiveDirectoryPayload struct {
	ActiveDirectoryTargetId *int64 `json:"active_directory_target_id,omitempty"`
	AutoRotate *bool `json:"auto_rotate,omitempty"`
	AutoRotateIntervalInDays *int32 `json:"auto_rotate_interval_in_days,omitempty"`
	AutoRotateRotationHour *int32 `json:"auto_rotate_rotation_hour,omitempty"`
	ComputerBaseDn *string `json:"computer_base_dn,omitempty"`
	// Deprecated
	DiscoverLocalUsers *bool `json:"discover_local_users,omitempty"`
	DiscoverServices *bool `json:"discover_services,omitempty"`
	DiscoveryTypes *[]string `json:"discovery_types,omitempty"`
	DomainName *string `json:"domain_name,omitempty"`
	DomainServerTargetsPathTemplate *string `json:"domain_server_targets_path_template,omitempty"`
	DomainUsersRotatedSecretsPathTemplate *string `json:"domain_users_rotated_secrets_path_template,omitempty"`
	EnableRdpSra *bool `json:"enable_rdp_sra,omitempty"`
	LocalUsersIgnoreList *map[string]bool `json:"local_users_ignore_list,omitempty"`
	LocalUsersRotatedSecretsPathTemplate *string `json:"local_users_rotated_secrets_path_template,omitempty"`
	OsFilter *string `json:"os_filter,omitempty"`
	SshPort *string `json:"ssh_port,omitempty"`
	TargetFormat *string `json:"target_format,omitempty"`
	TargetsType *string `json:"targets_type,omitempty"`
	UserBaseDn *string `json:"user_base_dn,omitempty"`
	UserGroups *[]string `json:"user_groups,omitempty"`
	WinrmOverHttp *bool `json:"winrm_over_http,omitempty"`
	WinrmPort *string `json:"winrm_port,omitempty"`
}

// NewActiveDirectoryPayload instantiates a new ActiveDirectoryPayload object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewActiveDirectoryPayload() *ActiveDirectoryPayload {
	this := ActiveDirectoryPayload{}
	return &this
}

// NewActiveDirectoryPayloadWithDefaults instantiates a new ActiveDirectoryPayload object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewActiveDirectoryPayloadWithDefaults() *ActiveDirectoryPayload {
	this := ActiveDirectoryPayload{}
	return &this
}

// GetActiveDirectoryTargetId returns the ActiveDirectoryTargetId field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetActiveDirectoryTargetId() int64 {
	if o == nil || o.ActiveDirectoryTargetId == nil {
		var ret int64
		return ret
	}
	return *o.ActiveDirectoryTargetId
}

// GetActiveDirectoryTargetIdOk returns a tuple with the ActiveDirectoryTargetId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetActiveDirectoryTargetIdOk() (*int64, bool) {
	if o == nil || o.ActiveDirectoryTargetId == nil {
		return nil, false
	}
	return o.ActiveDirectoryTargetId, true
}

// HasActiveDirectoryTargetId returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasActiveDirectoryTargetId() bool {
	if o != nil && o.ActiveDirectoryTargetId != nil {
		return true
	}

	return false
}

// SetActiveDirectoryTargetId gets a reference to the given int64 and assigns it to the ActiveDirectoryTargetId field.
func (o *ActiveDirectoryPayload) SetActiveDirectoryTargetId(v int64) {
	o.ActiveDirectoryTargetId = &v
}

// GetAutoRotate returns the AutoRotate field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetAutoRotate() bool {
	if o == nil || o.AutoRotate == nil {
		var ret bool
		return ret
	}
	return *o.AutoRotate
}

// GetAutoRotateOk returns a tuple with the AutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetAutoRotateOk() (*bool, bool) {
	if o == nil || o.AutoRotate == nil {
		return nil, false
	}
	return o.AutoRotate, true
}

// HasAutoRotate returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasAutoRotate() bool {
	if o != nil && o.AutoRotate != nil {
		return true
	}

	return false
}

// SetAutoRotate gets a reference to the given bool and assigns it to the AutoRotate field.
func (o *ActiveDirectoryPayload) SetAutoRotate(v bool) {
	o.AutoRotate = &v
}

// GetAutoRotateIntervalInDays returns the AutoRotateIntervalInDays field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetAutoRotateIntervalInDays() int32 {
	if o == nil || o.AutoRotateIntervalInDays == nil {
		var ret int32
		return ret
	}
	return *o.AutoRotateIntervalInDays
}

// GetAutoRotateIntervalInDaysOk returns a tuple with the AutoRotateIntervalInDays field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetAutoRotateIntervalInDaysOk() (*int32, bool) {
	if o == nil || o.AutoRotateIntervalInDays == nil {
		return nil, false
	}
	return o.AutoRotateIntervalInDays, true
}

// HasAutoRotateIntervalInDays returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasAutoRotateIntervalInDays() bool {
	if o != nil && o.AutoRotateIntervalInDays != nil {
		return true
	}

	return false
}

// SetAutoRotateIntervalInDays gets a reference to the given int32 and assigns it to the AutoRotateIntervalInDays field.
func (o *ActiveDirectoryPayload) SetAutoRotateIntervalInDays(v int32) {
	o.AutoRotateIntervalInDays = &v
}

// GetAutoRotateRotationHour returns the AutoRotateRotationHour field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetAutoRotateRotationHour() int32 {
	if o == nil || o.AutoRotateRotationHour == nil {
		var ret int32
		return ret
	}
	return *o.AutoRotateRotationHour
}

// GetAutoRotateRotationHourOk returns a tuple with the AutoRotateRotationHour field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetAutoRotateRotationHourOk() (*int32, bool) {
	if o == nil || o.AutoRotateRotationHour == nil {
		return nil, false
	}
	return o.AutoRotateRotationHour, true
}

// HasAutoRotateRotationHour returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasAutoRotateRotationHour() bool {
	if o != nil && o.AutoRotateRotationHour != nil {
		return true
	}

	return false
}

// SetAutoRotateRotationHour gets a reference to the given int32 and assigns it to the AutoRotateRotationHour field.
func (o *ActiveDirectoryPayload) SetAutoRotateRotationHour(v int32) {
	o.AutoRotateRotationHour = &v
}

// GetComputerBaseDn returns the ComputerBaseDn field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetComputerBaseDn() string {
	if o == nil || o.ComputerBaseDn == nil {
		var ret string
		return ret
	}
	return *o.ComputerBaseDn
}

// GetComputerBaseDnOk returns a tuple with the ComputerBaseDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetComputerBaseDnOk() (*string, bool) {
	if o == nil || o.ComputerBaseDn == nil {
		return nil, false
	}
	return o.ComputerBaseDn, true
}

// HasComputerBaseDn returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasComputerBaseDn() bool {
	if o != nil && o.ComputerBaseDn != nil {
		return true
	}

	return false
}

// SetComputerBaseDn gets a reference to the given string and assigns it to the ComputerBaseDn field.
func (o *ActiveDirectoryPayload) SetComputerBaseDn(v string) {
	o.ComputerBaseDn = &v
}

// GetDiscoverLocalUsers returns the DiscoverLocalUsers field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetDiscoverLocalUsers() bool {
	if o == nil || o.DiscoverLocalUsers == nil {
		var ret bool
		return ret
	}
	return *o.DiscoverLocalUsers
}

// GetDiscoverLocalUsersOk returns a tuple with the DiscoverLocalUsers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetDiscoverLocalUsersOk() (*bool, bool) {
	if o == nil || o.DiscoverLocalUsers == nil {
		return nil, false
	}
	return o.DiscoverLocalUsers, true
}

// HasDiscoverLocalUsers returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasDiscoverLocalUsers() bool {
	if o != nil && o.DiscoverLocalUsers != nil {
		return true
	}

	return false
}

// SetDiscoverLocalUsers gets a reference to the given bool and assigns it to the DiscoverLocalUsers field.
func (o *ActiveDirectoryPayload) SetDiscoverLocalUsers(v bool) {
	o.DiscoverLocalUsers = &v
}

// GetDiscoverServices returns the DiscoverServices field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetDiscoverServices() bool {
	if o == nil || o.DiscoverServices == nil {
		var ret bool
		return ret
	}
	return *o.DiscoverServices
}

// GetDiscoverServicesOk returns a tuple with the DiscoverServices field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetDiscoverServicesOk() (*bool, bool) {
	if o == nil || o.DiscoverServices == nil {
		return nil, false
	}
	return o.DiscoverServices, true
}

// HasDiscoverServices returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasDiscoverServices() bool {
	if o != nil && o.DiscoverServices != nil {
		return true
	}

	return false
}

// SetDiscoverServices gets a reference to the given bool and assigns it to the DiscoverServices field.
func (o *ActiveDirectoryPayload) SetDiscoverServices(v bool) {
	o.DiscoverServices = &v
}

// GetDiscoveryTypes returns the DiscoveryTypes field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetDiscoveryTypes() []string {
	if o == nil || o.DiscoveryTypes == nil {
		var ret []string
		return ret
	}
	return *o.DiscoveryTypes
}

// GetDiscoveryTypesOk returns a tuple with the DiscoveryTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetDiscoveryTypesOk() (*[]string, bool) {
	if o == nil || o.DiscoveryTypes == nil {
		return nil, false
	}
	return o.DiscoveryTypes, true
}

// HasDiscoveryTypes returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasDiscoveryTypes() bool {
	if o != nil && o.DiscoveryTypes != nil {
		return true
	}

	return false
}

// SetDiscoveryTypes gets a reference to the given []string and assigns it to the DiscoveryTypes field.
func (o *ActiveDirectoryPayload) SetDiscoveryTypes(v []string) {
	o.DiscoveryTypes = &v
}

// GetDomainName returns the DomainName field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetDomainName() string {
	if o == nil || o.DomainName == nil {
		var ret string
		return ret
	}
	return *o.DomainName
}

// GetDomainNameOk returns a tuple with the DomainName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetDomainNameOk() (*string, bool) {
	if o == nil || o.DomainName == nil {
		return nil, false
	}
	return o.DomainName, true
}

// HasDomainName returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasDomainName() bool {
	if o != nil && o.DomainName != nil {
		return true
	}

	return false
}

// SetDomainName gets a reference to the given string and assigns it to the DomainName field.
func (o *ActiveDirectoryPayload) SetDomainName(v string) {
	o.DomainName = &v
}

// GetDomainServerTargetsPathTemplate returns the DomainServerTargetsPathTemplate field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetDomainServerTargetsPathTemplate() string {
	if o == nil || o.DomainServerTargetsPathTemplate == nil {
		var ret string
		return ret
	}
	return *o.DomainServerTargetsPathTemplate
}

// GetDomainServerTargetsPathTemplateOk returns a tuple with the DomainServerTargetsPathTemplate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetDomainServerTargetsPathTemplateOk() (*string, bool) {
	if o == nil || o.DomainServerTargetsPathTemplate == nil {
		return nil, false
	}
	return o.DomainServerTargetsPathTemplate, true
}

// HasDomainServerTargetsPathTemplate returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasDomainServerTargetsPathTemplate() bool {
	if o != nil && o.DomainServerTargetsPathTemplate != nil {
		return true
	}

	return false
}

// SetDomainServerTargetsPathTemplate gets a reference to the given string and assigns it to the DomainServerTargetsPathTemplate field.
func (o *ActiveDirectoryPayload) SetDomainServerTargetsPathTemplate(v string) {
	o.DomainServerTargetsPathTemplate = &v
}

// GetDomainUsersRotatedSecretsPathTemplate returns the DomainUsersRotatedSecretsPathTemplate field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetDomainUsersRotatedSecretsPathTemplate() string {
	if o == nil || o.DomainUsersRotatedSecretsPathTemplate == nil {
		var ret string
		return ret
	}
	return *o.DomainUsersRotatedSecretsPathTemplate
}

// GetDomainUsersRotatedSecretsPathTemplateOk returns a tuple with the DomainUsersRotatedSecretsPathTemplate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetDomainUsersRotatedSecretsPathTemplateOk() (*string, bool) {
	if o == nil || o.DomainUsersRotatedSecretsPathTemplate == nil {
		return nil, false
	}
	return o.DomainUsersRotatedSecretsPathTemplate, true
}

// HasDomainUsersRotatedSecretsPathTemplate returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasDomainUsersRotatedSecretsPathTemplate() bool {
	if o != nil && o.DomainUsersRotatedSecretsPathTemplate != nil {
		return true
	}

	return false
}

// SetDomainUsersRotatedSecretsPathTemplate gets a reference to the given string and assigns it to the DomainUsersRotatedSecretsPathTemplate field.
func (o *ActiveDirectoryPayload) SetDomainUsersRotatedSecretsPathTemplate(v string) {
	o.DomainUsersRotatedSecretsPathTemplate = &v
}

// GetEnableRdpSra returns the EnableRdpSra field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetEnableRdpSra() bool {
	if o == nil || o.EnableRdpSra == nil {
		var ret bool
		return ret
	}
	return *o.EnableRdpSra
}

// GetEnableRdpSraOk returns a tuple with the EnableRdpSra field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetEnableRdpSraOk() (*bool, bool) {
	if o == nil || o.EnableRdpSra == nil {
		return nil, false
	}
	return o.EnableRdpSra, true
}

// HasEnableRdpSra returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasEnableRdpSra() bool {
	if o != nil && o.EnableRdpSra != nil {
		return true
	}

	return false
}

// SetEnableRdpSra gets a reference to the given bool and assigns it to the EnableRdpSra field.
func (o *ActiveDirectoryPayload) SetEnableRdpSra(v bool) {
	o.EnableRdpSra = &v
}

// GetLocalUsersIgnoreList returns the LocalUsersIgnoreList field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetLocalUsersIgnoreList() map[string]bool {
	if o == nil || o.LocalUsersIgnoreList == nil {
		var ret map[string]bool
		return ret
	}
	return *o.LocalUsersIgnoreList
}

// GetLocalUsersIgnoreListOk returns a tuple with the LocalUsersIgnoreList field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetLocalUsersIgnoreListOk() (*map[string]bool, bool) {
	if o == nil || o.LocalUsersIgnoreList == nil {
		return nil, false
	}
	return o.LocalUsersIgnoreList, true
}

// HasLocalUsersIgnoreList returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasLocalUsersIgnoreList() bool {
	if o != nil && o.LocalUsersIgnoreList != nil {
		return true
	}

	return false
}

// SetLocalUsersIgnoreList gets a reference to the given map[string]bool and assigns it to the LocalUsersIgnoreList field.
func (o *ActiveDirectoryPayload) SetLocalUsersIgnoreList(v map[string]bool) {
	o.LocalUsersIgnoreList = &v
}

// GetLocalUsersRotatedSecretsPathTemplate returns the LocalUsersRotatedSecretsPathTemplate field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetLocalUsersRotatedSecretsPathTemplate() string {
	if o == nil || o.LocalUsersRotatedSecretsPathTemplate == nil {
		var ret string
		return ret
	}
	return *o.LocalUsersRotatedSecretsPathTemplate
}

// GetLocalUsersRotatedSecretsPathTemplateOk returns a tuple with the LocalUsersRotatedSecretsPathTemplate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetLocalUsersRotatedSecretsPathTemplateOk() (*string, bool) {
	if o == nil || o.LocalUsersRotatedSecretsPathTemplate == nil {
		return nil, false
	}
	return o.LocalUsersRotatedSecretsPathTemplate, true
}

// HasLocalUsersRotatedSecretsPathTemplate returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasLocalUsersRotatedSecretsPathTemplate() bool {
	if o != nil && o.LocalUsersRotatedSecretsPathTemplate != nil {
		return true
	}

	return false
}

// SetLocalUsersRotatedSecretsPathTemplate gets a reference to the given string and assigns it to the LocalUsersRotatedSecretsPathTemplate field.
func (o *ActiveDirectoryPayload) SetLocalUsersRotatedSecretsPathTemplate(v string) {
	o.LocalUsersRotatedSecretsPathTemplate = &v
}

// GetOsFilter returns the OsFilter field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetOsFilter() string {
	if o == nil || o.OsFilter == nil {
		var ret string
		return ret
	}
	return *o.OsFilter
}

// GetOsFilterOk returns a tuple with the OsFilter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetOsFilterOk() (*string, bool) {
	if o == nil || o.OsFilter == nil {
		return nil, false
	}
	return o.OsFilter, true
}

// HasOsFilter returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasOsFilter() bool {
	if o != nil && o.OsFilter != nil {
		return true
	}

	return false
}

// SetOsFilter gets a reference to the given string and assigns it to the OsFilter field.
func (o *ActiveDirectoryPayload) SetOsFilter(v string) {
	o.OsFilter = &v
}

// GetSshPort returns the SshPort field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetSshPort() string {
	if o == nil || o.SshPort == nil {
		var ret string
		return ret
	}
	return *o.SshPort
}

// GetSshPortOk returns a tuple with the SshPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetSshPortOk() (*string, bool) {
	if o == nil || o.SshPort == nil {
		return nil, false
	}
	return o.SshPort, true
}

// HasSshPort returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasSshPort() bool {
	if o != nil && o.SshPort != nil {
		return true
	}

	return false
}

// SetSshPort gets a reference to the given string and assigns it to the SshPort field.
func (o *ActiveDirectoryPayload) SetSshPort(v string) {
	o.SshPort = &v
}

// GetTargetFormat returns the TargetFormat field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetTargetFormat() string {
	if o == nil || o.TargetFormat == nil {
		var ret string
		return ret
	}
	return *o.TargetFormat
}

// GetTargetFormatOk returns a tuple with the TargetFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetTargetFormatOk() (*string, bool) {
	if o == nil || o.TargetFormat == nil {
		return nil, false
	}
	return o.TargetFormat, true
}

// HasTargetFormat returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasTargetFormat() bool {
	if o != nil && o.TargetFormat != nil {
		return true
	}

	return false
}

// SetTargetFormat gets a reference to the given string and assigns it to the TargetFormat field.
func (o *ActiveDirectoryPayload) SetTargetFormat(v string) {
	o.TargetFormat = &v
}

// GetTargetsType returns the TargetsType field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetTargetsType() string {
	if o == nil || o.TargetsType == nil {
		var ret string
		return ret
	}
	return *o.TargetsType
}

// GetTargetsTypeOk returns a tuple with the TargetsType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetTargetsTypeOk() (*string, bool) {
	if o == nil || o.TargetsType == nil {
		return nil, false
	}
	return o.TargetsType, true
}

// HasTargetsType returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasTargetsType() bool {
	if o != nil && o.TargetsType != nil {
		return true
	}

	return false
}

// SetTargetsType gets a reference to the given string and assigns it to the TargetsType field.
func (o *ActiveDirectoryPayload) SetTargetsType(v string) {
	o.TargetsType = &v
}

// GetUserBaseDn returns the UserBaseDn field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetUserBaseDn() string {
	if o == nil || o.UserBaseDn == nil {
		var ret string
		return ret
	}
	return *o.UserBaseDn
}

// GetUserBaseDnOk returns a tuple with the UserBaseDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetUserBaseDnOk() (*string, bool) {
	if o == nil || o.UserBaseDn == nil {
		return nil, false
	}
	return o.UserBaseDn, true
}

// HasUserBaseDn returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasUserBaseDn() bool {
	if o != nil && o.UserBaseDn != nil {
		return true
	}

	return false
}

// SetUserBaseDn gets a reference to the given string and assigns it to the UserBaseDn field.
func (o *ActiveDirectoryPayload) SetUserBaseDn(v string) {
	o.UserBaseDn = &v
}

// GetUserGroups returns the UserGroups field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetUserGroups() []string {
	if o == nil || o.UserGroups == nil {
		var ret []string
		return ret
	}
	return *o.UserGroups
}

// GetUserGroupsOk returns a tuple with the UserGroups field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetUserGroupsOk() (*[]string, bool) {
	if o == nil || o.UserGroups == nil {
		return nil, false
	}
	return o.UserGroups, true
}

// HasUserGroups returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasUserGroups() bool {
	if o != nil && o.UserGroups != nil {
		return true
	}

	return false
}

// SetUserGroups gets a reference to the given []string and assigns it to the UserGroups field.
func (o *ActiveDirectoryPayload) SetUserGroups(v []string) {
	o.UserGroups = &v
}

// GetWinrmOverHttp returns the WinrmOverHttp field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetWinrmOverHttp() bool {
	if o == nil || o.WinrmOverHttp == nil {
		var ret bool
		return ret
	}
	return *o.WinrmOverHttp
}

// GetWinrmOverHttpOk returns a tuple with the WinrmOverHttp field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetWinrmOverHttpOk() (*bool, bool) {
	if o == nil || o.WinrmOverHttp == nil {
		return nil, false
	}
	return o.WinrmOverHttp, true
}

// HasWinrmOverHttp returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasWinrmOverHttp() bool {
	if o != nil && o.WinrmOverHttp != nil {
		return true
	}

	return false
}

// SetWinrmOverHttp gets a reference to the given bool and assigns it to the WinrmOverHttp field.
func (o *ActiveDirectoryPayload) SetWinrmOverHttp(v bool) {
	o.WinrmOverHttp = &v
}

// GetWinrmPort returns the WinrmPort field value if set, zero value otherwise.
func (o *ActiveDirectoryPayload) GetWinrmPort() string {
	if o == nil || o.WinrmPort == nil {
		var ret string
		return ret
	}
	return *o.WinrmPort
}

// GetWinrmPortOk returns a tuple with the WinrmPort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ActiveDirectoryPayload) GetWinrmPortOk() (*string, bool) {
	if o == nil || o.WinrmPort == nil {
		return nil, false
	}
	return o.WinrmPort, true
}

// HasWinrmPort returns a boolean if a field has been set.
func (o *ActiveDirectoryPayload) HasWinrmPort() bool {
	if o != nil && o.WinrmPort != nil {
		return true
	}

	return false
}

// SetWinrmPort gets a reference to the given string and assigns it to the WinrmPort field.
func (o *ActiveDirectoryPayload) SetWinrmPort(v string) {
	o.WinrmPort = &v
}

func (o ActiveDirectoryPayload) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ActiveDirectoryTargetId != nil {
		toSerialize["active_directory_target_id"] = o.ActiveDirectoryTargetId
	}
	if o.AutoRotate != nil {
		toSerialize["auto_rotate"] = o.AutoRotate
	}
	if o.AutoRotateIntervalInDays != nil {
		toSerialize["auto_rotate_interval_in_days"] = o.AutoRotateIntervalInDays
	}
	if o.AutoRotateRotationHour != nil {
		toSerialize["auto_rotate_rotation_hour"] = o.AutoRotateRotationHour
	}
	if o.ComputerBaseDn != nil {
		toSerialize["computer_base_dn"] = o.ComputerBaseDn
	}
	if o.DiscoverLocalUsers != nil {
		toSerialize["discover_local_users"] = o.DiscoverLocalUsers
	}
	if o.DiscoverServices != nil {
		toSerialize["discover_services"] = o.DiscoverServices
	}
	if o.DiscoveryTypes != nil {
		toSerialize["discovery_types"] = o.DiscoveryTypes
	}
	if o.DomainName != nil {
		toSerialize["domain_name"] = o.DomainName
	}
	if o.DomainServerTargetsPathTemplate != nil {
		toSerialize["domain_server_targets_path_template"] = o.DomainServerTargetsPathTemplate
	}
	if o.DomainUsersRotatedSecretsPathTemplate != nil {
		toSerialize["domain_users_rotated_secrets_path_template"] = o.DomainUsersRotatedSecretsPathTemplate
	}
	if o.EnableRdpSra != nil {
		toSerialize["enable_rdp_sra"] = o.EnableRdpSra
	}
	if o.LocalUsersIgnoreList != nil {
		toSerialize["local_users_ignore_list"] = o.LocalUsersIgnoreList
	}
	if o.LocalUsersRotatedSecretsPathTemplate != nil {
		toSerialize["local_users_rotated_secrets_path_template"] = o.LocalUsersRotatedSecretsPathTemplate
	}
	if o.OsFilter != nil {
		toSerialize["os_filter"] = o.OsFilter
	}
	if o.SshPort != nil {
		toSerialize["ssh_port"] = o.SshPort
	}
	if o.TargetFormat != nil {
		toSerialize["target_format"] = o.TargetFormat
	}
	if o.TargetsType != nil {
		toSerialize["targets_type"] = o.TargetsType
	}
	if o.UserBaseDn != nil {
		toSerialize["user_base_dn"] = o.UserBaseDn
	}
	if o.UserGroups != nil {
		toSerialize["user_groups"] = o.UserGroups
	}
	if o.WinrmOverHttp != nil {
		toSerialize["winrm_over_http"] = o.WinrmOverHttp
	}
	if o.WinrmPort != nil {
		toSerialize["winrm_port"] = o.WinrmPort
	}
	return json.Marshal(toSerialize)
}

type NullableActiveDirectoryPayload struct {
	value *ActiveDirectoryPayload
	isSet bool
}

func (v NullableActiveDirectoryPayload) Get() *ActiveDirectoryPayload {
	return v.value
}

func (v *NullableActiveDirectoryPayload) Set(val *ActiveDirectoryPayload) {
	v.value = val
	v.isSet = true
}

func (v NullableActiveDirectoryPayload) IsSet() bool {
	return v.isSet
}

func (v *NullableActiveDirectoryPayload) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableActiveDirectoryPayload(val *ActiveDirectoryPayload) *NullableActiveDirectoryPayload {
	return &NullableActiveDirectoryPayload{value: val, isSet: true}
}

func (v NullableActiveDirectoryPayload) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableActiveDirectoryPayload) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


