/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AcmeAccount AcmeAccount is copied without the jwk as it seems like it has issues with sdk
type AcmeAccount struct {
	// AccountId is the ACME account id, not Akeyless account id
	AccountId *string `json:"account_id,omitempty"`
	KeyDigest *string `json:"key_digest,omitempty"`
	Status *string `json:"status,omitempty"`
}

// NewAcmeAccount instantiates a new AcmeAccount object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAcmeAccount() *AcmeAccount {
	this := AcmeAccount{}
	return &this
}

// NewAcmeAccountWithDefaults instantiates a new AcmeAccount object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAcmeAccountWithDefaults() *AcmeAccount {
	this := AcmeAccount{}
	return &this
}

// GetAccountId returns the AccountId field value if set, zero value otherwise.
func (o *AcmeAccount) GetAccountId() string {
	if o == nil || o.AccountId == nil {
		var ret string
		return ret
	}
	return *o.AccountId
}

// GetAccountIdOk returns a tuple with the AccountId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AcmeAccount) GetAccountIdOk() (*string, bool) {
	if o == nil || o.AccountId == nil {
		return nil, false
	}
	return o.AccountId, true
}

// HasAccountId returns a boolean if a field has been set.
func (o *AcmeAccount) HasAccountId() bool {
	if o != nil && o.AccountId != nil {
		return true
	}

	return false
}

// SetAccountId gets a reference to the given string and assigns it to the AccountId field.
func (o *AcmeAccount) SetAccountId(v string) {
	o.AccountId = &v
}

// GetKeyDigest returns the KeyDigest field value if set, zero value otherwise.
func (o *AcmeAccount) GetKeyDigest() string {
	if o == nil || o.KeyDigest == nil {
		var ret string
		return ret
	}
	return *o.KeyDigest
}

// GetKeyDigestOk returns a tuple with the KeyDigest field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AcmeAccount) GetKeyDigestOk() (*string, bool) {
	if o == nil || o.KeyDigest == nil {
		return nil, false
	}
	return o.KeyDigest, true
}

// HasKeyDigest returns a boolean if a field has been set.
func (o *AcmeAccount) HasKeyDigest() bool {
	if o != nil && o.KeyDigest != nil {
		return true
	}

	return false
}

// SetKeyDigest gets a reference to the given string and assigns it to the KeyDigest field.
func (o *AcmeAccount) SetKeyDigest(v string) {
	o.KeyDigest = &v
}

// GetStatus returns the Status field value if set, zero value otherwise.
func (o *AcmeAccount) GetStatus() string {
	if o == nil || o.Status == nil {
		var ret string
		return ret
	}
	return *o.Status
}

// GetStatusOk returns a tuple with the Status field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AcmeAccount) GetStatusOk() (*string, bool) {
	if o == nil || o.Status == nil {
		return nil, false
	}
	return o.Status, true
}

// HasStatus returns a boolean if a field has been set.
func (o *AcmeAccount) HasStatus() bool {
	if o != nil && o.Status != nil {
		return true
	}

	return false
}

// SetStatus gets a reference to the given string and assigns it to the Status field.
func (o *AcmeAccount) SetStatus(v string) {
	o.Status = &v
}

func (o AcmeAccount) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccountId != nil {
		toSerialize["account_id"] = o.AccountId
	}
	if o.KeyDigest != nil {
		toSerialize["key_digest"] = o.KeyDigest
	}
	if o.Status != nil {
		toSerialize["status"] = o.Status
	}
	return json.Marshal(toSerialize)
}

type NullableAcmeAccount struct {
	value *AcmeAccount
	isSet bool
}

func (v NullableAcmeAccount) Get() *AcmeAccount {
	return v.value
}

func (v *NullableAcmeAccount) Set(val *AcmeAccount) {
	v.value = val
	v.isSet = true
}

func (v NullableAcmeAccount) IsSet() bool {
	return v.isSet
}

func (v *NullableAcmeAccount) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAcmeAccount(val *AcmeAccount) *NullableAcmeAccount {
	return &NullableAcmeAccount{value: val, isSet: true}
}

func (v NullableAcmeAccount) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAcmeAccount) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


