/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.artifacts.ComponentMetadataDetails;
import org.gradle.api.internal.artifacts.dsl.ActionBasedMetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.ClassBasedMetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.MetadataRuleWrapper;
import org.gradle.api.internal.artifacts.dsl.SpecConfigurableRule;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.NoOpDerivationStrategy;
import org.gradle.internal.component.external.model.VariantDerivationStrategy;
import org.gradle.internal.rules.SpecRuleAction;

class ComponentMetadataRuleContainer
implements Iterable<MetadataRuleWrapper> {
    private final List<MetadataRuleWrapper> rules = new ArrayList<MetadataRuleWrapper>(10);
    private MetadataRuleWrapper lastAdded;
    private boolean classBasedRulesOnly = true;
    private VariantDerivationStrategy variantDerivationStrategy = NoOpDerivationStrategy.getInstance();
    private int rulesHash = 0;
    private Consumer<DisplayName> onAdd;

    ComponentMetadataRuleContainer() {
    }

    void addRule(SpecRuleAction<? super ComponentMetadataDetails> ruleAction) {
        this.lastAdded = new ActionBasedMetadataRuleWrapper(ruleAction);
        this.addRule();
        this.classBasedRulesOnly = false;
        this.rulesHash = 31 * this.rulesHash + ruleAction.hashCode();
    }

    private void addRule() {
        if (this.onAdd != null) {
            this.onAdd.accept(this.lastAdded.getDisplayName());
        }
        this.rules.add(this.lastAdded);
    }

    void addClassRule(SpecConfigurableRule ruleAction) {
        if (this.lastAdded != null && this.lastAdded.isClassBased()) {
            this.lastAdded.addClassRule(ruleAction);
        } else {
            this.lastAdded = new ClassBasedMetadataRuleWrapper(ruleAction);
            this.addRule();
        }
        this.rulesHash = 31 * this.rulesHash + ruleAction.getConfigurableRule().hashCode();
    }

    boolean isClassBasedRulesOnly() {
        return this.classBasedRulesOnly;
    }

    boolean isEmpty() {
        return this.rules.isEmpty();
    }

    @Override
    public Iterator<MetadataRuleWrapper> iterator() {
        return this.rules.iterator();
    }

    Collection<SpecConfigurableRule> getOnlyClassRules() {
        if (!this.isClassBasedRulesOnly() || this.isEmpty()) {
            throw new IllegalStateException("This method cannot be used unless there is at least one rule and they are all class based");
        }
        return this.rules.get(0).getClassRules();
    }

    public VariantDerivationStrategy getVariantDerivationStrategy() {
        return this.variantDerivationStrategy;
    }

    public void setVariantDerivationStrategy(VariantDerivationStrategy variantDerivationStrategy) {
        this.variantDerivationStrategy = variantDerivationStrategy;
    }

    public int getRulesHash() {
        return 31 * this.variantDerivationStrategy.hashCode() + this.rulesHash;
    }

    void onAddRule(Consumer<DisplayName> consumer) {
        this.onAdd = consumer;
    }
}

