/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import com.google.common.base.Optional;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.jvm.JavaVersionParser;
import org.gradle.internal.FileUtils;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.jvm.JavaHomeException;
import org.gradle.internal.jvm.JavaInfo;
import org.gradle.internal.os.OperatingSystem;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jvm
implements JavaInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jvm.class);
    private static final Collection<String> VENDOR_PROPERTIES = Arrays.asList("java.vendor", "java.vm.vendor");
    private static final AtomicReference<Jvm> CURRENT = new AtomicReference();
    private static final Pattern APP_NAME_REGEX = Pattern.compile("APP_NAME_\\d+");
    private static final Pattern JAVA_MAIN_CLASS_REGEX = Pattern.compile("JAVA_MAIN_CLASS_\\d+");
    private final OperatingSystem os;
    private final File javaBase;
    private final File javaHome;
    private final boolean userSupplied;
    private final String implementationJavaVersion;
    private final Integer javaVersionMajor;
    private File javaExecutable;
    private File javacExecutable;
    private File javadocExecutable;
    private Optional<File> toolsJar;
    private Boolean jdk;

    public static Jvm current() {
        Jvm jvm = CURRENT.get();
        if (jvm == null) {
            CURRENT.compareAndSet(null, new Jvm(OperatingSystem.current()));
            jvm = CURRENT.get();
        }
        return jvm;
    }

    private static Jvm create(File javaBase, @Nullable String implementationJavaVersion, @Nullable Integer javaVersionMajor) {
        Jvm jvm = new Jvm(OperatingSystem.current(), javaBase, implementationJavaVersion, javaVersionMajor);
        Jvm current = Jvm.current();
        return jvm.getJavaHome().equals(current.getJavaHome()) ? current : jvm;
    }

    Jvm(OperatingSystem os) {
        this(os, FileUtils.canonicalize(new File(System.getProperty("java.home"))), System.getProperty("java.version"), JavaVersionParser.parseMajorVersion((String)System.getProperty("java.version")), false);
    }

    Jvm(OperatingSystem os, File suppliedJavaBase, @Nullable String implementationJavaVersion, @Nullable Integer javaVersionMajor) {
        this(os, suppliedJavaBase, implementationJavaVersion, javaVersionMajor, true);
    }

    private Jvm(OperatingSystem os, File suppliedJavaBase, @Nullable String implementationJavaVersion, @Nullable Integer javaVersionMajor, boolean userSupplied) {
        this.os = os;
        this.javaBase = suppliedJavaBase;
        this.implementationJavaVersion = implementationJavaVersion;
        this.javaVersionMajor = javaVersionMajor;
        this.userSupplied = userSupplied;
        this.javaHome = this.findJavaHome(suppliedJavaBase);
    }

    public static JavaInfo forHome(File javaHome) throws JavaHomeException, IllegalArgumentException {
        if (!javaHome.isDirectory()) {
            throw new IllegalArgumentException("Supplied javaHome must be a valid directory. You supplied: " + javaHome);
        }
        Jvm jvm = Jvm.create(javaHome, null, null);
        jvm.getJavaExecutable();
        return jvm;
    }

    public static Jvm discovered(File javaHome, String implementationJavaVersion, Integer javaVersionMajor) {
        return Jvm.create(javaHome, implementationJavaVersion, javaVersionMajor);
    }

    @Deprecated
    public static Jvm discovered(File javaHome, String implementationJavaVersion, JavaVersion javaVersion) {
        return Jvm.create(javaHome, implementationJavaVersion, Integer.parseInt(javaVersion.getMajorVersion()));
    }

    public String toString() {
        if (this.userSupplied) {
            return "User-supplied java: " + this.javaBase;
        }
        return SystemProperties.getInstance().getJavaVersion() + " (" + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.version") + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Jvm other = (Jvm)obj;
        return other.javaHome.equals(this.javaHome);
    }

    public int hashCode() {
        return this.javaHome.hashCode();
    }

    public boolean isJdk() {
        if (this.jdk == null) {
            this.jdk = this.findExecutableInJavaHome("javac") != null;
        }
        return this.jdk;
    }

    private @Nullable File findExecutableInJavaHome(String command) {
        File executable = this.commandLocation(command);
        if (executable.isFile()) {
            return executable;
        }
        return null;
    }

    private File commandLocation(String command) {
        File exec = new File(this.getJavaHome(), "bin/" + command);
        return new File(this.os.getExecutableName(exec.getAbsolutePath()));
    }

    private File findExecutable(String command) {
        File executable = this.commandLocation(command);
        if (executable.isFile()) {
            return executable;
        }
        if (this.userSupplied) {
            throw new JavaHomeException(String.format("The supplied javaHome seems to be invalid. I cannot find the %s executable. Tried location: %s", command, executable.getAbsolutePath()));
        }
        File pathExecutable = this.os.findInPath(command);
        if (pathExecutable != null) {
            LOGGER.info(String.format("Unable to find the '%s' executable using home: %s. We found it on the PATH: %s.", command, this.getJavaHome(), pathExecutable));
            return pathExecutable;
        }
        LOGGER.warn("Unable to find the '{}' executable. Tried the java home: {} and the PATH. We will assume the executable can be run in the current working folder.", (Object)command, (Object)this.getJavaHome());
        return new File(this.os.getExecutableName(command));
    }

    @Override
    public File getJavaExecutable() throws JavaHomeException {
        if (this.javaExecutable != null) {
            return this.javaExecutable;
        }
        this.javaExecutable = this.findExecutable("java");
        return this.javaExecutable;
    }

    @Override
    public File getJavacExecutable() throws JavaHomeException {
        if (this.javacExecutable != null) {
            return this.javacExecutable;
        }
        this.javacExecutable = this.findExecutable("javac");
        return this.javacExecutable;
    }

    @Override
    public File getJavadocExecutable() throws JavaHomeException {
        if (this.javadocExecutable != null) {
            return this.javadocExecutable;
        }
        this.javadocExecutable = this.findExecutable("javadoc");
        return this.javadocExecutable;
    }

    @Override
    public File getExecutable(String name) throws JavaHomeException {
        return this.findExecutable(name);
    }

    public @Nullable Integer getJavaVersionMajor() {
        return this.javaVersionMajor;
    }

    public @Nullable JavaVersion getJavaVersion() {
        if (this.javaVersionMajor == null) {
            return null;
        }
        return JavaVersion.toVersion((Object)this.javaVersionMajor);
    }

    @Override
    public File getJavaHome() {
        return this.javaHome;
    }

    private File findJavaHome(File javaBase) {
        Optional<File> toolsJar = this.findToolsJar(javaBase);
        if (toolsJar.isPresent()) {
            return ((File)toolsJar.get()).getParentFile().getParentFile();
        }
        if (javaBase.getName().equalsIgnoreCase("jre") && new File(javaBase.getParentFile(), "bin/java").exists()) {
            return javaBase.getParentFile();
        }
        return javaBase;
    }

    @Override
    public File getToolsJar() {
        if (this.toolsJar != null) {
            return (File)this.toolsJar.orNull();
        }
        this.toolsJar = this.findToolsJar(this.javaHome);
        return (File)this.toolsJar.orNull();
    }

    public @Nullable File getStandaloneJre() {
        File jreDir;
        JavaVersion javaVersion = this.getJavaVersion();
        if (javaVersion != null && javaVersion.isJava9Compatible()) {
            return null;
        }
        if (this.os.isWindows() && (jreDir = this.javaVersionMajor == 5 ? new File(this.javaHome.getParentFile(), "jre" + this.implementationJavaVersion) : new File(this.javaHome.getParentFile(), "jre" + this.javaVersionMajor)).isDirectory()) {
            return jreDir;
        }
        return null;
    }

    public @Nullable File getEmbeddedJre() {
        File jreDir = new File(this.javaHome, "jre");
        if (jreDir.isDirectory()) {
            return jreDir;
        }
        return null;
    }

    public @Nullable File getJre() {
        File standaloneJre = this.getStandaloneJre();
        if (standaloneJre != null) {
            return standaloneJre;
        }
        return this.getEmbeddedJre();
    }

    private Optional<File> findToolsJar(File javaHome) {
        File toolsJar = new File(javaHome, "lib/tools.jar");
        if (toolsJar.exists()) {
            return Optional.of((Object)toolsJar);
        }
        if (javaHome.getName().equalsIgnoreCase("jre") && (toolsJar = new File(javaHome = javaHome.getParentFile(), "lib/tools.jar")).exists()) {
            return Optional.of((Object)toolsJar);
        }
        if (this.os.isWindows()) {
            String version = this.implementationJavaVersion;
            if ((javaHome.getName().matches("jre\\d+") || javaHome.getName().equals("jre" + version)) && (toolsJar = new File(javaHome = new File(javaHome.getParentFile(), "jdk" + version), "lib/tools.jar")).exists()) {
                return Optional.of((Object)toolsJar);
            }
        }
        return Optional.absent();
    }

    public static Map<String, ?> getInheritableEnvironmentVariables(Map<String, ?> envVars) {
        HashMap vars = new HashMap();
        for (Map.Entry<String, ?> entry : envVars.entrySet()) {
            if (APP_NAME_REGEX.matcher(entry.getKey()).matches() || JAVA_MAIN_CLASS_REGEX.matcher(entry.getKey()).matches() || entry.getKey().equals("TERM_SESSION_ID") || entry.getKey().equals("ITERM_SESSION_ID")) continue;
            vars.put(entry.getKey(), entry.getValue());
        }
        return vars;
    }

    public boolean isIbmJvm() {
        for (String vendorProperty : VENDOR_PROPERTIES) {
            if (!System.getProperties().containsKey(vendorProperty) || !System.getProperty(vendorProperty).toLowerCase(Locale.ROOT).startsWith("ibm corporation")) continue;
            return true;
        }
        return false;
    }

    public @Nullable String getVendor() {
        for (String vendorProperty : VENDOR_PROPERTIES) {
            if (!System.getProperties().containsKey(vendorProperty) || System.getProperty(vendorProperty).isEmpty()) continue;
            return System.getProperty(vendorProperty);
        }
        return null;
    }
}

