/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.AbstractRenderableDependencyResult;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableUnresolvedDependencyResult;

public class RenderableDependencyResult
extends AbstractRenderableDependencyResult {
    private final ResolvedDependencyResult dependency;

    public RenderableDependencyResult(ResolvedDependencyResult dependency) {
        this.dependency = dependency;
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return this.dependency.isConstraint() ? RenderableDependency.ResolutionState.RESOLVED_CONSTRAINT : RenderableDependency.ResolutionState.RESOLVED;
    }

    @Override
    protected ComponentIdentifier getActual() {
        return this.dependency.getSelected().getId();
    }

    @Override
    protected ComponentSelector getRequested() {
        return this.dependency.getRequested();
    }

    public Set<RenderableDependency> getChildren() {
        LinkedHashSet<RenderableDependency> out = new LinkedHashSet<RenderableDependency>();
        for (DependencyResult d : this.dependency.getSelected().getDependencies()) {
            if (d instanceof UnresolvedDependencyResult) {
                out.add(new RenderableUnresolvedDependencyResult((UnresolvedDependencyResult)d));
                continue;
            }
            out.add(new RenderableDependencyResult((ResolvedDependencyResult)d));
        }
        return out;
    }
}

