/* Copyright (C) 2022 D. R. Commander.  All Rights Reserved.
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */

package com.turbovnc.rfb;

public final class Keycodes {

  public static final int[] XORG_BASE_TO_RFB = {
    // Auto-generated from keymaps.csv
    // Database checksum
    // sha256(277b04f9dd721dd7942235d6ff107f992d95a083b651e73814ac3bb12f9c56d5)
    // To re-generate, run:
    //   keymap-gen code-map --lang=stdc++ keymaps.csv xorgkbd qnum
    0,     // xorgkbd:0 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:1 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:2 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:3 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:4 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:5 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:6 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:7 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:8 -> linux:None (unnamed) -> qnum:None
    0x1,   // xorgkbd:9 -> linux:1 (KEY_ESC) -> qnum:1
    0x2,   // xorgkbd:10 -> linux:2 (KEY_1) -> qnum:2
    0x3,   // xorgkbd:11 -> linux:3 (KEY_2) -> qnum:3
    0x4,   // xorgkbd:12 -> linux:4 (KEY_3) -> qnum:4
    0x5,   // xorgkbd:13 -> linux:5 (KEY_4) -> qnum:5
    0x6,   // xorgkbd:14 -> linux:6 (KEY_5) -> qnum:6
    0x7,   // xorgkbd:15 -> linux:7 (KEY_6) -> qnum:7
    0x8,   // xorgkbd:16 -> linux:8 (KEY_7) -> qnum:8
    0x9,   // xorgkbd:17 -> linux:9 (KEY_8) -> qnum:9
    0xa,   // xorgkbd:18 -> linux:10 (KEY_9) -> qnum:10
    0xb,   // xorgkbd:19 -> linux:11 (KEY_0) -> qnum:11
    0xc,   // xorgkbd:20 -> linux:12 (KEY_MINUS) -> qnum:12
    0xd,   // xorgkbd:21 -> linux:13 (KEY_EQUAL) -> qnum:13
    0xe,   // xorgkbd:22 -> linux:14 (KEY_BACKSPACE) -> qnum:14
    0xf,   // xorgkbd:23 -> linux:15 (KEY_TAB) -> qnum:15
    0x10,  // xorgkbd:24 -> linux:16 (KEY_Q) -> qnum:16
    0x11,  // xorgkbd:25 -> linux:17 (KEY_W) -> qnum:17
    0x12,  // xorgkbd:26 -> linux:18 (KEY_E) -> qnum:18
    0x13,  // xorgkbd:27 -> linux:19 (KEY_R) -> qnum:19
    0x14,  // xorgkbd:28 -> linux:20 (KEY_T) -> qnum:20
    0x15,  // xorgkbd:29 -> linux:21 (KEY_Y) -> qnum:21
    0x16,  // xorgkbd:30 -> linux:22 (KEY_U) -> qnum:22
    0x17,  // xorgkbd:31 -> linux:23 (KEY_I) -> qnum:23
    0x18,  // xorgkbd:32 -> linux:24 (KEY_O) -> qnum:24
    0x19,  // xorgkbd:33 -> linux:25 (KEY_P) -> qnum:25
    0x1a,  // xorgkbd:34 -> linux:26 (KEY_LEFTBRACE) -> qnum:26
    0x1b,  // xorgkbd:35 -> linux:27 (KEY_RIGHTBRACE) -> qnum:27
    0x1c,  // xorgkbd:36 -> linux:28 (KEY_ENTER) -> qnum:28
    0x1d,  // xorgkbd:37 -> linux:29 (KEY_LEFTCTRL) -> qnum:29
    0x1e,  // xorgkbd:38 -> linux:30 (KEY_A) -> qnum:30
    0x1f,  // xorgkbd:39 -> linux:31 (KEY_S) -> qnum:31
    0x20,  // xorgkbd:40 -> linux:32 (KEY_D) -> qnum:32
    0x21,  // xorgkbd:41 -> linux:33 (KEY_F) -> qnum:33
    0x22,  // xorgkbd:42 -> linux:34 (KEY_G) -> qnum:34
    0x23,  // xorgkbd:43 -> linux:35 (KEY_H) -> qnum:35
    0x24,  // xorgkbd:44 -> linux:36 (KEY_J) -> qnum:36
    0x25,  // xorgkbd:45 -> linux:37 (KEY_K) -> qnum:37
    0x26,  // xorgkbd:46 -> linux:38 (KEY_L) -> qnum:38
    0x27,  // xorgkbd:47 -> linux:39 (KEY_SEMICOLON) -> qnum:39
    0x28,  // xorgkbd:48 -> linux:40 (KEY_APOSTROPHE) -> qnum:40
    0x29,  // xorgkbd:49 -> linux:41 (KEY_GRAVE) -> qnum:41
    0x2a,  // xorgkbd:50 -> linux:42 (KEY_LEFTSHIFT) -> qnum:42
    0x2b,  // xorgkbd:51 -> linux:43 (KEY_BACKSLASH) -> qnum:43
    0x2c,  // xorgkbd:52 -> linux:44 (KEY_Z) -> qnum:44
    0x2d,  // xorgkbd:53 -> linux:45 (KEY_X) -> qnum:45
    0x2e,  // xorgkbd:54 -> linux:46 (KEY_C) -> qnum:46
    0x2f,  // xorgkbd:55 -> linux:47 (KEY_V) -> qnum:47
    0x30,  // xorgkbd:56 -> linux:48 (KEY_B) -> qnum:48
    0x31,  // xorgkbd:57 -> linux:49 (KEY_N) -> qnum:49
    0x32,  // xorgkbd:58 -> linux:50 (KEY_M) -> qnum:50
    0x33,  // xorgkbd:59 -> linux:51 (KEY_COMMA) -> qnum:51
    0x34,  // xorgkbd:60 -> linux:52 (KEY_DOT) -> qnum:52
    0x35,  // xorgkbd:61 -> linux:53 (KEY_SLASH) -> qnum:53
    0x36,  // xorgkbd:62 -> linux:54 (KEY_RIGHTSHIFT) -> qnum:54
    0x37,  // xorgkbd:63 -> linux:55 (KEY_KPASTERISK) -> qnum:55
    0x38,  // xorgkbd:64 -> linux:56 (KEY_LEFTALT) -> qnum:56
    0x39,  // xorgkbd:65 -> linux:57 (KEY_SPACE) -> qnum:57
    0x3a,  // xorgkbd:66 -> linux:58 (KEY_CAPSLOCK) -> qnum:58
    0x3b,  // xorgkbd:67 -> linux:59 (KEY_F1) -> qnum:59
    0x3c,  // xorgkbd:68 -> linux:60 (KEY_F2) -> qnum:60
    0x3d,  // xorgkbd:69 -> linux:61 (KEY_F3) -> qnum:61
    0x3e,  // xorgkbd:70 -> linux:62 (KEY_F4) -> qnum:62
    0x3f,  // xorgkbd:71 -> linux:63 (KEY_F5) -> qnum:63
    0x40,  // xorgkbd:72 -> linux:64 (KEY_F6) -> qnum:64
    0x41,  // xorgkbd:73 -> linux:65 (KEY_F7) -> qnum:65
    0x42,  // xorgkbd:74 -> linux:66 (KEY_F8) -> qnum:66
    0x43,  // xorgkbd:75 -> linux:67 (KEY_F9) -> qnum:67
    0x44,  // xorgkbd:76 -> linux:68 (KEY_F10) -> qnum:68
    0x45,  // xorgkbd:77 -> linux:69 (KEY_NUMLOCK) -> qnum:69
    0x46,  // xorgkbd:78 -> linux:70 (KEY_SCROLLLOCK) -> qnum:70
    0x47,  // xorgkbd:79 -> linux:71 (KEY_KP7) -> qnum:71
    0x48,  // xorgkbd:80 -> linux:72 (KEY_KP8) -> qnum:72
    0x49,  // xorgkbd:81 -> linux:73 (KEY_KP9) -> qnum:73
    0x4a,  // xorgkbd:82 -> linux:74 (KEY_KPMINUS) -> qnum:74
    0x4b,  // xorgkbd:83 -> linux:75 (KEY_KP4) -> qnum:75
    0x4c,  // xorgkbd:84 -> linux:76 (KEY_KP5) -> qnum:76
    0x4d,  // xorgkbd:85 -> linux:77 (KEY_KP6) -> qnum:77
    0x4e,  // xorgkbd:86 -> linux:78 (KEY_KPPLUS) -> qnum:78
    0x4f,  // xorgkbd:87 -> linux:79 (KEY_KP1) -> qnum:79
    0x50,  // xorgkbd:88 -> linux:80 (KEY_KP2) -> qnum:80
    0x51,  // xorgkbd:89 -> linux:81 (KEY_KP3) -> qnum:81
    0x52,  // xorgkbd:90 -> linux:82 (KEY_KP0) -> qnum:82
    0x53,  // xorgkbd:91 -> linux:83 (KEY_KPDOT) -> qnum:83
    0,     // xorgkbd:92 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:93 -> linux:None (unnamed) -> qnum:None
    0x56,  // xorgkbd:94 -> linux:86 (KEY_102ND) -> qnum:86
    0x57,  // xorgkbd:95 -> linux:87 (KEY_F11) -> qnum:87
    0x58,  // xorgkbd:96 -> linux:88 (KEY_F12) -> qnum:88
    0xc7,  // xorgkbd:97 -> linux:102 (KEY_HOME) -> qnum:199
    0xc8,  // xorgkbd:98 -> linux:103 (KEY_UP) -> qnum:200
    0xc9,  // xorgkbd:99 -> linux:104 (KEY_PAGEUP) -> qnum:201
    0xcb,  // xorgkbd:100 -> linux:105 (KEY_LEFT) -> qnum:203
    0,     // xorgkbd:101 -> linux:None (unnamed) -> qnum:None
    0xcd,  // xorgkbd:102 -> linux:106 (KEY_RIGHT) -> qnum:205
    0xcf,  // xorgkbd:103 -> linux:107 (KEY_END) -> qnum:207
    0xd0,  // xorgkbd:104 -> linux:108 (KEY_DOWN) -> qnum:208
    0xd1,  // xorgkbd:105 -> linux:109 (KEY_PAGEDOWN) -> qnum:209
    0xd2,  // xorgkbd:106 -> linux:110 (KEY_INSERT) -> qnum:210
    0xd3,  // xorgkbd:107 -> linux:111 (KEY_DELETE) -> qnum:211
    0x9c,  // xorgkbd:108 -> linux:96 (KEY_KPENTER) -> qnum:156
    0x9d,  // xorgkbd:109 -> linux:97 (KEY_RIGHTCTRL) -> qnum:157
    0xc6,  // xorgkbd:110 -> linux:119 (KEY_PAUSE) -> qnum:198
    0x54,  // xorgkbd:111 -> linux:99 (KEY_SYSRQ) -> qnum:84
    0xb5,  // xorgkbd:112 -> linux:98 (KEY_KPSLASH) -> qnum:181
    0xb8,  // xorgkbd:113 -> linux:100 (KEY_RIGHTALT) -> qnum:184
    0,     // xorgkbd:114 -> linux:None (unnamed) -> qnum:None
    0xdb,  // xorgkbd:115 -> linux:125 (KEY_LEFTMETA) -> qnum:219
    0xdc,  // xorgkbd:116 -> linux:126 (KEY_RIGHTMETA) -> qnum:220
    0xdd,  // xorgkbd:117 -> linux:127 (KEY_COMPOSE) -> qnum:221
    0x5d,  // xorgkbd:118 -> linux:183 (KEY_F13) -> qnum:93
    0x5e,  // xorgkbd:119 -> linux:184 (KEY_F14) -> qnum:94
    0x5f,  // xorgkbd:120 -> linux:185 (KEY_F15) -> qnum:95
    0x55,  // xorgkbd:121 -> linux:186 (KEY_F16) -> qnum:85
    0x83,  // xorgkbd:122 -> linux:187 (KEY_F17) -> qnum:131
    0x73,  // xorgkbd:123 -> linux:89 (KEY_RO) -> qnum:115
    0,     // xorgkbd:124 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:125 -> linux:None (unnamed) -> qnum:None
    0x59,  // xorgkbd:126 -> linux:117 (KEY_KPEQUAL) -> qnum:89
    0,     // xorgkbd:127 -> linux:None (unnamed) -> qnum:None
    0,     // xorgkbd:128 -> linux:None (unnamed) -> qnum:None
    0x79,  // xorgkbd:129 -> linux:92 (KEY_HENKAN) -> qnum:121
    0,     // xorgkbd:130 -> linux:None (unnamed) -> qnum:None
    0x7b,  // xorgkbd:131 -> linux:94 (KEY_MUHENKAN) -> qnum:123
    0,     // xorgkbd:132 -> linux:None (unnamed) -> qnum:None
    0x7d   // xorgkbd:133 -> linux:124 (KEY_YEN) -> qnum:125
  };

  public static final int[] XORG_EVDEV_TO_RFB = {
    // Auto-generated from keymaps.csv
    // Database checksum
    // sha256(277b04f9dd721dd7942235d6ff107f992d95a083b651e73814ac3bb12f9c56d5)
    // To re-generate, run:
    //   keymap-gen code-map --lang=stdc++ keymaps.csv xorgevdev qnum
    0,     // xorgevdev:0 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:1 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:2 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:3 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:4 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:5 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:6 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:7 -> linux:None (unnamed) -> qnum:None
    0,     // xorgevdev:8 -> linux:0 (KEY_RESERVED) -> qnum:None
    0x1,   // xorgevdev:9 -> linux:1 (KEY_ESC) -> qnum:1
    0x2,   // xorgevdev:10 -> linux:2 (KEY_1) -> qnum:2
    0x3,   // xorgevdev:11 -> linux:3 (KEY_2) -> qnum:3
    0x4,   // xorgevdev:12 -> linux:4 (KEY_3) -> qnum:4
    0x5,   // xorgevdev:13 -> linux:5 (KEY_4) -> qnum:5
    0x6,   // xorgevdev:14 -> linux:6 (KEY_5) -> qnum:6
    0x7,   // xorgevdev:15 -> linux:7 (KEY_6) -> qnum:7
    0x8,   // xorgevdev:16 -> linux:8 (KEY_7) -> qnum:8
    0x9,   // xorgevdev:17 -> linux:9 (KEY_8) -> qnum:9
    0xa,   // xorgevdev:18 -> linux:10 (KEY_9) -> qnum:10
    0xb,   // xorgevdev:19 -> linux:11 (KEY_0) -> qnum:11
    0xc,   // xorgevdev:20 -> linux:12 (KEY_MINUS) -> qnum:12
    0xd,   // xorgevdev:21 -> linux:13 (KEY_EQUAL) -> qnum:13
    0xe,   // xorgevdev:22 -> linux:14 (KEY_BACKSPACE) -> qnum:14
    0xf,   // xorgevdev:23 -> linux:15 (KEY_TAB) -> qnum:15
    0x10,  // xorgevdev:24 -> linux:16 (KEY_Q) -> qnum:16
    0x11,  // xorgevdev:25 -> linux:17 (KEY_W) -> qnum:17
    0x12,  // xorgevdev:26 -> linux:18 (KEY_E) -> qnum:18
    0x13,  // xorgevdev:27 -> linux:19 (KEY_R) -> qnum:19
    0x14,  // xorgevdev:28 -> linux:20 (KEY_T) -> qnum:20
    0x15,  // xorgevdev:29 -> linux:21 (KEY_Y) -> qnum:21
    0x16,  // xorgevdev:30 -> linux:22 (KEY_U) -> qnum:22
    0x17,  // xorgevdev:31 -> linux:23 (KEY_I) -> qnum:23
    0x18,  // xorgevdev:32 -> linux:24 (KEY_O) -> qnum:24
    0x19,  // xorgevdev:33 -> linux:25 (KEY_P) -> qnum:25
    0x1a,  // xorgevdev:34 -> linux:26 (KEY_LEFTBRACE) -> qnum:26
    0x1b,  // xorgevdev:35 -> linux:27 (KEY_RIGHTBRACE) -> qnum:27
    0x1c,  // xorgevdev:36 -> linux:28 (KEY_ENTER) -> qnum:28
    0x1d,  // xorgevdev:37 -> linux:29 (KEY_LEFTCTRL) -> qnum:29
    0x1e,  // xorgevdev:38 -> linux:30 (KEY_A) -> qnum:30
    0x1f,  // xorgevdev:39 -> linux:31 (KEY_S) -> qnum:31
    0x20,  // xorgevdev:40 -> linux:32 (KEY_D) -> qnum:32
    0x21,  // xorgevdev:41 -> linux:33 (KEY_F) -> qnum:33
    0x22,  // xorgevdev:42 -> linux:34 (KEY_G) -> qnum:34
    0x23,  // xorgevdev:43 -> linux:35 (KEY_H) -> qnum:35
    0x24,  // xorgevdev:44 -> linux:36 (KEY_J) -> qnum:36
    0x25,  // xorgevdev:45 -> linux:37 (KEY_K) -> qnum:37
    0x26,  // xorgevdev:46 -> linux:38 (KEY_L) -> qnum:38
    0x27,  // xorgevdev:47 -> linux:39 (KEY_SEMICOLON) -> qnum:39
    0x28,  // xorgevdev:48 -> linux:40 (KEY_APOSTROPHE) -> qnum:40
    0x29,  // xorgevdev:49 -> linux:41 (KEY_GRAVE) -> qnum:41
    0x2a,  // xorgevdev:50 -> linux:42 (KEY_LEFTSHIFT) -> qnum:42
    0x2b,  // xorgevdev:51 -> linux:43 (KEY_BACKSLASH) -> qnum:43
    0x2c,  // xorgevdev:52 -> linux:44 (KEY_Z) -> qnum:44
    0x2d,  // xorgevdev:53 -> linux:45 (KEY_X) -> qnum:45
    0x2e,  // xorgevdev:54 -> linux:46 (KEY_C) -> qnum:46
    0x2f,  // xorgevdev:55 -> linux:47 (KEY_V) -> qnum:47
    0x30,  // xorgevdev:56 -> linux:48 (KEY_B) -> qnum:48
    0x31,  // xorgevdev:57 -> linux:49 (KEY_N) -> qnum:49
    0x32,  // xorgevdev:58 -> linux:50 (KEY_M) -> qnum:50
    0x33,  // xorgevdev:59 -> linux:51 (KEY_COMMA) -> qnum:51
    0x34,  // xorgevdev:60 -> linux:52 (KEY_DOT) -> qnum:52
    0x35,  // xorgevdev:61 -> linux:53 (KEY_SLASH) -> qnum:53
    0x36,  // xorgevdev:62 -> linux:54 (KEY_RIGHTSHIFT) -> qnum:54
    0x37,  // xorgevdev:63 -> linux:55 (KEY_KPASTERISK) -> qnum:55
    0x38,  // xorgevdev:64 -> linux:56 (KEY_LEFTALT) -> qnum:56
    0x39,  // xorgevdev:65 -> linux:57 (KEY_SPACE) -> qnum:57
    0x3a,  // xorgevdev:66 -> linux:58 (KEY_CAPSLOCK) -> qnum:58
    0x3b,  // xorgevdev:67 -> linux:59 (KEY_F1) -> qnum:59
    0x3c,  // xorgevdev:68 -> linux:60 (KEY_F2) -> qnum:60
    0x3d,  // xorgevdev:69 -> linux:61 (KEY_F3) -> qnum:61
    0x3e,  // xorgevdev:70 -> linux:62 (KEY_F4) -> qnum:62
    0x3f,  // xorgevdev:71 -> linux:63 (KEY_F5) -> qnum:63
    0x40,  // xorgevdev:72 -> linux:64 (KEY_F6) -> qnum:64
    0x41,  // xorgevdev:73 -> linux:65 (KEY_F7) -> qnum:65
    0x42,  // xorgevdev:74 -> linux:66 (KEY_F8) -> qnum:66
    0x43,  // xorgevdev:75 -> linux:67 (KEY_F9) -> qnum:67
    0x44,  // xorgevdev:76 -> linux:68 (KEY_F10) -> qnum:68
    0x45,  // xorgevdev:77 -> linux:69 (KEY_NUMLOCK) -> qnum:69
    0x46,  // xorgevdev:78 -> linux:70 (KEY_SCROLLLOCK) -> qnum:70
    0x47,  // xorgevdev:79 -> linux:71 (KEY_KP7) -> qnum:71
    0x48,  // xorgevdev:80 -> linux:72 (KEY_KP8) -> qnum:72
    0x49,  // xorgevdev:81 -> linux:73 (KEY_KP9) -> qnum:73
    0x4a,  // xorgevdev:82 -> linux:74 (KEY_KPMINUS) -> qnum:74
    0x4b,  // xorgevdev:83 -> linux:75 (KEY_KP4) -> qnum:75
    0x4c,  // xorgevdev:84 -> linux:76 (KEY_KP5) -> qnum:76
    0x4d,  // xorgevdev:85 -> linux:77 (KEY_KP6) -> qnum:77
    0x4e,  // xorgevdev:86 -> linux:78 (KEY_KPPLUS) -> qnum:78
    0x4f,  // xorgevdev:87 -> linux:79 (KEY_KP1) -> qnum:79
    0x50,  // xorgevdev:88 -> linux:80 (KEY_KP2) -> qnum:80
    0x51,  // xorgevdev:89 -> linux:81 (KEY_KP3) -> qnum:81
    0x52,  // xorgevdev:90 -> linux:82 (KEY_KP0) -> qnum:82
    0x53,  // xorgevdev:91 -> linux:83 (KEY_KPDOT) -> qnum:83
    0x54,  // xorgevdev:92 -> linux:84 (unnamed) -> qnum:84
    0x76,  // xorgevdev:93 -> linux:85 (KEY_ZENKAKUHANKAKU) -> qnum:118
    0x56,  // xorgevdev:94 -> linux:86 (KEY_102ND) -> qnum:86
    0x57,  // xorgevdev:95 -> linux:87 (KEY_F11) -> qnum:87
    0x58,  // xorgevdev:96 -> linux:88 (KEY_F12) -> qnum:88
    0x73,  // xorgevdev:97 -> linux:89 (KEY_RO) -> qnum:115
    0x78,  // xorgevdev:98 -> linux:90 (KEY_KATAKANA) -> qnum:120
    0x77,  // xorgevdev:99 -> linux:91 (KEY_HIRAGANA) -> qnum:119
    0x79,  // xorgevdev:100 -> linux:92 (KEY_HENKAN) -> qnum:121
    0x70,  // xorgevdev:101 -> linux:93 (KEY_KATAKANAHIRAGANA) -> qnum:112
    0x7b,  // xorgevdev:102 -> linux:94 (KEY_MUHENKAN) -> qnum:123
    0x5c,  // xorgevdev:103 -> linux:95 (KEY_KPJPCOMMA) -> qnum:92
    0x9c,  // xorgevdev:104 -> linux:96 (KEY_KPENTER) -> qnum:156
    0x9d,  // xorgevdev:105 -> linux:97 (KEY_RIGHTCTRL) -> qnum:157
    0xb5,  // xorgevdev:106 -> linux:98 (KEY_KPSLASH) -> qnum:181
    0x54,  // xorgevdev:107 -> linux:99 (KEY_SYSRQ) -> qnum:84
    0xb8,  // xorgevdev:108 -> linux:100 (KEY_RIGHTALT) -> qnum:184
    0x5b,  // xorgevdev:109 -> linux:101 (KEY_LINEFEED) -> qnum:91
    0xc7,  // xorgevdev:110 -> linux:102 (KEY_HOME) -> qnum:199
    0xc8,  // xorgevdev:111 -> linux:103 (KEY_UP) -> qnum:200
    0xc9,  // xorgevdev:112 -> linux:104 (KEY_PAGEUP) -> qnum:201
    0xcb,  // xorgevdev:113 -> linux:105 (KEY_LEFT) -> qnum:203
    0xcd,  // xorgevdev:114 -> linux:106 (KEY_RIGHT) -> qnum:205
    0xcf,  // xorgevdev:115 -> linux:107 (KEY_END) -> qnum:207
    0xd0,  // xorgevdev:116 -> linux:108 (KEY_DOWN) -> qnum:208
    0xd1,  // xorgevdev:117 -> linux:109 (KEY_PAGEDOWN) -> qnum:209
    0xd2,  // xorgevdev:118 -> linux:110 (KEY_INSERT) -> qnum:210
    0xd3,  // xorgevdev:119 -> linux:111 (KEY_DELETE) -> qnum:211
    0xef,  // xorgevdev:120 -> linux:112 (KEY_MACRO) -> qnum:239
    0xa0,  // xorgevdev:121 -> linux:113 (KEY_MUTE) -> qnum:160
    0xae,  // xorgevdev:122 -> linux:114 (KEY_VOLUMEDOWN) -> qnum:174
    0xb0,  // xorgevdev:123 -> linux:115 (KEY_VOLUMEUP) -> qnum:176
    0xde,  // xorgevdev:124 -> linux:116 (KEY_POWER) -> qnum:222
    0x59,  // xorgevdev:125 -> linux:117 (KEY_KPEQUAL) -> qnum:89
    0xce,  // xorgevdev:126 -> linux:118 (KEY_KPPLUSMINUS) -> qnum:206
    0xc6,  // xorgevdev:127 -> linux:119 (KEY_PAUSE) -> qnum:198
    0x8b,  // xorgevdev:128 -> linux:120 (KEY_SCALE) -> qnum:139
    0x7e,  // xorgevdev:129 -> linux:121 (KEY_KPCOMMA) -> qnum:126
    0x72,  // xorgevdev:130 -> linux:122 (KEY_HANGEUL) -> qnum:114
    0x71,  // xorgevdev:131 -> linux:123 (KEY_HANJA) -> qnum:113
    0x7d,  // xorgevdev:132 -> linux:124 (KEY_YEN) -> qnum:125
    0xdb,  // xorgevdev:133 -> linux:125 (KEY_LEFTMETA) -> qnum:219
    0xdc,  // xorgevdev:134 -> linux:126 (KEY_RIGHTMETA) -> qnum:220
    0xdd,  // xorgevdev:135 -> linux:127 (KEY_COMPOSE) -> qnum:221
    0xe8,  // xorgevdev:136 -> linux:128 (KEY_STOP) -> qnum:232
    0x85,  // xorgevdev:137 -> linux:129 (KEY_AGAIN) -> qnum:133
    0x86,  // xorgevdev:138 -> linux:130 (KEY_PROPS) -> qnum:134
    0x87,  // xorgevdev:139 -> linux:131 (KEY_UNDO) -> qnum:135
    0x8c,  // xorgevdev:140 -> linux:132 (KEY_FRONT) -> qnum:140
    0xf8,  // xorgevdev:141 -> linux:133 (KEY_COPY) -> qnum:248
    0x64,  // xorgevdev:142 -> linux:134 (KEY_OPEN) -> qnum:100
    0x65,  // xorgevdev:143 -> linux:135 (KEY_PASTE) -> qnum:101
    0xc1,  // xorgevdev:144 -> linux:136 (KEY_FIND) -> qnum:193
    0xbc,  // xorgevdev:145 -> linux:137 (KEY_CUT) -> qnum:188
    0xf5,  // xorgevdev:146 -> linux:138 (KEY_HELP) -> qnum:245
    0x9e,  // xorgevdev:147 -> linux:139 (KEY_MENU) -> qnum:158
    0xa1,  // xorgevdev:148 -> linux:140 (KEY_CALC) -> qnum:161
    0x66,  // xorgevdev:149 -> linux:141 (KEY_SETUP) -> qnum:102
    0xdf,  // xorgevdev:150 -> linux:142 (KEY_SLEEP) -> qnum:223
    0xe3,  // xorgevdev:151 -> linux:143 (KEY_WAKEUP) -> qnum:227
    0x67,  // xorgevdev:152 -> linux:144 (KEY_FILE) -> qnum:103
    0x68,  // xorgevdev:153 -> linux:145 (KEY_SENDFILE) -> qnum:104
    0x69,  // xorgevdev:154 -> linux:146 (KEY_DELETEFILE) -> qnum:105
    0x93,  // xorgevdev:155 -> linux:147 (KEY_XFER) -> qnum:147
    0x9f,  // xorgevdev:156 -> linux:148 (KEY_PROG1) -> qnum:159
    0x97,  // xorgevdev:157 -> linux:149 (KEY_PROG2) -> qnum:151
    0x82,  // xorgevdev:158 -> linux:150 (KEY_WWW) -> qnum:130
    0x6a,  // xorgevdev:159 -> linux:151 (KEY_MSDOS) -> qnum:106
    0x92,  // xorgevdev:160 -> linux:152 (KEY_SCREENLOCK) -> qnum:146
    0x6b,  // xorgevdev:161 -> linux:153 (KEY_DIRECTION) -> qnum:107
    0xa6,  // xorgevdev:162 -> linux:154 (KEY_CYCLEWINDOWS) -> qnum:166
    0xec,  // xorgevdev:163 -> linux:155 (KEY_MAIL) -> qnum:236
    0xe6,  // xorgevdev:164 -> linux:156 (KEY_BOOKMARKS) -> qnum:230
    0xeb,  // xorgevdev:165 -> linux:157 (KEY_COMPUTER) -> qnum:235
    0xea,  // xorgevdev:166 -> linux:158 (KEY_BACK) -> qnum:234
    0xe9,  // xorgevdev:167 -> linux:159 (KEY_FORWARD) -> qnum:233
    0xa3,  // xorgevdev:168 -> linux:160 (KEY_CLOSECD) -> qnum:163
    0x6c,  // xorgevdev:169 -> linux:161 (KEY_EJECTCD) -> qnum:108
    0xfd,  // xorgevdev:170 -> linux:162 (KEY_EJECTCLOSECD) -> qnum:253
    0x99,  // xorgevdev:171 -> linux:163 (KEY_NEXTSONG) -> qnum:153
    0xa2,  // xorgevdev:172 -> linux:164 (KEY_PLAYPAUSE) -> qnum:162
    0x90,  // xorgevdev:173 -> linux:165 (KEY_PREVIOUSSONG) -> qnum:144
    0xa4,  // xorgevdev:174 -> linux:166 (KEY_STOPCD) -> qnum:164
    0xb1,  // xorgevdev:175 -> linux:167 (KEY_RECORD) -> qnum:177
    0x98,  // xorgevdev:176 -> linux:168 (KEY_REWIND) -> qnum:152
    0x63,  // xorgevdev:177 -> linux:169 (KEY_PHONE) -> qnum:99
    0,     // xorgevdev:178 -> linux:170 (KEY_ISO) -> qnum:None
    0x81,  // xorgevdev:179 -> linux:171 (KEY_CONFIG) -> qnum:129
    0xb2,  // xorgevdev:180 -> linux:172 (KEY_HOMEPAGE) -> qnum:178
    0xe7,  // xorgevdev:181 -> linux:173 (KEY_REFRESH) -> qnum:231
    0,     // xorgevdev:182 -> linux:174 (KEY_EXIT) -> qnum:None
    0,     // xorgevdev:183 -> linux:175 (KEY_MOVE) -> qnum:None
    0x88,  // xorgevdev:184 -> linux:176 (KEY_EDIT) -> qnum:136
    0x75,  // xorgevdev:185 -> linux:177 (KEY_SCROLLUP) -> qnum:117
    0x8f,  // xorgevdev:186 -> linux:178 (KEY_SCROLLDOWN) -> qnum:143
    0xf6,  // xorgevdev:187 -> linux:179 (KEY_KPLEFTPAREN) -> qnum:246
    0xfb,  // xorgevdev:188 -> linux:180 (KEY_KPRIGHTPAREN) -> qnum:251
    0x89,  // xorgevdev:189 -> linux:181 (KEY_NEW) -> qnum:137
    0x8a,  // xorgevdev:190 -> linux:182 (KEY_REDO) -> qnum:138
    0x5d,  // xorgevdev:191 -> linux:183 (KEY_F13) -> qnum:93
    0x5e,  // xorgevdev:192 -> linux:184 (KEY_F14) -> qnum:94
    0x5f,  // xorgevdev:193 -> linux:185 (KEY_F15) -> qnum:95
    0x55,  // xorgevdev:194 -> linux:186 (KEY_F16) -> qnum:85
    0x83,  // xorgevdev:195 -> linux:187 (KEY_F17) -> qnum:131
    0xf7,  // xorgevdev:196 -> linux:188 (KEY_F18) -> qnum:247
    0x84,  // xorgevdev:197 -> linux:189 (KEY_F19) -> qnum:132
    0x5a,  // xorgevdev:198 -> linux:190 (KEY_F20) -> qnum:90
    0x74,  // xorgevdev:199 -> linux:191 (KEY_F21) -> qnum:116
    0xf9,  // xorgevdev:200 -> linux:192 (KEY_F22) -> qnum:249
    0x6d,  // xorgevdev:201 -> linux:193 (KEY_F23) -> qnum:109
    0x6f,  // xorgevdev:202 -> linux:194 (KEY_F24) -> qnum:111
    0x95,  // xorgevdev:203 -> linux:195 (unnamed) -> qnum:149
    0x96,  // xorgevdev:204 -> linux:196 (unnamed) -> qnum:150
    0x9a,  // xorgevdev:205 -> linux:197 (unnamed) -> qnum:154
    0x9b,  // xorgevdev:206 -> linux:198 (unnamed) -> qnum:155
    0xa7,  // xorgevdev:207 -> linux:199 (unnamed) -> qnum:167
    0xa8,  // xorgevdev:208 -> linux:200 (KEY_PLAYCD) -> qnum:168
    0xa9,  // xorgevdev:209 -> linux:201 (KEY_PAUSECD) -> qnum:169
    0xab,  // xorgevdev:210 -> linux:202 (KEY_PROG3) -> qnum:171
    0xac,  // xorgevdev:211 -> linux:203 (KEY_PROG4) -> qnum:172
    0xad,  // xorgevdev:212 -> linux:204 (KEY_DASHBOARD) -> qnum:173
    0xa5,  // xorgevdev:213 -> linux:205 (KEY_SUSPEND) -> qnum:165
    0xaf,  // xorgevdev:214 -> linux:206 (KEY_CLOSE) -> qnum:175
    0xb3,  // xorgevdev:215 -> linux:207 (KEY_PLAY) -> qnum:179
    0xb4,  // xorgevdev:216 -> linux:208 (KEY_FASTFORWARD) -> qnum:180
    0xb6,  // xorgevdev:217 -> linux:209 (KEY_BASSBOOST) -> qnum:182
    0xb9,  // xorgevdev:218 -> linux:210 (KEY_PRINT) -> qnum:185
    0xba,  // xorgevdev:219 -> linux:211 (KEY_HP) -> qnum:186
    0xbb,  // xorgevdev:220 -> linux:212 (KEY_CAMERA) -> qnum:187
    0xbd,  // xorgevdev:221 -> linux:213 (KEY_SOUND) -> qnum:189
    0xbe,  // xorgevdev:222 -> linux:214 (KEY_QUESTION) -> qnum:190
    0xbf,  // xorgevdev:223 -> linux:215 (KEY_EMAIL) -> qnum:191
    0xc0,  // xorgevdev:224 -> linux:216 (KEY_CHAT) -> qnum:192
    0xe5,  // xorgevdev:225 -> linux:217 (KEY_SEARCH) -> qnum:229
    0xc2,  // xorgevdev:226 -> linux:218 (KEY_CONNECT) -> qnum:194
    0xc3,  // xorgevdev:227 -> linux:219 (KEY_FINANCE) -> qnum:195
    0xc4,  // xorgevdev:228 -> linux:220 (KEY_SPORT) -> qnum:196
    0xc5,  // xorgevdev:229 -> linux:221 (KEY_SHOP) -> qnum:197
    0x94,  // xorgevdev:230 -> linux:222 (KEY_ALTERASE) -> qnum:148
    0xca,  // xorgevdev:231 -> linux:223 (KEY_CANCEL) -> qnum:202
    0xcc,  // xorgevdev:232 -> linux:224 (KEY_BRIGHTNESSDOWN) -> qnum:204
    0xd4,  // xorgevdev:233 -> linux:225 (KEY_BRIGHTNESSUP) -> qnum:212
    0xed,  // xorgevdev:234 -> linux:226 (KEY_MEDIA) -> qnum:237
    0xd6,  // xorgevdev:235 -> linux:227 (KEY_SWITCHVIDEOMODE) -> qnum:214
    0xd7,  // xorgevdev:236 -> linux:228 (KEY_KBDILLUMTOGGLE) -> qnum:215
    0xd8,  // xorgevdev:237 -> linux:229 (KEY_KBDILLUMDOWN) -> qnum:216
    0xd9,  // xorgevdev:238 -> linux:230 (KEY_KBDILLUMUP) -> qnum:217
    0xda,  // xorgevdev:239 -> linux:231 (KEY_SEND) -> qnum:218
    0xe4,  // xorgevdev:240 -> linux:232 (KEY_REPLY) -> qnum:228
    0x8e,  // xorgevdev:241 -> linux:233 (KEY_FORWARDMAIL) -> qnum:142
    0xd5,  // xorgevdev:242 -> linux:234 (KEY_SAVE) -> qnum:213
    0xf0,  // xorgevdev:243 -> linux:235 (KEY_DOCUMENTS) -> qnum:240
    0xf1,  // xorgevdev:244 -> linux:236 (KEY_BATTERY) -> qnum:241
    0xf2,  // xorgevdev:245 -> linux:237 (KEY_BLUETOOTH) -> qnum:242
    0xf3,  // xorgevdev:246 -> linux:238 (KEY_WLAN) -> qnum:243
    0xf4   // xorgevdev:247 -> linux:239 (KEY_UWB) -> qnum:244
  };

  private Keycodes() {}
}
