// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package emrserverlessiface provides an interface to enable mocking the EMR Serverless service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package emrserverlessiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/emrserverless"
)

// EMRServerlessAPI provides an interface to enable mocking the
// emrserverless.EMRServerless service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// EMR Serverless.
//	func myFunc(svc emrserverlessiface.EMRServerlessAPI) bool {
//	    // Make svc.CancelJobRun request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := emrserverless.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockEMRServerlessClient struct {
//	    emrserverlessiface.EMRServerlessAPI
//	}
//	func (m *mockEMRServerlessClient) CancelJobRun(input *emrserverless.CancelJobRunInput) (*emrserverless.CancelJobRunOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockEMRServerlessClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type EMRServerlessAPI interface {
	CancelJobRun(*emrserverless.CancelJobRunInput) (*emrserverless.CancelJobRunOutput, error)
	CancelJobRunWithContext(aws.Context, *emrserverless.CancelJobRunInput, ...request.Option) (*emrserverless.CancelJobRunOutput, error)
	CancelJobRunRequest(*emrserverless.CancelJobRunInput) (*request.Request, *emrserverless.CancelJobRunOutput)

	CreateApplication(*emrserverless.CreateApplicationInput) (*emrserverless.CreateApplicationOutput, error)
	CreateApplicationWithContext(aws.Context, *emrserverless.CreateApplicationInput, ...request.Option) (*emrserverless.CreateApplicationOutput, error)
	CreateApplicationRequest(*emrserverless.CreateApplicationInput) (*request.Request, *emrserverless.CreateApplicationOutput)

	DeleteApplication(*emrserverless.DeleteApplicationInput) (*emrserverless.DeleteApplicationOutput, error)
	DeleteApplicationWithContext(aws.Context, *emrserverless.DeleteApplicationInput, ...request.Option) (*emrserverless.DeleteApplicationOutput, error)
	DeleteApplicationRequest(*emrserverless.DeleteApplicationInput) (*request.Request, *emrserverless.DeleteApplicationOutput)

	GetApplication(*emrserverless.GetApplicationInput) (*emrserverless.GetApplicationOutput, error)
	GetApplicationWithContext(aws.Context, *emrserverless.GetApplicationInput, ...request.Option) (*emrserverless.GetApplicationOutput, error)
	GetApplicationRequest(*emrserverless.GetApplicationInput) (*request.Request, *emrserverless.GetApplicationOutput)

	GetDashboardForJobRun(*emrserverless.GetDashboardForJobRunInput) (*emrserverless.GetDashboardForJobRunOutput, error)
	GetDashboardForJobRunWithContext(aws.Context, *emrserverless.GetDashboardForJobRunInput, ...request.Option) (*emrserverless.GetDashboardForJobRunOutput, error)
	GetDashboardForJobRunRequest(*emrserverless.GetDashboardForJobRunInput) (*request.Request, *emrserverless.GetDashboardForJobRunOutput)

	GetJobRun(*emrserverless.GetJobRunInput) (*emrserverless.GetJobRunOutput, error)
	GetJobRunWithContext(aws.Context, *emrserverless.GetJobRunInput, ...request.Option) (*emrserverless.GetJobRunOutput, error)
	GetJobRunRequest(*emrserverless.GetJobRunInput) (*request.Request, *emrserverless.GetJobRunOutput)

	ListApplications(*emrserverless.ListApplicationsInput) (*emrserverless.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *emrserverless.ListApplicationsInput, ...request.Option) (*emrserverless.ListApplicationsOutput, error)
	ListApplicationsRequest(*emrserverless.ListApplicationsInput) (*request.Request, *emrserverless.ListApplicationsOutput)

	ListApplicationsPages(*emrserverless.ListApplicationsInput, func(*emrserverless.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *emrserverless.ListApplicationsInput, func(*emrserverless.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListJobRunAttempts(*emrserverless.ListJobRunAttemptsInput) (*emrserverless.ListJobRunAttemptsOutput, error)
	ListJobRunAttemptsWithContext(aws.Context, *emrserverless.ListJobRunAttemptsInput, ...request.Option) (*emrserverless.ListJobRunAttemptsOutput, error)
	ListJobRunAttemptsRequest(*emrserverless.ListJobRunAttemptsInput) (*request.Request, *emrserverless.ListJobRunAttemptsOutput)

	ListJobRunAttemptsPages(*emrserverless.ListJobRunAttemptsInput, func(*emrserverless.ListJobRunAttemptsOutput, bool) bool) error
	ListJobRunAttemptsPagesWithContext(aws.Context, *emrserverless.ListJobRunAttemptsInput, func(*emrserverless.ListJobRunAttemptsOutput, bool) bool, ...request.Option) error

	ListJobRuns(*emrserverless.ListJobRunsInput) (*emrserverless.ListJobRunsOutput, error)
	ListJobRunsWithContext(aws.Context, *emrserverless.ListJobRunsInput, ...request.Option) (*emrserverless.ListJobRunsOutput, error)
	ListJobRunsRequest(*emrserverless.ListJobRunsInput) (*request.Request, *emrserverless.ListJobRunsOutput)

	ListJobRunsPages(*emrserverless.ListJobRunsInput, func(*emrserverless.ListJobRunsOutput, bool) bool) error
	ListJobRunsPagesWithContext(aws.Context, *emrserverless.ListJobRunsInput, func(*emrserverless.ListJobRunsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*emrserverless.ListTagsForResourceInput) (*emrserverless.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *emrserverless.ListTagsForResourceInput, ...request.Option) (*emrserverless.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*emrserverless.ListTagsForResourceInput) (*request.Request, *emrserverless.ListTagsForResourceOutput)

	StartApplication(*emrserverless.StartApplicationInput) (*emrserverless.StartApplicationOutput, error)
	StartApplicationWithContext(aws.Context, *emrserverless.StartApplicationInput, ...request.Option) (*emrserverless.StartApplicationOutput, error)
	StartApplicationRequest(*emrserverless.StartApplicationInput) (*request.Request, *emrserverless.StartApplicationOutput)

	StartJobRun(*emrserverless.StartJobRunInput) (*emrserverless.StartJobRunOutput, error)
	StartJobRunWithContext(aws.Context, *emrserverless.StartJobRunInput, ...request.Option) (*emrserverless.StartJobRunOutput, error)
	StartJobRunRequest(*emrserverless.StartJobRunInput) (*request.Request, *emrserverless.StartJobRunOutput)

	StopApplication(*emrserverless.StopApplicationInput) (*emrserverless.StopApplicationOutput, error)
	StopApplicationWithContext(aws.Context, *emrserverless.StopApplicationInput, ...request.Option) (*emrserverless.StopApplicationOutput, error)
	StopApplicationRequest(*emrserverless.StopApplicationInput) (*request.Request, *emrserverless.StopApplicationOutput)

	TagResource(*emrserverless.TagResourceInput) (*emrserverless.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *emrserverless.TagResourceInput, ...request.Option) (*emrserverless.TagResourceOutput, error)
	TagResourceRequest(*emrserverless.TagResourceInput) (*request.Request, *emrserverless.TagResourceOutput)

	UntagResource(*emrserverless.UntagResourceInput) (*emrserverless.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *emrserverless.UntagResourceInput, ...request.Option) (*emrserverless.UntagResourceOutput, error)
	UntagResourceRequest(*emrserverless.UntagResourceInput) (*request.Request, *emrserverless.UntagResourceOutput)

	UpdateApplication(*emrserverless.UpdateApplicationInput) (*emrserverless.UpdateApplicationOutput, error)
	UpdateApplicationWithContext(aws.Context, *emrserverless.UpdateApplicationInput, ...request.Option) (*emrserverless.UpdateApplicationOutput, error)
	UpdateApplicationRequest(*emrserverless.UpdateApplicationInput) (*request.Request, *emrserverless.UpdateApplicationOutput)
}

var _ EMRServerlessAPI = (*emrserverless.EMRServerless)(nil)
