<!--
  -- Thanks for filing a `petgraph` issue! Fill out the appropriate template
  -- below. We appreciate it :)
  -->

<!-- ************************ BUG REPORTS *************************** -->

### Test Case

Insert your test case here, ideally in the form of Rust code that creates a
graph.

### Steps To Reproduce

Insert instructions for reproducing the bug with the above test case:

* First, ...
* Then, ...
* ...

Bonus points if these STR are in the form of a `#[test]` that demonstrates the
bug, and can be used as a regression test once the bug is fixed

### Actual Results

Insert a panic backtrace here, or wrong answer, or whatever.

### Expected Results

The correct result / behavior that you expect when following the STR with the
test case. Maybe a `None` returned instead of a panic, or some node A instead of
the node B that was returned.

<!-- ************************ FEATURE REQUESTS ************************ -->

### Summary

A couple sentence summary of the requested feature.

### Motivation

What does adding this feature enable that isn't possible without it? Does it
improve performance? Turn dynamic checks into statically enforced properties?
Explain why this feature should be implemented.

### Details

* What code needs to change? New traits? Which modules?

* Is this a new graph algorithm? Include links to papers, Wikipedia, or other
  implementations of this algorithm that exist.

* Are you willing to implement this yourself? Mentor someone else and help them
  implement it?
