//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLAccelerationStructureUsage(pub NSUInteger);
bitflags::bitflags! {
    impl MTLAccelerationStructureUsage: NSUInteger {
        #[doc(alias = "MTLAccelerationStructureUsageNone")]
        const None = 0;
        #[doc(alias = "MTLAccelerationStructureUsageRefit")]
        const Refit = 1<<0;
        #[doc(alias = "MTLAccelerationStructureUsagePreferFastBuild")]
        const PreferFastBuild = 1<<1;
        #[doc(alias = "MTLAccelerationStructureUsageExtendedLimits")]
        const ExtendedLimits = 1<<2;
    }
}

unsafe impl Encode for MTLAccelerationStructureUsage {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLAccelerationStructureUsage {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLAccelerationStructureInstanceOptions(pub u32);
bitflags::bitflags! {
    impl MTLAccelerationStructureInstanceOptions: u32 {
        const MTLAccelerationStructureInstanceOptionNone = 0;
        const MTLAccelerationStructureInstanceOptionDisableTriangleCulling = 1<<0;
        const MTLAccelerationStructureInstanceOptionTriangleFrontFacingWindingCounterClockwise = 1<<1;
        const MTLAccelerationStructureInstanceOptionOpaque = 1<<2;
        const MTLAccelerationStructureInstanceOptionNonOpaque = 1<<3;
    }
}

unsafe impl Encode for MTLAccelerationStructureInstanceOptions {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for MTLAccelerationStructureInstanceOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureDescriptor {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureDescriptor {
        #[method(usage)]
        pub unsafe fn usage(&self) -> MTLAccelerationStructureUsage;

        #[method(setUsage:)]
        pub unsafe fn setUsage(&self, usage: MTLAccelerationStructureUsage);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureGeometryDescriptor {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureGeometryDescriptor {
        #[method(intersectionFunctionTableOffset)]
        pub unsafe fn intersectionFunctionTableOffset(&self) -> NSUInteger;

        #[method(setIntersectionFunctionTableOffset:)]
        pub fn setIntersectionFunctionTableOffset(
            &self,
            intersection_function_table_offset: NSUInteger,
        );

        #[method(opaque)]
        pub unsafe fn opaque(&self) -> bool;

        #[method(setOpaque:)]
        pub unsafe fn setOpaque(&self, opaque: bool);

        #[method(allowDuplicateIntersectionFunctionInvocation)]
        pub unsafe fn allowDuplicateIntersectionFunctionInvocation(&self) -> bool;

        #[method(setAllowDuplicateIntersectionFunctionInvocation:)]
        pub unsafe fn setAllowDuplicateIntersectionFunctionInvocation(
            &self,
            allow_duplicate_intersection_function_invocation: bool,
        );

        #[method_id(@__retain_semantics Other label)]
        pub unsafe fn label(&self) -> Option<Retained<NSString>>;

        #[method(setLabel:)]
        pub unsafe fn setLabel(&self, label: Option<&NSString>);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other primitiveDataBuffer)]
        pub unsafe fn primitiveDataBuffer(&self)
            -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setPrimitiveDataBuffer:)]
        pub fn setPrimitiveDataBuffer(
            &self,
            primitive_data_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(primitiveDataBufferOffset)]
        pub unsafe fn primitiveDataBufferOffset(&self) -> NSUInteger;

        #[method(setPrimitiveDataBufferOffset:)]
        pub unsafe fn setPrimitiveDataBufferOffset(&self, primitive_data_buffer_offset: NSUInteger);

        #[method(primitiveDataStride)]
        pub unsafe fn primitiveDataStride(&self) -> NSUInteger;

        #[method(setPrimitiveDataStride:)]
        pub fn setPrimitiveDataStride(&self, primitive_data_stride: NSUInteger);

        #[method(primitiveDataElementSize)]
        pub unsafe fn primitiveDataElementSize(&self) -> NSUInteger;

        #[method(setPrimitiveDataElementSize:)]
        pub fn setPrimitiveDataElementSize(&self, primitive_data_element_size: NSUInteger);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLMotionBorderMode(pub u32);
impl MTLMotionBorderMode {
    #[doc(alias = "MTLMotionBorderModeClamp")]
    pub const Clamp: Self = Self(0);
    #[doc(alias = "MTLMotionBorderModeVanish")]
    pub const Vanish: Self = Self(1);
}

unsafe impl Encode for MTLMotionBorderMode {
    const ENCODING: Encoding = u32::ENCODING;
}

unsafe impl RefEncode for MTLMotionBorderMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLPrimitiveAccelerationStructureDescriptor;

    unsafe impl ClassType for MTLPrimitiveAccelerationStructureDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLPrimitiveAccelerationStructureDescriptor {}

unsafe impl NSObjectProtocol for MTLPrimitiveAccelerationStructureDescriptor {}

extern_methods!(
    unsafe impl MTLPrimitiveAccelerationStructureDescriptor {
        #[method_id(@__retain_semantics Other geometryDescriptors)]
        pub unsafe fn geometryDescriptors(
            &self,
        ) -> Option<Retained<NSArray<MTLAccelerationStructureGeometryDescriptor>>>;

        #[method(setGeometryDescriptors:)]
        pub fn setGeometryDescriptors(
            &self,
            geometry_descriptors: Option<&NSArray<MTLAccelerationStructureGeometryDescriptor>>,
        );

        #[method(motionStartBorderMode)]
        pub unsafe fn motionStartBorderMode(&self) -> MTLMotionBorderMode;

        #[method(setMotionStartBorderMode:)]
        pub unsafe fn setMotionStartBorderMode(
            &self,
            motion_start_border_mode: MTLMotionBorderMode,
        );

        #[method(motionEndBorderMode)]
        pub unsafe fn motionEndBorderMode(&self) -> MTLMotionBorderMode;

        #[method(setMotionEndBorderMode:)]
        pub unsafe fn setMotionEndBorderMode(&self, motion_end_border_mode: MTLMotionBorderMode);

        #[method(motionStartTime)]
        pub unsafe fn motionStartTime(&self) -> c_float;

        #[method(setMotionStartTime:)]
        pub unsafe fn setMotionStartTime(&self, motion_start_time: c_float);

        #[method(motionEndTime)]
        pub unsafe fn motionEndTime(&self) -> c_float;

        #[method(setMotionEndTime:)]
        pub unsafe fn setMotionEndTime(&self, motion_end_time: c_float);

        #[method(motionKeyframeCount)]
        pub unsafe fn motionKeyframeCount(&self) -> NSUInteger;

        #[method(setMotionKeyframeCount:)]
        pub unsafe fn setMotionKeyframeCount(&self, motion_keyframe_count: NSUInteger);

        #[method_id(@__retain_semantics Other descriptor)]
        pub fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLPrimitiveAccelerationStructureDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureTriangleGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureTriangleGeometryDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureGeometryDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureTriangleGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureTriangleGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureTriangleGeometryDescriptor {
        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other vertexBuffer)]
        pub unsafe fn vertexBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setVertexBuffer:)]
        pub fn setVertexBuffer(&self, vertex_buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(vertexBufferOffset)]
        pub unsafe fn vertexBufferOffset(&self) -> NSUInteger;

        #[method(setVertexBufferOffset:)]
        pub unsafe fn setVertexBufferOffset(&self, vertex_buffer_offset: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(vertexFormat)]
        pub unsafe fn vertexFormat(&self) -> MTLAttributeFormat;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setVertexFormat:)]
        pub unsafe fn setVertexFormat(&self, vertex_format: MTLAttributeFormat);

        #[method(vertexStride)]
        pub unsafe fn vertexStride(&self) -> NSUInteger;

        #[method(setVertexStride:)]
        pub fn setVertexStride(&self, vertex_stride: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other indexBuffer)]
        pub unsafe fn indexBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setIndexBuffer:)]
        pub fn setIndexBuffer(&self, index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(indexBufferOffset)]
        pub unsafe fn indexBufferOffset(&self) -> NSUInteger;

        #[method(setIndexBufferOffset:)]
        pub unsafe fn setIndexBufferOffset(&self, index_buffer_offset: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(indexType)]
        pub unsafe fn indexType(&self) -> MTLIndexType;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setIndexType:)]
        pub unsafe fn setIndexType(&self, index_type: MTLIndexType);

        #[method(triangleCount)]
        pub unsafe fn triangleCount(&self) -> NSUInteger;

        #[method(setTriangleCount:)]
        pub fn setTriangleCount(&self, triangle_count: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other transformationMatrixBuffer)]
        pub unsafe fn transformationMatrixBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setTransformationMatrixBuffer:)]
        pub unsafe fn setTransformationMatrixBuffer(
            &self,
            transformation_matrix_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(transformationMatrixBufferOffset)]
        pub unsafe fn transformationMatrixBufferOffset(&self) -> NSUInteger;

        #[method(setTransformationMatrixBufferOffset:)]
        pub unsafe fn setTransformationMatrixBufferOffset(
            &self,
            transformation_matrix_buffer_offset: NSUInteger,
        );

        #[method_id(@__retain_semantics Other descriptor)]
        pub fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureTriangleGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureBoundingBoxGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureBoundingBoxGeometryDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureGeometryDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureBoundingBoxGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureBoundingBoxGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureBoundingBoxGeometryDescriptor {
        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other boundingBoxBuffer)]
        pub unsafe fn boundingBoxBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setBoundingBoxBuffer:)]
        pub fn setBoundingBoxBuffer(
            &self,
            bounding_box_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(boundingBoxBufferOffset)]
        pub unsafe fn boundingBoxBufferOffset(&self) -> NSUInteger;

        #[method(setBoundingBoxBufferOffset:)]
        pub unsafe fn setBoundingBoxBufferOffset(&self, bounding_box_buffer_offset: NSUInteger);

        #[method(boundingBoxStride)]
        pub unsafe fn boundingBoxStride(&self) -> NSUInteger;

        #[method(setBoundingBoxStride:)]
        pub unsafe fn setBoundingBoxStride(&self, bounding_box_stride: NSUInteger);

        #[method(boundingBoxCount)]
        pub unsafe fn boundingBoxCount(&self) -> NSUInteger;

        #[method(setBoundingBoxCount:)]
        pub fn setBoundingBoxCount(&self, bounding_box_count: NSUInteger);

        #[method_id(@__retain_semantics Other descriptor)]
        pub fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureBoundingBoxGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLMotionKeyframeData;

    unsafe impl ClassType for MTLMotionKeyframeData {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSObjectProtocol for MTLMotionKeyframeData {}

extern_methods!(
    unsafe impl MTLMotionKeyframeData {
        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other buffer)]
        pub unsafe fn buffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setBuffer:)]
        pub unsafe fn setBuffer(&self, buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(offset)]
        pub unsafe fn offset(&self) -> NSUInteger;

        #[method(setOffset:)]
        pub unsafe fn setOffset(&self, offset: NSUInteger);

        #[method_id(@__retain_semantics Other data)]
        pub unsafe fn data() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLMotionKeyframeData {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureMotionTriangleGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureMotionTriangleGeometryDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureGeometryDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureMotionTriangleGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureMotionTriangleGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureMotionTriangleGeometryDescriptor {
        #[method_id(@__retain_semantics Other vertexBuffers)]
        pub unsafe fn vertexBuffers(&self) -> Retained<NSArray<MTLMotionKeyframeData>>;

        #[method(setVertexBuffers:)]
        pub unsafe fn setVertexBuffers(&self, vertex_buffers: &NSArray<MTLMotionKeyframeData>);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(vertexFormat)]
        pub unsafe fn vertexFormat(&self) -> MTLAttributeFormat;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setVertexFormat:)]
        pub unsafe fn setVertexFormat(&self, vertex_format: MTLAttributeFormat);

        #[method(vertexStride)]
        pub unsafe fn vertexStride(&self) -> NSUInteger;

        #[method(setVertexStride:)]
        pub unsafe fn setVertexStride(&self, vertex_stride: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other indexBuffer)]
        pub unsafe fn indexBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setIndexBuffer:)]
        pub unsafe fn setIndexBuffer(&self, index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(indexBufferOffset)]
        pub unsafe fn indexBufferOffset(&self) -> NSUInteger;

        #[method(setIndexBufferOffset:)]
        pub unsafe fn setIndexBufferOffset(&self, index_buffer_offset: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(indexType)]
        pub unsafe fn indexType(&self) -> MTLIndexType;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setIndexType:)]
        pub unsafe fn setIndexType(&self, index_type: MTLIndexType);

        #[method(triangleCount)]
        pub unsafe fn triangleCount(&self) -> NSUInteger;

        #[method(setTriangleCount:)]
        pub unsafe fn setTriangleCount(&self, triangle_count: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other transformationMatrixBuffer)]
        pub unsafe fn transformationMatrixBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setTransformationMatrixBuffer:)]
        pub unsafe fn setTransformationMatrixBuffer(
            &self,
            transformation_matrix_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(transformationMatrixBufferOffset)]
        pub unsafe fn transformationMatrixBufferOffset(&self) -> NSUInteger;

        #[method(setTransformationMatrixBufferOffset:)]
        pub unsafe fn setTransformationMatrixBufferOffset(
            &self,
            transformation_matrix_buffer_offset: NSUInteger,
        );

        #[method_id(@__retain_semantics Other descriptor)]
        pub unsafe fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureMotionTriangleGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureGeometryDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor {
        #[method_id(@__retain_semantics Other boundingBoxBuffers)]
        pub unsafe fn boundingBoxBuffers(&self) -> Retained<NSArray<MTLMotionKeyframeData>>;

        #[method(setBoundingBoxBuffers:)]
        pub unsafe fn setBoundingBoxBuffers(
            &self,
            bounding_box_buffers: &NSArray<MTLMotionKeyframeData>,
        );

        #[method(boundingBoxStride)]
        pub unsafe fn boundingBoxStride(&self) -> NSUInteger;

        #[method(setBoundingBoxStride:)]
        pub unsafe fn setBoundingBoxStride(&self, bounding_box_stride: NSUInteger);

        #[method(boundingBoxCount)]
        pub unsafe fn boundingBoxCount(&self) -> NSUInteger;

        #[method(setBoundingBoxCount:)]
        pub unsafe fn setBoundingBoxCount(&self, bounding_box_count: NSUInteger);

        #[method_id(@__retain_semantics Other descriptor)]
        pub unsafe fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureMotionBoundingBoxGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCurveType(pub NSInteger);
impl MTLCurveType {
    #[doc(alias = "MTLCurveTypeRound")]
    pub const Round: Self = Self(0);
    #[doc(alias = "MTLCurveTypeFlat")]
    pub const Flat: Self = Self(1);
}

unsafe impl Encode for MTLCurveType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLCurveType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCurveBasis(pub NSInteger);
impl MTLCurveBasis {
    #[doc(alias = "MTLCurveBasisBSpline")]
    pub const BSpline: Self = Self(0);
    #[doc(alias = "MTLCurveBasisCatmullRom")]
    pub const CatmullRom: Self = Self(1);
    #[doc(alias = "MTLCurveBasisLinear")]
    pub const Linear: Self = Self(2);
    #[doc(alias = "MTLCurveBasisBezier")]
    pub const Bezier: Self = Self(3);
}

unsafe impl Encode for MTLCurveBasis {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLCurveBasis {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCurveEndCaps(pub NSInteger);
impl MTLCurveEndCaps {
    #[doc(alias = "MTLCurveEndCapsNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "MTLCurveEndCapsDisk")]
    pub const Disk: Self = Self(1);
    #[doc(alias = "MTLCurveEndCapsSphere")]
    pub const Sphere: Self = Self(2);
}

unsafe impl Encode for MTLCurveEndCaps {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLCurveEndCaps {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureCurveGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureCurveGeometryDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureGeometryDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureCurveGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureCurveGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureCurveGeometryDescriptor {
        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other controlPointBuffer)]
        pub unsafe fn controlPointBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setControlPointBuffer:)]
        pub unsafe fn setControlPointBuffer(
            &self,
            control_point_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(controlPointBufferOffset)]
        pub unsafe fn controlPointBufferOffset(&self) -> NSUInteger;

        #[method(setControlPointBufferOffset:)]
        pub unsafe fn setControlPointBufferOffset(&self, control_point_buffer_offset: NSUInteger);

        #[method(controlPointCount)]
        pub unsafe fn controlPointCount(&self) -> NSUInteger;

        #[method(setControlPointCount:)]
        pub unsafe fn setControlPointCount(&self, control_point_count: NSUInteger);

        #[method(controlPointStride)]
        pub unsafe fn controlPointStride(&self) -> NSUInteger;

        #[method(setControlPointStride:)]
        pub unsafe fn setControlPointStride(&self, control_point_stride: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(controlPointFormat)]
        pub unsafe fn controlPointFormat(&self) -> MTLAttributeFormat;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setControlPointFormat:)]
        pub unsafe fn setControlPointFormat(&self, control_point_format: MTLAttributeFormat);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other radiusBuffer)]
        pub unsafe fn radiusBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setRadiusBuffer:)]
        pub unsafe fn setRadiusBuffer(&self, radius_buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(radiusBufferOffset)]
        pub unsafe fn radiusBufferOffset(&self) -> NSUInteger;

        #[method(setRadiusBufferOffset:)]
        pub unsafe fn setRadiusBufferOffset(&self, radius_buffer_offset: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(radiusFormat)]
        pub unsafe fn radiusFormat(&self) -> MTLAttributeFormat;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setRadiusFormat:)]
        pub unsafe fn setRadiusFormat(&self, radius_format: MTLAttributeFormat);

        #[method(radiusStride)]
        pub unsafe fn radiusStride(&self) -> NSUInteger;

        #[method(setRadiusStride:)]
        pub unsafe fn setRadiusStride(&self, radius_stride: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other indexBuffer)]
        pub unsafe fn indexBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setIndexBuffer:)]
        pub unsafe fn setIndexBuffer(&self, index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(indexBufferOffset)]
        pub unsafe fn indexBufferOffset(&self) -> NSUInteger;

        #[method(setIndexBufferOffset:)]
        pub unsafe fn setIndexBufferOffset(&self, index_buffer_offset: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(indexType)]
        pub unsafe fn indexType(&self) -> MTLIndexType;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setIndexType:)]
        pub unsafe fn setIndexType(&self, index_type: MTLIndexType);

        #[method(segmentCount)]
        pub unsafe fn segmentCount(&self) -> NSUInteger;

        #[method(setSegmentCount:)]
        pub unsafe fn setSegmentCount(&self, segment_count: NSUInteger);

        #[method(segmentControlPointCount)]
        pub unsafe fn segmentControlPointCount(&self) -> NSUInteger;

        #[method(setSegmentControlPointCount:)]
        pub unsafe fn setSegmentControlPointCount(&self, segment_control_point_count: NSUInteger);

        #[method(curveType)]
        pub unsafe fn curveType(&self) -> MTLCurveType;

        #[method(setCurveType:)]
        pub unsafe fn setCurveType(&self, curve_type: MTLCurveType);

        #[method(curveBasis)]
        pub unsafe fn curveBasis(&self) -> MTLCurveBasis;

        #[method(setCurveBasis:)]
        pub unsafe fn setCurveBasis(&self, curve_basis: MTLCurveBasis);

        #[method(curveEndCaps)]
        pub unsafe fn curveEndCaps(&self) -> MTLCurveEndCaps;

        #[method(setCurveEndCaps:)]
        pub unsafe fn setCurveEndCaps(&self, curve_end_caps: MTLCurveEndCaps);

        #[method_id(@__retain_semantics Other descriptor)]
        pub unsafe fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureCurveGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLAccelerationStructureMotionCurveGeometryDescriptor;

    unsafe impl ClassType for MTLAccelerationStructureMotionCurveGeometryDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureGeometryDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLAccelerationStructureMotionCurveGeometryDescriptor {}

unsafe impl NSObjectProtocol for MTLAccelerationStructureMotionCurveGeometryDescriptor {}

extern_methods!(
    unsafe impl MTLAccelerationStructureMotionCurveGeometryDescriptor {
        #[method_id(@__retain_semantics Other controlPointBuffers)]
        pub unsafe fn controlPointBuffers(&self) -> Retained<NSArray<MTLMotionKeyframeData>>;

        #[method(setControlPointBuffers:)]
        pub unsafe fn setControlPointBuffers(
            &self,
            control_point_buffers: &NSArray<MTLMotionKeyframeData>,
        );

        #[method(controlPointCount)]
        pub unsafe fn controlPointCount(&self) -> NSUInteger;

        #[method(setControlPointCount:)]
        pub unsafe fn setControlPointCount(&self, control_point_count: NSUInteger);

        #[method(controlPointStride)]
        pub unsafe fn controlPointStride(&self) -> NSUInteger;

        #[method(setControlPointStride:)]
        pub unsafe fn setControlPointStride(&self, control_point_stride: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(controlPointFormat)]
        pub unsafe fn controlPointFormat(&self) -> MTLAttributeFormat;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setControlPointFormat:)]
        pub unsafe fn setControlPointFormat(&self, control_point_format: MTLAttributeFormat);

        #[method_id(@__retain_semantics Other radiusBuffers)]
        pub unsafe fn radiusBuffers(&self) -> Retained<NSArray<MTLMotionKeyframeData>>;

        #[method(setRadiusBuffers:)]
        pub unsafe fn setRadiusBuffers(&self, radius_buffers: &NSArray<MTLMotionKeyframeData>);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(radiusFormat)]
        pub unsafe fn radiusFormat(&self) -> MTLAttributeFormat;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setRadiusFormat:)]
        pub unsafe fn setRadiusFormat(&self, radius_format: MTLAttributeFormat);

        #[method(radiusStride)]
        pub unsafe fn radiusStride(&self) -> NSUInteger;

        #[method(setRadiusStride:)]
        pub unsafe fn setRadiusStride(&self, radius_stride: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other indexBuffer)]
        pub unsafe fn indexBuffer(&self) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setIndexBuffer:)]
        pub unsafe fn setIndexBuffer(&self, index_buffer: Option<&ProtocolObject<dyn MTLBuffer>>);

        #[method(indexBufferOffset)]
        pub unsafe fn indexBufferOffset(&self) -> NSUInteger;

        #[method(setIndexBufferOffset:)]
        pub unsafe fn setIndexBufferOffset(&self, index_buffer_offset: NSUInteger);

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(indexType)]
        pub unsafe fn indexType(&self) -> MTLIndexType;

        #[cfg(feature = "MTLStageInputOutputDescriptor")]
        #[method(setIndexType:)]
        pub unsafe fn setIndexType(&self, index_type: MTLIndexType);

        #[method(segmentCount)]
        pub unsafe fn segmentCount(&self) -> NSUInteger;

        #[method(setSegmentCount:)]
        pub unsafe fn setSegmentCount(&self, segment_count: NSUInteger);

        #[method(segmentControlPointCount)]
        pub unsafe fn segmentControlPointCount(&self) -> NSUInteger;

        #[method(setSegmentControlPointCount:)]
        pub unsafe fn setSegmentControlPointCount(&self, segment_control_point_count: NSUInteger);

        #[method(curveType)]
        pub unsafe fn curveType(&self) -> MTLCurveType;

        #[method(setCurveType:)]
        pub unsafe fn setCurveType(&self, curve_type: MTLCurveType);

        #[method(curveBasis)]
        pub unsafe fn curveBasis(&self) -> MTLCurveBasis;

        #[method(setCurveBasis:)]
        pub unsafe fn setCurveBasis(&self, curve_basis: MTLCurveBasis);

        #[method(curveEndCaps)]
        pub unsafe fn curveEndCaps(&self) -> MTLCurveEndCaps;

        #[method(setCurveEndCaps:)]
        pub unsafe fn setCurveEndCaps(&self, curve_end_caps: MTLCurveEndCaps);

        #[method_id(@__retain_semantics Other descriptor)]
        pub unsafe fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLAccelerationStructureMotionCurveGeometryDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

#[cfg(feature = "MTLAccelerationStructureTypes")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLAccelerationStructureInstanceDescriptor {
    pub transformationMatrix: MTLPackedFloat4x3,
    pub options: MTLAccelerationStructureInstanceOptions,
    pub mask: u32,
    pub intersectionFunctionTableOffset: u32,
    pub accelerationStructureIndex: u32,
}

#[cfg(feature = "MTLAccelerationStructureTypes")]
unsafe impl Encode for MTLAccelerationStructureInstanceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <MTLPackedFloat4x3>::ENCODING,
            <MTLAccelerationStructureInstanceOptions>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "MTLAccelerationStructureTypes")]
unsafe impl RefEncode for MTLAccelerationStructureInstanceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "MTLAccelerationStructureTypes")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLAccelerationStructureUserIDInstanceDescriptor {
    pub transformationMatrix: MTLPackedFloat4x3,
    pub options: MTLAccelerationStructureInstanceOptions,
    pub mask: u32,
    pub intersectionFunctionTableOffset: u32,
    pub accelerationStructureIndex: u32,
    pub userID: u32,
}

#[cfg(feature = "MTLAccelerationStructureTypes")]
unsafe impl Encode for MTLAccelerationStructureUserIDInstanceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <MTLPackedFloat4x3>::ENCODING,
            <MTLAccelerationStructureInstanceOptions>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
        ],
    );
}

#[cfg(feature = "MTLAccelerationStructureTypes")]
unsafe impl RefEncode for MTLAccelerationStructureUserIDInstanceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLAccelerationStructureInstanceDescriptorType(pub NSUInteger);
impl MTLAccelerationStructureInstanceDescriptorType {
    #[doc(alias = "MTLAccelerationStructureInstanceDescriptorTypeDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "MTLAccelerationStructureInstanceDescriptorTypeUserID")]
    pub const UserID: Self = Self(1);
    #[doc(alias = "MTLAccelerationStructureInstanceDescriptorTypeMotion")]
    pub const Motion: Self = Self(2);
    #[doc(alias = "MTLAccelerationStructureInstanceDescriptorTypeIndirect")]
    pub const Indirect: Self = Self(3);
    #[doc(alias = "MTLAccelerationStructureInstanceDescriptorTypeIndirectMotion")]
    pub const IndirectMotion: Self = Self(4);
}

unsafe impl Encode for MTLAccelerationStructureInstanceDescriptorType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLAccelerationStructureInstanceDescriptorType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLAccelerationStructureMotionInstanceDescriptor {
    pub options: MTLAccelerationStructureInstanceOptions,
    pub mask: u32,
    pub intersectionFunctionTableOffset: u32,
    pub accelerationStructureIndex: u32,
    pub userID: u32,
    pub motionTransformsStartIndex: u32,
    pub motionTransformsCount: u32,
    pub motionStartBorderMode: MTLMotionBorderMode,
    pub motionEndBorderMode: MTLMotionBorderMode,
    pub motionStartTime: c_float,
    pub motionEndTime: c_float,
}

unsafe impl Encode for MTLAccelerationStructureMotionInstanceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <MTLAccelerationStructureInstanceOptions>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <MTLMotionBorderMode>::ENCODING,
            <MTLMotionBorderMode>::ENCODING,
            <c_float>::ENCODING,
            <c_float>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLAccelerationStructureMotionInstanceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(all(feature = "MTLAccelerationStructureTypes", feature = "MTLTypes"))]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLIndirectAccelerationStructureInstanceDescriptor {
    pub transformationMatrix: MTLPackedFloat4x3,
    pub options: MTLAccelerationStructureInstanceOptions,
    pub mask: u32,
    pub intersectionFunctionTableOffset: u32,
    pub userID: u32,
    pub accelerationStructureID: MTLResourceID,
}

#[cfg(all(feature = "MTLAccelerationStructureTypes", feature = "MTLTypes"))]
unsafe impl Encode for MTLIndirectAccelerationStructureInstanceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <MTLPackedFloat4x3>::ENCODING,
            <MTLAccelerationStructureInstanceOptions>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <MTLResourceID>::ENCODING,
        ],
    );
}

#[cfg(all(feature = "MTLAccelerationStructureTypes", feature = "MTLTypes"))]
unsafe impl RefEncode for MTLIndirectAccelerationStructureInstanceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(feature = "MTLTypes")]
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLIndirectAccelerationStructureMotionInstanceDescriptor {
    pub options: MTLAccelerationStructureInstanceOptions,
    pub mask: u32,
    pub intersectionFunctionTableOffset: u32,
    pub userID: u32,
    pub accelerationStructureID: MTLResourceID,
    pub motionTransformsStartIndex: u32,
    pub motionTransformsCount: u32,
    pub motionStartBorderMode: MTLMotionBorderMode,
    pub motionEndBorderMode: MTLMotionBorderMode,
    pub motionStartTime: c_float,
    pub motionEndTime: c_float,
}

#[cfg(feature = "MTLTypes")]
unsafe impl Encode for MTLIndirectAccelerationStructureMotionInstanceDescriptor {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <MTLAccelerationStructureInstanceOptions>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <MTLResourceID>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <MTLMotionBorderMode>::ENCODING,
            <MTLMotionBorderMode>::ENCODING,
            <c_float>::ENCODING,
            <c_float>::ENCODING,
        ],
    );
}

#[cfg(feature = "MTLTypes")]
unsafe impl RefEncode for MTLIndirectAccelerationStructureMotionInstanceDescriptor {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLInstanceAccelerationStructureDescriptor;

    unsafe impl ClassType for MTLInstanceAccelerationStructureDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLInstanceAccelerationStructureDescriptor {}

unsafe impl NSObjectProtocol for MTLInstanceAccelerationStructureDescriptor {}

extern_methods!(
    unsafe impl MTLInstanceAccelerationStructureDescriptor {
        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other instanceDescriptorBuffer)]
        pub unsafe fn instanceDescriptorBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setInstanceDescriptorBuffer:)]
        pub fn setInstanceDescriptorBuffer(
            &self,
            instance_descriptor_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(instanceDescriptorBufferOffset)]
        pub unsafe fn instanceDescriptorBufferOffset(&self) -> NSUInteger;

        #[method(setInstanceDescriptorBufferOffset:)]
        pub unsafe fn setInstanceDescriptorBufferOffset(
            &self,
            instance_descriptor_buffer_offset: NSUInteger,
        );

        #[method(instanceDescriptorStride)]
        pub unsafe fn instanceDescriptorStride(&self) -> NSUInteger;

        #[method(setInstanceDescriptorStride:)]
        pub unsafe fn setInstanceDescriptorStride(&self, instance_descriptor_stride: NSUInteger);

        #[method(instanceCount)]
        pub unsafe fn instanceCount(&self) -> NSUInteger;

        #[method(setInstanceCount:)]
        pub fn setInstanceCount(&self, instance_count: NSUInteger);

        #[cfg(feature = "MTLResource")]
        #[method_id(@__retain_semantics Other instancedAccelerationStructures)]
        pub unsafe fn instancedAccelerationStructures(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn MTLAccelerationStructure>>>>;

        #[cfg(feature = "MTLResource")]
        #[method(setInstancedAccelerationStructures:)]
        pub fn setInstancedAccelerationStructures(
            &self,
            instanced_acceleration_structures: Option<
                &NSArray<ProtocolObject<dyn MTLAccelerationStructure>>,
            >,
        );

        #[method(instanceDescriptorType)]
        pub unsafe fn instanceDescriptorType(
            &self,
        ) -> MTLAccelerationStructureInstanceDescriptorType;

        #[method(setInstanceDescriptorType:)]
        pub unsafe fn setInstanceDescriptorType(
            &self,
            instance_descriptor_type: MTLAccelerationStructureInstanceDescriptorType,
        );

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other motionTransformBuffer)]
        pub unsafe fn motionTransformBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setMotionTransformBuffer:)]
        pub unsafe fn setMotionTransformBuffer(
            &self,
            motion_transform_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(motionTransformBufferOffset)]
        pub unsafe fn motionTransformBufferOffset(&self) -> NSUInteger;

        #[method(setMotionTransformBufferOffset:)]
        pub unsafe fn setMotionTransformBufferOffset(
            &self,
            motion_transform_buffer_offset: NSUInteger,
        );

        #[method(motionTransformCount)]
        pub unsafe fn motionTransformCount(&self) -> NSUInteger;

        #[method(setMotionTransformCount:)]
        pub unsafe fn setMotionTransformCount(&self, motion_transform_count: NSUInteger);

        #[method_id(@__retain_semantics Other descriptor)]
        pub fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLInstanceAccelerationStructureDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLIndirectInstanceAccelerationStructureDescriptor;

    unsafe impl ClassType for MTLIndirectInstanceAccelerationStructureDescriptor {
        #[inherits(NSObject)]
        type Super = MTLAccelerationStructureDescriptor;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLIndirectInstanceAccelerationStructureDescriptor {}

unsafe impl NSObjectProtocol for MTLIndirectInstanceAccelerationStructureDescriptor {}

extern_methods!(
    unsafe impl MTLIndirectInstanceAccelerationStructureDescriptor {
        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other instanceDescriptorBuffer)]
        pub unsafe fn instanceDescriptorBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setInstanceDescriptorBuffer:)]
        pub unsafe fn setInstanceDescriptorBuffer(
            &self,
            instance_descriptor_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(instanceDescriptorBufferOffset)]
        pub unsafe fn instanceDescriptorBufferOffset(&self) -> NSUInteger;

        #[method(setInstanceDescriptorBufferOffset:)]
        pub unsafe fn setInstanceDescriptorBufferOffset(
            &self,
            instance_descriptor_buffer_offset: NSUInteger,
        );

        #[method(instanceDescriptorStride)]
        pub unsafe fn instanceDescriptorStride(&self) -> NSUInteger;

        #[method(setInstanceDescriptorStride:)]
        pub unsafe fn setInstanceDescriptorStride(&self, instance_descriptor_stride: NSUInteger);

        #[method(maxInstanceCount)]
        pub unsafe fn maxInstanceCount(&self) -> NSUInteger;

        #[method(setMaxInstanceCount:)]
        pub unsafe fn setMaxInstanceCount(&self, max_instance_count: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other instanceCountBuffer)]
        pub unsafe fn instanceCountBuffer(&self)
            -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setInstanceCountBuffer:)]
        pub unsafe fn setInstanceCountBuffer(
            &self,
            instance_count_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(instanceCountBufferOffset)]
        pub unsafe fn instanceCountBufferOffset(&self) -> NSUInteger;

        #[method(setInstanceCountBufferOffset:)]
        pub unsafe fn setInstanceCountBufferOffset(&self, instance_count_buffer_offset: NSUInteger);

        #[method(instanceDescriptorType)]
        pub unsafe fn instanceDescriptorType(
            &self,
        ) -> MTLAccelerationStructureInstanceDescriptorType;

        #[method(setInstanceDescriptorType:)]
        pub unsafe fn setInstanceDescriptorType(
            &self,
            instance_descriptor_type: MTLAccelerationStructureInstanceDescriptorType,
        );

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other motionTransformBuffer)]
        pub unsafe fn motionTransformBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setMotionTransformBuffer:)]
        pub unsafe fn setMotionTransformBuffer(
            &self,
            motion_transform_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(motionTransformBufferOffset)]
        pub unsafe fn motionTransformBufferOffset(&self) -> NSUInteger;

        #[method(setMotionTransformBufferOffset:)]
        pub unsafe fn setMotionTransformBufferOffset(
            &self,
            motion_transform_buffer_offset: NSUInteger,
        );

        #[method(maxMotionTransformCount)]
        pub unsafe fn maxMotionTransformCount(&self) -> NSUInteger;

        #[method(setMaxMotionTransformCount:)]
        pub unsafe fn setMaxMotionTransformCount(&self, max_motion_transform_count: NSUInteger);

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics Other motionTransformCountBuffer)]
        pub unsafe fn motionTransformCountBuffer(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method(setMotionTransformCountBuffer:)]
        pub unsafe fn setMotionTransformCountBuffer(
            &self,
            motion_transform_count_buffer: Option<&ProtocolObject<dyn MTLBuffer>>,
        );

        #[method(motionTransformCountBufferOffset)]
        pub unsafe fn motionTransformCountBufferOffset(&self) -> NSUInteger;

        #[method(setMotionTransformCountBufferOffset:)]
        pub unsafe fn setMotionTransformCountBufferOffset(
            &self,
            motion_transform_count_buffer_offset: NSUInteger,
        );

        #[method_id(@__retain_semantics Other descriptor)]
        pub unsafe fn descriptor() -> Retained<Self>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLIndirectInstanceAccelerationStructureDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_protocol!(
    #[cfg(feature = "MTLResource")]
    pub unsafe trait MTLAccelerationStructure: MTLResource + IsRetainable {
        #[method(size)]
        unsafe fn size(&self) -> NSUInteger;

        #[cfg(feature = "MTLTypes")]
        #[method(gpuResourceID)]
        unsafe fn gpuResourceID(&self) -> MTLResourceID;
    }

    #[cfg(feature = "MTLResource")]
    unsafe impl ProtocolType for dyn MTLAccelerationStructure {}
);
