// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssoadmin

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAttachCustomerManagedPolicyReferenceToPermissionSet = "AttachCustomerManagedPolicyReferenceToPermissionSet"

// AttachCustomerManagedPolicyReferenceToPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the AttachCustomerManagedPolicyReferenceToPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachCustomerManagedPolicyReferenceToPermissionSet for more information on using the AttachCustomerManagedPolicyReferenceToPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachCustomerManagedPolicyReferenceToPermissionSetRequest method.
//	req, resp := client.AttachCustomerManagedPolicyReferenceToPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet
func (c *SSOAdmin) AttachCustomerManagedPolicyReferenceToPermissionSetRequest(input *AttachCustomerManagedPolicyReferenceToPermissionSetInput) (req *request.Request, output *AttachCustomerManagedPolicyReferenceToPermissionSetOutput) {
	op := &request.Operation{
		Name:       opAttachCustomerManagedPolicyReferenceToPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachCustomerManagedPolicyReferenceToPermissionSetInput{}
	}

	output = &AttachCustomerManagedPolicyReferenceToPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachCustomerManagedPolicyReferenceToPermissionSet API operation for AWS Single Sign-On Admin.
//
// Attaches the specified customer managed policy to the specified PermissionSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation AttachCustomerManagedPolicyReferenceToPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachCustomerManagedPolicyReferenceToPermissionSet
func (c *SSOAdmin) AttachCustomerManagedPolicyReferenceToPermissionSet(input *AttachCustomerManagedPolicyReferenceToPermissionSetInput) (*AttachCustomerManagedPolicyReferenceToPermissionSetOutput, error) {
	req, out := c.AttachCustomerManagedPolicyReferenceToPermissionSetRequest(input)
	return out, req.Send()
}

// AttachCustomerManagedPolicyReferenceToPermissionSetWithContext is the same as AttachCustomerManagedPolicyReferenceToPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See AttachCustomerManagedPolicyReferenceToPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) AttachCustomerManagedPolicyReferenceToPermissionSetWithContext(ctx aws.Context, input *AttachCustomerManagedPolicyReferenceToPermissionSetInput, opts ...request.Option) (*AttachCustomerManagedPolicyReferenceToPermissionSetOutput, error) {
	req, out := c.AttachCustomerManagedPolicyReferenceToPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachManagedPolicyToPermissionSet = "AttachManagedPolicyToPermissionSet"

// AttachManagedPolicyToPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the AttachManagedPolicyToPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachManagedPolicyToPermissionSet for more information on using the AttachManagedPolicyToPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AttachManagedPolicyToPermissionSetRequest method.
//	req, resp := client.AttachManagedPolicyToPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet
func (c *SSOAdmin) AttachManagedPolicyToPermissionSetRequest(input *AttachManagedPolicyToPermissionSetInput) (req *request.Request, output *AttachManagedPolicyToPermissionSetOutput) {
	op := &request.Operation{
		Name:       opAttachManagedPolicyToPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachManagedPolicyToPermissionSetInput{}
	}

	output = &AttachManagedPolicyToPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachManagedPolicyToPermissionSet API operation for AWS Single Sign-On Admin.
//
// Attaches an Amazon Web Services managed policy ARN to a permission set.
//
// If the permission set is already referenced by one or more account assignments,
// you will need to call ProvisionPermissionSet after this operation. Calling
// ProvisionPermissionSet applies the corresponding IAM policy updates to all
// assigned accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation AttachManagedPolicyToPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/AttachManagedPolicyToPermissionSet
func (c *SSOAdmin) AttachManagedPolicyToPermissionSet(input *AttachManagedPolicyToPermissionSetInput) (*AttachManagedPolicyToPermissionSetOutput, error) {
	req, out := c.AttachManagedPolicyToPermissionSetRequest(input)
	return out, req.Send()
}

// AttachManagedPolicyToPermissionSetWithContext is the same as AttachManagedPolicyToPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See AttachManagedPolicyToPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) AttachManagedPolicyToPermissionSetWithContext(ctx aws.Context, input *AttachManagedPolicyToPermissionSetInput, opts ...request.Option) (*AttachManagedPolicyToPermissionSetOutput, error) {
	req, out := c.AttachManagedPolicyToPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccountAssignment = "CreateAccountAssignment"

// CreateAccountAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccountAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccountAssignment for more information on using the CreateAccountAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccountAssignmentRequest method.
//	req, resp := client.CreateAccountAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment
func (c *SSOAdmin) CreateAccountAssignmentRequest(input *CreateAccountAssignmentInput) (req *request.Request, output *CreateAccountAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateAccountAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAccountAssignmentInput{}
	}

	output = &CreateAccountAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccountAssignment API operation for AWS Single Sign-On Admin.
//
// Assigns access to a principal for a specified Amazon Web Services account
// using a specified permission set.
//
// The term principal here refers to a user or group that is defined in IAM
// Identity Center.
//
// As part of a successful CreateAccountAssignment call, the specified permission
// set will automatically be provisioned to the account in the form of an IAM
// policy. That policy is attached to the IAM role created in IAM Identity Center.
// If the permission set is subsequently updated, the corresponding IAM policies
// attached to roles in your accounts will not be updated automatically. In
// this case, you must call ProvisionPermissionSet to make these updates.
//
// After a successful response, call DescribeAccountAssignmentCreationStatus
// to describe the status of an assignment creation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateAccountAssignment for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateAccountAssignment
func (c *SSOAdmin) CreateAccountAssignment(input *CreateAccountAssignmentInput) (*CreateAccountAssignmentOutput, error) {
	req, out := c.CreateAccountAssignmentRequest(input)
	return out, req.Send()
}

// CreateAccountAssignmentWithContext is the same as CreateAccountAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccountAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateAccountAssignmentWithContext(ctx aws.Context, input *CreateAccountAssignmentInput, opts ...request.Option) (*CreateAccountAssignmentOutput, error) {
	req, out := c.CreateAccountAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationRequest method.
//	req, resp := client.CreateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplication
func (c *SSOAdmin) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS Single Sign-On Admin.
//
// Creates an application in IAM Identity Center for the given application provider.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplication
func (c *SSOAdmin) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplicationAssignment = "CreateApplicationAssignment"

// CreateApplicationAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplicationAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplicationAssignment for more information on using the CreateApplicationAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateApplicationAssignmentRequest method.
//	req, resp := client.CreateApplicationAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplicationAssignment
func (c *SSOAdmin) CreateApplicationAssignmentRequest(input *CreateApplicationAssignmentInput) (req *request.Request, output *CreateApplicationAssignmentOutput) {
	op := &request.Operation{
		Name:       opCreateApplicationAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateApplicationAssignmentInput{}
	}

	output = &CreateApplicationAssignmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateApplicationAssignment API operation for AWS Single Sign-On Admin.
//
// Grant application access to a user or group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateApplicationAssignment for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateApplicationAssignment
func (c *SSOAdmin) CreateApplicationAssignment(input *CreateApplicationAssignmentInput) (*CreateApplicationAssignmentOutput, error) {
	req, out := c.CreateApplicationAssignmentRequest(input)
	return out, req.Send()
}

// CreateApplicationAssignmentWithContext is the same as CreateApplicationAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplicationAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateApplicationAssignmentWithContext(ctx aws.Context, input *CreateApplicationAssignmentInput, opts ...request.Option) (*CreateApplicationAssignmentOutput, error) {
	req, out := c.CreateApplicationAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstance = "CreateInstance"

// CreateInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstance for more information on using the CreateInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceRequest method.
//	req, resp := client.CreateInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstance
func (c *SSOAdmin) CreateInstanceRequest(input *CreateInstanceInput) (req *request.Request, output *CreateInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceInput{}
	}

	output = &CreateInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstance API operation for AWS Single Sign-On Admin.
//
// Creates an instance of IAM Identity Center for a standalone Amazon Web Services
// account that is not managed by Organizations or a member Amazon Web Services
// account in an organization. You can create only one instance per account
// and across all Amazon Web Services Regions.
//
// The CreateInstance request is rejected if the following apply:
//
//   - The instance is created within the organization management account.
//
//   - An instance already exists in the same account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateInstance for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstance
func (c *SSOAdmin) CreateInstance(input *CreateInstanceInput) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	return out, req.Send()
}

// CreateInstanceWithContext is the same as CreateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateInstanceWithContext(ctx aws.Context, input *CreateInstanceInput, opts ...request.Option) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceAccessControlAttributeConfiguration = "CreateInstanceAccessControlAttributeConfiguration"

// CreateInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstanceAccessControlAttributeConfiguration for more information on using the CreateInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceAccessControlAttributeConfigurationRequest method.
//	req, resp := client.CreateInstanceAccessControlAttributeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) CreateInstanceAccessControlAttributeConfigurationRequest(input *CreateInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *CreateInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &CreateInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Enables the attributes-based access control (ABAC) feature for the specified
// IAM Identity Center instance. You can also specify new attributes to add
// to your ABAC configuration during the enabling process. For more information
// about ABAC, see Attribute-Based Access Control (/singlesignon/latest/userguide/abac.html)
// in the IAM Identity Center User Guide.
//
// After a successful response, call DescribeInstanceAccessControlAttributeConfiguration
// to validate that InstanceAccessControlAttributeConfiguration was created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) CreateInstanceAccessControlAttributeConfiguration(input *CreateInstanceAccessControlAttributeConfigurationInput) (*CreateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.CreateInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// CreateInstanceAccessControlAttributeConfigurationWithContext is the same as CreateInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *CreateInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*CreateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.CreateInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePermissionSet = "CreatePermissionSet"

// CreatePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the CreatePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePermissionSet for more information on using the CreatePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePermissionSetRequest method.
//	req, resp := client.CreatePermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet
func (c *SSOAdmin) CreatePermissionSetRequest(input *CreatePermissionSetInput) (req *request.Request, output *CreatePermissionSetOutput) {
	op := &request.Operation{
		Name:       opCreatePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePermissionSetInput{}
	}

	output = &CreatePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePermissionSet API operation for AWS Single Sign-On Admin.
//
// Creates a permission set within a specified IAM Identity Center instance.
//
// To grant users and groups access to Amazon Web Services account resources,
// use CreateAccountAssignment .
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreatePermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreatePermissionSet
func (c *SSOAdmin) CreatePermissionSet(input *CreatePermissionSetInput) (*CreatePermissionSetOutput, error) {
	req, out := c.CreatePermissionSetRequest(input)
	return out, req.Send()
}

// CreatePermissionSetWithContext is the same as CreatePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreatePermissionSetWithContext(ctx aws.Context, input *CreatePermissionSetInput, opts ...request.Option) (*CreatePermissionSetOutput, error) {
	req, out := c.CreatePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrustedTokenIssuer = "CreateTrustedTokenIssuer"

// CreateTrustedTokenIssuerRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrustedTokenIssuer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrustedTokenIssuer for more information on using the CreateTrustedTokenIssuer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrustedTokenIssuerRequest method.
//	req, resp := client.CreateTrustedTokenIssuerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateTrustedTokenIssuer
func (c *SSOAdmin) CreateTrustedTokenIssuerRequest(input *CreateTrustedTokenIssuerInput) (req *request.Request, output *CreateTrustedTokenIssuerOutput) {
	op := &request.Operation{
		Name:       opCreateTrustedTokenIssuer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTrustedTokenIssuerInput{}
	}

	output = &CreateTrustedTokenIssuerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrustedTokenIssuer API operation for AWS Single Sign-On Admin.
//
// Creates a connection to a trusted token issuer in an instance of IAM Identity
// Center. A trusted token issuer enables trusted identity propagation to be
// used with applications that authenticate outside of Amazon Web Services.
//
// This trusted token issuer describes an external identity provider (IdP) that
// can generate claims or assertions in the form of access tokens for a user.
// Applications enabled for IAM Identity Center can use these tokens for authentication.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation CreateTrustedTokenIssuer for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/CreateTrustedTokenIssuer
func (c *SSOAdmin) CreateTrustedTokenIssuer(input *CreateTrustedTokenIssuerInput) (*CreateTrustedTokenIssuerOutput, error) {
	req, out := c.CreateTrustedTokenIssuerRequest(input)
	return out, req.Send()
}

// CreateTrustedTokenIssuerWithContext is the same as CreateTrustedTokenIssuer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrustedTokenIssuer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) CreateTrustedTokenIssuerWithContext(ctx aws.Context, input *CreateTrustedTokenIssuerInput, opts ...request.Option) (*CreateTrustedTokenIssuerOutput, error) {
	req, out := c.CreateTrustedTokenIssuerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccountAssignment = "DeleteAccountAssignment"

// DeleteAccountAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccountAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccountAssignment for more information on using the DeleteAccountAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccountAssignmentRequest method.
//	req, resp := client.DeleteAccountAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment
func (c *SSOAdmin) DeleteAccountAssignmentRequest(input *DeleteAccountAssignmentInput) (req *request.Request, output *DeleteAccountAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteAccountAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAccountAssignmentInput{}
	}

	output = &DeleteAccountAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAccountAssignment API operation for AWS Single Sign-On Admin.
//
// Deletes a principal's access from a specified Amazon Web Services account
// using a specified permission set.
//
// After a successful response, call DescribeAccountAssignmentDeletionStatus
// to describe the status of an assignment deletion request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteAccountAssignment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteAccountAssignment
func (c *SSOAdmin) DeleteAccountAssignment(input *DeleteAccountAssignmentInput) (*DeleteAccountAssignmentOutput, error) {
	req, out := c.DeleteAccountAssignmentRequest(input)
	return out, req.Send()
}

// DeleteAccountAssignmentWithContext is the same as DeleteAccountAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccountAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteAccountAssignmentWithContext(ctx aws.Context, input *DeleteAccountAssignmentInput, opts ...request.Option) (*DeleteAccountAssignmentOutput, error) {
	req, out := c.DeleteAccountAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationRequest method.
//	req, resp := client.DeleteApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplication
func (c *SSOAdmin) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplication API operation for AWS Single Sign-On Admin.
//
// Deletes the association with the application. The connected service resource
// still exists.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplication
func (c *SSOAdmin) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationAccessScope = "DeleteApplicationAccessScope"

// DeleteApplicationAccessScopeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationAccessScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationAccessScope for more information on using the DeleteApplicationAccessScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationAccessScopeRequest method.
//	req, resp := client.DeleteApplicationAccessScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAccessScope
func (c *SSOAdmin) DeleteApplicationAccessScopeRequest(input *DeleteApplicationAccessScopeInput) (req *request.Request, output *DeleteApplicationAccessScopeOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationAccessScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationAccessScopeInput{}
	}

	output = &DeleteApplicationAccessScopeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationAccessScope API operation for AWS Single Sign-On Admin.
//
// Deletes an IAM Identity Center access scope from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteApplicationAccessScope for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAccessScope
func (c *SSOAdmin) DeleteApplicationAccessScope(input *DeleteApplicationAccessScopeInput) (*DeleteApplicationAccessScopeOutput, error) {
	req, out := c.DeleteApplicationAccessScopeRequest(input)
	return out, req.Send()
}

// DeleteApplicationAccessScopeWithContext is the same as DeleteApplicationAccessScope with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationAccessScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteApplicationAccessScopeWithContext(ctx aws.Context, input *DeleteApplicationAccessScopeInput, opts ...request.Option) (*DeleteApplicationAccessScopeOutput, error) {
	req, out := c.DeleteApplicationAccessScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationAssignment = "DeleteApplicationAssignment"

// DeleteApplicationAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationAssignment for more information on using the DeleteApplicationAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationAssignmentRequest method.
//	req, resp := client.DeleteApplicationAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAssignment
func (c *SSOAdmin) DeleteApplicationAssignmentRequest(input *DeleteApplicationAssignmentInput) (req *request.Request, output *DeleteApplicationAssignmentOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationAssignmentInput{}
	}

	output = &DeleteApplicationAssignmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationAssignment API operation for AWS Single Sign-On Admin.
//
// Revoke application access to an application by deleting application assignments
// for a user or group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteApplicationAssignment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAssignment
func (c *SSOAdmin) DeleteApplicationAssignment(input *DeleteApplicationAssignmentInput) (*DeleteApplicationAssignmentOutput, error) {
	req, out := c.DeleteApplicationAssignmentRequest(input)
	return out, req.Send()
}

// DeleteApplicationAssignmentWithContext is the same as DeleteApplicationAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteApplicationAssignmentWithContext(ctx aws.Context, input *DeleteApplicationAssignmentInput, opts ...request.Option) (*DeleteApplicationAssignmentOutput, error) {
	req, out := c.DeleteApplicationAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationAuthenticationMethod = "DeleteApplicationAuthenticationMethod"

// DeleteApplicationAuthenticationMethodRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationAuthenticationMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationAuthenticationMethod for more information on using the DeleteApplicationAuthenticationMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationAuthenticationMethodRequest method.
//	req, resp := client.DeleteApplicationAuthenticationMethodRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAuthenticationMethod
func (c *SSOAdmin) DeleteApplicationAuthenticationMethodRequest(input *DeleteApplicationAuthenticationMethodInput) (req *request.Request, output *DeleteApplicationAuthenticationMethodOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationAuthenticationMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationAuthenticationMethodInput{}
	}

	output = &DeleteApplicationAuthenticationMethodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationAuthenticationMethod API operation for AWS Single Sign-On Admin.
//
// Deletes an authentication method from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteApplicationAuthenticationMethod for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationAuthenticationMethod
func (c *SSOAdmin) DeleteApplicationAuthenticationMethod(input *DeleteApplicationAuthenticationMethodInput) (*DeleteApplicationAuthenticationMethodOutput, error) {
	req, out := c.DeleteApplicationAuthenticationMethodRequest(input)
	return out, req.Send()
}

// DeleteApplicationAuthenticationMethodWithContext is the same as DeleteApplicationAuthenticationMethod with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationAuthenticationMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteApplicationAuthenticationMethodWithContext(ctx aws.Context, input *DeleteApplicationAuthenticationMethodInput, opts ...request.Option) (*DeleteApplicationAuthenticationMethodOutput, error) {
	req, out := c.DeleteApplicationAuthenticationMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplicationGrant = "DeleteApplicationGrant"

// DeleteApplicationGrantRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplicationGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplicationGrant for more information on using the DeleteApplicationGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteApplicationGrantRequest method.
//	req, resp := client.DeleteApplicationGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationGrant
func (c *SSOAdmin) DeleteApplicationGrantRequest(input *DeleteApplicationGrantInput) (req *request.Request, output *DeleteApplicationGrantOutput) {
	op := &request.Operation{
		Name:       opDeleteApplicationGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteApplicationGrantInput{}
	}

	output = &DeleteApplicationGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApplicationGrant API operation for AWS Single Sign-On Admin.
//
// Deletes a grant from an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteApplicationGrant for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteApplicationGrant
func (c *SSOAdmin) DeleteApplicationGrant(input *DeleteApplicationGrantInput) (*DeleteApplicationGrantOutput, error) {
	req, out := c.DeleteApplicationGrantRequest(input)
	return out, req.Send()
}

// DeleteApplicationGrantWithContext is the same as DeleteApplicationGrant with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplicationGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteApplicationGrantWithContext(ctx aws.Context, input *DeleteApplicationGrantInput, opts ...request.Option) (*DeleteApplicationGrantOutput, error) {
	req, out := c.DeleteApplicationGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInlinePolicyFromPermissionSet = "DeleteInlinePolicyFromPermissionSet"

// DeleteInlinePolicyFromPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInlinePolicyFromPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInlinePolicyFromPermissionSet for more information on using the DeleteInlinePolicyFromPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInlinePolicyFromPermissionSetRequest method.
//	req, resp := client.DeleteInlinePolicyFromPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet
func (c *SSOAdmin) DeleteInlinePolicyFromPermissionSetRequest(input *DeleteInlinePolicyFromPermissionSetInput) (req *request.Request, output *DeleteInlinePolicyFromPermissionSetOutput) {
	op := &request.Operation{
		Name:       opDeleteInlinePolicyFromPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInlinePolicyFromPermissionSetInput{}
	}

	output = &DeleteInlinePolicyFromPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInlinePolicyFromPermissionSet API operation for AWS Single Sign-On Admin.
//
// Deletes the inline policy from a specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteInlinePolicyFromPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInlinePolicyFromPermissionSet
func (c *SSOAdmin) DeleteInlinePolicyFromPermissionSet(input *DeleteInlinePolicyFromPermissionSetInput) (*DeleteInlinePolicyFromPermissionSetOutput, error) {
	req, out := c.DeleteInlinePolicyFromPermissionSetRequest(input)
	return out, req.Send()
}

// DeleteInlinePolicyFromPermissionSetWithContext is the same as DeleteInlinePolicyFromPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInlinePolicyFromPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteInlinePolicyFromPermissionSetWithContext(ctx aws.Context, input *DeleteInlinePolicyFromPermissionSetInput, opts ...request.Option) (*DeleteInlinePolicyFromPermissionSetOutput, error) {
	req, out := c.DeleteInlinePolicyFromPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstance for more information on using the DeleteInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceRequest method.
//	req, resp := client.DeleteInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstance
func (c *SSOAdmin) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	output = &DeleteInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstance API operation for AWS Single Sign-On Admin.
//
// Deletes the instance of IAM Identity Center. Only the account that owns the
// instance can call this API. Neither the delegated administrator nor member
// account can delete the organization instance, but those roles can delete
// their own instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteInstance for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstance
func (c *SSOAdmin) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	return out, req.Send()
}

// DeleteInstanceWithContext is the same as DeleteInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteInstanceWithContext(ctx aws.Context, input *DeleteInstanceInput, opts ...request.Option) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstanceAccessControlAttributeConfiguration = "DeleteInstanceAccessControlAttributeConfiguration"

// DeleteInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstanceAccessControlAttributeConfiguration for more information on using the DeleteInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceAccessControlAttributeConfigurationRequest method.
//	req, resp := client.DeleteInstanceAccessControlAttributeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DeleteInstanceAccessControlAttributeConfigurationRequest(input *DeleteInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *DeleteInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &DeleteInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Disables the attributes-based access control (ABAC) feature for the specified
// IAM Identity Center instance and deletes all of the attribute mappings that
// have been configured. Once deleted, any attributes that are received from
// an identity source and any custom attributes you have previously configured
// will not be passed. For more information about ABAC, see Attribute-Based
// Access Control (/singlesignon/latest/userguide/abac.html) in the IAM Identity
// Center User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DeleteInstanceAccessControlAttributeConfiguration(input *DeleteInstanceAccessControlAttributeConfigurationInput) (*DeleteInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DeleteInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// DeleteInstanceAccessControlAttributeConfigurationWithContext is the same as DeleteInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *DeleteInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*DeleteInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DeleteInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionSet = "DeletePermissionSet"

// DeletePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionSet for more information on using the DeletePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePermissionSetRequest method.
//	req, resp := client.DeletePermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet
func (c *SSOAdmin) DeletePermissionSetRequest(input *DeletePermissionSetInput) (req *request.Request, output *DeletePermissionSetOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionSetInput{}
	}

	output = &DeletePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermissionSet API operation for AWS Single Sign-On Admin.
//
// Deletes the specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeletePermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionSet
func (c *SSOAdmin) DeletePermissionSet(input *DeletePermissionSetInput) (*DeletePermissionSetOutput, error) {
	req, out := c.DeletePermissionSetRequest(input)
	return out, req.Send()
}

// DeletePermissionSetWithContext is the same as DeletePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeletePermissionSetWithContext(ctx aws.Context, input *DeletePermissionSetInput, opts ...request.Option) (*DeletePermissionSetOutput, error) {
	req, out := c.DeletePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionsBoundaryFromPermissionSet = "DeletePermissionsBoundaryFromPermissionSet"

// DeletePermissionsBoundaryFromPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionsBoundaryFromPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionsBoundaryFromPermissionSet for more information on using the DeletePermissionsBoundaryFromPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePermissionsBoundaryFromPermissionSetRequest method.
//	req, resp := client.DeletePermissionsBoundaryFromPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet
func (c *SSOAdmin) DeletePermissionsBoundaryFromPermissionSetRequest(input *DeletePermissionsBoundaryFromPermissionSetInput) (req *request.Request, output *DeletePermissionsBoundaryFromPermissionSetOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionsBoundaryFromPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionsBoundaryFromPermissionSetInput{}
	}

	output = &DeletePermissionsBoundaryFromPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermissionsBoundaryFromPermissionSet API operation for AWS Single Sign-On Admin.
//
// Deletes the permissions boundary from a specified PermissionSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeletePermissionsBoundaryFromPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeletePermissionsBoundaryFromPermissionSet
func (c *SSOAdmin) DeletePermissionsBoundaryFromPermissionSet(input *DeletePermissionsBoundaryFromPermissionSetInput) (*DeletePermissionsBoundaryFromPermissionSetOutput, error) {
	req, out := c.DeletePermissionsBoundaryFromPermissionSetRequest(input)
	return out, req.Send()
}

// DeletePermissionsBoundaryFromPermissionSetWithContext is the same as DeletePermissionsBoundaryFromPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionsBoundaryFromPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeletePermissionsBoundaryFromPermissionSetWithContext(ctx aws.Context, input *DeletePermissionsBoundaryFromPermissionSetInput, opts ...request.Option) (*DeletePermissionsBoundaryFromPermissionSetOutput, error) {
	req, out := c.DeletePermissionsBoundaryFromPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrustedTokenIssuer = "DeleteTrustedTokenIssuer"

// DeleteTrustedTokenIssuerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrustedTokenIssuer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrustedTokenIssuer for more information on using the DeleteTrustedTokenIssuer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrustedTokenIssuerRequest method.
//	req, resp := client.DeleteTrustedTokenIssuerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteTrustedTokenIssuer
func (c *SSOAdmin) DeleteTrustedTokenIssuerRequest(input *DeleteTrustedTokenIssuerInput) (req *request.Request, output *DeleteTrustedTokenIssuerOutput) {
	op := &request.Operation{
		Name:       opDeleteTrustedTokenIssuer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTrustedTokenIssuerInput{}
	}

	output = &DeleteTrustedTokenIssuerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrustedTokenIssuer API operation for AWS Single Sign-On Admin.
//
// Deletes a trusted token issuer configuration from an instance of IAM Identity
// Center.
//
// Deleting this trusted token issuer configuration will cause users to lose
// access to any applications that are configured to use the trusted token issuer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DeleteTrustedTokenIssuer for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DeleteTrustedTokenIssuer
func (c *SSOAdmin) DeleteTrustedTokenIssuer(input *DeleteTrustedTokenIssuerInput) (*DeleteTrustedTokenIssuerOutput, error) {
	req, out := c.DeleteTrustedTokenIssuerRequest(input)
	return out, req.Send()
}

// DeleteTrustedTokenIssuerWithContext is the same as DeleteTrustedTokenIssuer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrustedTokenIssuer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DeleteTrustedTokenIssuerWithContext(ctx aws.Context, input *DeleteTrustedTokenIssuerInput, opts ...request.Option) (*DeleteTrustedTokenIssuerOutput, error) {
	req, out := c.DeleteTrustedTokenIssuerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAssignmentCreationStatus = "DescribeAccountAssignmentCreationStatus"

// DescribeAccountAssignmentCreationStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAssignmentCreationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAssignmentCreationStatus for more information on using the DescribeAccountAssignmentCreationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountAssignmentCreationStatusRequest method.
//	req, resp := client.DescribeAccountAssignmentCreationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus
func (c *SSOAdmin) DescribeAccountAssignmentCreationStatusRequest(input *DescribeAccountAssignmentCreationStatusInput) (req *request.Request, output *DescribeAccountAssignmentCreationStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAssignmentCreationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAssignmentCreationStatusInput{}
	}

	output = &DescribeAccountAssignmentCreationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAssignmentCreationStatus API operation for AWS Single Sign-On Admin.
//
// Describes the status of the assignment creation request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeAccountAssignmentCreationStatus for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentCreationStatus
func (c *SSOAdmin) DescribeAccountAssignmentCreationStatus(input *DescribeAccountAssignmentCreationStatusInput) (*DescribeAccountAssignmentCreationStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentCreationStatusRequest(input)
	return out, req.Send()
}

// DescribeAccountAssignmentCreationStatusWithContext is the same as DescribeAccountAssignmentCreationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAssignmentCreationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeAccountAssignmentCreationStatusWithContext(ctx aws.Context, input *DescribeAccountAssignmentCreationStatusInput, opts ...request.Option) (*DescribeAccountAssignmentCreationStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentCreationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAssignmentDeletionStatus = "DescribeAccountAssignmentDeletionStatus"

// DescribeAccountAssignmentDeletionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAssignmentDeletionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAssignmentDeletionStatus for more information on using the DescribeAccountAssignmentDeletionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccountAssignmentDeletionStatusRequest method.
//	req, resp := client.DescribeAccountAssignmentDeletionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus
func (c *SSOAdmin) DescribeAccountAssignmentDeletionStatusRequest(input *DescribeAccountAssignmentDeletionStatusInput) (req *request.Request, output *DescribeAccountAssignmentDeletionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAssignmentDeletionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAssignmentDeletionStatusInput{}
	}

	output = &DescribeAccountAssignmentDeletionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAssignmentDeletionStatus API operation for AWS Single Sign-On Admin.
//
// Describes the status of the assignment deletion request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeAccountAssignmentDeletionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeAccountAssignmentDeletionStatus
func (c *SSOAdmin) DescribeAccountAssignmentDeletionStatus(input *DescribeAccountAssignmentDeletionStatusInput) (*DescribeAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentDeletionStatusRequest(input)
	return out, req.Send()
}

// DescribeAccountAssignmentDeletionStatusWithContext is the same as DescribeAccountAssignmentDeletionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAssignmentDeletionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeAccountAssignmentDeletionStatusWithContext(ctx aws.Context, input *DescribeAccountAssignmentDeletionStatusInput, opts ...request.Option) (*DescribeAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.DescribeAccountAssignmentDeletionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplication = "DescribeApplication"

// DescribeApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplication for more information on using the DescribeApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApplicationRequest method.
//	req, resp := client.DescribeApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplication
func (c *SSOAdmin) DescribeApplicationRequest(input *DescribeApplicationInput) (req *request.Request, output *DescribeApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationInput{}
	}

	output = &DescribeApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplication API operation for AWS Single Sign-On Admin.
//
// Retrieves the details of an application associated with an instance of IAM
// Identity Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeApplication for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplication
func (c *SSOAdmin) DescribeApplication(input *DescribeApplicationInput) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	return out, req.Send()
}

// DescribeApplicationWithContext is the same as DescribeApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeApplicationWithContext(ctx aws.Context, input *DescribeApplicationInput, opts ...request.Option) (*DescribeApplicationOutput, error) {
	req, out := c.DescribeApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationAssignment = "DescribeApplicationAssignment"

// DescribeApplicationAssignmentRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationAssignment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationAssignment for more information on using the DescribeApplicationAssignment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApplicationAssignmentRequest method.
//	req, resp := client.DescribeApplicationAssignmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationAssignment
func (c *SSOAdmin) DescribeApplicationAssignmentRequest(input *DescribeApplicationAssignmentInput) (req *request.Request, output *DescribeApplicationAssignmentOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationAssignment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationAssignmentInput{}
	}

	output = &DescribeApplicationAssignmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationAssignment API operation for AWS Single Sign-On Admin.
//
// Retrieves a direct assignment of a user or group to an application. If the
// user doesn’t have a direct assignment to the application, the user may
// still have access to the application through a group. Therefore, don’t
// use this API to test access to an application for a user. Instead use ListApplicationAssignmentsForPrincipal.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeApplicationAssignment for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationAssignment
func (c *SSOAdmin) DescribeApplicationAssignment(input *DescribeApplicationAssignmentInput) (*DescribeApplicationAssignmentOutput, error) {
	req, out := c.DescribeApplicationAssignmentRequest(input)
	return out, req.Send()
}

// DescribeApplicationAssignmentWithContext is the same as DescribeApplicationAssignment with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationAssignment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeApplicationAssignmentWithContext(ctx aws.Context, input *DescribeApplicationAssignmentInput, opts ...request.Option) (*DescribeApplicationAssignmentOutput, error) {
	req, out := c.DescribeApplicationAssignmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicationProvider = "DescribeApplicationProvider"

// DescribeApplicationProviderRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicationProvider operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicationProvider for more information on using the DescribeApplicationProvider
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeApplicationProviderRequest method.
//	req, resp := client.DescribeApplicationProviderRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationProvider
func (c *SSOAdmin) DescribeApplicationProviderRequest(input *DescribeApplicationProviderInput) (req *request.Request, output *DescribeApplicationProviderOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicationProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeApplicationProviderInput{}
	}

	output = &DescribeApplicationProviderOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicationProvider API operation for AWS Single Sign-On Admin.
//
// Retrieves details about a provider that can be used to connect an Amazon
// Web Services managed application or customer managed application to IAM Identity
// Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeApplicationProvider for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeApplicationProvider
func (c *SSOAdmin) DescribeApplicationProvider(input *DescribeApplicationProviderInput) (*DescribeApplicationProviderOutput, error) {
	req, out := c.DescribeApplicationProviderRequest(input)
	return out, req.Send()
}

// DescribeApplicationProviderWithContext is the same as DescribeApplicationProvider with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicationProvider for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeApplicationProviderWithContext(ctx aws.Context, input *DescribeApplicationProviderInput, opts ...request.Option) (*DescribeApplicationProviderOutput, error) {
	req, out := c.DescribeApplicationProviderRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstance = "DescribeInstance"

// DescribeInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstance for more information on using the DescribeInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceRequest method.
//	req, resp := client.DescribeInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstance
func (c *SSOAdmin) DescribeInstanceRequest(input *DescribeInstanceInput) (req *request.Request, output *DescribeInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceInput{}
	}

	output = &DescribeInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstance API operation for AWS Single Sign-On Admin.
//
// Returns the details of an instance of IAM Identity Center. The status can
// be one of the following:
//
//   - CREATE_IN_PROGRESS - The instance is in the process of being created.
//     When the instance is ready for use, DescribeInstance returns the status
//     of ACTIVE. While the instance is in the CREATE_IN_PROGRESS state, you
//     can call only DescribeInstance and DeleteInstance operations.
//
//   - DELETE_IN_PROGRESS - The instance is being deleted. Returns AccessDeniedException
//     after the delete operation completes.
//
//   - ACTIVE - The instance is active.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeInstance for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstance
func (c *SSOAdmin) DescribeInstance(input *DescribeInstanceInput) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	return out, req.Send()
}

// DescribeInstanceWithContext is the same as DescribeInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeInstanceWithContext(ctx aws.Context, input *DescribeInstanceInput, opts ...request.Option) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceAccessControlAttributeConfiguration = "DescribeInstanceAccessControlAttributeConfiguration"

// DescribeInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAccessControlAttributeConfiguration for more information on using the DescribeInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceAccessControlAttributeConfigurationRequest method.
//	req, resp := client.DescribeInstanceAccessControlAttributeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DescribeInstanceAccessControlAttributeConfigurationRequest(input *DescribeInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *DescribeInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &DescribeInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Returns the list of IAM Identity Center identity store attributes that have
// been configured to work with attributes-based access control (ABAC) for the
// specified IAM Identity Center instance. This will not return attributes configured
// and sent by an external identity provider. For more information about ABAC,
// see Attribute-Based Access Control (/singlesignon/latest/userguide/abac.html)
// in the IAM Identity Center User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) DescribeInstanceAccessControlAttributeConfiguration(input *DescribeInstanceAccessControlAttributeConfigurationInput) (*DescribeInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DescribeInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// DescribeInstanceAccessControlAttributeConfigurationWithContext is the same as DescribeInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *DescribeInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*DescribeInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.DescribeInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePermissionSet = "DescribePermissionSet"

// DescribePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DescribePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePermissionSet for more information on using the DescribePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePermissionSetRequest method.
//	req, resp := client.DescribePermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet
func (c *SSOAdmin) DescribePermissionSetRequest(input *DescribePermissionSetInput) (req *request.Request, output *DescribePermissionSetOutput) {
	op := &request.Operation{
		Name:       opDescribePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionSetInput{}
	}

	output = &DescribePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePermissionSet API operation for AWS Single Sign-On Admin.
//
// Gets the details of the permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribePermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSet
func (c *SSOAdmin) DescribePermissionSet(input *DescribePermissionSetInput) (*DescribePermissionSetOutput, error) {
	req, out := c.DescribePermissionSetRequest(input)
	return out, req.Send()
}

// DescribePermissionSetWithContext is the same as DescribePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribePermissionSetWithContext(ctx aws.Context, input *DescribePermissionSetInput, opts ...request.Option) (*DescribePermissionSetOutput, error) {
	req, out := c.DescribePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePermissionSetProvisioningStatus = "DescribePermissionSetProvisioningStatus"

// DescribePermissionSetProvisioningStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribePermissionSetProvisioningStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePermissionSetProvisioningStatus for more information on using the DescribePermissionSetProvisioningStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePermissionSetProvisioningStatusRequest method.
//	req, resp := client.DescribePermissionSetProvisioningStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus
func (c *SSOAdmin) DescribePermissionSetProvisioningStatusRequest(input *DescribePermissionSetProvisioningStatusInput) (req *request.Request, output *DescribePermissionSetProvisioningStatusOutput) {
	op := &request.Operation{
		Name:       opDescribePermissionSetProvisioningStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionSetProvisioningStatusInput{}
	}

	output = &DescribePermissionSetProvisioningStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePermissionSetProvisioningStatus API operation for AWS Single Sign-On Admin.
//
// Describes the status for the given permission set provisioning request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribePermissionSetProvisioningStatus for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribePermissionSetProvisioningStatus
func (c *SSOAdmin) DescribePermissionSetProvisioningStatus(input *DescribePermissionSetProvisioningStatusInput) (*DescribePermissionSetProvisioningStatusOutput, error) {
	req, out := c.DescribePermissionSetProvisioningStatusRequest(input)
	return out, req.Send()
}

// DescribePermissionSetProvisioningStatusWithContext is the same as DescribePermissionSetProvisioningStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePermissionSetProvisioningStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribePermissionSetProvisioningStatusWithContext(ctx aws.Context, input *DescribePermissionSetProvisioningStatusInput, opts ...request.Option) (*DescribePermissionSetProvisioningStatusOutput, error) {
	req, out := c.DescribePermissionSetProvisioningStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrustedTokenIssuer = "DescribeTrustedTokenIssuer"

// DescribeTrustedTokenIssuerRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrustedTokenIssuer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrustedTokenIssuer for more information on using the DescribeTrustedTokenIssuer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTrustedTokenIssuerRequest method.
//	req, resp := client.DescribeTrustedTokenIssuerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeTrustedTokenIssuer
func (c *SSOAdmin) DescribeTrustedTokenIssuerRequest(input *DescribeTrustedTokenIssuerInput) (req *request.Request, output *DescribeTrustedTokenIssuerOutput) {
	op := &request.Operation{
		Name:       opDescribeTrustedTokenIssuer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTrustedTokenIssuerInput{}
	}

	output = &DescribeTrustedTokenIssuerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrustedTokenIssuer API operation for AWS Single Sign-On Admin.
//
// Retrieves details about a trusted token issuer configuration stored in an
// instance of IAM Identity Center. Details include the name of the trusted
// token issuer, the issuer URL, and the path of the source attribute and the
// destination attribute for a trusted token issuer configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DescribeTrustedTokenIssuer for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DescribeTrustedTokenIssuer
func (c *SSOAdmin) DescribeTrustedTokenIssuer(input *DescribeTrustedTokenIssuerInput) (*DescribeTrustedTokenIssuerOutput, error) {
	req, out := c.DescribeTrustedTokenIssuerRequest(input)
	return out, req.Send()
}

// DescribeTrustedTokenIssuerWithContext is the same as DescribeTrustedTokenIssuer with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrustedTokenIssuer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DescribeTrustedTokenIssuerWithContext(ctx aws.Context, input *DescribeTrustedTokenIssuerInput, opts ...request.Option) (*DescribeTrustedTokenIssuerOutput, error) {
	req, out := c.DescribeTrustedTokenIssuerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachCustomerManagedPolicyReferenceFromPermissionSet = "DetachCustomerManagedPolicyReferenceFromPermissionSet"

// DetachCustomerManagedPolicyReferenceFromPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DetachCustomerManagedPolicyReferenceFromPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachCustomerManagedPolicyReferenceFromPermissionSet for more information on using the DetachCustomerManagedPolicyReferenceFromPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetachCustomerManagedPolicyReferenceFromPermissionSetRequest method.
//	req, resp := client.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet
func (c *SSOAdmin) DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(input *DetachCustomerManagedPolicyReferenceFromPermissionSetInput) (req *request.Request, output *DetachCustomerManagedPolicyReferenceFromPermissionSetOutput) {
	op := &request.Operation{
		Name:       opDetachCustomerManagedPolicyReferenceFromPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachCustomerManagedPolicyReferenceFromPermissionSetInput{}
	}

	output = &DetachCustomerManagedPolicyReferenceFromPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachCustomerManagedPolicyReferenceFromPermissionSet API operation for AWS Single Sign-On Admin.
//
// Detaches the specified customer managed policy from the specified PermissionSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DetachCustomerManagedPolicyReferenceFromPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachCustomerManagedPolicyReferenceFromPermissionSet
func (c *SSOAdmin) DetachCustomerManagedPolicyReferenceFromPermissionSet(input *DetachCustomerManagedPolicyReferenceFromPermissionSetInput) (*DetachCustomerManagedPolicyReferenceFromPermissionSetOutput, error) {
	req, out := c.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(input)
	return out, req.Send()
}

// DetachCustomerManagedPolicyReferenceFromPermissionSetWithContext is the same as DetachCustomerManagedPolicyReferenceFromPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DetachCustomerManagedPolicyReferenceFromPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DetachCustomerManagedPolicyReferenceFromPermissionSetWithContext(ctx aws.Context, input *DetachCustomerManagedPolicyReferenceFromPermissionSetInput, opts ...request.Option) (*DetachCustomerManagedPolicyReferenceFromPermissionSetOutput, error) {
	req, out := c.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachManagedPolicyFromPermissionSet = "DetachManagedPolicyFromPermissionSet"

// DetachManagedPolicyFromPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the DetachManagedPolicyFromPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachManagedPolicyFromPermissionSet for more information on using the DetachManagedPolicyFromPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetachManagedPolicyFromPermissionSetRequest method.
//	req, resp := client.DetachManagedPolicyFromPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet
func (c *SSOAdmin) DetachManagedPolicyFromPermissionSetRequest(input *DetachManagedPolicyFromPermissionSetInput) (req *request.Request, output *DetachManagedPolicyFromPermissionSetOutput) {
	op := &request.Operation{
		Name:       opDetachManagedPolicyFromPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachManagedPolicyFromPermissionSetInput{}
	}

	output = &DetachManagedPolicyFromPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachManagedPolicyFromPermissionSet API operation for AWS Single Sign-On Admin.
//
// Detaches the attached Amazon Web Services managed policy ARN from the specified
// permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation DetachManagedPolicyFromPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/DetachManagedPolicyFromPermissionSet
func (c *SSOAdmin) DetachManagedPolicyFromPermissionSet(input *DetachManagedPolicyFromPermissionSetInput) (*DetachManagedPolicyFromPermissionSetOutput, error) {
	req, out := c.DetachManagedPolicyFromPermissionSetRequest(input)
	return out, req.Send()
}

// DetachManagedPolicyFromPermissionSetWithContext is the same as DetachManagedPolicyFromPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See DetachManagedPolicyFromPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) DetachManagedPolicyFromPermissionSetWithContext(ctx aws.Context, input *DetachManagedPolicyFromPermissionSetInput, opts ...request.Option) (*DetachManagedPolicyFromPermissionSetOutput, error) {
	req, out := c.DetachManagedPolicyFromPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationAccessScope = "GetApplicationAccessScope"

// GetApplicationAccessScopeRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationAccessScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationAccessScope for more information on using the GetApplicationAccessScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationAccessScopeRequest method.
//	req, resp := client.GetApplicationAccessScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAccessScope
func (c *SSOAdmin) GetApplicationAccessScopeRequest(input *GetApplicationAccessScopeInput) (req *request.Request, output *GetApplicationAccessScopeOutput) {
	op := &request.Operation{
		Name:       opGetApplicationAccessScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationAccessScopeInput{}
	}

	output = &GetApplicationAccessScopeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationAccessScope API operation for AWS Single Sign-On Admin.
//
// Retrieves the authorized targets for an IAM Identity Center access scope
// for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetApplicationAccessScope for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAccessScope
func (c *SSOAdmin) GetApplicationAccessScope(input *GetApplicationAccessScopeInput) (*GetApplicationAccessScopeOutput, error) {
	req, out := c.GetApplicationAccessScopeRequest(input)
	return out, req.Send()
}

// GetApplicationAccessScopeWithContext is the same as GetApplicationAccessScope with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationAccessScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetApplicationAccessScopeWithContext(ctx aws.Context, input *GetApplicationAccessScopeInput, opts ...request.Option) (*GetApplicationAccessScopeOutput, error) {
	req, out := c.GetApplicationAccessScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationAssignmentConfiguration = "GetApplicationAssignmentConfiguration"

// GetApplicationAssignmentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationAssignmentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationAssignmentConfiguration for more information on using the GetApplicationAssignmentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationAssignmentConfigurationRequest method.
//	req, resp := client.GetApplicationAssignmentConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAssignmentConfiguration
func (c *SSOAdmin) GetApplicationAssignmentConfigurationRequest(input *GetApplicationAssignmentConfigurationInput) (req *request.Request, output *GetApplicationAssignmentConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetApplicationAssignmentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationAssignmentConfigurationInput{}
	}

	output = &GetApplicationAssignmentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationAssignmentConfiguration API operation for AWS Single Sign-On Admin.
//
// Retrieves the configuration of PutApplicationAssignmentConfiguration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetApplicationAssignmentConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAssignmentConfiguration
func (c *SSOAdmin) GetApplicationAssignmentConfiguration(input *GetApplicationAssignmentConfigurationInput) (*GetApplicationAssignmentConfigurationOutput, error) {
	req, out := c.GetApplicationAssignmentConfigurationRequest(input)
	return out, req.Send()
}

// GetApplicationAssignmentConfigurationWithContext is the same as GetApplicationAssignmentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationAssignmentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetApplicationAssignmentConfigurationWithContext(ctx aws.Context, input *GetApplicationAssignmentConfigurationInput, opts ...request.Option) (*GetApplicationAssignmentConfigurationOutput, error) {
	req, out := c.GetApplicationAssignmentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationAuthenticationMethod = "GetApplicationAuthenticationMethod"

// GetApplicationAuthenticationMethodRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationAuthenticationMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationAuthenticationMethod for more information on using the GetApplicationAuthenticationMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationAuthenticationMethodRequest method.
//	req, resp := client.GetApplicationAuthenticationMethodRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAuthenticationMethod
func (c *SSOAdmin) GetApplicationAuthenticationMethodRequest(input *GetApplicationAuthenticationMethodInput) (req *request.Request, output *GetApplicationAuthenticationMethodOutput) {
	op := &request.Operation{
		Name:       opGetApplicationAuthenticationMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationAuthenticationMethodInput{}
	}

	output = &GetApplicationAuthenticationMethodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationAuthenticationMethod API operation for AWS Single Sign-On Admin.
//
// Retrieves details about an authentication method used by an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetApplicationAuthenticationMethod for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationAuthenticationMethod
func (c *SSOAdmin) GetApplicationAuthenticationMethod(input *GetApplicationAuthenticationMethodInput) (*GetApplicationAuthenticationMethodOutput, error) {
	req, out := c.GetApplicationAuthenticationMethodRequest(input)
	return out, req.Send()
}

// GetApplicationAuthenticationMethodWithContext is the same as GetApplicationAuthenticationMethod with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationAuthenticationMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetApplicationAuthenticationMethodWithContext(ctx aws.Context, input *GetApplicationAuthenticationMethodInput, opts ...request.Option) (*GetApplicationAuthenticationMethodOutput, error) {
	req, out := c.GetApplicationAuthenticationMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplicationGrant = "GetApplicationGrant"

// GetApplicationGrantRequest generates a "aws/request.Request" representing the
// client's request for the GetApplicationGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplicationGrant for more information on using the GetApplicationGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetApplicationGrantRequest method.
//	req, resp := client.GetApplicationGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationGrant
func (c *SSOAdmin) GetApplicationGrantRequest(input *GetApplicationGrantInput) (req *request.Request, output *GetApplicationGrantOutput) {
	op := &request.Operation{
		Name:       opGetApplicationGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetApplicationGrantInput{}
	}

	output = &GetApplicationGrantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplicationGrant API operation for AWS Single Sign-On Admin.
//
// Retrieves details about an application grant.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetApplicationGrant for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetApplicationGrant
func (c *SSOAdmin) GetApplicationGrant(input *GetApplicationGrantInput) (*GetApplicationGrantOutput, error) {
	req, out := c.GetApplicationGrantRequest(input)
	return out, req.Send()
}

// GetApplicationGrantWithContext is the same as GetApplicationGrant with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplicationGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetApplicationGrantWithContext(ctx aws.Context, input *GetApplicationGrantInput, opts ...request.Option) (*GetApplicationGrantOutput, error) {
	req, out := c.GetApplicationGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInlinePolicyForPermissionSet = "GetInlinePolicyForPermissionSet"

// GetInlinePolicyForPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the GetInlinePolicyForPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInlinePolicyForPermissionSet for more information on using the GetInlinePolicyForPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetInlinePolicyForPermissionSetRequest method.
//	req, resp := client.GetInlinePolicyForPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet
func (c *SSOAdmin) GetInlinePolicyForPermissionSetRequest(input *GetInlinePolicyForPermissionSetInput) (req *request.Request, output *GetInlinePolicyForPermissionSetOutput) {
	op := &request.Operation{
		Name:       opGetInlinePolicyForPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInlinePolicyForPermissionSetInput{}
	}

	output = &GetInlinePolicyForPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInlinePolicyForPermissionSet API operation for AWS Single Sign-On Admin.
//
// Obtains the inline policy assigned to the permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetInlinePolicyForPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetInlinePolicyForPermissionSet
func (c *SSOAdmin) GetInlinePolicyForPermissionSet(input *GetInlinePolicyForPermissionSetInput) (*GetInlinePolicyForPermissionSetOutput, error) {
	req, out := c.GetInlinePolicyForPermissionSetRequest(input)
	return out, req.Send()
}

// GetInlinePolicyForPermissionSetWithContext is the same as GetInlinePolicyForPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetInlinePolicyForPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetInlinePolicyForPermissionSetWithContext(ctx aws.Context, input *GetInlinePolicyForPermissionSetInput, opts ...request.Option) (*GetInlinePolicyForPermissionSetOutput, error) {
	req, out := c.GetInlinePolicyForPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPermissionsBoundaryForPermissionSet = "GetPermissionsBoundaryForPermissionSet"

// GetPermissionsBoundaryForPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the GetPermissionsBoundaryForPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPermissionsBoundaryForPermissionSet for more information on using the GetPermissionsBoundaryForPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetPermissionsBoundaryForPermissionSetRequest method.
//	req, resp := client.GetPermissionsBoundaryForPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet
func (c *SSOAdmin) GetPermissionsBoundaryForPermissionSetRequest(input *GetPermissionsBoundaryForPermissionSetInput) (req *request.Request, output *GetPermissionsBoundaryForPermissionSetOutput) {
	op := &request.Operation{
		Name:       opGetPermissionsBoundaryForPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPermissionsBoundaryForPermissionSetInput{}
	}

	output = &GetPermissionsBoundaryForPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPermissionsBoundaryForPermissionSet API operation for AWS Single Sign-On Admin.
//
// Obtains the permissions boundary for a specified PermissionSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation GetPermissionsBoundaryForPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/GetPermissionsBoundaryForPermissionSet
func (c *SSOAdmin) GetPermissionsBoundaryForPermissionSet(input *GetPermissionsBoundaryForPermissionSetInput) (*GetPermissionsBoundaryForPermissionSetOutput, error) {
	req, out := c.GetPermissionsBoundaryForPermissionSetRequest(input)
	return out, req.Send()
}

// GetPermissionsBoundaryForPermissionSetWithContext is the same as GetPermissionsBoundaryForPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetPermissionsBoundaryForPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) GetPermissionsBoundaryForPermissionSetWithContext(ctx aws.Context, input *GetPermissionsBoundaryForPermissionSetInput, opts ...request.Option) (*GetPermissionsBoundaryForPermissionSetOutput, error) {
	req, out := c.GetPermissionsBoundaryForPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountAssignmentCreationStatus = "ListAccountAssignmentCreationStatus"

// ListAccountAssignmentCreationStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignmentCreationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignmentCreationStatus for more information on using the ListAccountAssignmentCreationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountAssignmentCreationStatusRequest method.
//	req, resp := client.ListAccountAssignmentCreationStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus
func (c *SSOAdmin) ListAccountAssignmentCreationStatusRequest(input *ListAccountAssignmentCreationStatusInput) (req *request.Request, output *ListAccountAssignmentCreationStatusOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignmentCreationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentCreationStatusInput{}
	}

	output = &ListAccountAssignmentCreationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignmentCreationStatus API operation for AWS Single Sign-On Admin.
//
// Lists the status of the Amazon Web Services account assignment creation requests
// for a specified IAM Identity Center instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignmentCreationStatus for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentCreationStatus
func (c *SSOAdmin) ListAccountAssignmentCreationStatus(input *ListAccountAssignmentCreationStatusInput) (*ListAccountAssignmentCreationStatusOutput, error) {
	req, out := c.ListAccountAssignmentCreationStatusRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentCreationStatusWithContext is the same as ListAccountAssignmentCreationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignmentCreationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentCreationStatusWithContext(ctx aws.Context, input *ListAccountAssignmentCreationStatusInput, opts ...request.Option) (*ListAccountAssignmentCreationStatusOutput, error) {
	req, out := c.ListAccountAssignmentCreationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentCreationStatusPages iterates over the pages of a ListAccountAssignmentCreationStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignmentCreationStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountAssignmentCreationStatus operation.
//	pageNum := 0
//	err := client.ListAccountAssignmentCreationStatusPages(params,
//	    func(page *ssoadmin.ListAccountAssignmentCreationStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListAccountAssignmentCreationStatusPages(input *ListAccountAssignmentCreationStatusInput, fn func(*ListAccountAssignmentCreationStatusOutput, bool) bool) error {
	return c.ListAccountAssignmentCreationStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentCreationStatusPagesWithContext same as ListAccountAssignmentCreationStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentCreationStatusPagesWithContext(ctx aws.Context, input *ListAccountAssignmentCreationStatusInput, fn func(*ListAccountAssignmentCreationStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentCreationStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentCreationStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentCreationStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountAssignmentDeletionStatus = "ListAccountAssignmentDeletionStatus"

// ListAccountAssignmentDeletionStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignmentDeletionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignmentDeletionStatus for more information on using the ListAccountAssignmentDeletionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountAssignmentDeletionStatusRequest method.
//	req, resp := client.ListAccountAssignmentDeletionStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusRequest(input *ListAccountAssignmentDeletionStatusInput) (req *request.Request, output *ListAccountAssignmentDeletionStatusOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignmentDeletionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentDeletionStatusInput{}
	}

	output = &ListAccountAssignmentDeletionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignmentDeletionStatus API operation for AWS Single Sign-On Admin.
//
// Lists the status of the Amazon Web Services account assignment deletion requests
// for a specified IAM Identity Center instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignmentDeletionStatus for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentDeletionStatus
func (c *SSOAdmin) ListAccountAssignmentDeletionStatus(input *ListAccountAssignmentDeletionStatusInput) (*ListAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.ListAccountAssignmentDeletionStatusRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentDeletionStatusWithContext is the same as ListAccountAssignmentDeletionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignmentDeletionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusWithContext(ctx aws.Context, input *ListAccountAssignmentDeletionStatusInput, opts ...request.Option) (*ListAccountAssignmentDeletionStatusOutput, error) {
	req, out := c.ListAccountAssignmentDeletionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentDeletionStatusPages iterates over the pages of a ListAccountAssignmentDeletionStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignmentDeletionStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountAssignmentDeletionStatus operation.
//	pageNum := 0
//	err := client.ListAccountAssignmentDeletionStatusPages(params,
//	    func(page *ssoadmin.ListAccountAssignmentDeletionStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusPages(input *ListAccountAssignmentDeletionStatusInput, fn func(*ListAccountAssignmentDeletionStatusOutput, bool) bool) error {
	return c.ListAccountAssignmentDeletionStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentDeletionStatusPagesWithContext same as ListAccountAssignmentDeletionStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentDeletionStatusPagesWithContext(ctx aws.Context, input *ListAccountAssignmentDeletionStatusInput, fn func(*ListAccountAssignmentDeletionStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentDeletionStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentDeletionStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentDeletionStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountAssignments = "ListAccountAssignments"

// ListAccountAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignments for more information on using the ListAccountAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountAssignmentsRequest method.
//	req, resp := client.ListAccountAssignmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments
func (c *SSOAdmin) ListAccountAssignmentsRequest(input *ListAccountAssignmentsInput) (req *request.Request, output *ListAccountAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentsInput{}
	}

	output = &ListAccountAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignments API operation for AWS Single Sign-On Admin.
//
// Lists the assignee of the specified Amazon Web Services account with the
// specified permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignments for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignments
func (c *SSOAdmin) ListAccountAssignments(input *ListAccountAssignmentsInput) (*ListAccountAssignmentsOutput, error) {
	req, out := c.ListAccountAssignmentsRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentsWithContext is the same as ListAccountAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentsWithContext(ctx aws.Context, input *ListAccountAssignmentsInput, opts ...request.Option) (*ListAccountAssignmentsOutput, error) {
	req, out := c.ListAccountAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentsPages iterates over the pages of a ListAccountAssignments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountAssignments operation.
//	pageNum := 0
//	err := client.ListAccountAssignmentsPages(params,
//	    func(page *ssoadmin.ListAccountAssignmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListAccountAssignmentsPages(input *ListAccountAssignmentsInput, fn func(*ListAccountAssignmentsOutput, bool) bool) error {
	return c.ListAccountAssignmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentsPagesWithContext same as ListAccountAssignmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentsPagesWithContext(ctx aws.Context, input *ListAccountAssignmentsInput, fn func(*ListAccountAssignmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountAssignmentsForPrincipal = "ListAccountAssignmentsForPrincipal"

// ListAccountAssignmentsForPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountAssignmentsForPrincipal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountAssignmentsForPrincipal for more information on using the ListAccountAssignmentsForPrincipal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountAssignmentsForPrincipalRequest method.
//	req, resp := client.ListAccountAssignmentsForPrincipalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentsForPrincipal
func (c *SSOAdmin) ListAccountAssignmentsForPrincipalRequest(input *ListAccountAssignmentsForPrincipalInput) (req *request.Request, output *ListAccountAssignmentsForPrincipalOutput) {
	op := &request.Operation{
		Name:       opListAccountAssignmentsForPrincipal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountAssignmentsForPrincipalInput{}
	}

	output = &ListAccountAssignmentsForPrincipalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountAssignmentsForPrincipal API operation for AWS Single Sign-On Admin.
//
// Retrieves a list of the IAM Identity Center associated Amazon Web Services
// accounts that the principal has access to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountAssignmentsForPrincipal for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountAssignmentsForPrincipal
func (c *SSOAdmin) ListAccountAssignmentsForPrincipal(input *ListAccountAssignmentsForPrincipalInput) (*ListAccountAssignmentsForPrincipalOutput, error) {
	req, out := c.ListAccountAssignmentsForPrincipalRequest(input)
	return out, req.Send()
}

// ListAccountAssignmentsForPrincipalWithContext is the same as ListAccountAssignmentsForPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountAssignmentsForPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentsForPrincipalWithContext(ctx aws.Context, input *ListAccountAssignmentsForPrincipalInput, opts ...request.Option) (*ListAccountAssignmentsForPrincipalOutput, error) {
	req, out := c.ListAccountAssignmentsForPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountAssignmentsForPrincipalPages iterates over the pages of a ListAccountAssignmentsForPrincipal operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountAssignmentsForPrincipal method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountAssignmentsForPrincipal operation.
//	pageNum := 0
//	err := client.ListAccountAssignmentsForPrincipalPages(params,
//	    func(page *ssoadmin.ListAccountAssignmentsForPrincipalOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListAccountAssignmentsForPrincipalPages(input *ListAccountAssignmentsForPrincipalInput, fn func(*ListAccountAssignmentsForPrincipalOutput, bool) bool) error {
	return c.ListAccountAssignmentsForPrincipalPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountAssignmentsForPrincipalPagesWithContext same as ListAccountAssignmentsForPrincipalPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountAssignmentsForPrincipalPagesWithContext(ctx aws.Context, input *ListAccountAssignmentsForPrincipalInput, fn func(*ListAccountAssignmentsForPrincipalOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountAssignmentsForPrincipalInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountAssignmentsForPrincipalRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountAssignmentsForPrincipalOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccountsForProvisionedPermissionSet = "ListAccountsForProvisionedPermissionSet"

// ListAccountsForProvisionedPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountsForProvisionedPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountsForProvisionedPermissionSet for more information on using the ListAccountsForProvisionedPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccountsForProvisionedPermissionSetRequest method.
//	req, resp := client.ListAccountsForProvisionedPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetRequest(input *ListAccountsForProvisionedPermissionSetInput) (req *request.Request, output *ListAccountsForProvisionedPermissionSetOutput) {
	op := &request.Operation{
		Name:       opListAccountsForProvisionedPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccountsForProvisionedPermissionSetInput{}
	}

	output = &ListAccountsForProvisionedPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountsForProvisionedPermissionSet API operation for AWS Single Sign-On Admin.
//
// Lists all the Amazon Web Services accounts where the specified permission
// set is provisioned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListAccountsForProvisionedPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListAccountsForProvisionedPermissionSet
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSet(input *ListAccountsForProvisionedPermissionSetInput) (*ListAccountsForProvisionedPermissionSetOutput, error) {
	req, out := c.ListAccountsForProvisionedPermissionSetRequest(input)
	return out, req.Send()
}

// ListAccountsForProvisionedPermissionSetWithContext is the same as ListAccountsForProvisionedPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountsForProvisionedPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetWithContext(ctx aws.Context, input *ListAccountsForProvisionedPermissionSetInput, opts ...request.Option) (*ListAccountsForProvisionedPermissionSetOutput, error) {
	req, out := c.ListAccountsForProvisionedPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccountsForProvisionedPermissionSetPages iterates over the pages of a ListAccountsForProvisionedPermissionSet operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccountsForProvisionedPermissionSet method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccountsForProvisionedPermissionSet operation.
//	pageNum := 0
//	err := client.ListAccountsForProvisionedPermissionSetPages(params,
//	    func(page *ssoadmin.ListAccountsForProvisionedPermissionSetOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetPages(input *ListAccountsForProvisionedPermissionSetInput, fn func(*ListAccountsForProvisionedPermissionSetOutput, bool) bool) error {
	return c.ListAccountsForProvisionedPermissionSetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccountsForProvisionedPermissionSetPagesWithContext same as ListAccountsForProvisionedPermissionSetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListAccountsForProvisionedPermissionSetPagesWithContext(ctx aws.Context, input *ListAccountsForProvisionedPermissionSetInput, fn func(*ListAccountsForProvisionedPermissionSetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccountsForProvisionedPermissionSetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccountsForProvisionedPermissionSetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccountsForProvisionedPermissionSetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationAccessScopes = "ListApplicationAccessScopes"

// ListApplicationAccessScopesRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationAccessScopes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationAccessScopes for more information on using the ListApplicationAccessScopes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationAccessScopesRequest method.
//	req, resp := client.ListApplicationAccessScopesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAccessScopes
func (c *SSOAdmin) ListApplicationAccessScopesRequest(input *ListApplicationAccessScopesInput) (req *request.Request, output *ListApplicationAccessScopesOutput) {
	op := &request.Operation{
		Name:       opListApplicationAccessScopes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationAccessScopesInput{}
	}

	output = &ListApplicationAccessScopesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationAccessScopes API operation for AWS Single Sign-On Admin.
//
// Lists the access scopes and authorized targets associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplicationAccessScopes for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAccessScopes
func (c *SSOAdmin) ListApplicationAccessScopes(input *ListApplicationAccessScopesInput) (*ListApplicationAccessScopesOutput, error) {
	req, out := c.ListApplicationAccessScopesRequest(input)
	return out, req.Send()
}

// ListApplicationAccessScopesWithContext is the same as ListApplicationAccessScopes with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationAccessScopes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAccessScopesWithContext(ctx aws.Context, input *ListApplicationAccessScopesInput, opts ...request.Option) (*ListApplicationAccessScopesOutput, error) {
	req, out := c.ListApplicationAccessScopesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationAccessScopesPages iterates over the pages of a ListApplicationAccessScopes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationAccessScopes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationAccessScopes operation.
//	pageNum := 0
//	err := client.ListApplicationAccessScopesPages(params,
//	    func(page *ssoadmin.ListApplicationAccessScopesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationAccessScopesPages(input *ListApplicationAccessScopesInput, fn func(*ListApplicationAccessScopesOutput, bool) bool) error {
	return c.ListApplicationAccessScopesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationAccessScopesPagesWithContext same as ListApplicationAccessScopesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAccessScopesPagesWithContext(ctx aws.Context, input *ListApplicationAccessScopesInput, fn func(*ListApplicationAccessScopesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationAccessScopesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationAccessScopesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationAccessScopesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationAssignments = "ListApplicationAssignments"

// ListApplicationAssignmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationAssignments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationAssignments for more information on using the ListApplicationAssignments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationAssignmentsRequest method.
//	req, resp := client.ListApplicationAssignmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignments
func (c *SSOAdmin) ListApplicationAssignmentsRequest(input *ListApplicationAssignmentsInput) (req *request.Request, output *ListApplicationAssignmentsOutput) {
	op := &request.Operation{
		Name:       opListApplicationAssignments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationAssignmentsInput{}
	}

	output = &ListApplicationAssignmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationAssignments API operation for AWS Single Sign-On Admin.
//
// Lists Amazon Web Services account users that are assigned to an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplicationAssignments for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignments
func (c *SSOAdmin) ListApplicationAssignments(input *ListApplicationAssignmentsInput) (*ListApplicationAssignmentsOutput, error) {
	req, out := c.ListApplicationAssignmentsRequest(input)
	return out, req.Send()
}

// ListApplicationAssignmentsWithContext is the same as ListApplicationAssignments with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationAssignments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAssignmentsWithContext(ctx aws.Context, input *ListApplicationAssignmentsInput, opts ...request.Option) (*ListApplicationAssignmentsOutput, error) {
	req, out := c.ListApplicationAssignmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationAssignmentsPages iterates over the pages of a ListApplicationAssignments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationAssignments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationAssignments operation.
//	pageNum := 0
//	err := client.ListApplicationAssignmentsPages(params,
//	    func(page *ssoadmin.ListApplicationAssignmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationAssignmentsPages(input *ListApplicationAssignmentsInput, fn func(*ListApplicationAssignmentsOutput, bool) bool) error {
	return c.ListApplicationAssignmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationAssignmentsPagesWithContext same as ListApplicationAssignmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAssignmentsPagesWithContext(ctx aws.Context, input *ListApplicationAssignmentsInput, fn func(*ListApplicationAssignmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationAssignmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationAssignmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationAssignmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationAssignmentsForPrincipal = "ListApplicationAssignmentsForPrincipal"

// ListApplicationAssignmentsForPrincipalRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationAssignmentsForPrincipal operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationAssignmentsForPrincipal for more information on using the ListApplicationAssignmentsForPrincipal
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationAssignmentsForPrincipalRequest method.
//	req, resp := client.ListApplicationAssignmentsForPrincipalRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignmentsForPrincipal
func (c *SSOAdmin) ListApplicationAssignmentsForPrincipalRequest(input *ListApplicationAssignmentsForPrincipalInput) (req *request.Request, output *ListApplicationAssignmentsForPrincipalOutput) {
	op := &request.Operation{
		Name:       opListApplicationAssignmentsForPrincipal,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationAssignmentsForPrincipalInput{}
	}

	output = &ListApplicationAssignmentsForPrincipalOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationAssignmentsForPrincipal API operation for AWS Single Sign-On Admin.
//
// Lists the applications to which a specified principal is assigned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplicationAssignmentsForPrincipal for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAssignmentsForPrincipal
func (c *SSOAdmin) ListApplicationAssignmentsForPrincipal(input *ListApplicationAssignmentsForPrincipalInput) (*ListApplicationAssignmentsForPrincipalOutput, error) {
	req, out := c.ListApplicationAssignmentsForPrincipalRequest(input)
	return out, req.Send()
}

// ListApplicationAssignmentsForPrincipalWithContext is the same as ListApplicationAssignmentsForPrincipal with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationAssignmentsForPrincipal for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAssignmentsForPrincipalWithContext(ctx aws.Context, input *ListApplicationAssignmentsForPrincipalInput, opts ...request.Option) (*ListApplicationAssignmentsForPrincipalOutput, error) {
	req, out := c.ListApplicationAssignmentsForPrincipalRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationAssignmentsForPrincipalPages iterates over the pages of a ListApplicationAssignmentsForPrincipal operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationAssignmentsForPrincipal method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationAssignmentsForPrincipal operation.
//	pageNum := 0
//	err := client.ListApplicationAssignmentsForPrincipalPages(params,
//	    func(page *ssoadmin.ListApplicationAssignmentsForPrincipalOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationAssignmentsForPrincipalPages(input *ListApplicationAssignmentsForPrincipalInput, fn func(*ListApplicationAssignmentsForPrincipalOutput, bool) bool) error {
	return c.ListApplicationAssignmentsForPrincipalPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationAssignmentsForPrincipalPagesWithContext same as ListApplicationAssignmentsForPrincipalPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAssignmentsForPrincipalPagesWithContext(ctx aws.Context, input *ListApplicationAssignmentsForPrincipalInput, fn func(*ListApplicationAssignmentsForPrincipalOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationAssignmentsForPrincipalInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationAssignmentsForPrincipalRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationAssignmentsForPrincipalOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationAuthenticationMethods = "ListApplicationAuthenticationMethods"

// ListApplicationAuthenticationMethodsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationAuthenticationMethods operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationAuthenticationMethods for more information on using the ListApplicationAuthenticationMethods
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationAuthenticationMethodsRequest method.
//	req, resp := client.ListApplicationAuthenticationMethodsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAuthenticationMethods
func (c *SSOAdmin) ListApplicationAuthenticationMethodsRequest(input *ListApplicationAuthenticationMethodsInput) (req *request.Request, output *ListApplicationAuthenticationMethodsOutput) {
	op := &request.Operation{
		Name:       opListApplicationAuthenticationMethods,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationAuthenticationMethodsInput{}
	}

	output = &ListApplicationAuthenticationMethodsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationAuthenticationMethods API operation for AWS Single Sign-On Admin.
//
// Lists all of the authentication methods supported by the specified application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplicationAuthenticationMethods for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationAuthenticationMethods
func (c *SSOAdmin) ListApplicationAuthenticationMethods(input *ListApplicationAuthenticationMethodsInput) (*ListApplicationAuthenticationMethodsOutput, error) {
	req, out := c.ListApplicationAuthenticationMethodsRequest(input)
	return out, req.Send()
}

// ListApplicationAuthenticationMethodsWithContext is the same as ListApplicationAuthenticationMethods with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationAuthenticationMethods for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAuthenticationMethodsWithContext(ctx aws.Context, input *ListApplicationAuthenticationMethodsInput, opts ...request.Option) (*ListApplicationAuthenticationMethodsOutput, error) {
	req, out := c.ListApplicationAuthenticationMethodsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationAuthenticationMethodsPages iterates over the pages of a ListApplicationAuthenticationMethods operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationAuthenticationMethods method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationAuthenticationMethods operation.
//	pageNum := 0
//	err := client.ListApplicationAuthenticationMethodsPages(params,
//	    func(page *ssoadmin.ListApplicationAuthenticationMethodsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationAuthenticationMethodsPages(input *ListApplicationAuthenticationMethodsInput, fn func(*ListApplicationAuthenticationMethodsOutput, bool) bool) error {
	return c.ListApplicationAuthenticationMethodsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationAuthenticationMethodsPagesWithContext same as ListApplicationAuthenticationMethodsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationAuthenticationMethodsPagesWithContext(ctx aws.Context, input *ListApplicationAuthenticationMethodsInput, fn func(*ListApplicationAuthenticationMethodsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationAuthenticationMethodsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationAuthenticationMethodsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationAuthenticationMethodsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationGrants = "ListApplicationGrants"

// ListApplicationGrantsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationGrants operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationGrants for more information on using the ListApplicationGrants
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationGrantsRequest method.
//	req, resp := client.ListApplicationGrantsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationGrants
func (c *SSOAdmin) ListApplicationGrantsRequest(input *ListApplicationGrantsInput) (req *request.Request, output *ListApplicationGrantsOutput) {
	op := &request.Operation{
		Name:       opListApplicationGrants,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationGrantsInput{}
	}

	output = &ListApplicationGrantsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationGrants API operation for AWS Single Sign-On Admin.
//
// List the grants associated with an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplicationGrants for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationGrants
func (c *SSOAdmin) ListApplicationGrants(input *ListApplicationGrantsInput) (*ListApplicationGrantsOutput, error) {
	req, out := c.ListApplicationGrantsRequest(input)
	return out, req.Send()
}

// ListApplicationGrantsWithContext is the same as ListApplicationGrants with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationGrants for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationGrantsWithContext(ctx aws.Context, input *ListApplicationGrantsInput, opts ...request.Option) (*ListApplicationGrantsOutput, error) {
	req, out := c.ListApplicationGrantsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationGrantsPages iterates over the pages of a ListApplicationGrants operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationGrants method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationGrants operation.
//	pageNum := 0
//	err := client.ListApplicationGrantsPages(params,
//	    func(page *ssoadmin.ListApplicationGrantsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationGrantsPages(input *ListApplicationGrantsInput, fn func(*ListApplicationGrantsOutput, bool) bool) error {
	return c.ListApplicationGrantsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationGrantsPagesWithContext same as ListApplicationGrantsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationGrantsPagesWithContext(ctx aws.Context, input *ListApplicationGrantsInput, fn func(*ListApplicationGrantsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationGrantsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationGrantsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationGrantsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplicationProviders = "ListApplicationProviders"

// ListApplicationProvidersRequest generates a "aws/request.Request" representing the
// client's request for the ListApplicationProviders operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplicationProviders for more information on using the ListApplicationProviders
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationProvidersRequest method.
//	req, resp := client.ListApplicationProvidersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationProviders
func (c *SSOAdmin) ListApplicationProvidersRequest(input *ListApplicationProvidersInput) (req *request.Request, output *ListApplicationProvidersOutput) {
	op := &request.Operation{
		Name:       opListApplicationProviders,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationProvidersInput{}
	}

	output = &ListApplicationProvidersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplicationProviders API operation for AWS Single Sign-On Admin.
//
// Lists the application providers configured in the IAM Identity Center identity
// store.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplicationProviders for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplicationProviders
func (c *SSOAdmin) ListApplicationProviders(input *ListApplicationProvidersInput) (*ListApplicationProvidersOutput, error) {
	req, out := c.ListApplicationProvidersRequest(input)
	return out, req.Send()
}

// ListApplicationProvidersWithContext is the same as ListApplicationProviders with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationProviders for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationProvidersWithContext(ctx aws.Context, input *ListApplicationProvidersInput, opts ...request.Option) (*ListApplicationProvidersOutput, error) {
	req, out := c.ListApplicationProvidersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationProvidersPages iterates over the pages of a ListApplicationProviders operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplicationProviders method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplicationProviders operation.
//	pageNum := 0
//	err := client.ListApplicationProvidersPages(params,
//	    func(page *ssoadmin.ListApplicationProvidersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationProvidersPages(input *ListApplicationProvidersInput, fn func(*ListApplicationProvidersOutput, bool) bool) error {
	return c.ListApplicationProvidersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationProvidersPagesWithContext same as ListApplicationProvidersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationProvidersPagesWithContext(ctx aws.Context, input *ListApplicationProvidersInput, fn func(*ListApplicationProvidersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationProvidersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationProvidersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationProvidersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApplicationsRequest method.
//	req, resp := client.ListApplicationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplications
func (c *SSOAdmin) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWS Single Sign-On Admin.
//
// Lists all applications associated with the instance of IAM Identity Center.
// When listing applications for an instance in the management account, member
// accounts must use the applicationAccount parameter to filter the list to
// only applications created from that account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListApplications
func (c *SSOAdmin) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApplications operation.
//	pageNum := 0
//	err := client.ListApplicationsPages(params,
//	    func(page *ssoadmin.ListApplicationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCustomerManagedPolicyReferencesInPermissionSet = "ListCustomerManagedPolicyReferencesInPermissionSet"

// ListCustomerManagedPolicyReferencesInPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomerManagedPolicyReferencesInPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomerManagedPolicyReferencesInPermissionSet for more information on using the ListCustomerManagedPolicyReferencesInPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomerManagedPolicyReferencesInPermissionSetRequest method.
//	req, resp := client.ListCustomerManagedPolicyReferencesInPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet
func (c *SSOAdmin) ListCustomerManagedPolicyReferencesInPermissionSetRequest(input *ListCustomerManagedPolicyReferencesInPermissionSetInput) (req *request.Request, output *ListCustomerManagedPolicyReferencesInPermissionSetOutput) {
	op := &request.Operation{
		Name:       opListCustomerManagedPolicyReferencesInPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomerManagedPolicyReferencesInPermissionSetInput{}
	}

	output = &ListCustomerManagedPolicyReferencesInPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomerManagedPolicyReferencesInPermissionSet API operation for AWS Single Sign-On Admin.
//
// Lists all customer managed policies attached to a specified PermissionSet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListCustomerManagedPolicyReferencesInPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListCustomerManagedPolicyReferencesInPermissionSet
func (c *SSOAdmin) ListCustomerManagedPolicyReferencesInPermissionSet(input *ListCustomerManagedPolicyReferencesInPermissionSetInput) (*ListCustomerManagedPolicyReferencesInPermissionSetOutput, error) {
	req, out := c.ListCustomerManagedPolicyReferencesInPermissionSetRequest(input)
	return out, req.Send()
}

// ListCustomerManagedPolicyReferencesInPermissionSetWithContext is the same as ListCustomerManagedPolicyReferencesInPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomerManagedPolicyReferencesInPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListCustomerManagedPolicyReferencesInPermissionSetWithContext(ctx aws.Context, input *ListCustomerManagedPolicyReferencesInPermissionSetInput, opts ...request.Option) (*ListCustomerManagedPolicyReferencesInPermissionSetOutput, error) {
	req, out := c.ListCustomerManagedPolicyReferencesInPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomerManagedPolicyReferencesInPermissionSetPages iterates over the pages of a ListCustomerManagedPolicyReferencesInPermissionSet operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomerManagedPolicyReferencesInPermissionSet method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomerManagedPolicyReferencesInPermissionSet operation.
//	pageNum := 0
//	err := client.ListCustomerManagedPolicyReferencesInPermissionSetPages(params,
//	    func(page *ssoadmin.ListCustomerManagedPolicyReferencesInPermissionSetOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListCustomerManagedPolicyReferencesInPermissionSetPages(input *ListCustomerManagedPolicyReferencesInPermissionSetInput, fn func(*ListCustomerManagedPolicyReferencesInPermissionSetOutput, bool) bool) error {
	return c.ListCustomerManagedPolicyReferencesInPermissionSetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomerManagedPolicyReferencesInPermissionSetPagesWithContext same as ListCustomerManagedPolicyReferencesInPermissionSetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListCustomerManagedPolicyReferencesInPermissionSetPagesWithContext(ctx aws.Context, input *ListCustomerManagedPolicyReferencesInPermissionSetInput, fn func(*ListCustomerManagedPolicyReferencesInPermissionSetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomerManagedPolicyReferencesInPermissionSetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomerManagedPolicyReferencesInPermissionSetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomerManagedPolicyReferencesInPermissionSetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstancesRequest method.
//	req, resp := client.ListInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances
func (c *SSOAdmin) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for AWS Single Sign-On Admin.
//
// Lists the details of the organization and account instances of IAM Identity
// Center that were created in or visible to the account calling this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListInstances for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListInstances
func (c *SSOAdmin) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInstances operation.
//	pageNum := 0
//	err := client.ListInstancesPages(params,
//	    func(page *ssoadmin.ListInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListManagedPoliciesInPermissionSet = "ListManagedPoliciesInPermissionSet"

// ListManagedPoliciesInPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ListManagedPoliciesInPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListManagedPoliciesInPermissionSet for more information on using the ListManagedPoliciesInPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListManagedPoliciesInPermissionSetRequest method.
//	req, resp := client.ListManagedPoliciesInPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetRequest(input *ListManagedPoliciesInPermissionSetInput) (req *request.Request, output *ListManagedPoliciesInPermissionSetOutput) {
	op := &request.Operation{
		Name:       opListManagedPoliciesInPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListManagedPoliciesInPermissionSetInput{}
	}

	output = &ListManagedPoliciesInPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListManagedPoliciesInPermissionSet API operation for AWS Single Sign-On Admin.
//
// Lists the Amazon Web Services managed policy that is attached to a specified
// permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListManagedPoliciesInPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListManagedPoliciesInPermissionSet
func (c *SSOAdmin) ListManagedPoliciesInPermissionSet(input *ListManagedPoliciesInPermissionSetInput) (*ListManagedPoliciesInPermissionSetOutput, error) {
	req, out := c.ListManagedPoliciesInPermissionSetRequest(input)
	return out, req.Send()
}

// ListManagedPoliciesInPermissionSetWithContext is the same as ListManagedPoliciesInPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ListManagedPoliciesInPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetWithContext(ctx aws.Context, input *ListManagedPoliciesInPermissionSetInput, opts ...request.Option) (*ListManagedPoliciesInPermissionSetOutput, error) {
	req, out := c.ListManagedPoliciesInPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListManagedPoliciesInPermissionSetPages iterates over the pages of a ListManagedPoliciesInPermissionSet operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListManagedPoliciesInPermissionSet method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListManagedPoliciesInPermissionSet operation.
//	pageNum := 0
//	err := client.ListManagedPoliciesInPermissionSetPages(params,
//	    func(page *ssoadmin.ListManagedPoliciesInPermissionSetOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetPages(input *ListManagedPoliciesInPermissionSetInput, fn func(*ListManagedPoliciesInPermissionSetOutput, bool) bool) error {
	return c.ListManagedPoliciesInPermissionSetPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListManagedPoliciesInPermissionSetPagesWithContext same as ListManagedPoliciesInPermissionSetPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListManagedPoliciesInPermissionSetPagesWithContext(ctx aws.Context, input *ListManagedPoliciesInPermissionSetInput, fn func(*ListManagedPoliciesInPermissionSetOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListManagedPoliciesInPermissionSetInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListManagedPoliciesInPermissionSetRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListManagedPoliciesInPermissionSetOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionSetProvisioningStatus = "ListPermissionSetProvisioningStatus"

// ListPermissionSetProvisioningStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionSetProvisioningStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionSetProvisioningStatus for more information on using the ListPermissionSetProvisioningStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionSetProvisioningStatusRequest method.
//	req, resp := client.ListPermissionSetProvisioningStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus
func (c *SSOAdmin) ListPermissionSetProvisioningStatusRequest(input *ListPermissionSetProvisioningStatusInput) (req *request.Request, output *ListPermissionSetProvisioningStatusOutput) {
	op := &request.Operation{
		Name:       opListPermissionSetProvisioningStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionSetProvisioningStatusInput{}
	}

	output = &ListPermissionSetProvisioningStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionSetProvisioningStatus API operation for AWS Single Sign-On Admin.
//
// Lists the status of the permission set provisioning requests for a specified
// IAM Identity Center instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListPermissionSetProvisioningStatus for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetProvisioningStatus
func (c *SSOAdmin) ListPermissionSetProvisioningStatus(input *ListPermissionSetProvisioningStatusInput) (*ListPermissionSetProvisioningStatusOutput, error) {
	req, out := c.ListPermissionSetProvisioningStatusRequest(input)
	return out, req.Send()
}

// ListPermissionSetProvisioningStatusWithContext is the same as ListPermissionSetProvisioningStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSetProvisioningStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetProvisioningStatusWithContext(ctx aws.Context, input *ListPermissionSetProvisioningStatusInput, opts ...request.Option) (*ListPermissionSetProvisioningStatusOutput, error) {
	req, out := c.ListPermissionSetProvisioningStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionSetProvisioningStatusPages iterates over the pages of a ListPermissionSetProvisioningStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionSetProvisioningStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissionSetProvisioningStatus operation.
//	pageNum := 0
//	err := client.ListPermissionSetProvisioningStatusPages(params,
//	    func(page *ssoadmin.ListPermissionSetProvisioningStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListPermissionSetProvisioningStatusPages(input *ListPermissionSetProvisioningStatusInput, fn func(*ListPermissionSetProvisioningStatusOutput, bool) bool) error {
	return c.ListPermissionSetProvisioningStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionSetProvisioningStatusPagesWithContext same as ListPermissionSetProvisioningStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetProvisioningStatusPagesWithContext(ctx aws.Context, input *ListPermissionSetProvisioningStatusInput, fn func(*ListPermissionSetProvisioningStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionSetProvisioningStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionSetProvisioningStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionSetProvisioningStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionSets = "ListPermissionSets"

// ListPermissionSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionSets for more information on using the ListPermissionSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionSetsRequest method.
//	req, resp := client.ListPermissionSetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets
func (c *SSOAdmin) ListPermissionSetsRequest(input *ListPermissionSetsInput) (req *request.Request, output *ListPermissionSetsOutput) {
	op := &request.Operation{
		Name:       opListPermissionSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionSetsInput{}
	}

	output = &ListPermissionSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionSets API operation for AWS Single Sign-On Admin.
//
// Lists the PermissionSets in an IAM Identity Center instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListPermissionSets for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSets
func (c *SSOAdmin) ListPermissionSets(input *ListPermissionSetsInput) (*ListPermissionSetsOutput, error) {
	req, out := c.ListPermissionSetsRequest(input)
	return out, req.Send()
}

// ListPermissionSetsWithContext is the same as ListPermissionSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsWithContext(ctx aws.Context, input *ListPermissionSetsInput, opts ...request.Option) (*ListPermissionSetsOutput, error) {
	req, out := c.ListPermissionSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionSetsPages iterates over the pages of a ListPermissionSets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionSets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissionSets operation.
//	pageNum := 0
//	err := client.ListPermissionSetsPages(params,
//	    func(page *ssoadmin.ListPermissionSetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListPermissionSetsPages(input *ListPermissionSetsInput, fn func(*ListPermissionSetsOutput, bool) bool) error {
	return c.ListPermissionSetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionSetsPagesWithContext same as ListPermissionSetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsPagesWithContext(ctx aws.Context, input *ListPermissionSetsInput, fn func(*ListPermissionSetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionSetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionSetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionSetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPermissionSetsProvisionedToAccount = "ListPermissionSetsProvisionedToAccount"

// ListPermissionSetsProvisionedToAccountRequest generates a "aws/request.Request" representing the
// client's request for the ListPermissionSetsProvisionedToAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPermissionSetsProvisionedToAccount for more information on using the ListPermissionSetsProvisionedToAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPermissionSetsProvisionedToAccountRequest method.
//	req, resp := client.ListPermissionSetsProvisionedToAccountRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountRequest(input *ListPermissionSetsProvisionedToAccountInput) (req *request.Request, output *ListPermissionSetsProvisionedToAccountOutput) {
	op := &request.Operation{
		Name:       opListPermissionSetsProvisionedToAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPermissionSetsProvisionedToAccountInput{}
	}

	output = &ListPermissionSetsProvisionedToAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPermissionSetsProvisionedToAccount API operation for AWS Single Sign-On Admin.
//
// Lists all the permission sets that are provisioned to a specified Amazon
// Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListPermissionSetsProvisionedToAccount for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListPermissionSetsProvisionedToAccount
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccount(input *ListPermissionSetsProvisionedToAccountInput) (*ListPermissionSetsProvisionedToAccountOutput, error) {
	req, out := c.ListPermissionSetsProvisionedToAccountRequest(input)
	return out, req.Send()
}

// ListPermissionSetsProvisionedToAccountWithContext is the same as ListPermissionSetsProvisionedToAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSetsProvisionedToAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountWithContext(ctx aws.Context, input *ListPermissionSetsProvisionedToAccountInput, opts ...request.Option) (*ListPermissionSetsProvisionedToAccountOutput, error) {
	req, out := c.ListPermissionSetsProvisionedToAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPermissionSetsProvisionedToAccountPages iterates over the pages of a ListPermissionSetsProvisionedToAccount operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPermissionSetsProvisionedToAccount method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPermissionSetsProvisionedToAccount operation.
//	pageNum := 0
//	err := client.ListPermissionSetsProvisionedToAccountPages(params,
//	    func(page *ssoadmin.ListPermissionSetsProvisionedToAccountOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountPages(input *ListPermissionSetsProvisionedToAccountInput, fn func(*ListPermissionSetsProvisionedToAccountOutput, bool) bool) error {
	return c.ListPermissionSetsProvisionedToAccountPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPermissionSetsProvisionedToAccountPagesWithContext same as ListPermissionSetsProvisionedToAccountPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListPermissionSetsProvisionedToAccountPagesWithContext(ctx aws.Context, input *ListPermissionSetsProvisionedToAccountInput, fn func(*ListPermissionSetsProvisionedToAccountOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPermissionSetsProvisionedToAccountInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPermissionSetsProvisionedToAccountRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPermissionSetsProvisionedToAccountOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource
func (c *SSOAdmin) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Single Sign-On Admin.
//
// Lists the tags that are attached to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTagsForResource
func (c *SSOAdmin) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsForResourcePages iterates over the pages of a ListTagsForResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTagsForResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTagsForResource operation.
//	pageNum := 0
//	err := client.ListTagsForResourcePages(params,
//	    func(page *ssoadmin.ListTagsForResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListTagsForResourcePages(input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool) error {
	return c.ListTagsForResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsForResourcePagesWithContext same as ListTagsForResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListTagsForResourcePagesWithContext(ctx aws.Context, input *ListTagsForResourceInput, fn func(*ListTagsForResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsForResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsForResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsForResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrustedTokenIssuers = "ListTrustedTokenIssuers"

// ListTrustedTokenIssuersRequest generates a "aws/request.Request" representing the
// client's request for the ListTrustedTokenIssuers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrustedTokenIssuers for more information on using the ListTrustedTokenIssuers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrustedTokenIssuersRequest method.
//	req, resp := client.ListTrustedTokenIssuersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTrustedTokenIssuers
func (c *SSOAdmin) ListTrustedTokenIssuersRequest(input *ListTrustedTokenIssuersInput) (req *request.Request, output *ListTrustedTokenIssuersOutput) {
	op := &request.Operation{
		Name:       opListTrustedTokenIssuers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrustedTokenIssuersInput{}
	}

	output = &ListTrustedTokenIssuersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrustedTokenIssuers API operation for AWS Single Sign-On Admin.
//
// Lists all the trusted token issuers configured in an instance of IAM Identity
// Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ListTrustedTokenIssuers for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ListTrustedTokenIssuers
func (c *SSOAdmin) ListTrustedTokenIssuers(input *ListTrustedTokenIssuersInput) (*ListTrustedTokenIssuersOutput, error) {
	req, out := c.ListTrustedTokenIssuersRequest(input)
	return out, req.Send()
}

// ListTrustedTokenIssuersWithContext is the same as ListTrustedTokenIssuers with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrustedTokenIssuers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListTrustedTokenIssuersWithContext(ctx aws.Context, input *ListTrustedTokenIssuersInput, opts ...request.Option) (*ListTrustedTokenIssuersOutput, error) {
	req, out := c.ListTrustedTokenIssuersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrustedTokenIssuersPages iterates over the pages of a ListTrustedTokenIssuers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrustedTokenIssuers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrustedTokenIssuers operation.
//	pageNum := 0
//	err := client.ListTrustedTokenIssuersPages(params,
//	    func(page *ssoadmin.ListTrustedTokenIssuersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *SSOAdmin) ListTrustedTokenIssuersPages(input *ListTrustedTokenIssuersInput, fn func(*ListTrustedTokenIssuersOutput, bool) bool) error {
	return c.ListTrustedTokenIssuersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrustedTokenIssuersPagesWithContext same as ListTrustedTokenIssuersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ListTrustedTokenIssuersPagesWithContext(ctx aws.Context, input *ListTrustedTokenIssuersInput, fn func(*ListTrustedTokenIssuersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrustedTokenIssuersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrustedTokenIssuersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrustedTokenIssuersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opProvisionPermissionSet = "ProvisionPermissionSet"

// ProvisionPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the ProvisionPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ProvisionPermissionSet for more information on using the ProvisionPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ProvisionPermissionSetRequest method.
//	req, resp := client.ProvisionPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet
func (c *SSOAdmin) ProvisionPermissionSetRequest(input *ProvisionPermissionSetInput) (req *request.Request, output *ProvisionPermissionSetOutput) {
	op := &request.Operation{
		Name:       opProvisionPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ProvisionPermissionSetInput{}
	}

	output = &ProvisionPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ProvisionPermissionSet API operation for AWS Single Sign-On Admin.
//
// The process by which a specified permission set is provisioned to the specified
// target.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation ProvisionPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/ProvisionPermissionSet
func (c *SSOAdmin) ProvisionPermissionSet(input *ProvisionPermissionSetInput) (*ProvisionPermissionSetOutput, error) {
	req, out := c.ProvisionPermissionSetRequest(input)
	return out, req.Send()
}

// ProvisionPermissionSetWithContext is the same as ProvisionPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See ProvisionPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) ProvisionPermissionSetWithContext(ctx aws.Context, input *ProvisionPermissionSetInput, opts ...request.Option) (*ProvisionPermissionSetOutput, error) {
	req, out := c.ProvisionPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutApplicationAccessScope = "PutApplicationAccessScope"

// PutApplicationAccessScopeRequest generates a "aws/request.Request" representing the
// client's request for the PutApplicationAccessScope operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApplicationAccessScope for more information on using the PutApplicationAccessScope
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutApplicationAccessScopeRequest method.
//	req, resp := client.PutApplicationAccessScopeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAccessScope
func (c *SSOAdmin) PutApplicationAccessScopeRequest(input *PutApplicationAccessScopeInput) (req *request.Request, output *PutApplicationAccessScopeOutput) {
	op := &request.Operation{
		Name:       opPutApplicationAccessScope,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApplicationAccessScopeInput{}
	}

	output = &PutApplicationAccessScopeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutApplicationAccessScope API operation for AWS Single Sign-On Admin.
//
// Adds or updates the list of authorized targets for an IAM Identity Center
// access scope for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutApplicationAccessScope for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAccessScope
func (c *SSOAdmin) PutApplicationAccessScope(input *PutApplicationAccessScopeInput) (*PutApplicationAccessScopeOutput, error) {
	req, out := c.PutApplicationAccessScopeRequest(input)
	return out, req.Send()
}

// PutApplicationAccessScopeWithContext is the same as PutApplicationAccessScope with the addition of
// the ability to pass a context and additional request options.
//
// See PutApplicationAccessScope for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutApplicationAccessScopeWithContext(ctx aws.Context, input *PutApplicationAccessScopeInput, opts ...request.Option) (*PutApplicationAccessScopeOutput, error) {
	req, out := c.PutApplicationAccessScopeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutApplicationAssignmentConfiguration = "PutApplicationAssignmentConfiguration"

// PutApplicationAssignmentConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutApplicationAssignmentConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApplicationAssignmentConfiguration for more information on using the PutApplicationAssignmentConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutApplicationAssignmentConfigurationRequest method.
//	req, resp := client.PutApplicationAssignmentConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAssignmentConfiguration
func (c *SSOAdmin) PutApplicationAssignmentConfigurationRequest(input *PutApplicationAssignmentConfigurationInput) (req *request.Request, output *PutApplicationAssignmentConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutApplicationAssignmentConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApplicationAssignmentConfigurationInput{}
	}

	output = &PutApplicationAssignmentConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutApplicationAssignmentConfiguration API operation for AWS Single Sign-On Admin.
//
// Configure how users gain access to an application. If AssignmentsRequired
// is true (default value), users don’t have access to the application unless
// an assignment is created using the CreateApplicationAssignment API (https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html).
// If false, all users have access to the application. If an assignment is created
// using CreateApplicationAssignment (https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html).,
// the user retains access if AssignmentsRequired is set to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutApplicationAssignmentConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAssignmentConfiguration
func (c *SSOAdmin) PutApplicationAssignmentConfiguration(input *PutApplicationAssignmentConfigurationInput) (*PutApplicationAssignmentConfigurationOutput, error) {
	req, out := c.PutApplicationAssignmentConfigurationRequest(input)
	return out, req.Send()
}

// PutApplicationAssignmentConfigurationWithContext is the same as PutApplicationAssignmentConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutApplicationAssignmentConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutApplicationAssignmentConfigurationWithContext(ctx aws.Context, input *PutApplicationAssignmentConfigurationInput, opts ...request.Option) (*PutApplicationAssignmentConfigurationOutput, error) {
	req, out := c.PutApplicationAssignmentConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutApplicationAuthenticationMethod = "PutApplicationAuthenticationMethod"

// PutApplicationAuthenticationMethodRequest generates a "aws/request.Request" representing the
// client's request for the PutApplicationAuthenticationMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApplicationAuthenticationMethod for more information on using the PutApplicationAuthenticationMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutApplicationAuthenticationMethodRequest method.
//	req, resp := client.PutApplicationAuthenticationMethodRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAuthenticationMethod
func (c *SSOAdmin) PutApplicationAuthenticationMethodRequest(input *PutApplicationAuthenticationMethodInput) (req *request.Request, output *PutApplicationAuthenticationMethodOutput) {
	op := &request.Operation{
		Name:       opPutApplicationAuthenticationMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApplicationAuthenticationMethodInput{}
	}

	output = &PutApplicationAuthenticationMethodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutApplicationAuthenticationMethod API operation for AWS Single Sign-On Admin.
//
// Adds or updates an authentication method for an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutApplicationAuthenticationMethod for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationAuthenticationMethod
func (c *SSOAdmin) PutApplicationAuthenticationMethod(input *PutApplicationAuthenticationMethodInput) (*PutApplicationAuthenticationMethodOutput, error) {
	req, out := c.PutApplicationAuthenticationMethodRequest(input)
	return out, req.Send()
}

// PutApplicationAuthenticationMethodWithContext is the same as PutApplicationAuthenticationMethod with the addition of
// the ability to pass a context and additional request options.
//
// See PutApplicationAuthenticationMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutApplicationAuthenticationMethodWithContext(ctx aws.Context, input *PutApplicationAuthenticationMethodInput, opts ...request.Option) (*PutApplicationAuthenticationMethodOutput, error) {
	req, out := c.PutApplicationAuthenticationMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutApplicationGrant = "PutApplicationGrant"

// PutApplicationGrantRequest generates a "aws/request.Request" representing the
// client's request for the PutApplicationGrant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutApplicationGrant for more information on using the PutApplicationGrant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutApplicationGrantRequest method.
//	req, resp := client.PutApplicationGrantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationGrant
func (c *SSOAdmin) PutApplicationGrantRequest(input *PutApplicationGrantInput) (req *request.Request, output *PutApplicationGrantOutput) {
	op := &request.Operation{
		Name:       opPutApplicationGrant,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutApplicationGrantInput{}
	}

	output = &PutApplicationGrantOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutApplicationGrant API operation for AWS Single Sign-On Admin.
//
// Adds a grant to an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutApplicationGrant for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutApplicationGrant
func (c *SSOAdmin) PutApplicationGrant(input *PutApplicationGrantInput) (*PutApplicationGrantOutput, error) {
	req, out := c.PutApplicationGrantRequest(input)
	return out, req.Send()
}

// PutApplicationGrantWithContext is the same as PutApplicationGrant with the addition of
// the ability to pass a context and additional request options.
//
// See PutApplicationGrant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutApplicationGrantWithContext(ctx aws.Context, input *PutApplicationGrantInput, opts ...request.Option) (*PutApplicationGrantOutput, error) {
	req, out := c.PutApplicationGrantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutInlinePolicyToPermissionSet = "PutInlinePolicyToPermissionSet"

// PutInlinePolicyToPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the PutInlinePolicyToPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutInlinePolicyToPermissionSet for more information on using the PutInlinePolicyToPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutInlinePolicyToPermissionSetRequest method.
//	req, resp := client.PutInlinePolicyToPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet
func (c *SSOAdmin) PutInlinePolicyToPermissionSetRequest(input *PutInlinePolicyToPermissionSetInput) (req *request.Request, output *PutInlinePolicyToPermissionSetOutput) {
	op := &request.Operation{
		Name:       opPutInlinePolicyToPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInlinePolicyToPermissionSetInput{}
	}

	output = &PutInlinePolicyToPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutInlinePolicyToPermissionSet API operation for AWS Single Sign-On Admin.
//
// Attaches an inline policy to a permission set.
//
// If the permission set is already referenced by one or more account assignments,
// you will need to call ProvisionPermissionSet after this action to apply the
// corresponding IAM policy updates to all assigned accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutInlinePolicyToPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutInlinePolicyToPermissionSet
func (c *SSOAdmin) PutInlinePolicyToPermissionSet(input *PutInlinePolicyToPermissionSetInput) (*PutInlinePolicyToPermissionSetOutput, error) {
	req, out := c.PutInlinePolicyToPermissionSetRequest(input)
	return out, req.Send()
}

// PutInlinePolicyToPermissionSetWithContext is the same as PutInlinePolicyToPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See PutInlinePolicyToPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutInlinePolicyToPermissionSetWithContext(ctx aws.Context, input *PutInlinePolicyToPermissionSetInput, opts ...request.Option) (*PutInlinePolicyToPermissionSetOutput, error) {
	req, out := c.PutInlinePolicyToPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPermissionsBoundaryToPermissionSet = "PutPermissionsBoundaryToPermissionSet"

// PutPermissionsBoundaryToPermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the PutPermissionsBoundaryToPermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPermissionsBoundaryToPermissionSet for more information on using the PutPermissionsBoundaryToPermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutPermissionsBoundaryToPermissionSetRequest method.
//	req, resp := client.PutPermissionsBoundaryToPermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet
func (c *SSOAdmin) PutPermissionsBoundaryToPermissionSetRequest(input *PutPermissionsBoundaryToPermissionSetInput) (req *request.Request, output *PutPermissionsBoundaryToPermissionSetOutput) {
	op := &request.Operation{
		Name:       opPutPermissionsBoundaryToPermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPermissionsBoundaryToPermissionSetInput{}
	}

	output = &PutPermissionsBoundaryToPermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPermissionsBoundaryToPermissionSet API operation for AWS Single Sign-On Admin.
//
// Attaches an Amazon Web Services managed or customer managed policy to the
// specified PermissionSet as a permissions boundary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation PutPermissionsBoundaryToPermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/PutPermissionsBoundaryToPermissionSet
func (c *SSOAdmin) PutPermissionsBoundaryToPermissionSet(input *PutPermissionsBoundaryToPermissionSetInput) (*PutPermissionsBoundaryToPermissionSetOutput, error) {
	req, out := c.PutPermissionsBoundaryToPermissionSetRequest(input)
	return out, req.Send()
}

// PutPermissionsBoundaryToPermissionSetWithContext is the same as PutPermissionsBoundaryToPermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See PutPermissionsBoundaryToPermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) PutPermissionsBoundaryToPermissionSetWithContext(ctx aws.Context, input *PutPermissionsBoundaryToPermissionSetInput, opts ...request.Option) (*PutPermissionsBoundaryToPermissionSetOutput, error) {
	req, out := c.PutPermissionsBoundaryToPermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource
func (c *SSOAdmin) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Single Sign-On Admin.
//
// Associates a set of tags with a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ServiceQuotaExceededException
//     Indicates that the principal has crossed the permitted number of resources
//     that can be created.
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/TagResource
func (c *SSOAdmin) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource
func (c *SSOAdmin) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Single Sign-On Admin.
//
// Disassociates a set of tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UntagResource
func (c *SSOAdmin) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateApplicationRequest method.
//	req, resp := client.UpdateApplicationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateApplication
func (c *SSOAdmin) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApplication API operation for AWS Single Sign-On Admin.
//
// Updates application properties.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateApplication
func (c *SSOAdmin) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstance = "UpdateInstance"

// UpdateInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstance for more information on using the UpdateInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceRequest method.
//	req, resp := client.UpdateInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstance
func (c *SSOAdmin) UpdateInstanceRequest(input *UpdateInstanceInput) (req *request.Request, output *UpdateInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceInput{}
	}

	output = &UpdateInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstance API operation for AWS Single Sign-On Admin.
//
// Update the details for the instance of IAM Identity Center that is owned
// by the Amazon Web Services account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdateInstance for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstance
func (c *SSOAdmin) UpdateInstance(input *UpdateInstanceInput) (*UpdateInstanceOutput, error) {
	req, out := c.UpdateInstanceRequest(input)
	return out, req.Send()
}

// UpdateInstanceWithContext is the same as UpdateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdateInstanceWithContext(ctx aws.Context, input *UpdateInstanceInput, opts ...request.Option) (*UpdateInstanceOutput, error) {
	req, out := c.UpdateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceAccessControlAttributeConfiguration = "UpdateInstanceAccessControlAttributeConfiguration"

// UpdateInstanceAccessControlAttributeConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceAccessControlAttributeConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceAccessControlAttributeConfiguration for more information on using the UpdateInstanceAccessControlAttributeConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceAccessControlAttributeConfigurationRequest method.
//	req, resp := client.UpdateInstanceAccessControlAttributeConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) UpdateInstanceAccessControlAttributeConfigurationRequest(input *UpdateInstanceAccessControlAttributeConfigurationInput) (req *request.Request, output *UpdateInstanceAccessControlAttributeConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceAccessControlAttributeConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceAccessControlAttributeConfigurationInput{}
	}

	output = &UpdateInstanceAccessControlAttributeConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceAccessControlAttributeConfiguration API operation for AWS Single Sign-On Admin.
//
// Updates the IAM Identity Center identity store attributes that you can use
// with the IAM Identity Center instance for attributes-based access control
// (ABAC). When using an external identity provider as an identity source, you
// can pass attributes through the SAML assertion as an alternative to configuring
// attributes from the IAM Identity Center identity store. If a SAML assertion
// passes any of these attributes, IAM Identity Center replaces the attribute
// value with the value from the IAM Identity Center identity store. For more
// information about ABAC, see Attribute-Based Access Control (/singlesignon/latest/userguide/abac.html)
// in the IAM Identity Center User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdateInstanceAccessControlAttributeConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateInstanceAccessControlAttributeConfiguration
func (c *SSOAdmin) UpdateInstanceAccessControlAttributeConfiguration(input *UpdateInstanceAccessControlAttributeConfigurationInput) (*UpdateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.UpdateInstanceAccessControlAttributeConfigurationRequest(input)
	return out, req.Send()
}

// UpdateInstanceAccessControlAttributeConfigurationWithContext is the same as UpdateInstanceAccessControlAttributeConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceAccessControlAttributeConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdateInstanceAccessControlAttributeConfigurationWithContext(ctx aws.Context, input *UpdateInstanceAccessControlAttributeConfigurationInput, opts ...request.Option) (*UpdateInstanceAccessControlAttributeConfigurationOutput, error) {
	req, out := c.UpdateInstanceAccessControlAttributeConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePermissionSet = "UpdatePermissionSet"

// UpdatePermissionSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePermissionSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePermissionSet for more information on using the UpdatePermissionSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePermissionSetRequest method.
//	req, resp := client.UpdatePermissionSetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet
func (c *SSOAdmin) UpdatePermissionSetRequest(input *UpdatePermissionSetInput) (req *request.Request, output *UpdatePermissionSetOutput) {
	op := &request.Operation{
		Name:       opUpdatePermissionSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePermissionSetInput{}
	}

	output = &UpdatePermissionSetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdatePermissionSet API operation for AWS Single Sign-On Admin.
//
// Updates an existing permission set.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdatePermissionSet for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdatePermissionSet
func (c *SSOAdmin) UpdatePermissionSet(input *UpdatePermissionSetInput) (*UpdatePermissionSetOutput, error) {
	req, out := c.UpdatePermissionSetRequest(input)
	return out, req.Send()
}

// UpdatePermissionSetWithContext is the same as UpdatePermissionSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePermissionSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdatePermissionSetWithContext(ctx aws.Context, input *UpdatePermissionSetInput, opts ...request.Option) (*UpdatePermissionSetOutput, error) {
	req, out := c.UpdatePermissionSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrustedTokenIssuer = "UpdateTrustedTokenIssuer"

// UpdateTrustedTokenIssuerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrustedTokenIssuer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrustedTokenIssuer for more information on using the UpdateTrustedTokenIssuer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTrustedTokenIssuerRequest method.
//	req, resp := client.UpdateTrustedTokenIssuerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateTrustedTokenIssuer
func (c *SSOAdmin) UpdateTrustedTokenIssuerRequest(input *UpdateTrustedTokenIssuerInput) (req *request.Request, output *UpdateTrustedTokenIssuerOutput) {
	op := &request.Operation{
		Name:       opUpdateTrustedTokenIssuer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateTrustedTokenIssuerInput{}
	}

	output = &UpdateTrustedTokenIssuerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTrustedTokenIssuer API operation for AWS Single Sign-On Admin.
//
// Updates the name of the trusted token issuer, or the path of a source attribute
// or destination attribute for a trusted token issuer configuration.
//
// Updating this trusted token issuer configuration might cause users to lose
// access to any applications that are configured to use the trusted token issuer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Single Sign-On Admin's
// API operation UpdateTrustedTokenIssuer for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     Indicates that the principal has crossed the throttling limits of the API
//     operations.
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception,
//     or failure with an internal server.
//
//   - ResourceNotFoundException
//     Indicates that a requested resource is not found.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ValidationException
//     The request failed because it contains a syntax error.
//
//   - ConflictException
//     Occurs when a conflict with a previous successful write is detected. This
//     generally occurs when the previous write did not have time to propagate to
//     the host serving the current request. A retry (with appropriate backoff logic)
//     is the recommended response to this exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/sso-admin-2020-07-20/UpdateTrustedTokenIssuer
func (c *SSOAdmin) UpdateTrustedTokenIssuer(input *UpdateTrustedTokenIssuerInput) (*UpdateTrustedTokenIssuerOutput, error) {
	req, out := c.UpdateTrustedTokenIssuerRequest(input)
	return out, req.Send()
}

// UpdateTrustedTokenIssuerWithContext is the same as UpdateTrustedTokenIssuer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrustedTokenIssuer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SSOAdmin) UpdateTrustedTokenIssuerWithContext(ctx aws.Context, input *UpdateTrustedTokenIssuerInput, opts ...request.Option) (*UpdateTrustedTokenIssuerOutput, error) {
	req, out := c.UpdateTrustedTokenIssuerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// These are IAM Identity Center identity store attributes that you can configure
// for use in attributes-based access control (ABAC). You can create permissions
// policies that determine who can access your Amazon Web Services resources
// based upon the configured attribute values. When you enable ABAC and specify
// AccessControlAttributes, IAM Identity Center passes the attribute values
// of the authenticated user into IAM for use in policy evaluation.
type AccessControlAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the attribute associated with your identities in your identity
	// source. This is used to map a specified attribute in your identity source
	// with an attribute in IAM Identity Center.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value used for mapping a specified attribute to an identity source.
	//
	// Value is a required field
	Value *AccessControlAttributeValue `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlAttribute"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil {
		if err := s.Value.Validate(); err != nil {
			invalidParams.AddNested("Value", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *AccessControlAttribute) SetKey(v string) *AccessControlAttribute {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AccessControlAttribute) SetValue(v *AccessControlAttributeValue) *AccessControlAttribute {
	s.Value = v
	return s
}

// The value used for mapping a specified attribute to an identity source. For
// more information, see Attribute mappings (https://docs.aws.amazon.com/singlesignon/latest/userguide/attributemappingsconcept.html)
// in the IAM Identity Center User Guide.
type AccessControlAttributeValue struct {
	_ struct{} `type:"structure"`

	// The identity source to use when mapping a specified attribute to IAM Identity
	// Center.
	//
	// Source is a required field
	Source []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessControlAttributeValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccessControlAttributeValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AccessControlAttributeValue"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *AccessControlAttributeValue) SetSource(v []*string) *AccessControlAttributeValue {
	s.Source = v
	return s
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The assignment that indicates a principal's limited access to a specified
// Amazon Web Services account with a specified permission set.
//
// The term principal here refers to a user or group that is defined in IAM
// Identity Center.
type AccountAssignment struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	PrincipalId *string `min:"1" type:"string"`

	// The entity type for which the assignment will be created.
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignment) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountAssignment) SetAccountId(v string) *AccountAssignment {
	s.AccountId = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AccountAssignment) SetPermissionSetArn(v string) *AccountAssignment {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccountAssignment) SetPrincipalId(v string) *AccountAssignment {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AccountAssignment) SetPrincipalType(v string) *AccountAssignment {
	s.PrincipalType = &v
	return s
}

// A structure that describes an assignment of an Amazon Web Services account
// to a principal and the permissions that principal has in the account.
type AccountAssignmentForPrincipal struct {
	_ struct{} `type:"structure"`

	// The account ID number of the Amazon Web Services account.
	AccountId *string `min:"12" type:"string"`

	// The ARN of the IAM Identity Center permission set assigned to this principal
	// for this Amazon Web Services account.
	PermissionSetArn *string `min:"10" type:"string"`

	// The ID of the principal.
	PrincipalId *string `min:"1" type:"string"`

	// The type of the principal.
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignmentForPrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignmentForPrincipal) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *AccountAssignmentForPrincipal) SetAccountId(v string) *AccountAssignmentForPrincipal {
	s.AccountId = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AccountAssignmentForPrincipal) SetPermissionSetArn(v string) *AccountAssignmentForPrincipal {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccountAssignmentForPrincipal) SetPrincipalId(v string) *AccountAssignmentForPrincipal {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AccountAssignmentForPrincipal) SetPrincipalType(v string) *AccountAssignmentForPrincipal {
	s.PrincipalType = &v
	return s
}

// The status of the creation or deletion operation of an assignment that a
// principal needs to access an account.
type AccountAssignmentOperationStatus struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The message that contains an error or exception in case of an operation failure.
	FailureReason *string `type:"string"`

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	PrincipalId *string `min:"1" type:"string"`

	// The entity type for which the assignment will be created.
	PrincipalType *string `type:"string" enum:"PrincipalType"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `min:"36" type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`

	// TargetID is an Amazon Web Services account identifier, (For example, 123456789012).
	TargetId *string `min:"12" type:"string"`

	// The entity type for which the assignment will be created.
	TargetType *string `type:"string" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignmentOperationStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignmentOperationStatus) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AccountAssignmentOperationStatus) SetCreatedDate(v time.Time) *AccountAssignmentOperationStatus {
	s.CreatedDate = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *AccountAssignmentOperationStatus) SetFailureReason(v string) *AccountAssignmentOperationStatus {
	s.FailureReason = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AccountAssignmentOperationStatus) SetPermissionSetArn(v string) *AccountAssignmentOperationStatus {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AccountAssignmentOperationStatus) SetPrincipalId(v string) *AccountAssignmentOperationStatus {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AccountAssignmentOperationStatus) SetPrincipalType(v string) *AccountAssignmentOperationStatus {
	s.PrincipalType = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AccountAssignmentOperationStatus) SetRequestId(v string) *AccountAssignmentOperationStatus {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccountAssignmentOperationStatus) SetStatus(v string) *AccountAssignmentOperationStatus {
	s.Status = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *AccountAssignmentOperationStatus) SetTargetId(v string) *AccountAssignmentOperationStatus {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *AccountAssignmentOperationStatus) SetTargetType(v string) *AccountAssignmentOperationStatus {
	s.TargetType = &v
	return s
}

// Provides information about the AccountAssignment creation request.
type AccountAssignmentOperationStatusMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `min:"36" type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignmentOperationStatusMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountAssignmentOperationStatusMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *AccountAssignmentOperationStatusMetadata) SetCreatedDate(v time.Time) *AccountAssignmentOperationStatusMetadata {
	s.CreatedDate = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AccountAssignmentOperationStatusMetadata) SetRequestId(v string) *AccountAssignmentOperationStatusMetadata {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccountAssignmentOperationStatusMetadata) SetStatus(v string) *AccountAssignmentOperationStatusMetadata {
	s.Status = &v
	return s
}

// A structure that describes an application that uses IAM Identity Center for
// access management.
type Application struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services account ID number of the application.
	ApplicationAccount *string `min:"12" type:"string"`

	// The ARN of the application.
	ApplicationArn *string `min:"10" type:"string"`

	// The ARN of the application provider for this application.
	ApplicationProviderArn *string `min:"10" type:"string"`

	// The date and time when the application was originally created.
	CreatedDate *time.Time `type:"timestamp"`

	// The description of the application.
	Description *string `min:"1" type:"string"`

	// The ARN of the instance of IAM Identity Center that is configured with this
	// application.
	InstanceArn *string `min:"10" type:"string"`

	// The name of the application.
	Name *string `type:"string"`

	// A structure that describes the options for the access portal associated with
	// this application.
	PortalOptions *PortalOptions `type:"structure"`

	// The current status of the application in this instance of IAM Identity Center.
	Status *string `type:"string" enum:"ApplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) GoString() string {
	return s.String()
}

// SetApplicationAccount sets the ApplicationAccount field's value.
func (s *Application) SetApplicationAccount(v string) *Application {
	s.ApplicationAccount = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *Application) SetApplicationArn(v string) *Application {
	s.ApplicationArn = &v
	return s
}

// SetApplicationProviderArn sets the ApplicationProviderArn field's value.
func (s *Application) SetApplicationProviderArn(v string) *Application {
	s.ApplicationProviderArn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Application) SetCreatedDate(v time.Time) *Application {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Application) SetDescription(v string) *Application {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *Application) SetInstanceArn(v string) *Application {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// SetPortalOptions sets the PortalOptions field's value.
func (s *Application) SetPortalOptions(v *PortalOptions) *Application {
	s.PortalOptions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Application) SetStatus(v string) *Application {
	s.Status = &v
	return s
}

// A structure that describes an assignment of a principal to an application.
type ApplicationAssignment struct {
	_ struct{} `type:"structure"`

	// The ARN of the application that has principals assigned.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// The unique identifier of the principal assigned to the application.
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The type of the principal assigned to the application.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationAssignment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationAssignment) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ApplicationAssignment) SetApplicationArn(v string) *ApplicationAssignment {
	s.ApplicationArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ApplicationAssignment) SetPrincipalId(v string) *ApplicationAssignment {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *ApplicationAssignment) SetPrincipalType(v string) *ApplicationAssignment {
	s.PrincipalType = &v
	return s
}

// A structure that describes an application to which a principal is assigned.
type ApplicationAssignmentForPrincipal struct {
	_ struct{} `type:"structure"`

	// The ARN of the application to which the specified principal is assigned.
	ApplicationArn *string `min:"10" type:"string"`

	// The unique identifier of the principal assigned to the application.
	PrincipalId *string `min:"1" type:"string"`

	// The type of the principal assigned to the application.
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationAssignmentForPrincipal) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationAssignmentForPrincipal) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ApplicationAssignmentForPrincipal) SetApplicationArn(v string) *ApplicationAssignmentForPrincipal {
	s.ApplicationArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ApplicationAssignmentForPrincipal) SetPrincipalId(v string) *ApplicationAssignmentForPrincipal {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *ApplicationAssignmentForPrincipal) SetPrincipalType(v string) *ApplicationAssignmentForPrincipal {
	s.PrincipalType = &v
	return s
}

// A structure that describes a provider that can be used to connect an Amazon
// Web Services managed application or customer managed application to IAM Identity
// Center.
type ApplicationProvider struct {
	_ struct{} `type:"structure"`

	// The ARN of the application provider.
	//
	// ApplicationProviderArn is a required field
	ApplicationProviderArn *string `min:"10" type:"string" required:"true"`

	// A structure that describes how IAM Identity Center represents the application
	// provider in the portal.
	DisplayData *DisplayData `type:"structure"`

	// The protocol that the application provider uses to perform federation.
	FederationProtocol *string `type:"string" enum:"FederationProtocol"`

	// A structure that describes the application provider's resource server.
	ResourceServerConfig *ResourceServerConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationProvider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationProvider) GoString() string {
	return s.String()
}

// SetApplicationProviderArn sets the ApplicationProviderArn field's value.
func (s *ApplicationProvider) SetApplicationProviderArn(v string) *ApplicationProvider {
	s.ApplicationProviderArn = &v
	return s
}

// SetDisplayData sets the DisplayData field's value.
func (s *ApplicationProvider) SetDisplayData(v *DisplayData) *ApplicationProvider {
	s.DisplayData = v
	return s
}

// SetFederationProtocol sets the FederationProtocol field's value.
func (s *ApplicationProvider) SetFederationProtocol(v string) *ApplicationProvider {
	s.FederationProtocol = &v
	return s
}

// SetResourceServerConfig sets the ResourceServerConfig field's value.
func (s *ApplicationProvider) SetResourceServerConfig(v *ResourceServerConfig) *ApplicationProvider {
	s.ResourceServerConfig = v
	return s
}

type AttachCustomerManagedPolicyReferenceToPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name and path of a customer managed policy. You must have an
	// IAM policy that matches the name and path in each Amazon Web Services account
	// where you want to deploy your permission set.
	//
	// CustomerManagedPolicyReference is a required field
	CustomerManagedPolicyReference *CustomerManagedPolicyReference `type:"structure" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the PermissionSet.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachCustomerManagedPolicyReferenceToPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachCustomerManagedPolicyReferenceToPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachCustomerManagedPolicyReferenceToPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachCustomerManagedPolicyReferenceToPermissionSetInput"}
	if s.CustomerManagedPolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerManagedPolicyReference"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.CustomerManagedPolicyReference != nil {
		if err := s.CustomerManagedPolicyReference.Validate(); err != nil {
			invalidParams.AddNested("CustomerManagedPolicyReference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerManagedPolicyReference sets the CustomerManagedPolicyReference field's value.
func (s *AttachCustomerManagedPolicyReferenceToPermissionSetInput) SetCustomerManagedPolicyReference(v *CustomerManagedPolicyReference) *AttachCustomerManagedPolicyReferenceToPermissionSetInput {
	s.CustomerManagedPolicyReference = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *AttachCustomerManagedPolicyReferenceToPermissionSetInput) SetInstanceArn(v string) *AttachCustomerManagedPolicyReferenceToPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AttachCustomerManagedPolicyReferenceToPermissionSetInput) SetPermissionSetArn(v string) *AttachCustomerManagedPolicyReferenceToPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type AttachCustomerManagedPolicyReferenceToPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachCustomerManagedPolicyReferenceToPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachCustomerManagedPolicyReferenceToPermissionSetOutput) GoString() string {
	return s.String()
}

type AttachManagedPolicyToPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The Amazon Web Services managed policy ARN to be attached to a permission
	// set.
	//
	// ManagedPolicyArn is a required field
	ManagedPolicyArn *string `min:"20" type:"string" required:"true"`

	// The ARN of the PermissionSet that the managed policy should be attached to.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachManagedPolicyToPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachManagedPolicyToPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachManagedPolicyToPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachManagedPolicyToPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ManagedPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedPolicyArn"))
	}
	if s.ManagedPolicyArn != nil && len(*s.ManagedPolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedPolicyArn", 20))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *AttachManagedPolicyToPermissionSetInput) SetInstanceArn(v string) *AttachManagedPolicyToPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetManagedPolicyArn sets the ManagedPolicyArn field's value.
func (s *AttachManagedPolicyToPermissionSetInput) SetManagedPolicyArn(v string) *AttachManagedPolicyToPermissionSetInput {
	s.ManagedPolicyArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *AttachManagedPolicyToPermissionSetInput) SetPermissionSetArn(v string) *AttachManagedPolicyToPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type AttachManagedPolicyToPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachManagedPolicyToPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachManagedPolicyToPermissionSetOutput) GoString() string {
	return s.String()
}

// A structure that stores the details of the Amazon Web Services managed policy.
type AttachedManagedPolicy struct {
	_ struct{} `type:"structure"`

	// The ARN of the Amazon Web Services managed policy. For more information about
	// ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces
	// (/general/latest/gr/aws-arns-and-namespaces.html) in the Amazon Web Services
	// General Reference.
	Arn *string `min:"20" type:"string"`

	// The name of the Amazon Web Services managed policy.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachedManagedPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachedManagedPolicy) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AttachedManagedPolicy) SetArn(v string) *AttachedManagedPolicy {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttachedManagedPolicy) SetName(v string) *AttachedManagedPolicy {
	s.Name = &v
	return s
}

// A structure that describes an authentication method that can be used by an
// application.
type AuthenticationMethod struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationMethod) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationMethod) GoString() string {
	return s.String()
}

// A structure that describes an authentication method and its type.
type AuthenticationMethodItem struct {
	_ struct{} `type:"structure"`

	// A structure that describes an authentication method. The contents of this
	// structure is determined by the AuthenticationMethodType.
	AuthenticationMethod *AuthenticationMethod `type:"structure"`

	// The type of authentication that is used by this method.
	AuthenticationMethodType *string `type:"string" enum:"AuthenticationMethodType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationMethodItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthenticationMethodItem) GoString() string {
	return s.String()
}

// SetAuthenticationMethod sets the AuthenticationMethod field's value.
func (s *AuthenticationMethodItem) SetAuthenticationMethod(v *AuthenticationMethod) *AuthenticationMethodItem {
	s.AuthenticationMethod = v
	return s
}

// SetAuthenticationMethodType sets the AuthenticationMethodType field's value.
func (s *AuthenticationMethodItem) SetAuthenticationMethodType(v string) *AuthenticationMethodItem {
	s.AuthenticationMethodType = &v
	return s
}

// A structure that defines configuration settings for an application that supports
// the OAuth 2.0 Authorization Code Grant.
type AuthorizationCodeGrant struct {
	_ struct{} `type:"structure"`

	// A list of URIs that are valid locations to redirect a user's browser after
	// the user is authorized.
	RedirectUris []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizationCodeGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizationCodeGrant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizationCodeGrant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizationCodeGrant"}
	if s.RedirectUris != nil && len(s.RedirectUris) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedirectUris", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRedirectUris sets the RedirectUris field's value.
func (s *AuthorizationCodeGrant) SetRedirectUris(v []*string) *AuthorizationCodeGrant {
	s.RedirectUris = v
	return s
}

// A structure that describes a trusted token issuer and associates it with
// a set of authorized audiences.
type AuthorizedTokenIssuer struct {
	_ struct{} `type:"structure"`

	// An array list of authorized audiences, or applications, that can consume
	// the tokens generated by the associated trusted token issuer.
	AuthorizedAudiences []*string `min:"1" type:"list"`

	// The ARN of the trusted token issuer.
	TrustedTokenIssuerArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizedTokenIssuer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizedTokenIssuer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizedTokenIssuer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizedTokenIssuer"}
	if s.AuthorizedAudiences != nil && len(s.AuthorizedAudiences) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedAudiences", 1))
	}
	if s.TrustedTokenIssuerArn != nil && len(*s.TrustedTokenIssuerArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TrustedTokenIssuerArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedAudiences sets the AuthorizedAudiences field's value.
func (s *AuthorizedTokenIssuer) SetAuthorizedAudiences(v []*string) *AuthorizedTokenIssuer {
	s.AuthorizedAudiences = v
	return s
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *AuthorizedTokenIssuer) SetTrustedTokenIssuerArn(v string) *AuthorizedTokenIssuer {
	s.TrustedTokenIssuerArn = &v
	return s
}

// Occurs when a conflict with a previous successful write is detected. This
// generally occurs when the previous write did not have time to propagate to
// the host serving the current request. A retry (with appropriate backoff logic)
// is the recommended response to this exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateAccountAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that the admin wants to grant the principal
	// access to.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be created.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`

	// TargetID is an Amazon Web Services account identifier, (For example, 123456789012).
	//
	// TargetId is a required field
	TargetId *string `min:"12" type:"string" required:"true"`

	// The entity type for which the assignment will be created.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccountAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccountAssignmentInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}
	if s.TargetId != nil && len(*s.TargetId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("TargetId", 12))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateAccountAssignmentInput) SetInstanceArn(v string) *CreateAccountAssignmentInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *CreateAccountAssignmentInput) SetPermissionSetArn(v string) *CreateAccountAssignmentInput {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *CreateAccountAssignmentInput) SetPrincipalId(v string) *CreateAccountAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *CreateAccountAssignmentInput) SetPrincipalType(v string) *CreateAccountAssignmentInput {
	s.PrincipalType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *CreateAccountAssignmentInput) SetTargetId(v string) *CreateAccountAssignmentInput {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *CreateAccountAssignmentInput) SetTargetType(v string) *CreateAccountAssignmentInput {
	s.TargetType = &v
	return s
}

type CreateAccountAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment creation operation.
	AccountAssignmentCreationStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccountAssignmentOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentCreationStatus sets the AccountAssignmentCreationStatus field's value.
func (s *CreateAccountAssignmentOutput) SetAccountAssignmentCreationStatus(v *AccountAssignmentOperationStatus) *CreateAccountAssignmentOutput {
	s.AccountAssignmentCreationStatus = v
	return s
}

type CreateApplicationAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application provider under which the operation will run.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be created.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationAssignmentInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateApplicationAssignmentInput) SetApplicationArn(v string) *CreateApplicationAssignmentInput {
	s.ApplicationArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *CreateApplicationAssignmentInput) SetPrincipalId(v string) *CreateApplicationAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *CreateApplicationAssignmentInput) SetPrincipalType(v string) *CreateApplicationAssignmentInput {
	s.PrincipalType = &v
	return s
}

type CreateApplicationAssignmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationAssignmentOutput) GoString() string {
	return s.String()
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application provider under which the operation will run.
	//
	// ApplicationProviderArn is a required field
	ApplicationProviderArn *string `min:"10" type:"string" required:"true"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the .
	Description *string `min:"1" type:"string"`

	// The ARN of the instance of IAM Identity Center under which the operation
	// will run. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The name of the .
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A structure that describes the options for the portal associated with an
	// application.
	PortalOptions *PortalOptions `type:"structure"`

	// Specifies whether the application is enabled or disabled.
	Status *string `type:"string" enum:"ApplicationStatus"`

	// Specifies tags to be attached to the application.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ApplicationProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationProviderArn"))
	}
	if s.ApplicationProviderArn != nil && len(*s.ApplicationProviderArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationProviderArn", 10))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.PortalOptions != nil {
		if err := s.PortalOptions.Validate(); err != nil {
			invalidParams.AddNested("PortalOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationProviderArn sets the ApplicationProviderArn field's value.
func (s *CreateApplicationInput) SetApplicationProviderArn(v string) *CreateApplicationInput {
	s.ApplicationProviderArn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateApplicationInput) SetInstanceArn(v string) *CreateApplicationInput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetPortalOptions sets the PortalOptions field's value.
func (s *CreateApplicationInput) SetPortalOptions(v *PortalOptions) *CreateApplicationInput {
	s.PortalOptions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateApplicationInput) SetStatus(v string) *CreateApplicationInput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v []*Tag) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application.
	ApplicationArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *CreateApplicationOutput) SetApplicationArn(v string) *CreateApplicationOutput {
	s.ApplicationArn = &v
	return s
}

type CreateInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the IAM Identity Center identity store attributes to add to your
	// ABAC configuration. When using an external identity provider as an identity
	// source, you can pass attributes through the SAML assertion. Doing so provides
	// an alternative to configuring attributes from the IAM Identity Center identity
	// store. If a SAML assertion passes any of these attributes, IAM Identity Center
	// will replace the attribute value with the value from the IAM Identity Center
	// identity store.
	//
	// InstanceAccessControlAttributeConfiguration is a required field
	InstanceAccessControlAttributeConfiguration *InstanceAccessControlAttributeConfiguration `type:"structure" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceAccessControlAttributeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceAccessControlAttributeConfiguration"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.InstanceAccessControlAttributeConfiguration != nil {
		if err := s.InstanceAccessControlAttributeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceAccessControlAttributeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceAccessControlAttributeConfiguration sets the InstanceAccessControlAttributeConfiguration field's value.
func (s *CreateInstanceAccessControlAttributeConfigurationInput) SetInstanceAccessControlAttributeConfiguration(v *InstanceAccessControlAttributeConfiguration) *CreateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceAccessControlAttributeConfiguration = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *CreateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type CreateInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

type CreateInstanceInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The name of the instance of IAM Identity Center.
	Name *string `type:"string"`

	// Specifies tags to be attached to the instance of IAM Identity Center.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInstanceInput) SetClientToken(v string) *CreateInstanceInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInstanceInput) SetName(v string) *CreateInstanceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateInstanceInput) SetTags(v []*Tag) *CreateInstanceInput {
	s.Tags = v
	return s
}

type CreateInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the instance of IAM Identity Center under which the operation
	// will run.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateInstanceOutput) SetInstanceArn(v string) *CreateInstanceOutput {
	s.InstanceArn = &v
	return s
}

type CreatePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The description of the PermissionSet.
	Description *string `min:"1" type:"string"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The name of the PermissionSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Used to redirect users within the application during the federation authentication
	// process.
	RelayState *string `min:"1" type:"string"`

	// The length of time that the application user sessions are valid in the ISO-8601
	// standard.
	SessionDuration *string `min:"1" type:"string"`

	// The tags to attach to the new PermissionSet.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePermissionSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RelayState != nil && len(*s.RelayState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayState", 1))
	}
	if s.SessionDuration != nil && len(*s.SessionDuration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionDuration", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreatePermissionSetInput) SetDescription(v string) *CreatePermissionSetInput {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreatePermissionSetInput) SetInstanceArn(v string) *CreatePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePermissionSetInput) SetName(v string) *CreatePermissionSetInput {
	s.Name = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *CreatePermissionSetInput) SetRelayState(v string) *CreatePermissionSetInput {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *CreatePermissionSetInput) SetSessionDuration(v string) *CreatePermissionSetInput {
	s.SessionDuration = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePermissionSetInput) SetTags(v []*Tag) *CreatePermissionSetInput {
	s.Tags = v
	return s
}

type CreatePermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// Defines the level of access on an Amazon Web Services account.
	PermissionSet *PermissionSet `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionSet sets the PermissionSet field's value.
func (s *CreatePermissionSetOutput) SetPermissionSet(v *PermissionSet) *CreatePermissionSetOutput {
	s.PermissionSet = v
	return s
}

type CreateTrustedTokenIssuerInput struct {
	_ struct{} `type:"structure"`

	// Specifies a unique, case-sensitive ID that you provide to ensure the idempotency
	// of the request. This lets you safely retry the request without accidentally
	// performing the same operation a second time. Passing the same value to a
	// later call to an operation requires that you also pass the same value for
	// all other parameters. We recommend that you use a UUID type of value. (https://wikipedia.org/wiki/Universally_unique_identifier).
	//
	// If you don't provide this value, then Amazon Web Services generates a random
	// one for you.
	//
	// If you retry the operation with the same ClientToken, but with different
	// parameters, the retry fails with an IdempotentParameterMismatch error.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// Specifies the ARN of the instance of IAM Identity Center to contain the new
	// trusted token issuer configuration.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// Specifies the name of the new trusted token issuer configuration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Specifies tags to be attached to the new trusted token issuer configuration.
	Tags []*Tag `type:"list"`

	// Specifies settings that apply to the new trusted token issuer configuration.
	// The settings that are available depend on what TrustedTokenIssuerType you
	// specify.
	//
	// TrustedTokenIssuerConfiguration is a required field
	TrustedTokenIssuerConfiguration *TrustedTokenIssuerConfiguration `type:"structure" required:"true"`

	// Specifies the type of the new trusted token issuer.
	//
	// TrustedTokenIssuerType is a required field
	TrustedTokenIssuerType *string `type:"string" required:"true" enum:"TrustedTokenIssuerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustedTokenIssuerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustedTokenIssuerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrustedTokenIssuerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrustedTokenIssuerInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TrustedTokenIssuerConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedTokenIssuerConfiguration"))
	}
	if s.TrustedTokenIssuerType == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedTokenIssuerType"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TrustedTokenIssuerConfiguration != nil {
		if err := s.TrustedTokenIssuerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TrustedTokenIssuerConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTrustedTokenIssuerInput) SetClientToken(v string) *CreateTrustedTokenIssuerInput {
	s.ClientToken = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *CreateTrustedTokenIssuerInput) SetInstanceArn(v string) *CreateTrustedTokenIssuerInput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrustedTokenIssuerInput) SetName(v string) *CreateTrustedTokenIssuerInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrustedTokenIssuerInput) SetTags(v []*Tag) *CreateTrustedTokenIssuerInput {
	s.Tags = v
	return s
}

// SetTrustedTokenIssuerConfiguration sets the TrustedTokenIssuerConfiguration field's value.
func (s *CreateTrustedTokenIssuerInput) SetTrustedTokenIssuerConfiguration(v *TrustedTokenIssuerConfiguration) *CreateTrustedTokenIssuerInput {
	s.TrustedTokenIssuerConfiguration = v
	return s
}

// SetTrustedTokenIssuerType sets the TrustedTokenIssuerType field's value.
func (s *CreateTrustedTokenIssuerInput) SetTrustedTokenIssuerType(v string) *CreateTrustedTokenIssuerInput {
	s.TrustedTokenIssuerType = &v
	return s
}

type CreateTrustedTokenIssuerOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the new trusted token issuer configuration.
	TrustedTokenIssuerArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustedTokenIssuerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrustedTokenIssuerOutput) GoString() string {
	return s.String()
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *CreateTrustedTokenIssuerOutput) SetTrustedTokenIssuerArn(v string) *CreateTrustedTokenIssuerOutput {
	s.TrustedTokenIssuerArn = &v
	return s
}

// Specifies the name and path of a customer managed policy. You must have an
// IAM policy that matches the name and path in each Amazon Web Services account
// where you want to deploy your permission set.
type CustomerManagedPolicyReference struct {
	_ struct{} `type:"structure"`

	// The name of the IAM policy that you have configured in each account where
	// you want to deploy your permission set.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The path to the IAM policy that you have configured in each account where
	// you want to deploy your permission set. The default is /. For more information,
	// see Friendly names and paths (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names)
	// in the IAM User Guide.
	Path *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedPolicyReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedPolicyReference) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomerManagedPolicyReference) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomerManagedPolicyReference"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CustomerManagedPolicyReference) SetName(v string) *CustomerManagedPolicyReference {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *CustomerManagedPolicyReference) SetPath(v string) *CustomerManagedPolicyReference {
	s.Path = &v
	return s
}

type DeleteAccountAssignmentInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that will be used to remove access.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be deleted.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`

	// TargetID is an Amazon Web Services account identifier, (For example, 123456789012).
	//
	// TargetId is a required field
	TargetId *string `min:"12" type:"string" required:"true"`

	// The entity type for which the assignment will be deleted.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"TargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccountAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccountAssignmentInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.TargetId == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetId"))
	}
	if s.TargetId != nil && len(*s.TargetId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("TargetId", 12))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteAccountAssignmentInput) SetInstanceArn(v string) *DeleteAccountAssignmentInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeleteAccountAssignmentInput) SetPermissionSetArn(v string) *DeleteAccountAssignmentInput {
	s.PermissionSetArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteAccountAssignmentInput) SetPrincipalId(v string) *DeleteAccountAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *DeleteAccountAssignmentInput) SetPrincipalType(v string) *DeleteAccountAssignmentInput {
	s.PrincipalType = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *DeleteAccountAssignmentInput) SetTargetId(v string) *DeleteAccountAssignmentInput {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *DeleteAccountAssignmentInput) SetTargetType(v string) *DeleteAccountAssignmentInput {
	s.TargetType = &v
	return s
}

type DeleteAccountAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment deletion operation.
	AccountAssignmentDeletionStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccountAssignmentOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentDeletionStatus sets the AccountAssignmentDeletionStatus field's value.
func (s *DeleteAccountAssignmentOutput) SetAccountAssignmentDeletionStatus(v *AccountAssignmentOperationStatus) *DeleteAccountAssignmentOutput {
	s.AccountAssignmentDeletionStatus = v
	return s
}

type DeleteApplicationAccessScopeInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the access scope to delete.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the name of the access scope to remove from the application.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAccessScopeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAccessScopeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationAccessScopeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationAccessScopeInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DeleteApplicationAccessScopeInput) SetApplicationArn(v string) *DeleteApplicationAccessScopeInput {
	s.ApplicationArn = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *DeleteApplicationAccessScopeInput) SetScope(v string) *DeleteApplicationAccessScopeInput {
	s.Scope = &v
	return s
}

type DeleteApplicationAccessScopeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAccessScopeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAccessScopeOutput) GoString() string {
	return s.String()
}

type DeleteApplicationAssignmentInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be deleted.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationAssignmentInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DeleteApplicationAssignmentInput) SetApplicationArn(v string) *DeleteApplicationAssignmentInput {
	s.ApplicationArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DeleteApplicationAssignmentInput) SetPrincipalId(v string) *DeleteApplicationAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *DeleteApplicationAssignmentInput) SetPrincipalType(v string) *DeleteApplicationAssignmentInput {
	s.PrincipalType = &v
	return s
}

type DeleteApplicationAssignmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAssignmentOutput) GoString() string {
	return s.String()
}

type DeleteApplicationAuthenticationMethodInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the authentication method to delete.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the authentication method type to delete from the application.
	//
	// AuthenticationMethodType is a required field
	AuthenticationMethodType *string `type:"string" required:"true" enum:"AuthenticationMethodType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAuthenticationMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAuthenticationMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationAuthenticationMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationAuthenticationMethodInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.AuthenticationMethodType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationMethodType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DeleteApplicationAuthenticationMethodInput) SetApplicationArn(v string) *DeleteApplicationAuthenticationMethodInput {
	s.ApplicationArn = &v
	return s
}

// SetAuthenticationMethodType sets the AuthenticationMethodType field's value.
func (s *DeleteApplicationAuthenticationMethodInput) SetAuthenticationMethodType(v string) *DeleteApplicationAuthenticationMethodInput {
	s.AuthenticationMethodType = &v
	return s
}

type DeleteApplicationAuthenticationMethodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAuthenticationMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationAuthenticationMethodOutput) GoString() string {
	return s.String()
}

type DeleteApplicationGrantInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the grant to delete.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the type of grant to delete from the application.
	//
	// GrantType is a required field
	GrantType *string `type:"string" required:"true" enum:"GrantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationGrantInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.GrantType == nil {
		invalidParams.Add(request.NewErrParamRequired("GrantType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DeleteApplicationGrantInput) SetApplicationArn(v string) *DeleteApplicationGrantInput {
	s.ApplicationArn = &v
	return s
}

// SetGrantType sets the GrantType field's value.
func (s *DeleteApplicationGrantInput) SetGrantType(v string) *DeleteApplicationGrantInput {
	s.GrantType = &v
	return s
}

type DeleteApplicationGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationGrantOutput) GoString() string {
	return s.String()
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DeleteApplicationInput) SetApplicationArn(v string) *DeleteApplicationInput {
	s.ApplicationArn = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

type DeleteInlinePolicyFromPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that will be used to remove access.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInlinePolicyFromPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInlinePolicyFromPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInlinePolicyFromPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInlinePolicyFromPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteInlinePolicyFromPermissionSetInput) SetInstanceArn(v string) *DeleteInlinePolicyFromPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeleteInlinePolicyFromPermissionSetInput) SetPermissionSetArn(v string) *DeleteInlinePolicyFromPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DeleteInlinePolicyFromPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInlinePolicyFromPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInlinePolicyFromPermissionSetOutput) GoString() string {
	return s.String()
}

type DeleteInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *DeleteInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type DeleteInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the instance of IAM Identity Center under which the operation
	// will run.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeleteInstanceInput) SetInstanceArn(v string) *DeleteInstanceInput {
	s.InstanceArn = &v
	return s
}

type DeleteInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteInstanceOutput) GoString() string {
	return s.String()
}

type DeletePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set that should be deleted.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeletePermissionSetInput) SetInstanceArn(v string) *DeletePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeletePermissionSetInput) SetPermissionSetArn(v string) *DeletePermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DeletePermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionSetOutput) GoString() string {
	return s.String()
}

type DeletePermissionsBoundaryFromPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the PermissionSet.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionsBoundaryFromPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionsBoundaryFromPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionsBoundaryFromPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionsBoundaryFromPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DeletePermissionsBoundaryFromPermissionSetInput) SetInstanceArn(v string) *DeletePermissionsBoundaryFromPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DeletePermissionsBoundaryFromPermissionSetInput) SetPermissionSetArn(v string) *DeletePermissionsBoundaryFromPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DeletePermissionsBoundaryFromPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionsBoundaryFromPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePermissionsBoundaryFromPermissionSetOutput) GoString() string {
	return s.String()
}

type DeleteTrustedTokenIssuerInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trusted token issuer configuration to delete.
	//
	// TrustedTokenIssuerArn is a required field
	TrustedTokenIssuerArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustedTokenIssuerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustedTokenIssuerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTrustedTokenIssuerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTrustedTokenIssuerInput"}
	if s.TrustedTokenIssuerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedTokenIssuerArn"))
	}
	if s.TrustedTokenIssuerArn != nil && len(*s.TrustedTokenIssuerArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TrustedTokenIssuerArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *DeleteTrustedTokenIssuerInput) SetTrustedTokenIssuerArn(v string) *DeleteTrustedTokenIssuerInput {
	s.TrustedTokenIssuerArn = &v
	return s
}

type DeleteTrustedTokenIssuerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustedTokenIssuerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTrustedTokenIssuerOutput) GoString() string {
	return s.String()
}

type DescribeAccountAssignmentCreationStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier that is used to track the request operation progress.
	//
	// AccountAssignmentCreationRequestId is a required field
	AccountAssignmentCreationRequestId *string `min:"36" type:"string" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentCreationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentCreationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountAssignmentCreationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountAssignmentCreationStatusInput"}
	if s.AccountAssignmentCreationRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAssignmentCreationRequestId"))
	}
	if s.AccountAssignmentCreationRequestId != nil && len(*s.AccountAssignmentCreationRequestId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccountAssignmentCreationRequestId", 36))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAssignmentCreationRequestId sets the AccountAssignmentCreationRequestId field's value.
func (s *DescribeAccountAssignmentCreationStatusInput) SetAccountAssignmentCreationRequestId(v string) *DescribeAccountAssignmentCreationStatusInput {
	s.AccountAssignmentCreationRequestId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeAccountAssignmentCreationStatusInput) SetInstanceArn(v string) *DescribeAccountAssignmentCreationStatusInput {
	s.InstanceArn = &v
	return s
}

type DescribeAccountAssignmentCreationStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment creation operation.
	AccountAssignmentCreationStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentCreationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentCreationStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentCreationStatus sets the AccountAssignmentCreationStatus field's value.
func (s *DescribeAccountAssignmentCreationStatusOutput) SetAccountAssignmentCreationStatus(v *AccountAssignmentOperationStatus) *DescribeAccountAssignmentCreationStatusOutput {
	s.AccountAssignmentCreationStatus = v
	return s
}

type DescribeAccountAssignmentDeletionStatusInput struct {
	_ struct{} `type:"structure"`

	// The identifier that is used to track the request operation progress.
	//
	// AccountAssignmentDeletionRequestId is a required field
	AccountAssignmentDeletionRequestId *string `min:"36" type:"string" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentDeletionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentDeletionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountAssignmentDeletionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountAssignmentDeletionStatusInput"}
	if s.AccountAssignmentDeletionRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountAssignmentDeletionRequestId"))
	}
	if s.AccountAssignmentDeletionRequestId != nil && len(*s.AccountAssignmentDeletionRequestId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AccountAssignmentDeletionRequestId", 36))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountAssignmentDeletionRequestId sets the AccountAssignmentDeletionRequestId field's value.
func (s *DescribeAccountAssignmentDeletionStatusInput) SetAccountAssignmentDeletionRequestId(v string) *DescribeAccountAssignmentDeletionStatusInput {
	s.AccountAssignmentDeletionRequestId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeAccountAssignmentDeletionStatusInput) SetInstanceArn(v string) *DescribeAccountAssignmentDeletionStatusInput {
	s.InstanceArn = &v
	return s
}

type DescribeAccountAssignmentDeletionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment deletion operation.
	AccountAssignmentDeletionStatus *AccountAssignmentOperationStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentDeletionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountAssignmentDeletionStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentDeletionStatus sets the AccountAssignmentDeletionStatus field's value.
func (s *DescribeAccountAssignmentDeletionStatusOutput) SetAccountAssignmentDeletionStatus(v *AccountAssignmentOperationStatus) *DescribeAccountAssignmentDeletionStatusOutput {
	s.AccountAssignmentDeletionStatus = v
	return s
}

type DescribeApplicationAssignmentInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// The entity type for which the assignment will be created.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssignmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssignmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationAssignmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationAssignmentInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DescribeApplicationAssignmentInput) SetApplicationArn(v string) *DescribeApplicationAssignmentInput {
	s.ApplicationArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DescribeApplicationAssignmentInput) SetPrincipalId(v string) *DescribeApplicationAssignmentInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *DescribeApplicationAssignmentInput) SetPrincipalType(v string) *DescribeApplicationAssignmentInput {
	s.PrincipalType = &v
	return s
}

type DescribeApplicationAssignmentOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	ApplicationArn *string `min:"10" type:"string"`

	// An identifier for an object in IAM Identity Center, such as a user or group.
	// PrincipalIds are GUIDs (For example, f81d4fae-7dec-11d0-a765-00a0c91e6bf6).
	// For more information about PrincipalIds in IAM Identity Center, see the IAM
	// Identity Center Identity Store API Reference (/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
	PrincipalId *string `min:"1" type:"string"`

	// The entity type for which the assignment will be created.
	PrincipalType *string `type:"string" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssignmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationAssignmentOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DescribeApplicationAssignmentOutput) SetApplicationArn(v string) *DescribeApplicationAssignmentOutput {
	s.ApplicationArn = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DescribeApplicationAssignmentOutput) SetPrincipalId(v string) *DescribeApplicationAssignmentOutput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *DescribeApplicationAssignmentOutput) SetPrincipalType(v string) *DescribeApplicationAssignmentOutput {
	s.PrincipalType = &v
	return s
}

type DescribeApplicationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DescribeApplicationInput) SetApplicationArn(v string) *DescribeApplicationInput {
	s.ApplicationArn = &v
	return s
}

type DescribeApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The account ID.
	ApplicationAccount *string `min:"12" type:"string"`

	// Specifies the ARN of the application.
	ApplicationArn *string `min:"10" type:"string"`

	// The ARN of the application provider under which the operation will run.
	ApplicationProviderArn *string `min:"10" type:"string"`

	// The date the application was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The description of the .
	Description *string `min:"1" type:"string"`

	// The ARN of the IAM Identity Center application under which the operation
	// will run. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`

	// The application name.
	Name *string `type:"string"`

	// A structure that describes the options for the portal associated with an
	// application.
	PortalOptions *PortalOptions `type:"structure"`

	// Specifies whether the application is enabled or disabled.
	Status *string `type:"string" enum:"ApplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationOutput) GoString() string {
	return s.String()
}

// SetApplicationAccount sets the ApplicationAccount field's value.
func (s *DescribeApplicationOutput) SetApplicationAccount(v string) *DescribeApplicationOutput {
	s.ApplicationAccount = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DescribeApplicationOutput) SetApplicationArn(v string) *DescribeApplicationOutput {
	s.ApplicationArn = &v
	return s
}

// SetApplicationProviderArn sets the ApplicationProviderArn field's value.
func (s *DescribeApplicationOutput) SetApplicationProviderArn(v string) *DescribeApplicationOutput {
	s.ApplicationProviderArn = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DescribeApplicationOutput) SetCreatedDate(v time.Time) *DescribeApplicationOutput {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeApplicationOutput) SetDescription(v string) *DescribeApplicationOutput {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeApplicationOutput) SetInstanceArn(v string) *DescribeApplicationOutput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeApplicationOutput) SetName(v string) *DescribeApplicationOutput {
	s.Name = &v
	return s
}

// SetPortalOptions sets the PortalOptions field's value.
func (s *DescribeApplicationOutput) SetPortalOptions(v *PortalOptions) *DescribeApplicationOutput {
	s.PortalOptions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeApplicationOutput) SetStatus(v string) *DescribeApplicationOutput {
	s.Status = &v
	return s
}

type DescribeApplicationProviderInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application provider for which you want details.
	//
	// ApplicationProviderArn is a required field
	ApplicationProviderArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationProviderInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationProviderInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeApplicationProviderInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeApplicationProviderInput"}
	if s.ApplicationProviderArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationProviderArn"))
	}
	if s.ApplicationProviderArn != nil && len(*s.ApplicationProviderArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationProviderArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationProviderArn sets the ApplicationProviderArn field's value.
func (s *DescribeApplicationProviderInput) SetApplicationProviderArn(v string) *DescribeApplicationProviderInput {
	s.ApplicationProviderArn = &v
	return s
}

type DescribeApplicationProviderOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the application provider.
	//
	// ApplicationProviderArn is a required field
	ApplicationProviderArn *string `min:"10" type:"string" required:"true"`

	// A structure with details about the display data for the application provider.
	DisplayData *DisplayData `type:"structure"`

	// The protocol used to federate to the application provider.
	FederationProtocol *string `type:"string" enum:"FederationProtocol"`

	// A structure with details about the receiving application.
	ResourceServerConfig *ResourceServerConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationProviderOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeApplicationProviderOutput) GoString() string {
	return s.String()
}

// SetApplicationProviderArn sets the ApplicationProviderArn field's value.
func (s *DescribeApplicationProviderOutput) SetApplicationProviderArn(v string) *DescribeApplicationProviderOutput {
	s.ApplicationProviderArn = &v
	return s
}

// SetDisplayData sets the DisplayData field's value.
func (s *DescribeApplicationProviderOutput) SetDisplayData(v *DisplayData) *DescribeApplicationProviderOutput {
	s.DisplayData = v
	return s
}

// SetFederationProtocol sets the FederationProtocol field's value.
func (s *DescribeApplicationProviderOutput) SetFederationProtocol(v string) *DescribeApplicationProviderOutput {
	s.FederationProtocol = &v
	return s
}

// SetResourceServerConfig sets the ResourceServerConfig field's value.
func (s *DescribeApplicationProviderOutput) SetResourceServerConfig(v *ResourceServerConfig) *DescribeApplicationProviderOutput {
	s.ResourceServerConfig = v
	return s
}

type DescribeInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *DescribeInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type DescribeInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// Gets the list of IAM Identity Center identity store attributes that have
	// been added to your ABAC configuration.
	InstanceAccessControlAttributeConfiguration *InstanceAccessControlAttributeConfiguration `type:"structure"`

	// The status of the attribute configuration process.
	Status *string `type:"string" enum:"InstanceAccessControlAttributeConfigurationStatus"`

	// Provides more details about the current status of the specified attribute.
	StatusReason *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

// SetInstanceAccessControlAttributeConfiguration sets the InstanceAccessControlAttributeConfiguration field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationOutput) SetInstanceAccessControlAttributeConfiguration(v *InstanceAccessControlAttributeConfiguration) *DescribeInstanceAccessControlAttributeConfigurationOutput {
	s.InstanceAccessControlAttributeConfiguration = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationOutput) SetStatus(v string) *DescribeInstanceAccessControlAttributeConfigurationOutput {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *DescribeInstanceAccessControlAttributeConfigurationOutput) SetStatusReason(v string) *DescribeInstanceAccessControlAttributeConfigurationOutput {
	s.StatusReason = &v
	return s
}

type DescribeInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the instance of IAM Identity Center under which the operation
	// will run.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeInstanceInput) SetInstanceArn(v string) *DescribeInstanceInput {
	s.InstanceArn = &v
	return s
}

type DescribeInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The date the instance was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier of the identity store that is connected to the instance of
	// IAM Identity Center.
	IdentityStoreId *string `min:"1" type:"string"`

	// The ARN of the instance of IAM Identity Center under which the operation
	// will run. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`

	// Specifies the instance name.
	Name *string `type:"string"`

	// The identifier of the Amazon Web Services account for which the instance
	// was created.
	OwnerAccountId *string `min:"12" type:"string"`

	// The status of the instance.
	Status *string `type:"string" enum:"InstanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DescribeInstanceOutput) SetCreatedDate(v time.Time) *DescribeInstanceOutput {
	s.CreatedDate = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *DescribeInstanceOutput) SetIdentityStoreId(v string) *DescribeInstanceOutput {
	s.IdentityStoreId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribeInstanceOutput) SetInstanceArn(v string) *DescribeInstanceOutput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeInstanceOutput) SetName(v string) *DescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *DescribeInstanceOutput) SetOwnerAccountId(v string) *DescribeInstanceOutput {
	s.OwnerAccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeInstanceOutput) SetStatus(v string) *DescribeInstanceOutput {
	s.Status = &v
	return s
}

type DescribePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribePermissionSetInput) SetInstanceArn(v string) *DescribePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DescribePermissionSetInput) SetPermissionSetArn(v string) *DescribePermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DescribePermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// Describes the level of access on an Amazon Web Services account.
	PermissionSet *PermissionSet `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionSet sets the PermissionSet field's value.
func (s *DescribePermissionSetOutput) SetPermissionSet(v *PermissionSet) *DescribePermissionSetOutput {
	s.PermissionSet = v
	return s
}

type DescribePermissionSetProvisioningStatusInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The identifier that is provided by the ProvisionPermissionSet call to retrieve
	// the current status of the provisioning workflow.
	//
	// ProvisionPermissionSetRequestId is a required field
	ProvisionPermissionSetRequestId *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetProvisioningStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetProvisioningStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePermissionSetProvisioningStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePermissionSetProvisioningStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ProvisionPermissionSetRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProvisionPermissionSetRequestId"))
	}
	if s.ProvisionPermissionSetRequestId != nil && len(*s.ProvisionPermissionSetRequestId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("ProvisionPermissionSetRequestId", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DescribePermissionSetProvisioningStatusInput) SetInstanceArn(v string) *DescribePermissionSetProvisioningStatusInput {
	s.InstanceArn = &v
	return s
}

// SetProvisionPermissionSetRequestId sets the ProvisionPermissionSetRequestId field's value.
func (s *DescribePermissionSetProvisioningStatusInput) SetProvisionPermissionSetRequestId(v string) *DescribePermissionSetProvisioningStatusInput {
	s.ProvisionPermissionSetRequestId = &v
	return s
}

type DescribePermissionSetProvisioningStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the permission set provisioning operation.
	PermissionSetProvisioningStatus *PermissionSetProvisioningStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetProvisioningStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePermissionSetProvisioningStatusOutput) GoString() string {
	return s.String()
}

// SetPermissionSetProvisioningStatus sets the PermissionSetProvisioningStatus field's value.
func (s *DescribePermissionSetProvisioningStatusOutput) SetPermissionSetProvisioningStatus(v *PermissionSetProvisioningStatus) *DescribePermissionSetProvisioningStatusOutput {
	s.PermissionSetProvisioningStatus = v
	return s
}

type DescribeTrustedTokenIssuerInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the trusted token issuer configuration that you want
	// details about.
	//
	// TrustedTokenIssuerArn is a required field
	TrustedTokenIssuerArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrustedTokenIssuerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrustedTokenIssuerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTrustedTokenIssuerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTrustedTokenIssuerInput"}
	if s.TrustedTokenIssuerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedTokenIssuerArn"))
	}
	if s.TrustedTokenIssuerArn != nil && len(*s.TrustedTokenIssuerArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TrustedTokenIssuerArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *DescribeTrustedTokenIssuerInput) SetTrustedTokenIssuerArn(v string) *DescribeTrustedTokenIssuerInput {
	s.TrustedTokenIssuerArn = &v
	return s
}

type DescribeTrustedTokenIssuerOutput struct {
	_ struct{} `type:"structure"`

	// The name of the trusted token issuer configuration.
	Name *string `min:"1" type:"string"`

	// The ARN of the trusted token issuer configuration.
	TrustedTokenIssuerArn *string `min:"10" type:"string"`

	// A structure the describes the settings that apply of this trusted token issuer.
	TrustedTokenIssuerConfiguration *TrustedTokenIssuerConfiguration `type:"structure"`

	// The type of the trusted token issuer.
	TrustedTokenIssuerType *string `type:"string" enum:"TrustedTokenIssuerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrustedTokenIssuerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTrustedTokenIssuerOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DescribeTrustedTokenIssuerOutput) SetName(v string) *DescribeTrustedTokenIssuerOutput {
	s.Name = &v
	return s
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *DescribeTrustedTokenIssuerOutput) SetTrustedTokenIssuerArn(v string) *DescribeTrustedTokenIssuerOutput {
	s.TrustedTokenIssuerArn = &v
	return s
}

// SetTrustedTokenIssuerConfiguration sets the TrustedTokenIssuerConfiguration field's value.
func (s *DescribeTrustedTokenIssuerOutput) SetTrustedTokenIssuerConfiguration(v *TrustedTokenIssuerConfiguration) *DescribeTrustedTokenIssuerOutput {
	s.TrustedTokenIssuerConfiguration = v
	return s
}

// SetTrustedTokenIssuerType sets the TrustedTokenIssuerType field's value.
func (s *DescribeTrustedTokenIssuerOutput) SetTrustedTokenIssuerType(v string) *DescribeTrustedTokenIssuerOutput {
	s.TrustedTokenIssuerType = &v
	return s
}

type DetachCustomerManagedPolicyReferenceFromPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// Specifies the name and path of a customer managed policy. You must have an
	// IAM policy that matches the name and path in each Amazon Web Services account
	// where you want to deploy your permission set.
	//
	// CustomerManagedPolicyReference is a required field
	CustomerManagedPolicyReference *CustomerManagedPolicyReference `type:"structure" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the PermissionSet.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachCustomerManagedPolicyReferenceFromPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachCustomerManagedPolicyReferenceFromPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachCustomerManagedPolicyReferenceFromPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachCustomerManagedPolicyReferenceFromPermissionSetInput"}
	if s.CustomerManagedPolicyReference == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomerManagedPolicyReference"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.CustomerManagedPolicyReference != nil {
		if err := s.CustomerManagedPolicyReference.Validate(); err != nil {
			invalidParams.AddNested("CustomerManagedPolicyReference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerManagedPolicyReference sets the CustomerManagedPolicyReference field's value.
func (s *DetachCustomerManagedPolicyReferenceFromPermissionSetInput) SetCustomerManagedPolicyReference(v *CustomerManagedPolicyReference) *DetachCustomerManagedPolicyReferenceFromPermissionSetInput {
	s.CustomerManagedPolicyReference = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DetachCustomerManagedPolicyReferenceFromPermissionSetInput) SetInstanceArn(v string) *DetachCustomerManagedPolicyReferenceFromPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DetachCustomerManagedPolicyReferenceFromPermissionSetInput) SetPermissionSetArn(v string) *DetachCustomerManagedPolicyReferenceFromPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DetachCustomerManagedPolicyReferenceFromPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachCustomerManagedPolicyReferenceFromPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachCustomerManagedPolicyReferenceFromPermissionSetOutput) GoString() string {
	return s.String()
}

type DetachManagedPolicyFromPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The Amazon Web Services managed policy ARN to be detached from a permission
	// set.
	//
	// ManagedPolicyArn is a required field
	ManagedPolicyArn *string `min:"20" type:"string" required:"true"`

	// The ARN of the PermissionSet from which the policy should be detached.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachManagedPolicyFromPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachManagedPolicyFromPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachManagedPolicyFromPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachManagedPolicyFromPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ManagedPolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagedPolicyArn"))
	}
	if s.ManagedPolicyArn != nil && len(*s.ManagedPolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedPolicyArn", 20))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *DetachManagedPolicyFromPermissionSetInput) SetInstanceArn(v string) *DetachManagedPolicyFromPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetManagedPolicyArn sets the ManagedPolicyArn field's value.
func (s *DetachManagedPolicyFromPermissionSetInput) SetManagedPolicyArn(v string) *DetachManagedPolicyFromPermissionSetInput {
	s.ManagedPolicyArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *DetachManagedPolicyFromPermissionSetInput) SetPermissionSetArn(v string) *DetachManagedPolicyFromPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type DetachManagedPolicyFromPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachManagedPolicyFromPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetachManagedPolicyFromPermissionSetOutput) GoString() string {
	return s.String()
}

// A structure that describes how the portal represents an application provider.
type DisplayData struct {
	_ struct{} `type:"structure"`

	// The description of the application provider that appears in the portal.
	Description *string `min:"1" type:"string"`

	// The name of the application provider that appears in the portal.
	DisplayName *string `min:"1" type:"string"`

	// A URL that points to an icon that represents the application provider.
	IconUrl *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisplayData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisplayData) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *DisplayData) SetDescription(v string) *DisplayData {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *DisplayData) SetDisplayName(v string) *DisplayData {
	s.DisplayName = &v
	return s
}

// SetIconUrl sets the IconUrl field's value.
func (s *DisplayData) SetIconUrl(v string) *DisplayData {
	s.IconUrl = &v
	return s
}

type GetApplicationAccessScopeInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the access scope that you want
	// to retrieve.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the name of the access scope for which you want the authorized
	// targets.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAccessScopeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAccessScopeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationAccessScopeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationAccessScopeInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationAccessScopeInput) SetApplicationArn(v string) *GetApplicationAccessScopeInput {
	s.ApplicationArn = &v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetApplicationAccessScopeInput) SetScope(v string) *GetApplicationAccessScopeInput {
	s.Scope = &v
	return s
}

type GetApplicationAccessScopeOutput struct {
	_ struct{} `type:"structure"`

	// An array of authorized targets associated with this access scope.
	AuthorizedTargets []*string `min:"1" type:"list"`

	// The name of the access scope that can be used with the authorized targets.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAccessScopeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAccessScopeOutput) GoString() string {
	return s.String()
}

// SetAuthorizedTargets sets the AuthorizedTargets field's value.
func (s *GetApplicationAccessScopeOutput) SetAuthorizedTargets(v []*string) *GetApplicationAccessScopeOutput {
	s.AuthorizedTargets = v
	return s
}

// SetScope sets the Scope field's value.
func (s *GetApplicationAccessScopeOutput) SetScope(v string) *GetApplicationAccessScopeOutput {
	s.Scope = &v
	return s
}

type GetApplicationAssignmentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAssignmentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAssignmentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationAssignmentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationAssignmentConfigurationInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationAssignmentConfigurationInput) SetApplicationArn(v string) *GetApplicationAssignmentConfigurationInput {
	s.ApplicationArn = &v
	return s
}

type GetApplicationAssignmentConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// If AssignmentsRequired is true (default value), users don’t have access
	// to the application unless an assignment is created using the CreateApplicationAssignment
	// API (https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html).
	// If false, all users have access to the application.
	//
	// AssignmentRequired is a required field
	AssignmentRequired *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAssignmentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAssignmentConfigurationOutput) GoString() string {
	return s.String()
}

// SetAssignmentRequired sets the AssignmentRequired field's value.
func (s *GetApplicationAssignmentConfigurationOutput) SetAssignmentRequired(v bool) *GetApplicationAssignmentConfigurationOutput {
	s.AssignmentRequired = &v
	return s
}

type GetApplicationAuthenticationMethodInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the type of authentication method for which you want details.
	//
	// AuthenticationMethodType is a required field
	AuthenticationMethodType *string `type:"string" required:"true" enum:"AuthenticationMethodType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAuthenticationMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAuthenticationMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationAuthenticationMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationAuthenticationMethodInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.AuthenticationMethodType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationMethodType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationAuthenticationMethodInput) SetApplicationArn(v string) *GetApplicationAuthenticationMethodInput {
	s.ApplicationArn = &v
	return s
}

// SetAuthenticationMethodType sets the AuthenticationMethodType field's value.
func (s *GetApplicationAuthenticationMethodInput) SetAuthenticationMethodType(v string) *GetApplicationAuthenticationMethodInput {
	s.AuthenticationMethodType = &v
	return s
}

type GetApplicationAuthenticationMethodOutput struct {
	_ struct{} `type:"structure"`

	// A structure that contains details about the requested authentication method.
	AuthenticationMethod *AuthenticationMethod `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAuthenticationMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationAuthenticationMethodOutput) GoString() string {
	return s.String()
}

// SetAuthenticationMethod sets the AuthenticationMethod field's value.
func (s *GetApplicationAuthenticationMethodOutput) SetAuthenticationMethod(v *AuthenticationMethod) *GetApplicationAuthenticationMethodOutput {
	s.AuthenticationMethod = v
	return s
}

type GetApplicationGrantInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application that contains the grant.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the type of grant.
	//
	// GrantType is a required field
	GrantType *string `type:"string" required:"true" enum:"GrantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationGrantInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.GrantType == nil {
		invalidParams.Add(request.NewErrParamRequired("GrantType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *GetApplicationGrantInput) SetApplicationArn(v string) *GetApplicationGrantInput {
	s.ApplicationArn = &v
	return s
}

// SetGrantType sets the GrantType field's value.
func (s *GetApplicationGrantInput) SetGrantType(v string) *GetApplicationGrantInput {
	s.GrantType = &v
	return s
}

type GetApplicationGrantOutput struct {
	_ struct{} `type:"structure"`

	// A structure that describes the requested grant.
	//
	// Grant is a required field
	Grant *Grant `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationGrantOutput) GoString() string {
	return s.String()
}

// SetGrant sets the Grant field's value.
func (s *GetApplicationGrantOutput) SetGrant(v *Grant) *GetApplicationGrantOutput {
	s.Grant = v
	return s
}

type GetInlinePolicyForPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInlinePolicyForPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInlinePolicyForPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInlinePolicyForPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInlinePolicyForPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *GetInlinePolicyForPermissionSetInput) SetInstanceArn(v string) *GetInlinePolicyForPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *GetInlinePolicyForPermissionSetInput) SetPermissionSetArn(v string) *GetInlinePolicyForPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type GetInlinePolicyForPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The inline policy that is attached to the permission set.
	//
	// For Length Constraints, if a valid ARN is provided for a permission set,
	// it is possible for an empty inline policy to be returned.
	InlinePolicy *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInlinePolicyForPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetInlinePolicyForPermissionSetOutput) GoString() string {
	return s.String()
}

// SetInlinePolicy sets the InlinePolicy field's value.
func (s *GetInlinePolicyForPermissionSetOutput) SetInlinePolicy(v string) *GetInlinePolicyForPermissionSetOutput {
	s.InlinePolicy = &v
	return s
}

type GetPermissionsBoundaryForPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the PermissionSet.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionsBoundaryForPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionsBoundaryForPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPermissionsBoundaryForPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPermissionsBoundaryForPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *GetPermissionsBoundaryForPermissionSetInput) SetInstanceArn(v string) *GetPermissionsBoundaryForPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *GetPermissionsBoundaryForPermissionSetInput) SetPermissionSetArn(v string) *GetPermissionsBoundaryForPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type GetPermissionsBoundaryForPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The permissions boundary attached to the specified permission set.
	PermissionsBoundary *PermissionsBoundary `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionsBoundaryForPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetPermissionsBoundaryForPermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionsBoundary sets the PermissionsBoundary field's value.
func (s *GetPermissionsBoundaryForPermissionSetOutput) SetPermissionsBoundary(v *PermissionsBoundary) *GetPermissionsBoundaryForPermissionSetOutput {
	s.PermissionsBoundary = v
	return s
}

// The Grant union represents the set of possible configuration options for
// the selected grant type. Exactly one member of the union must be specified,
// and must match the grant type selected.
type Grant struct {
	_ struct{} `type:"structure"`

	// Configuration options for the authorization_code grant type.
	AuthorizationCode *AuthorizationCodeGrant `type:"structure"`

	// Configuration options for the urn:ietf:params:oauth:grant-type:jwt-bearer
	// grant type.
	JwtBearer *JwtBearerGrant `type:"structure"`

	// Configuration options for the refresh_token grant type.
	RefreshToken *RefreshTokenGrant `type:"structure"`

	// Configuration options for the urn:ietf:params:oauth:grant-type:token-exchange
	// grant type.
	TokenExchange *TokenExchangeGrant `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Grant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Grant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Grant"}
	if s.AuthorizationCode != nil {
		if err := s.AuthorizationCode.Validate(); err != nil {
			invalidParams.AddNested("AuthorizationCode", err.(request.ErrInvalidParams))
		}
	}
	if s.JwtBearer != nil {
		if err := s.JwtBearer.Validate(); err != nil {
			invalidParams.AddNested("JwtBearer", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizationCode sets the AuthorizationCode field's value.
func (s *Grant) SetAuthorizationCode(v *AuthorizationCodeGrant) *Grant {
	s.AuthorizationCode = v
	return s
}

// SetJwtBearer sets the JwtBearer field's value.
func (s *Grant) SetJwtBearer(v *JwtBearerGrant) *Grant {
	s.JwtBearer = v
	return s
}

// SetRefreshToken sets the RefreshToken field's value.
func (s *Grant) SetRefreshToken(v *RefreshTokenGrant) *Grant {
	s.RefreshToken = v
	return s
}

// SetTokenExchange sets the TokenExchange field's value.
func (s *Grant) SetTokenExchange(v *TokenExchangeGrant) *Grant {
	s.TokenExchange = v
	return s
}

// A structure that defines a single grant and its configuration.
type GrantItem struct {
	_ struct{} `type:"structure"`

	// The configuration structure for the selected grant.
	//
	// Grant is a required field
	Grant *Grant `type:"structure" required:"true"`

	// The type of the selected grant.
	//
	// GrantType is a required field
	GrantType *string `type:"string" required:"true" enum:"GrantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GrantItem) GoString() string {
	return s.String()
}

// SetGrant sets the Grant field's value.
func (s *GrantItem) SetGrant(v *Grant) *GrantItem {
	s.Grant = v
	return s
}

// SetGrantType sets the GrantType field's value.
func (s *GrantItem) SetGrantType(v string) *GrantItem {
	s.GrantType = &v
	return s
}

// Specifies the attributes to add to your attribute-based access control (ABAC)
// configuration.
type InstanceAccessControlAttributeConfiguration struct {
	_ struct{} `type:"structure"`

	// Lists the attributes that are configured for ABAC in the specified IAM Identity
	// Center instance.
	//
	// AccessControlAttributes is a required field
	AccessControlAttributes []*AccessControlAttribute `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceAccessControlAttributeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceAccessControlAttributeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InstanceAccessControlAttributeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "InstanceAccessControlAttributeConfiguration"}
	if s.AccessControlAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessControlAttributes"))
	}
	if s.AccessControlAttributes != nil {
		for i, v := range s.AccessControlAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AccessControlAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessControlAttributes sets the AccessControlAttributes field's value.
func (s *InstanceAccessControlAttributeConfiguration) SetAccessControlAttributes(v []*AccessControlAttribute) *InstanceAccessControlAttributeConfiguration {
	s.AccessControlAttributes = v
	return s
}

// Provides information about the IAM Identity Center instance.
type InstanceMetadata struct {
	_ struct{} `type:"structure"`

	// The date and time that the Identity Center instance was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier of the identity store that is connected to the Identity Center
	// instance.
	IdentityStoreId *string `min:"1" type:"string"`

	// The ARN of the Identity Center instance under which the operation will be
	// executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`

	// The name of the Identity Center instance.
	Name *string `type:"string"`

	// The Amazon Web Services account ID number of the owner of the Identity Center
	// instance.
	OwnerAccountId *string `min:"12" type:"string"`

	// The current status of this Identity Center instance.
	Status *string `type:"string" enum:"InstanceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InstanceMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *InstanceMetadata) SetCreatedDate(v time.Time) *InstanceMetadata {
	s.CreatedDate = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *InstanceMetadata) SetIdentityStoreId(v string) *InstanceMetadata {
	s.IdentityStoreId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *InstanceMetadata) SetInstanceArn(v string) *InstanceMetadata {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *InstanceMetadata) SetName(v string) *InstanceMetadata {
	s.Name = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *InstanceMetadata) SetOwnerAccountId(v string) *InstanceMetadata {
	s.OwnerAccountId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceMetadata) SetStatus(v string) *InstanceMetadata {
	s.Status = &v
	return s
}

// The request processing has failed because of an unknown error, exception,
// or failure with an internal server.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that defines configuration settings for an application that supports
// the JWT Bearer Token Authorization Grant.
type JwtBearerGrant struct {
	_ struct{} `type:"structure"`

	// A list of allowed token issuers trusted by the Identity Center instances
	// for this application.
	AuthorizedTokenIssuers []*AuthorizedTokenIssuer `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JwtBearerGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JwtBearerGrant) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JwtBearerGrant) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JwtBearerGrant"}
	if s.AuthorizedTokenIssuers != nil && len(s.AuthorizedTokenIssuers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedTokenIssuers", 1))
	}
	if s.AuthorizedTokenIssuers != nil {
		for i, v := range s.AuthorizedTokenIssuers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AuthorizedTokenIssuers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizedTokenIssuers sets the AuthorizedTokenIssuers field's value.
func (s *JwtBearerGrant) SetAuthorizedTokenIssuers(v []*AuthorizedTokenIssuer) *JwtBearerGrant {
	s.AuthorizedTokenIssuers = v
	return s
}

type ListAccountAssignmentCreationStatusInput struct {
	_ struct{} `type:"structure"`

	// Filters results based on the passed attribute value.
	Filter *OperationStatusFilter `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentCreationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentCreationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentCreationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentCreationStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetFilter(v *OperationStatusFilter) *ListAccountAssignmentCreationStatusInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetInstanceArn(v string) *ListAccountAssignmentCreationStatusInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetMaxResults(v int64) *ListAccountAssignmentCreationStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentCreationStatusInput) SetNextToken(v string) *ListAccountAssignmentCreationStatusInput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentCreationStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment creation operation.
	AccountAssignmentsCreationStatus []*AccountAssignmentOperationStatusMetadata `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentCreationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentCreationStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentsCreationStatus sets the AccountAssignmentsCreationStatus field's value.
func (s *ListAccountAssignmentCreationStatusOutput) SetAccountAssignmentsCreationStatus(v []*AccountAssignmentOperationStatusMetadata) *ListAccountAssignmentCreationStatusOutput {
	s.AccountAssignmentsCreationStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentCreationStatusOutput) SetNextToken(v string) *ListAccountAssignmentCreationStatusOutput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentDeletionStatusInput struct {
	_ struct{} `type:"structure"`

	// Filters results based on the passed attribute value.
	Filter *OperationStatusFilter `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentDeletionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentDeletionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentDeletionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentDeletionStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetFilter(v *OperationStatusFilter) *ListAccountAssignmentDeletionStatusInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetInstanceArn(v string) *ListAccountAssignmentDeletionStatusInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetMaxResults(v int64) *ListAccountAssignmentDeletionStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentDeletionStatusInput) SetNextToken(v string) *ListAccountAssignmentDeletionStatusInput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentDeletionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the account assignment deletion operation.
	AccountAssignmentsDeletionStatus []*AccountAssignmentOperationStatusMetadata `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentDeletionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentDeletionStatusOutput) GoString() string {
	return s.String()
}

// SetAccountAssignmentsDeletionStatus sets the AccountAssignmentsDeletionStatus field's value.
func (s *ListAccountAssignmentDeletionStatusOutput) SetAccountAssignmentsDeletionStatus(v []*AccountAssignmentOperationStatusMetadata) *ListAccountAssignmentDeletionStatusOutput {
	s.AccountAssignmentsDeletionStatus = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentDeletionStatusOutput) SetNextToken(v string) *ListAccountAssignmentDeletionStatusOutput {
	s.NextToken = &v
	return s
}

// A structure that describes a filter for account assignments.
type ListAccountAssignmentsFilter struct {
	_ struct{} `type:"structure"`

	// The ID number of an Amazon Web Services account that filters the results
	// in the response.
	AccountId *string `min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentsFilter"}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccountAssignmentsFilter) SetAccountId(v string) *ListAccountAssignmentsFilter {
	s.AccountId = &v
	return s
}

type ListAccountAssignmentsForPrincipalInput struct {
	_ struct{} `type:"structure"`

	// Specifies an Amazon Web Services account ID number. Results are filtered
	// to only those that match this ID number.
	Filter *ListAccountAssignmentsFilter `type:"structure"`

	// Specifies the ARN of the instance of IAM Identity Center that contains the
	// principal.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`

	// Specifies the principal for which you want to retrieve the list of account
	// assignments.
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// Specifies the type of the principal.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsForPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsForPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentsForPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentsForPrincipalInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListAccountAssignmentsForPrincipalInput) SetFilter(v *ListAccountAssignmentsFilter) *ListAccountAssignmentsForPrincipalInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentsForPrincipalInput) SetInstanceArn(v string) *ListAccountAssignmentsForPrincipalInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentsForPrincipalInput) SetMaxResults(v int64) *ListAccountAssignmentsForPrincipalInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentsForPrincipalInput) SetNextToken(v string) *ListAccountAssignmentsForPrincipalInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListAccountAssignmentsForPrincipalInput) SetPrincipalId(v string) *ListAccountAssignmentsForPrincipalInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *ListAccountAssignmentsForPrincipalInput) SetPrincipalType(v string) *ListAccountAssignmentsForPrincipalInput {
	s.PrincipalType = &v
	return s
}

type ListAccountAssignmentsForPrincipalOutput struct {
	_ struct{} `type:"structure"`

	// An array list of the account assignments for the principal.
	AccountAssignments []*AccountAssignmentForPrincipal `type:"list"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsForPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsForPrincipalOutput) GoString() string {
	return s.String()
}

// SetAccountAssignments sets the AccountAssignments field's value.
func (s *ListAccountAssignmentsForPrincipalOutput) SetAccountAssignments(v []*AccountAssignmentForPrincipal) *ListAccountAssignmentsForPrincipalOutput {
	s.AccountAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentsForPrincipalOutput) SetNextToken(v string) *ListAccountAssignmentsForPrincipalOutput {
	s.NextToken = &v
	return s
}

type ListAccountAssignmentsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the permission set from which to list assignments.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountAssignmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountAssignmentsInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListAccountAssignmentsInput) SetAccountId(v string) *ListAccountAssignmentsInput {
	s.AccountId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountAssignmentsInput) SetInstanceArn(v string) *ListAccountAssignmentsInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountAssignmentsInput) SetMaxResults(v int64) *ListAccountAssignmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentsInput) SetNextToken(v string) *ListAccountAssignmentsInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListAccountAssignmentsInput) SetPermissionSetArn(v string) *ListAccountAssignmentsInput {
	s.PermissionSetArn = &v
	return s
}

type ListAccountAssignmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of assignments that match the input Amazon Web Services account
	// and permission set.
	AccountAssignments []*AccountAssignment `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountAssignmentsOutput) GoString() string {
	return s.String()
}

// SetAccountAssignments sets the AccountAssignments field's value.
func (s *ListAccountAssignmentsOutput) SetAccountAssignments(v []*AccountAssignment) *ListAccountAssignmentsOutput {
	s.AccountAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountAssignmentsOutput) SetNextToken(v string) *ListAccountAssignmentsOutput {
	s.NextToken = &v
	return s
}

type ListAccountsForProvisionedPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the PermissionSet.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the PermissionSet from which the associated Amazon Web Services
	// accounts will be listed.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// The permission set provisioning status for an Amazon Web Services account.
	ProvisioningStatus *string `type:"string" enum:"ProvisioningStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountsForProvisionedPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountsForProvisionedPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountsForProvisionedPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountsForProvisionedPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetInstanceArn(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetMaxResults(v int64) *ListAccountsForProvisionedPermissionSetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetNextToken(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetPermissionSetArn(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetProvisioningStatus sets the ProvisioningStatus field's value.
func (s *ListAccountsForProvisionedPermissionSetInput) SetProvisioningStatus(v string) *ListAccountsForProvisionedPermissionSetInput {
	s.ProvisioningStatus = &v
	return s
}

type ListAccountsForProvisionedPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon Web Services AccountIds.
	AccountIds []*string `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountsForProvisionedPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccountsForProvisionedPermissionSetOutput) GoString() string {
	return s.String()
}

// SetAccountIds sets the AccountIds field's value.
func (s *ListAccountsForProvisionedPermissionSetOutput) SetAccountIds(v []*string) *ListAccountsForProvisionedPermissionSetOutput {
	s.AccountIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountsForProvisionedPermissionSetOutput) SetNextToken(v string) *ListAccountsForProvisionedPermissionSetOutput {
	s.NextToken = &v
	return s
}

type ListApplicationAccessScopesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAccessScopesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAccessScopesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationAccessScopesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationAccessScopesInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListApplicationAccessScopesInput) SetApplicationArn(v string) *ListApplicationAccessScopesInput {
	s.ApplicationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationAccessScopesInput) SetMaxResults(v int64) *ListApplicationAccessScopesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAccessScopesInput) SetNextToken(v string) *ListApplicationAccessScopesInput {
	s.NextToken = &v
	return s
}

type ListApplicationAccessScopesOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`

	// An array list of access scopes and their authorized targets that are associated
	// with the application.
	//
	// Scopes is a required field
	Scopes []*ScopeDetails `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAccessScopesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAccessScopesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAccessScopesOutput) SetNextToken(v string) *ListApplicationAccessScopesOutput {
	s.NextToken = &v
	return s
}

// SetScopes sets the Scopes field's value.
func (s *ListApplicationAccessScopesOutput) SetScopes(v []*ScopeDetails) *ListApplicationAccessScopesOutput {
	s.Scopes = v
	return s
}

// A structure that describes a filter for application assignments.
type ListApplicationAssignmentsFilter struct {
	_ struct{} `type:"structure"`

	// The ARN of an application.
	ApplicationArn *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationAssignmentsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationAssignmentsFilter"}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListApplicationAssignmentsFilter) SetApplicationArn(v string) *ListApplicationAssignmentsFilter {
	s.ApplicationArn = &v
	return s
}

type ListApplicationAssignmentsForPrincipalInput struct {
	_ struct{} `type:"structure"`

	// Filters the output to include only assignments associated with the application
	// that has the specified ARN.
	Filter *ListApplicationAssignmentsFilter `type:"structure"`

	// Specifies the instance of IAM Identity Center that contains principal and
	// applications.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`

	// Specifies the unique identifier of the principal for which you want to retrieve
	// its assignments.
	//
	// PrincipalId is a required field
	PrincipalId *string `min:"1" type:"string" required:"true"`

	// Specifies the type of the principal for which you want to retrieve its assignments.
	//
	// PrincipalType is a required field
	PrincipalType *string `type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsForPrincipalInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsForPrincipalInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationAssignmentsForPrincipalInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationAssignmentsForPrincipalInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListApplicationAssignmentsForPrincipalInput) SetFilter(v *ListApplicationAssignmentsFilter) *ListApplicationAssignmentsForPrincipalInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListApplicationAssignmentsForPrincipalInput) SetInstanceArn(v string) *ListApplicationAssignmentsForPrincipalInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationAssignmentsForPrincipalInput) SetMaxResults(v int64) *ListApplicationAssignmentsForPrincipalInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAssignmentsForPrincipalInput) SetNextToken(v string) *ListApplicationAssignmentsForPrincipalInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListApplicationAssignmentsForPrincipalInput) SetPrincipalId(v string) *ListApplicationAssignmentsForPrincipalInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *ListApplicationAssignmentsForPrincipalInput) SetPrincipalType(v string) *ListApplicationAssignmentsForPrincipalInput {
	s.PrincipalType = &v
	return s
}

type ListApplicationAssignmentsForPrincipalOutput struct {
	_ struct{} `type:"structure"`

	// An array list of the application assignments for the specified principal.
	ApplicationAssignments []*ApplicationAssignmentForPrincipal `type:"list"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsForPrincipalOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsForPrincipalOutput) GoString() string {
	return s.String()
}

// SetApplicationAssignments sets the ApplicationAssignments field's value.
func (s *ListApplicationAssignmentsForPrincipalOutput) SetApplicationAssignments(v []*ApplicationAssignmentForPrincipal) *ListApplicationAssignmentsForPrincipalOutput {
	s.ApplicationAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAssignmentsForPrincipalOutput) SetNextToken(v string) *ListApplicationAssignmentsForPrincipalOutput {
	s.NextToken = &v
	return s
}

type ListApplicationAssignmentsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationAssignmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationAssignmentsInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListApplicationAssignmentsInput) SetApplicationArn(v string) *ListApplicationAssignmentsInput {
	s.ApplicationArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationAssignmentsInput) SetMaxResults(v int64) *ListApplicationAssignmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAssignmentsInput) SetNextToken(v string) *ListApplicationAssignmentsInput {
	s.NextToken = &v
	return s
}

type ListApplicationAssignmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of users assigned to an application.
	ApplicationAssignments []*ApplicationAssignment `type:"list"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAssignmentsOutput) GoString() string {
	return s.String()
}

// SetApplicationAssignments sets the ApplicationAssignments field's value.
func (s *ListApplicationAssignmentsOutput) SetApplicationAssignments(v []*ApplicationAssignment) *ListApplicationAssignmentsOutput {
	s.ApplicationAssignments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAssignmentsOutput) SetNextToken(v string) *ListApplicationAssignmentsOutput {
	s.NextToken = &v
	return s
}

type ListApplicationAuthenticationMethodsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the authentication methods you
	// want to list.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAuthenticationMethodsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAuthenticationMethodsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationAuthenticationMethodsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationAuthenticationMethodsInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListApplicationAuthenticationMethodsInput) SetApplicationArn(v string) *ListApplicationAuthenticationMethodsInput {
	s.ApplicationArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAuthenticationMethodsInput) SetNextToken(v string) *ListApplicationAuthenticationMethodsInput {
	s.NextToken = &v
	return s
}

type ListApplicationAuthenticationMethodsOutput struct {
	_ struct{} `type:"structure"`

	// An array list of authentication methods for the specified application.
	AuthenticationMethods []*AuthenticationMethodItem `type:"list"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAuthenticationMethodsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationAuthenticationMethodsOutput) GoString() string {
	return s.String()
}

// SetAuthenticationMethods sets the AuthenticationMethods field's value.
func (s *ListApplicationAuthenticationMethodsOutput) SetAuthenticationMethods(v []*AuthenticationMethodItem) *ListApplicationAuthenticationMethodsOutput {
	s.AuthenticationMethods = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationAuthenticationMethodsOutput) SetNextToken(v string) *ListApplicationAuthenticationMethodsOutput {
	s.NextToken = &v
	return s
}

type ListApplicationGrantsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application whose grants you want to list.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationGrantsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationGrantsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationGrantsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationGrantsInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *ListApplicationGrantsInput) SetApplicationArn(v string) *ListApplicationGrantsInput {
	s.ApplicationArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationGrantsInput) SetNextToken(v string) *ListApplicationGrantsInput {
	s.NextToken = &v
	return s
}

type ListApplicationGrantsOutput struct {
	_ struct{} `type:"structure"`

	// An array list of structures that describe the requested grants.
	//
	// Grants is a required field
	Grants []*GrantItem `type:"list" required:"true"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationGrantsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationGrantsOutput) GoString() string {
	return s.String()
}

// SetGrants sets the Grants field's value.
func (s *ListApplicationGrantsOutput) SetGrants(v []*GrantItem) *ListApplicationGrantsOutput {
	s.Grants = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationGrantsOutput) SetNextToken(v string) *ListApplicationGrantsOutput {
	s.NextToken = &v
	return s
}

type ListApplicationProvidersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationProvidersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationProvidersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationProvidersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationProvidersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationProvidersInput) SetMaxResults(v int64) *ListApplicationProvidersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationProvidersInput) SetNextToken(v string) *ListApplicationProvidersInput {
	s.NextToken = &v
	return s
}

type ListApplicationProvidersOutput struct {
	_ struct{} `type:"structure"`

	// An array list of structures that describe application providers.
	ApplicationProviders []*ApplicationProvider `type:"list"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationProvidersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationProvidersOutput) GoString() string {
	return s.String()
}

// SetApplicationProviders sets the ApplicationProviders field's value.
func (s *ListApplicationProvidersOutput) SetApplicationProviders(v []*ApplicationProvider) *ListApplicationProvidersOutput {
	s.ApplicationProviders = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationProvidersOutput) SetNextToken(v string) *ListApplicationProvidersOutput {
	s.NextToken = &v
	return s
}

// A structure that describes a filter for applications.
type ListApplicationsFilter struct {
	_ struct{} `type:"structure"`

	// An Amazon Web Services account ID number that filters the results in the
	// response.
	ApplicationAccount *string `min:"12" type:"string"`

	// The ARN of an application provider that can filter the results in the response.
	ApplicationProvider *string `min:"10" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsFilter"}
	if s.ApplicationAccount != nil && len(*s.ApplicationAccount) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationAccount", 12))
	}
	if s.ApplicationProvider != nil && len(*s.ApplicationProvider) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationProvider", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationAccount sets the ApplicationAccount field's value.
func (s *ListApplicationsFilter) SetApplicationAccount(v string) *ListApplicationsFilter {
	s.ApplicationAccount = &v
	return s
}

// SetApplicationProvider sets the ApplicationProvider field's value.
func (s *ListApplicationsFilter) SetApplicationProvider(v string) *ListApplicationsFilter {
	s.ApplicationProvider = &v
	return s
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Filters response results.
	Filter *ListApplicationsFilter `type:"structure"`

	// The ARN of the IAM Identity Center application under which the operation
	// will run. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filter != nil {
		if err := s.Filter.Validate(); err != nil {
			invalidParams.AddNested("Filter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListApplicationsInput) SetFilter(v *ListApplicationsFilter) *ListApplicationsInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListApplicationsInput) SetInstanceArn(v string) *ListApplicationsInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// Retrieves all applications associated with the instance.
	Applications []*Application `type:"list"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*Application) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListCustomerManagedPolicyReferencesInPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the list call.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the PermissionSet.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomerManagedPolicyReferencesInPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomerManagedPolicyReferencesInPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomerManagedPolicyReferencesInPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetInput) SetInstanceArn(v string) *ListCustomerManagedPolicyReferencesInPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetInput) SetMaxResults(v int64) *ListCustomerManagedPolicyReferencesInPermissionSetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetInput) SetNextToken(v string) *ListCustomerManagedPolicyReferencesInPermissionSetInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetInput) SetPermissionSetArn(v string) *ListCustomerManagedPolicyReferencesInPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type ListCustomerManagedPolicyReferencesInPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the names and paths of the customer managed policies that you have
	// attached to your permission set.
	CustomerManagedPolicyReferences []*CustomerManagedPolicyReference `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomerManagedPolicyReferencesInPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomerManagedPolicyReferencesInPermissionSetOutput) GoString() string {
	return s.String()
}

// SetCustomerManagedPolicyReferences sets the CustomerManagedPolicyReferences field's value.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetOutput) SetCustomerManagedPolicyReferences(v []*CustomerManagedPolicyReference) *ListCustomerManagedPolicyReferencesInPermissionSetOutput {
	s.CustomerManagedPolicyReferences = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomerManagedPolicyReferencesInPermissionSetOutput) SetNextToken(v string) *ListCustomerManagedPolicyReferencesInPermissionSetOutput {
	s.NextToken = &v
	return s
}

type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to display for the instance.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstancesInput) SetMaxResults(v int64) *ListInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesInput) SetNextToken(v string) *ListInstancesInput {
	s.NextToken = &v
	return s
}

type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Lists the IAM Identity Center instances that the caller has access to.
	Instances []*InstanceMetadata `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *ListInstancesOutput) SetInstances(v []*InstanceMetadata) *ListInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesOutput) SetNextToken(v string) *ListInstancesOutput {
	s.NextToken = &v
	return s
}

type ListManagedPoliciesInPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the PermissionSet.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the PermissionSet whose managed policies will be listed.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedPoliciesInPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedPoliciesInPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListManagedPoliciesInPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListManagedPoliciesInPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetInstanceArn(v string) *ListManagedPoliciesInPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetMaxResults(v int64) *ListManagedPoliciesInPermissionSetInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetNextToken(v string) *ListManagedPoliciesInPermissionSetInput {
	s.NextToken = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ListManagedPoliciesInPermissionSetInput) SetPermissionSetArn(v string) *ListManagedPoliciesInPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type ListManagedPoliciesInPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// An array of the AttachedManagedPolicy data type object.
	AttachedManagedPolicies []*AttachedManagedPolicy `type:"list"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedPoliciesInPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListManagedPoliciesInPermissionSetOutput) GoString() string {
	return s.String()
}

// SetAttachedManagedPolicies sets the AttachedManagedPolicies field's value.
func (s *ListManagedPoliciesInPermissionSetOutput) SetAttachedManagedPolicies(v []*AttachedManagedPolicy) *ListManagedPoliciesInPermissionSetOutput {
	s.AttachedManagedPolicies = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListManagedPoliciesInPermissionSetOutput) SetNextToken(v string) *ListManagedPoliciesInPermissionSetOutput {
	s.NextToken = &v
	return s
}

type ListPermissionSetProvisioningStatusInput struct {
	_ struct{} `type:"structure"`

	// Filters results based on the passed attribute value.
	Filter *OperationStatusFilter `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetProvisioningStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetProvisioningStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetProvisioningStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetProvisioningStatusInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetFilter(v *OperationStatusFilter) *ListPermissionSetProvisioningStatusInput {
	s.Filter = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetInstanceArn(v string) *ListPermissionSetProvisioningStatusInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetMaxResults(v int64) *ListPermissionSetProvisioningStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetProvisioningStatusInput) SetNextToken(v string) *ListPermissionSetProvisioningStatusInput {
	s.NextToken = &v
	return s
}

type ListPermissionSetProvisioningStatusOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The status object for the permission set provisioning operation.
	PermissionSetsProvisioningStatus []*PermissionSetProvisioningStatusMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetProvisioningStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetProvisioningStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetProvisioningStatusOutput) SetNextToken(v string) *ListPermissionSetProvisioningStatusOutput {
	s.NextToken = &v
	return s
}

// SetPermissionSetsProvisioningStatus sets the PermissionSetsProvisioningStatus field's value.
func (s *ListPermissionSetProvisioningStatusOutput) SetPermissionSetsProvisioningStatus(v []*PermissionSetProvisioningStatusMetadata) *ListPermissionSetProvisioningStatusOutput {
	s.PermissionSetsProvisioningStatus = v
	return s
}

type ListPermissionSetsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetsInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListPermissionSetsInput) SetInstanceArn(v string) *ListPermissionSetsInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionSetsInput) SetMaxResults(v int64) *ListPermissionSetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsInput) SetNextToken(v string) *ListPermissionSetsInput {
	s.NextToken = &v
	return s
}

type ListPermissionSetsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// Defines the level of access on an Amazon Web Services account.
	PermissionSets []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsOutput) SetNextToken(v string) *ListPermissionSetsOutput {
	s.NextToken = &v
	return s
}

// SetPermissionSets sets the PermissionSets field's value.
func (s *ListPermissionSetsOutput) SetPermissionSets(v []*string) *ListPermissionSetsOutput {
	s.PermissionSets = v
	return s
}

type ListPermissionSetsProvisionedToAccountInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	//
	// AccountId is a required field
	AccountId *string `min:"12" type:"string" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The maximum number of results to display for the assignment.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The status object for the permission set provisioning operation.
	ProvisioningStatus *string `type:"string" enum:"ProvisioningStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsProvisionedToAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsProvisionedToAccountInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetsProvisionedToAccountInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetsProvisionedToAccountInput"}
	if s.AccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("AccountId"))
	}
	if s.AccountId != nil && len(*s.AccountId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("AccountId", 12))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetAccountId(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.AccountId = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetInstanceArn(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetMaxResults(v int64) *ListPermissionSetsProvisionedToAccountInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetNextToken(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.NextToken = &v
	return s
}

// SetProvisioningStatus sets the ProvisioningStatus field's value.
func (s *ListPermissionSetsProvisionedToAccountInput) SetProvisioningStatus(v string) *ListPermissionSetsProvisionedToAccountInput {
	s.ProvisioningStatus = &v
	return s
}

type ListPermissionSetsProvisionedToAccountOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// Defines the level of access that an Amazon Web Services account has.
	PermissionSets []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsProvisionedToAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPermissionSetsProvisionedToAccountOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPermissionSetsProvisionedToAccountOutput) SetNextToken(v string) *ListPermissionSetsProvisionedToAccountOutput {
	s.NextToken = &v
	return s
}

// SetPermissionSets sets the PermissionSets field's value.
func (s *ListPermissionSetsProvisionedToAccountOutput) SetPermissionSets(v []*string) *ListPermissionSetsProvisionedToAccountOutput {
	s.PermissionSets = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// The ARN of the resource with the tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListTagsForResourceInput) SetInstanceArn(v string) *ListTagsForResourceInput {
	s.InstanceArn = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceInput) SetNextToken(v string) *ListTagsForResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token for the list API. Initially the value is null. Use the
	// output of previous API calls to make subsequent calls.
	NextToken *string `type:"string"`

	// A set of key-value pairs that are used to manage the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsForResourceOutput) SetNextToken(v string) *ListTagsForResourceOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTrustedTokenIssuersInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the instance of IAM Identity Center with the trusted
	// token issuer configurations that you want to list.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// Specifies the total number of results that you want included in each response.
	// If additional items exist beyond the number you specify, the NextToken response
	// element is returned with a value (not null). Include the specified value
	// as the NextToken request parameter in the next call to the operation to get
	// the next set of results. Note that the service might return fewer results
	// than the maximum even when there are more results available. You should check
	// NextToken after every operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Specifies that you want to receive the next page of results. Valid only if
	// you received a NextToken response in the previous request. If you did, it
	// indicates that more output is available. Set this parameter to the value
	// provided by the previous call's NextToken response to request the next page
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustedTokenIssuersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustedTokenIssuersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTrustedTokenIssuersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTrustedTokenIssuersInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ListTrustedTokenIssuersInput) SetInstanceArn(v string) *ListTrustedTokenIssuersInput {
	s.InstanceArn = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTrustedTokenIssuersInput) SetMaxResults(v int64) *ListTrustedTokenIssuersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustedTokenIssuersInput) SetNextToken(v string) *ListTrustedTokenIssuersInput {
	s.NextToken = &v
	return s
}

type ListTrustedTokenIssuersOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that more output is available than is included
	// in the current response. Use this value in the NextToken request parameter
	// in a subsequent call to the operation to get the next part of the output.
	// You should repeat this until the NextToken response element comes back as
	// null. This indicates that this is the last page of results.
	NextToken *string `type:"string"`

	// An array list of the trusted token issuer configurations.
	TrustedTokenIssuers []*TrustedTokenIssuerMetadata `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustedTokenIssuersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTrustedTokenIssuersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTrustedTokenIssuersOutput) SetNextToken(v string) *ListTrustedTokenIssuersOutput {
	s.NextToken = &v
	return s
}

// SetTrustedTokenIssuers sets the TrustedTokenIssuers field's value.
func (s *ListTrustedTokenIssuersOutput) SetTrustedTokenIssuers(v []*TrustedTokenIssuerMetadata) *ListTrustedTokenIssuersOutput {
	s.TrustedTokenIssuers = v
	return s
}

// A structure that describes configuration settings for a trusted token issuer
// that supports OpenID Connect (OIDC) and JSON Web Tokens (JWTs).
type OidcJwtConfiguration struct {
	_ struct{} `type:"structure"`

	// The path of the source attribute in the JWT from the trusted token issuer.
	// The attribute mapped by this JMESPath expression is compared against the
	// attribute mapped by IdentityStoreAttributePath when a trusted token issuer
	// token is exchanged for an IAM Identity Center token.
	//
	// ClaimAttributePath is a required field
	ClaimAttributePath *string `min:"1" type:"string" required:"true"`

	// The path of the destination attribute in a JWT from IAM Identity Center.
	// The attribute mapped by this JMESPath expression is compared against the
	// attribute mapped by ClaimAttributePath when a trusted token issuer token
	// is exchanged for an IAM Identity Center token.
	//
	// IdentityStoreAttributePath is a required field
	IdentityStoreAttributePath *string `min:"1" type:"string" required:"true"`

	// The URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery
	// is used to obtain the information required to verify the tokens that the
	// trusted token issuer generates.
	//
	// IssuerUrl is a required field
	IssuerUrl *string `min:"1" type:"string" required:"true"`

	// The method that the trusted token issuer can use to retrieve the JSON Web
	// Key Set used to verify a JWT.
	//
	// JwksRetrievalOption is a required field
	JwksRetrievalOption *string `type:"string" required:"true" enum:"JwksRetrievalOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcJwtConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcJwtConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OidcJwtConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OidcJwtConfiguration"}
	if s.ClaimAttributePath == nil {
		invalidParams.Add(request.NewErrParamRequired("ClaimAttributePath"))
	}
	if s.ClaimAttributePath != nil && len(*s.ClaimAttributePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClaimAttributePath", 1))
	}
	if s.IdentityStoreAttributePath == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreAttributePath"))
	}
	if s.IdentityStoreAttributePath != nil && len(*s.IdentityStoreAttributePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreAttributePath", 1))
	}
	if s.IssuerUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("IssuerUrl"))
	}
	if s.IssuerUrl != nil && len(*s.IssuerUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IssuerUrl", 1))
	}
	if s.JwksRetrievalOption == nil {
		invalidParams.Add(request.NewErrParamRequired("JwksRetrievalOption"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClaimAttributePath sets the ClaimAttributePath field's value.
func (s *OidcJwtConfiguration) SetClaimAttributePath(v string) *OidcJwtConfiguration {
	s.ClaimAttributePath = &v
	return s
}

// SetIdentityStoreAttributePath sets the IdentityStoreAttributePath field's value.
func (s *OidcJwtConfiguration) SetIdentityStoreAttributePath(v string) *OidcJwtConfiguration {
	s.IdentityStoreAttributePath = &v
	return s
}

// SetIssuerUrl sets the IssuerUrl field's value.
func (s *OidcJwtConfiguration) SetIssuerUrl(v string) *OidcJwtConfiguration {
	s.IssuerUrl = &v
	return s
}

// SetJwksRetrievalOption sets the JwksRetrievalOption field's value.
func (s *OidcJwtConfiguration) SetJwksRetrievalOption(v string) *OidcJwtConfiguration {
	s.JwksRetrievalOption = &v
	return s
}

// A structure that describes updated configuration settings for a trusted token
// issuer that supports OpenID Connect (OIDC) and JSON Web Tokens (JWTs).
type OidcJwtUpdateConfiguration struct {
	_ struct{} `type:"structure"`

	// The path of the source attribute in the JWT from the trusted token issuer.
	// The attribute mapped by this JMESPath expression is compared against the
	// attribute mapped by IdentityStoreAttributePath when a trusted token issuer
	// token is exchanged for an IAM Identity Center token.
	ClaimAttributePath *string `min:"1" type:"string"`

	// The path of the destination attribute in a JWT from IAM Identity Center.
	// The attribute mapped by this JMESPath expression is compared against the
	// attribute mapped by ClaimAttributePath when a trusted token issuer token
	// is exchanged for an IAM Identity Center token.
	IdentityStoreAttributePath *string `min:"1" type:"string"`

	// The method that the trusted token issuer can use to retrieve the JSON Web
	// Key Set used to verify a JWT.
	JwksRetrievalOption *string `type:"string" enum:"JwksRetrievalOption"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcJwtUpdateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcJwtUpdateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OidcJwtUpdateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OidcJwtUpdateConfiguration"}
	if s.ClaimAttributePath != nil && len(*s.ClaimAttributePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClaimAttributePath", 1))
	}
	if s.IdentityStoreAttributePath != nil && len(*s.IdentityStoreAttributePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreAttributePath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClaimAttributePath sets the ClaimAttributePath field's value.
func (s *OidcJwtUpdateConfiguration) SetClaimAttributePath(v string) *OidcJwtUpdateConfiguration {
	s.ClaimAttributePath = &v
	return s
}

// SetIdentityStoreAttributePath sets the IdentityStoreAttributePath field's value.
func (s *OidcJwtUpdateConfiguration) SetIdentityStoreAttributePath(v string) *OidcJwtUpdateConfiguration {
	s.IdentityStoreAttributePath = &v
	return s
}

// SetJwksRetrievalOption sets the JwksRetrievalOption field's value.
func (s *OidcJwtUpdateConfiguration) SetJwksRetrievalOption(v string) *OidcJwtUpdateConfiguration {
	s.JwksRetrievalOption = &v
	return s
}

// Filters the operation status list based on the passed attribute value.
type OperationStatusFilter struct {
	_ struct{} `type:"structure"`

	// Filters the list operations result based on the status attribute.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationStatusFilter) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *OperationStatusFilter) SetStatus(v string) *OperationStatusFilter {
	s.Status = &v
	return s
}

// An entity that contains IAM policies.
type PermissionSet struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The description of the PermissionSet.
	Description *string `min:"1" type:"string"`

	// The name of the permission set.
	Name *string `min:"1" type:"string"`

	// The ARN of the permission set. For more information about ARNs, see Amazon
	// Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// Used to redirect users within the application during the federation authentication
	// process.
	RelayState *string `min:"1" type:"string"`

	// The length of time that the application user sessions are valid for in the
	// ISO-8601 standard.
	SessionDuration *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionSet) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PermissionSet) SetCreatedDate(v time.Time) *PermissionSet {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PermissionSet) SetDescription(v string) *PermissionSet {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PermissionSet) SetName(v string) *PermissionSet {
	s.Name = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PermissionSet) SetPermissionSetArn(v string) *PermissionSet {
	s.PermissionSetArn = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *PermissionSet) SetRelayState(v string) *PermissionSet {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *PermissionSet) SetSessionDuration(v string) *PermissionSet {
	s.SessionDuration = &v
	return s
}

// A structure that is used to provide the status of the provisioning operation
// for a specified permission set.
type PermissionSetProvisioningStatus struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account from which to list the
	// assignments.
	AccountId *string `min:"12" type:"string"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The message that contains an error or exception in case of an operation failure.
	FailureReason *string `type:"string"`

	// The ARN of the permission set that is being provisioned. For more information
	// about ARNs, see Amazon Resource Names (ARNs) and Amazon Web Services Service
	// Namespaces (/general/latest/gr/aws-arns-and-namespaces.html) in the Amazon
	// Web Services General Reference.
	PermissionSetArn *string `min:"10" type:"string"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `min:"36" type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionSetProvisioningStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionSetProvisioningStatus) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *PermissionSetProvisioningStatus) SetAccountId(v string) *PermissionSetProvisioningStatus {
	s.AccountId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PermissionSetProvisioningStatus) SetCreatedDate(v time.Time) *PermissionSetProvisioningStatus {
	s.CreatedDate = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *PermissionSetProvisioningStatus) SetFailureReason(v string) *PermissionSetProvisioningStatus {
	s.FailureReason = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PermissionSetProvisioningStatus) SetPermissionSetArn(v string) *PermissionSetProvisioningStatus {
	s.PermissionSetArn = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PermissionSetProvisioningStatus) SetRequestId(v string) *PermissionSetProvisioningStatus {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PermissionSetProvisioningStatus) SetStatus(v string) *PermissionSetProvisioningStatus {
	s.Status = &v
	return s
}

// Provides information about the permission set provisioning status.
type PermissionSetProvisioningStatusMetadata struct {
	_ struct{} `type:"structure"`

	// The date that the permission set was created.
	CreatedDate *time.Time `type:"timestamp"`

	// The identifier for tracking the request operation that is generated by the
	// universally unique identifier (UUID) workflow.
	RequestId *string `min:"36" type:"string"`

	// The status of the permission set provisioning process.
	Status *string `type:"string" enum:"StatusValues"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionSetProvisioningStatusMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionSetProvisioningStatusMetadata) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *PermissionSetProvisioningStatusMetadata) SetCreatedDate(v time.Time) *PermissionSetProvisioningStatusMetadata {
	s.CreatedDate = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *PermissionSetProvisioningStatusMetadata) SetRequestId(v string) *PermissionSetProvisioningStatusMetadata {
	s.RequestId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PermissionSetProvisioningStatusMetadata) SetStatus(v string) *PermissionSetProvisioningStatusMetadata {
	s.Status = &v
	return s
}

// Specifies the configuration of the Amazon Web Services managed or customer
// managed policy that you want to set as a permissions boundary. Specify either
// CustomerManagedPolicyReference to use the name and path of a customer managed
// policy, or ManagedPolicyArn to use the ARN of an Amazon Web Services managed
// policy. A permissions boundary represents the maximum permissions that any
// policy can grant your role. For more information, see Permissions boundaries
// for IAM entities (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
// in the IAM User Guide.
//
// Policies used as permissions boundaries don't provide permissions. You must
// also attach an IAM policy to the role. To learn how the effective permissions
// for a role are evaluated, see IAM JSON policy evaluation logic (https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html)
// in the IAM User Guide.
type PermissionsBoundary struct {
	_ struct{} `type:"structure"`

	// Specifies the name and path of a customer managed policy. You must have an
	// IAM policy that matches the name and path in each Amazon Web Services account
	// where you want to deploy your permission set.
	CustomerManagedPolicyReference *CustomerManagedPolicyReference `type:"structure"`

	// The Amazon Web Services managed policy ARN that you want to attach to a permission
	// set as a permissions boundary.
	ManagedPolicyArn *string `min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionsBoundary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PermissionsBoundary) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PermissionsBoundary) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PermissionsBoundary"}
	if s.ManagedPolicyArn != nil && len(*s.ManagedPolicyArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ManagedPolicyArn", 20))
	}
	if s.CustomerManagedPolicyReference != nil {
		if err := s.CustomerManagedPolicyReference.Validate(); err != nil {
			invalidParams.AddNested("CustomerManagedPolicyReference", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerManagedPolicyReference sets the CustomerManagedPolicyReference field's value.
func (s *PermissionsBoundary) SetCustomerManagedPolicyReference(v *CustomerManagedPolicyReference) *PermissionsBoundary {
	s.CustomerManagedPolicyReference = v
	return s
}

// SetManagedPolicyArn sets the ManagedPolicyArn field's value.
func (s *PermissionsBoundary) SetManagedPolicyArn(v string) *PermissionsBoundary {
	s.ManagedPolicyArn = &v
	return s
}

// A structure that describes the options for the access portal associated with
// an application.
type PortalOptions struct {
	_ struct{} `type:"structure"`

	// A structure that describes the sign-in options for the access portal.
	SignInOptions *SignInOptions `type:"structure"`

	// Indicates whether this application is visible in the access portal.
	Visibility *string `type:"string" enum:"ApplicationVisibility"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PortalOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortalOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortalOptions"}
	if s.SignInOptions != nil {
		if err := s.SignInOptions.Validate(); err != nil {
			invalidParams.AddNested("SignInOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSignInOptions sets the SignInOptions field's value.
func (s *PortalOptions) SetSignInOptions(v *SignInOptions) *PortalOptions {
	s.SignInOptions = v
	return s
}

// SetVisibility sets the Visibility field's value.
func (s *PortalOptions) SetVisibility(v string) *PortalOptions {
	s.Visibility = &v
	return s
}

type ProvisionPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// TargetID is an Amazon Web Services account identifier, (For example, 123456789012).
	TargetId *string `min:"12" type:"string"`

	// The entity type for which the assignment will be created.
	//
	// TargetType is a required field
	TargetType *string `type:"string" required:"true" enum:"ProvisionTargetType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProvisionPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProvisionPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.TargetId != nil && len(*s.TargetId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("TargetId", 12))
	}
	if s.TargetType == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *ProvisionPermissionSetInput) SetInstanceArn(v string) *ProvisionPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *ProvisionPermissionSetInput) SetPermissionSetArn(v string) *ProvisionPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetTargetId sets the TargetId field's value.
func (s *ProvisionPermissionSetInput) SetTargetId(v string) *ProvisionPermissionSetInput {
	s.TargetId = &v
	return s
}

// SetTargetType sets the TargetType field's value.
func (s *ProvisionPermissionSetInput) SetTargetType(v string) *ProvisionPermissionSetInput {
	s.TargetType = &v
	return s
}

type ProvisionPermissionSetOutput struct {
	_ struct{} `type:"structure"`

	// The status object for the permission set provisioning operation.
	PermissionSetProvisioningStatus *PermissionSetProvisioningStatus `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionPermissionSetOutput) GoString() string {
	return s.String()
}

// SetPermissionSetProvisioningStatus sets the PermissionSetProvisioningStatus field's value.
func (s *ProvisionPermissionSetOutput) SetPermissionSetProvisioningStatus(v *PermissionSetProvisioningStatus) *ProvisionPermissionSetOutput {
	s.PermissionSetProvisioningStatus = v
	return s
}

type PutApplicationAccessScopeInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the access scope with the targets
	// to add or update.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies an array list of ARNs that represent the authorized targets for
	// this access scope.
	AuthorizedTargets []*string `min:"1" type:"list"`

	// Specifies the name of the access scope to be associated with the specified
	// targets.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAccessScopeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAccessScopeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApplicationAccessScopeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApplicationAccessScopeInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.AuthorizedTargets != nil && len(s.AuthorizedTargets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizedTargets", 1))
	}
	if s.Scope == nil {
		invalidParams.Add(request.NewErrParamRequired("Scope"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *PutApplicationAccessScopeInput) SetApplicationArn(v string) *PutApplicationAccessScopeInput {
	s.ApplicationArn = &v
	return s
}

// SetAuthorizedTargets sets the AuthorizedTargets field's value.
func (s *PutApplicationAccessScopeInput) SetAuthorizedTargets(v []*string) *PutApplicationAccessScopeInput {
	s.AuthorizedTargets = v
	return s
}

// SetScope sets the Scope field's value.
func (s *PutApplicationAccessScopeInput) SetScope(v string) *PutApplicationAccessScopeInput {
	s.Scope = &v
	return s
}

type PutApplicationAccessScopeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAccessScopeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAccessScopeOutput) GoString() string {
	return s.String()
}

type PutApplicationAssignmentConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// If AssignmentsRequired is true (default value), users don’t have access
	// to the application unless an assignment is created using the CreateApplicationAssignment
	// API (https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_CreateApplicationAssignment.html).
	// If false, all users have access to the application.
	//
	// AssignmentRequired is a required field
	AssignmentRequired *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAssignmentConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAssignmentConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApplicationAssignmentConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApplicationAssignmentConfigurationInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.AssignmentRequired == nil {
		invalidParams.Add(request.NewErrParamRequired("AssignmentRequired"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *PutApplicationAssignmentConfigurationInput) SetApplicationArn(v string) *PutApplicationAssignmentConfigurationInput {
	s.ApplicationArn = &v
	return s
}

// SetAssignmentRequired sets the AssignmentRequired field's value.
func (s *PutApplicationAssignmentConfigurationInput) SetAssignmentRequired(v bool) *PutApplicationAssignmentConfigurationInput {
	s.AssignmentRequired = &v
	return s
}

type PutApplicationAssignmentConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAssignmentConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAssignmentConfigurationOutput) GoString() string {
	return s.String()
}

type PutApplicationAuthenticationMethodInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application with the authentication method to add
	// or update.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies a structure that describes the authentication method to add or
	// update. The structure type you provide is determined by the AuthenticationMethodType
	// parameter.
	//
	// AuthenticationMethod is a required field
	AuthenticationMethod *AuthenticationMethod `type:"structure" required:"true"`

	// Specifies the type of the authentication method that you want to add or update.
	//
	// AuthenticationMethodType is a required field
	AuthenticationMethodType *string `type:"string" required:"true" enum:"AuthenticationMethodType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAuthenticationMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAuthenticationMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApplicationAuthenticationMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApplicationAuthenticationMethodInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.AuthenticationMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationMethod"))
	}
	if s.AuthenticationMethodType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthenticationMethodType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *PutApplicationAuthenticationMethodInput) SetApplicationArn(v string) *PutApplicationAuthenticationMethodInput {
	s.ApplicationArn = &v
	return s
}

// SetAuthenticationMethod sets the AuthenticationMethod field's value.
func (s *PutApplicationAuthenticationMethodInput) SetAuthenticationMethod(v *AuthenticationMethod) *PutApplicationAuthenticationMethodInput {
	s.AuthenticationMethod = v
	return s
}

// SetAuthenticationMethodType sets the AuthenticationMethodType field's value.
func (s *PutApplicationAuthenticationMethodInput) SetAuthenticationMethodType(v string) *PutApplicationAuthenticationMethodInput {
	s.AuthenticationMethodType = &v
	return s
}

type PutApplicationAuthenticationMethodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAuthenticationMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationAuthenticationMethodOutput) GoString() string {
	return s.String()
}

type PutApplicationGrantInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application to update.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// Specifies a structure that describes the grant to update.
	//
	// Grant is a required field
	Grant *Grant `type:"structure" required:"true"`

	// Specifies the type of grant to update.
	//
	// GrantType is a required field
	GrantType *string `type:"string" required:"true" enum:"GrantType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationGrantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationGrantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApplicationGrantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutApplicationGrantInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.Grant == nil {
		invalidParams.Add(request.NewErrParamRequired("Grant"))
	}
	if s.GrantType == nil {
		invalidParams.Add(request.NewErrParamRequired("GrantType"))
	}
	if s.Grant != nil {
		if err := s.Grant.Validate(); err != nil {
			invalidParams.AddNested("Grant", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *PutApplicationGrantInput) SetApplicationArn(v string) *PutApplicationGrantInput {
	s.ApplicationArn = &v
	return s
}

// SetGrant sets the Grant field's value.
func (s *PutApplicationGrantInput) SetGrant(v *Grant) *PutApplicationGrantInput {
	s.Grant = v
	return s
}

// SetGrantType sets the GrantType field's value.
func (s *PutApplicationGrantInput) SetGrantType(v string) *PutApplicationGrantInput {
	s.GrantType = &v
	return s
}

type PutApplicationGrantOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationGrantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutApplicationGrantOutput) GoString() string {
	return s.String()
}

type PutInlinePolicyToPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The inline policy to attach to a PermissionSet.
	//
	// InlinePolicy is a required field
	InlinePolicy *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInlinePolicyToPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInlinePolicyToPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInlinePolicyToPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutInlinePolicyToPermissionSetInput"}
	if s.InlinePolicy == nil {
		invalidParams.Add(request.NewErrParamRequired("InlinePolicy"))
	}
	if s.InlinePolicy != nil && len(*s.InlinePolicy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InlinePolicy", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInlinePolicy sets the InlinePolicy field's value.
func (s *PutInlinePolicyToPermissionSetInput) SetInlinePolicy(v string) *PutInlinePolicyToPermissionSetInput {
	s.InlinePolicy = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *PutInlinePolicyToPermissionSetInput) SetInstanceArn(v string) *PutInlinePolicyToPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PutInlinePolicyToPermissionSetInput) SetPermissionSetArn(v string) *PutInlinePolicyToPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

type PutInlinePolicyToPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInlinePolicyToPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutInlinePolicyToPermissionSetOutput) GoString() string {
	return s.String()
}

type PutPermissionsBoundaryToPermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the PermissionSet.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// The permissions boundary that you want to attach to a PermissionSet.
	//
	// PermissionsBoundary is a required field
	PermissionsBoundary *PermissionsBoundary `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionsBoundaryToPermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionsBoundaryToPermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPermissionsBoundaryToPermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPermissionsBoundaryToPermissionSetInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.PermissionsBoundary == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionsBoundary"))
	}
	if s.PermissionsBoundary != nil {
		if err := s.PermissionsBoundary.Validate(); err != nil {
			invalidParams.AddNested("PermissionsBoundary", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *PutPermissionsBoundaryToPermissionSetInput) SetInstanceArn(v string) *PutPermissionsBoundaryToPermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *PutPermissionsBoundaryToPermissionSetInput) SetPermissionSetArn(v string) *PutPermissionsBoundaryToPermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetPermissionsBoundary sets the PermissionsBoundary field's value.
func (s *PutPermissionsBoundaryToPermissionSetInput) SetPermissionsBoundary(v *PermissionsBoundary) *PutPermissionsBoundaryToPermissionSetInput {
	s.PermissionsBoundary = v
	return s
}

type PutPermissionsBoundaryToPermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionsBoundaryToPermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutPermissionsBoundaryToPermissionSetOutput) GoString() string {
	return s.String()
}

// A structure that defines configuration settings for an application that supports
// the OAuth 2.0 Refresh Token Grant.
type RefreshTokenGrant struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RefreshTokenGrant) GoString() string {
	return s.String()
}

// Indicates that a requested resource is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that describes the configuration of a resource server.
type ResourceServerConfig struct {
	_ struct{} `type:"structure"`

	// A list of the IAM Identity Center access scopes that are associated with
	// this resource server.
	Scopes map[string]*ResourceServerScopeDetails `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerConfig) GoString() string {
	return s.String()
}

// SetScopes sets the Scopes field's value.
func (s *ResourceServerConfig) SetScopes(v map[string]*ResourceServerScopeDetails) *ResourceServerConfig {
	s.Scopes = v
	return s
}

// A structure that describes details for an IAM Identity Center access scope
// that is associated with a resource server.
type ResourceServerScopeDetails struct {
	_ struct{} `type:"structure"`

	// The title of an access scope for a resource server.
	DetailedTitle *string `min:"1" type:"string"`

	// The description of an access scope for a resource server.
	LongDescription *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerScopeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceServerScopeDetails) GoString() string {
	return s.String()
}

// SetDetailedTitle sets the DetailedTitle field's value.
func (s *ResourceServerScopeDetails) SetDetailedTitle(v string) *ResourceServerScopeDetails {
	s.DetailedTitle = &v
	return s
}

// SetLongDescription sets the LongDescription field's value.
func (s *ResourceServerScopeDetails) SetLongDescription(v string) *ResourceServerScopeDetails {
	s.LongDescription = &v
	return s
}

// A structure that describes an IAM Identity Center access scope and its authorized
// targets.
type ScopeDetails struct {
	_ struct{} `type:"structure"`

	// An array list of ARNs of applications.
	AuthorizedTargets []*string `min:"1" type:"list"`

	// The name of the access scope.
	//
	// Scope is a required field
	Scope *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScopeDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScopeDetails) GoString() string {
	return s.String()
}

// SetAuthorizedTargets sets the AuthorizedTargets field's value.
func (s *ScopeDetails) SetAuthorizedTargets(v []*string) *ScopeDetails {
	s.AuthorizedTargets = v
	return s
}

// SetScope sets the Scope field's value.
func (s *ScopeDetails) SetScope(v string) *ScopeDetails {
	s.Scope = &v
	return s
}

// Indicates that the principal has crossed the permitted number of resources
// that can be created.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that describes the sign-in options for an application portal.
type SignInOptions struct {
	_ struct{} `type:"structure"`

	// The URL that accepts authentication requests for an application. This is
	// a required parameter if the Origin parameter is APPLICATION.
	ApplicationUrl *string `min:"1" type:"string"`

	// This determines how IAM Identity Center navigates the user to the target
	// application. It can be one of the following values:
	//
	//    * APPLICATION: IAM Identity Center redirects the customer to the configured
	//    ApplicationUrl.
	//
	//    * IDENTITY_CENTER: IAM Identity Center uses SAML identity-provider initiated
	//    authentication to sign the customer directly into a SAML-based application.
	//
	// Origin is a required field
	Origin *string `type:"string" required:"true" enum:"SignInOrigin"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignInOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SignInOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SignInOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SignInOptions"}
	if s.ApplicationUrl != nil && len(*s.ApplicationUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationUrl", 1))
	}
	if s.Origin == nil {
		invalidParams.Add(request.NewErrParamRequired("Origin"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationUrl sets the ApplicationUrl field's value.
func (s *SignInOptions) SetApplicationUrl(v string) *SignInOptions {
	s.ApplicationUrl = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *SignInOptions) SetOrigin(v string) *SignInOptions {
	s.Origin = &v
	return s
}

// A set of key-value pairs that are used to manage the resource. Tags can only
// be applied to permission sets and cannot be applied to corresponding roles
// that IAM Identity Center creates in Amazon Web Services accounts.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`

	// The ARN of the resource with the tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"10" type:"string" required:"true"`

	// A set of key-value pairs that are used to manage the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 10))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *TagResourceInput) SetInstanceArn(v string) *TagResourceInput {
	s.InstanceArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Indicates that the principal has crossed the throttling limits of the API
// operations.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that defines configuration settings for an application that supports
// the OAuth 2.0 Token Exchange Grant.
type TokenExchangeGrant struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenExchangeGrant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenExchangeGrant) GoString() string {
	return s.String()
}

// A structure that describes the configuration of a trusted token issuer. The
// structure and available settings are determined by the type of the trusted
// token issuer.
type TrustedTokenIssuerConfiguration struct {
	_ struct{} `type:"structure"`

	// A structure that describes the settings for a trusted token issuer that works
	// with OpenID Connect (OIDC) by using JSON Web Tokens (JWT).
	OidcJwtConfiguration *OidcJwtConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedTokenIssuerConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedTokenIssuerConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedTokenIssuerConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrustedTokenIssuerConfiguration"}
	if s.OidcJwtConfiguration != nil {
		if err := s.OidcJwtConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OidcJwtConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOidcJwtConfiguration sets the OidcJwtConfiguration field's value.
func (s *TrustedTokenIssuerConfiguration) SetOidcJwtConfiguration(v *OidcJwtConfiguration) *TrustedTokenIssuerConfiguration {
	s.OidcJwtConfiguration = v
	return s
}

// A structure that describes a trusted token issuer.
type TrustedTokenIssuerMetadata struct {
	_ struct{} `type:"structure"`

	// The name of the trusted token issuer configuration in the instance of IAM
	// Identity Center.
	Name *string `min:"1" type:"string"`

	// The ARN of the trusted token issuer configuration in the instance of IAM
	// Identity Center.
	TrustedTokenIssuerArn *string `min:"10" type:"string"`

	// The type of trusted token issuer.
	TrustedTokenIssuerType *string `type:"string" enum:"TrustedTokenIssuerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedTokenIssuerMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedTokenIssuerMetadata) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *TrustedTokenIssuerMetadata) SetName(v string) *TrustedTokenIssuerMetadata {
	s.Name = &v
	return s
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *TrustedTokenIssuerMetadata) SetTrustedTokenIssuerArn(v string) *TrustedTokenIssuerMetadata {
	s.TrustedTokenIssuerArn = &v
	return s
}

// SetTrustedTokenIssuerType sets the TrustedTokenIssuerType field's value.
func (s *TrustedTokenIssuerMetadata) SetTrustedTokenIssuerType(v string) *TrustedTokenIssuerMetadata {
	s.TrustedTokenIssuerType = &v
	return s
}

// A structure that contains details to be updated for a trusted token issuer
// configuration. The structure and settings that you can include depend on
// the type of the trusted token issuer being updated.
type TrustedTokenIssuerUpdateConfiguration struct {
	_ struct{} `type:"structure"`

	// A structure that describes an updated configuration for a trusted token issuer
	// that uses OpenID Connect (OIDC) with JSON web tokens (JWT).
	OidcJwtConfiguration *OidcJwtUpdateConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedTokenIssuerUpdateConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TrustedTokenIssuerUpdateConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrustedTokenIssuerUpdateConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrustedTokenIssuerUpdateConfiguration"}
	if s.OidcJwtConfiguration != nil {
		if err := s.OidcJwtConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OidcJwtConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOidcJwtConfiguration sets the OidcJwtConfiguration field's value.
func (s *TrustedTokenIssuerUpdateConfiguration) SetOidcJwtConfiguration(v *OidcJwtUpdateConfiguration) *TrustedTokenIssuerUpdateConfiguration {
	s.OidcJwtConfiguration = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	InstanceArn *string `min:"10" type:"string"`

	// The ARN of the resource with the tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"10" type:"string" required:"true"`

	// The keys of tags that are attached to the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 10))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UntagResourceInput) SetInstanceArn(v string) *UntagResourceInput {
	s.InstanceArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN of the application. For more information about ARNs, see
	// Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// ApplicationArn is a required field
	ApplicationArn *string `min:"10" type:"string" required:"true"`

	// The description of the .
	Description *string `min:"1" type:"string"`

	// Specifies the updated name for the application.
	Name *string `type:"string"`

	// A structure that describes the options for the portal associated with an
	// application.
	PortalOptions *UpdateApplicationPortalOptions `type:"structure"`

	// Specifies whether the application is enabled or disabled.
	Status *string `type:"string" enum:"ApplicationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.ApplicationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationArn"))
	}
	if s.ApplicationArn != nil && len(*s.ApplicationArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationArn", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.PortalOptions != nil {
		if err := s.PortalOptions.Validate(); err != nil {
			invalidParams.AddNested("PortalOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *UpdateApplicationInput) SetApplicationArn(v string) *UpdateApplicationInput {
	s.ApplicationArn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationInput) SetName(v string) *UpdateApplicationInput {
	s.Name = &v
	return s
}

// SetPortalOptions sets the PortalOptions field's value.
func (s *UpdateApplicationInput) SetPortalOptions(v *UpdateApplicationPortalOptions) *UpdateApplicationInput {
	s.PortalOptions = v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateApplicationInput) SetStatus(v string) *UpdateApplicationInput {
	s.Status = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// A structure that describes the options for the access portal associated with
// an application that can be updated.
type UpdateApplicationPortalOptions struct {
	_ struct{} `type:"structure"`

	// A structure that describes the sign-in options for an application portal.
	SignInOptions *SignInOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationPortalOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationPortalOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationPortalOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationPortalOptions"}
	if s.SignInOptions != nil {
		if err := s.SignInOptions.Validate(); err != nil {
			invalidParams.AddNested("SignInOptions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSignInOptions sets the SignInOptions field's value.
func (s *UpdateApplicationPortalOptions) SetSignInOptions(v *SignInOptions) *UpdateApplicationPortalOptions {
	s.SignInOptions = v
	return s
}

type UpdateInstanceAccessControlAttributeConfigurationInput struct {
	_ struct{} `type:"structure"`

	// Updates the attributes for your ABAC configuration.
	//
	// InstanceAccessControlAttributeConfiguration is a required field
	InstanceAccessControlAttributeConfiguration *InstanceAccessControlAttributeConfiguration `type:"structure" required:"true"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceAccessControlAttributeConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceAccessControlAttributeConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceAccessControlAttributeConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstanceAccessControlAttributeConfigurationInput"}
	if s.InstanceAccessControlAttributeConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceAccessControlAttributeConfiguration"))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.InstanceAccessControlAttributeConfiguration != nil {
		if err := s.InstanceAccessControlAttributeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InstanceAccessControlAttributeConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceAccessControlAttributeConfiguration sets the InstanceAccessControlAttributeConfiguration field's value.
func (s *UpdateInstanceAccessControlAttributeConfigurationInput) SetInstanceAccessControlAttributeConfiguration(v *InstanceAccessControlAttributeConfiguration) *UpdateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceAccessControlAttributeConfiguration = v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UpdateInstanceAccessControlAttributeConfigurationInput) SetInstanceArn(v string) *UpdateInstanceAccessControlAttributeConfigurationInput {
	s.InstanceArn = &v
	return s
}

type UpdateInstanceAccessControlAttributeConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceAccessControlAttributeConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceAccessControlAttributeConfigurationOutput) GoString() string {
	return s.String()
}

type UpdateInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the instance of IAM Identity Center under which the operation
	// will run. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// Updates the instance name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstanceInput"}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UpdateInstanceInput) SetInstanceArn(v string) *UpdateInstanceInput {
	s.InstanceArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateInstanceInput) SetName(v string) *UpdateInstanceInput {
	s.Name = &v
	return s
}

type UpdateInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateInstanceOutput) GoString() string {
	return s.String()
}

type UpdatePermissionSetInput struct {
	_ struct{} `type:"structure"`

	// The description of the PermissionSet.
	Description *string `min:"1" type:"string"`

	// The ARN of the IAM Identity Center instance under which the operation will
	// be executed. For more information about ARNs, see Amazon Resource Names (ARNs)
	// and Amazon Web Services Service Namespaces (/general/latest/gr/aws-arns-and-namespaces.html)
	// in the Amazon Web Services General Reference.
	//
	// InstanceArn is a required field
	InstanceArn *string `min:"10" type:"string" required:"true"`

	// The ARN of the permission set.
	//
	// PermissionSetArn is a required field
	PermissionSetArn *string `min:"10" type:"string" required:"true"`

	// Used to redirect users within the application during the federation authentication
	// process.
	RelayState *string `min:"1" type:"string"`

	// The length of time that the application user sessions are valid for in the
	// ISO-8601 standard.
	SessionDuration *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePermissionSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePermissionSetInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceArn"))
	}
	if s.InstanceArn != nil && len(*s.InstanceArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceArn", 10))
	}
	if s.PermissionSetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PermissionSetArn"))
	}
	if s.PermissionSetArn != nil && len(*s.PermissionSetArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("PermissionSetArn", 10))
	}
	if s.RelayState != nil && len(*s.RelayState) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RelayState", 1))
	}
	if s.SessionDuration != nil && len(*s.SessionDuration) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionDuration", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdatePermissionSetInput) SetDescription(v string) *UpdatePermissionSetInput {
	s.Description = &v
	return s
}

// SetInstanceArn sets the InstanceArn field's value.
func (s *UpdatePermissionSetInput) SetInstanceArn(v string) *UpdatePermissionSetInput {
	s.InstanceArn = &v
	return s
}

// SetPermissionSetArn sets the PermissionSetArn field's value.
func (s *UpdatePermissionSetInput) SetPermissionSetArn(v string) *UpdatePermissionSetInput {
	s.PermissionSetArn = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *UpdatePermissionSetInput) SetRelayState(v string) *UpdatePermissionSetInput {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *UpdatePermissionSetInput) SetSessionDuration(v string) *UpdatePermissionSetInput {
	s.SessionDuration = &v
	return s
}

type UpdatePermissionSetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePermissionSetOutput) GoString() string {
	return s.String()
}

type UpdateTrustedTokenIssuerInput struct {
	_ struct{} `type:"structure"`

	// Specifies the updated name to be applied to the trusted token issuer configuration.
	Name *string `min:"1" type:"string"`

	// Specifies the ARN of the trusted token issuer configuration that you want
	// to update.
	//
	// TrustedTokenIssuerArn is a required field
	TrustedTokenIssuerArn *string `min:"10" type:"string" required:"true"`

	// Specifies a structure with settings to apply to the specified trusted token
	// issuer. The settings that you can provide are determined by the type of the
	// trusted token issuer that you are updating.
	TrustedTokenIssuerConfiguration *TrustedTokenIssuerUpdateConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustedTokenIssuerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustedTokenIssuerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTrustedTokenIssuerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTrustedTokenIssuerInput"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.TrustedTokenIssuerArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TrustedTokenIssuerArn"))
	}
	if s.TrustedTokenIssuerArn != nil && len(*s.TrustedTokenIssuerArn) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("TrustedTokenIssuerArn", 10))
	}
	if s.TrustedTokenIssuerConfiguration != nil {
		if err := s.TrustedTokenIssuerConfiguration.Validate(); err != nil {
			invalidParams.AddNested("TrustedTokenIssuerConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateTrustedTokenIssuerInput) SetName(v string) *UpdateTrustedTokenIssuerInput {
	s.Name = &v
	return s
}

// SetTrustedTokenIssuerArn sets the TrustedTokenIssuerArn field's value.
func (s *UpdateTrustedTokenIssuerInput) SetTrustedTokenIssuerArn(v string) *UpdateTrustedTokenIssuerInput {
	s.TrustedTokenIssuerArn = &v
	return s
}

// SetTrustedTokenIssuerConfiguration sets the TrustedTokenIssuerConfiguration field's value.
func (s *UpdateTrustedTokenIssuerInput) SetTrustedTokenIssuerConfiguration(v *TrustedTokenIssuerUpdateConfiguration) *UpdateTrustedTokenIssuerInput {
	s.TrustedTokenIssuerConfiguration = v
	return s
}

type UpdateTrustedTokenIssuerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustedTokenIssuerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTrustedTokenIssuerOutput) GoString() string {
	return s.String()
}

// The request failed because it contains a syntax error.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ApplicationStatusEnabled is a ApplicationStatus enum value
	ApplicationStatusEnabled = "ENABLED"

	// ApplicationStatusDisabled is a ApplicationStatus enum value
	ApplicationStatusDisabled = "DISABLED"
)

// ApplicationStatus_Values returns all elements of the ApplicationStatus enum
func ApplicationStatus_Values() []string {
	return []string{
		ApplicationStatusEnabled,
		ApplicationStatusDisabled,
	}
}

const (
	// ApplicationVisibilityEnabled is a ApplicationVisibility enum value
	ApplicationVisibilityEnabled = "ENABLED"

	// ApplicationVisibilityDisabled is a ApplicationVisibility enum value
	ApplicationVisibilityDisabled = "DISABLED"
)

// ApplicationVisibility_Values returns all elements of the ApplicationVisibility enum
func ApplicationVisibility_Values() []string {
	return []string{
		ApplicationVisibilityEnabled,
		ApplicationVisibilityDisabled,
	}
}

const (
	// AuthenticationMethodTypeIam is a AuthenticationMethodType enum value
	AuthenticationMethodTypeIam = "IAM"
)

// AuthenticationMethodType_Values returns all elements of the AuthenticationMethodType enum
func AuthenticationMethodType_Values() []string {
	return []string{
		AuthenticationMethodTypeIam,
	}
}

const (
	// FederationProtocolSaml is a FederationProtocol enum value
	FederationProtocolSaml = "SAML"

	// FederationProtocolOauth is a FederationProtocol enum value
	FederationProtocolOauth = "OAUTH"
)

// FederationProtocol_Values returns all elements of the FederationProtocol enum
func FederationProtocol_Values() []string {
	return []string{
		FederationProtocolSaml,
		FederationProtocolOauth,
	}
}

const (
	// GrantTypeAuthorizationCode is a GrantType enum value
	GrantTypeAuthorizationCode = "authorization_code"

	// GrantTypeRefreshToken is a GrantType enum value
	GrantTypeRefreshToken = "refresh_token"

	// GrantTypeUrnIetfParamsOauthGrantTypeJwtBearer is a GrantType enum value
	GrantTypeUrnIetfParamsOauthGrantTypeJwtBearer = "urn:ietf:params:oauth:grant-type:jwt-bearer"

	// GrantTypeUrnIetfParamsOauthGrantTypeTokenExchange is a GrantType enum value
	GrantTypeUrnIetfParamsOauthGrantTypeTokenExchange = "urn:ietf:params:oauth:grant-type:token-exchange"
)

// GrantType_Values returns all elements of the GrantType enum
func GrantType_Values() []string {
	return []string{
		GrantTypeAuthorizationCode,
		GrantTypeRefreshToken,
		GrantTypeUrnIetfParamsOauthGrantTypeJwtBearer,
		GrantTypeUrnIetfParamsOauthGrantTypeTokenExchange,
	}
}

const (
	// InstanceAccessControlAttributeConfigurationStatusEnabled is a InstanceAccessControlAttributeConfigurationStatus enum value
	InstanceAccessControlAttributeConfigurationStatusEnabled = "ENABLED"

	// InstanceAccessControlAttributeConfigurationStatusCreationInProgress is a InstanceAccessControlAttributeConfigurationStatus enum value
	InstanceAccessControlAttributeConfigurationStatusCreationInProgress = "CREATION_IN_PROGRESS"

	// InstanceAccessControlAttributeConfigurationStatusCreationFailed is a InstanceAccessControlAttributeConfigurationStatus enum value
	InstanceAccessControlAttributeConfigurationStatusCreationFailed = "CREATION_FAILED"
)

// InstanceAccessControlAttributeConfigurationStatus_Values returns all elements of the InstanceAccessControlAttributeConfigurationStatus enum
func InstanceAccessControlAttributeConfigurationStatus_Values() []string {
	return []string{
		InstanceAccessControlAttributeConfigurationStatusEnabled,
		InstanceAccessControlAttributeConfigurationStatusCreationInProgress,
		InstanceAccessControlAttributeConfigurationStatusCreationFailed,
	}
}

const (
	// InstanceStatusCreateInProgress is a InstanceStatus enum value
	InstanceStatusCreateInProgress = "CREATE_IN_PROGRESS"

	// InstanceStatusDeleteInProgress is a InstanceStatus enum value
	InstanceStatusDeleteInProgress = "DELETE_IN_PROGRESS"

	// InstanceStatusActive is a InstanceStatus enum value
	InstanceStatusActive = "ACTIVE"
)

// InstanceStatus_Values returns all elements of the InstanceStatus enum
func InstanceStatus_Values() []string {
	return []string{
		InstanceStatusCreateInProgress,
		InstanceStatusDeleteInProgress,
		InstanceStatusActive,
	}
}

const (
	// JwksRetrievalOptionOpenIdDiscovery is a JwksRetrievalOption enum value
	JwksRetrievalOptionOpenIdDiscovery = "OPEN_ID_DISCOVERY"
)

// JwksRetrievalOption_Values returns all elements of the JwksRetrievalOption enum
func JwksRetrievalOption_Values() []string {
	return []string{
		JwksRetrievalOptionOpenIdDiscovery,
	}
}

const (
	// PrincipalTypeUser is a PrincipalType enum value
	PrincipalTypeUser = "USER"

	// PrincipalTypeGroup is a PrincipalType enum value
	PrincipalTypeGroup = "GROUP"
)

// PrincipalType_Values returns all elements of the PrincipalType enum
func PrincipalType_Values() []string {
	return []string{
		PrincipalTypeUser,
		PrincipalTypeGroup,
	}
}

const (
	// ProvisionTargetTypeAwsAccount is a ProvisionTargetType enum value
	ProvisionTargetTypeAwsAccount = "AWS_ACCOUNT"

	// ProvisionTargetTypeAllProvisionedAccounts is a ProvisionTargetType enum value
	ProvisionTargetTypeAllProvisionedAccounts = "ALL_PROVISIONED_ACCOUNTS"
)

// ProvisionTargetType_Values returns all elements of the ProvisionTargetType enum
func ProvisionTargetType_Values() []string {
	return []string{
		ProvisionTargetTypeAwsAccount,
		ProvisionTargetTypeAllProvisionedAccounts,
	}
}

const (
	// ProvisioningStatusLatestPermissionSetProvisioned is a ProvisioningStatus enum value
	ProvisioningStatusLatestPermissionSetProvisioned = "LATEST_PERMISSION_SET_PROVISIONED"

	// ProvisioningStatusLatestPermissionSetNotProvisioned is a ProvisioningStatus enum value
	ProvisioningStatusLatestPermissionSetNotProvisioned = "LATEST_PERMISSION_SET_NOT_PROVISIONED"
)

// ProvisioningStatus_Values returns all elements of the ProvisioningStatus enum
func ProvisioningStatus_Values() []string {
	return []string{
		ProvisioningStatusLatestPermissionSetProvisioned,
		ProvisioningStatusLatestPermissionSetNotProvisioned,
	}
}

const (
	// SignInOriginIdentityCenter is a SignInOrigin enum value
	SignInOriginIdentityCenter = "IDENTITY_CENTER"

	// SignInOriginApplication is a SignInOrigin enum value
	SignInOriginApplication = "APPLICATION"
)

// SignInOrigin_Values returns all elements of the SignInOrigin enum
func SignInOrigin_Values() []string {
	return []string{
		SignInOriginIdentityCenter,
		SignInOriginApplication,
	}
}

const (
	// StatusValuesInProgress is a StatusValues enum value
	StatusValuesInProgress = "IN_PROGRESS"

	// StatusValuesFailed is a StatusValues enum value
	StatusValuesFailed = "FAILED"

	// StatusValuesSucceeded is a StatusValues enum value
	StatusValuesSucceeded = "SUCCEEDED"
)

// StatusValues_Values returns all elements of the StatusValues enum
func StatusValues_Values() []string {
	return []string{
		StatusValuesInProgress,
		StatusValuesFailed,
		StatusValuesSucceeded,
	}
}

const (
	// TargetTypeAwsAccount is a TargetType enum value
	TargetTypeAwsAccount = "AWS_ACCOUNT"
)

// TargetType_Values returns all elements of the TargetType enum
func TargetType_Values() []string {
	return []string{
		TargetTypeAwsAccount,
	}
}

const (
	// TrustedTokenIssuerTypeOidcJwt is a TrustedTokenIssuerType enum value
	TrustedTokenIssuerTypeOidcJwt = "OIDC_JWT"
)

// TrustedTokenIssuerType_Values returns all elements of the TrustedTokenIssuerType enum
func TrustedTokenIssuerType_Values() []string {
	return []string{
		TrustedTokenIssuerTypeOidcJwt,
	}
}
