#ifndef _SYS_FUTEX_H
#define _SYS_FUTEX_H

#include <sys/types.h>
#include <sys/time.h>

__BEGIN_DECLS

enum {
  FUTEX_WAIT=0,
  FUTEX_WAKE=1,
  FUTEX_FD=2,
  FUTEX_REQUEUE=3,
  FUTEX_CMP_REQUEUE=4,
  FUTEX_WAKE_OP=5,
  FUTEX_LOCK_PI=6,
  FUTEX_UNLOCK_PI=7,
  FUTEX_TRYLOCK_PI=8,
  FUTEX_WAIT_BITSET=9,
  FUTEX_WAKE_BITSET=10,
  FUTEX_WAIT_REQUEUE_PI=11,
  FUTEX_CMP_REQUEUE_PI=12,
  FUTEX_LOCK_PI2=13,

  FUTEX_PRIVATE_FLAG=128,
  FUTEX_CLOCK_REALTIME=256,
  FUTEX_CMD_MASK=~(FUTEX_PRIVATE_FLAG | FUTEX_CLOCK_REALTIME),

  FUTEX_WAIT_PRIVATE=(FUTEX_WAIT | FUTEX_PRIVATE_FLAG),
  FUTEX_WAKE_PRIVATE=(FUTEX_WAKE | FUTEX_PRIVATE_FLAG),
  FUTEX_REQUEUE_PRIVATE=(FUTEX_REQUEUE | FUTEX_PRIVATE_FLAG),
  FUTEX_CMP_REQUEUE_PRIVATE=(FUTEX_CMP_REQUEUE | FUTEX_PRIVATE_FLAG),
  FUTEX_WAKE_OP_PRIVATE=(FUTEX_WAKE_OP | FUTEX_PRIVATE_FLAG),
  FUTEX_LOCK_PI_PRIVATE=(FUTEX_LOCK_PI | FUTEX_PRIVATE_FLAG),
  FUTEX_LOCK_PI2_PRIVATE=(FUTEX_LOCK_PI2 | FUTEX_PRIVATE_FLAG),
  FUTEX_UNLOCK_PI_PRIVATE=(FUTEX_UNLOCK_PI | FUTEX_PRIVATE_FLAG),
  FUTEX_TRYLOCK_PI_PRIVATE=(FUTEX_TRYLOCK_PI | FUTEX_PRIVATE_FLAG),
  FUTEX_WAIT_BITSET_PRIVATE=(FUTEX_WAIT_BITSET | FUTEX_PRIVATE_FLAG),
  FUTEX_WAKE_BITSET_PRIVATE=(FUTEX_WAKE_BITSET | FUTEX_PRIVATE_FLAG),
  FUTEX_WAIT_REQUEUE_PI_PRIVATE=(FUTEX_WAIT_REQUEUE_PI | FUTEX_PRIVATE_FLAG),
  FUTEX_CMP_REQUEUE_PI_PRIVATE=(FUTEX_CMP_REQUEUE_PI |  FUTEX_PRIVATE_FLAG),

  FUTEX2_SIZE_U8=0x00,
  FUTEX2_SIZE_U16=0x01,
  FUTEX2_SIZE_U32=0x02,
  FUTEX2_SIZE_U64=0x03,
  FUTEX2_NUMA=0x0,

  FUTEX2_PRIVATE=FUTEX_PRIVATE_FLAG,

  FUTEX2_SIZE_MASK=0x03,

  FUTEX_WAITV_MAX=128,

  FUTEX_BITSET_MATCH_ANY=-1,
};

long futex(int* uaddr,int op,int val,const struct timespec* timeout,int* uaddr2,int val3);

struct futex_waitv {
	uint64_t val;
	uint64_t uaddr;
	uint32_t flags;
	uint32_t __reserved;
};

long futex_waitv(struct futex_waitv *waiters, unsigned int nr_futexes,
            unsigned int flags, struct timespec *timeout, clockid_t clockid);

__END_DECLS

#endif
