// Copyright (c) Facebook, Inc. and its affiliates.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by `go generate`, DO NOT EDIT.

package schema

// VulnerabilitySearchResults struct
type VulnerabilitySearchResults struct {
	More      bool             `json:"more"`
	Page      int              `json:"page"`
	PageSize  int              `json:"page_size"`
	Results   []*Vulnerability `json:"results"`
	TotalSize int              `json:"total_size"`
}

// Vulnerability struct
type Vulnerability struct {
	AdvertisedBy                      *VulnerabilityAdvertisedBy     `json:"advertised_by"`
	Affects                           *VulnerabilityAffects          `json:"affects"`
	Alias                             []string                       `json:"alias"`
	AlsoIdentifies                    *VulnerabilityAlsoIdentifies   `json:"also_identifies"`
	Analysis                          string                         `json:"analysis"`
	ClassificationOfVulnerabilityType string                         `json:"classification_of_vulnerability_type"`
	CreatedOn                         string                         `json:"created_on"`
	Cvss2                             string                         `json:"cvss2"`
	Cvss2BaseScore                    float64                        `json:"cvss2_base_score"`
	Cvss2TemporalScore                float64                        `json:"cvss2_temporal_score"`
	Cvss3                             string                         `json:"cvss3"`
	Cvss3BaseScore                    float64                        `json:"cvss3_base_score"`
	Cvss3TemporalScore                float64                        `json:"cvss3_temporal_score"`
	Cwe                               string                         `json:"cwe"`
	Description                       string                         `json:"description"`
	Exclusive                         bool                           `json:"exclusive"`
	ExploitedBy                       *VulnerabilityExploitedBy      `json:"exploited_by"`
	FirstSeenActive                   string                         `json:"first_seen_active"`
	FixedBy                           *VulnerabilityFixedBy          `json:"fixed_by"`
	History                           []*VulnerabilityHistory        `json:"history"`
	IdentifiedBy                      *VulnerabilityIdentifiedBy     `json:"identified_by"`
	IndexTimestamp                    string                         `json:"index_timestamp"`
	Key                               string                         `json:"key"`
	LastModified                      string                         `json:"last_modified"`
	LastPublished                     string                         `json:"last_published"`
	MentionedBy                       []string                       `json:"mentioned_by"`
	Mitigation                        string                         `json:"mitigation"`
	NotableVuln                       bool                           `json:"notable_vuln"`
	NotableZeroDay                    bool                           `json:"notable_zero_day"`
	Pocs                              []*VulnerabilityProofOfConcept `json:"pocs"`
	Popularity                        int                            `json:"popularity"`
	ReplicationID                     int                            `json:"replication_id"`
	Severity                          int                            `json:"severity"`
	SourcesExternal                   []*VulnerabilitySource         `json:"sources_external"`
	ThreatTypes                       []string                       `json:"threat_types"`
	Title                             string                         `json:"title"`
	Translations                      *VulnerabilityTranslations     `json:"translations"`
	TranslationsFr                    *VulnerabilityTranslations     `json:"translations_fr"`
	TranslationsJa                    *VulnerabilityTranslations     `json:"translations_ja"`
	UUID                              string                         `json:"uuid"`
	VendorFixExternal                 []*VulnerabilityVendorAdvisory `json:"vendor_fix_external"`
	Workarounds                       []*VulnerabilityWorkaround     `json:"workarounds"`
	Wormable                          bool                           `json:"wormable"`
	ZeroDay                           bool                           `json:"zero_day"`
}

// VulnerabilityAdvertisedBy struct
type VulnerabilityAdvertisedBy struct {
	ThreatGroup []*VulnerabilityAdvertisedThreatGroup `json:"threat_group"`
}

// VulnerabilityAffects struct
type VulnerabilityAffects struct {
	Packages  []*VulnerabilityAffectedPackage  `json:"packages"`
	VulnTechs []*VulnerabilityAffectedVulnTech `json:"vuln_techs"`
}

// VulnerabilityAlsoIdentifies struct
type VulnerabilityAlsoIdentifies struct {
	Vulnerability []*VulnerabilityOtherVulnerability `json:"vulnerability"`
}

// VulnerabilityExploitedBy struct
type VulnerabilityExploitedBy struct {
	File          []string `json:"file"`
	MaliciousTool []string `json:"malicious_tool"`
	MalwareFamily []string `json:"malware_family"`
}

// VulnerabilityFixedBy struct
type VulnerabilityFixedBy struct {
	Packages  []*VulnerabilityPatchedPackage  `json:"packages"`
	VulnTechs []*VulnerabilityPatchedVulnTech `json:"vuln_techs"`
}

// VulnerabilityHistory struct
type VulnerabilityHistory struct {
	Comment           string   `json:"comment"`
	Timestamp         string   `json:"timestamp"`
	UpdatedProperties []string `json:"updated_properties"`
}

// VulnerabilityIdentifiedBy struct
type VulnerabilityIdentifiedBy struct {
	DetectionSignature []string `json:"detection_signature"`
}

// VulnerabilityProofOfConcept struct
type VulnerabilityProofOfConcept struct {
	Datetime    string `json:"datetime"`
	Description string `json:"description"`
	PocAuthor   string `json:"poc_author"`
	PocName     string `json:"poc_name"`
	URL         string `json:"url"`
}

// VulnerabilitySource struct
type VulnerabilitySource struct {
	Datetime    string `json:"datetime"`
	Description string `json:"description"`
	Name        string `json:"name"`
	Reputation  int    `json:"reputation"`
	URL         string `json:"url"`
}

// VulnerabilityTranslations struct
type VulnerabilityTranslations struct {
	Analysis            string                             `json:"analysis"`
	Description         string                             `json:"description"`
	LastModified        string                             `json:"last_modified"`
	Mitigation          string                             `json:"mitigation"`
	ReplicationID       int                                `json:"replication_id"`
	Title               string                             `json:"title"`
	TranslatedTimestamp string                             `json:"translated_timestamp"`
	TranslationHistory  []*VulnerabilityTranslationHistory `json:"translation_history"`
}

// VulnerabilityVendorAdvisory struct
type VulnerabilityVendorAdvisory struct {
	Datetime string `json:"datetime"`
	ID       string `json:"id"`
	URL      string `json:"url"`
}

// VulnerabilityWorkaround struct
type VulnerabilityWorkaround struct {
	Comment      string `json:"comment"`
	URLReference string `json:"url_reference"`
}

// VulnerabilityAdvertisedThreatGroup struct
type VulnerabilityAdvertisedThreatGroup struct {
	CreatedOn    string   `json:"created_on"`
	Key          string   `json:"key"`
	LastModified string   `json:"last_modified"`
	ThreatTypes  []string `json:"threat_types"`
	UUID         string   `json:"uuid"`
}

// VulnerabilityAffectedPackage struct
type VulnerabilityAffectedPackage struct {
	AndPriorVersions bool   `json:"and_prior_versions"`
	Architecture     string `json:"architecture"`
	CreatedOn        string `json:"created_on"`
	Key              string `json:"key"`
	LastModified     string `json:"last_modified"`
	PackageName      string `json:"package_name"`
	PackageSecurity  bool   `json:"package_security"`
	PackageType      string `json:"package_type"`
	PackageVersion   string `json:"package_version"`
	UUID             string `json:"uuid"`
}

// VulnerabilityAffectedVulnTech struct
type VulnerabilityAffectedVulnTech struct {
	Alias            []string `json:"alias"`
	AndPriorVersions bool     `json:"and_prior_versions"`
	Category         []string `json:"category"`
	CpeInDictionary  bool     `json:"cpe_in_dictionary"`
	CreatedOn        string   `json:"created_on"`
	Description      string   `json:"description"`
	DisplayName      string   `json:"display_name"`
	Edition          string   `json:"edition"`
	Key              string   `json:"key"`
	Language         string   `json:"language"`
	LastModified     string   `json:"last_modified"`
	Part             string   `json:"part"`
	Product          string   `json:"product"`
	Update           string   `json:"update"`
	UUID             string   `json:"uuid"`
	Vendor           string   `json:"vendor"`
	Version          string   `json:"version"`
}

// VulnerabilityOtherVulnerability struct
type VulnerabilityOtherVulnerability struct {
	CreatedOn    string   `json:"created_on"`
	Key          string   `json:"key"`
	LastModified string   `json:"last_modified"`
	ThreatTypes  []string `json:"threat_types"`
	UUID         string   `json:"uuid"`
}

// VulnerabilityPatchedPackage struct
type VulnerabilityPatchedPackage struct {
	Architecture    string                `json:"architecture"`
	CreatedOn       string                `json:"created_on"`
	Key             string                `json:"key"`
	LastModified    string                `json:"last_modified"`
	PackageName     string                `json:"package_name"`
	PackageSecurity bool                  `json:"package_security"`
	PackageType     string                `json:"package_type"`
	PackageVersion  string                `json:"package_version"`
	Patches         []*VulnerabilityPatch `json:"patches"`
	UUID            string                `json:"uuid"`
}

// VulnerabilityPatchedVulnTech struct
type VulnerabilityPatchedVulnTech struct {
	Alias           []string              `json:"alias"`
	Category        []string              `json:"category"`
	CpeInDictionary bool                  `json:"cpe_in_dictionary"`
	CreatedOn       string                `json:"created_on"`
	Description     string                `json:"description"`
	DisplayName     string                `json:"display_name"`
	Edition         string                `json:"edition"`
	Key             string                `json:"key"`
	Language        string                `json:"language"`
	LastModified    string                `json:"last_modified"`
	Part            string                `json:"part"`
	Patches         []*VulnerabilityPatch `json:"patches"`
	Product         string                `json:"product"`
	Update          string                `json:"update"`
	UUID            string                `json:"uuid"`
	Vendor          string                `json:"vendor"`
	Version         string                `json:"version"`
}

// VulnerabilityTranslationHistory struct
type VulnerabilityTranslationHistory struct {
	Comment           string   `json:"comment"`
	Timestamp         string   `json:"timestamp"`
	UpdatedProperties []string `json:"updated_properties"`
}

// VulnerabilityPatch struct
type VulnerabilityPatch struct {
	ID  string `json:"id"`
	URL string `json:"url"`
}
