# Development Report for May 22, 2017

### New feature: Long running session

PR for [adding long-running session between daemon and cli](https://github.com/moby/moby/pull/32677) that enables advanced features like incremental context send, build credentials from the client, ssh forwarding etc. is ready for reviews. This is blocking many new features like token signing, not pulling unnecessary context files, exposing sources outside working directory etc.


### Quality: Dependency interface switch

Work continues on making the builder dependency interface more stable.

Merged as part of this effort this week:

- [Refactor COPY/ADD dispatchers](https://github.com/moby/moby/pull/33116)

In review:
- [Refactor builder probe cache and container backend](https://github.com/moby/moby/pull/33061)

### Buildkit

[Diff and snapshot services](https://github.com/containerd/containerd/pull/849) were added to containerd. This is a required dependency for [buildkit](https://github.com/moby/moby/issues/32925).

### Proposals discussed in maintainers meeting

New builder proposals were discussed in maintainers meeting. The decision was to give 2 more weeks for anyone to post feedback to [IMPORT/EXPORT commands](https://github.com/moby/moby/issues/32100) and [`RUN --mount`](https://github.com/moby/moby/issues/32507) and accept them for development if nothing significant comes up.

Build secrets and its possible overlap with [--mount](https://github.com/moby/moby/issues/32507) was discussed as well. The decision was to create a [new issue](https://github.com/moby/moby/issues/33343)(as the [old PR](https://github.com/moby/moby/pull/30637) is closed) to track this and avoid it from blocking `--mount` implementation. 

### Proposals for new Dockerfile features that need design feedback:

[Add IMPORT/EXPORT commands to Dockerfile](https://github.com/moby/moby/issues/32100)

[Add `DOCKEROS/DOCKERARCH` default ARG to Dockerfile](https://github.com/moby/moby/issues/32487)

[Add support for `RUN --mount`](https://github.com/moby/moby/issues/32507)

[DAG image builder](https://github.com/moby/moby/issues/32550)

[Option to export the hash of the build context](https://github.com/moby/moby/issues/32963) (new)

[Allow --cache-from=*](https://github.com/moby/moby/issues/33002#issuecomment-299041162) (new)

If you are interested in implementing any of them, leave a comment on the specific issues.

### Other new builder features currently in code-review:

-
