/*
 * SPDX-FileCopyrightText: 2013-2025 Mattia Basaglia
 * SPDX-License-Identifier: LGPL-3.0-or-later
 */

#ifndef HUE_SLIDER_PLUGIN_HPP
#define HUE_SLIDER_PLUGIN_HPP

#include <QtUiPlugin/QDesignerCustomWidgetInterface>

class HueSlider_Plugin : public QObject, public QDesignerCustomWidgetInterface
{
    Q_OBJECT
    Q_INTERFACES(QDesignerCustomWidgetInterface)

public:
    HueSlider_Plugin(QObject *parent = nullptr);

    void initialize(QDesignerFormEditorInterface *core);
    bool isInitialized() const;

    QWidget *createWidget(QWidget *parent);

    QString name() const;
    QString group() const;
    QIcon icon() const;
    QString toolTip() const;
    QString whatsThis() const;
    bool isContainer() const;

    QString domXml() const;

    QString includeFile() const;

private:
    bool initialized;
};

#endif // HUE_SLIDER_PLUGIN_HPP
