// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// REQUIRES: amdgpu-registered-target
// RUN: %clang_cc1 -cl-std=CL2.0 -triple amdgcn-unknown-unknown -target-cpu gfx1250 -emit-llvm -o - %s | FileCheck %s --check-prefix=CHECK-GFX1250

typedef int    v2i   __attribute__((ext_vector_type(2)));
typedef int    v4i   __attribute__((ext_vector_type(4)));

// CHECK-GFX1250-LABEL: @test_amdgcn_cluster_load_b32(
// CHECK-GFX1250-NEXT:  entry:
// CHECK-GFX1250-NEXT:    [[TMP0:%.*]] = tail call i32 @llvm.amdgcn.cluster.load.b32.i32(ptr addrspace(1) [[INPTR:%.*]], i32 10, i32 [[MASK:%.*]])
// CHECK-GFX1250-NEXT:    ret i32 [[TMP0]]
//
int test_amdgcn_cluster_load_b32(global int* inptr, int mask)
{
  return __builtin_amdgcn_cluster_load_b32(inptr, 10, mask);
}

// CHECK-GFX1250-LABEL: @test_amdgcn_cluster_load_b64(
// CHECK-GFX1250-NEXT:  entry:
// CHECK-GFX1250-NEXT:    [[TMP0:%.*]] = tail call <2 x i32> @llvm.amdgcn.cluster.load.b64.v2i32(ptr addrspace(1) [[INPTR:%.*]], i32 22, i32 [[MASK:%.*]])
// CHECK-GFX1250-NEXT:    ret <2 x i32> [[TMP0]]
//
v2i test_amdgcn_cluster_load_b64(global v2i* inptr, int mask)
{
  return __builtin_amdgcn_cluster_load_b64(inptr, 22, mask);
}

// CHECK-GFX1250-LABEL: @test_amdgcn_cluster_load_b128(
// CHECK-GFX1250-NEXT:  entry:
// CHECK-GFX1250-NEXT:    [[TMP0:%.*]] = tail call <4 x i32> @llvm.amdgcn.cluster.load.b128.v4i32(ptr addrspace(1) [[INPTR:%.*]], i32 27, i32 [[MASK:%.*]])
// CHECK-GFX1250-NEXT:    ret <4 x i32> [[TMP0]]
//
v4i test_amdgcn_cluster_load_b128(global v4i* inptr, int mask)
{
  return __builtin_amdgcn_cluster_load_b128(inptr, 27, mask);
}
