// Package media provides the Chrome DevTools Protocol
// commands, types, and events for the Media domain.
//
// This domain allows detailed inspection of media elements.
//
// Generated by the cdproto-gen command.
package media

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EnableParams enables the Media domain.
type EnableParams struct{}

// Enable enables the Media domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#method-enable
func Enable() *EnableParams {
	return &EnableParams{}
}

// Do executes Media.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, nil, nil)
}

// DisableParams disables the Media domain.
type DisableParams struct{}

// Disable disables the Media domain.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Media#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes Media.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// Command names.
const (
	CommandEnable  = "Media.enable"
	CommandDisable = "Media.disable"
)
