/*
 * msstyle data maps
 *
 * Copyright (C) 2004 Kevin Koltzau
 * Copyright 2021-2022 Zhiyi Zhang for CodeWeavers
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include <stdarg.h>
#include <stdlib.h>

#include "windef.h"
#include "winbase.h"
#include "winnls.h"
#include "winuser.h"
#include "vssym32.h"

#define TMT_ENUM 200
#define TMT_STOCKIMAGEFILE 3007

typedef struct _MSSTYLES_PROPERTY_MAP {
    WCHAR szPropertyName[24];
    WORD dwPrimitiveType;
    WORD dwPropertyID;
} MSSTYLES_PROPERTY_MAP, *PMSSTYLES_PROPERTY_MAP;

typedef struct _MSSTYLES_ENUM_MAP {
    WORD dwEnum;
    WORD dwValue;
    WCHAR szValueName[18];
} MSSTYLES_ENUM_MAP, *PMSSTYLES_ENUM_MAP;

typedef struct _MSSTYLES_CLASS_MAP {
    WORD dwPartID;
    WORD dwStateID;
    WCHAR szName[31];
} MSSTYLES_CLASS_MAP, *PMSSTYLES_CLASS_MAP;

typedef struct _MSSTYLES_CLASS_NAME {
    const MSSTYLES_CLASS_MAP *lpMap;
    WCHAR pszClass[12];
} MSSTYLES_CLASS_NAME, *PMSSTYLES_CLASS_NAME;

/***********************************************************************
 * Map property names to IDs & primitive types
 * PrimitiveType,PropertyID,PropertyName
 *
 * NOTE: Keep this sorted, we use bsearch to lookup properties.
 */
static const MSSTYLES_PROPERTY_MAP mapProperty[] = {
    {L"ACCENTCOLORHINT", TMT_COLOR, TMT_ACCENTCOLORHINT},
    {L"ACTIVEBORDER", TMT_COLOR, TMT_ACTIVEBORDER},
    {L"ACTIVECAPTION", TMT_COLOR, TMT_ACTIVECAPTION},
    {L"ALPHALEVEL", TMT_INT, TMT_ALPHALEVEL},
    {L"ALPHATHRESHOLD", TMT_INT, TMT_ALPHATHRESHOLD},
    {L"ALWAYSSHOWSIZINGBAR", TMT_BOOL, TMT_ALWAYSSHOWSIZINGBAR},
    {L"APPWORKSPACE", TMT_COLOR, TMT_APPWORKSPACE},
    {L"AUTHOR", TMT_STRING, TMT_AUTHOR},
    {L"AUTOSIZE", TMT_BOOL, TMT_AUTOSIZE},
    {L"BACKGROUND", TMT_COLOR, TMT_BACKGROUND},
    {L"BGFILL", TMT_BOOL, TMT_BGFILL},
    {L"BGTYPE", TMT_ENUM, TMT_BGTYPE},
    {L"BLENDCOLOR", TMT_COLOR, TMT_BLENDCOLOR},
    {L"BODYFONT", TMT_FONT, TMT_BODYFONT},
    {L"BOOL", TMT_BOOL, TMT_BOOL},
    {L"BORDERCOLOR", TMT_COLOR, TMT_BORDERCOLOR},
    {L"BORDERCOLORHINT", TMT_COLOR, TMT_BORDERCOLORHINT},
    {L"BORDERONLY", TMT_BOOL, TMT_BORDERONLY},
    {L"BORDERSIZE", TMT_INT, TMT_BORDERSIZE},
    {L"BORDERTYPE", TMT_ENUM, TMT_BORDERTYPE},
    {L"BTNFACE", TMT_COLOR, TMT_BTNFACE},
    {L"BTNHIGHLIGHT", TMT_COLOR, TMT_BTNHIGHLIGHT},
    {L"BTNSHADOW", TMT_COLOR, TMT_BTNSHADOW},
    {L"BTNTEXT", TMT_COLOR, TMT_BTNTEXT},
    {L"BUTTONALTERNATEFACE", TMT_COLOR, TMT_BUTTONALTERNATEFACE},
    {L"CAPTIONBARHEIGHT", TMT_SIZE, TMT_CAPTIONBARHEIGHT},
    {L"CAPTIONBARWIDTH", TMT_SIZE, TMT_CAPTIONBARWIDTH},
    {L"CAPTIONFONT", TMT_FONT, TMT_CAPTIONFONT},
    {L"CAPTIONMARGINS", TMT_MARGINS, TMT_CAPTIONMARGINS},
    {L"CAPTIONTEXT", TMT_COLOR, TMT_CAPTIONTEXT},
    {L"CHARSET", TMT_INT, TMT_CHARSET},
    {L"COLOR", TMT_COLOR, TMT_COLOR},
    {L"COLORSCHEMES", TMT_STRING, TMT_COLORSCHEMES},
    {L"COMPANY", TMT_STRING, TMT_COMPANY},
    {L"COMPOSITED", TMT_BOOL, TMT_COMPOSITED},
    {L"CONTENTALIGNMENT", TMT_ENUM, TMT_CONTENTALIGNMENT},
    {L"CONTENTMARGINS", TMT_MARGINS, TMT_CONTENTMARGINS},
    {L"COPYRIGHT", TMT_STRING, TMT_COPYRIGHT},
    {L"CSSNAME", TMT_STRING, TMT_CSSNAME},
    {L"DEFAULTPANESIZE", TMT_RECT, TMT_DEFAULTPANESIZE},
    {L"DESCRIPTION", TMT_STRING, TMT_DESCRIPTION},
    {L"DISPLAYNAME", TMT_STRING, TMT_DISPLAYNAME},
    {L"DKSHADOW3D", TMT_COLOR, TMT_DKSHADOW3D},
    {L"EDGEDKSHADOWCOLOR", TMT_COLOR, TMT_EDGEDKSHADOWCOLOR},
    {L"EDGEFILLCOLOR", TMT_COLOR, TMT_EDGEFILLCOLOR},
    {L"EDGEHIGHLIGHTCOLOR", TMT_COLOR, TMT_EDGEHIGHLIGHTCOLOR},
    {L"EDGELIGHTCOLOR", TMT_COLOR, TMT_EDGELIGHTCOLOR},
    {L"EDGESHADOWCOLOR", TMT_COLOR, TMT_EDGESHADOWCOLOR},
    {L"FILENAME", TMT_FILENAME, TMT_FILENAME},
    {L"FILLCOLOR", TMT_COLOR, TMT_FILLCOLOR},
    {L"FILLCOLORHINT", TMT_COLOR, TMT_FILLCOLORHINT},
    {L"FILLTYPE", TMT_ENUM, TMT_FILLTYPE},
    {L"FLATMENUS", TMT_BOOL, TMT_FLATMENUS},
    {L"FONT", TMT_FONT, TMT_FONT},
    {L"FROMCOLOR1", TMT_COLOR, TMT_FROMCOLOR1},
    {L"FROMCOLOR2", TMT_COLOR, TMT_FROMCOLOR2},
    {L"FROMCOLOR3", TMT_COLOR, TMT_FROMCOLOR3},
    {L"FROMCOLOR4", TMT_COLOR, TMT_FROMCOLOR4},
    {L"FROMCOLOR5", TMT_COLOR, TMT_FROMCOLOR5},
    {L"FROMHUE1", TMT_INT, TMT_FROMHUE1},
    {L"FROMHUE2", TMT_INT, TMT_FROMHUE2},
    {L"FROMHUE3", TMT_INT, TMT_FROMHUE3},
    {L"FROMHUE4", TMT_INT, TMT_FROMHUE4},
    {L"FROMHUE5", TMT_INT, TMT_FROMHUE5},
    {L"GLOWCOLOR", TMT_COLOR, TMT_GLOWCOLOR},
    {L"GLYPHFONT", TMT_FONT, TMT_GLYPHFONT},
    {L"GLYPHFONTSIZINGTYPE", TMT_ENUM, TMT_GLYPHFONTSIZINGTYPE},
    {L"GLYPHIMAGEFILE", TMT_FILENAME, TMT_GLYPHIMAGEFILE},
    {L"GLYPHINDEX", TMT_INT, TMT_GLYPHINDEX},
    {L"GLYPHONLY", TMT_BOOL, TMT_GLYPHONLY},
    {L"GLYPHTEXTCOLOR", TMT_COLOR, TMT_GLYPHTEXTCOLOR},
    {L"GLYPHTRANSPARENT", TMT_BOOL, TMT_GLYPHTRANSPARENT},
    {L"GLYPHTRANSPARENTCOLOR", TMT_COLOR, TMT_GLYPHTRANSPARENTCOLOR},
    {L"GLYPHTYPE", TMT_ENUM, TMT_GLYPHTYPE},
    {L"GRADIENTACTIVECAPTION", TMT_COLOR, TMT_GRADIENTACTIVECAPTION},
    {L"GRADIENTCOLOR1", TMT_COLOR, TMT_GRADIENTCOLOR1},
    {L"GRADIENTCOLOR2", TMT_COLOR, TMT_GRADIENTCOLOR2},
    {L"GRADIENTCOLOR3", TMT_COLOR, TMT_GRADIENTCOLOR3},
    {L"GRADIENTCOLOR4", TMT_COLOR, TMT_GRADIENTCOLOR4},
    {L"GRADIENTCOLOR5", TMT_COLOR, TMT_GRADIENTCOLOR5},
    {L"GRADIENTINACTIVECAPTION", TMT_COLOR, TMT_GRADIENTINACTIVECAPTION},
    {L"GRADIENTRATIO1", TMT_INT, TMT_GRADIENTRATIO1},
    {L"GRADIENTRATIO2", TMT_INT, TMT_GRADIENTRATIO2},
    {L"GRADIENTRATIO3", TMT_INT, TMT_GRADIENTRATIO3},
    {L"GRADIENTRATIO4", TMT_INT, TMT_GRADIENTRATIO4},
    {L"GRADIENTRATIO5", TMT_INT, TMT_GRADIENTRATIO5},
    {L"GRAYTEXT", TMT_COLOR, TMT_GRAYTEXT},
    {L"HALIGN", TMT_ENUM, TMT_HALIGN},
    {L"HEADING1FONT", TMT_FONT, TMT_HEADING1FONT},
    {L"HEADING2FONT", TMT_FONT, TMT_HEADING2FONT},
    {L"HEIGHT", TMT_SIZE, TMT_HEIGHT},
    {L"HIGHLIGHT", TMT_COLOR, TMT_HIGHLIGHT},
    {L"HIGHLIGHTTEXT", TMT_COLOR, TMT_HIGHLIGHTTEXT},
    {L"HOTTRACKING", TMT_COLOR, TMT_HOTTRACKING},
    {L"ICONEFFECT", TMT_ENUM, TMT_ICONEFFECT},
    {L"ICONTITLEFONT", TMT_FONT, TMT_ICONTITLEFONT},
    {L"IMAGECOUNT", TMT_INT, TMT_IMAGECOUNT},
    {L"IMAGEFILE", TMT_FILENAME, TMT_IMAGEFILE},
    {L"IMAGEFILE1", TMT_FILENAME, TMT_IMAGEFILE1},
    {L"IMAGEFILE2", TMT_FILENAME, TMT_IMAGEFILE2},
    {L"IMAGEFILE3", TMT_FILENAME, TMT_IMAGEFILE3},
    {L"IMAGEFILE4", TMT_FILENAME, TMT_IMAGEFILE4},
    {L"IMAGEFILE5", TMT_FILENAME, TMT_IMAGEFILE5},
    {L"IMAGEFILE6", TMT_FILENAME, TMT_IMAGEFILE6},
    {L"IMAGEFILE7", TMT_FILENAME, TMT_IMAGEFILE7},
    {L"IMAGELAYOUT", TMT_ENUM, TMT_IMAGELAYOUT},
    {L"IMAGESELECTTYPE", TMT_ENUM, TMT_IMAGESELECTTYPE},
    {L"INACTIVEBORDER", TMT_COLOR, TMT_INACTIVEBORDER},
    {L"INACTIVECAPTION", TMT_COLOR, TMT_INACTIVECAPTION},
    {L"INACTIVECAPTIONTEXT", TMT_COLOR, TMT_INACTIVECAPTIONTEXT},
    {L"INFOBK", TMT_COLOR, TMT_INFOBK},
    {L"INFOTEXT", TMT_COLOR, TMT_INFOTEXT},
    {L"INT", TMT_INT, TMT_INT},
    {L"INTEGRALSIZING", TMT_BOOL, TMT_INTEGRALSIZING},
    {L"INTLIST", TMT_INTLIST, TMT_INTLIST},
    {L"LIGHT3D", TMT_COLOR, TMT_LIGHT3D},
    {L"MARGINS", TMT_MARGINS, TMT_MARGINS},
    {L"MENU", TMT_COLOR, TMT_MENU},
    {L"MENUBAR", TMT_COLOR, TMT_MENUBAR},
    {L"MENUBARHEIGHT", TMT_SIZE, TMT_MENUBARHEIGHT},
    {L"MENUBARWIDTH", TMT_SIZE, TMT_MENUBARWIDTH},
    {L"MENUFONT", TMT_FONT, TMT_MENUFONT},
    {L"MENUHILIGHT", TMT_COLOR, TMT_MENUHILIGHT},
    {L"MENUTEXT", TMT_COLOR, TMT_MENUTEXT},
    {L"MINCOLORDEPTH", TMT_INT, TMT_MINCOLORDEPTH},
    {L"MINDPI1", TMT_INT, TMT_MINDPI1},
    {L"MINDPI2", TMT_INT, TMT_MINDPI2},
    {L"MINDPI3", TMT_INT, TMT_MINDPI3},
    {L"MINDPI4", TMT_INT, TMT_MINDPI4},
    {L"MINDPI5", TMT_INT, TMT_MINDPI5},
    {L"MINDPI6", TMT_INT, TMT_MINDPI6},
    {L"MINDPI7", TMT_INT, TMT_MINDPI7},
    {L"MINSIZE", TMT_POSITION, TMT_MINSIZE},
    {L"MINSIZE1", TMT_POSITION, TMT_MINSIZE1},
    {L"MINSIZE2", TMT_POSITION, TMT_MINSIZE2},
    {L"MINSIZE3", TMT_POSITION, TMT_MINSIZE3},
    {L"MINSIZE4", TMT_POSITION, TMT_MINSIZE4},
    {L"MINSIZE5", TMT_POSITION, TMT_MINSIZE5},
    {L"MINSIZE6", TMT_POSITION, TMT_MINSIZE6},
    {L"MINSIZE7", TMT_POSITION, TMT_MINSIZE7},
    {L"MIRRORIMAGE", TMT_BOOL, TMT_MIRRORIMAGE},
    {L"MSGBOXFONT", TMT_FONT, TMT_MSGBOXFONT},
    {L"NORMALSIZE", TMT_POSITION, TMT_NORMALSIZE},
    {L"OFFSET", TMT_POSITION, TMT_OFFSET},
    {L"OFFSETTYPE", TMT_ENUM, TMT_OFFSETTYPE},
    {L"POSITION", TMT_POSITION, TMT_POSITION},
    {L"PROGRESSCHUNKSIZE", TMT_INT, TMT_PROGRESSCHUNKSIZE},
    {L"PROGRESSSPACESIZE", TMT_INT, TMT_PROGRESSSPACESIZE},
    {L"RECT", TMT_RECT, TMT_RECT},
    {L"ROUNDCORNERHEIGHT", TMT_INT, TMT_ROUNDCORNERHEIGHT},
    {L"ROUNDCORNERWIDTH", TMT_INT, TMT_ROUNDCORNERWIDTH},
    {L"SATURATION", TMT_INT, TMT_SATURATION},
    {L"SCROLLBAR", TMT_COLOR, TMT_SCROLLBAR},
    {L"SCROLLBARHEIGHT", TMT_SIZE, TMT_SCROLLBARHEIGHT},
    {L"SCROLLBARWIDTH", TMT_SIZE, TMT_SCROLLBARWIDTH},
    {L"SHADOWCOLOR", TMT_COLOR, TMT_SHADOWCOLOR},
    {L"SIZE", TMT_SIZE, TMT_SIZE},
    {L"SIZES", TMT_STRING, TMT_SIZES},
    {L"SIZINGBORDERWIDTH", TMT_SIZE, TMT_SIZINGBORDERWIDTH},
    {L"SIZINGMARGINS", TMT_MARGINS, TMT_SIZINGMARGINS},
    {L"SIZINGTYPE", TMT_ENUM, TMT_SIZINGTYPE},
    {L"SMALLCAPTIONFONT", TMT_FONT, TMT_SMALLCAPTIONFONT},
    {L"SMCAPTIONBARHEIGHT", TMT_SIZE, TMT_SMCAPTIONBARHEIGHT},
    {L"SMCAPTIONBARWIDTH", TMT_SIZE, TMT_SMCAPTIONBARWIDTH},
    {L"SOURCEGROW", TMT_BOOL, TMT_SOURCEGROW},
    {L"SOURCESHRINK", TMT_BOOL, TMT_SOURCESHRINK},
    {L"STATUSFONT", TMT_FONT, TMT_STATUSFONT},
    {L"STOCKIMAGEFILE", TMT_FILENAME, TMT_STOCKIMAGEFILE},
    {L"STRING", TMT_STRING, TMT_STRING},
    {L"TEXT", TMT_STRING, TMT_TEXT},
    {L"TEXTBORDERCOLOR", TMT_COLOR, TMT_TEXTBORDERCOLOR},
    {L"TEXTBORDERSIZE", TMT_INT, TMT_TEXTBORDERSIZE},
    {L"TEXTCOLOR", TMT_COLOR, TMT_TEXTCOLOR},
    {L"TEXTSHADOWCOLOR", TMT_COLOR, TMT_TEXTSHADOWCOLOR},
    {L"TEXTSHADOWOFFSET", TMT_POSITION, TMT_TEXTSHADOWOFFSET},
    {L"TEXTSHADOWTYPE", TMT_ENUM, TMT_TEXTSHADOWTYPE},
    {L"TOCOLOR1", TMT_COLOR, TMT_TOCOLOR1},
    {L"TOCOLOR2", TMT_COLOR, TMT_TOCOLOR2},
    {L"TOCOLOR3", TMT_COLOR, TMT_TOCOLOR3},
    {L"TOCOLOR4", TMT_COLOR, TMT_TOCOLOR4},
    {L"TOCOLOR5", TMT_COLOR, TMT_TOCOLOR5},
    {L"TOHUE1", TMT_INT, TMT_TOHUE1},
    {L"TOHUE2", TMT_INT, TMT_TOHUE2},
    {L"TOHUE3", TMT_INT, TMT_TOHUE3},
    {L"TOHUE4", TMT_INT, TMT_TOHUE4},
    {L"TOHUE5", TMT_INT, TMT_TOHUE5},
    {L"TOOLTIP", TMT_STRING, TMT_TOOLTIP},
    {L"TRANSITIONDURATIONS", TMT_INTLIST, TMT_TRANSITIONDURATIONS},
    {L"TRANSPARENT", TMT_BOOL, TMT_TRANSPARENT},
    {L"TRANSPARENTCOLOR", TMT_COLOR, TMT_TRANSPARENTCOLOR},
    {L"TRUESIZESCALINGTYPE", TMT_ENUM, TMT_TRUESIZESCALINGTYPE},
    {L"TRUESIZESTRETCHMARK", TMT_INT, TMT_TRUESIZESTRETCHMARK},
    {L"UNIFORMSIZING", TMT_BOOL, TMT_UNIFORMSIZING},
    {L"URL", TMT_STRING, TMT_URL},
    {L"USERPICTURE", TMT_BOOL, TMT_USERPICTURE},
    {L"VALIGN", TMT_ENUM, TMT_VALIGN},
    {L"VERSION", TMT_STRING, TMT_VERSION},
    {L"WIDTH", TMT_SIZE, TMT_WIDTH},
    {L"WINDOW", TMT_COLOR, TMT_WINDOW},
    {L"WINDOWFRAME", TMT_COLOR, TMT_WINDOWFRAME},
    {L"WINDOWTEXT", TMT_COLOR, TMT_WINDOWTEXT},
    {L"XMLNAME", TMT_STRING, TMT_XMLNAME},
};

/***********************************************************************
 * Map strings to enumeration values
 * Enum,Value,ValueName
 */
static const MSSTYLES_ENUM_MAP mapEnum[] = {
    {TMT_BGTYPE, BT_IMAGEFILE, L"IMAGEFILE"},
    {TMT_BGTYPE, BT_BORDERFILL, L"BORDERFILL"},
    {TMT_BGTYPE, BT_NONE, L"NONE"},
    {TMT_IMAGELAYOUT, IL_VERTICAL, L"VERTICAL"},
    {TMT_IMAGELAYOUT, IL_HORIZONTAL, L"HORIZONTAL"},
    {TMT_BORDERTYPE, BT_RECT, L"RECT"},
    {TMT_BORDERTYPE, BT_ROUNDRECT, L"ROUNDRECT"},
    {TMT_BORDERTYPE, BT_ELLIPSE, L"ELLIPSE"},
    {TMT_FILLTYPE, FT_SOLID, L"SOLID"},
    {TMT_FILLTYPE, FT_VERTGRADIENT, L"VERTGRADIENT"},
    {TMT_FILLTYPE, FT_HORZGRADIENT, L"HORZGRADIENT"},
    {TMT_FILLTYPE, FT_RADIALGRADIENT, L"RADIALGRADIENT"},
    {TMT_FILLTYPE, FT_TILEIMAGE, L"TILEIMAGE"},
    {TMT_SIZINGTYPE, ST_TRUESIZE, L"TRUESIZE"},
    {TMT_SIZINGTYPE, ST_STRETCH, L"STRETCH"},
    {TMT_SIZINGTYPE, ST_TILE, L"TILE"},
    {TMT_HALIGN, HA_LEFT, L"LEFT"},
    {TMT_HALIGN, HA_CENTER, L"CENTER"},
    {TMT_HALIGN, HA_RIGHT, L"RIGHT"},
    {TMT_CONTENTALIGNMENT, CA_LEFT, L"LEFT"},
    {TMT_CONTENTALIGNMENT, CA_CENTER, L"CENTER"},
    {TMT_CONTENTALIGNMENT, CA_RIGHT, L"RIGHT"},
    {TMT_VALIGN, VA_TOP, L"TOP"},
    {TMT_VALIGN, VA_CENTER, L"CENTER"},
    {TMT_VALIGN, VA_BOTTOM, L"BOTTOM"},
    {TMT_OFFSETTYPE, OT_TOPLEFT, L"TOPLEFT"},
    {TMT_OFFSETTYPE, OT_TOPRIGHT, L"TOPRIGHT"},
    {TMT_OFFSETTYPE, OT_TOPMIDDLE, L"TOPMIDDLE"},
    {TMT_OFFSETTYPE, OT_BOTTOMLEFT, L"BOTTOMLEFT"},
    {TMT_OFFSETTYPE, OT_BOTTOMRIGHT, L"BOTTOMRIGHT"},
    {TMT_OFFSETTYPE, OT_BOTTOMMIDDLE, L"BOTTOMMIDDLE"},
    {TMT_OFFSETTYPE, OT_MIDDLELEFT, L"MIDDLELEFT"},
    {TMT_OFFSETTYPE, OT_MIDDLERIGHT, L"MIDDLERIGHT"},
    {TMT_OFFSETTYPE, OT_LEFTOFCAPTION, L"LEFTOFCAPTION"},
    {TMT_OFFSETTYPE, OT_RIGHTOFCAPTION, L"RIGHTOFCAPTION"},
    {TMT_OFFSETTYPE, OT_LEFTOFLASTBUTTON, L"LEFTOFLASTBUTTON"},
    {TMT_OFFSETTYPE, OT_RIGHTOFLASTBUTTON, L"RIGHTOFLASTBUTTON"},
    {TMT_OFFSETTYPE, OT_ABOVELASTBUTTON, L"ABOVELASTBUTTON"},
    {TMT_OFFSETTYPE, OT_BELOWLASTBUTTON, L"BELOWLASTBUTTON"},
    {TMT_ICONEFFECT, ICE_NONE, L"NONE"},
    {TMT_ICONEFFECT, ICE_GLOW, L"GLOW"},
    {TMT_ICONEFFECT, ICE_SHADOW, L"SHADOW"},
    {TMT_ICONEFFECT, ICE_PULSE, L"PULSE"},
    {TMT_ICONEFFECT, ICE_ALPHA, L"ALPHA"},
    {TMT_TEXTSHADOWTYPE, TST_NONE, L"NONE"},
    {TMT_TEXTSHADOWTYPE, TST_SINGLE, L"SINGLE"},
    {TMT_TEXTSHADOWTYPE, TST_CONTINUOUS, L"CONTINUOUS"},
    {TMT_GLYPHTYPE, GT_NONE, L"NONE"},
    {TMT_GLYPHTYPE, GT_IMAGEGLYPH, L"IMAGEGLYPH"},
    {TMT_GLYPHTYPE, GT_FONTGLYPH, L"FONTGLYPH"},
    {TMT_IMAGESELECTTYPE, IST_NONE, L"NONE"},
    {TMT_IMAGESELECTTYPE, IST_SIZE, L"SIZE"},
    {TMT_IMAGESELECTTYPE, IST_DPI, L"DPI"},
    {TMT_TRUESIZESCALINGTYPE, TSST_NONE, L"NONE"},
    {TMT_TRUESIZESCALINGTYPE, TSST_SIZE, L"SIZE"},
    {TMT_TRUESIZESCALINGTYPE, TSST_DPI, L"DPI"},
    {TMT_GLYPHFONTSIZINGTYPE, GFST_NONE, L"NONE"},
    {TMT_GLYPHFONTSIZINGTYPE, GFST_SIZE, L"SIZE"},
    {TMT_GLYPHFONTSIZINGTYPE, GFST_DPI, L"DPI"},
    {0, 0, L""}
};


/***********************************************************************
 * Classes defined below
 * Defined as PartID,StateID,TextName
 * If StateID == 0 then its a part being defined
 */
static const MSSTYLES_CLASS_MAP classButton[] = {
    {BP_PUSHBUTTON, 0, L"PUSHBUTTON"},
    {BP_PUSHBUTTON, PBS_NORMAL, L"NORMAL"},
    {BP_PUSHBUTTON, PBS_HOT, L"HOT"},
    {BP_PUSHBUTTON, PBS_PRESSED, L"PRESSED"},
    {BP_PUSHBUTTON, PBS_DISABLED, L"DISABLED"},
    {BP_PUSHBUTTON, PBS_DEFAULTED, L"DEFAULTED"},
    {BP_PUSHBUTTON, PBS_DEFAULTED_ANIMATING, L"DEFAULTED_ANIMATING"},
    {BP_RADIOBUTTON, 0, L"RADIOBUTTON"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDNORMAL, L"UNCHECKEDNORMAL"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDHOT, L"UNCHECKEDHOT"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDPRESSED, L"UNCHECKEDPRESSED"},
    {BP_RADIOBUTTON, RBS_UNCHECKEDDISABLED, L"UNCHECKEDDISABLED"},
    {BP_RADIOBUTTON, RBS_CHECKEDNORMAL, L"CHECKEDNORMAL"},
    {BP_RADIOBUTTON, RBS_CHECKEDHOT, L"CHECKEDHOT"},
    {BP_RADIOBUTTON, RBS_CHECKEDPRESSED, L"CHECKEDPRESSED"},
    {BP_RADIOBUTTON, RBS_CHECKEDDISABLED, L"CHECKEDDISABLED"},
    {BP_CHECKBOX, 0, L"CHECKBOX"},
    {BP_CHECKBOX, CBS_UNCHECKEDNORMAL, L"UNCHECKEDNORMAL"},
    {BP_CHECKBOX, CBS_UNCHECKEDHOT, L"UNCHECKEDHOT"},
    {BP_CHECKBOX, CBS_UNCHECKEDPRESSED, L"UNCHECKEDPRESSED"},
    {BP_CHECKBOX, CBS_UNCHECKEDDISABLED, L"UNCHECKEDDISABLED"},
    {BP_CHECKBOX, CBS_CHECKEDNORMAL, L"CHECKEDNORMAL"},
    {BP_CHECKBOX, CBS_CHECKEDHOT, L"CHECKEDHOT"},
    {BP_CHECKBOX, CBS_CHECKEDPRESSED, L"CHECKEDPRESSED"},
    {BP_CHECKBOX, CBS_CHECKEDDISABLED, L"CHECKEDDISABLED"},
    {BP_CHECKBOX, CBS_MIXEDNORMAL, L"MIXEDNORMAL"},
    {BP_CHECKBOX, CBS_MIXEDHOT, L"MIXEDHOT"},
    {BP_CHECKBOX, CBS_MIXEDPRESSED, L"MIXEDPRESSED"},
    {BP_CHECKBOX, CBS_MIXEDDISABLED, L"MIXEDDISABLED"},
    {BP_CHECKBOX, CBS_IMPLICITNORMAL, L"IMPLICITNORMAL"},
    {BP_CHECKBOX, CBS_IMPLICITHOT, L"IMPLICITHOT"},
    {BP_CHECKBOX, CBS_IMPLICITPRESSED, L"IMPLICITPRESSED"},
    {BP_CHECKBOX, CBS_IMPLICITDISABLED, L"IMPLICITDISABLED"},
    {BP_CHECKBOX, CBS_EXCLUDEDNORMAL, L"EXCLUDEDNORMAL"},
    {BP_CHECKBOX, CBS_EXCLUDEDHOT, L"EXCLUDEDHOT"},
    {BP_CHECKBOX, CBS_EXCLUDEDPRESSED, L"EXCLUDEDPRESSED"},
    {BP_CHECKBOX, CBS_EXCLUDEDDISABLED, L"EXCLUDEDDISABLED"},
    {BP_GROUPBOX, 0, L"GROUPBOX"},
    {BP_GROUPBOX, GBS_NORMAL, L"NORMAL"},
    {BP_GROUPBOX, GBS_DISABLED, L"DISABLED"},
    {BP_USERBUTTON, 0, L"USERBUTTON"},
    {BP_COMMANDLINK, 0, L"COMMANDLINK"},
    {BP_COMMANDLINK, CMDLS_NORMAL, L"NORMAL"},
    {BP_COMMANDLINK, CMDLS_HOT, L"HOT"},
    {BP_COMMANDLINK, CMDLS_PRESSED, L"PRESSED"},
    {BP_COMMANDLINK, CMDLS_DISABLED, L"DISABLED"},
    {BP_COMMANDLINK, CMDLS_DEFAULTED, L"DEFAULTED"},
    {BP_COMMANDLINK, CMDLS_DEFAULTED_ANIMATING, L"DEFAULTED_ANIMATING"},
    {BP_COMMANDLINKGLYPH, 0, L"COMMANDLINKGLYPH"},
    {BP_COMMANDLINKGLYPH, CMDLGS_NORMAL, L"NORMAL"},
    {BP_COMMANDLINKGLYPH, CMDLGS_HOT, L"HOT"},
    {BP_COMMANDLINKGLYPH, CMDLGS_PRESSED, L"PRESSED"},
    {BP_COMMANDLINKGLYPH, CMDLGS_DISABLED, L"DISABLED"},
    {BP_COMMANDLINKGLYPH, CMDLGS_DEFAULTED, L"DEFAULTED"},
    {BP_RADIOBUTTON_HCDISABLED, 0, L"RADIOBUTTON_HCDISABLED"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_UNCHECKEDNORMAL, L"UNCHECKEDNORMAL"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_UNCHECKEDHOT, L"UNCHECKEDHOT"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_UNCHECKEDPRESSED, L"UNCHECKEDPRESSED"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_UNCHECKEDDISABLED, L"UNCHECKEDDISABLED"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_CHECKEDNORMAL, L"CHECKEDNORMAL"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_CHECKEDHOT, L"CHECKEDHOT"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_CHECKEDPRESSED, L"CHECKEDPRESSED"},
    {BP_RADIOBUTTON_HCDISABLED, RBS_CHECKEDDISABLED, L"CHECKEDDISABLED"},
    {BP_CHECKBOX_HCDISABLED, 0, L"CHECKBOX_HCDISABLED"},
    {BP_CHECKBOX_HCDISABLED, CBS_UNCHECKEDNORMAL, L"UNCHECKEDNORMAL"},
    {BP_CHECKBOX_HCDISABLED, CBS_UNCHECKEDHOT, L"UNCHECKEDHOT"},
    {BP_CHECKBOX_HCDISABLED, CBS_UNCHECKEDPRESSED, L"UNCHECKEDPRESSED"},
    {BP_CHECKBOX_HCDISABLED, CBS_UNCHECKEDDISABLED, L"UNCHECKEDDISABLED"},
    {BP_CHECKBOX_HCDISABLED, CBS_CHECKEDNORMAL, L"CHECKEDNORMAL"},
    {BP_CHECKBOX_HCDISABLED, CBS_CHECKEDHOT, L"CHECKEDHOT"},
    {BP_CHECKBOX_HCDISABLED, CBS_CHECKEDPRESSED, L"CHECKEDPRESSED"},
    {BP_CHECKBOX_HCDISABLED, CBS_CHECKEDDISABLED, L"CHECKEDDISABLED"},
    {BP_CHECKBOX_HCDISABLED, CBS_MIXEDNORMAL, L"MIXEDNORMAL"},
    {BP_CHECKBOX_HCDISABLED, CBS_MIXEDHOT, L"MIXEDHOT"},
    {BP_CHECKBOX_HCDISABLED, CBS_MIXEDPRESSED, L"MIXEDPRESSED"},
    {BP_CHECKBOX_HCDISABLED, CBS_MIXEDDISABLED, L"MIXEDDISABLED"},
    {BP_CHECKBOX_HCDISABLED, CBS_IMPLICITNORMAL, L"IMPLICITNORMAL"},
    {BP_CHECKBOX_HCDISABLED, CBS_IMPLICITHOT, L"IMPLICITHOT"},
    {BP_CHECKBOX_HCDISABLED, CBS_IMPLICITPRESSED, L"IMPLICITPRESSED"},
    {BP_CHECKBOX_HCDISABLED, CBS_IMPLICITDISABLED, L"IMPLICITDISABLED"},
    {BP_CHECKBOX_HCDISABLED, CBS_EXCLUDEDNORMAL, L"EXCLUDEDNORMAL"},
    {BP_CHECKBOX_HCDISABLED, CBS_EXCLUDEDHOT, L"EXCLUDEDHOT"},
    {BP_CHECKBOX_HCDISABLED, CBS_EXCLUDEDPRESSED, L"EXCLUDEDPRESSED"},
    {BP_CHECKBOX_HCDISABLED, CBS_EXCLUDEDDISABLED, L"EXCLUDEDDISABLED"},
    {BP_GROUPBOX_HCDISABLED, 0, L"GROUPBOX_HCDISABLED"},
    {BP_GROUPBOX_HCDISABLED, GBS_NORMAL, L"NORMAL"},
    {BP_GROUPBOX_HCDISABLED, GBS_DISABLED, L"DISABLED"},
    {BP_PUSHBUTTONDROPDOWN, 0, L"PUSHBUTTONDROPDOWN"},
    {BP_PUSHBUTTONDROPDOWN, PBDDS_NORMAL, L"NORMAL"},
    {BP_PUSHBUTTONDROPDOWN, PBDDS_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classClock[] = {
    {CLP_TIME, 0, L"TIME"},
    {CLP_TIME, CLS_NORMAL, L"NORMAL"},
    {CLP_TIME, CLS_HOT, L"HOT"},
    {CLP_TIME, CLS_PRESSED, L"PRESSED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classCombobox[] = {
    {CP_DROPDOWNBUTTON, 0, L"DROPDOWNBUTTON"},
    {CP_DROPDOWNBUTTON, CBXS_NORMAL, L"NORMAL"},
    {CP_DROPDOWNBUTTON, CBXS_HOT, L"HOT"},
    {CP_DROPDOWNBUTTON, CBXS_PRESSED, L"PRESSED"},
    {CP_DROPDOWNBUTTON, CBXS_DISABLED, L"DISABLED"},
    {CP_BACKGROUND, 0, L"BACKGROUND"},
    {CP_TRANSPARENTBACKGROUND, 0, L"TRANSPARENTBACKGROUND"},
    {CP_TRANSPARENTBACKGROUND, CBTBS_NORMAL, L"NORMAL"},
    {CP_TRANSPARENTBACKGROUND, CBTBS_HOT, L"HOT"},
    {CP_TRANSPARENTBACKGROUND, CBTBS_DISABLED, L"DISABLED"},
    {CP_TRANSPARENTBACKGROUND, CBTBS_FOCUSED, L"FOCUSED"},
    {CP_BORDER, 0, L"BORDER"},
    {CP_BORDER, CBB_NORMAL, L"NORMAL"},
    {CP_BORDER, CBB_HOT, L"HOT"},
    {CP_BORDER, CBB_FOCUSED, L"FOCUSED"},
    {CP_BORDER, CBB_DISABLED, L"DISABLED"},
    {CP_READONLY, 0, L"READONLY"},
    {CP_READONLY, CBRO_NORMAL, L"NORMAL"},
    {CP_READONLY, CBRO_HOT, L"HOT"},
    {CP_READONLY, CBRO_PRESSED, L"PRESSED"},
    {CP_READONLY, CBRO_DISABLED, L"DISABLED"},
    {CP_DROPDOWNBUTTONRIGHT, 0, L"DROPDOWNBUTTONRIGHT"},
    {CP_DROPDOWNBUTTONRIGHT, CBXSR_NORMAL, L"NORMAL"},
    {CP_DROPDOWNBUTTONRIGHT, CBXSR_HOT, L"HOT"},
    {CP_DROPDOWNBUTTONRIGHT, CBXSR_PRESSED, L"PRESSED"},
    {CP_DROPDOWNBUTTONRIGHT, CBXSR_DISABLED, L"DISABLED"},
    {CP_DROPDOWNBUTTONLEFT, 0, L"DROPDOWNBUTTONLEFT"},
    {CP_DROPDOWNBUTTONLEFT, CBXSL_NORMAL, L"NORMAL"},
    {CP_DROPDOWNBUTTONLEFT, CBXSL_HOT, L"HOT"},
    {CP_DROPDOWNBUTTONLEFT, CBXSL_PRESSED, L"PRESSED"},
    {CP_DROPDOWNBUTTONLEFT, CBXSL_DISABLED, L"DISABLED"},
    {CP_CUEBANNER, 0, L"CUEBANNER"},
    {CP_CUEBANNER, CBCB_NORMAL, L"NORMAL"},
    {CP_CUEBANNER, CBCB_HOT, L"HOT"},
    {CP_CUEBANNER, CBCB_PRESSED, L"PRESSED"},
    {CP_CUEBANNER, CBCB_DISABLED, L"DISABLED"},
    {CP_DROPDOWNITEM, 0, L"DROPDOWNITEM"},
    {CP_DROPDOWNITEM, CBDI_NORMAL, L"NORMAL"},
    {CP_DROPDOWNITEM, CBDI_HIGHLIGHTED, L"HIGHLIGHTED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classEdit[] = {
    {EP_EDITTEXT, 0, L"EDITTEXT"},
    {EP_EDITTEXT, ETS_NORMAL, L"NORMAL"},
    {EP_EDITTEXT, ETS_HOT, L"HOT"},
    {EP_EDITTEXT, ETS_SELECTED, L"SELECTED"},
    {EP_EDITTEXT, ETS_DISABLED, L"DISABLED"},
    {EP_EDITTEXT, ETS_FOCUSED, L"FOCUSED"},
    {EP_EDITTEXT, ETS_READONLY, L"READONLY"},
    {EP_EDITTEXT, ETS_ASSIST, L"ASSIST"},
    {EP_EDITTEXT, ETS_CUEBANNER, L"CUEBANNER"},
    {EP_CARET, 0, L"CARET"},
    {EP_BACKGROUND, 0, L"BACKGROUND"},
    {EP_BACKGROUND, EBS_NORMAL, L"NORMAL"},
    {EP_BACKGROUND, EBS_HOT, L"HOT"},
    {EP_BACKGROUND, EBS_DISABLED, L"DISABLED"},
    {EP_BACKGROUND, EBS_FOCUSED, L"FOCUSED"},
    {EP_BACKGROUND, EBS_READONLY, L"READONLY"},
    {EP_BACKGROUND, EBS_ASSIST, L"ASSIST"},
    {EP_PASSWORD, 0, L"PASSWORD"},
    {EP_BACKGROUNDWITHBORDER, 0, L"BACKGROUNDWITHBORDER"},
    {EP_BACKGROUNDWITHBORDER, EBWBS_NORMAL, L"NORMAL"},
    {EP_BACKGROUNDWITHBORDER, EBWBS_HOT, L"HOT"},
    {EP_BACKGROUNDWITHBORDER, EBWBS_DISABLED, L"DISABLED"},
    {EP_BACKGROUNDWITHBORDER, EBWBS_FOCUSED, L"FOCUSED"},
    {EP_EDITBORDER_NOSCROLL, 0, L"EDITBORDER_NOSCROLL"},
    {EP_EDITBORDER_NOSCROLL, EPSN_NORMAL, L"NORMAL"},
    {EP_EDITBORDER_NOSCROLL, EPSN_HOT, L"HOT"},
    {EP_EDITBORDER_NOSCROLL, EPSN_FOCUSED, L"FOCUSED"},
    {EP_EDITBORDER_NOSCROLL, EPSN_DISABLED, L"DISABLED"},
    {EP_EDITBORDER_HSCROLL, 0, L"EDITBORDER_HSCROLL"},
    {EP_EDITBORDER_HSCROLL, EPSH_NORMAL, L"NORMAL"},
    {EP_EDITBORDER_HSCROLL, EPSH_HOT, L"HOT"},
    {EP_EDITBORDER_HSCROLL, EPSH_FOCUSED, L"FOCUSED"},
    {EP_EDITBORDER_HSCROLL, EPSH_DISABLED, L"DISABLED"},
    {EP_EDITBORDER_VSCROLL, 0, L"EDITBORDER_VSCROLL"},
    {EP_EDITBORDER_VSCROLL, EPSV_NORMAL, L"NORMAL"},
    {EP_EDITBORDER_VSCROLL, EPSV_HOT, L"HOT"},
    {EP_EDITBORDER_VSCROLL, EPSV_FOCUSED, L"FOCUSED"},
    {EP_EDITBORDER_VSCROLL, EPSV_DISABLED, L"DISABLED"},
    {EP_EDITBORDER_HVSCROLL, 0, L"EDITBORDER_HVSCROLL"},
    {EP_EDITBORDER_HVSCROLL, EPSHV_NORMAL, L"NORMAL"},
    {EP_EDITBORDER_HVSCROLL, EPSHV_HOT, L"HOT"},
    {EP_EDITBORDER_HVSCROLL, EPSHV_FOCUSED, L"FOCUSED"},
    {EP_EDITBORDER_HVSCROLL, EPSHV_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classExplorerbar[] = {
    {EBP_HEADERBACKGROUND, 0, L"HEADERBACKGROUND"},
    {EBP_HEADERCLOSE, 0, L"HEADERCLOSE"},
    {EBP_HEADERCLOSE, EBHC_NORMAL, L"NORMAL"},
    {EBP_HEADERCLOSE, EBHC_HOT, L"HOT"},
    {EBP_HEADERCLOSE, EBHC_PRESSED, L"PRESSED"},
    {EBP_HEADERPIN, 0, L"HEADERPIN"},
    {EBP_HEADERPIN, EBHP_NORMAL, L"NORMAL"},
    {EBP_HEADERPIN, EBHP_HOT, L"HOT"},
    {EBP_HEADERPIN, EBHP_PRESSED, L"PRESSED"},
    {EBP_HEADERPIN, EBHP_SELECTEDNORMAL, L"SELECTEDNORMAL"},
    {EBP_HEADERPIN, EBHP_SELECTEDHOT, L"SELECTEDHOT"},
    {EBP_HEADERPIN, EBHP_SELECTEDPRESSED, L"SELECTEDPRESSED"},
    {EBP_IEBARMENU, 0, L"IEBARMENU"},
    {EBP_IEBARMENU, EBM_NORMAL, L"NORMAL"},
    {EBP_IEBARMENU, EBM_HOT, L"HOT"},
    {EBP_IEBARMENU, EBM_PRESSED, L"PRESSED"},
    {EBP_NORMALGROUPBACKGROUND, 0, L"NORMALGROUPBACKGROUND"},
    {EBP_NORMALGROUPCOLLAPSE, 0, L"NORMALGROUPCOLLAPSE"},
    {EBP_NORMALGROUPCOLLAPSE, EBNGC_NORMAL, L"NORMAL"},
    {EBP_NORMALGROUPCOLLAPSE, EBNGC_HOT, L"HOT"},
    {EBP_NORMALGROUPCOLLAPSE, EBNGC_PRESSED, L"PRESSED"},
    {EBP_NORMALGROUPEXPAND, 0, L"NORMALGROUPEXPAND"},
    {EBP_NORMALGROUPEXPAND, EBNGE_NORMAL, L"NORMAL"},
    {EBP_NORMALGROUPEXPAND, EBNGE_HOT, L"HOT"},
    {EBP_NORMALGROUPEXPAND, EBNGE_PRESSED, L"PRESSED"},
    {EBP_NORMALGROUPHEAD, 0, L"NORMALGROUPHEAD"},
    {EBP_SPECIALGROUPBACKGROUND, 0, L"SPECIALGROUPBACKGROUND"},
    {EBP_SPECIALGROUPCOLLAPSE, 0, L"SPECIALGROUPCOLLAPSE"},
    {EBP_SPECIALGROUPCOLLAPSE, EBSGC_NORMAL, L"NORMAL"},
    {EBP_SPECIALGROUPCOLLAPSE, EBSGC_HOT, L"HOT"},
    {EBP_SPECIALGROUPCOLLAPSE, EBSGC_PRESSED, L"PRESSED"},
    {EBP_SPECIALGROUPEXPAND, 0, L"SPECIALGROUPEXPAND"},
    {EBP_SPECIALGROUPEXPAND, EBSGE_NORMAL, L"NORMAL"},
    {EBP_SPECIALGROUPEXPAND, EBSGE_HOT, L"HOT"},
    {EBP_SPECIALGROUPEXPAND, EBSGE_PRESSED, L"PRESSED"},
    {EBP_SPECIALGROUPHEAD, 0, L"SPECIALGROUPHEAD"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classHeader[] = {
    {HP_HEADERITEM, 0, L"HEADERITEM"},
    {HP_HEADERITEM, HIS_NORMAL, L"NORMAL"},
    {HP_HEADERITEM, HIS_HOT, L"HOT"},
    {HP_HEADERITEM, HIS_PRESSED, L"PRESSED"},
    {HP_HEADERITEM, HIS_SORTEDNORMAL, L"SORTEDNORMAL"},
    {HP_HEADERITEM, HIS_SORTEDHOT, L"SORTHOT"},
    {HP_HEADERITEM, HIS_SORTEDPRESSED, L"SORTPRESSED"},
    {HP_HEADERITEM, HIS_ICONNORMAL, L"ICONNORMAL"},
    {HP_HEADERITEM, HIS_ICONHOT, L"ICONHOT"},
    {HP_HEADERITEM, HIS_ICONPRESSED, L"ICONPRESSED"},
    {HP_HEADERITEM, HIS_ICONSORTEDNORMAL, L"ICONSORTEDNORMAL"},
    {HP_HEADERITEM, HIS_ICONSORTEDHOT, L"ICONSORTEDHOT"},
    {HP_HEADERITEM, HIS_ICONSORTEDPRESSED, L"ICONSORTEDPRESSED"},
    {HP_HEADERITEMLEFT, 0, L"HEADERITEMLEFT"},
    {HP_HEADERITEMLEFT, HILS_NORMAL, L"NORMAL"},
    {HP_HEADERITEMLEFT, HILS_HOT, L"HOT"},
    {HP_HEADERITEMLEFT, HILS_PRESSED, L"PRESSED"},
    {HP_HEADERITEMRIGHT, 0, L"HEADERITEMRIGHT"},
    {HP_HEADERITEMRIGHT, HIRS_NORMAL, L"NORMAL"},
    {HP_HEADERITEMRIGHT, HIRS_HOT, L"HOT"},
    {HP_HEADERITEMRIGHT, HIRS_PRESSED, L"PRESSED"},
    {HP_HEADERSORTARROW, 0, L"HEADERSORTARROW"},
    {HP_HEADERSORTARROW, HSAS_SORTEDUP, L"SORTEDUP"},
    {HP_HEADERSORTARROW, HSAS_SORTEDDOWN, L"SORTEDDOWN"},
    {HP_HEADERDROPDOWN, 0, L"HEADERDROPDOWN"},
    {HP_HEADERDROPDOWN, HDDS_NORMAL, L"NORMAL"},
    {HP_HEADERDROPDOWN, HDDS_SOFTHOT, L"SOFTHOT"},
    {HP_HEADERDROPDOWN, HDDS_HOT, L"HOT"},
    {HP_HEADERDROPDOWNFILTER, 0, L"HEADERDROPDOWNFILTER"},
    {HP_HEADERDROPDOWNFILTER, HDDFS_NORMAL, L"NORMAL"},
    {HP_HEADERDROPDOWNFILTER, HDDFS_SOFTHOT, L"SOFTHOT"},
    {HP_HEADERDROPDOWNFILTER, HDDFS_HOT, L"HOT"},
    {HP_HEADEROVERFLOW, 0, L"HEADEROVERFLOW"},
    {HP_HEADEROVERFLOW, HOFS_NORMAL, L"NORMAL"},
    {HP_HEADEROVERFLOW, HOFS_HOT, L"HOT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classListview[] = {
    {LVP_LISTITEM, 0, L"LISTITEM"},
    {LVP_LISTITEM, LISS_NORMAL, L"NORMAL"},
    {LVP_LISTITEM, LISS_HOT, L"HOT"},
    {LVP_LISTITEM, LISS_SELECTED, L"SELECTED"},
    {LVP_LISTITEM, LISS_DISABLED, L"DISABLED"},
    {LVP_LISTITEM, LISS_SELECTEDNOTFOCUS, L"SELECTEDNOTFOCUS"},
    {LVP_LISTITEM, LISS_HOTSELECTED, L"HOTSELECTED"},
    {LVP_LISTGROUP, 0, L"LISTGROUP"},
    {LVP_LISTDETAIL, 0, L"LISTDETAIL"},
    {LVP_LISTSORTEDDETAIL, 0, L"LISTSORTEDDETAIL"},
    {LVP_EMPTYTEXT, 0, L"EMPTYTEXT"},
    {LVP_GROUPHEADER, 0, L"GROUPHEADER"},
    {LVP_GROUPHEADER, LVGH_OPEN, L"OPEN"},
    {LVP_GROUPHEADER, LVGH_OPENHOT, L"OPENHOT"},
    {LVP_GROUPHEADER, LVGH_OPENSELECTED, L"OPENSELECTED"},
    {LVP_GROUPHEADER, LVGH_OPENSELECTEDHOT, L"OPENSELECTEDHOT"},
    {LVP_GROUPHEADER, LVGH_OPENSELECTEDNOTFOCUSED, L"OPENSELECTEDNOTFOCUSED"},
    {LVP_GROUPHEADER, LVGH_OPENSELECTEDNOTFOCUSEDHOT, L"OPENSELECTEDNOTFOCUSEDHOT"},
    {LVP_GROUPHEADER, LVGH_OPENMIXEDSELECTION, L"OPENMIXEDSELECTION"},
    {LVP_GROUPHEADER, LVGH_OPENMIXEDSELECTIONHOT, L"OPENMIXEDSELECTIONHOT"},
    {LVP_GROUPHEADER, LVGH_CLOSE, L"CLOSE"},
    {LVP_GROUPHEADER, LVGH_CLOSEHOT, L"CLOSEHOT"},
    {LVP_GROUPHEADER, LVGH_CLOSESELECTED, L"CLOSESELECTED"},
    {LVP_GROUPHEADER, LVGH_CLOSESELECTEDHOT, L"CLOSESELECTEDHOT"},
    {LVP_GROUPHEADER, LVGH_CLOSESELECTEDNOTFOCUSED, L"CLOSESELECTEDNOTFOCUSED"},
    {LVP_GROUPHEADER, LVGH_CLOSESELECTEDNOTFOCUSEDHOT, L"CLOSESELECTEDNOTFOCUSEDHOT"},
    {LVP_GROUPHEADER, LVGH_CLOSEMIXEDSELECTION, L"CLOSEMIXEDSELECTION"},
    {LVP_GROUPHEADER, LVGH_CLOSEMIXEDSELECTIONHOT, L"CLOSEMIXEDSELECTIONHOT"},
    {LVP_GROUPHEADERLINE, 0, L"GROUPHEADERLINE"},
    {LVP_GROUPHEADERLINE, LVGHL_OPEN, L"OPEN"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENHOT, L"OPENHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENSELECTED, L"OPENSELECTED"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENSELECTEDHOT, L"OPENSELECTEDHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENSELECTEDNOTFOCUSED, L"OPENSELECTEDNOTFOCUSED"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENSELECTEDNOTFOCUSEDHOT, L"OPENSELECTEDNOTFOCUSEDHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENMIXEDSELECTION, L"OPENMIXEDSELECTION"},
    {LVP_GROUPHEADERLINE, LVGHL_OPENMIXEDSELECTIONHOT, L"OPENMIXEDSELECTIONHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSE, L"CLOSE"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSEHOT, L"CLOSEHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSESELECTED, L"CLOSESELECTED"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSESELECTEDHOT, L"CLOSESELECTEDHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSESELECTEDNOTFOCUSED, L"CLOSESELECTEDNOTFOCUSED"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSESELECTEDNOTFOCUSEDHOT, L"CLOSESELECTEDNOTFOCUSEDHOT"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSEMIXEDSELECTION, L"CLOSEMIXEDSELECTION"},
    {LVP_GROUPHEADERLINE, LVGHL_CLOSEMIXEDSELECTIONHOT, L"CLOSEMIXEDSELECTIONHOT"},
    {LVP_EXPANDBUTTON, 0, L"EXPANDBUTTON"},
    {LVP_EXPANDBUTTON, LVEB_NORMAL, L"NORMAL"},
    {LVP_EXPANDBUTTON, LVEB_HOVER, L"HOVER"},
    {LVP_EXPANDBUTTON, LVEB_PUSHED, L"PUSHED"},
    {LVP_COLLAPSEBUTTON, 0, L"COLLAPSEBUTTON"},
    {LVP_COLLAPSEBUTTON, LVCB_NORMAL, L"NORMAL"},
    {LVP_COLLAPSEBUTTON, LVCB_HOVER, L"HOVER"},
    {LVP_COLLAPSEBUTTON, LVCB_PUSHED, L"PUSHED"},
    {LVP_COLUMNDETAIL, 0, L"COLUMNDETAIL"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classMenu[] = {
    {MENU_MENUITEM_TMSCHEMA, 0, L"MENUITEM"},
    {MENU_MENUDROPDOWN_TMSCHEMA, 0, L"MENUDROPDOWN"},
    {MENU_MENUBARITEM_TMSCHEMA, 0, L"MENUBARITEM"},
    {MENU_MENUBARDROPDOWN_TMSCHEMA, 0, L"MENUBARDROPDOWN"},
    {MENU_CHEVRON_TMSCHEMA, 0, L"CHEVRON"},
    {MENU_SEPARATOR_TMSCHEMA, 0, L"SEPARATOR"},
    {MENU_BARBACKGROUND, 0, L"BARBACKGROUND"},
    {MENU_BARBACKGROUND, MB_ACTIVE, L"ACTIVE"},
    {MENU_BARBACKGROUND, MB_INACTIVE, L"INACTIVE"},
    {MENU_BARITEM, 0, L"BARITEM"},
    {MENU_BARITEM, MBI_NORMAL, L"NORMAL"},
    {MENU_BARITEM, MBI_HOT, L"HOT"},
    {MENU_BARITEM, MBI_PUSHED, L"PUSHED"},
    {MENU_BARITEM, MBI_DISABLED, L"DISABLED"},
    {MENU_BARITEM, MBI_DISABLEDHOT, L"DISABLEDHOT"},
    {MENU_BARITEM, MBI_DISABLEDPUSHED, L"DISABLEDPUSHED"},
    {MENU_POPUPBACKGROUND, 0, L"POPUPBACKGROUND"},
    {MENU_POPUPBORDERS, 0, L"POPUPBORDERS"},
    {MENU_POPUPCHECK, 0, L"POPUPCHECK"},
    {MENU_POPUPCHECK, MC_CHECKMARKNORMAL, L"CHECKMARKNORMAL"},
    {MENU_POPUPCHECK, MC_CHECKMARKDISABLED, L"CHECKMARKDISABLED"},
    {MENU_POPUPCHECK, MC_BULLETNORMAL, L"BULLETNORMAL"},
    {MENU_POPUPCHECK, MC_BULLETDISABLED, L"BULLETDISABLED"},
    {MENU_POPUPCHECKBACKGROUND, 0, L"POPUPCHECKBACKGROUND"},
    {MENU_POPUPCHECKBACKGROUND, MCB_DISABLED, L"DISABLED"},
    {MENU_POPUPCHECKBACKGROUND, MCB_NORMAL, L"NORMAL"},
    {MENU_POPUPCHECKBACKGROUND, MCB_BITMAP, L"BITMAP"},
    {MENU_POPUPGUTTER, 0, L"POPUPGUTTER"},
    {MENU_POPUPITEM, 0, L"POPUPITEM"},
    {MENU_POPUPITEM, MPI_NORMAL, L"NORMAL"},
    {MENU_POPUPITEM, MPI_HOT, L"HOT"},
    {MENU_POPUPITEM, MPI_DISABLED, L"DISABLED"},
    {MENU_POPUPITEM, MPI_DISABLEDHOT, L"DISABLEDHOT"},
    {MENU_POPUPSEPARATOR, 0, L"POPUPSEPARATOR"},
    {MENU_POPUPSUBMENU, 0, L"POPUPSUBMENU"},
    {MENU_POPUPSUBMENU, MSM_NORMAL, L"NORMAL"},
    {MENU_POPUPSUBMENU, MSM_DISABLED, L"DISABLED"},
    {MENU_SYSTEMCLOSE, 0, L"SYSTEMCLOSE"},
    {MENU_SYSTEMCLOSE, MSYSC_NORMAL, L"NORMAL"},
    {MENU_SYSTEMCLOSE, MSYSC_DISABLED, L"DISABLED"},
    {MENU_SYSTEMMAXIMIZE, 0, L"SYSTEMMAXIMIZE"},
    {MENU_SYSTEMMAXIMIZE, MSYSMX_NORMAL, L"NORMAL"},
    {MENU_SYSTEMMAXIMIZE, MSYSMX_DISABLED, L"DISABLED"},
    {MENU_SYSTEMMINIMIZE, 0, L"SYSTEMMINIMIZE"},
    {MENU_SYSTEMMINIMIZE, MSYSMN_NORMAL, L"NORMAL"},
    {MENU_SYSTEMMINIMIZE, MSYSMN_DISABLED, L"DISABLED"},
    {MENU_SYSTEMRESTORE, 0, L"SYSTEMRESTORE"},
    {MENU_SYSTEMRESTORE, MSYSR_NORMAL, L"NORMAL"},
    {MENU_SYSTEMRESTORE, MSYSR_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classMenuband[] = {
    {MDP_NEWAPPBUTTON, 0, L"NEWAPPBUTTON"},
    {MDP_NEWAPPBUTTON, MDS_NORMAL, L"NORMAL"},
    {MDP_NEWAPPBUTTON, MDS_HOT, L"HOT"},
    {MDP_NEWAPPBUTTON, MDS_PRESSED, L"PRESSED"},
    {MDP_NEWAPPBUTTON, MDS_DISABLED, L"DISABLED"},
    {MDP_NEWAPPBUTTON, MDS_CHECKED, L"CHECKED"},
    {MDP_NEWAPPBUTTON, MDS_HOTCHECKED, L"HOTCHECKED"},
    {MDP_SEPERATOR, 0, L"SEPERATOR"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classNavigation[] = {
    {NAV_BACKBUTTON, 0, L"BACKBUTTON"},
    {NAV_BACKBUTTON, NAV_BB_NORMAL, L"NORMAL"},
    {NAV_BACKBUTTON, NAV_BB_HOT, L"HOT"},
    {NAV_BACKBUTTON, NAV_BB_PRESSED, L"PRESSED"},
    {NAV_BACKBUTTON, NAV_BB_DISABLED, L"DISABLED"},
    {NAV_FORWARDBUTTON, 0, L"FORWARDBUTTON"},
    {NAV_FORWARDBUTTON, NAV_FB_NORMAL, L"NORMAL"},
    {NAV_FORWARDBUTTON, NAV_FB_HOT, L"HOT"},
    {NAV_FORWARDBUTTON, NAV_FB_PRESSED, L"PRESSED"},
    {NAV_FORWARDBUTTON, NAV_FB_DISABLED, L"DISABLED"},
    {NAV_MENUBUTTON, 0, L"MENUBUTTON"},
    {NAV_MENUBUTTON, NAV_MB_NORMAL, L"NORMAL"},
    {NAV_MENUBUTTON, NAV_MB_HOT, L"HOT"},
    {NAV_MENUBUTTON, NAV_MB_PRESSED, L"PRESSED"},
    {NAV_MENUBUTTON, NAV_MB_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classPage[] = {
    {PGRP_UP, 0, L"UP"},
    {PGRP_UP, UPS_NORMAL, L"NORMAL"},
    {PGRP_UP, UPS_HOT, L"HOT"},
    {PGRP_UP, UPS_PRESSED, L"PRESSED"},
    {PGRP_UP, UPS_DISABLED, L"DISABLED"},
    {PGRP_DOWN, 0, L"DOWN"},
    {PGRP_DOWN, DNS_NORMAL, L"NORMAL"},
    {PGRP_DOWN, DNS_HOT, L"HOT"},
    {PGRP_DOWN, DNS_PRESSED, L"PRESSED"},
    {PGRP_DOWN, DNS_DISABLED, L"DISABLED"},
    {PGRP_UPHORZ, 0, L"UPHORZ"},
    {PGRP_UPHORZ, UPHZS_NORMAL, L"NORMAL"},
    {PGRP_UPHORZ, UPHZS_HOT, L"HOT"},
    {PGRP_UPHORZ, UPHZS_PRESSED, L"PRESSED"},
    {PGRP_UPHORZ, UPHZS_DISABLED, L"DISABLED"},
    {PGRP_DOWNHORZ, 0, L"DOWNHORZ"},
    {PGRP_DOWNHORZ, DNHZS_NORMAL, L"NORMAL"},
    {PGRP_DOWNHORZ, DNHZS_HOT, L"HOT"},
    {PGRP_DOWNHORZ, DNHZS_PRESSED, L"PRESSED"},
    {PGRP_DOWNHORZ, DNHZS_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classProgress[] = {
    {PP_BAR, 0, L"BAR"},
    {PP_BARVERT, 0, L"BARVERT"},
    {PP_CHUNK, 0, L"CHUNK"},
    {PP_CHUNKVERT, 0, L"CHUNKVERT"},
    {PP_FILL, 0, L"FILL"},
    {PP_FILL, PBFS_NORMAL, L"NORMAL"},
    {PP_FILL, PBFS_ERROR, L"ERROR"},
    {PP_FILL, PBFS_PAUSED, L"PAUSED"},
    {PP_FILL, PBFS_PARTIAL, L"PARTIAL"},
    {PP_FILLVERT, 0, L"FILLVERT"},
    {PP_FILLVERT, PBFVS_NORMAL, L"NORMAL"},
    {PP_FILLVERT, PBFVS_ERROR, L"ERROR"},
    {PP_FILLVERT, PBFVS_PAUSED, L"PAUSED"},
    {PP_FILLVERT, PBFVS_PARTIAL, L"PARTIAL"},
    {PP_PULSEOVERLAY, 0, L"PULSEOVERLAY"},
    {PP_MOVEOVERLAY, 0, L"MOVEOVERLAY"},
    {PP_PULSEOVERLAYVERT, 0, L"PULSEOVERLAYVERT"},
    {PP_MOVEOVERLAYVERT, 0, L"MOVEOVERLAYVERT"},
    {PP_TRANSPARENTBAR, 0, L"TRANSPARENTBAR"},
    {PP_TRANSPARENTBAR, PBBS_NORMAL, L"NORMAL"},
    {PP_TRANSPARENTBAR, PBBS_PARTIAL, L"PARTIAL"},
    {PP_TRANSPARENTBARVERT, 0, L"TRANSPARENTBARVERT"},
    {PP_TRANSPARENTBARVERT, PBBVS_NORMAL, L"NORMAL"},
    {PP_TRANSPARENTBARVERT, PBBVS_PARTIAL, L"PARTIAL"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classRebar[] = {
    {RP_GRIPPER, 0, L"GRIPPER"},
    {RP_GRIPPERVERT, 0, L"GRIPPERVERT"},
    {RP_BAND, 0, L"BAND"},
    {RP_CHEVRON, 0, L"CHEVRON"},
    {RP_CHEVRON, CHEVS_NORMAL, L"NORMAL"},
    {RP_CHEVRON, CHEVS_HOT, L"HOT"},
    {RP_CHEVRON, CHEVS_PRESSED, L"PRESSED"},
    {RP_CHEVRONVERT, 0, L"CHEVRONVERT"},
    {RP_CHEVRONVERT, CHEVSV_NORMAL, L"NORMAL"},
    {RP_CHEVRONVERT, CHEVSV_HOT, L"HOT"},
    {RP_CHEVRONVERT, CHEVSV_PRESSED, L"PRESSED"},
    {RP_BACKGROUND, 0, L"BACKGROUND"},
    {RP_SPLITTER, 0, L"SPLITTER"},
    {RP_SPLITTER, SPLITS_NORMAL, L"NORMAL"},
    {RP_SPLITTER, SPLITS_HOT, L"HOT"},
    {RP_SPLITTER, SPLITS_PRESSED, L"PRESSED"},
    {RP_SPLITTERVERT, 0, L"SPLITTERVERT"},
    {RP_SPLITTERVERT, SPLITSV_NORMAL, L"NORMAL"},
    {RP_SPLITTERVERT, SPLITSV_HOT, L"HOT"},
    {RP_SPLITTERVERT, SPLITSV_PRESSED, L"PRESSED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classScrollbar[] = {
    {SBP_ARROWBTN, 0, L"ARROWBTN"},
    {SBP_ARROWBTN, ABS_UPNORMAL, L"UPNORMAL"},
    {SBP_ARROWBTN, ABS_UPHOT, L"UPHOT"},
    {SBP_ARROWBTN, ABS_UPPRESSED, L"UPPRESSED"},
    {SBP_ARROWBTN, ABS_UPDISABLED, L"UPDISABLED"},
    {SBP_ARROWBTN, ABS_DOWNNORMAL, L"DOWNNORMAL"},
    {SBP_ARROWBTN, ABS_DOWNHOT, L"DOWNHOT"},
    {SBP_ARROWBTN, ABS_DOWNPRESSED, L"DOWNPRESSED"},
    {SBP_ARROWBTN, ABS_DOWNDISABLED, L"DOWNDISABLED"},
    {SBP_ARROWBTN, ABS_LEFTNORMAL, L"LEFTNORMAL"},
    {SBP_ARROWBTN, ABS_LEFTHOT, L"LEFTHOT"},
    {SBP_ARROWBTN, ABS_LEFTPRESSED, L"LEFTPRESSED"},
    {SBP_ARROWBTN, ABS_LEFTDISABLED, L"LEFTDISABLED"},
    {SBP_ARROWBTN, ABS_RIGHTNORMAL, L"RIGHTNORMAL"},
    {SBP_ARROWBTN, ABS_RIGHTHOT, L"RIGHTHOT"},
    {SBP_ARROWBTN, ABS_RIGHTPRESSED, L"RIGHTPRESSED"},
    {SBP_ARROWBTN, ABS_RIGHTDISABLED, L"RIGHTDISABLED"},
    {SBP_ARROWBTN, ABS_UPHOVER, L"UPHOVER"},
    {SBP_ARROWBTN, ABS_DOWNHOVER, L"DOWNHOVER"},
    {SBP_ARROWBTN, ABS_LEFTHOVER, L"LEFTHOVER"},
    {SBP_ARROWBTN, ABS_RIGHTHOVER, L"RIGHTHOVER"},
    {SBP_THUMBBTNHORZ, 0, L"THUMBBTNHORZ"},
    {SBP_THUMBBTNHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_THUMBBTNHORZ, SCRBS_HOT, L"HOT"},
    {SBP_THUMBBTNHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_THUMBBTNHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_THUMBBTNHORZ, SCRBS_HOVER, L"HOVER"},
    {SBP_THUMBBTNVERT, 0, L"THUMBBTNVERT"},
    {SBP_THUMBBTNVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_THUMBBTNVERT, SCRBS_HOT, L"HOT"},
    {SBP_THUMBBTNVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_THUMBBTNVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_THUMBBTNVERT, SCRBS_HOVER, L"HOVER"},
    {SBP_LOWERTRACKHORZ, 0, L"LOWERTRACKHORZ"},
    {SBP_LOWERTRACKHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_LOWERTRACKHORZ, SCRBS_HOT, L"HOT"},
    {SBP_LOWERTRACKHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_LOWERTRACKHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_LOWERTRACKHORZ, SCRBS_HOVER, L"HOVER"},
    {SBP_UPPERTRACKHORZ, 0, L"UPPERTRACKHORZ"},
    {SBP_UPPERTRACKHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_UPPERTRACKHORZ, SCRBS_HOT, L"HOT"},
    {SBP_UPPERTRACKHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_UPPERTRACKHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_UPPERTRACKHORZ, SCRBS_HOVER, L"HOVER"},
    {SBP_LOWERTRACKVERT, 0, L"LOWERTRACKVERT"},
    {SBP_LOWERTRACKVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_LOWERTRACKVERT, SCRBS_HOT, L"HOT"},
    {SBP_LOWERTRACKVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_LOWERTRACKVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_LOWERTRACKVERT, SCRBS_HOVER, L"HOVER"},
    {SBP_UPPERTRACKVERT, 0, L"UPPERTRACKVERT"},
    {SBP_UPPERTRACKVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_UPPERTRACKVERT, SCRBS_HOT, L"HOT"},
    {SBP_UPPERTRACKVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_UPPERTRACKVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_UPPERTRACKVERT, SCRBS_HOVER, L"HOVER"},
    {SBP_GRIPPERHORZ, 0, L"GRIPPERHORZ"},
    {SBP_GRIPPERHORZ, SCRBS_NORMAL, L"NORMAL"},
    {SBP_GRIPPERHORZ, SCRBS_HOT, L"HOT"},
    {SBP_GRIPPERHORZ, SCRBS_PRESSED, L"PRESSED"},
    {SBP_GRIPPERHORZ, SCRBS_DISABLED, L"DISABLED"},
    {SBP_GRIPPERHORZ, SCRBS_HOVER, L"HOVER"},
    {SBP_GRIPPERVERT, 0, L"GRIPPERVERT"},
    {SBP_GRIPPERVERT, SCRBS_NORMAL, L"NORMAL"},
    {SBP_GRIPPERVERT, SCRBS_HOT, L"HOT"},
    {SBP_GRIPPERVERT, SCRBS_PRESSED, L"PRESSED"},
    {SBP_GRIPPERVERT, SCRBS_DISABLED, L"DISABLED"},
    {SBP_GRIPPERVERT, SCRBS_HOVER, L"HOVER"},
    {SBP_SIZEBOX, 0, L"SIZEBOX"},
    {SBP_SIZEBOX, SZB_RIGHTALIGN, L"RIGHTALIGN"},
    {SBP_SIZEBOX, SZB_LEFTALIGN, L"LEFTALIGN"},
    {SBP_SIZEBOX, SZB_TOPRIGHTALIGN, L"TOPRIGHTALIGN"},
    {SBP_SIZEBOX, SZB_TOPLEFTALIGN, L"TOPLEFTALIGN"},
    {SBP_SIZEBOX, SZB_HALFBOTTOMRIGHTALIGN, L"HALFBOTTOMRIGHTALIGN"},
    {SBP_SIZEBOX, SZB_HALFBOTTOMLEFTALIGN, L"HALFBOTTOMLEFTALIGN"},
    {SBP_SIZEBOX, SZB_HALFTOPRIGHTALIGN, L"HALFTOPRIGHTALIGN"},
    {SBP_SIZEBOX, SZB_HALFTOPLEFTALIGN, L"HALFTOPLEFTALIGN"},
    {SBP_SIZEBOXBKGND, 0, L"SIZEBOXBKGND"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classSpin[] = {
    {SPNP_UP, 0, L"UP"},
    {SPNP_UP, UPS_NORMAL, L"NORMAL"},
    {SPNP_UP, UPS_HOT, L"HOT"},
    {SPNP_UP, UPS_PRESSED, L"PRESSED"},
    {SPNP_UP, UPS_DISABLED, L"DISABLED"},
    {SPNP_DOWN, 0, L"DOWN"},
    {SPNP_DOWN, DNS_NORMAL, L"NORMAL"},
    {SPNP_DOWN, DNS_HOT, L"HOT"},
    {SPNP_DOWN, DNS_PRESSED, L"PRESSED"},
    {SPNP_DOWN, DNS_DISABLED, L"DISABLED"},
    {SPNP_UPHORZ, 0, L"UPHORZ"},
    {SPNP_UPHORZ, UPHZS_NORMAL, L"NORMAL"},
    {SPNP_UPHORZ, UPHZS_HOT, L"HOT"},
    {SPNP_UPHORZ, UPHZS_PRESSED, L"PRESSED"},
    {SPNP_UPHORZ, UPHZS_DISABLED, L"DISABLED"},
    {SPNP_DOWNHORZ, 0, L"DOWNHORZ"},
    {SPNP_DOWNHORZ, DNHZS_NORMAL, L"NORMAL"},
    {SPNP_DOWNHORZ, DNHZS_HOT, L"HOT"},
    {SPNP_DOWNHORZ, DNHZS_PRESSED, L"PRESSED"},
    {SPNP_DOWNHORZ, DNHZS_DISABLED, L"DISABLED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classStartpanel[] = {
    {SPP_USERPANE, 0, L"USERPANE"},
    {SPP_MOREPROGRAMS, 0, L"MOREPROGRAMS"},
    {SPP_MOREPROGRAMSARROW, 0, L"MOREPROGRAMSARROW"},
    {SPP_MOREPROGRAMSARROW, SPS_NORMAL, L"NORMAL"},
    {SPP_MOREPROGRAMSARROW, SPS_HOT, L"HOT"},
    {SPP_MOREPROGRAMSARROW, SPS_PRESSED, L"PRESSED"},
    {SPP_PROGLIST, 0, L"PROGLIST"},
    {SPP_PROGLISTSEPARATOR, 0, L"PROGLISTSEPARATOR"},
    {SPP_PLACESLIST, 0, L"PLACESLIST"},
    {SPP_PLACESLISTSEPARATOR, 0, L"PLACESLISTSEPARATOR"},
    {SPP_LOGOFF, 0, L"LOGOFF"},
    {SPP_LOGOFFBUTTONS, 0, L"LOGOFFBUTTONS"},
    {SPP_LOGOFFBUTTONS, SPLS_NORMAL, L"NORMAL"},
    {SPP_LOGOFFBUTTONS, SPLS_HOT, L"HOT"},
    {SPP_LOGOFFBUTTONS, SPLS_PRESSED, L"PRESSED"},
    {SPP_USERPICTURE, 0, L"USERPICTURE"},
    {SPP_PREVIEW, 0, L"PREVIEW"},
    {SPP_MOREPROGRAMSTAB, 0, L"MOREPROGRAMSTAB"},
    {SPP_MOREPROGRAMSTAB, SPMPT_NORMAL, L"NORMAL"},
    {SPP_MOREPROGRAMSTAB, SPMPT_HOT, L"HOT"},
    {SPP_MOREPROGRAMSTAB, SPMPT_SELECTED, L"SELECTED"},
    {SPP_MOREPROGRAMSTAB, SPMPT_DISABLED, L"DISABLED"},
    {SPP_MOREPROGRAMSTAB, SPMPT_FOCUSED, L"FOCUSED"},
    {SPP_NSCHOST, 0, L"NSCHOST"},
    {SPP_SOFTWAREEXPLORER, 0, L"SOFTWAREEXPLORER"},
    {SPP_SOFTWAREEXPLORER, SPSE_NORMAL, L"NORMAL"},
    {SPP_SOFTWAREEXPLORER, SPSE_HOT, L"HOT"},
    {SPP_SOFTWAREEXPLORER, SPSE_SELECTED, L"SELECTED"},
    {SPP_SOFTWAREEXPLORER, SPSE_DISABLED, L"DISABLED"},
    {SPP_SOFTWAREEXPLORER, SPSE_FOCUSED, L"FOCUSED"},
    {SPP_OPENBOX, 0, L"OPENBOX"},
    {SPP_OPENBOX, SPOB_NORMAL, L"NORMAL"},
    {SPP_OPENBOX, SPOB_HOT, L"HOT"},
    {SPP_OPENBOX, SPOB_SELECTED, L"SELECTED"},
    {SPP_OPENBOX, SPOB_DISABLED, L"DISABLED"},
    {SPP_OPENBOX, SPOB_FOCUSED, L"FOCUSED"},
    {SPP_SEARCHVIEW, 0, L"SEARCHVIEW"},
    {SPP_MOREPROGRAMSARROWBACK, 0, L"MOREPROGRAMSARROWBACK"},
    {SPP_MOREPROGRAMSARROWBACK, SPSB_NORMAL, L"NORMAL"},
    {SPP_MOREPROGRAMSARROWBACK, SPSB_HOT, L"HOT"},
    {SPP_MOREPROGRAMSARROWBACK, SPSB_PRESSED, L"PRESSED"},
    {SPP_TOPMATCH, 0, L"TOPMATCH"},
    {SPP_LOGOFFSPLITBUTTONDROPDOWN, 0, L"LOGOFFSPLITBUTTONDROPDOWN"},
    {SPP_LOGOFFSPLITBUTTONDROPDOWN, SPLS_NORMAL, L"NORMAL"},
    {SPP_LOGOFFSPLITBUTTONDROPDOWN, SPLS_HOT, L"HOT"},
    {SPP_LOGOFFSPLITBUTTONDROPDOWN, SPLS_PRESSED, L"PRESSED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classStatus[] = {
    {SP_PANE, 0, L"PANE"},
    {SP_GRIPPERPANE, 0, L"GRIPPERPANE"},
    {SP_GRIPPER, 0, L"GRIPPER"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTab[] = {
    {TABP_TABITEM, 0, L"TABITEM"},
    {TABP_TABITEM, TIS_NORMAL, L"NORMAL"},
    {TABP_TABITEM, TIS_HOT, L"HOT"},
    {TABP_TABITEM, TIS_SELECTED, L"SELECTED"},
    {TABP_TABITEM, TIS_DISABLED, L"DISABLED"},
    {TABP_TABITEM, TIS_FOCUSED, L"FOCUSED"},
    {TABP_TABITEMLEFTEDGE, 0, L"TABITEMLEFTEDGE"},
    {TABP_TABITEMLEFTEDGE, TILES_NORMAL, L"NORMAL"},
    {TABP_TABITEMLEFTEDGE, TILES_HOT, L"HOT"},
    {TABP_TABITEMLEFTEDGE, TILES_SELECTED, L"SELECTED"},
    {TABP_TABITEMLEFTEDGE, TILES_DISABLED, L"DISABLED"},
    {TABP_TABITEMLEFTEDGE, TILES_FOCUSED, L"FOCUSED"},
    {TABP_TABITEMRIGHTEDGE, 0, L"TABITEMRIGHTEDGE"},
    {TABP_TABITEMRIGHTEDGE, TIRES_NORMAL, L"NORMAL"},
    {TABP_TABITEMRIGHTEDGE, TIRES_HOT, L"HOT"},
    {TABP_TABITEMRIGHTEDGE, TIRES_SELECTED, L"SELECTED"},
    {TABP_TABITEMRIGHTEDGE, TIRES_DISABLED, L"DISABLED"},
    {TABP_TABITEMRIGHTEDGE, TIRES_FOCUSED, L"FOCUSED"},
    {TABP_TABITEMBOTHEDGE, 0, L"TABITEMBOTHEDGE"},
    {TABP_TABITEMBOTHEDGE, TIBES_NORMAL, L"NORMAL"},
    {TABP_TABITEMBOTHEDGE, TIBES_HOT, L"HOT"},
    {TABP_TABITEMBOTHEDGE, TIBES_SELECTED, L"SELECTED"},
    {TABP_TABITEMBOTHEDGE, TIBES_DISABLED, L"DISABLED"},
    {TABP_TABITEMBOTHEDGE, TIBES_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEM, 0, L"TOPTABITEM"},
    {TABP_TOPTABITEM, TTIS_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEM, TTIS_HOT, L"HOT"},
    {TABP_TOPTABITEM, TTIS_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEM, TTIS_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEM, TTIS_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEMLEFTEDGE, 0, L"TOPTABITEMLEFTEDGE"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_HOT, L"HOT"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEMLEFTEDGE, TTILES_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEMRIGHTEDGE, 0, L"TOPTABITEMRIGHTEDGE"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_HOT, L"HOT"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEMRIGHTEDGE, TTIRES_FOCUSED, L"FOCUSED"},
    {TABP_TOPTABITEMBOTHEDGE, 0, L"TOPTABITEMBOTHEDGE"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_NORMAL, L"NORMAL"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_HOT, L"HOT"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_SELECTED, L"SELECTED"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_DISABLED, L"DISABLED"},
    {TABP_TOPTABITEMBOTHEDGE, TTIBES_FOCUSED, L"FOCUSED"},
    {TABP_PANE, 0, L"PANE"},
    {TABP_BODY, 0, L"BODY"},
    {TABP_AEROWIZARDBODY, 0, L"AEROWIZARDBODY"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTaskband[] = {
    {TDP_GROUPCOUNT, 0, L"GROUPCOUNT"},
    {TDP_FLASHBUTTON, 0, L"FLASHBUTTON"},
    {TDP_FLASHBUTTONGROUPMENU, 0, L"FLASHBUTTONGROUPMENU"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTaskbar[] = {
    {TBP_BACKGROUNDBOTTOM, 0, L"BACKGROUNDBOTTOM"},
    {TBP_BACKGROUNDRIGHT, 0, L"BACKGROUNDRIGHT"},
    {TBP_BACKGROUNDTOP, 0, L"BACKGROUNDTOP"},
    {TBP_BACKGROUNDLEFT, 0, L"BACKGROUNDLEFT"},
    {TBP_SIZINGBARBOTTOM, 0, L"SIZINGBARBOTTOM"},
    {TBP_SIZINGBARRIGHT, 0, L"SIZINGBARRIGHT"},
    {TBP_SIZINGBARTOP, 0, L"SIZINGBARTOP"},
    {TBP_SIZINGBARLEFT, 0, L"SIZINGBARLEFT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTaskdialog[] = {
    {TDLG_PRIMARYPANEL, 0, L"PRIMARYPANEL"},
    {TDLG_MAININSTRUCTIONPANE, 0, L"MAININSTRUCTIONPANE"},
    {TDLG_MAINICON, 0, L"MAINICON"},
    {TDLG_CONTENTPANE, 0, L"CONTENTPANE"},
    {TDLG_CONTENTICON, 0, L"CONTENTICON"},
    {TDLG_EXPANDEDCONTENT, 0, L"EXPANDEDCONTENT"},
    {TDLG_COMMANDLINKPANE, 0, L"COMMANDLINKPANE"},
    {TDLG_SECONDARYPANEL, 0, L"SECONDARYPANEL"},
    {TDLG_CONTROLPANE, 0, L"CONTROLPANE"},
    {TDLG_CONTROLPANE, TDLGCPS_STANDALONE, L"STANDALONE"},
    {TDLG_BUTTONSECTION, 0, L"BUTTONSECTION"},
    {TDLG_BUTTONWRAPPER, 0, L"BUTTONWRAPPER"},
    {TDLG_EXPANDOTEXT, 0, L"EXPANDOTEXT"},
    {TDLG_EXPANDOBUTTON, 0, L"EXPANDOBUTTON"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_NORMAL, L"NORMAL"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_HOVER, L"HOVER"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_PRESSED, L"PRESSED"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_EXPANDEDNORMAL, L"EXPANDEDNORMAL"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_EXPANDEDHOVER, L"EXPANDEDHOVER"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_EXPANDEDPRESSED, L"EXPANDEDPRESSED"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_NORMALDISABLED, L"NORMALDISABLED"},
    {TDLG_EXPANDOBUTTON, TDLGEBS_EXPANDEDDISABLED, L"EXPANDEDDISABLED"},
    {TDLG_VERIFICATIONTEXT, 0, L"VERIFICATIONTEXT"},
    {TDLG_FOOTNOTEPANE, 0, L"FOOTNOTEPANE"},
    {TDLG_FOOTNOTEAREA, 0, L"FOOTNOTEAREA"},
    {TDLG_FOOTNOTESEPARATOR, 0, L"FOOTNOTESEPARATOR"},
    {TDLG_EXPANDEDFOOTERAREA, 0, L"EXPANDEDFOOTERAREA"},
    {TDLG_PROGRESSBAR, 0, L"PROGRESSBAR"},
    {TDLG_IMAGEALIGNMENT, 0, L"IMAGEALIGNMENT"},
    {TDLG_RADIOBUTTONPANE, 0, L"RADIOBUTTONPANE"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classToolbar[] = {
    {TP_BUTTON, 0, L"BUTTON"},
    {TP_BUTTON, TS_NORMAL, L"NORMAL"},
    {TP_BUTTON, TS_HOT, L"HOT"},
    {TP_BUTTON, TS_PRESSED, L"PRESSED"},
    {TP_BUTTON, TS_DISABLED, L"DISABLED"},
    {TP_BUTTON, TS_CHECKED, L"CHECKED"},
    {TP_BUTTON, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_BUTTON, TS_NEARHOT, L"NEARHOT"},
    {TP_BUTTON, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {TP_DROPDOWNBUTTON, 0, L"DROPDOWNBUTTON"},
    {TP_DROPDOWNBUTTON, TS_NORMAL, L"NORMAL"},
    {TP_DROPDOWNBUTTON, TS_HOT, L"HOT"},
    {TP_DROPDOWNBUTTON, TS_PRESSED, L"PRESSED"},
    {TP_DROPDOWNBUTTON, TS_DISABLED, L"DISABLED"},
    {TP_DROPDOWNBUTTON, TS_CHECKED, L"CHECKED"},
    {TP_DROPDOWNBUTTON, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_DROPDOWNBUTTON, TS_NEARHOT, L"NEARHOT"},
    {TP_DROPDOWNBUTTON, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {TP_SPLITBUTTON, 0, L"SPLITBUTTON"},
    {TP_SPLITBUTTON, TS_NORMAL, L"NORMAL"},
    {TP_SPLITBUTTON, TS_HOT, L"HOT"},
    {TP_SPLITBUTTON, TS_PRESSED, L"PRESSED"},
    {TP_SPLITBUTTON, TS_DISABLED, L"DISABLED"},
    {TP_SPLITBUTTON, TS_CHECKED, L"CHECKED"},
    {TP_SPLITBUTTON, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SPLITBUTTON, TS_NEARHOT, L"NEARHOT"},
    {TP_SPLITBUTTON, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {TP_SPLITBUTTONDROPDOWN, 0, L"SPLITBUTTONDROPDOWN"},
    {TP_SPLITBUTTONDROPDOWN, TS_NORMAL, L"NORMAL"},
    {TP_SPLITBUTTONDROPDOWN, TS_HOT, L"HOT"},
    {TP_SPLITBUTTONDROPDOWN, TS_PRESSED, L"PRESSED"},
    {TP_SPLITBUTTONDROPDOWN, TS_DISABLED, L"DISABLED"},
    {TP_SPLITBUTTONDROPDOWN, TS_CHECKED, L"CHECKED"},
    {TP_SPLITBUTTONDROPDOWN, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SPLITBUTTONDROPDOWN, TS_NEARHOT, L"NEARHOT"},
    {TP_SPLITBUTTONDROPDOWN, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {TP_SEPARATOR, 0, L"SEPARATOR"},
    {TP_SEPARATOR, TS_NORMAL, L"NORMAL"},
    {TP_SEPARATOR, TS_HOT, L"HOT"},
    {TP_SEPARATOR, TS_PRESSED, L"PRESSED"},
    {TP_SEPARATOR, TS_DISABLED, L"DISABLED"},
    {TP_SEPARATOR, TS_CHECKED, L"CHECKED"},
    {TP_SEPARATOR, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SEPARATOR, TS_NEARHOT, L"NEARHOT"},
    {TP_SEPARATOR, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {TP_SEPARATORVERT, 0, L"SEPARATORVERT"},
    {TP_SEPARATORVERT, TS_NORMAL, L"NORMAL"},
    {TP_SEPARATORVERT, TS_HOT, L"HOT"},
    {TP_SEPARATORVERT, TS_PRESSED, L"PRESSED"},
    {TP_SEPARATORVERT, TS_DISABLED, L"DISABLED"},
    {TP_SEPARATORVERT, TS_CHECKED, L"CHECKED"},
    {TP_SEPARATORVERT, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_SEPARATORVERT, TS_NEARHOT, L"NEARHOT"},
    {TP_SEPARATORVERT, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {TP_DROPDOWNBUTTONGLYPH, 0, L"DROPDOWNBUTTONGLYPH"},
    {TP_DROPDOWNBUTTONGLYPH, TS_NORMAL, L"NORMAL"},
    {TP_DROPDOWNBUTTONGLYPH, TS_HOT, L"HOT"},
    {TP_DROPDOWNBUTTONGLYPH, TS_PRESSED, L"PRESSED"},
    {TP_DROPDOWNBUTTONGLYPH, TS_DISABLED, L"DISABLED"},
    {TP_DROPDOWNBUTTONGLYPH, TS_CHECKED, L"CHECKED"},
    {TP_DROPDOWNBUTTONGLYPH, TS_HOTCHECKED, L"HOTCHECKED"},
    {TP_DROPDOWNBUTTONGLYPH, TS_NEARHOT, L"NEARHOT"},
    {TP_DROPDOWNBUTTONGLYPH, TS_OTHERSIDEHOT, L"OTHERSIDEHOT"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTooltip[] = {
    {TTP_STANDARD, 0, L"STANDARD"},
    {TTP_STANDARD, TTSS_NORMAL, L"NORMAL"},
    {TTP_STANDARD, TTSS_LINK, L"LINK"},
    {TTP_STANDARDTITLE, 0, L"STANDARDTITLE"},
    {TTP_STANDARDTITLE, TTSS_NORMAL, L"NORMAL"},
    {TTP_STANDARDTITLE, TTSS_LINK, L"LINK"},
    {TTP_BALLOON, 0, L"BALLOON"},
    {TTP_BALLOON, TTBS_NORMAL, L"NORMAL"},
    {TTP_BALLOON, TTBS_LINK, L"LINK"},
    {TTP_BALLOONTITLE, 0, L"BALLOONTITLE"},
    {TTP_BALLOONTITLE, TTBS_NORMAL, L"NORMAL"},
    {TTP_BALLOONTITLE, TTBS_LINK, L"LINK"},
    {TTP_CLOSE, 0, L"CLOSE"},
    {TTP_CLOSE, TTCS_NORMAL, L"NORMAL"},
    {TTP_CLOSE, TTCS_HOT, L"HOT"},
    {TTP_CLOSE, TTCS_PRESSED, L"PRESSED"},
    {TTP_BALLOONSTEM, 0, L"BALLOONSTEM"},
    {TTP_BALLOONSTEM, TTBSS_POINTINGUPLEFTWALL, L"POINTINGUPLEFTWALL"},
    {TTP_BALLOONSTEM, TTBSS_POINTINGUPCENTERED, L"POINTINGUPCENTERED"},
    {TTP_BALLOONSTEM, TTBSS_POINTINGUPRIGHTWALL, L"POINTINGUPRIGHTWALL"},
    {TTP_BALLOONSTEM, TTBSS_POINTINGDOWNRIGHTWALL, L"POINTINGDOWNRIGHTWALL"},
    {TTP_BALLOONSTEM, TTBSS_POINTINGDOWNCENTERED, L"POINTINGDOWNCENTERED"},
    {TTP_BALLOONSTEM, TTBSS_POINTINGDOWNLEFTWALL, L"POINTINGDOWNLEFTWALL"},
    {TTP_WRENCH, 0, L"WRENCH"},
    {TTP_WRENCH, TTWS_NORMAL, L"NORMAL"},
    {TTP_WRENCH, TTWS_HOT, L"HOT"},
    {TTP_WRENCH, TTWS_PRESSED, L"PRESSED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTrackbar[] = {
    {TKP_TRACK, 0, L"TRACK"},
    {TKP_TRACK, TRS_NORMAL, L"NORMAL"},
    {TKP_TRACKVERT, 0, L"TRACKVERT"},
    {TKP_TRACKVERT, TRVS_NORMAL, L"NORMAL"},
    {TKP_THUMB, 0, L"THUMB"},
    {TKP_THUMB, TUS_NORMAL, L"NORMAL"},
    {TKP_THUMB, TUS_HOT, L"HOT"},
    {TKP_THUMB, TUS_PRESSED, L"PRESSED"},
    {TKP_THUMB, TUS_FOCUSED, L"FOCUSED"},
    {TKP_THUMB, TUS_DISABLED, L"DISABLED"},
    {TKP_THUMBBOTTOM, 0, L"THUMBBOTTOM"},
    {TKP_THUMBBOTTOM, TUBS_NORMAL, L"NORMAL"},
    {TKP_THUMBBOTTOM, TUBS_HOT, L"HOT"},
    {TKP_THUMBBOTTOM, TUBS_PRESSED, L"PRESSED"},
    {TKP_THUMBBOTTOM, TUBS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBBOTTOM, TUBS_DISABLED, L"DISABLED"},
    {TKP_THUMBTOP, 0, L"THUMBTOP"},
    {TKP_THUMBTOP, TUTS_NORMAL, L"NORMAL"},
    {TKP_THUMBTOP, TUTS_HOT, L"HOT"},
    {TKP_THUMBTOP, TUTS_PRESSED, L"PRESSED"},
    {TKP_THUMBTOP, TUTS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBTOP, TUTS_DISABLED, L"DISABLED"},
    {TKP_THUMBVERT, 0, L"THUMBVERT"},
    {TKP_THUMBVERT, TUVS_NORMAL, L"NORMAL"},
    {TKP_THUMBVERT, TUVS_HOT, L"HOT"},
    {TKP_THUMBVERT, TUVS_PRESSED, L"PRESSED"},
    {TKP_THUMBVERT, TUVS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBVERT, TUVS_DISABLED, L"DISABLED"},
    {TKP_THUMBLEFT, 0, L"THUMBLEFT"},
    {TKP_THUMBLEFT, TUVLS_NORMAL, L"NORMAL"},
    {TKP_THUMBLEFT, TUVLS_HOT, L"HOT"},
    {TKP_THUMBLEFT, TUVLS_PRESSED, L"PRESSED"},
    {TKP_THUMBLEFT, TUVLS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBLEFT, TUVLS_DISABLED, L"DISABLED"},
    {TKP_THUMBRIGHT, 0, L"THUMBRIGHT"},
    {TKP_THUMBRIGHT, TUVRS_NORMAL, L"NORMAL"},
    {TKP_THUMBRIGHT, TUVRS_HOT, L"HOT"},
    {TKP_THUMBRIGHT, TUVRS_PRESSED, L"PRESSED"},
    {TKP_THUMBRIGHT, TUVRS_FOCUSED, L"FOCUSED"},
    {TKP_THUMBRIGHT, TUVRS_DISABLED, L"DISABLED"},
    {TKP_TICS, 0, L"TICS"},
    {TKP_TICS, TSS_NORMAL, L"NORMAL"},
    {TKP_TICSVERT, 0, L"TICSVERT"},
    {TKP_TICSVERT, TSVS_NORMAL, L"NORMAL"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTraynotify[] = {
    {TNP_BACKGROUND, 0, L"BACKGROUND"},
    {TNP_ANIMBACKGROUND, 0, L"ANIMBACKGROUND"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classTreeview[] = {
    {TVP_TREEITEM, 0, L"TREEITEM"},
    {TVP_TREEITEM, TREIS_NORMAL, L"NORMAL"},
    {TVP_TREEITEM, TREIS_HOT, L"HOT"},
    {TVP_TREEITEM, TREIS_SELECTED, L"SELECTED"},
    {TVP_TREEITEM, TREIS_DISABLED, L"DISABLED"},
    {TVP_TREEITEM, TREIS_SELECTEDNOTFOCUS, L"SELECTEDNOTFOCUS"},
    {TVP_TREEITEM, TREIS_HOTSELECTED, L"HOTSELECTED"},
    {TVP_GLYPH, 0, L"GLYPH"},
    {TVP_GLYPH, GLPS_CLOSED, L"CLOSED"},
    {TVP_GLYPH, GLPS_OPENED, L"OPENED"},
    {TVP_BRANCH, 0, L"BRANCH"},
    {TVP_HOTGLYPH, 0, L"HOTGLYPH"},
    {TVP_HOTGLYPH, HGLPS_CLOSED, L"CLOSED"},
    {TVP_HOTGLYPH, HGLPS_OPENED, L"OPENED"},
    {0, 0, L""}
};

static const MSSTYLES_CLASS_MAP classWindow[] = {
    {WP_CAPTION, 0, L"CAPTION"},
    {WP_CAPTION, CS_ACTIVE, L"ACTIVE"},
    {WP_CAPTION, CS_INACTIVE, L"INACTIVE"},
    {WP_CAPTION, CS_DISABLED, L"DISABLED"},
    {WP_SMALLCAPTION, 0, L"SMALLCAPTION"},
    {WP_SMALLCAPTION, CS_ACTIVE, L"ACTIVE"},
    {WP_SMALLCAPTION, CS_INACTIVE, L"INACTIVE"},
    {WP_SMALLCAPTION, CS_DISABLED, L"DISABLED"},
    {WP_MINCAPTION, 0, L"MINCAPTION"},
    {WP_MINCAPTION, MNCS_ACTIVE, L"ACTIVE"},
    {WP_MINCAPTION, MNCS_INACTIVE, L"INACTIVE"},
    {WP_MINCAPTION, MNCS_DISABLED, L"DISABLED"},
    {WP_SMALLMINCAPTION, 0, L"SMALLMINCAPTION"},
    {WP_SMALLMINCAPTION, MNCS_ACTIVE, L"ACTIVE"},
    {WP_SMALLMINCAPTION, MNCS_INACTIVE, L"INACTIVE"},
    {WP_SMALLMINCAPTION, MNCS_DISABLED, L"DISABLED"},
    {WP_MAXCAPTION, 0, L"MAXCAPTION"},
    {WP_MAXCAPTION, MXCS_ACTIVE, L"ACTIVE"},
    {WP_MAXCAPTION, MXCS_INACTIVE, L"INACTIVE"},
    {WP_MAXCAPTION, MXCS_DISABLED, L"DISABLED"},
    {WP_SMALLMAXCAPTION, 0, L"SMALLMAXCAPTION"},
    {WP_SMALLMAXCAPTION, MXCS_ACTIVE, L"ACTIVE"},
    {WP_SMALLMAXCAPTION, MXCS_INACTIVE, L"INACTIVE"},
    {WP_SMALLMAXCAPTION, MXCS_DISABLED, L"DISABLED"},
    {WP_FRAMELEFT, 0, L"FRAMELEFT"},
    {WP_FRAMELEFT, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAMELEFT, FS_INACTIVE, L"INACTIVE"},
    {WP_FRAMERIGHT, 0, L"FRAMERIGHT"},
    {WP_FRAMERIGHT, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAMERIGHT, FS_INACTIVE, L"INACTIVE"},
    {WP_FRAMEBOTTOM, 0, L"FRAMEBOTTOM"},
    {WP_FRAMEBOTTOM, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAMEBOTTOM, FS_INACTIVE, L"INACTIVE"},
    {WP_SMALLFRAMELEFT, 0, L"SMALLFRAMELEFT"},
    {WP_SMALLFRAMELEFT, FS_ACTIVE, L"ACTIVE"},
    {WP_SMALLFRAMELEFT, FS_INACTIVE, L"INACTIVE"},
    {WP_SMALLFRAMERIGHT, 0, L"SMALLFRAMERIGHT"},
    {WP_SMALLFRAMERIGHT, FS_ACTIVE, L"ACTIVE"},
    {WP_SMALLFRAMERIGHT, FS_INACTIVE, L"INACTIVE"},
    {WP_SMALLFRAMEBOTTOM, 0, L"SMALLFRAMEBOTTOM"},
    {WP_SMALLFRAMEBOTTOM, FS_ACTIVE, L"ACTIVE"},
    {WP_SMALLFRAMEBOTTOM, FS_INACTIVE, L"INACTIVE"},
    {WP_SYSBUTTON, 0, L"SYSBUTTON"},
    {WP_SYSBUTTON, SBS_NORMAL, L"NORMAL"},
    {WP_SYSBUTTON, SBS_HOT, L"HOT"},
    {WP_SYSBUTTON, SBS_PUSHED, L"PUSHED"},
    {WP_SYSBUTTON, SBS_DISABLED, L"DISABLED"},
    {WP_MDISYSBUTTON, 0, L"MDISYSBUTTON"},
    {WP_MDISYSBUTTON, SBS_NORMAL, L"NORMAL"},
    {WP_MDISYSBUTTON, SBS_HOT, L"HOT"},
    {WP_MDISYSBUTTON, SBS_PUSHED, L"PUSHED"},
    {WP_MDISYSBUTTON, SBS_DISABLED, L"DISABLED"},
    {WP_MINBUTTON, 0, L"MINBUTTON"},
    {WP_MINBUTTON, MINBS_NORMAL, L"NORMAL"},
    {WP_MINBUTTON, MINBS_HOT, L"HOT"},
    {WP_MINBUTTON, MINBS_PUSHED, L"PUSHED"},
    {WP_MINBUTTON, MINBS_DISABLED, L"DISABLED"},
    {WP_MDIMINBUTTON, 0, L"MDIMINBUTTON"},
    {WP_MDIMINBUTTON, MINBS_NORMAL, L"NORMAL"},
    {WP_MDIMINBUTTON, MINBS_HOT, L"HOT"},
    {WP_MDIMINBUTTON, MINBS_PUSHED, L"PUSHED"},
    {WP_MDIMINBUTTON, MINBS_DISABLED, L"DISABLED"},
    {WP_MAXBUTTON, 0, L"MAXBUTTON"},
    {WP_MAXBUTTON, MAXBS_NORMAL, L"NORMAL"},
    {WP_MAXBUTTON, MAXBS_HOT, L"HOT"},
    {WP_MAXBUTTON, MAXBS_PUSHED, L"PUSHED"},
    {WP_MAXBUTTON, MAXBS_DISABLED, L"DISABLED"},
    {WP_CLOSEBUTTON, 0, L"CLOSEBUTTON"},
    {WP_CLOSEBUTTON, CBS_NORMAL, L"NORMAL"},
    {WP_CLOSEBUTTON, CBS_HOT, L"HOT"},
    {WP_CLOSEBUTTON, CBS_PUSHED, L"PUSHED"},
    {WP_CLOSEBUTTON, CBS_DISABLED, L"DISABLED"},
    {WP_SMALLCLOSEBUTTON, 0, L"SMALLCLOSEBUTTON"},
    {WP_SMALLCLOSEBUTTON, CBS_NORMAL, L"NORMAL"},
    {WP_SMALLCLOSEBUTTON, CBS_HOT, L"HOT"},
    {WP_SMALLCLOSEBUTTON, CBS_PUSHED, L"PUSHED"},
    {WP_SMALLCLOSEBUTTON, CBS_DISABLED, L"DISABLED"},
    {WP_MDICLOSEBUTTON, 0, L"MDICLOSEBUTTON"},
    {WP_MDICLOSEBUTTON, CBS_NORMAL, L"NORMAL"},
    {WP_MDICLOSEBUTTON, CBS_HOT, L"HOT"},
    {WP_MDICLOSEBUTTON, CBS_PUSHED, L"PUSHED"},
    {WP_MDICLOSEBUTTON, CBS_DISABLED, L"DISABLED"},
    {WP_RESTOREBUTTON, 0, L"RESTOREBUTTON"},
    {WP_RESTOREBUTTON, RBS_NORMAL, L"NORMAL"},
    {WP_RESTOREBUTTON, RBS_HOT, L"HOT"},
    {WP_RESTOREBUTTON, RBS_PUSHED, L"PUSHED"},
    {WP_RESTOREBUTTON, RBS_DISABLED, L"DISABLED"},
    {WP_MDIRESTOREBUTTON, 0, L"MDIRESTOREBUTTON"},
    {WP_MDIRESTOREBUTTON, RBS_NORMAL, L"NORMAL"},
    {WP_MDIRESTOREBUTTON, RBS_HOT, L"HOT"},
    {WP_MDIRESTOREBUTTON, RBS_PUSHED, L"PUSHED"},
    {WP_MDIRESTOREBUTTON, RBS_DISABLED, L"DISABLED"},
    {WP_HELPBUTTON, 0, L"HELPBUTTON"},
    {WP_HELPBUTTON, HBS_NORMAL, L"NORMAL"},
    {WP_HELPBUTTON, HBS_HOT, L"HOT"},
    {WP_HELPBUTTON, HBS_PUSHED, L"PUSHED"},
    {WP_HELPBUTTON, HBS_DISABLED, L"DISABLED"},
    {WP_MDIHELPBUTTON, 0, L"MDIHELPBUTTON"},
    {WP_MDIHELPBUTTON, HBS_NORMAL, L"NORMAL"},
    {WP_MDIHELPBUTTON, HBS_HOT, L"HOT"},
    {WP_MDIHELPBUTTON, HBS_PUSHED, L"PUSHED"},
    {WP_MDIHELPBUTTON, HBS_DISABLED, L"DISABLED"},
    {WP_HORZSCROLL, 0, L"HORZSCROLL"},
    {WP_HORZSCROLL, HSS_NORMAL, L"NORMAL"},
    {WP_HORZSCROLL, HSS_HOT, L"HOT"},
    {WP_HORZSCROLL, HSS_PUSHED, L"PUSHED"},
    {WP_HORZSCROLL, HSS_DISABLED, L"DISABLED"},
    {WP_HORZTHUMB, 0, L"HORZTHUMB"},
    {WP_HORZTHUMB, HTS_NORMAL, L"NORMAL"},
    {WP_HORZTHUMB, HTS_HOT, L"HOT"},
    {WP_HORZTHUMB, HTS_PUSHED, L"PUSHED"},
    {WP_HORZTHUMB, HTS_DISABLED, L"DISABLED"},
    {WP_VERTSCROLL, 0, L"VERTSCROLL"},
    {WP_VERTSCROLL, VSS_NORMAL, L"NORMAL"},
    {WP_VERTSCROLL, VSS_HOT, L"HOT"},
    {WP_VERTSCROLL, VSS_PUSHED, L"PUSHED"},
    {WP_VERTSCROLL, VSS_DISABLED, L"DISABLED"},
    {WP_VERTTHUMB, 0, L"VERTTHUMB"},
    {WP_VERTTHUMB, VTS_NORMAL, L"NORMAL"},
    {WP_VERTTHUMB, VTS_HOT, L"HOT"},
    {WP_VERTTHUMB, VTS_PUSHED, L"PUSHED"},
    {WP_VERTTHUMB, VTS_DISABLED, L"DISABLED"},
    {WP_DIALOG, 0, L"DIALOG"},
    {WP_CAPTIONSIZINGTEMPLATE, 0, L"CAPTIONSIZINGTEMPLATE"},
    {WP_SMALLCAPTIONSIZINGTEMPLATE, 0, L"SMALLCAPTIONSIZINGTEMPLATE"},
    {WP_FRAMELEFTSIZINGTEMPLATE, 0, L"FRAMELEFTSIZINGTEMPLATE"},
    {WP_SMALLFRAMELEFTSIZINGTEMPLATE, 0, L"SMALLFRAMELEFTSIZINGTEMPLATE"},
    {WP_FRAMERIGHTSIZINGTEMPLATE, 0, L"FRAMERIGHTSIZINGTEMPLATE"},
    {WP_SMALLFRAMERIGHTSIZINGTEMPLATE, 0, L"SMALLFRAMERIGHTSIZINGTEMPLATE"},
    {WP_FRAMEBOTTOMSIZINGTEMPLATE, 0, L"FRAMEBOTTOMSIZINGTEMPLATE"},
    {WP_SMALLFRAMEBOTTOMSIZINGTEMPLATE, 0, L"SMALLFRAMEBOTTOMSIZINGTEMPLATE"},
    {WP_FRAME, 0, L"FRAME"},
    {WP_FRAME, FS_ACTIVE, L"ACTIVE"},
    {WP_FRAME, FS_INACTIVE, L"INACTIVE"},
    {WP_BORDER, 0, L"BORDER"},
    {0, 0, L""}
};

/* Map class names to part/state maps */
static const MSSTYLES_CLASS_NAME mapClass[] = {
    {classButton, L"BUTTON"},
    {classClock, L"CLOCK"},
    {classCombobox, L"COMBOBOX"},
    {classEdit, L"EDIT"},
    {classExplorerbar, L"EXPLORERBAR"},
    {classHeader, L"HEADER"},
    {classListview, L"LISTVIEW"},
    {classMenu, L"MENU"},
    {classMenuband, L"MENUBAND"},
    {classNavigation, L"NAVIGATION"},
    {classPage, L"PAGE"},
    {classProgress, L"PROGRESS"},
    {classRebar, L"REBAR"},
    {classScrollbar, L"SCROLLBAR"},
    {classSpin, L"SPIN"},
    {classStartpanel, L"STARTPANEL"},
    {classStatus, L"STATUS"},
    {classTab, L"TAB"},
    {classTaskband, L"TASKBAND"},
    {classTaskbar, L"TASKBAR"},
    {classTaskdialog, L"TASKDIALOG"},
    {classToolbar, L"TOOLBAR"},
    {classTooltip, L"TOOLTIP"},
    {classTrackbar, L"TRACKBAR"},
    {classTraynotify, L"TRAYNOTIFY"},
    {classTreeview, L"TREEVIEW"},
    {classWindow, L"WINDOW"}
};

BOOL MSSTYLES_LookupPartState(LPCWSTR pszClass, LPCWSTR pszPart, LPCWSTR pszState, int *iPartId, int *iStateId)
{
    unsigned int i;
    const MSSTYLES_CLASS_MAP *map;

    *iPartId = 0;
    *iStateId = 0;
    for(i=0; i<ARRAY_SIZE(mapClass); i++) {
        if(!lstrcmpiW(mapClass[i].pszClass, pszClass)) {
            map = mapClass[i].lpMap;
            if(pszPart) {
                do {
                    if(map->dwStateID == 0 && !lstrcmpiW(map->szName, pszPart)) {
                        *iPartId = map->dwPartID;
                        break;
                    }
                } while(*((++map)->szName));
            }
            if(pszState) {
                if(pszPart && *iPartId == 0) {
                    break;
                }
                do {
                    if(pszPart) {
                        if(map->dwPartID == *iPartId && !lstrcmpiW(map->szName, pszState)) {
                            *iStateId = map->dwStateID;
                            break;
                        }
                    }
                    else {
                        if(!lstrcmpiW(map->szName, pszState)) {
                            *iStateId = map->dwStateID;
                            break;
                        }
                    }
                } while(*((++map)->szName));
            }
            break;
        }
    }
    if(pszPart && *iPartId == 0) {
        return FALSE;
    }
    if(pszState && *iStateId == 0) {
        return FALSE;
    }
    return TRUE;
}

static int __cdecl msstyles_property_map_compare(const void *a, const void *b)
{
    const MSSTYLES_PROPERTY_MAP *a_prop = a, *b_prop = b;
    INT size = ARRAY_SIZE(a_prop->szPropertyName);
    return CompareStringOrdinal(a_prop->szPropertyName, size, b_prop->szPropertyName, size, TRUE) - CSTR_EQUAL;
}

/**********************************************************************
 *      MSSTYLES_LookupProperty
 *
 * Find a property ID from name
 *
 * PARAMS
 *     pszPropertyName     Name of property to lookup
 *     dwPrimitive         Location to store primitive type of property
 *     dwId                Location to store ID of property
 *
 * RETURNS
 *     FALSE if value is not found, TRUE otherwise
 */
BOOL MSSTYLES_LookupProperty(LPCWSTR pszPropertyName, int *dwPrimitive, int *dwId)
{
    MSSTYLES_PROPERTY_MAP key = {{0}}, *found;
    SIZE_T len;

    if ((len = wcslen(pszPropertyName)) >= ARRAY_SIZE(key.szPropertyName)) return FALSE;
    memcpy(key.szPropertyName, pszPropertyName, len * sizeof(WCHAR));

    if (!(found = bsearch(&key, mapProperty, ARRAY_SIZE(mapProperty),
                          sizeof(*mapProperty), msstyles_property_map_compare)))
        return FALSE;

    if (dwPrimitive) *dwPrimitive = found->dwPrimitiveType;
    if (dwId) *dwId = found->dwPropertyID;
    return TRUE;
}

/**********************************************************************
 *      MSSTYLES_LookupEnum
 *
 * Lookup the value for an enumeration
 *
 * PARAMS
 *     pszValueName        Value name to lookup
 *     dwEnum              Enumeration property ID to search
 *     dwValue             Location to store value
 *
 * RETURNS
 *     FALSE if value is not found, TRUE otherwise
 */
BOOL MSSTYLES_LookupEnum(LPCWSTR pszValueName, int dwEnum, int *dwValue)
{
    DWORD item = 0;
    /* Locate the enum block */
    while(*mapEnum[item].szValueName && mapEnum[item].dwEnum != dwEnum) item++;
    /* Now find the value in that block */
    while(*mapEnum[item].szValueName && mapEnum[item].dwEnum == dwEnum) {
        if(!lstrcmpiW(mapEnum[item].szValueName, pszValueName)) {
            if(dwValue) *dwValue = mapEnum[item].dwValue;
            return TRUE;
        }
        item++;
    }
    return FALSE;
}
