package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteProfile invokes the vcs.DeleteProfile API synchronously
func (client *Client) DeleteProfile(request *DeleteProfileRequest) (response *DeleteProfileResponse, err error) {
	response = CreateDeleteProfileResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteProfileWithChan invokes the vcs.DeleteProfile API asynchronously
func (client *Client) DeleteProfileWithChan(request *DeleteProfileRequest) (<-chan *DeleteProfileResponse, <-chan error) {
	responseChan := make(chan *DeleteProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteProfileWithCallback invokes the vcs.DeleteProfile API asynchronously
func (client *Client) DeleteProfileWithCallback(request *DeleteProfileRequest, callback func(response *DeleteProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteProfileResponse
		var err error
		defer close(result)
		response, err = client.DeleteProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteProfileRequest is the request struct for api DeleteProfile
type DeleteProfileRequest struct {
	*requests.RpcRequest
	IsvSubId  string           `position:"Body" name:"IsvSubId"`
	CorpId    string           `position:"Body" name:"CorpId"`
	ProfileId requests.Integer `position:"Body" name:"ProfileId"`
}

// DeleteProfileResponse is the response struct for api DeleteProfile
type DeleteProfileResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteProfileRequest creates a request to invoke DeleteProfile API
func CreateDeleteProfileRequest() (request *DeleteProfileRequest) {
	request = &DeleteProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "DeleteProfile", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteProfileResponse creates a response to parse from DeleteProfile response
func CreateDeleteProfileResponse() (response *DeleteProfileResponse) {
	response = &DeleteProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
