package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SendVerificationMessage invokes the subscription.SendVerificationMessage API synchronously
// api document: https://help.aliyun.com/api/subscription/sendverificationmessage.html
func (client *Client) SendVerificationMessage(request *SendVerificationMessageRequest) (response *SendVerificationMessageResponse, err error) {
	response = CreateSendVerificationMessageResponse()
	err = client.DoAction(request, response)
	return
}

// SendVerificationMessageWithChan invokes the subscription.SendVerificationMessage API asynchronously
// api document: https://help.aliyun.com/api/subscription/sendverificationmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendVerificationMessageWithChan(request *SendVerificationMessageRequest) (<-chan *SendVerificationMessageResponse, <-chan error) {
	responseChan := make(chan *SendVerificationMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SendVerificationMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SendVerificationMessageWithCallback invokes the subscription.SendVerificationMessage API asynchronously
// api document: https://help.aliyun.com/api/subscription/sendverificationmessage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) SendVerificationMessageWithCallback(request *SendVerificationMessageRequest, callback func(response *SendVerificationMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SendVerificationMessageResponse
		var err error
		defer close(result)
		response, err = client.SendVerificationMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SendVerificationMessageRequest is the request struct for api SendVerificationMessage
type SendVerificationMessageRequest struct {
	*requests.RpcRequest
	ContactId requests.Integer `position:"Query" name:"ContactId"`
	Type      requests.Integer `position:"Query" name:"Type"`
	Locale    string           `position:"Query" name:"Locale"`
}

// SendVerificationMessageResponse is the response struct for api SendVerificationMessage
type SendVerificationMessageResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    int    `json:"Result" xml:"Result"`
}

// CreateSendVerificationMessageRequest creates a request to invoke SendVerificationMessage API
func CreateSendVerificationMessageRequest() (request *SendVerificationMessageRequest) {
	request = &SendVerificationMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "SendVerificationMessage", "", "")
	return
}

// CreateSendVerificationMessageResponse creates a response to parse from SendVerificationMessage response
func CreateSendVerificationMessageResponse() (response *SendVerificationMessageResponse) {
	response = &SendVerificationMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
