package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeployedAlgorithmModels invokes the opensearch.ListDeployedAlgorithmModels API synchronously
func (client *Client) ListDeployedAlgorithmModels(request *ListDeployedAlgorithmModelsRequest) (response *ListDeployedAlgorithmModelsResponse, err error) {
	response = CreateListDeployedAlgorithmModelsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeployedAlgorithmModelsWithChan invokes the opensearch.ListDeployedAlgorithmModels API asynchronously
func (client *Client) ListDeployedAlgorithmModelsWithChan(request *ListDeployedAlgorithmModelsRequest) (<-chan *ListDeployedAlgorithmModelsResponse, <-chan error) {
	responseChan := make(chan *ListDeployedAlgorithmModelsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeployedAlgorithmModels(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeployedAlgorithmModelsWithCallback invokes the opensearch.ListDeployedAlgorithmModels API asynchronously
func (client *Client) ListDeployedAlgorithmModelsWithCallback(request *ListDeployedAlgorithmModelsRequest, callback func(response *ListDeployedAlgorithmModelsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeployedAlgorithmModelsResponse
		var err error
		defer close(result)
		response, err = client.ListDeployedAlgorithmModels(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeployedAlgorithmModelsRequest is the request struct for api ListDeployedAlgorithmModels
type ListDeployedAlgorithmModelsRequest struct {
	*requests.RoaRequest
	AlgorithmType    string           `position:"Query" name:"algorithmType"`
	InServiceOnly    requests.Boolean `position:"Query" name:"inServiceOnly"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ListDeployedAlgorithmModelsResponse is the response struct for api ListDeployedAlgorithmModels
type ListDeployedAlgorithmModelsResponse struct {
	*responses.BaseResponse
	RequestId string                                    `json:"requestId" xml:"requestId"`
	Result    []ResultItemInListDeployedAlgorithmModels `json:"result" xml:"result"`
}

// CreateListDeployedAlgorithmModelsRequest creates a request to invoke ListDeployedAlgorithmModels API
func CreateListDeployedAlgorithmModelsRequest() (request *ListDeployedAlgorithmModelsRequest) {
	request = &ListDeployedAlgorithmModelsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListDeployedAlgorithmModels", "/v4/openapi/app-groups/[appGroupIdentity]/deployed-algorithm-models", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDeployedAlgorithmModelsResponse creates a response to parse from ListDeployedAlgorithmModels response
func CreateListDeployedAlgorithmModelsResponse() (response *ListDeployedAlgorithmModelsResponse) {
	response = &ListDeployedAlgorithmModelsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
