package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitFpFileDeleteJob invokes the mts.SubmitFpFileDeleteJob API synchronously
func (client *Client) SubmitFpFileDeleteJob(request *SubmitFpFileDeleteJobRequest) (response *SubmitFpFileDeleteJobResponse, err error) {
	response = CreateSubmitFpFileDeleteJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitFpFileDeleteJobWithChan invokes the mts.SubmitFpFileDeleteJob API asynchronously
func (client *Client) SubmitFpFileDeleteJobWithChan(request *SubmitFpFileDeleteJobRequest) (<-chan *SubmitFpFileDeleteJobResponse, <-chan error) {
	responseChan := make(chan *SubmitFpFileDeleteJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitFpFileDeleteJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitFpFileDeleteJobWithCallback invokes the mts.SubmitFpFileDeleteJob API asynchronously
func (client *Client) SubmitFpFileDeleteJobWithCallback(request *SubmitFpFileDeleteJobRequest, callback func(response *SubmitFpFileDeleteJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitFpFileDeleteJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitFpFileDeleteJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitFpFileDeleteJobRequest is the request struct for api SubmitFpFileDeleteJob
type SubmitFpFileDeleteJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	FpDBId               string           `position:"Query" name:"FpDBId"`
	UserData             string           `position:"Query" name:"UserData"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId           string           `position:"Query" name:"PipelineId"`
	FileIds              string           `position:"Query" name:"FileIds"`
}

// SubmitFpFileDeleteJobResponse is the response struct for api SubmitFpFileDeleteJob
type SubmitFpFileDeleteJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitFpFileDeleteJobRequest creates a request to invoke SubmitFpFileDeleteJob API
func CreateSubmitFpFileDeleteJobRequest() (request *SubmitFpFileDeleteJobRequest) {
	request = &SubmitFpFileDeleteJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitFpFileDeleteJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitFpFileDeleteJobResponse creates a response to parse from SubmitFpFileDeleteJob response
func CreateSubmitFpFileDeleteJobResponse() (response *SubmitFpFileDeleteJobResponse) {
	response = &SubmitFpFileDeleteJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
