package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAlbumsByNames invokes the cloudphoto.GetAlbumsByNames API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/getalbumsbynames.html
func (client *Client) GetAlbumsByNames(request *GetAlbumsByNamesRequest) (response *GetAlbumsByNamesResponse, err error) {
	response = CreateGetAlbumsByNamesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAlbumsByNamesWithChan invokes the cloudphoto.GetAlbumsByNames API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getalbumsbynames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAlbumsByNamesWithChan(request *GetAlbumsByNamesRequest) (<-chan *GetAlbumsByNamesResponse, <-chan error) {
	responseChan := make(chan *GetAlbumsByNamesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAlbumsByNames(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAlbumsByNamesWithCallback invokes the cloudphoto.GetAlbumsByNames API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getalbumsbynames.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAlbumsByNamesWithCallback(request *GetAlbumsByNamesRequest, callback func(response *GetAlbumsByNamesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAlbumsByNamesResponse
		var err error
		defer close(result)
		response, err = client.GetAlbumsByNames(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAlbumsByNamesRequest is the request struct for api GetAlbumsByNames
type GetAlbumsByNamesRequest struct {
	*requests.RpcRequest
	LibraryId string    `position:"Query" name:"LibraryId"`
	Name      *[]string `position:"Query" name:"Name"  type:"Repeated"`
	StoreName string    `position:"Query" name:"StoreName"`
}

// GetAlbumsByNamesResponse is the response struct for api GetAlbumsByNames
type GetAlbumsByNamesResponse struct {
	*responses.BaseResponse
	Code      string  `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Action    string  `json:"Action" xml:"Action"`
	Albums    []Album `json:"Albums" xml:"Albums"`
}

// CreateGetAlbumsByNamesRequest creates a request to invoke GetAlbumsByNames API
func CreateGetAlbumsByNamesRequest() (request *GetAlbumsByNamesRequest) {
	request = &GetAlbumsByNamesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "GetAlbumsByNames", "cloudphoto", "openAPI")
	return
}

// CreateGetAlbumsByNamesResponse creates a response to parse from GetAlbumsByNames response
func CreateGetAlbumsByNamesResponse() (response *GetAlbumsByNamesResponse) {
	response = &GetAlbumsByNamesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
