package session

import (
	"context"
	"errors"

	"github.com/ProtonMail/gluon/imap/command"
	"github.com/ProtonMail/gluon/internal/contexts"
	"github.com/ProtonMail/gluon/internal/response"
	"github.com/ProtonMail/gluon/internal/state"
	"github.com/ProtonMail/gluon/profiling"
	"github.com/ProtonMail/gluon/reporter"
)

func (s *Session) handleFetch(ctx context.Context, tag string, cmd *command.Fetch, mailbox *state.Mailbox, ch chan response.Response) (response.Response, error) {
	if contexts.IsUID(ctx) {
		profiling.Start(ctx, profiling.CmdTypeUIDFetch)
		defer profiling.Stop(ctx, profiling.CmdTypeUIDFetch)
	} else {
		profiling.Start(ctx, profiling.CmdTypeFetch)
		defer profiling.Stop(ctx, profiling.CmdTypeFetch)
	}

	if err := mailbox.Fetch(ctx, cmd, ch); errors.Is(err, state.ErrNoSuchMessage) {
		return response.Bad(tag).WithError(err), nil
	} else if err != nil {
		if shouldReportIMAPCommandError(err) {
			// there's no events like this in sentry so far.
			reporter.MessageWithContext(ctx,
				"Failed to fetch messages",
				reporter.Context{"error": err},
			)
		}

		return nil, err
	}

	var items []response.Item

	if mailbox.ExpungeIssued() {
		items = append(items, response.ItemExpungeIssued())
	}

	return response.Ok(tag).
		WithItems(items...).
		WithMessage(okMessage(ctx)), nil
}
