// Copyright 2016 Activision Publishing, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the Software
// is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#ifndef CUBEMAP_COEFFS_H
#define CUBEMAP_COEFFS_H

const float low_quality_coeffs[7][5][6][4] = { { { { 0.0002037563f, 0.0045063655f, -0.0016408688f, 0.00012037493f }, { -9.1834951e-05f, -0.008947532f, -8.1524405e-05f, -3.9080094e-05f }, { -2.6038267e-05f, -6.8409667e-05f, 7.2175702e-05f, 0.25492775f }, { -9.9426044e-05f, 0.0025427756f, -0.00074437925f, 1.1773191e-05f }, { -3.2668211e-05f, 0.0026930659f, -4.824934e-05f, -0.0006835048f }, { -0.0002864144f, -0.0032220854f, 0.0021558286f, -0.00014573736f } }, { { 0.00030683201f, 0.0026819548f, -0.00060011756f, -0.0067169226f }, { -0.0030993251f, 0.0098575575f, 0.0022416671f, -8.9075401e-05f }, { 0.00052405626f, 0.00057860515f, 0.00011654518f, -0.048018609f }, { 0.00010850967f, -0.0088443512f, -0.0018168095f, 8.6633128e-05f }, { 0.003333989f, -0.0050956447f, -8.0414612e-05f, 0.0049721239f }, { -4.0961436e-05f, -8.5486984e-05f, 0.0058683066f, 2.2978359e-05f } }, { { 0.99999993f, 0.99998625f, 0.99999847f, 0.99997743f }, { 0.99999519f, 0.99991138f, 0.99999748f, 1.0f }, { 0.99999986f, 0.99999983f, 0.99999999f, 0.96576708f }, { 0.99999999f, 0.99995765f, 0.99999807f, 1.0f }, { 0.99999444f, 0.99998339f, 1.0f, 0.99998741f }, { 0.99999996f, 0.99999481f, 0.99998046f, 0.99999999f } }, { { -0.32267524f, -0.65409377f, -1.4666488f, 0.87153305f }, { -1.264365f, 0.89880861f, -1.2245906f, -0.88501403f }, { -0.31118682f, -0.086150323f, -0.58811532f, 1.1317711f }, { -1.2193493f, 1.250379f, -1.0871569f, -0.12694096f }, { -0.4012249f, -0.47436307f, -0.59661001f, 2.7313005f }, { -1.3109856f, 0.60929855f, 0.55672643f, -0.39880018f } }, { { 0.93273157f, 0.59530745f, 1.1994788f, 0.19102276f }, { 1.2272239f, 0.23245736f, 1.2577607f, 2.5491008f }, { 1.1210098f, 0.83074953f, 1.3049282f, -0.001940633f }, { 1.5839111f, 0.10520816f, 1.150458f, 2.3251789f }, { 0.688692f, 0.59807498f, 1.3374877f, 0.095746692f }, { 1.3054173f, 0.36604721f, 0.065870226f, 1.6496907f } } }, { { { 0.10348445f, -4.6771514e-07f, -0.011513131f, 8.8921052e-05f }, { -0.042152043f, 0.013143535f, 0.00029120107f, 0.036661611f }, { -0.04516036f, 0.011438473f, -0.0099289792f, -0.011707897f }, { -0.034779497f, 0.0090981166f, -5.4202726e-05f, 0.038592793f }, { -0.0071967376f, -0.0056614418f, -0.012278945f, 0.0056867462f }, { -0.037678514f, 0.011570177f, 0.00029044557f, 0.038583909f } }, { { 0.048320869f, 1.4603673e-05f, 0.0092672368f, 0.00033289199f }, { 0.0071001761f, -0.0090106091f, -0.0027305905f, -0.00221479f }, { -0.0027204116f, 0.00017921587f, 0.015296357f, -0.00010306185f }, { 0.0079350203f, -0.014772431f, -1.2410913e-05f, -0.0062296897f }, { 0.025087691f, 0.00086046427f, 0.015034685f, -0.00078224706f }, { 0.00074587265f, -0.014602074f, 0.00027338224f, -0.012848552f } }, { { 0.99345662f, 1.0f, 0.99989078f, 0.99999994f }, { 0.99908598f, 0.99987302f, 0.99999623f, 0.99932528f }, { 0.99897605f, 0.99993456f, 0.9998337f, 0.99993145f }, { 0.99936351f, 0.99984949f, 1.0f, 0.9992356f }, { 0.99965935f, 0.9999836f, 0.99981158f, 0.99998352f }, { 0.99928963f, 0.99982644f, 0.99999992f, 0.99917276f } }, { { 3.6882765f, 0.15963861f, 0.55983965f, 0.4075649f }, { 2.1169304f, 0.56463157f, 0.52957047f, 2.0117964f }, { 3.1080461f, 0.09682931f, 0.42125986f, 0.089254784f }, { 1.4247315f, 0.48411378f, -0.17039102f, 1.7431674f }, { 4.0339531f, 0.14046159f, 0.89848909f, 0.011661811f }, { 1.9787852f, 0.61750145f, 0.63514194f, 1.9359003f } }, { { 0.030848793f, 1.4472743f, 1.4356825f, 1.4078009f }, { 0.37639678f, 1.0793106f, 1.1945413f, 0.43983395f }, { 0.27451605f, 1.5256415f, 1.016769f, 1.4850575f }, { 0.54580883f, 1.1332879f, 3.1331784f, 0.60772955f }, { 0.11785158f, 1.3928946f, 0.94998805f, 1.0377182f }, { 0.2842108f, 1.0026911f, 1.9064553f, 0.27147854f } } }, { { { -0.096789259f, 0.10326967f, 0.0011799959f, -0.03077328f }, { 0.08342021f, 0.033260738f, -0.00045864451f, -0.021450568f }, { -0.093369441f, -0.05807574f, -0.033745214f, 0.023817208f }, { 0.056747754f, 0.031140512f, 0.00019362509f, -0.023727797f }, { -0.084538386f, -0.040545412f, -0.0076838784f, 0.03424599f }, { 0.074312056f, 0.027619787f, 0.0015509082f, -0.031043528f } }, { { -0.0085160473f, -0.012179292f, 0.0049910118f, 0.020224799f }, { 0.022559343f, -0.016273333f, -0.0069382139f, 0.00058083224f }, { -0.001115062f, 0.035002846f, -0.0038974773f, -0.039378629f }, { 0.0014921617f, -0.00058523872f, -0.0011606685f, 0.02807528f }, { -0.021454809f, 0.052957852f, -0.0022083677f, -0.027956663f }, { -0.016486487f, -0.0040233682f, 0.00029949558f, 0.021924605f } }, { { 0.99526846f, 0.99457883f, 0.99998685f, 0.99932175f }, { 0.99625908f, 0.99931422f, 0.99997583f, 0.99976974f }, { 0.99563091f, 0.99769836f, 0.99942287f, 0.99894047f }, { 0.99838743f, 0.99951485f, 0.99999931f, 0.99932416f }, { 0.99618922f, 0.99777329f, 0.99996804f, 0.99902234f }, { 0.99709875f, 0.9996104f, 0.99999875f, 0.99927754f } }, { { 3.0342011f, 4.8022834f, 1.3814123f, 1.5280754f }, { 2.9043837f, 1.7325954f, 1.422223f, 2.0569263f }, { 3.0358722f, 5.3331504f, 1.5680146f, 1.6079289f }, { 3.2062833f, 1.5368069f, 1.0484709f, 1.5399477f }, { 2.4471653f, 4.0916696f, 1.5060688f, 1.5807009f }, { 2.6932695f, 1.5161537f, 1.3991175f, 1.6301918f } }, { { 0.50787578f, 0.17735471f, 1.4006765f, 1.0878482f }, { 0.69514518f, 1.6765187f, 1.2224869f, 1.3461327f }, { 0.71381288f, 0.17509216f, 1.2712934f, 0.94575821f }, { 1.1817337f, 1.796984f, 1.8671538f, 1.5708691f }, { 0.55621228f, 0.38291359f, 1.4128781f, 0.82625349f }, { 0.72441647f, 1.005794f, 1.5522327f, 1.6032524f } } }, { { { -0.00041301094f, -0.095882618f, 0.26932618f, -0.25137214f }, { 0.13737415f, -0.12694293f, -0.0090389663f, 0.07227623f }, { -0.005236407f, -0.0072961249f, 0.27776083f, -0.19536433f }, { 0.12781899f, -0.042881667f, -0.095979169f, 0.088937396f }, { 0.037496084f, -0.090547583f, 0.22112334f, -0.21930294f }, { 0.13353408f, -0.084346121f, -0.011365728f, 0.043459312f } }, { { -0.05799135f, -0.048612281f, 0.02422989f, 0.015536268f }, { -0.083144241f, 0.039381032f, 0.018705957f, 0.029297922f }, { 0.026364989f, -0.041927591f, 0.036718516f, 0.0050376168f }, { -0.11562256f, 0.043521976f, -0.014481644f, 0.01529188f }, { -0.047859898f, -0.057779647f, -0.053171395f, -0.0063193506f }, { -0.028781196f, 0.041145059f, -0.00018523142f, 0.053524246f } }, { { 0.998317f, 0.99420489f, 0.96274416f, 0.96776581f }, { 0.98702349f, 0.99112796f, 0.99978417f, 0.99695425f }, { 0.99963867f, 0.99909401f, 0.95994827f, 0.9807178f }, { 0.98503489f, 0.99813175f, 0.99527799f, 0.99591983f }, { 0.99815003f, 0.99421459f, 0.97379529f, 0.97563635f }, { 0.99062621f, 0.99558667f, 0.99993539f, 0.99762039f } }, { { 2.3221943f, 2.5383575f, 4.3177232f, 4.2016467f }, { 3.1936529f, 3.0443024f, 2.548962f, 2.7636456f }, { 2.5923827f, 2.3497949f, 4.2471014f, 4.1975975f }, { 3.3748785f, 3.2836577f, 2.9220414f, 2.7175317f }, { 2.3290083f, 2.5560991f, 4.3572168f, 4.4372585f }, { 3.1512055f, 3.2863613f, 2.4475378f, 2.3620003f } }, { { 0.62833231f, 0.52378061f, 0.55845033f, 0.64883444f }, { 0.76905594f, 1.1017801f, 1.8714048f, 1.5664383f }, { 1.5283278f, 1.2423369f, 0.62247385f, 1.0341956f }, { 0.77484548f, 1.6866409f, 1.0307399f, 1.4224643f }, { 0.85627405f, 0.72516079f, 0.70094339f, 0.7547877f }, { 1.202842f, 1.7650605f, 1.5938526f, 0.97031337f } } }, { { { -0.078108035f, -0.049518839f, 0.26950139f, -0.51522828f }, { 0.43015518f, -0.045354216f, 0.094550359f, -0.2395012f }, { -0.079900522f, -0.082582235f, 0.24464909f, -0.5234896f }, { 0.38422945f, -0.023833644f, 0.07334288f, -0.22827313f }, { -0.075370379f, -0.05156594f, 0.19883182f, -0.45064193f }, { 0.46285395f, 0.021899343f, 0.10155287f, -0.25974773f } }, { { 0.068681419f, -0.32175988f, 0.15143274f, -0.0066205388f }, { -0.17060226f, 0.31051319f, -0.080511981f, -0.1593209f }, { 0.08167251f, -0.32517768f, 0.10937023f, -0.06941926f }, { -0.14580685f, 0.32474959f, -0.081718057f, -0.11068378f }, { 0.053961394f, -0.29322836f, 0.10408839f, -0.02243046f }, { -0.030598471f, 0.34332821f, -0.091528353f, -0.16299796f } }, { { 0.99457629f, 0.9455255f, 0.95101899f, 0.85702741f }, { 0.88648824f, 0.94948647f, 0.99225906f, 0.95773484f }, { 0.99345131f, 0.94204015f, 0.96342357f, 0.84919939f }, { 0.9116513f, 0.94549969f, 0.99395321f, 0.96728511f }, { 0.99569447f, 0.95465076f, 0.97449039f, 0.89242295f }, { 0.88590629f, 0.93896015f, 0.99061071f, 0.95182077f } }, { { 3.6380949f, 4.1749529f, 4.1351439f, 4.8389883f }, { 5.256362f, 4.2027959f, 3.6096892f, 3.9848645f }, { 3.5689427f, 3.8620869f, 4.0023981f, 4.8268584f }, { 5.1128497f, 4.468934f, 3.5851596f, 4.047485f }, { 3.7014988f, 4.1310058f, 4.2446872f, 5.3049323f }, { 4.8659881f, 4.3133002f, 3.4582876f, 3.8863853f } }, { { 1.6276316f, 0.7747672f, 1.0485958f, 0.73900224f }, { 0.72010795f, 0.65403093f, 1.3179681f, 0.65610074f }, { 1.5881174f, 0.55108527f, 1.0509725f, 0.72153362f }, { 1.1389053f, 1.0905142f, 1.6661598f, 0.9987548f }, { 1.977914f, 0.83001686f, 1.0571479f, 0.80249183f }, { 0.94107069f, 0.80840873f, 0.95379751f, 0.50386367f } } }, { { { 0.015525428f, -0.48038019f, -0.021799698f, 0.43629156f }, { 0.045681247f, -0.55039024f, -0.54573329f, 0.57817853f }, { -0.045869129f, -0.42209953f, -0.14040829f, 0.37787106f }, { 0.66327604f, -0.70070311f, -0.55261635f, 0.63446196f }, { 0.015397585f, -0.43515767f, -0.021927897f, 0.4203714f }, { 0.85681772f, -0.65394729f, -0.67557236f, 0.60104142f } }, { { -0.31503888f, -0.26745648f, 0.26817896f, 0.26548747f }, { -0.93282124f, -0.033621213f, 0.68374802f, -0.10858524f }, { -0.21723689f, -0.17935495f, 0.38521982f, 0.2578335f }, { -0.39913153f, 0.23555359f, 0.59589456f, -0.19075103f }, { -0.28851798f, -0.24142459f, 0.28279261f, 0.24766617f }, { -0.29435977f, -0.25850549f, 0.57790878f, -0.200546f } }, { { 0.94895177f, 0.83528552f, 0.96312243f, 0.85974768f }, { 0.35743218f, 0.8342303f, 0.48442112f, 0.80865248f }, { 0.97504059f, 0.88863029f, 0.9120807f, 0.88923301f }, { 0.63305523f, 0.67344611f, 0.58268761f, 0.74904744f }, { 0.95735066f, 0.86738225f, 0.9589304f, 0.87289711f }, { 0.42333878f, 0.71100482f, 0.45784651f, 0.77364753f } }, { { 5.3641275f, 5.2550422f, 5.3103777f, 5.2851215f }, { 5.2657045f, 6.2095784f, 6.9549598f, 4.9205516f }, { 5.163385f, 5.3141038f, 4.9907618f, 5.3583852f }, { 6.1257061f, 6.1102338f, 6.9549598f, 5.3129951f }, { 5.3138838f, 5.3257842f, 5.3133783f, 5.2687156f }, { 5.8915091f, 6.153324f, 6.9549598f, 4.9568971f } }, { { 3.1221918f, 1.1882615f, 2.6991784f, 1.1185048f }, { -0.2322432f, -0.16590163f, 0.088416958f, 0.057399579f }, { 3.4395383f, 1.5836276f, 2.6242352f, 1.2873336f }, { -0.23767634f, -0.79425452f, 0.20477899f, 0.40461516f }, { 2.2521751f, 1.1933374f, 2.3309484f, 1.0185309f }, { -0.099258385f, -0.2173726f, 0.0736866f, 0.15470436f } } }, { { { 0.066050217f, -0.33053278f, -0.13771479f, 0.33278465f }, { 0.00084467977f, -0.50077778f, -0.30083482f, 0.6494273f }, { 0.24880159f, -0.30354993f, -0.15417892f, 0.38203296f }, { -0.073325098f, -0.4778777f, 0.10779844f, 0.66683723f }, { 0.15703809f, -0.36335455f, -0.15657631f, 0.35926503f }, { 0.26127617f, -0.29524368f, -0.14490804f, 0.65461301f } }, { { -0.57970022f, -0.33939622f, 0.72169742f, 0.320959f }, { -0.38698206f, -0.12730306f, 0.65810895f, 0.026509232f }, { -0.6199708f, -0.34745658f, 0.68683659f, 0.34547285f }, { -0.3613378f, -0.14006845f, 0.65917895f, 0.038446867f }, { -0.57778101f, -0.35057776f, 0.57837882f, 0.36488991f }, { -0.50051482f, -0.019174387f, 0.50816239f, 0.02682636f } }, { { 0.8121484f, 0.88065787f, 0.67837119f, 0.88670158f }, { 0.92208686f, 0.85616327f, 0.69021085f, -0.75996148f }, { 0.74413303f, 0.88720424f, 0.71027063f, 0.85714604f }, { 0.92954743f, 0.86718726f, 0.74421946f, -0.74421095f }, { 0.80094204f, 0.86317363f, 0.8006009f, 0.85894353f }, { 0.82536033f, 0.95522956f, 0.8489833f, -0.75548802f } }, { { 5.7725061f, 5.1565901f, 5.6224483f, 5.0847054f }, { 5.7717118f, 6.4180057f, 6.9797014f, -0.03290957f }, { 5.7847117f, 5.2015529f, 5.614561f, 5.2019388f }, { 6.2613999f, 6.5807982f, 6.9797014f, -0.032764603f }, { 5.823775f, 5.2332343f, 5.826694f, 5.197143f }, { 6.3463188f, 5.8174311f, 6.9797014f, -0.032766769f } }, { { 2.96787f, 1.3557735f, 2.0749129f, 1.3066609f }, { -0.92782801f, 0.0079162579f, -0.33479446f, 2.699659e-05f }, { 2.1997063f, 3.1083252f, 2.6810949f, 1.8276262f }, { -0.48654719f, -0.10954189f, -0.32175132f, 5.490092e-05f }, { 3.1970446f, 1.787085f, 3.062849f, 1.6274811f }, { -0.78882801f, -0.34050184f, -0.59962127f, 3.6554198e-05f } } } };

const float high_quality_coeffs[7][5][3][24][4] = { { { { { -4.8355339e-06f, -4.4902569e-05f, -9.2632249e-05f, -0.00053773136f }, { 0.0040143823f, -0.00060900339f, -0.0095301923f, -0.0053956011f }, { -0.0005923892f, -3.6901978e-05f, -5.6694857e-06f, -0.00017018564f }, { 0.0012441402f, 0.02236187f, 0.022751769f, 0.0062788948f }, { 0.00013810055f, -2.2709815e-05f, 0.0054849671f, -1.6599195e-05f }, { -0.020320408f, -0.017066319f, -0.017457746f, 0.022910628f }, { 0.00024171724f, 9.7419073e-05f, -0.00047804272f, -0.00010093683f }, { 7.6988167e-05f, 1.8551597e-05f, -5.7692813e-05f, -3.332362e-05f }, { -0.00062766208f, 2.713742e-05f, 0.00026511682f, 2.3841873e-05f }, { -0.00043656844f, 0.0028645469f, 0.0049817085f, 0.0080221478f }, { -3.3210444e-05f, -8.0852386e-05f, -2.2111492e-06f, -8.4430827e-05f }, { 0.010967284f, 0.018811225f, 0.017569463f, -0.0046944996f }, { -0.00018391248f, -0.00010462174f, -0.00017726f, -0.00018490133f }, { 0.00012591989f, 0.015965386f, 0.015964059f, -0.0078018431f }, { -0.006125333f, -8.2224165e-05f, -0.00020500151f, -0.00025207244f }, { -0.00016320041f, -0.0001279242f, 0.00014038799f, 8.1359421e-05f }, { -0.00064341098f, -0.0011265496f, -0.0011634792f, -0.00081607159f }, { 0.00089294825f, 0.0061923653f, 0.0052662392f, -0.00058227469f }, { -2.4001308e-05f, -1.3534224e-05f, -1.4720478e-05f, -2.5120827e-05f }, { 0.00029964918f, -0.0045658543f, -0.0045581938f, 0.0017106208f }, { 7.5790173e-05f, -1.8265415e-05f, 1.5918205e-05f, 5.8524021e-05f }, { 0.0011669872f, -0.00017571882f, -0.00017190275f, -0.0023833977f }, { 0.0033487264f, -0.0066535821f, -0.0066413786f, -0.0032332601f }, { -3.6468807e-05f, -0.00068145131f, -9.8190714e-05f, -8.7169435e-05f } }, { { -0.0010440653f, -8.9750644e-05f, 4.971182e-05f, 0.0044618878f }, { 0.0078333883f, -0.00090884312f, -0.00046920549f, -0.002465051f }, { -0.0058778609f, 0.0026554895f, -0.00031880506f, -0.00010649091f }, { -0.0015095448f, 0.0094026506f, 0.009492703f, 0.0024572848f }, { 0.0047331786f, 0.00070722401f, 0.0028798817f, -0.00039779892f }, { -0.0089878107f, -0.0095474878f, -0.0097187652f, 0.008765907f }, { -4.0435321e-05f, -0.00061813281f, -0.0060490143f, 0.0016259965f }, { -0.00014720558f, -1.0601876e-05f, 0.00014757138f, 0.00016227641f }, { -0.010428289f, -0.00031812813f, -0.0016172213f, -0.00012022134f }, { 0.0040517131f, 0.0072972763f, 0.0060433905f, 0.0025041645f }, { 0.00014090924f, 0.00027612853f, 0.00015961665f, 0.0002605418f }, { -0.00020653783f, -0.00048482867f, -0.00058472338f, 0.00026413759f }, { 0.00056712638f, 0.00026385353f, 0.00035484947f, 0.00033212447f }, { -0.00094663094f, 0.0029891757f, 0.0029887838f, -0.0026583585f }, { -0.0017400246f, 0.00042350567f, 0.00086128207f, 0.00039863587f }, { 0.00059604848f, 0.00027495434f, -0.00059956434f, -4.4981673e-05f }, { -0.010211343f, -0.0080580409f, -0.0085333216f, 0.0023258717f }, { 0.00042832593f, 0.0056750222f, 0.0048059635f, -0.0092168281f }, { 3.0214612e-05f, 4.540924e-06f, 1.7239937e-05f, 2.783598e-05f }, { 0.00029393335f, -4.5128636e-05f, -4.3089017e-05f, 0.00030682556f }, { -4.7077735e-05f, -1.3596835e-05f, -0.0015338149f, -7.4957991e-05f }, { -0.00097136844f, 0.00018564298f, 0.00021815754f, 0.0015095577f }, { 0.00043929849f, -0.0014691094f, -0.0014671742f, -0.00029365954f }, { 8.8554045e-05f, 0.0062500772f, 0.0001495049f, 0.00021007601f } }, { { 0.0020307077f, 0.0020947445f, 0.0017438295f, 0.0084822342f }, { -0.0069727503f, -0.0010131005f, 0.0055261321f, -0.0020442588f }, { 0.00031035611f, 0.00010839441f, 3.7359209e-06f, 4.3112837e-05f }, { 9.1207794e-05f, 0.0050148169f, 0.0051071455f, 0.0033679057f }, { -0.00090101737f, -0.00053793176f, -0.0025829621f, 0.0003241927f }, { -0.0019244714f, -0.0033690472f, -0.0035193497f, 0.0027653636f }, { -0.00065476293f, -0.00017787403f, 0.00040383136f, -0.00018123957f }, { -0.00030640434f, -0.00018961553f, -0.00011036218f, -0.00015793049f }, { 0.001110592f, -0.00021252645f, 0.00015849587f, -3.7758317e-05f }, { 0.00077967828f, -0.0051765235f, -0.0078505592f, -0.010796339f }, { -1.2024951e-05f, 6.48806e-05f, -3.9409005e-05f, 7.4639306e-05f }, { -0.00017352424f, -0.00037802595f, -0.00045639468f, 0.00016843169f }, { -4.2866244e-05f, -4.3730932e-06f, 7.3574276e-05f, 5.6076779e-05f }, { 0.00024802387f, 0.0018053101f, 0.0018042994f, -0.0016700716f }, { 0.0082698262f, -0.00014605077f, 0.0004377682f, 8.1585074e-05f }, { -4.494343e-06f, 0.00019781519f, -0.00058910268f, -0.00027360572f }, { 0.0013016934f, 0.0021020456f, 0.0022718598f, -0.0059377824f }, { 0.002185371f, -0.0080788056f, -0.0071952836f, 0.0039688918f }, { 0.00013048617f, 0.0001738124f, 0.00012978924f, 0.00013813358f }, { 0.00032386518f, 0.00023046021f, 0.00023064714f, 0.00033762343f }, { 0.00023643771f, 0.00019652953f, 0.0013083597f, 0.00024739959f }, { -0.0063957036f, -0.0055319023f, -0.0054742301f, -0.0037204932f }, { -0.0005510683f, -0.0007715413f, -0.00077385934f, -0.001009415f }, { 0.00017904616f, -0.00096137522f, 0.00030252599f, -2.2478138e-05f } } }, { { { -0.00038948583f, -0.00040817153f, -0.00041280315f, -0.0010985631f }, { 0.0025695337f, 0.00042904308f, 0.0054649973f, -0.0055079106f }, { 0.00052050672f, 2.2618679e-05f, 0.00024058975f, -0.00012632201f }, { -0.013468886f, 0.0079396715f, 0.0079402246f, 0.026283756f }, { -7.922122e-05f, -3.4761763e-06f, -0.0041716347f, 0.0001478739f }, { 0.023716381f, -0.016415262f, -0.015296927f, -0.021050827f }, { 3.7654391e-05f, 0.00012765816f, -0.0001337099f, 0.00051483398f }, { 0.00015671907f, 0.00010686796f, 2.1421097e-05f, -2.2281569e-05f }, { 3.1779413e-06f, 0.00010449913f, -0.00018303614f, 7.5382489e-05f }, { -0.00020526765f, -0.0011333575f, -0.0050720108f, 0.0051482782f }, { 4.0450357e-05f, 1.0808158e-05f, -2.3316095e-05f, 9.7767333e-06f }, { -0.019107229f, 0.010907324f, 0.0048969594f, 0.017851514f }, { 7.4048796e-05f, -7.041835e-06f, 8.0226174e-05f, 5.1714105e-05f }, { -0.016564627f, 0.0023486944f, 0.0023601429f, 0.016005248f }, { -0.004528284f, 3.6291049e-05f, 2.4229636e-05f, 0.0024853948f }, { 5.6882054e-05f, 6.8805135e-05f, 0.00013119897f, 0.00010339801f }, { 0.00021183341f, 0.0008203137f, -7.204401e-05f, 0.00062599728f }, { -0.00099314707f, 0.0030198762f, -0.0038989955f, 0.00055571214f }, { -7.4247984e-05f, -8.3993373e-05f, -5.9133252e-05f, -7.7411989e-05f }, { 0.0054296732f, -0.00057858871f, -0.00058417754f, -0.005072911f }, { -0.00019259782f, -0.00018772532f, -4.2959783e-05f, -0.0001827295f }, { -0.00029351865f, 0.00013736372f, 0.00016666048f, 0.00020873447f }, { 0.0069341659f, 0.0027612928f, 0.0027538377f, -0.0061770317f }, { 4.2584714e-05f, -0.00037063589f, -9.0693123e-06f, 0.00011845784f } }, { { 0.0028834168f, 0.0031807308f, 0.0031352582f, 0.01064051f }, { 0.0049297987f, -4.2149356e-05f, -0.0014926841f, -0.0002300371f }, { 0.0020396303f, -0.00066042794f, -6.4359283e-05f, 0.00017835163f }, { -0.0025767816f, 0.0025148152f, 0.0025224779f, 0.0043006543f }, { -0.00042084416f, -0.00013534305f, 0.002453623f, -4.0707749e-05f }, { -0.0001803055f, -0.0010450606f, -0.00084380806f, 0.00014843677f }, { -0.0064067107f, 0.00011012652f, -0.0022552747f, -0.00080508294f }, { -0.00017778763f, -4.296789e-05f, 0.00015343883f, 0.00025036711f }, { 0.002825978f, -0.00031945362f, -0.00031987612f, -0.00021117763f }, { 0.00032791249f, -0.00049524542f, 0.0049368722f, -0.0017186408f }, { -0.0001685943f, -0.00016766033f, -0.0001755097f, -0.00017067307f }, { 0.00023939157f, -0.00011793706f, -6.0620575e-05f, -0.0002706595f }, { -2.9718673e-05f, 3.5950879e-05f, 1.839844e-05f, -2.8718148e-05f }, { -0.0017260981f, 0.00012145435f, 0.0001236679f, 0.0018292155f }, { 0.0036086706f, 0.0001026898f, -2.5518889e-05f, -0.00019830236f }, { -0.00031546808f, -0.00042107458f, -0.00059963868f, -0.00061472497f }, { -0.0074719522f, 0.0015719596f, -0.0033624165f, -0.0092664101f }, { -0.0011285776f, 0.0018601435f, 0.00052060704f, -1.5554679e-05f }, { 4.9853171e-05f, 7.3650922e-05f, 3.4080107e-05f, 5.4255445e-05f }, { 0.00015102779f, -2.58105e-05f, -2.5851018e-05f, -4.5185316e-05f }, { 0.0002057452f, 0.00019037765f, 0.0040052198f, 0.00020046579f }, { 0.0027727314f, 0.0040749211f, 0.0036050794f, 0.0034635222f }, { 0.00042503689f, 0.00056027382f, 0.00056052971f, -8.2485044e-05f }, { -5.6309634e-05f, 0.0019722025f, 6.4267434e-05f, -0.00020376412f } }, { { 0.0051607661f, 0.0047835358f, 0.0047658352f, 0.0054281814f }, { -0.0040939561f, 0.0012119183f, -0.0023408179f, -0.00055891234f }, { -0.0031939804f, -0.0015954053f, -0.00018570689f, 0.00028849431f }, { -0.0075625096f, 0.0033878734f, 0.0033797415f, 0.010242674f }, { -0.002293562f, 0.00024245282f, 0.0019455622f, 0.0039550747f }, { 0.0090386754f, -0.0086947671f, -0.0082684939f, -0.0075613346f }, { -0.00085735117f, 3.4822634e-05f, -0.0024653972f, -0.00090964985f }, { -0.00013750587f, -0.00010089501f, 6.3555498e-05f, 0.0002758494f }, { 0.0060496328f, -0.00032664426f, 0.0005979723f, -0.00018819024f }, { 0.00072724184f, 0.00082242885f, 0.0045668772f, -0.0054557456f }, { -9.6167811e-05f, 7.9856612e-05f, 0.00015672473f, 8.0901183e-05f }, { 0.00038859448f, -0.00025360755f, -0.00017624981f, -0.00049125519f }, { -8.8277361e-05f, 2.4159527e-05f, -0.00016014627f, -2.7854246e-05f }, { -0.0037308647f, 0.00041434141f, 0.0004167221f, 0.0037190244f }, { 0.00050696744f, -4.6752715e-05f, 0.00033183668f, -0.0025882828f }, { -0.00015915702f, -0.0002325901f, -0.00036157415f, -0.00016391937f }, { 0.00012320153f, 0.0026711886f, 0.0018414591f, -0.0058215223f }, { -0.0029409983f, -0.00015460743f, 0.0031951665f, 0.0074654329f }, { 9.9084813e-05f, 9.1785865e-05f, 5.9300007e-05f, 0.00010463304f }, { 0.00024773341f, -2.5723276e-05f, -2.5709769e-05f, -0.00015357475f }, { 0.000416633f, 0.00028749584f, -0.0038632071f, 0.00039869488f }, { 0.00018344152f, 3.0811778e-05f, -0.00010240082f, 0.00059301197f }, { 0.0019217461f, 0.00034404024f, 0.00034318823f, -0.0015867375f }, { -0.00011928879f, 0.001178769f, -5.8655983e-05f, -0.00028461439f } } }, { { { 0.99999992f, 0.99999992f, 0.99999991f, 0.99999925f }, { 0.99998864f, 0.99999972f, 0.99993965f, 0.99997027f }, { 0.99999969f, 1.0f, 0.99999997f, 0.99999998f }, { 0.99990852f, 0.99971841f, 0.99970961f, 0.9996348f }, { 0.99999999f, 1.0f, 0.99997626f, 0.99999999f }, { 0.99951219f, 0.9997196f, 0.99973058f, 0.99951587f }, { 0.99999997f, 0.99999999f, 0.99999988f, 0.99999986f }, { 0.99999998f, 0.99999999f, 1.0f, 1.0f }, { 0.9999998f, 0.99999999f, 0.99999995f, 1.0f }, { 0.99999988f, 0.99999525f, 0.99997473f, 0.99995457f }, { 1.0f, 1.0f, 1.0f, 1.0f }, { 0.99975729f, 0.99976356f, 0.99983365f, 0.99982963f }, { 0.99999998f, 0.99999999f, 0.99999998f, 0.99999998f }, { 0.99986279f, 0.99986979f, 0.99986978f, 0.99984147f }, { 0.99997099f, 1.0f, 0.99999998f, 0.99999688f }, { 0.99999999f, 0.99999999f, 0.99999998f, 0.99999999f }, { 0.99999977f, 0.99999903f, 0.99999932f, 0.99999947f }, { 0.99999911f, 0.99997627f, 0.99997853f, 0.99999968f }, { 1.0f, 1.0f, 1.0f, 1.0f }, { 0.99998521f, 0.99998941f, 0.99998944f, 0.99998567f }, { 0.99999998f, 0.99999998f, 1.0f, 0.99999998f }, { 0.99999928f, 0.99999998f, 0.99999997f, 0.99999714f }, { 0.99997035f, 0.99997405f, 0.99997415f, 0.99997569f }, { 1.0f, 0.9999997f, 1.0f, 0.99999999f } }, { { 0.00015966941f, 0.00014262676f, 0.00020165066f, 0.00021618914f }, { 2.8140907e-06f, -0.00020325872f, 0.00017736728f, 6.0386679e-05f }, { -0.0003187876f, 5.8862288e-05f, 6.2281085e-05f, 1.7339908e-05f }, { -2.6587911e-05f, -0.00011609007f, -0.00011725093f, -7.6114852e-05f }, { 0.00013665042f, 5.2703844e-06f, -0.00031293536f, 3.8693931e-05f }, { -9.8143069e-05f, -0.00012816332f, -0.00012926252f, -0.00010623032f }, { 0.00032342312f, -1.9200091e-06f, -0.00010691485f, 6.3541059e-05f }, { -8.0643542e-06f, 9.7622933e-06f, 2.9924822e-05f, -1.988333e-05f }, { 0.00025318464f, 1.2588649e-05f, 1.4665927e-05f, 9.3294806e-06f }, { 2.6875391e-06f, -2.4928123e-05f, 2.251878e-05f, 0.00011026808f }, { 1.767638e-05f, 1.0309044e-05f, 2.4765648e-05f, 1.4397941e-05f }, { 6.9000935e-06f, 1.0637078e-05f, 1.087637e-05f, 6.3065784e-06f }, { 5.532953e-05f, 1.6231463e-05f, 4.9564371e-05f, 3.6623041e-05f }, { -1.6958729e-05f, -3.1627491e-05f, -3.1524511e-05f, -2.9954116e-05f }, { 8.9045086e-05f, 2.1005026e-05f, 1.3016463e-05f, 8.7863053e-05f }, { -2.75035e-05f, -3.0440427e-05f, -3.5356286e-05f, 5.9609261e-06f }, { 0.0001586274f, 4.0711165e-05f, 3.1563135e-05f, 0.0001385483f }, { 8.5548316e-06f, 7.4531928e-05f, -3.7017413e-05f, 2.6874037e-05f }, { -1.3750655e-05f, -8.2756032e-06f, -2.7214983e-07f, -1.4830115e-05f }, { -7.0798362e-07f, -3.3187173e-07f, -3.3266762e-07f, -5.7113855e-07f }, { 4.3615512e-05f, -4.4076433e-06f, 8.9239586e-06f, 3.7278531e-05f }, { -7.7366773e-06f, 4.610399e-06f, 4.3762687e-06f, -5.64067e-06f }, { -3.2666125e-06f, -1.0773146e-05f, -1.0861965e-05f, -1.3327232e-06f }, { -9.1178305e-06f, 0.00030171207f, -1.5395234e-05f, -2.0695425e-07f } }, { { 0.00017159464f, 0.00014699558f, 0.00018752678f, 0.0002227926f }, { -4.6524822e-05f, -0.00010460271f, 0.00034735325f, 0.00010082238f }, { -6.8269006e-05f, 1.4343751e-05f, 7.7283393e-06f, 2.5347136e-05f }, { -6.6149546e-05f, -7.1168993e-05f, -7.0621016e-05f, -0.00015246746f }, { 7.12022e-05f, 3.8790461e-05f, -0.00023994449f, 6.6792921e-05f }, { -0.00014735813f, -0.00012658353f, -0.00012162488f, -0.00012106777f }, { 0.00015161388f, -1.4439153e-05f, -3.7629923e-06f, 8.3140788e-06f }, { 4.0175416e-05f, 2.5380268e-05f, -2.2894421e-06f, 4.6374378e-06f }, { 0.00028906023f, 1.7695243e-05f, 5.3790587e-06f, 1.631859e-05f }, { 1.8890685e-05f, -1.6898275e-05f, 2.1007663e-05f, 6.5179363e-05f }, { -3.9142595e-06f, 2.5745488e-05f, 1.0803197e-05f, 2.7099749e-05f }, { 9.4245546e-06f, 1.0010075e-05f, 9.058324e-06f, 9.8703427e-06f }, { -2.3441863e-06f, 2.5490323e-05f, -1.0097654e-05f, 4.0554798e-05f }, { -4.1443921e-05f, -1.996316e-05f, -2.0000841e-05f, -4.7495655e-05f }, { 0.00012591695f, 5.6179903e-05f, -1.8415869e-05f, -3.8697972e-05f }, { 2.6719505e-05f, 2.4195362e-06f, 2.4287424e-05f, 3.4703059e-05f }, { 7.3804931e-05f, 4.9784871e-05f, 3.1159931e-06f, 0.00015857197f }, { -0.00010634331f, -1.6427658e-05f, -7.4874306e-05f, -6.2620255e-05f }, { -4.2561214e-06f, -1.6123179e-05f, -1.5507273e-05f, -1.2909924e-05f }, { -1.2210463e-06f, 1.1546399e-06f, 1.1413892e-06f, -1.3465856e-06f }, { 3.4909884e-05f, -1.2677793e-05f, 0.00011543701f, 2.413091e-05f }, { -2.1953323e-05f, -4.6244252e-06f, -3.5624435e-06f, 4.2293671e-06f }, { -1.1392936e-05f, -4.3970369e-06f, -4.4264864e-06f, -1.208518e-05f }, { -4.4002617e-05f, 0.00020912348f, -3.9617824e-05f, -4.1725112e-05f } } }, { { { -0.32504349f, -0.32502096f, -0.32501094f, -0.32423576f }, { -0.65602876f, -0.65622598f, -0.65567173f, -0.65525128f }, { -1.4666488f, -1.4666488f, -1.4666488f, -1.4666488f }, { 0.87168363f, 0.87181364f, 0.87181792f, 0.8718169f }, { -1.264365f, -1.264365f, -1.264365f, -1.264365f }, { 0.89917968f, 0.89916889f, 0.89916525f, 0.89927374f }, { -1.2245906f, -1.2245906f, -1.2245906f, -1.2245906f }, { -0.8885678f, -0.88856217f, -0.88856327f, -0.88855044f }, { -0.31799095f, -0.31916566f, -0.31907669f, -0.31918911f }, { -0.08987958f, -0.090342401f, -0.090004674f, -0.090222398f }, { -0.59425693f, -0.59433999f, -0.59429118f, -0.59433553f }, { 1.1317575f, 1.1317475f, 1.1317412f, 1.1317494f }, { -1.2193493f, -1.2193493f, -1.2193493f, -1.2193493f }, { 1.2506981f, 1.250675f, 1.250675f, 1.2506569f }, { -1.08782f, -1.0877793f, -1.0878022f, -1.0878025f }, { -0.13925598f, -0.13932948f, -0.13919658f, -0.13913403f }, { -0.40394684f, -0.4042314f, -0.40436178f, -0.40402218f }, { -0.47762966f, -0.47745572f, -0.47767784f, -0.47713093f }, { -0.60177181f, -0.60176862f, -0.60177347f, -0.60177079f }, { 2.7311956f, 2.7311911f, 2.7311911f, 2.731191f }, { -1.3109856f, -1.3109856f, -1.3109856f, -1.3109856f }, { 0.60942644f, 0.60941369f, 0.6094123f, 0.60944198f }, { 0.55675448f, 0.55672275f, 0.55672303f, 0.5567542f }, { -0.40637059f, -0.4057945f, -0.40635768f, -0.40636681f } }, { { -0.0016154222f, -0.0015930079f, -0.0015828998f, -0.00087447165f }, { -0.0011262472f, -0.001324462f, -0.00094895016f, -0.00062188189f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 9.7616744e-05f, 0.00010718899f, 0.00010718606f, 0.00012665246f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.00013476236f, 6.982272e-05f, 6.8208505e-05f, 0.00014604742f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { -0.0031089951f, -0.0031071196f, -0.0031207245f, -0.0031097054f }, { -0.0027808116f, -0.0035049857f, -0.0034100135f, -0.0035192661f }, { -0.0018291474f, -0.0019603285f, -0.0018919656f, -0.0019656229f }, { -0.0034301741f, -0.0034912573f, -0.0034474395f, -0.0034893985f }, { -6.156701e-06f, -9.8568527e-06f, -1.2383692e-05f, -9.9984205e-06f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.00011838153f, 0.00011008679f, 0.00011008878f, 0.00010536608f }, { -0.0006246638f, -0.00058479459f, -0.00061327452f, -0.00061085433f }, { -0.0059197749f, -0.0059778169f, -0.0059586015f, -0.0058798299f }, { -0.0013246996f, -0.0016061786f, -0.0016081246f, -0.0014374546f }, { -0.001593227f, -0.0014706843f, -0.0015974008f, -0.001341579f }, { -0.0027930604f, -0.0027920013f, -0.0027939865f, -0.0027928528f }, { -1.8908723e-06f, -4.266382e-06f, -4.2210172e-06f, -5.0155215e-06f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.00018508026f, 0.00019774537f, 0.00019744661f, 0.00019538593f }, { 2.3243747e-05f, 1.7291398e-05f, 1.7309712e-05f, 2.9261396e-05f }, { -0.0041402471f, -0.0037085946f, -0.0041294876f, -0.0041316136f } }, { { -0.0018899732f, -0.0018719182f, -0.0018661076f, -0.0012234594f }, { -0.0012968123f, -0.0012971446f, -0.00093522854f, -0.00066475268f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 9.1054464e-05f, 0.00014124217f, 0.00014156806f, 0.00012014953f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.00017026995f, 0.00010528413f, 0.00010537941f, 0.00015698848f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { -0.0025812972f, -0.0025835894f, -0.0025789321f, -0.002554949f }, { -0.0035568863f, -0.0042988014f, -0.0042155548f, -0.004312546f }, { -0.0024184575f, -0.0025111277f, -0.0024654994f, -0.0023980076f }, { -0.0036993386f, -0.0037113013f, -0.0036987284f, -0.0037094875f }, { -5.074861e-06f, -1.1367399e-05f, -1.4819989e-05f, -9.2705899e-06f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.00012570403f, 0.00012150272f, 0.00012149179f, 0.00010579599f }, { -0.00062162762f, -0.00058131015f, -0.00060837583f, -0.00060795256f }, { -0.00775735f, -0.0077198081f, -0.0078365948f, -0.0077749317f }, { -0.0015325554f, -0.0017125784f, -0.001703195f, -0.0015662859f }, { -0.0018130784f, -0.00177106f, -0.001858095f, -0.0015845058f }, { -0.003668417f, -0.0036659688f, -0.0036693421f, -0.0036680526f }, { -9.5804016e-06f, -9.6276607e-06f, -9.630607e-06f, -1.2159056e-05f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.00017930618f, 0.00020084683f, 0.00020150104f, 0.00020810787f }, { 2.3869269e-05f, 1.1024793e-05f, 1.1041937e-05f, 1.6467357e-05f }, { -0.004690782f, -0.0044656761f, -0.0046782065f, -0.0046921455f } } }, { { { 0.23047932f, 0.23043226f, 0.23041471f, 0.22922185f }, { 0.14990977f, 0.15703656f, 0.15110771f, 0.15149153f }, { 0.30629171f, 0.30426701f, 0.30400037f, 0.30403889f }, { 0.03476576f, 0.036188528f, 0.036216719f, 0.037322097f }, { 0.31066251f, 0.31090363f, 0.31041565f, 0.31057779f }, { 0.04875259f, 0.046468595f, 0.046486323f, 0.046584523f }, { 0.31745458f, 0.31874472f, 0.32086369f, 0.31880207f }, { 0.64054942f, 0.64062862f, 0.64051973f, 0.64059059f }, { 0.27309038f, 0.27480819f, 0.27477284f, 0.27486762f }, { 0.196647f, 0.19687982f, 0.19607604f, 0.1957915f }, { 0.32867362f, 0.32858008f, 0.32856702f, 0.328555f }, { -0.0026873031f, -0.0042393446f, -0.0057894907f, -0.0041858859f }, { 0.40254624f, 0.4024247f, 0.4025598f, 0.40243731f }, { 0.019362807f, 0.018146218f, 0.018146051f, 0.019656613f }, { 0.29328089f, 0.29403937f, 0.29435036f, 0.29403094f }, { 0.57111506f, 0.57118505f, 0.57099608f, 0.57099266f }, { 0.16966612f, 0.16993739f, 0.17069399f, 0.16991136f }, { 0.14989055f, 0.1489484f, 0.14995985f, 0.15015916f }, { 0.33606014f, 0.33606294f, 0.33606393f, 0.33605429f }, { 0.015421206f, 0.015180692f, 0.01518037f, 0.015431139f }, { 0.33165237f, 0.33185282f, 0.33162592f, 0.33166981f }, { 0.078137018f, 0.078153855f, 0.078165152f, 0.078332343f }, { 0.002896946f, 0.0026038621f, 0.0026029604f, 0.0022081151f }, { 0.41064398f, 0.40987685f, 0.41065341f, 0.41059166f } }, { { -0.0024316111f, -0.0024732789f, -0.0024922144f, -0.0035874346f }, { 0.0013306961f, 0.004171802f, 0.0027660627f, 0.0023671465f }, { 0.0034411091f, 0.0020878413f, 0.0020874456f, 0.0022028237f }, { -0.0032873976f, -0.0021351911f, -0.0021071363f, -0.0028424534f }, { 0.0017995208f, 0.0022319618f, 0.0039270256f, 0.0021249365f }, { -0.0019590835f, -0.0012526895f, -0.0012347747f, -0.0021069943f }, { 0.0012319531f, 0.002255621f, 0.0030193583f, 0.0020970822f }, { 0.0015144077f, 0.0015110104f, 0.0014803089f, 0.0015340007f }, { -0.0036679996f, -0.0028160114f, -0.0028586497f, -0.0027953731f }, { -0.005445786f, -0.0052624873f, -0.0054843188f, -0.0053271749f }, { 0.00067154572f, 0.0007530775f, 0.00067974516f, 0.00074462315f }, { -0.0035626119f, -0.0034186877f, -0.0038720517f, -0.0040088745f }, { 0.003455851f, 0.0035040061f, 0.0034671486f, 0.0035069881f }, { -0.0047789747f, -0.0047994804f, -0.0047996451f, -0.0044008337f }, { 0.0032403482f, 0.0033627856f, 0.003429619f, 0.0031153117f }, { -0.005027022f, -0.0049812f, -0.0049604573f, -0.0050556194f }, { -0.0020728991f, -0.0014784158f, -0.001216894f, -0.0019213729f }, { -0.00013808007f, -0.00067270623f, -0.00024001574f, -0.00030691077f }, { 0.0004367104f, 0.00043390709f, 0.00043548166f, 0.00043425516f }, { -0.00082746467f, -0.00088151411f, -0.00088152334f, -0.0008043643f }, { 0.0030277712f, 0.003133577f, 0.0028529862f, 0.0030362271f }, { -0.0058721937f, -0.0059816331f, -0.0059799345f, -0.0058882832f }, { -0.0057032562f, -0.0057401855f, -0.0057416619f, -0.0062417688f }, { -0.0014357888f, -0.0020782049f, -0.0014346823f, -0.0014513767f } }, { { -0.0027051235f, -0.0027087245f, -0.0027052303f, -0.0033594951f }, { 0.0028036195f, 0.0030416572f, 0.0014306948f, 0.0017897371f }, { 0.0031113166f, 0.0026432303f, 0.0025937824f, 0.0025394463f }, { -0.0036032904f, -0.003447065f, -0.0034344406f, -0.0024163572f }, { 0.0023912799f, 0.0025281229f, 0.0038665087f, 0.0024214034f }, { -0.0023543827f, -0.0024294943f, -0.0024539784f, -0.0027742617f }, { 0.0020903896f, 0.0026617586f, 0.003395249f, 0.0026261065f }, { 0.0019031008f, 0.0019405475f, 0.0019426085f, 0.0019404325f }, { -0.0040413326f, -0.0030964835f, -0.0031020735f, -0.0030826754f }, { -0.0064568993f, -0.0062342438f, -0.0064704698f, -0.0065636744f }, { 0.0010788406f, 0.0010092051f, 0.0010264121f, 0.00099891228f }, { -0.0040759201f, -0.0059224283f, -0.0066809927f, -0.0049099348f }, { 0.0042962009f, 0.0041909175f, 0.0043195236f, 0.0041900138f }, { -0.0062728983f, -0.0070256154f, -0.007025641f, -0.0061758746f }, { 0.0036210401f, 0.0039723998f, 0.0042232048f, 0.0042757707f }, { -0.0058693852f, -0.0058583303f, -0.0058544016f, -0.005887725f }, { -0.0023099876f, -0.0021136245f, -0.0017298078f, -0.0022483337f }, { -0.00017851962f, -0.00014956209f, 8.5676316e-05f, -0.00024971669f }, { 0.0003734781f, 0.00037078986f, 0.00037364181f, 0.00037070594f }, { -0.00030648905f, -0.00038230535f, -0.00038223043f, -0.00028623253f }, { 0.0032871423f, 0.0034163052f, 0.0028276655f, 0.0032991918f }, { -0.0061331695f, -0.0063319797f, -0.0063340119f, -0.0064390374f }, { -0.0062172888f, -0.0059787106f, -0.0059793294f, -0.0060406701f }, { -0.0018276142f, -0.0022170788f, -0.0018293949f, -0.0018222824f } } } }, { { { { 0.13218089f, -0.11654637f, -0.11622196f, -0.044208736f }, { 0.0074579257f, 0.0038503609f, 0.0013201096f, 4.0415784e-05f }, { -0.025474487f, -0.01209255f, -0.016535858f, 0.012704547f }, { -0.0016894103f, -0.0081312144f, -0.0033264609f, 0.0011923269f }, { -0.068044876f, 0.018276873f, -0.074833897f, 0.01308348f }, { 0.02665691f, 0.013515118f, 0.026440814f, -0.0077037816f }, { 0.0023286096f, -0.0025782652f, 0.0021644694f, -0.0042955294f }, { 0.051356261f, -0.031058382f, -0.085382962f, -0.033103269f }, { -0.081609229f, 0.0035270199f, -0.015722417f, 0.048773789f }, { 0.0023928418f, -0.001243811f, 0.011910492f, -0.011621478f }, { -0.028953904f, -0.029335777f, -0.0057891432f, 0.013874136f }, { -0.012473582f, 0.001772629f, -0.013983442f, 0.014846792f }, { -0.016111661f, 0.0018902323f, 0.025910586f, 0.042848276f }, { 0.026200626f, 0.024007879f, 0.0017667146f, -0.016394032f }, { -0.0067006429f, -0.0017968936f, 0.009028659f, 0.0044060413f }, { 0.019280611f, 0.0449581f, -0.042852227f, -0.066012332f }, { -0.014451123f, -0.047772741f, -0.047475406f, 0.098434178f }, { -0.0028954635f, 0.010521833f, -0.015741597f, -0.00091666191f }, { 0.0020291956f, -0.057966746f, -0.04525094f, 0.032711614f }, { 0.020563445f, -0.0078684621f, -0.015282237f, -0.0019830466f }, { -0.019504171f, 0.071338511f, 0.0033729474f, -0.0095772339f }, { 0.013056103f, 0.018719519f, 0.0096002937f, -0.028774366f }, { -0.00038728577f, -0.0010662982f, -0.0014333502f, 0.00059135695f }, { 0.073844752f, -0.05666013f, -0.1007151f, -0.030440738f } }, { { 0.00017766639f, -9.2398532e-05f, -3.9442682e-05f, -3.9559848e-05f }, { -0.0043956477f, 0.00044042277f, -0.00047491077f, 9.4171117e-05f }, { -0.0042095545f, -0.00910753f, -0.0014295282f, 0.0042595844f }, { 0.00070989004f, -0.0009623012f, 0.00084162653f, -0.00015925965f }, { -0.0017587638f, 0.0033199811f, -0.00025544613f, 0.00083644978f }, { 0.0051797987f, 0.0015691893f, -0.002324397f, 0.0050776381f }, { 0.003911779f, 0.00072639703f, 2.102924e-05f, -0.0029529332f }, { 0.0050240476f, -0.00041452319f, 3.1730448e-06f, -0.0072697591f }, { -1.5023048e-05f, 0.00032491246f, -9.2151952e-05f, 0.0035851726f }, { 0.0030984373f, 0.0016428856f, 0.0032974124f, -0.0036034289f }, { -0.00044578206f, -0.0035916409f, 0.0028146658f, 0.0068013321f }, { 0.00025716711f, -0.0024772152f, 0.0029660992f, -0.0008783244f }, { -0.005543602f, -0.00046453249f, 0.006815884f, 0.0069207512f }, { -0.0033541738f, -0.0015140333f, -0.004071746f, -0.0020908789f }, { 0.0027932918f, -0.0012517158f, -0.0033509184f, -0.001271572f }, { 0.0043481525f, -0.00088858735f, -0.0081538059f, 0.00027985077f }, { 7.4017523e-05f, -7.0080388e-05f, -7.1766386e-05f, 0.00020468758f }, { 0.00044507396f, 0.010179106f, -0.0048087449f, 0.0013487105f }, { 0.00082148695f, -0.00042640153f, -0.0024255173f, 0.0044486011f }, { -0.00026383509f, -0.0031871528f, -0.008203704f, -0.00053957093f }, { -0.0002996462f, 0.00070789605f, 7.9300612e-05f, -0.00024002209f }, { 0.0013722116f, 0.0049176054f, 0.0029283062f, -0.000849108f }, { 0.00026545039f, 0.0011783443f, 0.00072103548f, -0.0007355776f }, { 0.002192273f, -0.00294318f, 1.5452606e-05f, -0.0020953993f } }, { { 2.4074136e-05f, -2.4931598e-05f, -1.0893587e-05f, 1.080951e-05f }, { -0.0061635883f, -0.0042963493f, -0.00177783f, -0.00080292808f }, { 0.0047868795f, -0.0050472436f, 0.0082439123f, -0.0090979713f }, { 0.0017221077f, 0.0067285193f, 0.0031011872f, -0.0019932567f }, { 0.0010926271f, -0.0012170693f, 0.00012875612f, 0.00016441623f }, { -0.0048786273f, -0.0041225634f, -0.005591426f, 0.0043469593f }, { -0.0070664098f, -0.0012625813f, -0.00022220241f, -0.0026120468f }, { -0.0026689917f, 0.00030860545f, 1.9297947e-05f, 0.001274799f }, { 0.0026769559f, 0.00016106032f, 0.00013829246f, -0.0017239107f }, { -0.0042495789f, 0.0010270326f, -0.00078224804f, -0.0019210019f }, { 0.0072385804f, 0.0086418476f, 0.0061428272f, -0.0027142827f }, { 0.0019768127f, -0.00057957046f, 0.0047464783f, -0.004599565f }, { 0.0093618867f, -0.0010476542f, -0.0038681572f, -0.0065219521f }, { -0.0076406673f, -0.0036729355f, -0.0068804827f, 0.0077571478f }, { 0.0012706397f, -0.00042567505f, -0.002521821f, 6.0288127e-05f }, { -0.002041411f, 0.000430125f, 0.0073620925f, 0.0021579456f }, { 0.00012145466f, 4.1276616e-05f, 4.2449608e-05f, 9.8351262e-05f }, { 0.0014376278f, -0.007439719f, 0.0039006971f, 0.00051135138f }, { -7.1665367e-05f, 0.00023856335f, 0.00015274881f, -0.0096946274f }, { -0.00076804256f, 0.0040182915f, 0.012603411f, -0.00059669891f }, { -0.00010641981f, -0.00052355992f, 0.00057481361f, 0.00016456343f }, { -0.0027623375f, -0.0036761364f, -0.010480297f, 0.0066006902f }, { 0.00049081404f, 0.00077264749f, 0.0021355718f, -0.00029188425f }, { 0.00028566818f, 0.00097678458f, 0.00089022281f, -0.00013760767f } } }, { { { -0.0098123577f, 0.11017117f, 0.11245143f, -0.01173447f }, { 0.0036188505f, -0.0025878518f, -0.00043343726f, -0.0038813197f }, { 0.013109746f, -0.016775181f, -0.0011093308f, 0.00083465721f }, { -0.0042515898f, -0.0028159364f, 0.00027829209f, -0.002907578f }, { -0.0081027554f, -0.0019330574f, 0.061872524f, -0.037539524f }, { -0.012923735f, 0.021011524f, 0.002680406f, 0.0034369108f }, { 0.0027819214f, 0.0028657905f, -0.0034177203f, -0.0037322329f }, { -0.0036178174f, 0.065792163f, 0.13263475f, 0.0055427994f }, { 0.027832309f, -0.083372016f, -0.058757582f, 0.016164879f }, { -0.0082343898f, 0.011782416f, 0.011496052f, -0.0027847616f }, { 0.0012516658f, -0.014686832f, -0.025073035f, -0.020700577f }, { 0.0055718234f, -0.011543219f, -0.012867689f, -0.0049474286f }, { 0.028869265f, -0.035431559f, 0.024976635f, -0.01063055f }, { -0.0010657662f, 0.014977146f, 0.027109f, 0.01612865f }, { -0.0021697493f, 0.0044220507f, 0.0055654161f, -0.0032373397f }, { -0.018500666f, -0.01979267f, -0.0068480612f, 0.03908391f }, { 0.063306878f, 0.01934691f, 0.019254616f, -0.099824471f }, { 7.0580666e-05f, -0.0015082457f, -0.0056893693f, 0.00022726294f }, { 0.0077067654f, -0.014018834f, -0.021406454f, -0.0076589993f }, { -0.0013072394f, 2.6765854e-05f, 0.0028400803f, 0.0037431063f }, { -0.025369581f, -0.064039908f, -0.020594137f, -0.086807367f }, { -0.033639351f, 0.010434758f, 0.00082983507f, 0.013145885f }, { 0.00029373395f, 7.8193614e-05f, 0.00048496415f, 0.00062972215f }, { -0.0041597628f, 0.024283117f, -0.030148407f, 0.011456515f } }, { { -1.3484857e-05f, -3.7204145e-05f, -1.5660577e-05f, -2.4497955e-05f }, { -0.0068070249f, 0.0041035892f, 0.0034647689f, 0.0035918321f }, { -0.0053613309f, 0.0080593503f, 0.0028507084f, -0.0023104987f }, { 0.0048581064f, 0.0039720065f, -0.0019058129f, 0.0047295789f }, { -0.00030675956f, -0.0007787587f, -0.00025201217f, 0.00020777843f }, { -0.00026433336f, -0.0093672701f, -0.0053201627f, -0.0059632173f }, { -0.0063062815f, 0.0011995204f, 0.0001870407f, 0.0028197877f }, { -0.00053247524f, -0.00066138217f, -1.4959372e-05f, -0.00036023628f }, { 0.00027591427f, 0.00011309835f, 2.2453632e-05f, -0.00075736359f }, { 0.0015654886f, 0.0018114616f, -0.0004503446f, -8.5866048e-05f }, { 0.003501393f, 0.0037179893f, 0.008328543f, 0.013411108f }, { -0.0035136609f, -0.0015054003f, 0.0011903964f, 0.0022551358f }, { -0.0083723767f, 0.0061303554f, -0.008056962f, 0.0035035183f }, { -0.0023715655f, -0.0070468331f, -0.010219655f, -0.0057856465f }, { -0.0011406634f, -0.00021204595f, -0.001693195f, 0.0011051597f }, { 0.0011643412f, 0.00037557194f, 0.0048567739f, -0.00063996433f }, { -3.1728174e-05f, -2.9073903e-06f, -3.0243209e-06f, 2.579239e-05f }, { 0.00053152589f, 0.0029635352f, 0.0040743289f, -0.00051381046f }, { -0.0017253584f, 0.00012081524f, 0.00012243664f, -0.00063598215f }, { 0.0026711847f, -0.0020733972f, -0.0027860744f, 0.0017065643f }, { 5.7762902e-05f, 0.00092043577f, -0.0035278882f, 0.0007846087f }, { 0.0056127705f, -0.0051893669f, -0.0027072408f, -0.0025630045f }, { -0.00059289151f, -0.0004168408f, -8.8118696e-05f, -0.00073538101f }, { 0.0003388606f, -0.00094234652f, 3.013109e-05f, -0.0010532484f } }, { { -2.9013996e-05f, 6.1983083e-05f, 2.8401438e-05f, -3.4901557e-05f }, { 0.0045230474f, -0.0021369843f, -0.00422706f, -0.0018918027f }, { 0.00017586142f, 0.005389053f, 0.0071352982f, -0.0018278685f }, { -0.0012135723f, -0.0035970727f, 0.00078957165f, -0.0017065397f }, { -0.00067051937f, -1.9501585e-05f, 4.1968766e-05f, -0.0010958091f }, { -0.0015277626f, -0.0039952533f, -0.00049631478f, 0.0018042745f }, { 0.0039376754f, -0.00097834328f, 6.5894634e-06f, -0.0044189106f }, { -0.00067623039f, 0.0004690807f, 1.4532105e-07f, 0.0032984829f }, { 0.0020787449f, -0.0016586579f, -0.00062367064f, 0.0021545362f }, { 0.0016427801f, 2.6710288e-05f, 0.0016011535f, -0.00077649869f }, { 0.0039999622f, -0.0014968097f, -0.0025647576f, 0.0022783424f }, { 0.001558454f, -0.00083803058f, 0.0018955692f, 0.0010432376f }, { 0.010555722f, -0.010395022f, 0.0050354965f, -0.0016177699f }, { 0.00011370745f, -0.009328355f, -0.0063009522f, 0.0024377458f }, { -0.00024433189f, 0.00052920244f, -0.0013213352f, -0.0013503982f }, { -0.0057620093f, 0.00095391746f, -0.0034768563f, 0.00093990705f }, { 0.00012108024f, 4.1007202e-05f, 4.2193381e-05f, -0.00011043617f }, { 0.0038593696f, -0.00074282979f, -0.0093457897f, 0.00027311164f }, { 0.0021514797f, -7.8742315e-05f, -0.0018813077f, -0.0017625098f }, { 0.0038491118f, 0.00022570776f, -0.0061331041f, 0.00014956617f }, { -0.00014676603f, -0.00025053931f, 0.003376287f, -0.00014730695f }, { 0.0016439646f, 0.0060569792f, 0.00063058918f, -0.0034810156f }, { 0.00011722835f, 0.00032237223f, -0.0012556553f, -0.0006887808f }, { 0.00060814722f, 0.0003708376f, -0.00056515636f, -0.00016801817f } } }, { { { 0.99117704f, 0.98705585f, 0.98683693f, 0.9989534f }, { 0.99996564f, 0.99998924f, 0.99999903f, 0.99999247f }, { 0.99958951f, 0.99978616f, 0.99986266f, 0.99991895f }, { 0.99998953f, 0.99996298f, 0.99999443f, 0.99999506f }, { 0.99764936f, 0.9998311f, 0.99527468f, 0.99920949f }, { 0.9995611f, 0.99968788f, 0.99964679f, 0.99996442f }, { 0.99999342f, 0.99999257f, 0.99999182f, 0.99998381f }, { 0.99867384f, 0.99734987f, 0.98748052f, 0.99943657f }, { 0.99627571f, 0.99651225f, 0.99814846f, 0.99867903f }, { 0.99996323f, 0.99992981f, 0.99986298f, 0.99992859f }, { 0.99957996f, 0.99946171f, 0.99966886f, 0.99968945f }, { 0.99990668f, 0.9999318f, 0.99981943f, 0.99987754f }, { 0.99945334f, 0.99937032f, 0.99935219f, 0.99902503f }, { 0.99965614f, 0.99959957f, 0.99963092f, 0.99973552f }, { 0.9999752f, 0.99998861f, 0.99994375f, 0.99998505f }, { 0.99964293f, 0.99879278f, 0.99905795f, 0.99705307f }, { 0.99788947f, 0.99867085f, 0.99868681f, 0.99012413f }, { 0.99999581f, 0.99994351f, 0.99985991f, 0.99999955f }, { 0.99996824f, 0.99822008f, 0.99874627f, 0.99943549f }, { 0.9997877f, 0.99996904f, 0.99987919f, 0.99999103f }, { 0.99948785f, 0.99539425f, 0.99978223f, 0.99617908f }, { 0.99934875f, 0.99977032f, 0.99995357f, 0.99949949f }, { 0.99999988f, 0.99999943f, 0.99999886f, 0.99999963f }, { 0.99726107f, 0.99809817f, 0.99445842f, 0.99947091f } }, { { -2.3481737e-05f, -6.7307406e-06f, -2.8605869e-06f, -2.0372001e-06f }, { 6.6885689e-05f, 4.5630281e-06f, 3.5788218e-05f, 1.0842484e-05f }, { -4.9278613e-05f, -2.4660601e-05f, 3.1625301e-06f, 0.00019708279f }, { 1.2439158e-05f, 3.0347865e-05f, 8.6153947e-06f, 1.0887256e-05f }, { -0.00012454598f, -6.513709e-05f, -3.5853483e-06f, -3.4708286e-06f }, { -0.00013746339f, 0.00013516333f, 8.4535039e-05f, 5.693766e-05f }, { -2.3674091e-05f, -3.4690053e-06f, 5.3812265e-07f, -1.7613197e-05f }, { -0.00025790043f, 3.0475251e-05f, 2.1174795e-06f, -0.00023630753f }, { -8.8624748e-06f, 7.9175589e-06f, -2.4258477e-07f, -0.00017288313f }, { 4.0061469e-05f, 0.00069846663f, -0.00060299476f, -0.00015396968f }, { 5.0667108e-06f, 2.306363e-05f, 0.00028636884f, 3.6246633e-05f }, { 0.00032740524f, -0.00037985037f, -0.00014841039f, -0.00012676016f }, { 8.7000758e-05f, 0.00018530207f, 1.7669124e-05f, -0.00023199594f }, { 9.2332094e-05f, 0.00013487652f, 0.00034587506f, -3.8853378e-05f }, { 6.9809868e-05f, -0.00015411544f, 0.0013505166f, 1.4531796e-06f }, { -6.3782301e-05f, 4.8545135e-05f, -0.00027083794f, 4.5129465e-05f }, { 3.0912438e-06f, -3.2982361e-06f, -3.3551612e-06f, -1.7781589e-05f }, { 9.872609e-06f, -2.9944213e-05f, -4.5592652e-05f, 1.5950681e-05f }, { 1.4767773e-05f, -2.2486726e-05f, -0.00010613341f, -0.00015794394f }, { 2.4386215e-05f, -1.1610334e-05f, -4.4456294e-05f, -5.0215596e-06f }, { -4.2741558e-06f, 8.7714242e-06f, -6.6343322e-05f, 6.7010735e-05f }, { 0.00016489767f, -3.3636771e-05f, 5.1610504e-05f, 5.2803593e-06f }, { 1.1649256e-05f, 2.1169993e-05f, 1.9755999e-05f, 1.3389438e-05f }, { -0.00015815197f, -0.00014316145f, 2.6536218e-06f, -4.6846396e-05f } }, { { -3.5109783e-06f, -9.8530632e-06f, -4.5020804e-06f, 6.9233235e-08f }, { 9.9938991e-06f, -2.0914089e-06f, 3.5717699e-05f, 3.2813664e-06f }, { 0.00012938219f, 1.111062e-05f, 8.0858608e-05f, 0.00018147439f }, { 4.8657525e-06f, 8.6580257e-06f, 3.6742927e-06f, 3.5828406e-06f }, { 6.9905696e-05f, 2.0985073e-05f, 6.8866215e-06f, -4.2552499e-05f }, { 0.00012100208f, 9.7821801e-05f, 0.00013576456f, 6.3686234e-05f }, { 1.954525e-06f, -1.0727343e-06f, 5.2332444e-07f, -5.4034988e-06f }, { 0.00013699813f, -2.226833e-05f, 1.4994043e-06f, 1.7110377e-05f }, { 0.0001678261f, -0.00013844113f, -3.4281745e-05f, 5.3854072e-05f }, { -1.3018868e-05f, 0.00022176303f, 0.00016983401f, 0.00038109805f }, { 0.00019016068f, 0.00023448876f, 2.643329e-05f, 4.6842203e-05f }, { -1.2492528e-05f, -0.00059486605f, 0.00012427061f, 8.1876965e-05f }, { 8.400564e-05f, -0.00029859163f, -4.884214e-05f, 0.0002631806f }, { 0.00019907281f, 0.00014046808f, 0.00015482448f, 4.0461099e-05f }, { -0.00024349239f, 0.00081298441f, 0.00084294728f, 7.9617963e-05f }, { -6.0040835e-05f, 3.2352918e-07f, 0.00024295599f, 0.00011067283f }, { -6.0027092e-06f, 1.1975092e-06f, 1.2248893e-06f, -2.1293392e-05f }, { 1.4478736e-05f, 6.8326918e-05f, -7.8693614e-06f, 9.2888155e-06f }, { -1.6982828e-05f, 1.2094341e-05f, -3.1693808e-05f, 0.00028574477f }, { 3.4480942e-05f, 2.6556008e-05f, 0.00016193956f, -1.8966503e-06f }, { -5.7726961e-06f, 2.1091148e-05f, 5.8963955e-05f, -1.0834372e-05f }, { 0.0001214393f, 1.4174882e-05f, 0.0001371836f, 0.00021757165f }, { 1.0140226e-05f, 6.1641031e-06f, 1.0590727e-05f, 1.0893212e-05f }, { -1.7442656e-05f, 4.2353331e-05f, 7.4324714e-05f, -1.9484775e-06f } } }, { { { 3.7217719f, 3.6900797f, 3.6899881f, 3.6670816f }, { 0.067826319f, 0.16468028f, 0.083129199f, 0.1336756f }, { 0.66338737f, 0.23883566f, 0.093361469f, 0.10095622f }, { 0.27185537f, 0.20781392f, 0.32216624f, 0.29876595f }, { 2.0776462f, 2.0006156f, 2.0243138f, 2.080345f }, { 0.57695783f, 0.18015147f, -0.11440889f, 0.14229144f }, { 0.63833683f, 0.41431062f, 0.44752994f, 0.47594414f }, { 1.7890608f, 1.962584f, 1.9322155f, 1.6588331f }, { 3.0538128f, 3.108267f, 3.1001573f, 2.9593433f }, { -0.28383051f, -0.27708376f, -0.042513902f, -0.085181891f }, { 0.3873435f, 0.41697884f, 0.39625427f, 0.33250735f }, { -0.33498881f, -0.40206929f, -0.028905862f, -0.48179632f }, { 1.1875033f, 1.3535177f, 1.2526197f, 1.3337495f }, { 0.42579488f, 0.24951727f, 0.18976118f, 0.20605317f }, { -0.53212666f, -0.3861028f, -0.75685995f, -0.23411882f }, { 1.6910165f, 1.686815f, 1.5906473f, 1.6528217f }, { 4.0570657f, 4.0349492f, 4.0350332f, 4.0498099f }, { -0.017225465f, -0.032503897f, 0.46003211f, 0.21602109f }, { 1.1196901f, 1.00885f, 0.91675568f, 0.99635794f }, { -0.093891275f, 0.0809352f, -0.13783332f, 0.27130678f }, { 1.9925136f, 1.9829394f, 1.8820721f, 1.9542026f }, { 0.84563763f, 0.48476746f, 0.37907152f, 0.70267878f }, { 0.37054708f, 0.4228574f, 0.6329822f, 0.26197064f }, { 1.9618393f, 1.8405969f, 1.9440918f, 1.901629f } }, { { -5.6047186e-06f, 6.0454847e-06f, 2.8365975e-06f, 6.0894367e-06f }, { -0.00069876506f, -0.00029642785f, -0.00059516082f, -0.00025400441f }, { -0.00020850504f, -0.00012959593f, -0.00032902532f, -0.00058117893f }, { -0.00037901964f, -0.00038062016f, -0.00023777964f, -0.00033714679f }, { -5.9894351e-05f, -9.820791e-05f, -5.9867157e-06f, -6.258549e-06f }, { -0.00035424038f, -8.7146215e-05f, 3.0398362e-05f, -0.00061406521f }, { 0.00014971442f, 4.5936211e-05f, -5.6259869e-06f, 0.00013567035f }, { -0.00016180211f, 3.1840487e-06f, 3.8979157e-07f, -0.00017131994f }, { -1.9877193e-05f, 2.5768261e-05f, 9.0577543e-06f, -0.00013927462f }, { -0.0012323564f, -0.00042892846f, 7.2082106e-05f, 0.00010999853f }, { -0.00034618449f, -0.00017058897f, -0.00016535057f, -0.00096982024f }, { -0.00028039653f, -7.155747e-05f, -0.00075796707f, 0.00062756458f }, { 6.6596276e-05f, -7.9730809e-05f, -8.0686754e-05f, -2.9532397e-05f }, { -0.00084106867f, -0.00036762453f, 0.00012523548f, -0.00052789663f }, { 7.6718268e-05f, -0.0010042005f, -0.00042802983f, -0.0011951304f }, { -3.6972258e-05f, 2.1447505e-06f, -0.00035448623f, -1.0620008e-05f }, { 2.8326169e-05f, 2.2049468e-05f, 2.2640575e-05f, 1.7574827e-05f }, { -0.00014318496f, -0.0004811524f, -0.00049293303f, -0.00067646484f }, { -2.7469144e-05f, -5.9653763e-06f, -1.3998899e-05f, -0.00018475323f }, { -0.00017314302f, -0.00010954727f, -0.00040004932f, 3.31106e-05f }, { -3.6093435e-06f, -1.6125243e-05f, -4.9195648e-05f, 1.5586886e-05f }, { 0.0002059631f, -0.0004024722f, -0.00047984678f, -9.8485329e-05f }, { -0.00094100913f, -0.00073046048f, -0.00052500163f, -0.00068196784f }, { -2.2820197e-05f, -5.9454557e-05f, -6.2505468e-06f, -2.6569804e-05f } }, { { 2.6015883e-05f, 8.5398335e-06f, 3.8473185e-06f, 9.1409625e-06f }, { -0.00041459247f, -0.0001855224f, -0.00030529542f, -0.00016322166f }, { -8.8427847e-05f, -0.0002302048f, -0.00038072959f, -0.00076801295f }, { -0.00027717792f, -0.00028594346f, -0.00017910208f, -0.00027291164f }, { 2.8409311e-05f, -3.8005817e-05f, -4.2266878e-06f, -1.4520383e-05f }, { -0.0001088827f, -0.00021924377f, 3.9307406e-05f, -0.00032488556f }, { 0.00027997916f, 3.5103699e-05f, -5.7448764e-06f, 0.00010259251f }, { -4.7807894e-06f, -2.9470863e-05f, 2.6656233e-07f, -0.00014346393f }, { 0.00015527098f, -6.8528726e-05f, -1.1206714e-05f, 2.3422595e-05f }, { -0.0012763247f, -0.00051503472f, 0.00058055106f, -0.00068688488f }, { -6.1232076e-06f, -1.7073841e-05f, -0.00033533389f, -0.00078769935f }, { -0.00044113485f, -0.00027577451f, -0.0012008622f, 0.00013071136f }, { 1.834948e-05f, -0.00015615102f, -0.00016449385f, 3.6685217e-05f }, { -0.00063618257f, -0.00032641968f, -5.0281118e-05f, -0.00041378992f }, { -0.0010181884f, -0.0003871932f, -0.00050061147f, -0.0018967455f }, { -5.7650067e-05f, -5.1145774e-06f, -0.00017409773f, 1.9512036e-05f }, { 1.5838743e-05f, 2.503655e-05f, 2.5679098e-05f, 2.0053218e-05f }, { -0.00018055811f, -0.00044345237f, -7.9049557e-05f, -0.00095669161f }, { -4.98611e-05f, -1.1320605e-06f, 3.7756645e-06f, -8.7299215e-05f }, { -0.00011794063f, -0.00015778552f, -0.00036514881f, 4.7288704e-05f }, { -5.1753817e-06f, -1.5040527e-06f, -2.836739e-05f, -9.4945229e-06f }, { 0.00016873335f, -0.00031983601f, -0.00052281245f, 0.00019034815f }, { -0.0011988594f, -0.0010684975f, -0.00057577023f, -0.0009143845f }, { 5.0336006e-05f, -1.356148e-05f, 1.5582694e-05f, -2.0666272e-05f } } }, { { { 0.012207721f, 0.0044164612f, 0.0022704542f, 0.0042008503f }, { 0.29516302f, 0.139976f, 0.35038027f, 0.13748343f }, { 0.1462123f, 0.12114907f, 0.28473665f, 0.45762717f }, { 0.17976664f, 0.19141553f, 0.1209483f, 0.16393769f }, { 0.044254492f, 0.11383095f, 0.0062726904f, 0.023550537f }, { 0.14785458f, 0.10151341f, 0.045717467f, 0.42243971f }, { -0.24205201f, -0.033590842f, 0.0032064617f, -0.093924041f }, { 0.10866955f, 0.016299431f, 0.00081631108f, 0.15856447f }, { 0.10108337f, 0.057931152f, 0.024463589f, 0.21514346f }, { 0.47967783f, 0.75472932f, 0.5653649f, 0.64752457f }, { 0.30082544f, 0.15124922f, 0.23567284f, 0.47161499f }, { 0.54286166f, 0.61049777f, 0.61641378f, 0.51181399f }, { 0.39328762f, 0.25557559f, 0.25875912f, 0.22436901f }, { 0.45699569f, 0.16989563f, 0.2429263f, 0.3924359f }, { 0.92996797f, 1.1024806f, 0.78045387f, 1.2298879f }, { 0.19029829f, -0.022675055f, 0.28113642f, 0.034941166f }, { 0.013203939f, 0.013034069f, 0.013414649f, 0.011688038f }, { 0.076026927f, 0.13838472f, 0.29961655f, 0.31531564f }, { 0.089182386f, 0.010401684f, 0.029374547f, 0.22995838f }, { 0.052198894f, 0.039866726f, 0.11570972f, -0.013818992f }, { 0.0062380932f, 0.01788119f, -0.20765047f, 0.013339281f }, { 0.12436441f, 0.17318651f, 0.21554136f, 0.18600144f }, { 0.38005287f, 0.32135548f, 0.28632777f, 0.29211902f }, { 0.03798742f, 0.0450845f, 0.010912505f, 0.039060104f } }, { { 0.00077914246f, 0.00011130803f, 8.1110229e-05f, -0.00035312557f }, { 0.00051711901f, 0.00029701387f, 0.00040733345f, 0.00034149723f }, { 0.00063893978f, -0.00013702086f, 0.00030866699f, -0.00020070677f }, { 7.5899443e-05f, 9.7456273e-05f, -4.5352178e-05f, 7.6172703e-06f }, { 0.00066250814f, -0.00073033349f, 0.00015225542f, -0.0010197351f }, { 0.00040931533f, -0.00043022747f, 0.00093333285f, 0.0002579685f }, { -0.00067488578f, -0.0003706974f, -0.00044487256f, -0.00056555959f }, { 0.00075838366f, -0.0021903789f, -0.0026744174f, -0.00047135202f }, { -0.00081050821f, -0.0010297809f, -0.00099480849f, -0.00074914246f }, { 0.00063637392f, 5.248783e-05f, 0.00044645091f, 0.00018028446f }, { 0.00067430392f, 0.0004762628f, -0.00032736685f, 0.00041933609f }, { 6.2324555e-05f, -1.6709531e-06f, 0.00057418116f, -0.0010360999f }, { -0.00038256183f, -0.0010104012f, -0.00045533693f, -1.3888404e-05f }, { 0.00068274628f, 0.00068411875f, -0.00091273333f, 0.00016211145f }, { -0.00039440715f, 0.00027665323f, -0.00035895503f, 0.00013423207f }, { -0.00061939017f, 0.00012140102f, 0.00024178233f, 0.00064755788f }, { -0.00052441128f, -0.00050994483f, -0.00051126044f, 0.00066320373f }, { 0.00085915332f, 0.0013567332f, -0.00014328466f, 0.00056098523f }, { -0.0012682676f, 0.0029139719f, 0.0019812291f, -0.00053863027f }, { 0.0021895869f, 0.00062956835f, 0.0018161156f, 0.00011699452f }, { -0.0010337306f, 0.00016880497f, -0.0014942346f, -0.0034402453f }, { -0.0025336946f, -0.00019468865f, -0.00018045349f, -5.4312149e-05f }, { 0.00021491979f, 4.7651714e-05f, -0.00044921151f, 0.00046742044f }, { 0.0019408125f, 0.00044842687f, 0.0026003265f, -0.00090116109f } }, { { -0.0006591255f, 0.00022873584f, 0.00026313866f, -0.00060151354f }, { 0.00027198127f, 0.00034252944f, 0.00033246896f, 0.00035232159f }, { -0.00034460639f, -5.9085725e-05f, 7.836454e-05f, -0.00018946388f }, { 0.00018790551f, 0.0001918358f, 9.7031467e-05f, 0.00015259869f }, { -0.0023033429f, -0.0012945186f, -0.00080964072f, -0.00030432514f }, { -0.001359781f, 0.00055828912f, -0.00041912301f, 0.00019263336f }, { -0.00042789448f, -0.00018313775f, -0.00030217124f, -0.00028437496f }, { -0.0018340159f, 0.00030654336f, -0.00010781402f, -0.0011985455f }, { -0.002103478f, 0.00029492518f, -0.00042283946f, -0.001472689f }, { 0.00064558079f, 0.00049703204f, -0.00018932594f, -0.00038268301f }, { -0.00097813334f, -0.00057838807f, 0.00079268109f, 0.00039650774f }, { -0.00017335252f, 0.00074363734f, 0.0008194423f, -0.00065923207f }, { -0.00075344545f, -0.00026114262f, -0.00054658657f, -0.0013814943f }, { -0.00028279346f, 0.00055730283f, 0.00048990213f, -0.00022186466f }, { 0.00013438509f, -0.0001962818f, -0.00036195953f, 0.00042669461f }, { -0.00089003585f, -0.0011600794f, -0.0012554286f, -0.0012892408f }, { -0.00067007058f, -0.0010597247f, -0.0010590421f, 0.00044132516f }, { 0.0011626727f, 0.001261033f, -0.00072912018f, 0.00076332442f }, { -0.001204702f, -0.00011230019f, 0.00036178615f, -0.0017559004f }, { 0.00096282849f, 0.001025959f, 0.0011696947f, 0.00046633555f }, { -0.00082328571f, -0.00075771669f, -0.0011629302f, 0.00073458863f }, { -0.0016869269f, -0.00035239862f, -0.0004024204f, -0.0016276971f }, { 0.00029053123f, 0.00013409355f, -0.00049087974f, 0.00061969429f }, { -0.0013198997f, -0.0018615784f, -0.0025724061f, -0.0015563017f } } } }, { { { { -0.072246889f, -0.043157285f, 0.043289306f, 0.095998047f }, { 0.12597079f, 0.24289541f, -0.10930005f, -0.24150539f }, { 0.031889347f, -0.036238337f, -0.014521983f, -0.018963885f }, { -0.044155351f, -0.0077170425f, -0.043781059f, 0.047982339f }, { 0.093995001f, -0.0079510758f, -0.04688882f, -0.11125523f }, { 0.01700754f, -0.0034361033f, 0.055252382f, -0.053119426f }, { -0.0014957087f, -0.00063057103f, 0.037930463f, 0.017656646f }, { -0.017388477f, -0.084085888f, -0.067726647f, 0.061397079f }, { -0.070625168f, -0.061293011f, -0.077366932f, 0.11518646f }, { -0.14771316f, -0.12543895f, 0.052150789f, 0.10530462f }, { -0.03609139f, 0.001131616f, -0.039549928f, 0.03805765f }, { 0.064364205f, 0.066758929f, 0.045537002f, -0.05510954f }, { 0.049051369f, 0.098312455f, -0.01079726f, -0.11202623f }, { 0.033012208f, -0.0013996988f, -0.0049458824f, -0.028981527f }, { 0.008617177f, -0.00017670863f, -0.0052380282f, -0.0023438457f }, { -0.05901498f, -0.050754807f, -0.00011829844f, 0.037297411f }, { -0.056264446f, -0.03645315f, -0.066412698f, 0.019549244f }, { -0.11401603f, -0.11856524f, 0.12275022f, 0.11635143f }, { -0.0011999881f, -0.0016334327f, -0.0056868938f, 0.013393766f }, { 0.054526972f, 0.033632235f, 0.062591094f, -0.0025531074f }, { 0.073041316f, 0.073735243f, -0.06935254f, -0.11214186f }, { 0.034872822f, -0.015473423f, 0.037359975f, -0.026829465f }, { -0.015137592f, -0.0064462553f, 0.011771178f, 0.0025042048f }, { -0.038708904f, -0.033968131f, -0.044070885f, 0.024422773f } }, { { -0.047895007f, -0.016535938f, 0.04855533f, 0.018341613f }, { 0.004310087f, 0.01519838f, -0.0033290683f, -0.013597406f }, { 0.0015859181f, 0.016869623f, -0.019279963f, -0.01426933f }, { -0.0061048976f, 0.031131561f, 0.018085381f, -0.017927117f }, { 0.052590378f, 0.0066156852f, -0.0025756141f, -0.037241705f }, { 0.0083512619f, 0.0046235666f, 0.024122126f, -0.013443654f }, { 0.0010672274f, 0.00053123301f, -0.0016276029f, -0.04221993f }, { -0.0048754166f, -0.021474788f, -0.0039993317f, 0.011831691f }, { -0.054685347f, -0.050242732f, -0.007606251f, 0.043061893f }, { -7.5644942e-05f, 0.00086632318f, 0.0001960729f, 0.0013264286f }, { 0.0042413724f, -0.0057181522f, 0.0065940983f, -0.0078263328f }, { 0.0031260881f, -0.0013520907f, 0.025073658f, -0.010841673f }, { 0.038353769f, 0.06620308f, -0.0072105562f, -0.079188681f }, { 0.003099559f, -0.0022927921f, 0.021982683f, -0.018991144f }, { 0.012285675f, 0.0091834074f, -0.0041874571f, -0.032253924f }, { -0.014563556f, 0.009843969f, -0.010490279f, 0.012979866f }, { -0.005492286f, 0.064109426f, -0.034795617f, -0.020395732f }, { -0.023364141f, -0.059336321f, 0.080710391f, 0.038948527f }, { 0.0028384819f, 0.001822471f, 0.0012903958f, 0.012781079f }, { -0.004510518f, -0.0020008272f, 0.0017752876f, 0.0077607089f }, { 0.032279653f, 0.0041906079f, -0.034682371f, 0.0061335907f }, { -0.0082992317f, -0.025250117f, -0.017026845f, -0.028345042f }, { -0.013132125f, -0.026688493f, -0.0014827793f, -0.003236826f }, { 0.01650781f, 0.002313574f, -0.012897922f, 0.026077933f } }, { { 0.062668058f, 0.0081578851f, 0.018952049f, -0.012267283f }, { 0.0008567722f, 0.0033246009f, -0.0037620102f, -0.0096317368f }, { -0.0083012273f, 0.01184624f, -0.01209373f, 0.020208536f }, { 0.013862003f, 0.019166381f, 0.013235471f, -0.026788736f }, { -0.021904217f, -0.051018749f, 0.0020330268f, 0.006626371f }, { -0.015856131f, 0.0028024655f, -0.032825412f, -0.018920906f }, { 0.0020870233f, 0.0011616727f, -0.0032704368f, -0.027327141f }, { 0.01934969f, 0.002427195f, 0.049925128f, -0.0061414889f }, { 0.013158375f, 0.022248445f, 0.040266734f, -0.017583455f }, { 1.9024812e-05f, 0.00071602053f, 0.0012622199f, 0.0018791611f }, { -0.0011857767f, 0.0023417924f, 0.026237548f, -0.014687892f }, { -0.041419782f, 0.024942194f, -0.029143101f, 0.036590943f }, { -0.015470651f, -0.035208671f, -0.038530514f, 0.037434376f }, { -0.0029356279f, 0.0023358079f, 0.017641055f, 0.0038203652f }, { -0.0030449623f, -0.010187444f, 0.0066142145f, 0.0037433206f }, { 0.0080034603f, 0.011463159f, -0.0058129532f, 0.011831147f }, { -0.0091743137f, 0.045949289f, 0.022412137f, -0.0067531419f }, { 0.00069946656f, -0.0068974782f, 0.0091806954f, 0.0022160793f }, { -0.0027530077f, 0.00089797627f, 0.0066153093f, -0.010355635f }, { -0.019399018f, -0.0085762573f, 0.0208003f, -0.027739023f }, { -0.014354809f, -0.011971089f, -0.0031124986f, 0.044710091f }, { -0.011411144f, 0.0073253411f, -0.0087561348f, -0.014838738f }, { 0.018837992f, 0.00231775f, -0.013982978f, -0.0020044658f }, { 0.0012069362f, 0.0012202952f, 0.029106153f, 0.00062793994f } } }, { { { 0.054154158f, -0.11603661f, -0.025631275f, 0.054671866f }, { -0.2359715f, 0.093194255f, 0.21874866f, -0.08378526f }, { 0.0089903397f, 0.0087113885f, -0.015445726f, 0.011142042f }, { -0.0055372249f, -0.0041494086f, -0.033355186f, -0.010136823f }, { -0.015010227f, -0.0077144008f, 0.13058394f, -0.016779666f }, { -0.015855009f, 0.014090685f, 0.026549575f, 0.025677527f }, { -0.00065423811f, -0.0011506403f, 0.028628751f, 0.0086359197f }, { -0.010571292f, 0.035861454f, -0.025871285f, -0.024827688f }, { 0.00010603924f, 0.011433504f, -0.052819957f, -0.020208661f }, { 0.12243361f, -0.14574398f, -0.10091072f, 0.054524772f }, { -0.014659734f, -0.02291001f, 0.010102434f, -0.0099333349f }, { -0.0079939087f, 0.023468399f, 0.044548395f, 0.04568814f }, { -0.048188816f, 0.016469102f, 0.084818672f, -0.040634065f }, { 0.015089138f, 0.025396216f, 0.017000121f, 0.010820807f }, { -0.0098155552f, -0.00080001495f, 0.0020122754f, -0.00046896909f }, { -0.0018906417f, -0.03909342f, -0.020339049f, -0.024007559f }, { -0.0012744487f, -0.027829333f, -0.05202457f, -0.024366779f }, { 0.10406956f, -0.092281421f, -0.050420166f, 0.10716663f }, { -0.0049603976f, -0.0055370076f, -0.0016910106f, 0.012172389f }, { -0.0026486448f, 0.038673757f, -0.0016176887f, 0.052692494f }, { -0.03722357f, 0.055455783f, 0.067738953f, -0.0087990582f }, { -0.0026491637f, 0.017275247f, 0.010687117f, 0.020312052f }, { -0.0016032469f, 0.0090272843f, -0.0079027514f, -0.0050039898f }, { -0.0073653412f, -0.033150577f, 0.0082912493f, -0.021457881f } }, { { -0.0059001999f, 0.033600833f, 0.066374213f, -0.018058548f }, { -0.0037864945f, -0.0064946131f, 0.0018627774f, 0.0044899139f }, { 0.0048961861f, -0.0034770968f, -0.0002311598f, -0.0053935761f }, { 0.0090090757f, 0.012149811f, 0.0029969663f, 0.0049403543f }, { -0.042874682f, -0.0083455851f, -0.0064437344f, 0.0010579362f }, { 0.011866873f, -0.017157526f, -0.014724976f, 0.0054373752f }, { -0.0006329516f, -0.00024834697f, 0.0015416168f, -0.014246989f }, { 0.031530357f, -0.052715858f, -0.0063186617f, -0.0070200141f }, { -0.0082273844f, 0.053856605f, 0.0096812384f, 0.01684635f }, { -0.00017150577f, 0.00097354737f, 0.0013944706f, 0.00085166684f }, { -0.013604545f, 0.0089329355f, -0.013809086f, 0.0025044469f }, { -0.020284731f, 0.0004724419f, -0.045697697f, -0.01844702f }, { 0.017874081f, -0.0040537465f, -0.023316716f, -0.026344708f }, { 0.0092557469f, -0.014456327f, -0.0092919835f, 0.0091758924f }, { 0.016058873f, 0.0019220807f, 0.0031692823f, 0.0024577167f }, { -0.021184352f, 0.021287579f, -0.0048442696f, 0.0095799112f }, { 0.035229915f, -0.054291919f, -0.013871324f, 0.035585241f }, { 0.001275203f, 0.011513119f, 0.020184769f, -0.0061701639f }, { 0.011353237f, 0.0052697685f, 0.0047637419f, -0.020278005f }, { 0.0068266296f, -0.01173749f, 0.037482577f, -0.0083236299f }, { 0.025699221f, -0.03651135f, -0.032342446f, -0.0059784486f }, { 0.0029540635f, -0.0021598269f, 0.0028168477f, 0.0044577193f }, { 0.0038274002f, -0.0050806333f, 0.007628551f, 0.0027461742f }, { 0.0056567464f, 0.006846664f, -0.031161558f, -0.0040832656f } }, { { 0.025668431f, 0.0093723617f, 7.4324163e-05f, -0.023051436f }, { -0.010148124f, 0.0018159908f, 0.0072269566f, 0.00082671261f }, { 0.0069741056f, 0.023493533f, 0.028507618f, -0.026874125f }, { 0.0083316277f, -0.024891629f, 0.013623217f, 0.0038373532f }, { -0.020992516f, 0.070912136f, -0.0014634877f, -0.015680371f }, { 0.02178962f, -0.003772636f, -0.024578501f, -0.047467019f }, { 0.0028586275f, 0.0033445767f, 0.0049576063f, -0.017365739f }, { 0.0075721122f, 0.010652219f, -0.024031886f, -0.0001146548f }, { 0.016381176f, -0.044765924f, -0.038036229f, -0.014041395f }, { -0.00082564842f, 0.00033107944f, 0.00073792054f, 0.0005712734f }, { 0.0080934887f, 0.014534447f, -0.0071347609f, 0.0085413493f }, { -0.018211778f, 0.0064443848f, 0.017393403f, 0.011490985f }, { -0.071531366f, 0.030059694f, 0.049103287f, 0.0074609412f }, { 0.00770209f, -0.017999995f, -0.040048679f, -0.0029073853f }, { 0.020442166f, 0.0019454488f, -0.019644905f, 0.021793285f }, { 0.035171271f, 0.0080192155f, -0.023151504f, 0.014168348f }, { -0.048901887f, -0.0039613606f, 0.0021703807f, 0.030275152f }, { 0.044666116f, -0.029756153f, -0.015570779f, 0.034470632f }, { -0.0078700362f, 0.0037551741f, 0.0003070052f, -0.0031237403f }, { 0.015288427f, -0.01284757f, -0.0075319169f, 0.026981487f }, { -0.0093872483f, 0.013517073f, -0.030221944f, 0.058356065f }, { 0.0042326205f, -0.016381154f, 0.021475001f, 0.01008732f }, { 0.0034929117f, 0.020531314f, -0.0085114063f, 0.004821913f }, { 0.014314413f, 0.01127037f, -0.017197896f, 0.0046932185f } } }, { { { 0.99591552f, 0.99230689f, 0.99873374f, 0.99387895f }, { 0.96356049f, 0.96556546f, 0.96964041f, 0.96677566f }, { 0.99945097f, 0.99930521f, 0.99977525f, 0.99975808f }, { 0.99900933f, 0.99996161f, 0.99848418f, 0.99879675f }, { 0.99545951f, 0.99993863f, 0.99032786f, 0.9936502f }, { 0.99972964f, 0.99989482f, 0.99811938f, 0.99825798f }, { 0.99999867f, 0.99999914f, 0.9988702f, 0.99980681f }, { 0.99979292f, 0.99581299f, 0.99736843f, 0.99780458f }, { 0.99750292f, 0.99805433f, 0.99560254f, 0.9931383f }, { 0.98142286f, 0.98133774f, 0.99352772f, 0.9929441f }, { 0.99924096f, 0.99973689f, 0.99916652f, 0.99922617f }, { 0.99789446f, 0.9974931f, 0.99796885f, 0.99743448f }, { 0.9976331f, 0.99501931f, 0.9963379f, 0.99287411f }, { 0.99934104f, 0.99967648f, 0.99984325f, 0.99952138f }, { 0.9999147f, 0.99999966f, 0.99998426f, 0.99999714f }, { 0.99825531f, 0.99794572f, 0.99979313f, 0.99901579f }, { 0.99841509f, 0.99894779f, 0.99643504f, 0.99951192f }, { 0.98801309f, 0.98864879f, 0.99115599f, 0.98740957f }, { 0.99998698f, 0.99998334f, 0.9999824f, 0.99983621f }, { 0.99850879f, 0.99868574f, 0.99803794f, 0.99860752f }, { 0.99663402f, 0.99573479f, 0.99528974f, 0.99365325f }, { 0.99938825f, 0.99973103f, 0.99924472f, 0.99943364f }, { 0.99988413f, 0.99993848f, 0.99989949f, 0.99998434f }, { 0.99922338f, 0.99887297f, 0.998994f, 0.9994714f } }, { { -0.0050599833f, 0.003362263f, 0.0035202243f, -0.00056864904f }, { -0.0014675187f, -0.0029154981f, -0.00077796172f, -0.0027392627f }, { -0.0010916411f, 0.00078232803f, 0.0014339533f, -0.0020166729f }, { 0.011183745f, 0.008298699f, 0.011631254f, 0.00030693508f }, { -0.0012964861f, -0.00028098882f, 0.00098513135f, -0.0052243577f }, { 0.0091119501f, 0.002780703f, 0.011045274f, 0.00334383f }, { 4.1103001e-05f, 5.5767744e-05f, 0.0030605577f, 0.0022152241f }, { 0.00085375099f, 0.0026952672f, 0.0071937971f, 0.0056504112f }, { -0.003773118f, 0.0047936307f, -4.5743022e-05f, -0.0038357994f }, { 2.3815581e-05f, 0.0002468657f, 0.00013492048f, -0.00018410816f }, { 0.0070959632f, -0.00205589f, 0.0056417297f, 0.0030702073f }, { 0.010671769f, 0.0074346008f, 0.0012867659f, 0.0075437523f }, { -0.0013037272f, -0.0058374269f, 0.0025899757f, -0.0071565118f }, { 0.0030041304f, 0.0018011397f, 0.0093160386f, 0.0082062863f }, { 0.0053156934f, 0.0036543193f, 0.0048724246f, 0.0035118324f }, { -0.0053866158f, 0.0024053442f, 0.00052459148f, 0.0090970513f }, { 0.011239324f, -0.0010327051f, -0.00097551594f, 0.0044180668f }, { -0.0024379533f, -0.0088232426f, -0.012355568f, -0.0031875953f }, { 0.0026244123f, 0.0011858999f, 0.0028110843f, -0.001005442f }, { 0.0059514328f, 0.0018892606f, 0.0050231625f, 0.0046700575f }, { 0.00050741664f, 0.0096547476f, -0.00079618251f, 0.0024532112f }, { 0.0058717468f, -0.0017457656f, 0.0080261577f, -0.00048009588f }, { 0.0025457914f, 0.0016788968f, 0.0013982313f, 0.00073909928f }, { 0.0075035778f, 0.011234409f, 0.0079271096f, 0.006672353f } }, { { 0.0095152396f, 0.0011785006f, -0.00081996856f, 0.0018904938f }, { -0.0025430397f, -0.0010236291f, -0.0020168276f, -0.0021827861f }, { 0.0036295778f, 0.005406882f, 0.0040788276f, -0.0057729163f }, { -0.00029952998f, 0.0024548208f, 0.0088548836f, 0.0019084209f }, { 0.0034184324f, -0.0088925589f, 0.00023040452f, 0.00017437939f }, { 0.0037804595f, 0.012156355f, 0.0041276361f, 0.012721488f }, { 7.4846461e-05f, 0.00010580108f, 0.013483417f, 0.0024239851f }, { 0.00026411032f, -0.00059353627f, 0.0093564271f, 0.0061507538f }, { 0.0016065383f, -0.0027764641f, 0.0013620195f, 0.0010062065f }, { 9.7127925e-05f, 0.00017275393f, 1.0814607e-05f, -0.00022627793f }, { 0.0048710612f, -0.00014794569f, 0.0082832436f, -0.00072595412f }, { -0.0027392579f, 0.0066783951f, 0.00087397132f, 0.001567366f }, { -0.003378151f, 0.0025916338f, -0.0025553201f, 0.0030152022f }, { 0.0096818399f, 0.0012695523f, 0.0072489949f, 0.016881099f }, { 0.0022796191f, 0.0051693266f, 0.0023373397f, -0.0041448561f }, { -0.0002074582f, 0.0035962454f, -0.0007460719f, 0.0025086317f }, { 0.0035784996f, 0.003162753f, 0.0022592918f, 0.00024595998f }, { -0.0051294944f, -0.0041428868f, -0.0027597f, -0.0039539398f }, { 0.0022410392f, 0.00031263884f, 0.0016376751f, -0.0022787113f }, { 0.0025647038f, 0.0074733037f, 0.0051722028f, 0.0024463612f }, { 0.0011787227f, 0.0071159753f, 0.0017217143f, 0.0062717989f }, { 0.0046836737f, 0.0038976423f, 0.00062832002f, 0.0027638154f }, { 0.0014142926f, 0.0024903802f, 0.0015757227f, 0.0011628587f }, { 0.0016928585f, 0.0043828548f, 0.001653268f, 0.011450696f } } }, { { { 2.8886078f, 2.8900127f, 2.7925705f, 2.7895874f }, { 4.5455217f, 4.5284714f, 4.7042338f, 4.6915273f }, { 0.96672505f, 0.99303664f, 0.98927606f, 1.0351588f }, { 1.2743756f, 1.2525364f, 0.99649566f, 0.94572778f }, { 2.6910679f, 2.6922168f, 2.8503404f, 2.8246076f }, { 1.256075f, 1.2325025f, 1.5911826f, 1.6091223f }, { 1.3601759f, 1.3606869f, 1.2793533f, 1.240925f }, { 2.0291828f, 2.0506809f, 1.7341658f, 1.6555689f }, { 2.6663531f, 2.6921882f, 3.1290975f, 3.11849f }, { 5.3676887f, 5.3663279f, 5.3848664f, 5.3852162f }, { 1.0586431f, 1.0865889f, 0.8196623f, 0.8076665f }, { 1.6967251f, 1.7305944f, 1.5450413f, 1.6347879f }, { 3.0908857f, 3.0706775f, 3.2974343f, 3.3053965f }, { 1.2172073f, 1.3839086f, 1.5086796f, 1.4295506f }, { 0.97676668f, 1.0856738f, 0.98747912f, 1.0385491f }, { 1.5662275f, 1.4603538f, 1.784278f, 1.6575438f }, { 2.1085757f, 2.2092885f, 2.1410448f, 2.1518347f }, { 4.0214776f, 4.006424f, 3.7686967f, 3.7771354f }, { 1.2089239f, 1.2116036f, 1.1244311f, 1.0901017f }, { 1.1827246f, 1.1472796f, 1.7516784f, 1.7833976f }, { 2.2113439f, 2.197512f, 2.2692963f, 2.2787751f }, { 0.98819531f, 1.057833f, 1.3587301f, 1.3890421f }, { 1.208957f, 1.2247867f, 1.2301205f, 1.2325178f }, { 1.0499613f, 1.1319197f, 1.4067885f, 1.3209087f } }, { { -0.002860931f, -0.0033581281f, -0.0047612075f, -0.0030481839f }, { -0.0017370907f, -0.0065700936f, -0.0011051926f, -0.0046915938f }, { -0.0006126207f, 0.0010791181f, -0.022876686f, -0.015937275f }, { -0.010040922f, -0.016433531f, -0.0044976975f, -0.029838315f }, { 0.00056888968f, -0.0093450028f, -0.00041549218f, -0.0069079656f }, { -0.029781683f, -0.019722587f, 0.019472312f, 0.0016798037f }, { -0.0015128736f, -0.0012250172f, -0.0091568262f, -0.0091368119f }, { 0.0010846814f, 0.0017189068f, 0.012975603f, -0.0051530971f }, { -0.026042808f, -0.0090684857f, -0.0021498742f, -0.0032938309f }, { -0.0012792901f, -0.0010431731f, -0.0021366737f, -0.0025526365f }, { -0.03218779f, -0.013848893f, -0.021872476f, -0.029443623f }, { 0.008300061f, 0.011951182f, -0.011139414f, 0.0098292843f }, { -0.0065854884f, -0.020955083f, -9.3843515e-05f, -0.0078425688f }, { -0.054726229f, -0.0073673428f, -0.019267231f, -0.03383648f }, { -0.049769726f, 0.0065482059f, -0.010189395f, -0.0050480393f }, { 0.022565943f, -0.020311569f, 0.0091512717f, -0.015600752f }, { -0.014418429f, 0.0060070592f, -0.0055296743f, -0.003361885f }, { 8.8146509e-05f, -0.0082609252f, 0.0036746024f, 0.0040108321f }, { 0.0010230427f, 4.8153189e-06f, 0.0052893378f, -0.0096303521f }, { 0.0032909351f, -0.010982824f, 0.003880027f, 0.0097699095f }, { -0.006528317f, -0.012608887f, -0.0057088008f, -0.003867806f }, { -0.046599771f, -0.024701737f, -0.001078321f, -0.0041018649f }, { -0.021680777f, -0.021120711f, 0.0055144734f, -0.0031337995f }, { -0.030559213f, 0.0089872726f, -0.011166202f, -0.0077587071f } }, { { -0.0059548858f, -0.0040070313f, -0.0062572119f, -0.0047711065f }, { -0.0031938803f, -0.005431389f, -0.0026376521f, -0.0046119366f }, { 0.0064917253f, 0.013030824f, -0.027850471f, -0.011824849f }, { -0.032644485f, -0.025045016f, -0.0034396539f, -0.039827623f }, { -0.007691681f, -0.014095643f, -0.0008171964f, -0.0051336386f }, { -0.035626586f, -0.021424668f, 0.00035790929f, 0.0099705685f }, { -0.0019006762f, -0.0014887089f, -0.0050782898f, -0.0096835564f }, { -0.00087496879f, 0.0052586834f, 0.017041675f, -0.00046753956f }, { -0.022489507f, -0.0084834888f, 0.0017184219f, -0.0023910992f }, { -0.0010618265f, -0.00085888729f, -0.0020035777f, -0.0024245283f }, { -0.029245834f, -0.038977066f, -0.013385246f, -0.030312138f }, { -0.0028497869f, 0.014205986f, -0.0125692f, 0.0037959624f }, { -0.0086377959f, -0.019175965f, -0.007684309f, -0.005037677f }, { -0.063945685f, -0.0060751259f, -0.0057457302f, -0.019079575f }, { -0.043745147f, 0.013651906f, -0.034067394f, 0.0012111497f }, { 0.0086647574f, -0.019171418f, 0.020745219f, -0.0055629951f }, { -0.024541273f, 0.0072112135f, -0.0078821942f, -0.0085072621f }, { -0.0018227939f, -0.0021153099f, 0.008577002f, 0.0043865151f }, { -0.013984752f, -0.012209334f, 0.00023638151f, -0.0085025952f }, { -0.0099800075f, -0.0095390578f, 0.0081328135f, 0.012673433f }, { -0.0099975551f, -0.0028467616f, -0.010712056f, -0.0045012212f }, { -0.011329139f, -0.0084709831f, -0.0070232966f, 0.0015504012f }, { -0.015334801f, -0.0075637633f, -0.01107439f, -0.0094188163f }, { -0.017505269f, -0.00013701888f, -0.033955823f, -0.034192649f } } }, { { { 0.16413327f, 0.084074422f, 0.10646123f, 0.18806073f }, { 0.039511019f, 0.058967072f, 0.035166958f, 0.052296507f }, { 0.26970995f, 0.21576211f, 0.2954278f, 0.29870678f }, { 0.40442043f, 0.38744132f, 0.14502571f, 0.24076804f }, { 0.22655046f, 0.20912486f, 0.015295019f, 0.16442957f }, { 0.69235319f, 0.6080183f, 0.36756076f, 0.23314717f }, { 0.085565328f, 0.075535626f, 0.22162979f, 0.33140596f }, { 0.16109547f, 0.11961895f, 0.26619212f, 0.25941009f }, { 0.27077686f, 0.23481238f, 0.063446408f, 0.11614487f }, { 0.026116057f, 0.027491327f, 0.030421883f, 0.039965345f }, { 0.33922592f, 0.38039792f, 0.27167385f, 0.31510976f }, { 0.32744968f, 0.22567102f, 0.23116584f, 0.18867836f }, { 0.29783431f, 0.28054079f, 0.26752139f, 0.23889932f }, { 0.61721263f, 0.60602797f, 0.51283622f, 0.47601102f }, { 0.51383952f, 0.53111455f, 0.44519064f, 0.42875877f }, { 0.3485879f, 0.35374178f, 0.53292055f, 0.53995494f }, { 0.4366997f, 0.35554257f, 0.14878367f, 0.22083288f }, { 0.12855375f, 0.16718264f, 0.17583661f, 0.11125895f }, { 0.35898096f, 0.37222307f, 0.35439108f, 0.35956111f }, { 0.16773044f, 0.25668894f, 0.23246756f, 0.1506316f }, { 0.36172813f, 0.26938211f, 0.20069185f, 0.1714591f }, { 0.3998571f, 0.23607244f, 0.34121623f, 0.29126696f }, { 0.31471307f, 0.29500525f, 0.39451396f, 0.40013999f }, { 0.29554399f, 0.28083636f, 0.47190649f, 0.47892938f } }, { { 0.01419653f, -0.061214452f, -0.032506906f, 0.0078227125f }, { -0.015799432f, 0.0136148f, -0.0090824684f, 0.013638505f }, { 0.023848919f, 0.022034707f, 0.022812846f, 0.022790329f }, { -0.0026324255f, -0.0053566952f, 0.00027470228f, 0.050203583f }, { 0.0035659857f, -0.02015272f, -0.039043616f, 0.054511651f }, { 0.0052075445f, 0.0051043119f, -0.011801097f, -0.0074336577f }, { 0.020735195f, 0.01811747f, 0.00808952f, 0.01140964f }, { -0.0073139049f, 0.011075347f, 0.0057685988f, 0.010251582f }, { 0.024813488f, -0.01629986f, -0.012536791f, -0.01110061f }, { -0.014508648f, -0.021444084f, -0.023836972f, -0.014258253f }, { 0.0079687141f, -0.00092011446f, 0.060249601f, 0.033199468f }, { -0.020822483f, -0.013924875f, -0.005068391f, -0.016928794f }, { -0.030059f, -0.013887475f, -0.045329289f, -0.04449219f }, { 0.007264541f, 0.0015213919f, -0.0066322618f, -0.0036449174f }, { 0.0057175046f, 0.0012159867f, -0.00054271896f, 0.0020625484f }, { 0.0027083179f, -0.0012554897f, -0.0044854592f, -0.0045242423f }, { -0.017906563f, -0.028301884f, -0.010139427f, 0.0035851304f }, { -0.020245794f, 0.01149232f, 0.011320484f, -0.013561794f }, { 0.0068048997f, 0.011957759f, 0.0046962412f, -0.0015476541f }, { -0.0022514613f, 0.019996868f, 0.0051520398f, -0.023405604f }, { 0.0055213198f, 0.0070384134f, 0.024405643f, -0.02050399f }, { 0.039987541f, 0.021127504f, -0.012323503f, -0.0041538161f }, { 0.0072321478f, 0.0053097351f, 0.0039966161f, 0.013617175f }, { 0.030470642f, 0.0044694115f, -0.0024591651f, -0.0027274707f } }, { { -0.040500402f, -0.039657034f, -0.017497359f, -0.017857145f }, { -0.0015646885f, -0.020957371f, -0.0057356498f, -0.0060587007f }, { 0.0070388709f, -0.013205178f, -0.00033412934f, 0.02192306f }, { -0.0042317723f, 0.020620857f, -0.012309167f, 0.065948811f }, { -0.016686589f, 0.013616667f, 0.030139062f, -0.019023551f }, { 0.015181564f, 0.008673659f, -0.0014559576f, -0.025916054f }, { 0.031630671f, 0.027030197f, -0.026982415f, 0.025214731f }, { -0.003845127f, -0.00062884599f, -0.029488655f, -0.0051457939f }, { -0.0032476351f, 0.0021153707f, -0.033110808f, -0.033629213f }, { -0.0064637077f, -0.010805748f, -0.014982403f, -0.0084641529f }, { 0.0087766042f, 0.017780238f, 0.026838871f, 0.032580257f }, { 0.0010700985f, -0.037414784f, -0.0053773565f, 0.0040969752f }, { -0.02637392f, -0.050236074f, -0.048422986f, -0.069357813f }, { -0.0089483588f, 0.0026259727f, 0.0040142797f, -0.010752754f }, { -0.0025658872f, 0.0071106029f, 0.015467367f, 0.0012536589f }, { -0.0037247444f, -0.0036991733f, -0.015429566f, -0.016148852f }, { -0.024788221f, -0.045938054f, -0.028679471f, 0.011593494f }, { -0.032699114f, -0.036800967f, -0.033870575f, -0.031842203f }, { 0.018156047f, 0.02457546f, 0.0209432f, 0.015057433f }, { 0.0043152638f, 0.025831372f, -0.019608349f, -0.026614397f }, { -0.0057047815f, -0.013831909f, 0.027613211f, -0.043616864f }, { 0.014124478f, -0.010786326f, 0.010775415f, -0.023241344f }, { 0.018337827f, 0.0048735321f, 0.018371717f, 0.022106807f }, { 0.013619207f, 0.022051384f, 0.0082720974f, -0.0030262071f } } } }, { { { { 0.083322661f, 0.079807165f, 0.03660117f, -0.051657142f }, { -0.099216074f, -0.0080141573f, 0.10637241f, 0.0367403f }, { 0.20813681f, -0.0001361621f, -0.20762563f, -0.085913357f }, { -0.22091149f, 0.10003156f, -0.16122219f, 0.31542901f }, { 0.16226908f, 0.02665194f, -0.012123307f, -0.16559939f }, { -0.14025496f, 0.025804505f, 0.076174345f, 0.20548591f }, { 0.0035713609f, -0.0092551928f, -0.099937652f, 0.0038879391f }, { 0.12405732f, -0.0053373497f, -0.030865175f, -0.060934551f }, { -0.0060175826f, -0.026583926f, -0.075326797f, -0.0063155886f }, { 0.036389362f, 0.054175433f, 0.06490927f, -0.038784258f }, { 0.30604876f, -0.030813476f, 0.011402956f, -0.21074796f }, { -0.31769497f, 0.046793931f, -0.038212559f, 0.21137297f }, { 0.12952945f, 0.20720126f, 0.08525845f, -0.14568109f }, { -0.09735197f, -0.17799099f, -0.12256082f, 0.038889119f }, { 0.002114572f, 0.026037779f, -0.0036772795f, 0.13478173f }, { 0.094577863f, 0.0057382415f, -0.087017736f, -0.059444148f }, { 0.054953104f, 0.071323301f, 0.097417831f, 8.3254475e-05f }, { -0.11005534f, 0.027214076f, 0.0059378205f, 0.02443999f }, { 0.27096654f, 0.1864966f, 0.034810947f, -0.25886676f }, { -0.35626794f, 0.037256657f, -0.17795321f, 0.52988269f }, { 0.14913899f, -0.0086988732f, -0.028760192f, -0.21779266f }, { -0.16010301f, -0.17699785f, 0.017269826f, 0.17878541f }, { -0.0049504093f, -0.02387924f, -0.04034852f, -0.060461173f }, { 0.10405347f, 0.0072745723f, -0.10244372f, -0.072981984f } }, { { 0.019363393f, 5.327311e-05f, 0.0075925373f, 0.0019542034f }, { -0.051707557f, 0.06554253f, 0.0050626046f, -0.0061857803f }, { 0.022891698f, 0.014872273f, -0.020436928f, 0.0069081531f }, { -0.044566611f, 0.019854557f, 0.023600607f, -0.0055387351f }, { 0.02283957f, -0.067086756f, 0.088865856f, -0.033915007f }, { 0.0020254431f, -0.16422426f, 0.032495902f, 0.012460808f }, { -0.017316175f, 0.023440087f, 0.011459595f, 0.0043887872f }, { 0.027714908f, -0.06907548f, 0.013578806f, -0.009848884f }, { 0.0044782488f, 0.0079432606f, 0.010143137f, 0.023589488f }, { 0.014325082f, 0.0075465848f, -0.0079373813f, -0.0056032635f }, { 0.025123579f, 0.01904807f, -0.0092328848f, -0.019002052f }, { -0.02633985f, -0.019560519f, -0.065544737f, 0.0073352606f }, { 0.044308433f, -0.0032233834f, 0.01324206f, -0.00047128106f }, { -0.076577611f, -0.021853603f, -0.020190543f, 0.0026420865f }, { -0.0029799448f, -0.0083566545f, 0.14896601f, 0.0078617095f }, { 0.021033237f, -0.08234711f, -0.020642328f, -0.0089829962f }, { 0.043793881f, 0.0096494147f, 0.035831274f, -0.01294602f }, { -0.014064874f, 0.066144489f, 0.0143429f, 0.015113964f }, { 0.043111732f, 0.0029232804f, -0.016912145f, 0.012142059f }, { 0.0014186333f, -0.0078590166f, 0.065781153f, -0.038375123f }, { 0.02255714f, -0.030191796f, -0.078373164f, -0.0017593196f }, { -0.033878798f, 0.016266579f, 0.013539653f, 0.043519216f }, { 0.019046482f, 0.0080403173f, -0.0010755939f, 0.03305222f }, { 0.023206448f, -0.054323067f, -0.035173093f, -0.010873592f } }, { { 0.014068291f, -0.026418786f, 0.016375695f, 0.0048801469f }, { 0.024404214f, 0.0073572002f, -0.027247654f, 0.00093849398f }, { 0.012741523f, -0.012913063f, 0.0054881373f, -0.021780769f }, { -0.020497215f, 0.057437717f, 0.0031122704f, 0.014713732f }, { 0.012765254f, -0.052846334f, 0.048042201f, 0.0016578534f }, { 0.031245254f, -0.0469321f, -0.057199738f, 0.012436479f }, { -0.0022837759f, 0.0068501747f, 0.010541107f, -0.0005227683f }, { -0.0187059f, 0.0025631581f, -0.0082184266f, 0.0026294483f }, { 0.0053899388f, -0.0199458f, 0.0023448066f, 0.016215236f }, { 0.021117204f, 0.010868775f, -0.016412681f, -0.016399297f }, { -0.0026199223f, -0.011436548f, 0.0031355049f, 0.011933919f }, { 0.017940023f, 0.090292392f, -0.061029038f, 0.016388845f }, { 0.0074493061f, -0.045849358f, -0.082612855f, 0.025851315f }, { 0.061276666f, -0.024654813f, 0.035447334f, -0.025952766f }, { -0.0068267167f, -0.02207426f, 0.003724368f, 0.0070458116f }, { 0.021714649f, -0.017552721f, -0.037105408f, 0.024398534f }, { 0.0092901891f, -0.021559075f, 0.009034776f, -0.016574279f }, { -0.017218595f, -0.041930302f, 0.003369899f, 0.017959363f }, { -0.0022510875f, 0.028106616f, -0.042936548f, -0.041948028f }, { -0.017145551f, -0.032331654f, 0.021486923f, -0.020295391f }, { -0.023196465f, -0.088353584f, 0.010086154f, 0.018689553f }, { -0.024508386f, -0.00058959302f, -0.02867958f, 0.019018994f }, { 0.0088748911f, 0.012528454f, -0.016636351f, 0.0078166115f }, { 0.00066772723f, 0.001693912f, 0.032066885f, 0.016951148f } } }, { { { 0.015200105f, 0.071414961f, -0.020616434f, 0.0063982643f }, { -0.084578144f, -0.12318522f, -0.035470756f, 0.057833574f }, { 0.19487946f, 0.44043059f, 0.10981527f, -0.31907303f }, { -0.17774238f, -0.30460726f, -0.53133003f, 0.31186606f }, { -0.1172677f, 0.3183613f, 0.10375266f, -0.066515168f }, { 0.054176263f, -0.12382077f, -0.033807438f, 0.039809238f }, { -5.3634009e-05f, 0.004084452f, 0.005103199f, -0.060697866f }, { 0.06093199f, 0.060355274f, 0.049176467f, -0.060579228f }, { 0.054611799f, 9.0520863e-05f, -0.048891261f, -0.047609349f }, { -0.036428706f, 0.06336736f, 0.0020843807f, 0.033254378f }, { 0.26975732f, 0.51328693f, 0.29976157f, 0.049031141f }, { -0.28383516f, -0.48219276f, -0.27898799f, -0.033028759f }, { -0.078976834f, 0.14077934f, 0.098587186f, 0.051336328f }, { 0.076281206f, -0.074223398f, -0.053178835f, -0.099578331f }, { -0.056377095f, -0.00066113896f, -0.11597726f, 0.058805777f }, { -0.0027130032f, 0.12007881f, 0.0081935835f, -0.10415807f }, { -0.019349408f, 0.06206561f, -0.0079099126f, 0.079363093f }, { -0.059959607f, -0.0591041f, -0.047505451f, -0.0031496967f }, { -0.11419194f, 0.20904287f, 0.53960104f, 0.10467592f }, { -0.21312862f, -0.34770872f, -0.54593093f, 0.23230512f }, { -0.073229448f, 0.12913f, 0.27728133f, -0.050627706f }, { 0.082312471f, -0.24529296f, -0.12381516f, 0.05577292f }, { 0.03015389f, -0.0015805638f, 0.024306632f, -0.080697961f }, { 0.061367564f, 0.056058289f, 0.041197211f, -0.015551356f } }, { { -0.029269776f, -0.030251548f, 0.01352869f, 0.0084860712f }, { 0.053983187f, 0.047657625f, -0.026379004f, 0.022474039f }, { 0.011898439f, 0.045120742f, -0.024430477f, -0.081318878f }, { -0.0012641508f, -0.018495044f, -0.030127865f, -0.0088483264f }, { 0.040728292f, 0.010691761f, -0.023566342f, 0.028045232f }, { 0.014593998f, 0.0047006468f, -0.049032498f, -0.011446808f }, { 0.00045433705f, -0.0030610749f, -0.010359449f, -0.0026455857f }, { -0.0026794352f, -0.032142744f, 0.010153936f, -0.0034586152f }, { 0.0097198782f, 0.0051005644f, 0.03482872f, -0.0043676475f }, { -0.0012381415f, -0.025746274f, -0.0081178021f, 0.0041481596f }, { -0.01598781f, 0.0048815642f, 0.06313106f, -0.0062291669f }, { 0.072970618f, -0.041153529f, -0.007457013f, 0.059776924f }, { 0.0024768493f, 0.0093018711f, 0.024827984f, 0.043842172f }, { -0.012927661f, -0.023256709f, -0.0035951539f, -0.069710027f }, { 0.0064149713f, 0.0019783425f, 0.010135188f, 0.019449636f }, { -0.0071551675f, 0.015761815f, 0.0086309278f, 0.038854386f }, { 0.020978109f, -0.0056696814f, 0.0025526797f, -0.017352926f }, { -0.010711116f, -0.0097050903f, 0.0022304504f, -0.0039308489f }, { 0.036904234f, 0.025927127f, 0.028330671f, 0.051193417f }, { -0.00076391153f, -0.077528792f, -0.029763477f, 0.0033945843f }, { -0.01775202f, 0.034507636f, 0.065392848f, -0.017840909f }, { -0.019567742f, -0.019880035f, 0.055214211f, -0.02206159f }, { 0.01110111f, 0.0022938832f, -0.011417507f, 0.017692635f }, { 0.050208493f, -0.028178909f, 0.0065276591f, -0.0056267473f } }, { { 0.0065622702f, -0.0012303136f, -0.0081183663f, 0.00079383048f }, { 0.030775912f, 0.052260356f, -0.019758331f, -0.020044147f }, { 0.019016537f, -0.043070451f, 0.035298744f, -0.040592775f }, { 0.010468089f, 0.00057085185f, 0.0081761984f, 0.0033382478f }, { 0.047189462f, -0.052695409f, 0.021849623f, 0.033585939f }, { 0.0012065616f, -0.050287476f, -0.065085924f, -0.039012886f }, { -0.012294892f, 0.006839242f, 0.0051165438f, -2.0711078e-05f }, { -0.03292822f, 0.015299577f, 0.0029119931f, 0.0073040242f }, { -0.0086784873f, 0.0085910164f, -0.0059378411f, -0.010259049f }, { -0.014191355f, -0.011172486f, -0.01299927f, 0.015386671f }, { 0.040453224f, -0.041489173f, 0.015047889f, 0.064340197f }, { -0.020000046f, 0.058477092f, -0.0018150465f, 0.048536972f }, { -0.006105982f, 0.03437044f, 0.0087640339f, 0.032868283f }, { -0.027120362f, 0.016579996f, -0.01708524f, 0.011178424f }, { 0.030535528f, 0.0058718219f, -0.031240404f, 0.024241052f }, { 0.003729958f, -0.055735848f, -0.0055392842f, 0.03447519f }, { -0.04084502f, -0.01227488f, 0.0062970198f, -0.021996031f }, { 0.053671675f, -0.067787009f, 0.0053426012f, -0.0080796738f }, { -0.021911856f, 0.038395527f, -0.07713235f, 0.024805484f }, { -0.0034319194f, 0.0052741327f, 0.026402991f, 0.0012916612f }, { -0.033119652f, -0.0046506889f, 0.045613946f, -0.050230593f }, { -0.0054612035f, -0.033482221f, 0.084267507f, -0.0224334f }, { -0.0063348693f, -0.0074524817f, -0.0029629355f, 0.035493958f }, { -0.0073519185f, 0.045139911f, 0.0022901735f, -0.041385515f } } }, { { { 0.99640669f, 0.99424882f, 0.99911727f, 0.99864438f }, { 0.99146493f, 0.99235134f, 0.99369348f, 0.99764995f }, { 0.95848895f, 0.89778665f, 0.9720248f, 0.943828f }, { 0.95896077f, 0.9472107f, 0.83168251f, 0.89623886f }, { 0.97975356f, 0.94759472f, 0.99452924f, 0.98394744f }, { 0.98863213f, 0.99196902f, 0.99652121f, 0.97785007f }, { 0.99999362f, 0.99994883f, 0.99498061f, 0.99814861f }, { 0.99040248f, 0.99816269f, 0.99831309f, 0.99630173f }, { 0.99848953f, 0.99964658f, 0.9959596f, 0.99884607f }, { 0.9986735f, 0.99651874f, 0.99788899f, 0.99869411f }, { 0.91299789f, 0.85766372f, 0.953946f, 0.97631002f }, { 0.90471405f, 0.87481454f, 0.959534f, 0.97684726f }, { 0.9884254f, 0.96811612f, 0.9914694f, 0.98799879f }, { 0.99232241f, 0.98122887f, 0.99103524f, 0.99426948f }, { 0.99840731f, 0.99966074f, 0.99324506f, 0.98912879f }, { 0.99551377f, 0.99274778f, 0.99617307f, 0.9927827f }, { 0.99830144f, 0.99552039f, 0.99521214f, 0.99684577f }, { 0.99211525f, 0.9978808f, 0.99885333f, 0.99969634f }, { 0.95579147f, 0.95995838f, 0.84120087f, 0.96022443f }, { 0.90975235f, 0.9368621f, 0.81871367f, 0.8156339f }, { 0.98610091f, 0.99158952f, 0.96035822f, 0.97468107f }, { 0.98366238f, 0.9531543f, 0.99215501f, 0.98230604f }, { 0.99953301f, 0.9997136f, 0.99888998f, 0.99490315f }, { 0.99267663f, 0.998401f, 0.99388534f, 0.99721201f } }, { { -0.0021537732f, 0.010607958f, -0.0066166595f, -0.0027390442f }, { -0.0069401807f, 0.0053215201f, 0.0062121114f, 0.013403291f }, { -0.0035740125f, -0.021839368f, 0.00042431197f, -0.029478899f }, { -0.007886159f, -0.0087705321f, -0.010570968f, 0.0040635318f }, { -0.0021772698f, 0.00025306776f, -0.0092725896f, -0.0075657706f }, { -0.010438319f, -0.0072866821f, 0.009272756f, 0.0043932916f }, { -0.00058203184f, 0.0081284104f, 0.027749999f, 0.0035426599f }, { -0.003604276f, -0.012244348f, 0.0072177908f, 0.0026686264f }, { 0.011192179f, 0.0069527119f, 0.017278396f, -0.0053058312f }, { -0.020276487f, -0.0063228657f, 0.013968347f, -0.0021534789f }, { -0.0037534313f, 0.00061399133f, -0.02126817f, 0.0085256452f }, { 0.015620795f, -0.022637876f, 0.00069280338f, 0.0054369037f }, { 0.0095244184f, -0.0026896982f, -0.0057963534f, 0.0067237437f }, { -0.0085689961f, -0.004816024f, -0.00088793436f, -0.0034021999f }, { 0.015428153f, 0.019777562f, -0.011217833f, 0.0095744159f }, { -0.003802304f, 0.0022643577f, 0.0054254827f, 0.025560756f }, { -0.0053298651f, 0.021621993f, -0.01864184f, 0.019120967f }, { 0.015380344f, -0.0027384467f, 0.0010235928f, 0.0062792725f }, { -0.001166873f, -0.0049586656f, -0.014850883f, 0.00057841904f }, { 0.0032865456f, -0.033386196f, 0.0032068954f, 0.02854738f }, { 0.010308266f, -0.000233004f, -0.020287643f, 0.0044441043f }, { -0.0040523345f, 0.0050367711f, 0.01627907f, -0.010032412f }, { 0.0073463987f, 0.00073274858f, 0.002814661f, 0.030221018f }, { 0.0057509063f, -0.011441338f, 0.01894259f, 0.0077856453f } }, { { -0.0053054924f, 0.0037677068f, 0.0066263851f, 0.0011220287f }, { -0.02212139f, 0.013769097f, -0.0013834097f, 0.014152363f }, { -0.0008493126f, 0.021473024f, -0.0039313241f, -0.017764981f }, { -0.00081897848f, -0.0074161164f, 0.0038179092f, -0.0035760615f }, { 0.014045643f, 0.015317904f, 0.0045966739f, 0.0075917156f }, { 0.0035574126f, -0.00017773424f, -0.0010937491f, -0.0017762282f }, { 0.0072018344f, 0.012586227f, 0.0138702f, -0.0085424173f }, { -0.0055783456f, -0.019909385f, 0.01190919f, -0.0065821489f }, { 1.7402026e-05f, 0.0094513341f, 0.015333305f, -0.0072158969f }, { -0.0063049905f, 0.0021776758f, 0.014376378f, 0.0072426401f }, { -0.0078049673f, 0.028764242f, -0.0024169449f, 0.0077604105f }, { 0.00047536469f, 0.029806623f, 0.0017798261f, 0.00087410198f }, { -0.0030498401f, 0.0044874501f, 0.0020382571f, -0.0011101062f }, { -0.0057084397f, -0.0013428994f, -0.001024136f, 0.0066188614f }, { 0.039201052f, 0.015120258f, -0.0082642793f, 0.0051985023f }, { -0.0091203243f, 0.020790215f, 0.0025270937f, 0.020092044f }, { -0.0029830063f, 0.006602841f, -0.00833601f, 0.044852353f }, { 0.025206353f, -0.0038915173f, 0.00045914851f, 0.0037840538f }, { 0.0014814254f, -0.011573911f, 0.046232337f, -0.015228958f }, { -0.0071984443f, 0.0090004063f, 0.022942838f, 0.016019787f }, { 0.0050929336f, 0.0060892107f, -0.0061771339f, 0.0047850766f }, { -0.011634853f, 0.0010276548f, 0.022396644f, -0.0021248711f }, { -0.012943002f, 0.0016430074f, 0.02034928f, 0.024289705f }, { 0.0051047037f, 0.010052556f, 0.0020923265f, -0.019043181f } } }, { { { 2.1627647f, 2.1788232f, 1.9290264f, 1.8457806f }, { 2.526488f, 2.3020441f, 2.538915f, 2.03484f }, { 3.9987521f, 4.3952121f, 3.906821f, 4.1693278f }, { 4.0400466f, 4.1069844f, 5.2512999f, 5.4283264f }, { 3.0141968f, 3.3306035f, 3.2224806f, 3.2473051f }, { 2.9840674f, 3.1294685f, 3.2964833f, 3.2929246f }, { 1.8346741f, 1.8637353f, 2.3037966f, 2.0860888f }, { 2.691236f, 2.6068079f, 1.9349032f, 2.1632935f }, { 1.9231956f, 1.7251627f, 2.1609654f, 2.1155629f }, { 2.165771f, 2.1908952f, 1.777038f, 2.0223741f }, { 4.5166991f, 4.8674508f, 3.918546f, 3.378087f }, { 4.4502295f, 4.5429338f, 3.9552598f, 3.3580272f }, { 3.0973598f, 3.3953852f, 2.2704362f, 2.6488177f }, { 3.2110537f, 3.3104376f, 2.515002f, 2.3267785f }, { 1.8303675f, 1.7094345f, 3.1787979f, 2.5960104f }, { 2.4391795f, 2.8730077f, 2.3730261f, 2.1545299f }, { 2.2130903f, 2.1899209f, 2.4997355f, 1.9058674f }, { 2.6472893f, 2.5455636f, 2.1164596f, 1.8341163f }, { 3.9428283f, 4.0433678f, 4.5430063f, 4.2482776f }, { 4.1941673f, 4.28852f, 4.64044f, 4.6644567f }, { 3.0873642f, 2.649364f, 3.6026133f, 3.2426354f }, { 3.2415154f, 3.5406745f, 3.2976852f, 3.3100246f }, { 1.8400289f, 1.8404692f, 1.889289f, 2.0125184f }, { 2.7063995f, 2.7229173f, 2.6289878f, 2.4313709f } }, { { -0.015335928f, -0.043382119f, -0.0054163805f, -0.028249934f }, { -0.017200109f, 0.0027582413f, -0.079612821f, -0.0013966663f }, { -0.027233584f, -0.018783395f, -0.01183278f, -0.020918937f }, { -0.0036358348f, -0.015712206f, -0.0089146421f, -0.0057117233f }, { 0.020392865f, 0.017743746f, -0.068597326f, -0.030425581f }, { -0.041123673f, -0.020767538f, -0.0087941887f, -0.0065248183f }, { -0.0055478408f, -0.00082196865f, 0.0088521402f, -0.045916836f }, { -0.010506485f, 0.0078523247f, -0.030002306f, -0.0015085765f }, { 0.01894068f, -0.012424968f, -0.034837214f, -0.045009941f }, { -0.045299587f, 0.02630478f, -0.017175711f, -0.043601235f }, { -0.046003661f, -0.020588165f, 0.034398873f, -0.054653787f }, { -0.0042534368f, 0.01325834f, -0.0036369576f, -0.079162988f }, { -0.028728556f, 0.0051289128f, 0.012104313f, 0.010686997f }, { -0.066337767f, 0.00059928728f, -0.080303668f, 0.011318772f }, { -0.031879871f, 0.0011317962f, -0.050259029f, 0.0031596552f }, { -0.090121238f, -0.011196084f, -0.072456123f, -0.00079731072f }, { -0.024243475f, 0.021401076f, -0.018209385f, -0.0083196072f }, { -0.079888701f, 0.0032806631f, -0.12762259f, -0.04652308f }, { 0.031806075f, -0.034165157f, -0.015255921f, -0.049164663f }, { -0.0012051123f, 0.030788487f, 0.022291919f, 0.0025694519f }, { 0.035836509f, 0.0055365388f, 0.026704836f, 0.0001547235f }, { -0.012129747f, -0.0094322145f, -0.040637935f, -0.12125388f }, { -0.027044986f, 0.04531553f, -0.033484589f, -0.0059927923f }, { 0.0067188802f, -0.051166351f, -0.048822794f, -0.025926988f } }, { { 0.022049053f, 0.021265778f, -0.040370641f, -0.036232952f }, { -0.0058098424f, -0.0042264198f, -0.077428509f, -0.04241654f }, { -0.0026825379f, -0.029453318f, -0.016181275f, -0.028320229f }, { -0.012541692f, -0.01345735f, 0.00037814888f, -0.0046052489f }, { -0.026527394f, 0.020033638f, -0.025683861f, -0.084207169f }, { -0.0010459945f, -0.036745215f, -0.039772051f, 0.024810839f }, { 0.012134618f, 0.0068515798f, -0.035286972f, 0.043129595f }, { -0.077093357f, -0.026872688f, 0.032800133f, -0.090326706f }, { 0.13930909f, 0.0081274014f, -0.08349188f, -0.012200005f }, { -0.091693797f, -0.012567011f, -0.069736822f, -0.0061444184f }, { -0.053061301f, 0.003642159f, 0.0052515175f, -0.036957472f }, { 0.0043493933f, -0.013069332f, -0.014708126f, -0.032765039f }, { -0.016116105f, -0.022907609f, -0.043503106f, -0.013266465f }, { -0.072759977f, -0.077354585f, 0.0043827591f, -0.013821612f }, { -0.032399073f, -0.045305037f, -0.021840791f, 0.073996542f }, { -0.057239255f, -0.056581235f, -0.038880927f, 0.044102943f }, { -0.026951489f, -0.088667645f, -0.013659704f, 0.033527579f }, { 0.034815442f, -0.028634059f, -0.036666529f, 0.011546036f }, { 0.026688447f, -0.0081892129f, -0.031138092f, -0.041739155f }, { 0.0015665701f, -0.012701682f, 0.0013533943f, -0.002849785f }, { 0.032994636f, 0.008802974f, 0.019032649f, 0.0039042621f }, { -0.044544917f, 0.0093201326f, -0.017968915f, 0.01936344f }, { -0.034794535f, 0.043032983f, -0.051072531f, -0.040148303f }, { -0.0030398597f, -0.027112065f, -0.064007483f, -0.01798277f } } }, { { { 0.22040906f, 0.24911942f, 0.41660708f, 0.23632869f }, { 0.25894466f, 0.1416669f, 0.41902981f, 0.35717608f }, { 0.26918091f, 0.14566759f, 0.2147652f, 0.15769391f }, { 0.22500921f, 0.12113361f, 0.11151768f, 0.12348609f }, { 0.25699055f, 0.056819107f, 0.3859882f, 0.4585378f }, { 0.7304995f, 0.20719358f, 0.44455636f, 0.42226989f }, { 0.43602897f, 0.51049581f, 0.41978824f, 0.62521039f }, { 0.42004119f, 0.52912054f, 0.33314238f, 0.38257921f }, { 0.55092562f, 0.43085653f, 0.31149977f, 0.34391138f }, { 0.40391149f, 0.48820255f, 0.13569806f, 0.36060266f }, { 0.13647907f, 0.12061002f, 0.20668806f, 0.30221394f }, { 0.15583476f, 0.13133696f, 0.22775202f, 0.35653823f }, { 0.56336195f, 0.25684627f, 0.11118383f, 0.23109245f }, { 0.45430401f, 0.42843367f, 0.25496534f, 0.097473509f }, { 0.3420223f, 0.39418925f, 0.26458947f, 0.30588082f }, { 0.51345558f, 0.3612731f, 0.41151773f, 0.25269512f }, { 0.29195176f, 0.42659964f, 0.47971993f, 0.32714756f }, { 0.49222777f, 0.28477645f, 0.74993827f, 0.43781271f }, { 0.098434481f, 0.31164923f, 0.14486345f, 0.11466693f }, { 0.070833248f, 0.20569754f, 0.10233576f, 0.047352701f }, { 0.51050902f, 0.15597643f, 0.1417112f, 0.35581415f }, { 0.48261165f, 0.14592221f, 0.62554576f, 0.5209765f }, { 0.33562628f, 0.39920067f, 0.28183433f, 0.297464f }, { 0.366851f, 0.59278666f, 0.59095922f, 0.48385165f } }, { { 0.13792051f, 0.072076744f, 0.094800532f, 0.026318377f }, { 0.13607414f, -0.061382542f, 0.061800151f, -0.020060553f }, { 0.028096406f, 0.069282616f, 0.010195109f, -0.010461141f }, { 0.018651237f, 0.02642439f, 0.0077552848f, -0.051151646f }, { 0.098299803f, -0.0085081153f, -0.011764584f, 0.087405711f }, { 0.064082346f, -0.04626424f, -0.071480607f, 0.064447268f }, { 0.022766233f, 0.0167542f, -0.021285286f, -0.071637286f }, { -0.0202445f, 0.011692601f, 0.048325551f, 0.0097755172f }, { -0.027775183f, 0.016463115f, 0.060050391f, -0.034226107f }, { 0.019412547f, 0.059977501f, -0.0041737169f, 0.031539317f }, { 0.013192979f, 0.036015595f, -0.049943198f, 0.014112312f }, { -0.013272349f, 0.035821037f, -0.060503687f, 0.095316821f }, { 0.038338785f, -0.059038809f, -0.044954172f, -0.00051347307f }, { -0.039594082f, 0.018205882f, 0.13413799f, 0.012292954f }, { 0.015177594f, -0.0082493854f, 0.00029420179f, 0.010356248f }, { 0.100271f, -0.13623174f, 0.1121235f, 0.068902399f }, { 0.025189636f, 0.0014918434f, 0.0088847718f, -0.053714493f }, { 0.06487698f, -0.097217547f, -0.069537353f, 0.032490984f }, { -0.030729608f, 0.048956315f, 0.016036034f, 0.022485239f }, { 0.049839618f, 0.01148525f, -0.021032427f, -0.019665817f }, { -0.0037762817f, -0.030422275f, -0.062343207f, 0.057994884f }, { 0.014035184f, -0.021387762f, -0.080846143f, -0.020681511f }, { -0.03594567f, 0.026862531f, 0.078975557f, -0.034056659f }, { -0.014490672f, 0.026128902f, 0.045617611f, 0.090192953f } }, { { 0.011904288f, -0.014624471f, 0.042023114f, 0.019592867f }, { 0.032705848f, 0.00038558691f, 0.031901745f, 0.027208951f }, { -0.044369719f, -0.039761364f, -0.013366816f, -0.019308126f }, { -0.019051023f, -0.00015767269f, -0.082968285f, -0.035266053f }, { -0.004775162f, 0.010889271f, 0.0089521094f, 0.027037104f }, { 0.005616143f, -0.00099668486f, 0.0068716426f, -0.12649184f }, { 0.018531199f, 0.023881776f, -0.053798787f, -0.041912909f }, { -0.0036187094f, 0.11590788f, 0.025140733f, 0.022280209f }, { -0.02994342f, -0.026293799f, -0.017204658f, 0.044901944f }, { 0.079892089f, 0.10816526f, 0.14667807f, 0.027301352f }, { -0.045296738f, -0.066748968f, -0.0099354431f, -0.070369692f }, { -0.08357374f, -0.043311901f, 0.013163375f, -0.0881777f }, { -0.065923811f, -0.10382274f, 0.090440302f, -0.013617198f }, { -0.092578587f, -0.010178017f, -0.01416593f, 0.0432333f }, { 0.055172515f, 0.10021805f, -0.0062782668f, -0.11791805f }, { -0.039684132f, -0.08934283f, 0.020686084f, -0.0013788117f }, { 0.064624676f, 0.051773746f, 0.0045383964f, -0.037696971f }, { -0.066296373f, 0.020570689f, -0.017742721f, -0.022651449f }, { -0.0061572447f, -0.094510525f, -0.094775804f, -0.038022514f }, { 0.0055683313f, 0.039513342f, -0.096815654f, -0.0065483011f }, { -0.03311602f, -0.018395457f, 0.0028464434f, -0.088048272f }, { -0.073106109f, -0.055187863f, -0.093209932f, -0.10155137f }, { 0.042841842f, -0.005778703f, 0.074069607f, -0.025841052f }, { -0.018569637f, 0.063144303f, 0.02291584f, 0.005525742f } } } }, { { { { -0.20809663f, -0.18346453f, -0.072140694f, -0.0078104407f }, { -0.19490097f, 0.25712922f, 0.37640771f, 0.11563399f }, { 0.26894915f, -0.33477877f, -0.093739129f, -0.55078405f }, { -0.65794103f, 0.09211629f, -0.19166986f, 0.5574327f }, { 0.45579532f, 0.23202083f, 0.19626303f, -0.64130523f }, { -0.018763975f, -0.24981569f, -0.32514026f, -0.11121342f }, { 0.22376238f, 0.09515938f, 0.071728264f, -0.02790747f }, { -0.3053338f, 0.34023365f, 0.099862481f, 0.26163964f }, { -0.21722968f, -0.094881958f, -0.086364431f, -0.0081863581f }, { -0.16090709f, 0.23527698f, 0.28947119f, 0.11309742f }, { 0.26447184f, -0.33536416f, -0.096418234f, -0.26201294f }, { -0.56343769f, -0.041662822f, -0.24873841f, 0.67122901f }, { 0.35362642f, 0.2577592f, 0.2009013f, -0.74233681f }, { -0.047956299f, -0.54973418f, -0.4958485f, -0.12453303f }, { 0.06917425f, 0.080509853f, 0.0090863722f, -0.023518805f }, { -0.27000602f, 0.083167162f, 0.12715558f, 0.12397839f }, { -0.11376964f, -0.079199259f, 0.019676685f, -0.0094352472f }, { -0.19185851f, 0.22193112f, 0.28110877f, -0.06422845f }, { 0.084091992f, -0.16151548f, 0.091400556f, -0.28257376f }, { -0.53821376f, 0.21718328f, -0.2234907f, 0.52302804f }, { 0.71322306f, 0.042728493f, 0.13229522f, -0.61892094f }, { 0.15270046f, -0.26304886f, -0.33110633f, -0.052728951f }, { 0.072398971f, 0.25829764f, 0.25881687f, -0.020942042f }, { -0.26788161f, 0.055822039f, 0.33817103f, 0.42061402f } }, { { 0.088248648f, 0.091306255f, 0.020476927f, 0.0030144802f }, { 0.0087376707f, 0.043816157f, 0.0022807168f, 0.016745414f }, { -0.13412414f, 0.12686539f, 0.060531476f, 0.044582027f }, { 0.019204757f, -0.0070891897f, 0.091194602f, 0.065258927f }, { -0.10429513f, -0.027665602f, -0.064350626f, 0.0053147478f }, { 0.069218141f, -0.035018324f, -0.088257571f, 0.019279642f }, { -0.073137338f, 0.040764456f, -0.022352804f, 0.031743288f }, { 0.040325697f, -0.12840825f, -0.009582113f, 0.034509657f }, { 0.081971224f, -0.0035223125f, -0.051728499f, 0.0038899717f }, { 0.050968435f, 0.022254651f, 0.18781134f, -0.032392139f }, { 0.024342518f, 0.13929014f, -0.019175435f, -0.0011608234f }, { -0.0021942487f, -0.01251222f, 0.024263454f, -0.063179344f }, { -0.13071776f, -0.059221747f, -0.034153238f, 0.036561209f }, { 0.054124093f, 0.070495803f, 0.081441614f, 0.051900357f }, { 0.027480327f, 0.028940343f, -0.01469313f, 0.032388411f }, { -0.039696828f, -0.0069393798f, -0.011361641f, 0.035031025f }, { -0.039730763f, 0.0085971581f, -0.0077461932f, -0.040735188f }, { 0.10893368f, 0.00014757217f, 0.025489178f, -0.11388774f }, { -0.0013816669f, 0.0031148929f, 0.10281666f, -0.019860642f }, { -0.065093128f, -0.11495815f, 0.041783056f, -0.091373461f }, { -0.044985581f, 0.0012713031f, -0.16078032f, 0.17303747f }, { -0.038132358f, -0.02995975f, -0.037612782f, 0.012575173f }, { 0.0042976619f, 0.027014275f, 0.017518808f, 0.030405184f }, { -0.0015298607f, 0.029297664f, -0.1034349f, 0.023450502f } }, { { 0.028785558f, -0.028708377f, -0.010459636f, 2.8360915e-05f }, { 0.091634877f, 0.021214811f, 0.12282079f, 0.080617943f }, { -0.29287977f, 0.045481846f, 0.014712563f, 0.057317576f }, { -0.10728772f, 0.03268482f, 0.015167285f, -0.011256231f }, { 0.09337321f, 0.037150859f, 0.052549202f, -0.042671474f }, { -0.0041288689f, -0.024299997f, -0.11357403f, -0.022045772f }, { -0.041469935f, -0.0071353646f, -0.0086607538f, 0.008536762f }, { 0.033629272f, -0.0070042955f, -0.037864853f, -0.0055907778f }, { 0.016404597f, -0.0055321059f, -0.020989839f, -0.013771265f }, { 0.042552435f, 0.04428518f, 0.0030587466f, 0.044894182f }, { -0.027600219f, 0.026831779f, 0.051120849f, -0.032184808f }, { 0.13870554f, 0.15273282f, 0.049260112f, 0.043371121f }, { -0.018453269f, -0.18061413f, 0.24805649f, -0.031741165f }, { -0.085137374f, 0.025935867f, 0.015978067f, 0.067726486f }, { 0.072393868f, 0.0050430488f, 0.0016664585f, 0.0072097064f }, { 0.033840162f, 0.082225764f, -0.079387016f, 0.033165625f }, { 0.033170766f, 0.0012231618f, -0.066984982f, 0.051671704f }, { 0.017894231f, -0.012267532f, 0.045536123f, -0.07327109f }, { 0.0073109731f, -0.063797898f, -0.13446413f, 0.1408986f }, { -0.045702456f, -0.1647051f, -0.14336468f, 0.054543693f }, { 0.0042448876f, -0.13234456f, 0.092181719f, -0.10440841f }, { -0.060020212f, -0.011098469f, -0.030257182f, -0.030922037f }, { -0.018118661f, 0.00067983745f, -0.0061776598f, -0.031721273f }, { -0.019885189f, 0.094157888f, 0.014017961f, -0.051373389f } } }, { { { 0.12415319f, -0.13611564f, -0.029441661f, -0.14143497f }, { -0.26074418f, 0.011913326f, -0.033328425f, 0.43248793f }, { 0.19336432f, 0.37269586f, 0.36803538f, -0.51720719f }, { -0.15185913f, -0.47431781f, -0.6593667f, 0.23163184f }, { 0.18276216f, 0.19248743f, 0.65453332f, 0.54748087f }, { 0.17751443f, -0.0020337696f, 0.08506463f, -0.40147769f }, { -0.11370932f, 0.11523476f, -0.010573025f, 0.082295392f }, { -0.13666335f, -0.32747478f, -0.16897386f, 0.15359006f }, { 0.11716326f, -0.12259922f, 0.0033396256f, -0.13240653f }, { -0.27776876f, -0.10222241f, -0.039920479f, 0.35499708f }, { 0.090003723f, 0.3313923f, 0.1871549f, 0.003163675f }, { -0.51626118f, -0.76341562f, -0.56326874f, 0.20153559f }, { -0.34172723f, 0.26975563f, 0.67520079f, -0.1252004f }, { 0.45758078f, -0.19142179f, 0.064180031f, -0.48748431f }, { -0.12800789f, 0.1399912f, 0.0077954775f, 0.14379741f }, { -0.13042104f, -0.45670817f, -0.18831095f, 0.0032738639f }, { 0.12446807f, -0.11504524f, -0.027331682f, 0.03861758f }, { -0.31337986f, -0.11842668f, 0.033415325f, 0.45344231f }, { 0.11463107f, 0.077427841f, 0.060880794f, -0.069619455f }, { -0.37772106f, -0.59628905f, -0.65426572f, 0.065297039f }, { 0.29532991f, 0.75920243f, 0.53294265f, -0.15002562f }, { 0.3618333f, 0.10488387f, 0.36007528f, -0.30963565f }, { -0.13738196f, 0.20795596f, 0.029274703f, 0.18017599f }, { -0.10290023f, -0.48517535f, -0.33278584f, 0.56477854f } }, { { -0.0047891472f, 0.024629901f, 0.015256654f, -0.0084462001f }, { 0.056227746f, -0.048057782f, -0.15671312f, 0.06418471f }, { -0.070093217f, -0.018057199f, 0.062026545f, -0.051053726f }, { -0.0091221476f, 0.0020547295f, -0.087729813f, -0.10164738f }, { 0.098917091f, -0.066835916f, 0.083151519f, 0.006342544f }, { 0.0013540606f, 0.038719082f, 0.036333261f, -0.053178668f }, { 0.0083787438f, 0.0028359378f, 0.0089872852f, 0.031308249f }, { 0.014379686f, -0.079563474f, -0.079160006f, -0.016352226f }, { 0.0091376645f, -0.016678006f, -0.044636785f, -0.0011035265f }, { 0.0099146109f, 0.027589302f, -0.09494437f, 0.07451767f }, { 0.017453983f, 0.080674871f, 0.06341808f, 0.048820473f }, { 0.02794057f, 0.058230195f, -0.010793601f, 0.091813872f }, { -0.049633232f, -0.1142016f, 0.036984283f, 0.0034294865f }, { 0.047712957f, 0.10161366f, 0.13774722f, 0.039503136f }, { 0.014194782f, -0.014555183f, -0.00053182909f, 0.0019143477f }, { 0.0014900262f, 0.0056176356f, -0.034517871f, -0.0010707988f }, { 0.013287784f, -0.0073967933f, -0.019271341f, 0.016354896f }, { -0.10345626f, 0.023536634f, 0.027943639f, -0.015686972f }, { -0.025193395f, -0.10224801f, 0.078686884f, -0.048574399f }, { 0.15797878f, -0.0012322757f, -0.036096649f, -0.23983963f }, { -0.10455507f, -0.056368102f, -0.06570944f, 0.29104616f }, { 0.05155239f, -0.040940824f, -0.038367594f, 0.058174485f }, { 0.010471732f, -0.066952904f, -0.047763843f, -0.021124742f }, { -0.033555686f, 0.0049111983f, -0.026592789f, 0.014438586f } }, { { -0.0048440946f, 0.025915095f, -0.018325403f, 0.022133613f }, { 0.059240081f, -0.031272176f, -0.12967647f, -0.17957913f }, { 0.0574837f, 0.067005152f, 0.024644254f, 0.10786296f }, { 0.067084865f, 0.008513386f, 0.04077659f, 0.10587924f }, { 0.026332643f, 0.1072618f, -0.098375042f, -0.001724609f }, { -0.021386362f, -0.0020174921f, 0.16800158f, 0.081359882f }, { -0.018204146f, -0.026432136f, -0.0068153455f, -0.029997667f }, { -0.043221501f, -0.016869967f, -0.067406967f, -0.024965804f }, { -0.0033879999f, 0.031310818f, -0.010853802f, 0.00088944004f }, { -0.068991006f, 0.087874253f, -0.15737392f, -0.088870044f }, { 0.061763806f, -0.00072874343f, -0.009915009f, -0.0178225f }, { -0.07340717f, 0.080339271f, -0.0027124572f, -0.13078641f }, { -0.023682834f, 0.16512313f, -0.15784472f, 0.047978827f }, { 0.0063250439f, -0.09953777f, 0.094180888f, 0.010565041f }, { 0.010047311f, -0.042999009f, -0.012483998f, -0.016966759f }, { -0.048612679f, 0.051708319f, 0.015059148f, 0.0036776472f }, { -0.011737015f, -0.0027276603f, 0.026535075f, -0.065453876f }, { 0.056388137f, 0.061461073f, -0.12726984f, -0.025578248f }, { 0.0016833003f, 0.10878558f, 0.13254828f, -0.017098914f }, { -0.031606282f, -0.072245098f, 0.12724789f, -0.21852899f }, { -0.062502612f, -0.073402771f, -0.049624729f, 0.069066032f }, { -0.075837195f, -0.10297347f, -0.07249237f, -0.11538062f }, { -0.015644005f, 0.039474396f, 0.074415075f, -0.038881161f }, { -0.040175911f, 0.034030267f, 0.03947059f, 0.014167463f } } }, { { { 0.97019677f, 0.97355703f, 0.99695983f, 0.98991674f }, { 0.94552952f, 0.96630359f, 0.92585444f, 0.89419404f }, { 0.9435447f, 0.86545998f, 0.92507456f, 0.65508294f }, { 0.73759908f, 0.87552111f, 0.72697883f, 0.79725496f }, { 0.87111918f, 0.95347518f, 0.73011435f, 0.53758004f }, { 0.9839393f, 0.96829127f, 0.94183216f, 0.90909143f }, { 0.96798791f, 0.98876976f, 0.99736817f, 0.99621717f }, { 0.9423876f, 0.88147679f, 0.98054848f, 0.95286662f }, { 0.96906348f, 0.98791034f, 0.99625801f, 0.99116169f }, { 0.94707625f, 0.9665378f, 0.9563539f, 0.9280011f }, { 0.96018435f, 0.88187869f, 0.97758711f, 0.96505917f }, { 0.64499021f, 0.64456248f, 0.78794513f, 0.71332673f }, { 0.87073007f, 0.92778882f, 0.70974824f, 0.65822558f }, { 0.88787388f, 0.81311133f, 0.86603417f, 0.86420517f }, { 0.98935782f, 0.98687417f, 0.99992833f, 0.98932764f }, { 0.95398485f, 0.88572054f, 0.97384313f, 0.99227952f }, { 0.98567955f, 0.99019799f, 0.99943274f, 0.99920952f }, { 0.93004482f, 0.96784384f, 0.95909399f, 0.88896838f }, { 0.98984254f, 0.98382807f, 0.99395144f, 0.95671584f }, { 0.75342733f, 0.77283296f, 0.72248756f, 0.84981055f }, { 0.63568318f, 0.6494505f, 0.83574524f, 0.77099234f }, { 0.91965169f, 0.95906448f, 0.87218942f, 0.94939213f }, { 0.98786871f, 0.94341754f, 0.96548269f, 0.98341143f }, { 0.95794101f, 0.87263324f, 0.8802806f, 0.71000638f } }, { { -0.0064390277f, 0.051629953f, -0.011423447f, 0.032337826f }, { 0.055030538f, 0.061305324f, -0.016012659f, 0.083766345f }, { 0.052467122f, 0.018425134f, -0.00054737782f, 0.048038459f }, { 0.076436505f, 0.016815709f, -0.024174832f, -0.00829119f }, { 0.057903371f, 0.068822104f, -0.0064003131f, 0.00010695928f }, { 0.067104151f, 0.067284611f, 0.0074295447f, 0.024215238f }, { 0.073380541f, 0.01486405f, 0.01523157f, 0.012966612f }, { -0.0002536971f, 0.010628632f, 0.00045031869f, 0.041891438f }, { 0.055922922f, 0.0090823157f, 0.011101162f, 0.033807592f }, { -0.040264953f, 0.022318628f, -0.013682045f, -0.016112502f }, { -0.034286564f, 4.7089727e-05f, -0.013030079f, -0.012231424f }, { 0.027756308f, 0.084041595f, 0.018308393f, 0.11564334f }, { 0.0026690817f, 0.058149333f, -0.013682964f, 0.052975934f }, { -0.03852481f, 0.063493354f, 0.059460027f, 0.047740976f }, { 0.026410264f, -0.0073902435f, 0.022353771f, 0.012987341f }, { 0.035217135f, -0.0023455309f, -0.0055505614f, 0.010102857f }, { 0.00075590283f, 0.038624793f, -0.0040614962f, 0.070039437f }, { -0.02318411f, 0.04527054f, 0.013119286f, 0.025335215f }, { 0.021268391f, 0.044855911f, 0.012622905f, 0.04827088f }, { -0.0046678346f, -0.01934799f, 0.018393432f, 0.09750434f }, { 0.12480373f, 0.059151139f, 0.055196092f, 0.26701338f }, { -0.0096669036f, 0.065624767f, 0.016918517f, 0.028425135f }, { 0.026488514f, -0.0037618693f, 0.0077028717f, 0.041713399f }, { 0.018628451f, 0.033145064f, 0.029067918f, -0.000924258f } }, { { -0.043525781f, 0.028119778f, -0.011653105f, -0.020930158f }, { -0.028099186f, 0.017594088f, -0.099226445f, 0.10408808f }, { 0.11750066f, -0.0010629746f, 0.018381448f, 0.096538552f }, { 0.0010069446f, 0.013799541f, 0.1325137f, 0.020820734f }, { -0.053571928f, -0.0066793785f, 0.14596488f, -0.03272949f }, { 0.028507895f, 0.015474376f, -0.025411653f, 0.037264272f }, { 0.033698911f, 0.018088387f, 0.0038898537f, 0.03163178f }, { 0.0057766828f, 0.015879322f, 0.012557033f, 0.071771631f }, { -0.0044521866f, 0.0083963511f, -0.0020426175f, 0.023784146f }, { -0.011508765f, 0.0075020051f, 0.0018808294f, 0.040843424f }, { 0.0085150894f, 0.0056891711f, 0.010134672f, 0.046224768f }, { 0.040825446f, 0.10099754f, 0.021853299f, 0.024507528f }, { -0.0055958303f, -0.0060958f, 0.1115321f, -0.021701014f }, { 0.010487817f, -0.010033143f, -0.031203025f, 0.054265436f }, { 0.0040500672f, 0.0053935875f, 0.018233022f, 0.018797311f }, { 0.064057639f, 0.014318185f, 0.0199119f, 0.014366235f }, { 0.02411682f, 0.045454692f, 0.0030084434f, 0.019464939f }, { 0.012500289f, 0.027734846f, 0.0025097372f, 0.047343669f }, { 0.037625829f, -0.00064472688f, 0.0557556f, 0.04785655f }, { 0.0020433437f, 0.019929208f, 0.087936103f, -0.036738471f }, { 0.020811556f, 0.0915387f, 0.055445303f, -0.065132763f }, { 0.03911814f, 0.043721622f, 0.0074336204f, -0.031370424f }, { 0.014072509f, -0.014795458f, 0.010517063f, 0.022409628f }, { -0.0054107234f, 0.055313602f, 0.053556404f, 0.048574319f } } }, { { { 3.4224197f, 3.3162336f, 3.1136621f, 3.3189801f }, { 4.0715355f, 3.5614196f, 4.1797877f, 4.0959601f }, { 4.3979407f, 4.1858272f, 4.3116447f, 4.5467451f }, { 4.4920032f, 4.0716439f, 4.6107962f, 4.5268016f }, { 5.6570832f, 4.9036495f, 4.7373547f, 4.7259419f }, { 3.3277827f, 3.6015237f, 4.226646f, 3.7939772f }, { 3.4893058f, 3.3260638f, 3.0626103f, 3.1798705f }, { 3.6423735f, 4.1092281f, 3.3264203f, 3.7325301f }, { 3.4756581f, 3.2550256f, 3.224671f, 3.4093307f }, { 3.8511362f, 3.4821381f, 4.3232597f, 3.7357164f }, { 3.6688024f, 4.0797971f, 3.4140927f, 3.6881261f }, { 4.5298469f, 4.7472506f, 4.4046473f, 4.7279944f }, { 4.1614448f, 4.1242955f, 4.6741969f, 5.0037875f }, { 4.3148703f, 4.3815566f, 4.1976536f, 3.9032858f }, { 3.2640506f, 3.3214728f, 2.9463564f, 3.3562068f }, { 3.6729325f, 3.9218642f, 3.4550701f, 3.4833871f }, { 3.435975f, 3.3079446f, 3.3432341f, 3.3632985f }, { 3.8404619f, 3.4716915f, 3.858149f, 3.8677391f }, { 3.3181827f, 3.8403872f, 4.0363918f, 3.9604287f }, { 5.0916792f, 5.2773748f, 4.5404255f, 4.377031f }, { 4.6514614f, 4.7569957f, 4.1233238f, 4.4022582f }, { 3.6884833f, 3.6283543f, 4.1874612f, 4.2963913f }, { 3.456705f, 3.6250566f, 3.5292789f, 3.1420033f }, { 3.5986317f, 4.0596074f, 4.0696874f, 4.5327067f } }, { { -0.12592901f, -0.14780788f, -0.11051274f, -0.18767653f }, { -0.020435093f, 0.0055221209f, -0.021183195f, -0.15159792f }, { 0.022498629f, -0.025100789f, -0.30939177f, 0.016420202f }, { 0.21296442f, -0.042976575f, 0.082118132f, 0.14574735f }, { -0.13608022f, 0.16141834f, -0.015091164f, 0.044951541f }, { -0.08235774f, -0.10333151f, 0.089785432f, -0.036620639f }, { -0.17664465f, -0.015842477f, -0.083075331f, -0.15660828f }, { -0.11292423f, -0.072894494f, -0.068901923f, -0.2283674f }, { -0.19063437f, -0.071954393f, 0.091375283f, -0.26993547f }, { 0.042798331f, -0.06495575f, 0.050221766f, 0.024602586f }, { -0.026228614f, 0.0049810367f, 0.046584088f, -0.13067577f }, { 0.072779737f, -0.023369437f, -0.030275791f, 0.19591126f }, { -0.018649072f, 0.029208952f, 0.012033439f, 0.00094798196f }, { -0.094599446f, 0.0070746366f, -0.0007115864f, -0.040175552f }, { -0.027599009f, -0.068747365f, 0.19480498f, -0.19423733f }, { -0.076671551f, 0.0075475135f, 0.019853903f, -0.012984601f }, { 0.064371855f, -0.24044027f, -0.043765356f, 0.0016424127f }, { -0.076744435f, 0.035881398f, 0.12967612f, 0.081825243f }, { -0.15224256f, 0.032665115f, -0.027927205f, 0.076091133f }, { -0.0057973613f, -0.14914213f, -0.047678749f, -0.037214457f }, { 0.10060085f, -0.099197666f, -0.22704457f, -0.0020812401f }, { -0.070664558f, -0.13179176f, -0.014217065f, -0.030410253f }, { -0.12286487f, -0.046623366f, -0.10695394f, -0.0081383175f }, { -0.14561788f, 0.02765909f, 0.10439783f, 0.033139041f } }, { { 0.0063171031f, -0.0047223477f, -0.056312039f, -0.065065766f }, { -0.0059575982f, -0.062348475f, 0.069540315f, -0.090331962f }, { 0.10218203f, 0.050383376f, -0.0089914697f, -0.037837343f }, { -0.0037657879f, 0.18278082f, 0.079014627f, -0.052587294f }, { -0.33929282f, 0.018522098f, 0.0078923893f, 0.042545349f }, { 0.027294929f, -0.086490439f, -0.0057363347f, -0.035932082f }, { -0.061716003f, -0.14470599f, 0.033117786f, -0.08112808f }, { 0.16414856f, 0.082471596f, -0.058497326f, 0.050552718f }, { -0.07627083f, -0.0064181717f, -0.031179581f, -0.075705068f }, { -0.057808009f, -0.00074561624f, -0.23990956f, 0.018671772f }, { 0.1677602f, 0.10757253f, 0.028015134f, -0.23923178f }, { 0.078827365f, 0.068682485f, 0.056277532f, -0.069749241f }, { 0.079502977f, 0.05526585f, 0.0089767144f, -0.15319341f }, { -0.038594242f, -0.055488998f, -0.043132461f, 0.054313031f }, { 0.12890592f, -0.082639555f, 0.22520491f, -0.026781096f }, { -0.071292391f, 0.064592881f, -0.050368563f, -0.072488866f }, { 0.092998671f, 0.12152394f, 0.033318795f, -0.039691417f }, { -0.0049706273f, -0.0014175115f, -0.11634604f, 0.15219284f }, { -0.012414906f, 0.035583927f, -0.072463074f, -0.058394705f }, { -0.071558898f, -0.00093653835f, 0.013149622f, 0.01495775f }, { -0.057103279f, 0.013702583f, -0.020242751f, 0.04649072f }, { -0.083398977f, -0.20123674f, 0.062758815f, -0.043671819f }, { 0.084479675f, 0.17868517f, -0.021185269f, 0.15711776f }, { 0.11862504f, 0.079985297f, 0.063556911f, 0.14639069f } } }, { { { 0.48018566f, 0.17712962f, 0.45065949f, 0.76214707f }, { 0.37788335f, 0.385421f, 0.24766167f, 0.3647243f }, { 0.45095873f, 0.2634498f, 0.37824131f, 0.10713483f }, { 0.18808611f, 0.27852978f, 0.23671202f, 0.23174978f }, { 0.39404781f, -0.7399413f, 0.28511918f, 0.026007027f }, { 0.46587668f, 0.46802177f, 0.36697974f, 0.23706778f }, { 0.48925391f, 0.42086488f, 0.49570155f, 0.45137287f }, { 0.30655255f, 0.35196398f, 0.23019387f, 0.50586011f }, { 0.45798975f, 0.34137244f, 0.33289763f, 0.54218519f }, { 0.42271216f, 0.38700914f, 0.48791862f, 0.15025833f }, { 0.7282781f, 0.37956244f, 0.25156645f, 0.51632504f }, { 0.084933462f, 0.15576738f, 0.16469359f, 0.29684651f }, { 0.34570877f, 0.34912791f, 0.26663435f, 0.11188061f }, { 0.48552914f, 0.19012867f, 0.12677402f, 0.1234341f }, { 0.2190939f, 0.41431469f, 0.64823269f, 0.51846746f }, { 0.49289149f, 0.29829354f, 0.29090992f, 0.36465152f }, { 0.50568056f, 0.64150077f, 0.40217634f, 0.53523743f }, { 0.24945735f, 0.47058801f, 0.29099852f, 0.25452114f }, { 0.49039753f, 0.26327736f, 0.39431507f, 0.50632023f }, { 0.19678915f, 0.031547614f, 0.22295107f, 0.26300048f }, { 0.12409997f, 0.11506147f, 0.19327618f, 0.2174585f }, { 0.15319333f, 0.39177705f, 0.38498586f, 0.25972804f }, { 0.69027161f, 0.37279682f, 0.31143504f, 0.23440833f }, { 0.39682066f, 0.3156927f, 0.36369313f, 0.14308402f } }, { { 0.15030994f, 0.15410005f, 0.0072554408f, -0.22242826f }, { -0.032421729f, 0.22531436f, 0.22185899f, -0.022703209f }, { 0.070341052f, 0.30237173f, 0.047916387f, 0.03629681f }, { -0.024283222f, 0.075614195f, 0.013940033f, -0.016841468f }, { 0.077729482f, 0.19455394f, -0.02162282f, -0.018761003f }, { -0.22986895f, 0.18914992f, 0.14483608f, 0.11173921f }, { 0.14132894f, -0.0081864768f, -0.11405791f, 0.031777789f }, { 0.38775389f, 0.0085565642f, -0.057167843f, 0.09784167f }, { 0.079102739f, 0.030530894f, 0.041954967f, 0.02957611f }, { 0.076915126f, 0.18656729f, 0.044218872f, 0.22478833f }, { 0.017173879f, 0.11961351f, -0.085099523f, 0.22720323f }, { 0.030466202f, 0.095221887f, -0.042982583f, -0.069264747f }, { 0.041170442f, -0.090598444f, -0.021082598f, -0.028016784f }, { -0.082581617f, -0.023712106f, 0.32427665f, 0.1010696f }, { 0.19197752f, 0.10900527f, -0.0053794951f, 0.068553764f }, { 0.18674269f, 0.028895321f, -0.053421028f, 0.063918058f }, { 0.044090722f, -0.054247791f, 0.05585954f, -0.13406746f }, { 0.08358642f, -0.032301886f, 0.010371619f, 0.099505528f }, { 0.16467816f, 0.044994571f, -0.0045949279f, 0.0626774f }, { 0.12942209f, 0.092097891f, 0.019866495f, 0.10340014f }, { 0.037094903f, 0.13829877f, 0.15116473f, -0.048632499f }, { 0.10749044f, 0.14329542f, -0.061272024f, -0.1536028f }, { 0.097716907f, 0.044246181f, 0.056664419f, 0.15804873f }, { 0.031819999f, 0.10132976f, 0.079198524f, 0.017871462f } }, { { 0.056219172f, 0.08683492f, -0.061488015f, 0.065746152f }, { 0.088983664f, 0.19773741f, -0.096766599f, 0.16352101f }, { -0.0097043787f, -0.040925999f, 0.097458334f, 0.032319634f }, { -0.024873518f, 0.057873123f, -0.0059256291f, -0.057498398f }, { -0.13355098f, 0.39190863f, 0.017449142f, -0.0076009344f }, { 0.10319658f, 0.22069551f, -0.098795717f, 0.10603434f }, { 0.090765308f, 0.13803326f, -0.070647945f, 0.14557561f }, { -0.068457348f, 0.058955208f, -0.050501105f, 0.02914144f }, { 0.10363866f, 0.060231993f, 0.027681685f, 0.079659088f }, { 0.01269983f, 0.11977996f, -0.049648315f, 0.089882363f }, { -0.072877286f, 0.019348792f, 0.13977764f, 0.055396044f }, { 0.028834456f, -0.1084196f, -0.0043985215f, -0.072640844f }, { -0.040232522f, 0.051835989f, -0.02198193f, 0.016421295f }, { -0.087848469f, -0.04621504f, 0.099259188f, -0.0025909067f }, { 0.3000131f, 0.10526775f, 0.016890366f, 0.12892588f }, { -0.021028821f, -0.024429075f, 0.088067677f, -0.084594075f }, { 0.086861805f, -0.045902006f, 0.0058222123f, -0.0075466204f }, { 0.14411905f, 0.036488937f, 0.05091815f, 0.16385101f }, { 0.1576814f, 0.043890956f, -0.064244298f, -0.087234754f }, { -0.071100004f, 0.16782304f, -0.10860149f, -0.1601076f }, { 0.032634641f, -0.0025068263f, -0.093802703f, -0.076176546f }, { 0.1121451f, 0.15584236f, 0.070074778f, 0.083736091f }, { 0.16981897f, -0.078106227f, 0.12480295f, -0.0056807652f }, { -0.20300117f, -0.017467249f, 0.035504155f, 0.056546123f } } } }, { { { { 0.014994926f, 0.3118252f, 0.12179235f, -0.2013765f }, { -0.2622824f, 0.28086607f, 0.018805882f, 0.72058929f }, { -0.0081002049f, -0.28176506f, -0.592214f, -0.15032918f }, { 0.18913426f, -0.24000825f, 0.0020279072f, -0.54749128f }, { 0.010237954f, 0.76905205f, 0.80173664f, -0.016024595f }, { -0.53448318f, 0.31204229f, -0.16183732f, 0.76857439f }, { -0.57639279f, -0.63719194f, -0.71354849f, 0.56346054f }, { 0.49443258f, 0.15067585f, 0.31864726f, -0.30570933f }, { -0.20756322f, 0.2544828f, -0.005298245f, 0.0073796841f }, { -0.61822672f, 0.21508574f, 0.6362534f, 0.30433278f }, { -0.0050327191f, -0.278054f, -0.3460806f, 0.29967778f }, { 0.33983098f, -0.11715664f, -0.21761592f, -0.068273894f }, { 0.5550354f, 0.44369709f, 0.64019993f, -0.026032291f }, { -0.72587268f, -0.33528197f, -0.33592445f, 0.53027141f }, { -0.47623191f, -0.61767624f, -0.61525655f, 0.37823554f }, { 0.82869964f, 0.219401f, -0.018181789f, -0.56937955f }, { -0.051792934f, 0.3461701f, 0.20915925f, 0.078166496f }, { -0.26705611f, 0.14439061f, 0.0055054648f, 0.463243f }, { -0.0019649711f, -0.34119962f, -0.29306531f, -0.040223173f }, { 0.29285811f, -0.32824753f, -0.24768208f, -0.29676955f }, { 0.87604898f, 0.25374435f, 0.2341931f, -0.77851996f }, { -0.80404697f, 0.011122158f, 0.18899178f, 0.55592668f }, { -0.78397618f, -0.53690406f, -0.59931185f, 0.62348293f }, { 0.54613799f, 0.080819658f, 0.12590931f, -0.60614071f } }, { { -0.12307869f, -0.20242175f, 0.21530167f, -0.15608553f }, { 0.00052208688f, 0.09998365f, -0.067550225f, -0.14009319f }, { 0.12621699f, -0.089024022f, 0.022656689f, 0.18947331f }, { 0.34838897f, -0.04936051f, 0.25527451f, -0.18942819f }, { 0.013210249f, -0.043957685f, -0.19088103f, -0.034189573f }, { -0.0027790938f, -0.026595097f, 0.087083287f, -0.12513839f }, { -0.038231564f, 0.013328425f, -0.0091503894f, -0.005743873f }, { 0.17205702f, -0.14956835f, -0.0088915291f, 0.18720588f }, { -0.049670195f, 0.39532325f, 0.080260299f, 0.01811245f }, { 0.043555003f, -0.30289197f, -0.50878196f, 0.27306166f }, { 0.02555972f, -0.0068359476f, 0.061097702f, -0.43822038f }, { -0.10926471f, 0.1870906f, 0.12419548f, 0.1245213f }, { -0.012443149f, 0.040036941f, 0.18601483f, 0.02310445f }, { -0.10442982f, 0.057455632f, 0.13475314f, -0.0019859122f }, { -0.068181593f, -0.0033655904f, 0.01922998f, -0.020393828f }, { -0.10660626f, 0.0020812455f, 0.081209707f, 0.077131932f }, { 0.088733212f, -0.10430986f, 0.45554817f, -0.17113078f }, { 0.0046831409f, 0.13247549f, -0.1077727f, 0.15382275f }, { 0.022346595f, 0.022924261f, -0.35016323f, 0.2437608f }, { 0.029795657f, 0.23046877f, -0.020493651f, -0.33214749f }, { -0.016101582f, 0.042296203f, 0.046779444f, 0.037412394f }, { -0.02214903f, -0.025218605f, 0.14797485f, -0.051723623f }, { 0.021321783f, 0.010405115f, 0.0075476201f, 0.0082410917f }, { 0.040559796f, 0.027927916f, -0.012812736f, -0.0096642379f } }, { { -0.055647079f, 0.017595207f, 0.34495838f, -0.03055759f }, { -0.058415094f, 0.027416036f, 0.18568916f, 0.13044498f }, { 0.01482217f, -0.17300703f, 0.027540135f, -0.2744944f }, { 0.25558424f, -0.15324455f, -0.29751197f, -0.11422984f }, { -0.068936732f, -0.11425403f, 0.094767025f, -0.0020892558f }, { 0.040887892f, 0.031622148f, -0.095292456f, -0.02460001f }, { -0.0026237665f, 0.017734103f, 0.01213911f, 0.0056586962f }, { -0.052138375f, 0.052245567f, 0.04608449f, -0.043004468f }, { -0.17693366f, 0.0021023738f, 0.13167397f, -0.14062006f }, { -0.20900333f, 0.0057695127f, 0.13057243f, 0.046715668f }, { -0.020569928f, -0.08439655f, -0.09683347f, 0.038139385f }, { 0.18196242f, 0.44461908f, -0.11388512f, -0.12413082f }, { 0.072801844f, -0.0017236427f, -0.0026756083f, 0.049805114f }, { -0.092195952f, -0.0076195172f, -0.22763849f, -0.11320887f }, { 0.016234922f, 0.007258942f, 0.078535592f, -0.084829275f }, { -0.15320003f, 0.057490618f, -0.16065455f, -0.17063675f }, { -0.012856124f, 0.024818957f, 0.097529739f, 0.11569844f }, { -0.11141243f, 0.26677735f, 0.1319403f, -0.15699502f }, { -0.021128161f, -0.12370585f, 0.056198856f, -0.1836225f }, { -0.01871806f, 0.025525037f, 0.063822152f, 0.066517944f }, { -0.013759301f, 0.11401068f, -0.04701374f, -0.021321516f }, { 0.032714649f, -3.161284e-06f, 0.026930697f, 0.00019593482f }, { 0.10575127f, 0.016956425f, 0.016873291f, 0.0049304377f }, { -0.11938883f, 0.31242334f, 0.29347156f, -0.19514533f } } }, { { { -0.17374661f, -0.028781395f, -0.25993234f, 0.27242277f }, { -0.13675759f, -0.62291002f, -0.80742781f, 0.54260546f }, { 0.16876581f, -0.052588487f, 0.22415557f, -0.59669887f }, { 0.1769234f, 0.64210979f, 0.81157479f, -0.2718564f }, { -0.99873125f, -0.013258174f, 0.58939675f, 0.99930085f }, { -0.30883355f, -0.71116337f, -0.76218623f, 0.096388818f }, { 0.65749012f, -0.54533843f, -0.57508599f, -0.70359398f }, { -0.27406769f, 0.61006308f, 0.1873512f, 0.2563151f }, { -0.78453523f, -0.13585943f, -0.048534939f, 0.02085237f }, { 0.40938527f, -0.76981396f, -0.42506866f, 0.22362984f }, { 0.29003079f, -0.20624421f, 0.1151133f, -0.50558933f }, { 0.0070051806f, 0.20763719f, 0.59485798f, -0.61562639f }, { -0.4371111f, 0.48314196f, 0.72981069f, 0.99889301f }, { 0.58257878f, -0.8603979f, -0.94188892f, -0.83140889f }, { 0.71858167f, -0.49534538f, -0.63421799f, -0.84488463f }, { 0.016158248f, 0.65330502f, 0.82883727f, -0.127372f }, { -0.50292264f, -0.14848746f, -0.20836533f, 0.2471481f }, { -0.15815031f, -0.63472031f, -0.79826416f, 0.15325573f }, { -0.010424343f, -0.022843894f, 0.099730136f, -0.26040744f }, { 0.15069433f, 0.31188588f, 0.63836617f, -0.25234477f }, { -0.36946506f, 0.92093529f, 0.96548808f, 0.62354203f }, { -0.57070465f, -0.99847512f, -0.47855156f, -0.079970605f }, { 0.077467525f, -0.71134336f, -0.67172579f, -0.66364974f }, { -0.27299386f, 0.89512951f, 0.61598356f, 0.49577277f } }, { { 0.070458859f, -0.28774455f, 0.21287043f, -0.094689772f }, { 0.0029548085f, -0.31404605f, -0.039280892f, -0.3652277f }, { -0.033729607f, 0.041215792f, 0.065844258f, -0.21509418f }, { 0.39270582f, 0.067526811f, 0.15655351f, 0.053346856f }, { 0.052704394f, -0.087801294f, 0.18655104f, 0.056114808f }, { -0.074582751f, -0.055177669f, -0.22165519f, 0.13272162f }, { -0.027850171f, 0.0029849066f, -0.0062314784f, -0.010484316f }, { 0.20753796f, -0.0087111988f, -0.13875075f, -0.06137521f }, { 0.089744421f, 0.07271039f, 0.099417029f, -0.22157272f }, { -0.013209094f, 0.048633419f, -0.26528065f, -0.15253703f }, { 0.052922007f, 0.24859103f, 0.14406684f, 0.13857649f }, { 0.00096142813f, 0.32643367f, 0.17939549f, -0.39761314f }, { 0.013505803f, -0.036986517f, -0.12729111f, 0.15459921f }, { -0.00049722057f, -0.047063275f, -0.0018666598f, 0.1067114f }, { -0.074221027f, -0.00927958f, -0.029535811f, -0.024240068f }, { -0.12387933f, 0.06626829f, 0.16422781f, 0.077740779f }, { 0.14560404f, -0.082132455f, 0.027268021f, 0.18857832f }, { 0.10470732f, -0.29519533f, -0.23666419f, 0.10917064f }, { 0.042550279f, 0.02436036f, -0.31865644f, -0.024987356f }, { -0.030434576f, 0.082115299f, 0.17770796f, 0.020944092f }, { -0.17365377f, 0.13807361f, 0.12476029f, 0.072738061f }, { -0.11503962f, -0.04022554f, 0.028018434f, -0.070211356f }, { -0.043677907f, 0.0053361863f, 0.0039019898f, 0.0027489647f }, { 0.27060899f, -0.0016552279f, 0.14166067f, -0.25461265f } }, { { 0.014703402f, 0.094752279f, -0.32162049f, 0.082335322f }, { -0.31539882f, 0.44394592f, 0.44316202f, -0.031456167f }, { -0.024148679f, 0.082370612f, -0.0031744796f, 0.098610537f }, { 0.46130367f, -0.19989896f, -0.56118891f, 0.11979937f }, { 0.11784636f, 0.079971516f, -0.16977121f, 0.014922099f }, { 0.018367216f, -0.076519762f, 0.13801492f, 0.039682415f }, { -0.0027614728f, 0.0010389006f, -0.023126227f, 0.0027068473f }, { 0.22249856f, -0.071302328f, 0.23721977f, 0.10734273f }, { 0.41478408f, -0.36611101f, 0.18031261f, -0.11176768f }, { 0.15800457f, 0.23829725f, -0.0016193556f, 0.2112867f }, { -0.14793833f, -0.15378785f, 0.0082778301f, 0.27105519f }, { -0.064743588f, 0.44794816f, -0.12599819f, 0.4310022f }, { 0.092725214f, 0.033947737f, 0.19969884f, 0.0072363359f }, { -0.074190657f, 0.005985921f, 0.300818f, -0.090919095f }, { 0.024238118f, -0.010955859f, -0.068086841f, -0.021137349f }, { 0.12196721f, -0.19977338f, -0.64428422f, -0.30808722f }, { 0.46567096f, -0.042072501f, -0.1778338f, 0.34294059f }, { -0.32528695f, 0.25699981f, 0.49346557f, -0.20743316f }, { 0.10422458f, 0.049488574f, 0.49098274f, -0.34871439f }, { 0.16431875f, -0.050748897f, -0.18464312f, -0.61695364f }, { -0.1753479f, 0.033238479f, -0.046267845f, -0.012339883f }, { -0.16098841f, 0.080519992f, -0.11793031f, 0.036790025f }, { 0.017193144f, -0.0029212372f, -0.0044153187f, -0.0057094316f }, { 0.23481771f, -0.1556448f, -0.18775429f, -0.013697353f } } }, { { { 0.98467622f, 0.94970347f, 0.95791534f, 0.9408684f }, { 0.95525144f, 0.73013516f, 0.58966657f, 0.43166004f }, { 0.98562289f, 0.95804118f, 0.77397471f, 0.78825859f }, { 0.96588112f, 0.72807352f, 0.58424502f, 0.79142113f }, { -0.049305848f, 0.63904864f, 0.099145551f, -0.03377918f }, { 0.78673348f, 0.62998117f, 0.62680207f, 0.63245759f }, { 0.48526085f, 0.544603f, 0.40015579f, 0.43297544f }, { 0.82487776f, 0.77789448f, 0.92917353f, 0.91697567f }, { 0.58431326f, 0.95748667f, 0.99880743f, 0.99975533f }, { 0.67096902f, 0.60093643f, 0.64381538f, 0.92594344f }, { 0.95700408f, 0.93816272f, 0.93111608f, 0.80905665f }, { 0.94046044f, 0.97116483f, 0.77381347f, 0.78507504f }, { 0.7077214f, 0.7547892f, 0.23983411f, -0.039180128f }, { 0.3656649f, 0.38379871f, -0.00015338393f, 0.16604667f }, { 0.50679735f, 0.6108265f, 0.46821675f, 0.37829596f }, { 0.55946029f, 0.72460731f, 0.55919425f, 0.81214734f }, { 0.86277825f, 0.92634645f, 0.95542467f, 0.96581976f }, { 0.95061533f, 0.75913205f, 0.60228234f, 0.87287949f }, { 0.99994373f, 0.93971324f, 0.95087677f, 0.96466059f }, { 0.9442062f, 0.89161694f, 0.72879505f, 0.92100486f }, { 0.30989313f, 0.29579046f, 0.11395771f, 0.071428407f }, { 0.16674735f, -0.054071458f, 0.85747916f, 0.82737551f }, { 0.61593841f, 0.45356879f, 0.43544204f, 0.41332561f }, { 0.79196443f, 0.43841915f, 0.77763172f, 0.62193473f } }, { { 0.028699614f, 0.071974788f, -0.028868668f, 0.030119772f }, { -0.16988515f, -0.35713152f, 0.36877151f, 0.37172103f }, { 0.024472009f, 0.10373643f, 0.052160621f, -0.12998364f }, { 0.051999909f, -0.1688679f, 0.05813266f, -0.11063347f }, { 0.026373007f, 0.067310776f, 0.34433164f, 0.0017481699f }, { -0.017659611f, -0.10215276f, -0.23736187f, 0.12678732f }, { -0.0019097928f, 0.02067204f, -0.030447136f, -0.0093192388f }, { 0.10615435f, 0.11124023f, 0.04473958f, 0.14369936f }, { 0.14791062f, -0.034502091f, 0.041456555f, 0.06737059f }, { 0.22389399f, 0.2668048f, 0.25742349f, 0.03724758f }, { 0.0046009946f, 0.066632032f, 0.097957775f, 0.22969631f }, { 0.043253167f, -0.013638494f, 0.071328387f, -0.19249903f }, { -0.023561087f, 0.011490741f, 0.19824644f, -0.04133258f }, { -0.057507532f, -0.039265903f, 0.060469313f, 0.37300659f }, { 0.027051207f, -0.0086784396f, -0.0055877341f, -0.0315352f }, { 0.15724931f, 0.0099485187f, 0.22462997f, 0.14112999f }, { 0.13909905f, 0.026199511f, -0.12430815f, -0.076900423f }, { -0.022327596f, -0.1975812f, 0.49862652f, -0.096026553f }, { 0.076782007f, 0.041598482f, 0.0033451155f, 0.039947963f }, { 0.005353589f, 0.070993946f, 0.0068174778f, -0.17805261f }, { -0.059912765f, -0.17027417f, -0.060069718f, 0.1561139f }, { 0.017122435f, 0.048532637f, -0.05315926f, 0.066962855f }, { 0.058014377f, 0.021874362f, 0.017248667f, -0.0069413843f }, { 0.099274028f, 0.040622241f, 0.040435904f, 0.14191123f } }, { { -0.13453832f, 0.071519908f, -0.1597656f, -0.030758273f }, { -0.13511715f, 0.32373425f, 0.35851035f, -0.18685481f }, { 0.021440457f, 0.034442875f, 0.14324368f, 0.15754565f }, { -0.061440371f, 0.16837735f, 0.47887644f, -0.036265812f }, { 0.55060811f, 0.14095672f, 0.13077418f, 0.25515565f }, { -0.084599968f, -0.084002143f, 0.1542308f, 0.044223437f }, { 0.0017727822f, 0.025149715f, -0.025479364f, -0.0023658361f }, { 0.1619123f, 0.069159159f, -0.016343512f, 0.026108175f }, { 0.3296525f, 0.029456656f, 0.039715069f, 0.015958704f }, { -0.093419591f, 0.37051381f, -0.063182977f, -0.017764112f }, { 0.11962535f, 0.062511772f, -0.070445145f, 0.27768911f }, { 0.07458833f, -0.16218828f, 0.064111239f, 0.43889373f }, { -0.0326486f, -0.03666828f, -0.17597139f, 0.34213144f }, { 0.061334301f, -0.0099525239f, 0.21497301f, 0.0074569296f }, { -0.016749445f, 0.00054557189f, 0.040331287f, 0.066200794f }, { 0.20620866f, 0.25268529f, 0.46594276f, 0.059651923f }, { 0.15170896f, 0.041438057f, 0.021708506f, -0.15049245f }, { -0.14317538f, 0.13548996f, 0.37297491f, 0.13718874f }, { 0.053339004f, 0.015014013f, -0.10418356f, -0.13598877f }, { -0.02227412f, 0.045548464f, 0.21534467f, -0.23828118f }, { -0.055326885f, 0.11851609f, 0.28938409f, 0.041373996f }, { -0.1219532f, 0.57338554f, -0.094571555f, 0.025008596f }, { 0.070380772f, 0.016993506f, 0.018073937f, -0.015404818f }, { 0.17033841f, 0.12449473f, 0.10847869f, -0.11141982f } } }, { { { 4.409738f, 4.5071479f, 5.4761817f, 5.3214091f }, { 5.3741435f, 4.6270256f, 5.4786338f, 5.323679f }, { 4.305776f, 4.4890731f, 4.6894257f, 4.6068436f }, { 5.4930574f, 4.9116386f, 5.4097636f, 4.9225404f }, { 5.1861828f, 5.5144226f, 5.1307797f, 5.0804212f }, { 6.1194597f, 6.0655136f, 5.7369562f, 6.1076578f }, { 6.9549598f, 6.9281578f, 6.9549598f, 6.9549598f }, { 4.5030565f, 4.5849566f, 4.4830953f, 4.4904323f }, { 5.3629211f, 5.5524848f, 4.5719135f, 4.9103175f }, { 4.8906163f, 5.3972226f, 4.8806206f, 5.1834202f }, { 4.5047396f, 4.5984947f, 4.7039612f, 4.3422371f }, { 4.5956963f, 5.6294962f, 4.46025f, 4.4827131f }, { 5.8454206f, 6.000743f, 5.4594428f, 4.9952614f }, { 6.09642f, 6.3979283f, 4.9784963f, 5.6878449f }, { 6.9549598f, 6.9752898f, 6.9549598f, 6.9549598f }, { 6.2053562f, 4.9984547f, 5.3887395f, 4.6221036f }, { 4.5265196f, 4.3684629f, 5.5819288f, 5.4957366f }, { 5.2220057f, 4.6118907f, 5.5046208f, 4.9190037f }, { 4.3408178f, 4.4980303f, 5.4937404f, 5.6154153f }, { 4.4802186f, 4.4666194f, 4.8546878f, 5.1764252f }, { 5.7384024f, 5.9048089f, 5.4636107f, 5.0807017f }, { 5.1013817f, 5.2237041f, 6.0338955f, 5.8869417f }, { 6.9414339f, 6.9549598f, 6.9549598f, 6.9549598f }, { 4.3368412f, 4.9692663f, 4.7090567f, 4.9023075f } }, { { 0.0093525884f, -0.33796029f, -0.4366682f, -0.18161326f }, { -0.34446047f, 0.10854359f, -0.61563912f, -0.16514117f }, { 0.055849315f, 0.093045585f, 0.36722184f, 0.085665647f }, { -0.21881508f, -0.036846235f, -0.25226403f, -0.012790033f }, { -0.14697546f, -0.026656628f, 0.2559775f, 0.026279081f }, { 0.073189287f, -0.074472165f, -0.15439557f, 0.020907645f }, { 0.0f, -0.015078298f, 0.0f, 0.0f }, { 0.027540893f, -0.30876053f, -0.15680794f, -0.18470107f }, { -0.072547269f, -0.019227086f, -0.26735769f, -0.1362069f }, { 0.36907279f, -0.28005156f, 0.01966203f, -0.10277819f }, { -0.26755862f, 0.066747173f, 0.60834173f, -0.23356165f }, { -0.12357338f, -0.41742338f, 0.081840746f, -0.14596222f }, { -0.068599762f, -0.004402392f, -0.17192993f, -0.15797464f }, { -0.072923207f, -0.02555551f, -0.21075071f, 0.047272919f }, { 0.0f, 0.0115085f, 0.0f, 0.0f }, { 0.32527558f, 0.066048741f, -0.28639187f, 0.45171914f }, { -0.158086f, -0.049098981f, -0.17226122f, -0.50289857f }, { -0.39456648f, 0.031970902f, -0.74883626f, 0.20536003f }, { 0.22864705f, -0.0095988927f, -0.1155595f, -0.06240073f }, { 0.12336497f, -0.34128076f, 0.34341316f, 0.083678547f }, { -0.032718317f, 0.076359349f, -0.30099369f, -0.016865529f }, { -0.23491753f, -0.17228011f, -0.044893186f, -0.057411459f }, { -0.0077848677f, 0.0f, 0.0f, 0.0f }, { -0.18713605f, -0.11612415f, 0.30907006f, 0.064707406f } }, { { -0.20768494f, -0.15642062f, -0.079474216f, -0.020948121f }, { -0.18767308f, -0.013722599f, 0.15827086f, -0.27421942f }, { -0.11484158f, -0.29325715f, 0.24426149f, 0.34598577f }, { -0.095599056f, 0.16784413f, 0.23369965f, 0.15036114f }, { 0.058496274f, -0.064565923f, -0.076598803f, -0.11988702f }, { -0.03406356f, -0.010863931f, -0.036116475f, 0.0077051595f }, { 0.0f, -0.015078298f, 0.0f, 0.0f }, { -0.21271534f, 0.31678528f, 0.084310434f, -0.039787477f }, { 0.057420352f, -0.60894321f, -0.14275706f, -0.29178151f }, { -0.21477227f, 0.091254596f, -0.053659362f, -0.13299553f }, { -0.24972574f, 0.22261101f, -0.59415755f, -0.13299464f }, { -0.406027f, 0.15018847f, 0.33281927f, 0.28006105f }, { -0.033198856f, 0.013081228f, 0.0098634494f, -0.18858267f }, { -0.16914457f, -0.014917022f, -0.15618156f, 0.038961385f }, { 0.0f, 0.0115085f, 0.0f, 0.0f }, { 0.047340338f, -0.052961301f, 0.30193278f, 0.38564757f }, { -0.2009302f, -0.15247105f, -0.32333852f, 0.22878398f }, { -0.22934017f, 0.022888443f, 0.30911154f, -0.12420416f }, { 0.21191356f, -0.33281926f, -0.13523708f, -0.038546557f }, { 0.28507859f, -0.012777666f, 0.16285544f, -0.12612215f }, { -0.057034227f, 0.01719448f, -0.037892291f, -0.13064036f }, { -0.075888865f, 0.041589292f, 0.0089100653f, -0.10775402f }, { 0.0075560462f, 0.0f, 0.0f, 0.0f }, { -0.18120766f, 0.16485298f, 0.58949587f, 0.072313493f } } }, { { { 0.60381773f, 0.64633179f, 0.92301353f, 0.23720177f }, { 1.1128727f, 0.42172315f, 1.6605811f, 0.22066721f }, { 0.55829912f, 0.7107351f, 0.47437673f, 0.53646626f }, { 0.75684406f, 0.65607146f, 1.5264507f, 0.12817954f }, { -0.25070514f, 0.30263175f, -0.21070678f, -0.2264813f }, { -0.24745858f, -0.26801252f, 0.2750925f, 0.055035565f }, { -0.018769156f, -0.066023008f, 0.10111114f, 0.0089232736f }, { 0.41152465f, 0.52508091f, 0.4161358f, 0.39058287f }, { 0.90919582f, 1.2448772f, 0.61547497f, 0.51303689f }, { 0.2973136f, 1.2348603f, 0.24154398f, 0.76087607f }, { 0.23369317f, 0.68368068f, 0.81024353f, 0.35451079f }, { 0.69272073f, 0.47014545f, 0.61401877f, 0.43768641f }, { -0.44449894f, -0.10123077f, -0.19173956f, -0.15811184f }, { -0.089717f, -0.068601549f, -0.16704813f, -0.29761406f }, { 0.0055968308f, -0.089855929f, -0.087150641f, 0.2244144f }, { 0.38902787f, 0.62620686f, 1.3314901f, 0.26038797f }, { 0.16776511f, 0.32722251f, 0.71914611f, 0.53556119f }, { 0.63106992f, 0.46256454f, 1.785895f, 0.17339911f }, { 0.72516261f, 0.44941094f, 0.81174974f, 0.61247129f }, { 0.56877815f, 0.20989179f, 0.7607991f, 0.017998645f }, { 0.016372087f, 0.26062407f, -0.32771461f, -0.075930098f }, { -0.11957223f, -0.22579003f, -0.42587945f, -0.0015549589f }, { 0.0049992009f, 0.053511694f, 0.00053268274f, 0.022778575f }, { 0.19356675f, 0.5564623f, 0.74981777f, 0.28733119f } }, { { 0.017029304f, 0.22690356f, 0.25927682f, -0.048136042f }, { 0.52936856f, -0.26082526f, 0.12568074f, -0.046727529f }, { 0.08949554f, -0.019090555f, 0.31477592f, -0.067513409f }, { 0.056302335f, -0.011819435f, -0.063621104f, 0.27092306f }, { 0.053971592f, -0.17913246f, -0.14991651f, -0.044263405f }, { 0.29037749f, -0.040498369f, -0.33600753f, 0.16250066f }, { -0.067102844f, -0.17843768f, 0.033172168f, 0.13638573f }, { 0.057127881f, -0.044468822f, 0.33005778f, 0.34775491f }, { -0.14300931f, 0.022121077f, -0.045281831f, -0.065216583f }, { 0.084931489f, 0.06688461f, 0.15758114f, -0.091330485f }, { -0.014274888f, 0.29139103f, 0.089163749f, -0.18005467f }, { -0.2191522f, -0.1333803f, -0.31948964f, -0.28536602f }, { 0.20298891f, -0.0031882515f, -0.15749696f, -0.014977715f }, { -0.14016857f, -0.17278064f, 0.01369474f, 0.10971499f }, { 0.018219806f, 0.080447764f, 0.0056022696f, -0.043028475f }, { -0.076556403f, -0.13038184f, -0.23788273f, 0.5849635f }, { 0.1038427f, 0.18199702f, 0.35294355f, -0.0023601311f }, { 0.22294845f, -0.37427713f, 0.2907529f, 0.26234219f }, { 0.40809306f, 0.12982813f, 0.42857338f, 0.14064303f }, { 0.4265028f, 0.18710053f, 0.15310514f, 0.067551813f }, { -0.18986488f, -0.029676062f, -0.087045959f, -0.14788626f }, { -0.07865478f, 0.011558295f, -0.018262356f, 0.38992629f }, { 0.22297641f, 0.072192947f, 0.064119712f, 0.12862555f }, { -0.069262467f, -0.14990585f, 0.31342655f, -0.15002022f } }, { { 0.25288162f, -0.096551539f, 0.051695506f, 0.20925392f }, { 0.23093904f, 0.096712594f, 0.19826434f, 0.32530694f }, { 0.14114785f, 0.071010138f, -0.17642029f, 0.092260082f }, { 0.39001648f, -0.17666595f, 0.088397252f, 0.1462816f }, { 0.12484597f, 0.066920676f, -0.16116194f, 0.21758387f }, { 0.15625272f, -0.00043631439f, -0.07868976f, -0.19261141f }, { -0.0142415f, 0.06356153f, 0.026276923f, -0.024546668f }, { 0.097089221f, 0.085426402f, 0.11936115f, 0.012042542f }, { 0.52509109f, -0.22465399f, -0.11490612f, 0.023562122f }, { -0.12418278f, 0.11985465f, 0.087804943f, 0.25283464f }, { 0.10716753f, -0.036426901f, 0.2469409f, -0.095816257f }, { -0.095364501f, 0.14001518f, -0.068636804f, -0.082487255f }, { 0.074490355f, 0.25323233f, 0.17863748f, 0.12482145f }, { -0.019616587f, -0.0053326518f, 0.047558858f, 0.066104462f }, { 0.12647102f, 0.25712368f, 0.12306783f, -0.050252261f }, { -0.13375041f, 0.17825067f, 0.026649645f, -0.33338076f }, { 0.16384463f, -0.022241979f, 0.17817325f, 0.6808721f }, { 0.42075944f, -0.024292721f, -0.11323318f, 0.45027063f }, { -0.023953485f, 0.25719992f, 0.28680108f, 0.33600529f }, { 0.013445546f, 0.22504275f, 0.17408162f, 0.52860686f }, { -0.098839039f, -0.27017244f, 0.10293505f, -0.012472685f }, { 0.074267375f, -0.0056418849f, 0.17632358f, 0.21754089f }, { 0.1491061f, 0.017927571f, -0.0217757f, -0.0039381966f }, { 0.067239102f, -0.74624136f, 0.12992555f, -0.058866581f } } } }, { { { { 0.1270204f, 0.7650174f, 0.55252173f, 0.05956498f }, { -0.36870832f, 0.31227245f, 0.52167466f, 0.4282174f }, { -0.036761861f, -0.5477415f, -0.76091563f, -0.37583127f }, { 0.17129434f, -0.14281209f, -0.40463148f, -0.56367877f }, { 0.07429238f, 0.45420144f, 0.41919765f, 0.019225986f }, { -0.44125436f, -0.05567539f, 0.080551064f, 0.54444995f }, { -0.36600455f, -0.55359309f, -0.3290331f, 0.33946169f }, { 0.65253747f, 0.015186649f, 0.0665303f, -0.64649501f }, { 0.05392469f, 0.54355001f, 0.7539307f, -0.41089455f }, { -0.29264863f, 0.49684721f, 0.39184208f, 0.47737193f }, { 0.10885354f, -0.80803227f, -0.7443769f, -0.3736688f }, { 0.1939378f, -0.079590275f, -0.42241709f, -0.75536039f }, { 0.44776697f, 0.44884546f, 0.427965f, 0.3297221f }, { -0.34595785f, 0.27723463f, 0.12245317f, 0.43884357f }, { 0.18467758f, -0.55582608f, -0.99421464f, -0.0096027817f }, { 0.6672057f, -0.038103784f, -0.048616141f, -0.68508055f }, { -0.016615937f, 0.62001729f, 0.50530563f, -0.22211425f }, { -0.16823123f, 0.31934529f, 0.47092187f, 0.4884373f }, { 0.03194189f, -0.5624624f, -0.44688229f, 0.223814f }, { 0.17828041f, -0.080017082f, -0.44239439f, -0.46726625f }, { 0.19895649f, 0.82568772f, 0.47859751f, 0.064443297f }, { -0.47464217f, 0.011895223f, 0.01123465f, -0.010697203f }, { -0.17670677f, -0.66931423f, -0.5814681f, -0.01325001f }, { 0.65193874f, -0.010713062f, -0.007915928f, -0.65520853f } }, { { -0.01027431f, -0.0019056004f, 0.0020213958f, 0.0064495753f }, { 0.0058416688f, 0.0051314639f, 0.021497114f, 0.005870592f }, { -0.00035518612f, -0.00087553938f, -0.0029318969f, 0.0087577986f }, { -0.0048770476f, -0.015949665f, -0.034816051f, -0.006104917f }, { 0.0015371362f, -0.0012591621f, 0.01241148f, 0.00096621463f }, { 0.0032416133f, 0.021025709f, 0.0036344622f, 0.0015436078f }, { -0.0093946276f, 0.0046564763f, 0.028177476f, -0.01022744f }, { 0.00014675555f, 0.030031482f, -0.0092302407f, -0.001999398f }, { -0.049980321f, 0.024752279f, 0.016684689f, -0.0045230976f }, { 0.0067493834f, 0.014071508f, 0.0079316435f, 0.034593704f }, { 0.01971715f, -0.0037227013f, -0.013430278f, -0.024257585f }, { -0.004342319f, 0.024001878f, -0.013356442f, -0.022792018f }, { -0.0051709665f, -0.017029547f, 0.040567567f, 0.0052520812f }, { 0.0090399102f, 0.0079604733f, 0.00018765016f, -0.0092868977f }, { -0.020304032f, 0.0056590257f, -0.0045373063f, -0.018653318f }, { -9.9636934e-05f, 0.002001886f, 0.0046843544f, 0.0055608043f }, { 0.0018025744f, -0.0025962216f, 0.0068285574f, -0.014851062f }, { 0.00041645221f, 0.0054738242f, 0.0076769026f, -0.013419208f }, { 0.0038347099f, -0.0042555066f, -0.0066470075f, 0.0039146778f }, { -0.009084153f, 0.024461537f, 0.0034578066f, -0.0054827001f }, { 0.0033463477f, 0.0045594748f, 0.00037604935f, -0.01571513f }, { -0.012589588f, 0.029678359f, -0.019924871f, -0.004708459f }, { -0.0002642682f, -0.0051057336f, -0.0042867302f, -0.00041141781f }, { -0.00086487068f, -0.0025170841f, 0.0030062196f, -0.0030385417f } }, { { -0.01027431f, -0.0019056004f, 0.0020213958f, 0.0064495753f }, { 0.0058416688f, 0.0051314639f, 0.021497114f, 0.005870592f }, { -0.00035518612f, -0.00087553938f, -0.0029318969f, 0.0087577986f }, { -0.0048770476f, -0.015949665f, -0.034816051f, -0.006104917f }, { 0.0015371362f, -0.0012591621f, 0.01241148f, 0.00096621463f }, { 0.0032416133f, 0.021025709f, 0.0036344622f, 0.0015436078f }, { -0.0093946276f, 0.0046564763f, 0.028177476f, -0.01022744f }, { 0.00014675555f, 0.030031482f, -0.0092302407f, -0.001999398f }, { -0.049980321f, 0.024752279f, 0.016684689f, -0.0045230976f }, { 0.0067493834f, 0.014071508f, 0.0079316435f, 0.034593704f }, { 0.01971715f, -0.0037227013f, -0.013430278f, -0.024257585f }, { -0.004342319f, 0.024001878f, -0.013356442f, -0.022792018f }, { -0.0051709665f, -0.017029547f, 0.040567567f, 0.0052520812f }, { 0.0090399102f, 0.0079604733f, 0.00018765016f, -0.0092868977f }, { -0.020304032f, 0.0056590257f, -0.0045373063f, -0.018653318f }, { -9.9636934e-05f, 0.002001886f, 0.0046843544f, 0.0055608043f }, { 0.0018025744f, -0.0025962216f, 0.0068285574f, -0.014851062f }, { 0.00041645221f, 0.0054738242f, 0.0076769026f, -0.013419208f }, { 0.0038347099f, -0.0042555066f, -0.0066470075f, 0.0039146778f }, { -0.009084153f, 0.024461537f, 0.0034578066f, -0.0054827001f }, { 0.0033463477f, 0.0045594748f, 0.00037604935f, -0.01571513f }, { -0.012589588f, 0.029678359f, -0.019924871f, -0.004708459f }, { -0.0002642682f, -0.0051057336f, -0.0042867302f, -0.00041141781f }, { -0.00086487068f, -0.0025170841f, 0.0030062196f, -0.0030385417f } } }, { { { -0.68772793f, 0.19029367f, -0.17427646f, 0.60300616f }, { -0.29980532f, -0.22397537f, -0.4071009f, 0.36277983f }, { 0.75628069f, -0.13426242f, 0.13645381f, -0.74653491f }, { 0.14891408f, -0.13497977f, 0.36807879f, -0.39814386f }, { -0.20608987f, -0.076497863f, -0.19510375f, 0.34604256f }, { -0.02421123f, -0.4588774f, -0.64965351f, 0.083039161f }, { 0.51918764f, -0.30614677f, -0.25791921f, -0.40837612f }, { 0.028860181f, 0.63152733f, 0.5876224f, -0.033139773f }, { -0.63418144f, 0.046874151f, 0.24431924f, 0.71662556f }, { -0.29088451f, -0.21455586f, -0.73980807f, 0.65038559f }, { 0.78663226f, 0.00020858525f, 0.40361403f, -0.75720144f }, { 0.1998276f, 0.54590973f, 0.1773378f, -0.35464319f }, { -0.40236144f, 0.31362578f, -0.34406026f, 0.38120073f }, { -0.27845549f, -0.46862161f, -0.47141499f, 0.095899189f }, { 0.6004921f, 0.28051621f, -0.011378178f, -0.98141078f }, { 0.032724674f, 0.66798127f, 0.66430425f, -0.05209965f }, { -0.59603974f, -0.083198329f, 0.34616224f, 0.42082916f }, { -0.14262632f, -0.21418442f, -0.37504914f, 0.32676687f }, { 0.58204273f, 0.0067537174f, -0.35923481f, -0.40792038f }, { 0.15607366f, 0.17215007f, 0.34414936f, -0.33566945f }, { -0.44862333f, 0.004919013f, 0.0076768115f, 0.41897935f }, { -0.022062848f, -0.39695079f, -0.0062786656f, 0.042925103f }, { 0.65953535f, -0.15521993f, 0.011867978f, -0.57721165f }, { 0.031305912f, 0.65627006f, 0.66779002f, -0.029815636f } }, { { 0.011457792f, -0.011774949f, -0.012205337f, 0.0048139052f }, { -0.024024566f, 0.018313023f, -0.023210623f, -0.0046351547f }, { 0.0039133571f, 0.0046801024f, -0.020590099f, -0.0018568631f }, { -0.015369931f, -0.0092621276f, -0.026149742f, 0.0010335971f }, { 0.032555144f, -0.01336897f, -0.022733265f, -0.027997469f }, { -0.028161537f, -0.00073877629f, -0.023989631f, 0.0055660453f }, { -0.012966193f, 0.003944376f, 0.025685982f, -0.0017458044f }, { 0.00015626641f, -0.009524206f, 0.0083025026f, -0.00049753811f }, { -0.02358661f, 0.006370149f, 0.00087066462f, -0.00054248544f }, { -0.0024571244f, -0.023218369f, -0.010895303f, -0.0095647684f }, { 0.0069970393f, -0.00093403301f, -0.0081922371f, -0.00026359768f }, { 0.0065921354f, 0.028846533f, -0.045676337f, 0.006070217f }, { 0.0045248423f, -0.0084676847f, 0.028756195f, 0.020612871f }, { 0.0037691244f, -0.0069385161f, -0.00029501448f, -0.0017839033f }, { -0.0048675353f, -0.011930456f, 0.0044251285f, -0.00016323616f }, { -0.0012291164f, -0.0019575288f, 0.0078250029f, -0.0011151155f }, { 0.00503333f, -0.0094538968f, 0.0092375183f, 0.018207648f }, { 0.0080615812f, -0.0073583459f, -0.0166794f, 0.016416158f }, { 0.002192959f, -0.01153759f, -0.0048668362f, -0.0071123281f }, { -0.010116143f, -0.010224552f, 0.010897731f, 0.00093792816f }, { 0.017199359f, -0.0087516179f, 0.0021169251f, -0.020946959f }, { -0.01570063f, 0.020087246f, 0.014492818f, -0.016014018f }, { 0.0023484072f, 0.0015070243f, -0.00045616273f, -0.001211882f }, { 0.0018090492f, -0.0012261901f, 0.0012809284f, 0.00096488905f } }, { { 0.011457792f, -0.011774949f, -0.012205337f, 0.0048139052f }, { -0.024024566f, 0.018313023f, -0.023210623f, -0.0046351547f }, { 0.0039133571f, 0.0046801024f, -0.020590099f, -0.0018568631f }, { -0.015369931f, -0.0092621276f, -0.026149742f, 0.0010335971f }, { 0.032555144f, -0.01336897f, -0.022733265f, -0.027997469f }, { -0.028161537f, -0.00073877629f, -0.023989631f, 0.0055660453f }, { -0.012966193f, 0.003944376f, 0.025685982f, -0.0017458044f }, { 0.00015626641f, -0.009524206f, 0.0083025026f, -0.00049753811f }, { -0.02358661f, 0.006370149f, 0.00087066462f, -0.00054248544f }, { -0.0024571244f, -0.023218369f, -0.010895303f, -0.0095647684f }, { 0.0069970393f, -0.00093403301f, -0.0081922371f, -0.00026359768f }, { 0.0065921354f, 0.028846533f, -0.045676337f, 0.006070217f }, { 0.0045248423f, -0.0084676847f, 0.028756195f, 0.020612871f }, { 0.0037691244f, -0.0069385161f, -0.00029501448f, -0.0017839033f }, { -0.0048675353f, -0.011930456f, 0.0044251285f, -0.00016323616f }, { -0.0012291164f, -0.0019575288f, 0.0078250029f, -0.0011151155f }, { 0.00503333f, -0.0094538968f, 0.0092375183f, 0.018207648f }, { 0.0080615812f, -0.0073583459f, -0.0166794f, 0.016416158f }, { 0.002192959f, -0.01153759f, -0.0048668362f, -0.0071123281f }, { -0.010116143f, -0.010224552f, 0.010897731f, 0.00093792816f }, { 0.017199359f, -0.0087516179f, 0.0021169251f, -0.020946959f }, { -0.01570063f, 0.020087246f, 0.014492818f, -0.016014018f }, { 0.0023484072f, 0.0015070243f, -0.00045616273f, -0.001211882f }, { 0.0018090492f, -0.0012261901f, 0.0012809284f, 0.00096488905f } } }, { { { 0.71476997f, 0.61525336f, 0.81507512f, 0.79550964f }, { 0.87986984f, 0.9232123f, 0.74974956f, 0.82765975f }, { 0.65321366f, 0.82580437f, 0.63434042f, 0.54903231f }, { 0.97390084f, 0.98050251f, 0.83713283f, 0.72370416f }, { 0.97570877f, 0.88760866f, 0.88668363f, 0.9380218f }, { 0.89705541f, 0.88675351f, 0.75595095f, 0.83467284f }, { 0.77232433f, 0.77447327f, 0.9084134f, 0.84734569f }, { -0.75720667f, -0.77520488f, -0.80639546f, -0.76219811f }, { 0.77130152f, 0.83806694f, 0.60983327f, 0.56357207f }, { 0.91090229f, 0.84089752f, 0.54694041f, 0.59085922f }, { 0.60775044f, 0.58913818f, 0.53197627f, 0.53574024f }, { 0.96044628f, 0.83405513f, 0.88888419f, 0.55105253f }, { 0.79850486f, 0.83676557f, 0.83574428f, 0.86369517f }, { 0.89597751f, 0.83876978f, 0.87336884f, 0.8934314f }, { 0.77801249f, 0.78253947f, 0.10680725f, 0.19167855f }, { -0.74415432f, -0.74320194f, -0.74587957f, -0.72660186f }, { 0.802783f, 0.78016447f, 0.79046691f, 0.87952719f }, { 0.97537479f, 0.92311625f, 0.79848027f, 0.80910594f }, { 0.8125306f, 0.82679528f, 0.81929639f, 0.88516002f }, { 0.97152309f, 0.98181547f, 0.82815966f, 0.81791703f }, { 0.87129411f, 0.56410602f, 0.87800085f, 0.905706f }, { 0.87990229f, 0.91776281f, 0.99991718f, 0.99902102f }, { 0.73060786f, 0.72658464f, 0.81348263f, 0.81648708f }, { -0.75762512f, -0.75445002f, -0.74430762f, -0.75485946f } }, { { 0.018332644f, 0.0084005452f, -0.0018937689f, -0.0035491975f }, { 0.0016556654f, 0.0049261013f, -0.021796869f, 0.0025973591f }, { -0.0019671758f, 0.00051947074f, 0.0071261223f, 0.0056689139f }, { 0.00041901024f, -0.0023903288f, -0.0035639711f, -0.0036673013f }, { 0.009963464f, 0.00099195429f, -0.0042516892f, 0.0092605531f }, { 0.0034813664f, 0.0028575465f, -0.016343415f, -0.0014475905f }, { 0.0053571039f, 0.0051116063f, 0.016171091f, -0.00052744238f }, { 0.00013272575f, -0.0095491849f, 0.0070156475f, 0.0017057538f }, { 0.028067438f, -0.0086835729f, -0.0087852674f, 0.0035321054f }, { 0.0025007808f, -0.0075654884f, -0.012551417f, -0.0068823899f }, { -0.00017607308f, 0.002636122f, -0.011272055f, -0.010314896f }, { 0.010646599f, 0.00042804331f, 0.013900837f, -0.01279076f }, { 0.0059898286f, 0.012331371f, -0.0073125296f, 0.016248603f }, { 0.031579315f, -0.0057840222f, -0.00018304192f, 0.005171422f }, { 0.010928513f, 0.0092660887f, 0.030404621f, 0.0053167707f }, { -0.00014899672f, -0.0035246494f, 0.0075862845f, -0.005861723f }, { 0.0067791918f, 0.0021224495f, -0.0071755505f, -0.010370936f }, { 0.0015352958f, -0.0025785166f, -0.0092688001f, 0.003966373f }, { 0.0036915074f, -0.002306452f, -0.005736452f, -0.0033594125f }, { 0.0065128512f, 0.006188005f, 0.00088322638f, -0.0016227066f }, { 0.0092720771f, -0.0046684631f, -7.3769604e-05f, 0.013807013f }, { -0.0031421984f, 0.010622679f, 0.00041591214f, 0.0032786075f }, { -0.0021421613f, -0.0041675589f, -0.0029529994f, -0.00085350449f }, { -0.00069204344f, -0.0010785124f, 0.00097549628f, 0.0025280456f } }, { { 0.018332644f, 0.0084005452f, -0.0018937689f, -0.0035491975f }, { 0.0016556654f, 0.0049261013f, -0.021796869f, 0.0025973591f }, { -0.0019671758f, 0.00051947074f, 0.0071261223f, 0.0056689139f }, { 0.00041901024f, -0.0023903288f, -0.0035639711f, -0.0036673013f }, { 0.009963464f, 0.00099195429f, -0.0042516892f, 0.0092605531f }, { 0.0034813664f, 0.0028575465f, -0.016343415f, -0.0014475905f }, { 0.0053571039f, 0.0051116063f, 0.016171091f, -0.00052744238f }, { 0.00013272575f, -0.0095491849f, 0.0070156475f, 0.0017057538f }, { 0.028067438f, -0.0086835729f, -0.0087852674f, 0.0035321054f }, { 0.0025007808f, -0.0075654884f, -0.012551417f, -0.0068823899f }, { -0.00017607308f, 0.002636122f, -0.011272055f, -0.010314896f }, { 0.010646599f, 0.00042804331f, 0.013900837f, -0.01279076f }, { 0.0059898286f, 0.012331371f, -0.0073125296f, 0.016248603f }, { 0.031579315f, -0.0057840222f, -0.00018304192f, 0.005171422f }, { 0.010928513f, 0.0092660887f, 0.030404621f, 0.0053167707f }, { -0.00014899672f, -0.0035246494f, 0.0075862845f, -0.005861723f }, { 0.0067791918f, 0.0021224495f, -0.0071755505f, -0.010370936f }, { 0.0015352958f, -0.0025785166f, -0.0092688001f, 0.003966373f }, { 0.0036915074f, -0.002306452f, -0.005736452f, -0.0033594125f }, { 0.0065128512f, 0.006188005f, 0.00088322638f, -0.0016227066f }, { 0.0092720771f, -0.0046684631f, -7.3769604e-05f, 0.013807013f }, { -0.0031421984f, 0.010622679f, 0.00041591214f, 0.0032786075f }, { -0.0021421613f, -0.0041675589f, -0.0029529994f, -0.00085350449f }, { -0.00069204344f, -0.0010785124f, 0.00097549628f, 0.0025280456f } } }, { { { 5.3792285f, 5.1960477f, 5.5112916f, 5.6615254f }, { 5.0489877f, 5.2428834f, 5.1752035f, 5.1109826f }, { 5.5205204f, 5.7511938f, 5.0202917f, 4.9168865f }, { 4.9522523f, 4.8880256f, 5.1015936f, 5.2858816f }, { 5.7256502f, 5.7919759f, 5.645241f, 5.6035708f }, { 6.4076931f, 6.4822111f, 6.2642633f, 6.3925959f }, { 6.9797014f, 6.981436f, 7.0028674f, 6.9976464f }, { -0.03290957f, -0.03290957f, -0.03290957f, -0.03290957f }, { 5.4977854f, 5.7684965f, 5.3463095f, 4.8810492f }, { 4.9869047f, 5.4896416f, 4.9647805f, 4.884877f }, { 5.3141219f, 5.3357788f, 4.7695434f, 4.8709631f }, { 5.2056063f, 5.407802f, 5.2123857f, 4.9428208f }, { 6.2188218f, 6.17756f, 6.2751008f, 6.3672109f }, { 6.9105856f, 6.7986798f, 6.5712335f, 6.5907061f }, { 6.9797014f, 6.9797014f, 5.6859993f, 5.5642483f }, { -0.032764603f, -0.032764603f, -0.032764603f, -0.032764603f }, { 5.7724142f, 6.0929556f, 5.99581f, 5.9265164f }, { 4.9363192f, 4.9823732f, 5.1732995f, 5.2475265f }, { 5.8365191f, 5.9972902f, 5.9778441f, 5.9270668f }, { 4.8706768f, 5.0194503f, 5.155585f, 5.2188041f }, { 6.1569904f, 6.0563989f, 6.0989699f, 6.2139837f }, { 5.8727399f, 5.8948086f, 5.5734095f, 5.5536103f }, { 6.9797014f, 6.9797014f, 6.9797014f, 6.9797014f }, { -0.032766769f, -0.032766769f, -0.032766769f, -0.032766769f } }, { { 0.0011802354f, -0.006546101f, -0.02103972f, 0.0008654047f }, { -0.015460534f, 0.017874544f, 0.0029121134f, 0.023511773f }, { -0.040909245f, 0.011927691f, 0.011991588f, 0.01677931f }, { -0.015633544f, -0.0042321141f, 0.026623034f, 0.0080414514f }, { 0.012614382f, 0.0065080145f, 0.035716738f, -0.0080665814f }, { -0.0057849744f, -0.017478461f, -0.031219642f, 0.00016446523f }, { 0.0f, 0.00032235028f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { -0.068586697f, -0.024228236f, -0.012857221f, -0.039493706f }, { -0.018078201f, -0.015140979f, 0.00072119173f, -0.051249859f }, { -0.054228277f, 0.0097895101f, 0.0019832646f, -0.011715411f }, { -0.042326208f, -0.010160072f, 0.037088052f, -0.031848667f }, { 0.00067130897f, -0.013966717f, -0.017268559f, -0.0074614576f }, { 0.070515961f, 0.012848107f, -0.0008396517f, 0.0049006506f }, { 0.0f, 0.0f, -0.063014256f, -0.0085124986f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { -0.040302299f, 0.0048936307f, 0.0064406394f, 0.0034044871f }, { -0.010453589f, 0.0035820836f, -0.017384391f, -0.038199947f }, { -0.044968611f, -0.0088322127f, 0.020303819f, 0.0058131005f }, { -0.0056838535f, 0.010211409f, -0.010999927f, -0.027621859f }, { 0.0064753811f, -0.0059341242f, -0.014902755f, 0.0082868118f }, { -0.0013222735f, 0.0028492181f, -0.023523273f, -0.02576271f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f } }, { { 0.0011802354f, -0.006546101f, -0.02103972f, 0.00086540469f }, { -0.015460534f, 0.017874544f, 0.0029121134f, 0.023511773f }, { -0.040909245f, 0.011927691f, 0.011991588f, 0.01677931f }, { -0.015633544f, -0.0042321141f, 0.026623034f, 0.0080414514f }, { 0.012614382f, 0.0065080145f, 0.035716738f, -0.0080665814f }, { -0.0057849744f, -0.017478461f, -0.031219642f, 0.00016446523f }, { 0.0f, 0.00032235028f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { -0.068586697f, -0.024228236f, -0.012857221f, -0.039493706f }, { -0.018078201f, -0.015140979f, 0.00072119173f, -0.051249859f }, { -0.054228277f, 0.0097895101f, 0.0019832646f, -0.011715411f }, { -0.042326208f, -0.010160072f, 0.037088052f, -0.031848667f }, { 0.00067130897f, -0.013966717f, -0.017268559f, -0.0074614576f }, { 0.070515961f, 0.012848107f, -0.0008396517f, 0.0049006506f }, { 0.0f, 0.0f, -0.063014256f, -0.0085124986f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { -0.040302299f, 0.0048936307f, 0.0064406394f, 0.0034044871f }, { -0.010453589f, 0.0035820836f, -0.017384391f, -0.038199947f }, { -0.044968611f, -0.0088322127f, 0.020303819f, 0.0058131005f }, { -0.0056838535f, 0.010211409f, -0.010999927f, -0.027621859f }, { 0.0064753811f, -0.0059341242f, -0.014902755f, 0.0082868118f }, { -0.0013222735f, 0.0028492181f, -0.023523273f, -0.02576271f }, { 0.0f, 0.0f, 0.0f, 0.0f }, { 0.0f, 0.0f, 0.0f, 0.0f } } }, { { { 0.72189984f, 0.22069996f, 0.71952927f, 0.77725949f }, { 0.4054405f, 0.20582059f, 0.2747016f, 0.37612563f }, { 0.58887422f, 0.27441131f, 0.19468101f, 0.21480554f }, { 0.46814145f, 0.34317f, 0.46068212f, 0.13962064f }, { -0.18134132f, -0.26668789f, -0.60984999f, -0.67879259f }, { -0.47870351f, -0.34453227f, 0.32494779f, 0.10292971f }, { 0.087252967f, 0.066950358f, 0.31813819f, 0.071094818f }, { -0.0031436256f, 0.038245091f, -0.0076651913f, -0.015389479f }, { 1.2668531f, 1.2894974f, 0.40584018f, 0.51755806f }, { 1.3207257f, 1.3403747f, 0.54924634f, 0.40282713f }, { 0.78581828f, 0.56379328f, 0.27901993f, 0.56429306f }, { 0.8748226f, 1.0271253f, 1.0085726f, 0.3888545f }, { -0.22577636f, -0.32895071f, -0.2846317f, -0.11679531f }, { 0.26477285f, 0.3179447f, -0.063393238f, 0.024059773f }, { -0.15463395f, -0.22721468f, -0.20680404f, -0.15700788f }, { 0.012107106f, -0.0061245949f, -0.024224367f, 0.005040693f }, { 0.97943693f, 0.64840429f, 0.45106998f, 0.40771935f }, { 0.49907853f, 0.1562184f, 0.34338458f, 0.39710628f }, { 0.95047709f, 0.53336107f, 0.38318275f, 0.44919148f }, { 0.41892697f, 0.069965886f, 0.45831656f, 0.38821529f }, { -0.20216736f, -0.43209441f, -0.57684857f, -0.40189427f }, { -0.63992377f, -0.40683032f, -0.59207903f, -0.57251716f }, { -0.047117438f, -0.1880015f, -0.12265155f, 0.00059988607f }, { -0.011836442f, -0.010049497f, -0.0026152072f, 0.016137736f } }, { { 0.092068993f, 0.0045466749f, 0.0054574031f, 0.02582156f }, { 0.022115456f, -0.015664041f, -0.022004653f, 0.041431654f }, { 0.029951298f, -0.0004408542f, 0.0087496069f, 0.017850027f }, { 0.029086373f, 0.022116039f, 0.044010315f, 0.001644876f }, { 0.016256387f, 0.0083249367f, 0.019570849f, -0.0021276222f }, { 0.0079070076f, -0.024696939f, 0.044311101f, 0.023671132f }, { -0.0081796119f, -0.0024995551f, 0.033501743f, -0.031958988f }, { 0.0065005403f, -0.076642001f, 0.015736477f, 0.030966939f }, { 0.029110717f, 0.039154477f, -0.074376619f, 0.025532063f }, { -0.10980761f, 0.0038346834f, 0.014449171f, -0.030702653f }, { -0.00068350423f, -0.037251569f, -0.008409224f, -0.026322878f }, { 0.035406012f, 0.064176275f, 0.031437854f, -0.0344642f }, { 0.037145809f, -0.024909212f, 0.041030386f, 0.035216105f }, { -0.093276646f, -0.013904083f, -0.019536023f, -0.023834405f }, { 0.042751846f, -0.03620164f, 0.081115921f, 0.018379967f }, { -0.023909625f, 0.012833691f, 0.048086442f, -0.0097340268f }, { 0.039552712f, -0.00026806514f, 0.011646753f, 0.0065939486f }, { 0.058985248f, 0.020165701f, 0.0076721521f, 0.033274221f }, { 0.052889871f, 0.0042520093f, 0.016490396f, 0.009287973f }, { 0.044305975f, -0.0016263469f, 0.041390177f, 0.033541355f }, { 0.014595133f, -0.004801042f, -0.0049517302f, 0.015714264f }, { 0.00075086205f, 0.0080838736f, -0.037611057f, -0.030488441f }, { 0.0019178075f, -0.0082517768f, -0.002525773f, 0.0043993022f }, { 0.023774971f, 0.020335611f, 0.0056643868f, -0.032100338f } }, { { 0.092068993f, 0.0045466749f, 0.0054574031f, 0.02582156f }, { 0.022115456f, -0.015664041f, -0.022004653f, 0.041431654f }, { 0.029951298f, -0.0004408542f, 0.0087496069f, 0.017850027f }, { 0.029086373f, 0.022116039f, 0.044010315f, 0.001644876f }, { 0.016256387f, 0.0083249367f, 0.019570849f, -0.0021276222f }, { 0.0079070076f, -0.024696939f, 0.044311101f, 0.023671132f }, { -0.0081796119f, -0.0024995551f, 0.033501743f, -0.031958988f }, { 0.0065005403f, -0.076642001f, 0.015736477f, 0.030966939f }, { 0.029110717f, 0.039154477f, -0.074376619f, 0.025532063f }, { -0.10980761f, 0.0038346834f, 0.014449171f, -0.030702653f }, { -0.00068350423f, -0.037251569f, -0.008409224f, -0.026322878f }, { 0.035406012f, 0.064176275f, 0.031437854f, -0.0344642f }, { 0.037145809f, -0.024909212f, 0.041030386f, 0.035216105f }, { -0.093276646f, -0.013904083f, -0.019536023f, -0.023834405f }, { 0.042751846f, -0.03620164f, 0.081115921f, 0.018379967f }, { -0.023909625f, 0.012833691f, 0.048086442f, -0.0097340268f }, { 0.039552712f, -0.00026806514f, 0.011646753f, 0.0065939486f }, { 0.058985248f, 0.020165701f, 0.0076721521f, 0.033274221f }, { 0.052889871f, 0.0042520093f, 0.016490396f, 0.009287973f }, { 0.044305975f, -0.0016263469f, 0.041390177f, 0.033541355f }, { 0.014595133f, -0.004801042f, -0.0049517303f, 0.015714264f }, { 0.00075086205f, 0.0080838736f, -0.037611057f, -0.030488441f }, { 0.0019178075f, -0.0082517768f, -0.002525773f, 0.0043993022f }, { 0.023774971f, 0.020335611f, 0.0056643868f, -0.032100338f } } } } };

#endif
