/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.debugger;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.debugger.SqlProgramPosition;
import com.intellij.database.debugger.SqlVariable;
import com.intellij.database.debugger.SqlVariableValue;
import com.intellij.database.debugger.SqlVariablesViewModel;
import com.intellij.database.dialects.oracle.debugger.OraDebuggingSession;
import com.intellij.database.dialects.oracle.debugger.OraNamespace;
import com.intellij.database.dialects.oracle.debugger.OraPosition;
import com.intellij.database.dialects.oracle.debugger.OraProgramPosition;
import com.intellij.database.dialects.oracle.debugger.OraScriptPosition;
import com.intellij.database.dialects.oracle.debugger.OraVariableFinder;
import com.intellij.database.dialects.oracle.debugger.RetrieveVariablesCommand;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0005%&'()B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\"\u0010\r\u001a\u00060\u000eR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u00060\u0016R\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00060\u001bR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00060\fR\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u001cJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00102\b\u0010#\u001a\u0004\u0018\u00010$H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\f\u0012\b\u0012\u00060\fR\u00020\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "variableFinder", "Lcom/intellij/database/dialects/oracle/debugger/OraVariableFinder;", "session", "Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;", "globalEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraVariableFinder;Lcom/intellij/database/dialects/oracle/debugger/OraDebuggingSession;Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;)V", "frames", "", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$Frame;", "makeScriptFrame", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$ScriptFrame;", "frameLevel", "", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraScriptPosition;", "xPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "makeProgramFrame", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$ProgramFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramPosition;", "programPosition", "Lcom/intellij/database/debugger/SqlProgramPosition;", "makeRoutineWrapperFrame", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$RoutineWrapperFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "makeUnknownFrame", "getTopFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "computeStackFrames", "", "firstFrameIndex", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "Frame", "ScriptFrame", "ProgramFrame", "RoutineWrapperFrame", "UnknownFrame", "intellij.database.dialects.oracle.ex"})
public final class OraStack
extends XExecutionStack {
    @NotNull
    private final OraVariableFinder variableFinder;
    @NotNull
    private final OraDebuggingSession session;
    @Nullable
    private final XDebuggerEvaluator globalEvaluator;
    @NotNull
    private final List<Frame> frames;

    public OraStack(@NotNull OraVariableFinder variableFinder, @NotNull OraDebuggingSession session, @Nullable XDebuggerEvaluator globalEvaluator) {
        Intrinsics.checkNotNullParameter((Object)variableFinder, (String)"variableFinder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super("");
        this.variableFinder = variableFinder;
        this.session = session;
        this.globalEvaluator = globalEvaluator;
        this.frames = new ArrayList();
    }

    @NotNull
    public final ScriptFrame makeScriptFrame(int frameLevel, @NotNull OraScriptPosition position, @NotNull XSourcePosition xPosition) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)xPosition, (String)"xPosition");
        ScriptFrame frame = new ScriptFrame(frameLevel, position, xPosition);
        ((Collection)this.frames).add(frame);
        return frame;
    }

    @NotNull
    public final ProgramFrame makeProgramFrame(int frameLevel, @NotNull OraProgramPosition position, @NotNull SqlProgramPosition programPosition) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)programPosition, (String)"programPosition");
        ProgramFrame frame = new ProgramFrame(frameLevel, position, programPosition);
        ((Collection)this.frames).add(frame);
        return frame;
    }

    @NotNull
    public final RoutineWrapperFrame makeRoutineWrapperFrame(int frameLevel, @NotNull OraPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        RoutineWrapperFrame frame = new RoutineWrapperFrame(frameLevel, position);
        ((Collection)this.frames).add(frame);
        return frame;
    }

    @NotNull
    public final Frame makeUnknownFrame(int frameLevel, @NotNull OraPosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        UnknownFrame frame = new UnknownFrame(frameLevel, position);
        ((Collection)this.frames).add(frame);
        return frame;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        return (XStackFrame)CollectionsKt.firstOrNull(this.frames);
    }

    public void computeStackFrames(int firstFrameIndex, @Nullable XExecutionStack.XStackFrameContainer container) {
        block0: {
            XExecutionStack.XStackFrameContainer xStackFrameContainer = container;
            if (xStackFrameContainer == null) break block0;
            xStackFrameContainer.addStackFrames(this.frames.subList(firstFrameIndex, this.frames.size()), true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00a6\u0004\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001dH\u0016J\u0016\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000fH$J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR(\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rj\u0004\u0018\u0001`\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R.\u0010\u0014\u001a\u0016\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015j\u0004\u0018\u0001`\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStack$Frame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "level", "", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;I)V", "getLevel", "()I", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "getPosition", "()Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "variables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "getVariables", "()Ljava/util/List;", "setVariables", "(Ljava/util/List;)V", "values", "", "Lcom/intellij/database/debugger/SqlVariableValue;", "Lcom/intellij/database/debugger/SqlVariableValues;", "getValues", "()Ljava/util/Map;", "setValues", "(Ljava/util/Map;)V", "x", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "getX", "()Lcom/intellij/xdebugger/frame/XCompositeNode;", "setX", "(Lcom/intellij/xdebugger/frame/XCompositeNode;)V", "viewModel", "Lcom/intellij/database/debugger/SqlVariablesViewModel;", "computeChildren", "", "node", "findVariables", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "intellij.database.dialects.oracle.ex"})
    public abstract class Frame
    extends XStackFrame {
        private final int level;
        @Nullable
        private List<SqlVariable> variables;
        @Nullable
        private Map<SqlVariable, SqlVariableValue> values;
        @Nullable
        private XCompositeNode x;
        @Nullable
        private SqlVariablesViewModel viewModel;

        public Frame(int level) {
            this.level = level;
        }

        public final int getLevel() {
            return this.level;
        }

        @NotNull
        public abstract OraPosition getPosition();

        @Nullable
        public final List<SqlVariable> getVariables() {
            return this.variables;
        }

        public final void setVariables(@Nullable List<SqlVariable> list) {
            this.variables = list;
        }

        @Nullable
        public final Map<SqlVariable, SqlVariableValue> getValues() {
            return this.values;
        }

        public final void setValues(@Nullable Map<SqlVariable, SqlVariableValue> map2) {
            this.values = map2;
        }

        @Nullable
        public final XCompositeNode getX() {
            return this.x;
        }

        public final void setX(@Nullable XCompositeNode xCompositeNode) {
            this.x = xCompositeNode;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List<SqlVariable> variables = this.variables;
            if (variables == null) {
                List list = this.findVariables();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                this.variables = variables = list;
            }
            if (variables.isEmpty()) {
                node.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            SqlVariablesViewModel viewModel = this.viewModel;
            if (viewModel == null) {
                this.viewModel = viewModel = new SqlVariablesViewModel(variables);
            }
            viewModel.applyTopPresenters(node);
            OraStack.this.session.issueCommand(new RetrieveVariablesCommand(this.level, variables, (Function1<? super Map<SqlVariable, SqlVariableValue>, Unit>)((Function1)new Function1<Map<SqlVariable, ? extends SqlVariableValue>, Unit>((Object)viewModel){

                public final void invoke(Map<SqlVariable, SqlVariableValue> p0) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    ((SqlVariablesViewModel)this.receiver).update(p0);
                }
            })));
        }

        @Nullable
        protected abstract List<SqlVariable> findVariables();

        @Nullable
        public XDebuggerEvaluator getEvaluator() {
            return OraStack.this.globalEvaluator;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018j\u0004\u0018\u0001`\u001aH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStack$ProgramFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$Frame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "level", "", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraProgramPosition;", "programPosition", "Lcom/intellij/database/debugger/SqlProgramPosition;", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;ILcom/intellij/database/dialects/oracle/debugger/OraProgramPosition;Lcom/intellij/database/debugger/SqlProgramPosition;)V", "getPosition", "()Lcom/intellij/database/dialects/oracle/debugger/OraProgramPosition;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "guessKindByNamespace", "Lcom/intellij/database/model/ObjectKind;", "namespace", "Lcom/intellij/database/dialects/oracle/debugger/OraNamespace;", "findVariables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "intellij.database.dialects.oracle.ex"})
    public final class ProgramFrame
    extends Frame {
        @NotNull
        private final OraProgramPosition position;
        @NotNull
        private final SqlProgramPosition programPosition;

        public ProgramFrame(@NotNull int level, @NotNull OraProgramPosition position, SqlProgramPosition programPosition) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)programPosition, (String)"programPosition");
            super(level);
            this.position = position;
            this.programPosition = programPosition;
        }

        @Override
        @NotNull
        public OraProgramPosition getPosition() {
            return this.position;
        }

        @NotNull
        public XSourcePosition getSourcePosition() {
            return this.programPosition.getXPosition();
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            ObjectKind kind = this.programPosition.getSource().getKind();
            Icon icon = DbPresentation.getIcon((ObjectKind)kind);
            component.setIcon(icon);
            component.append(kind.getPresentableName(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            component.append(": ", SimpleTextAttributes.GRAY_ATTRIBUTES);
            component.append(this.getPosition().getSchemaName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(".", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(this.getPosition().getProgramName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(": ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(String.valueOf(this.getPosition().getLineNr()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        private final ObjectKind guessKindByNamespace(OraNamespace namespace) {
            ObjectKind objectKind;
            switch (WhenMappings.$EnumSwitchMapping$0[namespace.ordinal()]) {
                case 1: {
                    ObjectKind objectKind2 = ObjectKind.SCRIPT;
                    objectKind = objectKind2;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind2, (String)"SCRIPT");
                    break;
                }
                case 2: {
                    ObjectKind objectKind3 = ObjectKind.BODY;
                    objectKind = objectKind3;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind3, (String)"BODY");
                    break;
                }
                case 3: {
                    ObjectKind objectKind4 = ObjectKind.ROUTINE;
                    objectKind = objectKind4;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind4, (String)"ROUTINE");
                    break;
                }
                case 4: {
                    ObjectKind objectKind5 = ObjectKind.TRIGGER;
                    objectKind = objectKind5;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind5, (String)"TRIGGER");
                    break;
                }
                case 5: {
                    ObjectKind objectKind6 = ObjectKind.NONE;
                    objectKind = objectKind6;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKind6, (String)"NONE");
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return objectKind;
        }

        @Override
        @Nullable
        protected List<SqlVariable> findVariables() {
            return OraStack.this.variableFinder.findVariables(this.getPosition());
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[OraNamespace.values().length];
                try {
                    nArray[OraNamespace.NS_CURSOR.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OraNamespace.NS_BODY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OraNamespace.NS_TOP.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OraNamespace.NS_TRIGGER.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[OraNamespace.NS_NONE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015j\u0004\u0018\u0001`\u0017H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStack$RoutineWrapperFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$Frame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "level", "", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;ILcom/intellij/database/dialects/oracle/debugger/OraPosition;)V", "getPosition", "()Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "computeChildren", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "findVariables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "intellij.database.dialects.oracle.ex"})
    public final class RoutineWrapperFrame
    extends Frame {
        @NotNull
        private final OraPosition position;

        public RoutineWrapperFrame(@NotNull int level, OraPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super(level);
            this.position = position;
        }

        @Override
        @NotNull
        public OraPosition getPosition() {
            return this.position;
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            return null;
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIcon(AllIcons.Debugger.Frame);
            component.append(DatabaseBundle.message((String)"label.routine.wrapper", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }

        @Override
        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.addChildren(XValueChildrenList.EMPTY, true);
        }

        @Override
        @Nullable
        protected List<SqlVariable> findVariables() {
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\r\u001a\u00020\bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013j\u0004\u0018\u0001`\u0015H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStack$ScriptFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$Frame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "level", "", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraScriptPosition;", "xPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;ILcom/intellij/database/dialects/oracle/debugger/OraScriptPosition;Lcom/intellij/xdebugger/XSourcePosition;)V", "getPosition", "()Lcom/intellij/database/dialects/oracle/debugger/OraScriptPosition;", "getSourcePosition", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "findVariables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "intellij.database.dialects.oracle.ex"})
    public final class ScriptFrame
    extends Frame {
        @NotNull
        private final OraScriptPosition position;
        @NotNull
        private final XSourcePosition xPosition;

        public ScriptFrame(@NotNull int level, @NotNull OraScriptPosition position, XSourcePosition xPosition) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            Intrinsics.checkNotNullParameter((Object)xPosition, (String)"xPosition");
            super(level);
            this.position = position;
            this.xPosition = xPosition;
        }

        @Override
        @NotNull
        public OraScriptPosition getPosition() {
            return this.position;
        }

        @NotNull
        public XSourcePosition getSourcePosition() {
            return this.xPosition;
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIcon(DatabaseIcons.SqlOtherStatement);
            component.append("SCRIPT", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(":", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(String.valueOf(this.getPosition().getLineNr()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }

        @Override
        @Nullable
        protected List<SqlVariable> findVariables() {
            OraVariableFinder oraVariableFinder = OraStack.this.variableFinder;
            VirtualFile virtualFile = this.xPosition.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            return oraVariableFinder.findVariables(virtualFile, this.xPosition.getOffset());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015j\u0004\u0018\u0001`\u0017H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/oracle/debugger/OraStack$UnknownFrame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack$Frame;", "Lcom/intellij/database/dialects/oracle/debugger/OraStack;", "level", "", "position", "Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "<init>", "(Lcom/intellij/database/dialects/oracle/debugger/OraStack;ILcom/intellij/database/dialects/oracle/debugger/OraPosition;)V", "getPosition", "()Lcom/intellij/database/dialects/oracle/debugger/OraPosition;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "customizePresentation", "", "component", "Lcom/intellij/ui/ColoredTextContainer;", "computeChildren", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "findVariables", "", "Lcom/intellij/database/debugger/SqlVariable;", "Lcom/intellij/database/debugger/SqlVariables;", "intellij.database.dialects.oracle.ex"})
    public final class UnknownFrame
    extends Frame {
        @NotNull
        private final OraPosition position;

        public UnknownFrame(@NotNull int level, OraPosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super(level);
            this.position = position;
        }

        @Override
        @NotNull
        public OraPosition getPosition() {
            return this.position;
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            return null;
        }

        public void customizePresentation(@NotNull ColoredTextContainer component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIcon(AllIcons.General.Error);
            component.append("(", SimpleTextAttributes.ERROR_ATTRIBUTES);
            component.append(this.getPosition().toString(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(")", SimpleTextAttributes.ERROR_ATTRIBUTES);
        }

        @Override
        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            node.addChildren(XValueChildrenList.EMPTY, true);
        }

        @Override
        @Nullable
        protected List<SqlVariable> findVariables() {
            return null;
        }
    }
}

