/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.codeInsight.completion.PyRuntimeCompletionRetrievalService;
import com.jetbrains.python.codeInsight.completion.PyRuntimeCompletionRetrievalServiceKt;
import com.jetbrains.python.codeInsight.completion.PyRuntimeCompletionUtilsKt;
import com.jetbrains.python.codeInsight.completion.RemoteFilePathRetrievalService;
import com.jetbrains.python.codeInsight.completion.RuntimeLookupElement;
import com.jetbrains.python.debugger.state.PyRuntime;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH&J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH&\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/python/codeInsight/completion/AbstractRuntimeCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillCompletionVariantsFromRuntime", "project", "Lcom/intellij/openapi/project/Project;", "service", "Lcom/jetbrains/python/codeInsight/completion/PyRuntimeCompletionRetrievalService;", "getRuntimeEnvService", "Lcom/jetbrains/python/debugger/state/PyRuntime;", "getCompletionRetrievalService", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyRuntimeCompletionRetrievalService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyRuntimeCompletionRetrievalService.kt\ncom/jetbrains/python/codeInsight/completion/AbstractRuntimeCompletionContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,271:1\n1252#2,4:272\n1869#2,2:278\n30#3,2:276\n*S KotlinDebug\n*F\n+ 1 PyRuntimeCompletionRetrievalService.kt\ncom/jetbrains/python/codeInsight/completion/AbstractRuntimeCompletionContributor\n*L\n201#1:272,4\n228#1:278,2\n205#1:276,2\n*E\n"})
public abstract class AbstractRuntimeCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Project project = parameters.getEditor().getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (parameters.getCompletionType() == CompletionType.CLASS_NAME) {
            return;
        }
        ProcessingContext context = new ProcessingContext();
        if (!PlatformPatterns.psiElement().accepts((Object)parameters.getPosition(), context)) {
            return;
        }
        ProgressManager.checkCanceled();
        PyRuntimeCompletionRetrievalService service = this.getCompletionRetrievalService(project2);
        if (!service.canComplete(parameters)) {
            return;
        }
        this.fillCompletionVariantsFromRuntime(project2, service, parameters, result2);
    }

    /*
     * WARNING - void declaration
     */
    private final void fillCompletionVariantsFromRuntime(Project project, PyRuntimeCompletionRetrievalService service, CompletionParameters parameters, CompletionResultSet result2) {
        void destination$iv;
        void $this$associateByTo$iv;
        Iterable iterable = PyRuntimeCompletionRetrievalServiceKt.createCompletionResultSet(service, this.getRuntimeEnvService(project), parameters);
        Map map2 = new HashMap();
        boolean $i$f$associateByTo = false;
        for (Object element$iv : $this$associateByTo$iv) {
            LookupElement lookupElement = (LookupElement)element$iv;
            void var13_16 = destination$iv;
            boolean bl = false;
            LookupElement it = (LookupElement)element$iv;
            String string = it.getLookupString();
            boolean bl2 = false;
            RuntimeLookupElement runtimeLookupElement = new RuntimeLookupElement(it, PyRuntimeCompletionUtilsKt.createCustomMatcher(parameters, result2));
            var13_16.put(string, runtimeLookupElement);
        }
        void runtimeResults = destination$iv;
        if (runtimeResults.isEmpty()) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RemoteFilePathRetrievalService> serviceClass$iv = RemoteFilePathRetrievalService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            Map<String, RuntimeLookupElement> remoteFileResults = ((RemoteFilePathRetrievalService)object).retrieveRemoteFileLookupElements(parameters);
            runtimeResults.putAll(remoteFileResults);
        }
        if (runtimeResults.isEmpty()) {
            return;
        }
        if (!result2.isStopped()) {
            result2.runRemainingContributors(parameters, arg_0 -> AbstractRuntimeCompletionContributor.fillCompletionVariantsFromRuntime$lambda$3(arg_0 -> AbstractRuntimeCompletionContributor.fillCompletionVariantsFromRuntime$lambda$2((Map)runtimeResults, result2, arg_0), arg_0));
        }
        Iterable $this$forEach$iv = runtimeResults.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RuntimeLookupElement it = (RuntimeLookupElement)element$iv;
            boolean bl = false;
            result2.withPrefixMatcher(it.getPrefix()).addElement(it.getLookupElement());
        }
    }

    @NotNull
    public abstract PyRuntime getRuntimeEnvService(@NotNull Project var1);

    @NotNull
    public abstract PyRuntimeCompletionRetrievalService getCompletionRetrievalService(@NotNull Project var1);

    private static final Unit fillCompletionVariantsFromRuntime$lambda$2(Map $runtimeResults, CompletionResultSet $result, CompletionResult item) {
        if ($runtimeResults.remove(item.getLookupElement().getLookupString()) != null) {
            LookupElement lookupElement = item.getLookupElement();
            Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"getLookupElement(...)");
            CompletionResult completionResult = item.withLookupElement(PyRuntimeCompletionUtilsKt.createPrioritizedLookupElement(lookupElement, true));
            Intrinsics.checkNotNullExpressionValue((Object)completionResult, (String)"withLookupElement(...)");
            CompletionResult prioritizedCompletionResult = completionResult;
            $result.withPrefixMatcher(item.getPrefixMatcher()).passResult(prioritizedCompletionResult);
        } else {
            $result.passResult(item);
        }
        return Unit.INSTANCE;
    }

    private static final void fillCompletionVariantsFromRuntime$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

