/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.model.ObjectName;
import com.intellij.database.util.SmartPredicate;
import com.intellij.database.util.TreePatternNode;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreePatternSubdivision {
    @NotNull
    public static Subdivision<Pair<Integer, TreePatternNode>> generateSubdivision(@NotNull Iterable<TreePatternNode.Group> groups) {
        if (groups == null) {
            TreePatternSubdivision.$$$reportNull$$$0(0);
        }
        Subdivision<Pair<Integer, TreePatternNode>> subdivision = new Subdivision<Pair<Integer, TreePatternNode>>();
        int n = 0;
        for (TreePatternNode.Group group : groups) {
            TreePatternSubdivision.subdivide(subdivision, group, n++);
        }
        Subdivision<Pair<Integer, TreePatternNode>> subdivision2 = subdivision;
        if (subdivision2 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(1);
        }
        return subdivision2;
    }

    private static void subdivide(@NotNull Subdivision<Pair<Integer, TreePatternNode>> subdivision, @Nullable TreePatternNode.Group group, int tag) {
        if (subdivision == null) {
            TreePatternSubdivision.$$$reportNull$$$0(2);
        }
        if (group != null && group.children != null) {
            for (TreePatternNode child : group.children) {
                TreePatternSubdivision.subdivide(subdivision, child, tag);
            }
        } else {
            subdivision.newLayer((Pair<Integer, TreePatternNode>)Pair.create((Object)tag, null));
            subdivision.completeLayer();
        }
    }

    private static void subdivide(@NotNull Subdivision<Pair<Integer, TreePatternNode>> subdivision, @NotNull TreePatternNode node, int tag) {
        if (subdivision == null) {
            TreePatternSubdivision.$$$reportNull$$$0(3);
        }
        if (node == null) {
            TreePatternSubdivision.$$$reportNull$$$0(4);
        }
        subdivision.newLayer((Pair<Integer, TreePatternNode>)Pair.create((Object)tag, (Object)node));
        subdivision.subdivide(node.naming);
        subdivision.completeLayer();
    }

    private static SData subdivide(@NotNull TreePatternNode.BaseNaming n1, @NotNull TreePatternNode.BaseNaming n2) {
        if (n1 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(5);
        }
        if (n2 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(6);
        }
        if (n1.equals(n2)) {
            return new SData(null, null, n1, null, null);
        }
        if (n1 instanceof TreePatternNode.PositiveNaming) {
            if (n2 instanceof TreePatternNode.PositiveNaming) {
                return TreePatternSubdivision.subdivideImpl((TreePatternNode.PositiveNaming)n1, (TreePatternNode.PositiveNaming)n2);
            }
            if (n2 instanceof TreePatternNode.NegativeNaming) {
                return TreePatternSubdivision.subdivideImpl((TreePatternNode.PositiveNaming)n1, (TreePatternNode.NegativeNaming)n2, false);
            }
        }
        if (n1 instanceof TreePatternNode.NegativeNaming) {
            if (n2 instanceof TreePatternNode.PositiveNaming) {
                return TreePatternSubdivision.subdivideImpl((TreePatternNode.PositiveNaming)n2, (TreePatternNode.NegativeNaming)n1, true);
            }
            if (n2 instanceof TreePatternNode.NegativeNaming) {
                return TreePatternSubdivision.subdivideImpl((TreePatternNode.NegativeNaming)n1, (TreePatternNode.NegativeNaming)n2);
            }
        }
        return null;
    }

    @Nullable
    private static SData subdivideImpl(@NotNull TreePatternNode.PositiveNaming n1, @NotNull TreePatternNode.PositiveNaming n2) {
        if (n1 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(7);
        }
        if (n2 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(8);
        }
        LinkedHashSet names1 = ContainerUtil.newLinkedHashSet((Object[])n1.names);
        LinkedHashSet names2 = ContainerUtil.newLinkedHashSet((Object[])n2.names);
        LinkedHashSet<ObjectName> namesIntersection = new LinkedHashSet<ObjectName>(names1);
        namesIntersection.retainAll(names2);
        if (namesIntersection.isEmpty()) {
            return null;
        }
        TreePatternNode.PositiveNaming intersection = TreePatternSubdivision.createPositiveNaming(SmartPredicate.all(), namesIntersection);
        if (intersection == null) {
            return null;
        }
        TreePatternNode.BaseNaming rest1x = null;
        names1.removeAll(namesIntersection);
        TreePatternNode.PositiveNaming rest1 = TreePatternSubdivision.createPositiveNaming(SmartPredicate.all(), names1);
        TreePatternNode.BaseNaming rest2x = null;
        names2.removeAll(namesIntersection);
        TreePatternNode.PositiveNaming rest2 = TreePatternSubdivision.createPositiveNaming(SmartPredicate.all(), names2);
        return new SData(rest1, rest1x, intersection, rest2, rest2x);
    }

    @Nullable
    private static TreePatternNode.PositiveNaming createPositiveNaming(@NotNull SmartPredicate<TreePatternNode.PatternWrapper> pattern, @NotNull Collection<ObjectName> names) {
        if (pattern == null) {
            TreePatternSubdivision.$$$reportNull$$$0(9);
        }
        if (names == null) {
            TreePatternSubdivision.$$$reportNull$$$0(10);
        }
        if (pattern.isNone()) {
            return null;
        }
        List filtered = pattern.isAll() || names.isEmpty() ? names : ContainerUtil.filter(names, n -> TreePatternNode.PatternWrapper.evaluate(pattern, n));
        return filtered.isEmpty() ? null : new TreePatternNode.PositiveNaming(ObjectName.toArray(filtered));
    }

    @Nullable
    private static TreePatternNode.NegativeNaming createNegativeNaming(@NotNull SmartPredicate<TreePatternNode.PatternWrapper> pattern, @NotNull Collection<ObjectName> names) {
        if (pattern == null) {
            TreePatternSubdivision.$$$reportNull$$$0(11);
        }
        if (names == null) {
            TreePatternSubdivision.$$$reportNull$$$0(12);
        }
        if (pattern.isNone()) {
            return null;
        }
        List filtered = pattern.isAll() || names.isEmpty() ? names : ContainerUtil.filter(names, n -> !TreePatternNode.PatternWrapper.evaluate(pattern, n));
        return new TreePatternNode.NegativeNaming(pattern, ObjectName.toArray(filtered));
    }

    @Nullable
    private static SData subdivideImpl(@NotNull TreePatternNode.NegativeNaming n1, @NotNull TreePatternNode.NegativeNaming n2) {
        if (n1 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(13);
        }
        if (n2 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(14);
        }
        LinkedHashSet names1 = ContainerUtil.newLinkedHashSet((Object[])n1.names);
        LinkedHashSet names2 = ContainerUtil.newLinkedHashSet((Object[])n2.names);
        LinkedHashSet<ObjectName> namesIntersection = new LinkedHashSet<ObjectName>(names1);
        namesIntersection.addAll(names2);
        SmartPredicate<TreePatternNode.PatternWrapper> patternIntersection = n1.pattern.intersect(n2.pattern);
        TreePatternNode.NegativeNaming intersection = TreePatternSubdivision.createNegativeNaming(patternIntersection, namesIntersection);
        if (intersection == null) {
            return null;
        }
        TreePatternNode.NegativeNaming rest1x = TreePatternSubdivision.createNegativeNaming(n1.pattern.minus(n2.pattern), names1);
        namesIntersection.removeAll(names1);
        TreePatternNode.PositiveNaming rest1 = TreePatternSubdivision.createPositiveNaming(n1.pattern, namesIntersection);
        TreePatternNode.NegativeNaming rest2x = TreePatternSubdivision.createNegativeNaming(n2.pattern.minus(n1.pattern), names2);
        names1.removeAll(names2);
        TreePatternNode.PositiveNaming rest2 = TreePatternSubdivision.createPositiveNaming(n2.pattern, names1);
        return new SData(rest1, rest1x, intersection, rest2, rest2x);
    }

    @Nullable
    private static SData subdivideImpl(@NotNull TreePatternNode.PositiveNaming n1, @NotNull TreePatternNode.NegativeNaming n2, boolean rev) {
        if (n1 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(15);
        }
        if (n2 == null) {
            TreePatternSubdivision.$$$reportNull$$$0(16);
        }
        LinkedHashSet names1 = ContainerUtil.newLinkedHashSet((Object[])n1.names);
        LinkedHashSet<ObjectName> names2 = ContainerUtil.newLinkedHashSet((Object[])n2.names);
        LinkedHashSet<ObjectName> namesIntersection = new LinkedHashSet<ObjectName>(names1);
        namesIntersection.removeAll(names2);
        TreePatternNode.PositiveNaming intersection = TreePatternSubdivision.createPositiveNaming(n2.pattern, namesIntersection);
        if (intersection == null) {
            return null;
        }
        TreePatternNode.PositiveNaming rest1x = TreePatternSubdivision.createPositiveNaming(n2.pattern.negate(), names1);
        names1.retainAll(names2);
        TreePatternNode.PositiveNaming rest1 = TreePatternSubdivision.createPositiveNaming(SmartPredicate.all(), names1);
        TreePatternNode.BaseNaming rest2x = null;
        if (rev) {
            names2.addAll(namesIntersection);
        } else {
            namesIntersection.addAll((Collection<ObjectName>)names2);
        }
        TreePatternNode.NegativeNaming rest2 = TreePatternSubdivision.createNegativeNaming(n2.pattern, rev ? names2 : namesIntersection);
        return new SData(rest1, rest1x, intersection, rest2, rest2x, rev);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/TreePatternSubdivision";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdivision";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n1";
                break;
            }
            case 6: 
            case 8: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "n2";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/TreePatternSubdivision";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSubdivision";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSubdivision";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "subdivide";
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "subdivideImpl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPositiveNaming";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createNegativeNaming";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class Subdivision<T> {
        public final List<Pair<TreePatternNode.BaseNaming, IntList>> data = new SmartList((Object)Pair.create((Object)TreePatternNode.NegativeNaming.WILDCARD, (Object)new IntArrayList()));
        public final List<T> layers = new ArrayList<T>();

        public void newLayer(T key2) {
            this.layers.add(key2);
        }

        public T getLayer(int id) {
            return id == 0 ? null : (T)this.layers.get(Math.abs(id) - 1);
        }

        public boolean isCovered(int id) {
            return id > 0;
        }

        private int getLayerId() {
            return this.layers.size();
        }

        public void subdivide(@NotNull TreePatternNode.BaseNaming naming) {
            if (naming == null) {
                Subdivision.$$$reportNull$$$0(0);
            }
            int layerId = this.getLayerId();
            for (int i2 = 0; i2 < this.data.size(); ++i2) {
                Pair<TreePatternNode.BaseNaming, IntList> part = this.data.get(i2);
                SData d = TreePatternSubdivision.subdivide((TreePatternNode.BaseNaming)part.first, naming);
                if (d == null) continue;
                IntList keys = (IntList)part.second;
                if (d.rest1 != null) {
                    IntArrayList bothKeys = new IntArrayList(keys);
                    bothKeys.add(layerId);
                    this.data.set(i2, (Pair<TreePatternNode.BaseNaming, IntList>)Pair.create((Object)d.intersection, (Object)bothKeys));
                    this.data.add(++i2, (Pair<TreePatternNode.BaseNaming, IntList>)Pair.create((Object)d.rest1, (Object)keys));
                    if (d.rest1x == null) continue;
                    this.data.add(++i2, (Pair<TreePatternNode.BaseNaming, IntList>)Pair.create((Object)d.rest1x, (Object)keys));
                    continue;
                }
                assert (d.intersection.equals(part.first));
                keys.add(layerId);
            }
        }

        public void completeLayer() {
            int layerId = this.getLayerId();
            for (Pair<TreePatternNode.BaseNaming, IntList> pair : this.data) {
                IntList keys = (IntList)pair.second;
                int size = keys.size();
                if (size != 0 && keys.getInt(size - 1) == layerId) continue;
                keys.add(-layerId);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "naming", "com/intellij/database/util/TreePatternSubdivision$Subdivision", "subdivide"));
        }
    }

    private static class SData {
        private final TreePatternNode.BaseNaming rest1;
        private final TreePatternNode.BaseNaming rest1x;
        private final TreePatternNode.BaseNaming intersection;
        private final TreePatternNode.BaseNaming rest2;
        private final TreePatternNode.BaseNaming rest2x;

        private SData(@Nullable TreePatternNode.BaseNaming rest1, @Nullable TreePatternNode.BaseNaming rest1x, @NotNull TreePatternNode.BaseNaming intersection, @Nullable TreePatternNode.BaseNaming rest2, @Nullable TreePatternNode.BaseNaming rest2x, boolean rev) {
            if (intersection == null) {
                SData.$$$reportNull$$$0(0);
            }
            this(rev ? rest2 : rest1, rev ? rest2x : rest1x, intersection, rev ? rest1 : rest2, rev ? rest1x : rest2x);
        }

        private SData(@Nullable TreePatternNode.BaseNaming rest1, @Nullable TreePatternNode.BaseNaming rest1x, @NotNull TreePatternNode.BaseNaming intersection, @Nullable TreePatternNode.BaseNaming rest2, @Nullable TreePatternNode.BaseNaming rest2x) {
            if (intersection == null) {
                SData.$$$reportNull$$$0(1);
            }
            this.rest1 = rest1 == null ? rest1x : rest1;
            this.rest1x = rest1 == null ? null : rest1x;
            this.intersection = intersection;
            this.rest2 = rest2;
            this.rest2x = rest2x;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intersection", "com/intellij/database/util/TreePatternSubdivision$SData", "<init>"));
        }
    }
}

