/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.JdbcColumnDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.CsvImportUtil;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.model.DataType;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.TypeNameColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportUtilCore {
    protected ImportUtilCore() {
    }

    @NotNull
    public static String pluralize(@NotNull String word, long count) {
        if (word == null) {
            ImportUtilCore.$$$reportNull$$$0(0);
        }
        String string = count == 1L ? word : StringUtil.pluralize((String)word);
        if (string == null) {
            ImportUtilCore.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull JdbcColumnDescriptor delegate, boolean autogenerated, boolean hasDefault, boolean computed) {
        if (delegate == null) {
            ImportUtilCore.$$$reportNull$$$0(2);
        }
        return new AutoValueDescriptor.DelegateDescriptor(delegate, autogenerated, hasDefault, computed);
    }

    @NotNull
    public static String pluralizeRows(long count) {
        return ImportUtilCore.pluralize("row", count);
    }

    @Nullable
    public static Domain getConsumerDomain(@NotNull Dbms producerDbms, @NotNull Dbms consumerDbms, @Nullable Version consumerVersion, @Nullable Domain producerDomain) {
        if (producerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(3);
        }
        if (consumerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(4);
        }
        return producerDomain == null ? null : (consumerDbms != Dbms.UNKNOWN && producerDbms == consumerDbms && (consumerVersion == null || producerDomain.supportedIn(consumerVersion)) ? producerDomain : BaseDomainRegistry.getMostRecentDomain(producerDomain, consumerDbms, consumerVersion));
    }

    @NlsSafe
    @NotNull
    public static String getSqlTypeName(@Nullable Domain domain, @NotNull ColumnDescriptor column2, @Nullable List<? extends GridRow> rows, @NotNull Dbms producerDbms, @NotNull Dbms consumerDbms, @Nullable Version consumerVersion) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(5);
        }
        if (producerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(6);
        }
        if (consumerDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(7);
        }
        String typeName = column2.getTypeName();
        return domain != null ? domain.name() : (producerDbms == consumerDbms && typeName != null ? ExecutionEnvironmentHelper.EP.forDbms(producerDbms).jdbcTypeNameToSqlTypeName(typeName) : ImportUtilCore.getPreferredTypeBasedOnContent(column2, rows, consumerDbms, consumerVersion));
    }

    @NlsSafe
    @NotNull
    public static String getPreferredTypeBasedOnContent(@NotNull ColumnDescriptor column2, @Nullable List<? extends GridRow> rows, @NotNull Dbms dbms, @Nullable Version version) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            ImportUtilCore.$$$reportNull$$$0(9);
        }
        ImportManager manager = ImportManager.of(dbms, version);
        if (rows == null || !(column2 instanceof GridColumn)) {
            String string = manager.getStringMerger().getName();
            if (string == null) {
                ImportUtilCore.$$$reportNull$$$0(10);
            }
            return string;
        }
        GridColumn gc = (GridColumn)column2;
        JBIterable values = JBIterable.from(rows).map(row -> gc.getValue(row)).map(o -> o == null ? null : o.toString());
        String string = CsvImportUtil.getPreferredTypeMergerBasedOnContent((Iterable)values, (TypeMerger)manager.getStringMerger(), (TypeMerger[])manager.getMergers()).getName();
        if (string == null) {
            ImportUtilCore.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static DasType convertTypeName(@NotNull Dbms fromDbms, @NotNull Version fromVersion, @NotNull Dbms toDbms, @NotNull Version toVersion, @NotNull DasType colType) {
        if (fromDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(12);
        }
        if (fromVersion == null) {
            ImportUtilCore.$$$reportNull$$$0(13);
        }
        if (toDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(14);
        }
        if (toVersion == null) {
            ImportUtilCore.$$$reportNull$$$0(15);
        }
        if (colType == null) {
            ImportUtilCore.$$$reportNull$$$0(16);
        }
        TypeNameColumnDescriptor descriptor = ImportUtilCore.asDescriptor("", colType);
        String name2 = ImportUtilCore.convertTypeName(fromDbms, fromVersion, toDbms, toVersion, descriptor);
        DasType dasType = DasUnresolvedTypeReference.of(name2);
        if (dasType == null) {
            ImportUtilCore.$$$reportNull$$$0(17);
        }
        return dasType;
    }

    public static String convertTypeName(@NotNull Dbms fromDbms, @NotNull Version fromVersion, @NotNull Dbms toDbms, @NotNull Version version, @NotNull ColumnDescriptor descriptor) {
        if (fromDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(18);
        }
        if (fromVersion == null) {
            ImportUtilCore.$$$reportNull$$$0(19);
        }
        if (toDbms == null) {
            ImportUtilCore.$$$reportNull$$$0(20);
        }
        if (version == null) {
            ImportUtilCore.$$$reportNull$$$0(21);
        }
        if (descriptor == null) {
            ImportUtilCore.$$$reportNull$$$0(22);
        }
        Domain domain = BaseDomainRegistry.getDomain(fromDbms, fromVersion, descriptor, false);
        Domain d2 = ImportUtilCore.getConsumerDomain(fromDbms, toDbms, version, domain);
        if (domain != null && Objects.equals(domain, d2)) {
            return domain.name();
        }
        return ImportUtilCore.getSqlTypeName(d2, descriptor, null, fromDbms, toDbms, version);
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull BasicLikeColumn column2) {
        if (column2 == null) {
            ImportUtilCore.$$$reportNull$$$0(23);
        }
        DasType dasType = column2.getDasType();
        DataType dataType = dasType.toDataType();
        DataConsumer.Column desc = new DataConsumer.Column((int)column2.getPosition(), column2.getName(), JdbcUtil.guessJdbcTypeByName(DasTypeUtilsKt.getTypeName(dasType)), DasTypeUtilsKt.getTypeName(dasType), null, dataType.getPrecision(), dataType.getScale(), null, DasTypeUtilsKt.getSchemaName(dasType), null);
        if (column2 instanceof BasicTableColumn) {
            BasicTableColumn tc = (BasicTableColumn)column2;
            return new AutoValueDescriptor.DelegateDescriptor((JdbcColumnDescriptor)desc, tc.isAutoInc(), column2.getDefault() != null, tc.isComputed());
        }
        return new AutoValueDescriptor.DelegateDescriptor((JdbcColumnDescriptor)desc, false, column2.getDefault() != null, false);
    }

    @NotNull
    public static TypeNameColumnDescriptor asDescriptor(String name2, DasType dasType) {
        DataType type = dasType.toDataType();
        return new TypeNameColumnDescriptor(name2, DasTypeUtilsKt.getTypeName(dasType), type.getPrecision(), type.getScale());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 10, 11, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportUtilCore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producerDbms";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumerDbms";
                break;
            }
            case 5: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromDbms";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromVersion";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDbms";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toVersion";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportUtilCore";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 1: 
            case 10: 
            case 11: 
            case 17: {
                break;
            }
            case 2: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConsumerDomain";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSqlTypeName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "convertTypeName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 10, 11, 17 -> new IllegalStateException(string);
        };
    }
}

