/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt;

import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntAliasTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntService;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.CommandLineUtil;
import com.intellij.webcore.util.JsonUtil;
import icons.JavaScriptLanguageIcons;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GruntTaskStructureUtil {
    private static final Logger LOG = Logger.getInstance(GruntTaskStructureUtil.class);
    private static final String GRUNT_TASK_STRUCTURE_FETCHER_TASK_NAME = "_intellij_grunt_tasks_fetcher";
    private static final String NAME_PROP = "name";
    private static final String INFO_PROP = "info";
    private static final String FILE_PATH_PROP = "filePath";
    private static final String MULTI_PROP = "multi";
    private static final String DEPENDENCIES_PROP = "dependencies";
    private static final String TARGETS_PROP = "targets";

    private GruntTaskStructureUtil() {
    }

    @NotNull
    public static GruntfileStructure fetchStructure(@NotNull Project project, @Nullable NodeJsInterpreter interpreter2, @NotNull String nodeOptions, @NotNull NodePackage gruntCliPackage, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData) throws JsbtTaskFetchException {
        GruntfileStructure gruntfileStructure;
        List<JsbtInvalidSetting> invalidSettings;
        if (project == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(0);
        }
        if (nodeOptions == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(1);
        }
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(2);
        }
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(3);
        }
        if (envData == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(4);
        }
        if (!(invalidSettings = GruntTaskStructureUtil.checkSettings(interpreter2, gruntCliPackage)).isEmpty() || interpreter2 == null) {
            throw JsbtTaskFetchException.newInvalidSettings(gruntfile, invalidSettings);
        }
        try {
            gruntfileStructure = GruntTaskStructureUtil.doFetchStructure(project, interpreter2, nodeOptions, gruntCliPackage, gruntfile, envData, false);
        }
        catch (JsbtTaskFetchException e) {
            LOG.info("Failed to fetch tasks: " + e.getDescription() + ". Re-fetching in verbose mode to present a detailed error");
            GruntfileStructure gruntfileStructure2 = GruntTaskStructureUtil.doFetchStructure(project, interpreter2, nodeOptions, gruntCliPackage, gruntfile, envData, true);
            if (gruntfileStructure2 == null) {
                GruntTaskStructureUtil.$$$reportNull$$$0(6);
            }
            return gruntfileStructure2;
        }
        if (gruntfileStructure == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(5);
        }
        return gruntfileStructure;
    }

    private static GruntfileStructure doFetchStructure(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull String nodeOptions, @NotNull NodePackage gruntCliPackage, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData, boolean verboseMode) throws JsbtTaskFetchException {
        CapturingProcessHandler processHandler;
        GeneralCommandLine commandLine;
        if (project == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(7);
        }
        if (interpreter2 == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(8);
        }
        if (nodeOptions == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(9);
        }
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(10);
        }
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(11);
        }
        if (envData == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(12);
        }
        try {
            commandLine = GruntTaskStructureUtil.createCommandLine(project, interpreter2, nodeOptions, gruntCliPackage, gruntfile, envData, verboseMode);
        }
        catch (ExecutionException e) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "Failed to construct command line: " + e.getMessage(), null, e, null, null);
        }
        LOG.info("Fetching grunt tasks: " + commandLine.getCommandLineString());
        long startTimeMillis = System.currentTimeMillis();
        try {
            processHandler = new CapturingProcessHandler(commandLine);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot fetch grunt tasks: cannot run " + commandLine.getCommandLineString(), (Throwable)e);
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "cannot execute command", commandLine, e, null, null);
        }
        ProcessOutput processOutput = processHandler.runProcess();
        if (processOutput.getExitCode() != 0) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "process finished with exit code " + processOutput.getExitCode() + " (a non-zero exit code means an error)", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        GruntfileStructure structure = GruntTaskStructureUtil.parseStructure(gruntfile, processOutput.getStdout());
        if (structure == null) {
            throw GruntTaskStructureUtil.newFetchFail(gruntfile, "failed to parse tasks from json", commandLine, null, (ProcessHandler)processHandler, processOutput);
        }
        LOG.info(String.format("%s: %d alias tasks and %d core tasks listed in %d ms", gruntfile.getPath(), structure.getAliasTasks().size(), structure.getCoreTasks().size(), System.currentTimeMillis() - startTimeMillis));
        return structure;
    }

    @NotNull
    private static List<JsbtInvalidSetting> checkSettings(@Nullable NodeJsInterpreter interpreter2, @NotNull NodePackage gruntCliPackage) {
        JsbtInvalidSetting gruntCliPackageError;
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(13);
        }
        ArrayList<JsbtInvalidSetting> errorInfos = new ArrayList<JsbtInvalidSetting>(2);
        String interpreterErrorMessage = NodeInterpreterUtil.validateAndGetErrorMessage(interpreter2);
        if (interpreterErrorMessage != null) {
            errorInfos.add(new JsbtInvalidSetting("Node interpreter", null, interpreterErrorMessage));
        }
        if ((gruntCliPackageError = JsbtUtil.validatePackageDir(gruntCliPackage, "Grunt-cli package", "grunt-cli")) != null) {
            errorInfos.add(gruntCliPackageError);
        }
        ArrayList<JsbtInvalidSetting> arrayList = errorInfos;
        if (arrayList == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static JsbtTaskFetchException newFetchFail(@NotNull VirtualFile gruntfile, @NotNull String message, @Nullable GeneralCommandLine commandLine, @Nullable ExecutionException executionException, @Nullable ProcessHandler processHandler, @Nullable ProcessOutput processOutput) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(15);
        }
        if (message == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(16);
        }
        JsbtTaskFetchException jsbtTaskFetchException = JsbtTaskFetchException.newFetchFail(gruntfile, GruntService.GruntApplicationService.getInstance(), "grunt", JavaScriptLanguageIcons.BuildTools.Grunt.Grunt, message, commandLine, "grunt <list tasks>", executionException, processHandler, processOutput);
        if (jsbtTaskFetchException == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(17);
        }
        return jsbtTaskFetchException;
    }

    @Nullable
    private static GruntfileStructure parseStructure(@NotNull VirtualFile gruntfile, @NotNull String stdout) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(18);
        }
        if (stdout == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(19);
        }
        Iterable lines = Splitter.on((char)'\n').trimResults().omitEmptyStrings().split((CharSequence)stdout);
        for (String line : lines) {
            if ((line.startsWith("Reading ") || line.startsWith("Loading ")) && line.endsWith("ERROR")) {
                return null;
            }
            GruntfileStructure structure = GruntTaskStructureUtil.parseStructureFromLine(gruntfile, line);
            if (structure == null) continue;
            return structure;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static GruntfileStructure parseStructureFromLine(@NotNull VirtualFile gruntfile, @NotNull String line) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(20);
        }
        if (line == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(21);
        }
        if (!line.startsWith("{")) {
            return null;
        }
        JsonReader jsonReader = null;
        try {
            jsonReader = new JsonReader((Reader)new StringReader(line));
            jsonReader.setLenient(false);
            JsonElement rootElement = JsonParser.parseReader((JsonReader)jsonReader);
            if (rootElement.isJsonObject()) {
                GruntfileStructure gruntfileStructure = GruntTaskStructureUtil.parseStructureFromElement(gruntfile, rootElement.getAsJsonObject());
                return gruntfileStructure;
            }
            GruntfileStructure gruntfileStructure = null;
            return gruntfileStructure;
        }
        catch (Exception e) {
            GruntfileStructure gruntfileStructure = null;
            return gruntfileStructure;
        }
        finally {
            if (jsonReader != null) {
                try {
                    jsonReader.close();
                }
                catch (IOException e) {
                    LOG.warn("Can't close jsonReader", (Throwable)e);
                }
            }
        }
    }

    private static GruntfileStructure parseStructureFromElement(@NotNull VirtualFile gruntfile, @NotNull JsonObject rootObject) {
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(22);
        }
        if (rootObject == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(23);
        }
        JsonArray aliasTaskArray = JsonUtil.getChildAsArray((JsonObject)rootObject, (String)"aliasTasks");
        JsonArray coreTaskArray = JsonUtil.getChildAsArray((JsonObject)rootObject, (String)"coreTasks");
        if (aliasTaskArray == null || coreTaskArray == null) {
            return null;
        }
        GruntfileStructure structure = new GruntfileStructure(gruntfile);
        ArrayList<GruntAliasTask> aliasTasks = new ArrayList<GruntAliasTask>();
        for (JsonElement aliasElement : aliasTaskArray) {
            JsonObject aliasObject;
            String name;
            if (!aliasElement.isJsonObject() || (name = JsonUtil.getChildAsString((JsonObject)(aliasObject = aliasElement.getAsJsonObject()), (String)NAME_PROP)) == null) continue;
            aliasTasks.add(new GruntAliasTask(structure, name, JsonUtil.getChildAsString((JsonObject)aliasObject, (String)INFO_PROP), JsonUtil.getChildAsString((JsonObject)aliasObject, (String)FILE_PATH_PROP), JsonUtil.getChildAsBoolean((JsonObject)aliasObject, (String)MULTI_PROP, (boolean)false), ContainerUtil.notNullize((List)JsonUtil.getChildAsStringList((JsonObject)aliasObject, (String)DEPENDENCIES_PROP))));
        }
        ArrayList<GruntCoreTask> coreTasks = new ArrayList<GruntCoreTask>();
        for (JsonElement coreTaskElement : coreTaskArray) {
            JsonObject coreTaskObject;
            String name;
            if (!coreTaskElement.isJsonObject() || (name = JsonUtil.getChildAsString((JsonObject)(coreTaskObject = coreTaskElement.getAsJsonObject()), (String)NAME_PROP)) == null) continue;
            coreTasks.add(new GruntCoreTask(structure, name, JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)INFO_PROP), JsonUtil.getChildAsString((JsonObject)coreTaskObject, (String)FILE_PATH_PROP), JsonUtil.getChildAsBoolean((JsonObject)coreTaskObject, (String)MULTI_PROP, (boolean)false), ContainerUtil.notNullize((List)JsonUtil.getChildAsStringList((JsonObject)coreTaskObject, (String)TARGETS_PROP))));
        }
        structure.setTasks(aliasTasks, coreTasks);
        return structure;
    }

    @NotNull
    public static Path getTasksDir() throws ExecutionException {
        Path path2 = HelperFilesLocator.resolvePathOrThrowExecutionExecution("buildTools/grunt/tasks");
        if (path2 == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(24);
        }
        return path2;
    }

    @NotNull
    private static GeneralCommandLine createCommandLine(@NotNull Project project, @NotNull NodeJsInterpreter interpreter2, @NotNull String nodeOptions, @NotNull NodePackage gruntCliPackage, @NotNull VirtualFile gruntfile, @NotNull EnvironmentVariablesData envData, boolean verboseMode) throws ExecutionException {
        if (project == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(25);
        }
        if (interpreter2 == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(26);
        }
        if (nodeOptions == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(27);
        }
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(28);
        }
        if (gruntfile == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(29);
        }
        if (envData == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(30);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        envData.configureCommandLine(commandLine, true);
        File gruntfileDir = VfsUtilCore.virtualToIoFile((VirtualFile)gruntfile).getParentFile();
        CommandLineUtil.setWorkingDirectory((GeneralCommandLine)commandLine, (File)gruntfileDir, (boolean)true);
        nodeOptions = nodeOptions.trim();
        commandLine.addParameters(ParametersList.parse((String)nodeOptions));
        if (gruntCliPackage instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)gruntCliPackage).addYarnRunToCommandLine(commandLine, project, interpreter2, null);
        } else {
            commandLine.addParameter(GruntTaskStructureUtil.getGruntCliMainFilePath(gruntCliPackage));
        }
        commandLine.addParameter("--no-color");
        if (verboseMode) {
            commandLine.addParameter("--verbose");
        }
        commandLine.addParameter("--gruntfile");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)gruntfile.getPath()));
        commandLine.addParameter("--tasks");
        Path tasksDir = GruntTaskStructureUtil.getTasksDir();
        commandLine.addParameter(tasksDir.toString());
        commandLine.addParameter(GRUNT_TASK_STRUCTURE_FETCHER_TASK_NAME);
        NodeCommandLineConfigurator.find(interpreter2).configure(commandLine);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(31);
        }
        return generalCommandLine;
    }

    @NotNull
    public static String getGruntCliMainFilePath(@NotNull NodePackage gruntCliPackage) {
        if (gruntCliPackage == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(32);
        }
        File gruntBinFile = new File(gruntCliPackage.getSystemDependentPath(), "bin" + File.separator + "grunt");
        String string = gruntBinFile.getAbsolutePath();
        if (string == null) {
            GruntTaskStructureUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 14, 17, 24, 31, 33 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeOptions";
                break;
            }
            case 2: 
            case 10: 
            case 13: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntCliPackage";
                break;
            }
            case 3: 
            case 11: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gruntfile";
                break;
            }
            case 4: 
            case 12: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 24: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil";
                break;
            }
            case 8: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/GruntTaskStructureUtil";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchStructure";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSettings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newFetchFail";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasksDir";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getGruntCliMainFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fetchStructure";
                break;
            }
            case 5: 
            case 6: 
            case 14: 
            case 17: 
            case 24: 
            case 31: 
            case 33: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFetchStructure";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkSettings";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newFetchFail";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseStructure";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parseStructureFromLine";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseStructureFromElement";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getGruntCliMainFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 14, 17, 24, 31, 33 -> new IllegalStateException(string);
        };
    }
}

