/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.util.EscapeUtils;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetector;
import com.intellij.javascript.testing.detection.JsTestFrameworkDetectors;
import com.intellij.javascript.testing.runConfiguration.JSTestLocation;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColorUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSTestFailedLineManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(JSTestFailedLineManager.class);
    private final Map<String, FailedTestData> myMap;
    private final Project myProject;
    private final Alarm myRestartDaemonAlarm;
    private volatile boolean myDaemonRestartRequested;

    public JSTestFailedLineManager(@NotNull Project project) {
        if (project == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(0);
        }
        this.myMap = new ConcurrentHashMap<String, FailedTestData>();
        this.myDaemonRestartRequested = false;
        this.myProject = project;
        this.myRestartDaemonAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
    }

    public void dispose() {
    }

    @NotNull
    public static JSTestFailedLineManager getInstance(@NotNull Project project) {
        if (project == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(1);
        }
        JSTestFailedLineManager jSTestFailedLineManager = (JSTestFailedLineManager)project.getService(JSTestFailedLineManager.class);
        if (jSTestFailedLineManager == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(2);
        }
        return jSTestFailedLineManager;
    }

    @Nullable
    public FailedTestInfo getFailedLineInfoForElement(@NotNull PsiElement methodExpr) {
        ResolveResult result2;
        PsiElement element2;
        if (methodExpr == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(3);
        }
        PsiElement psiElement = element2 = (result2 = this.findFailedLineForTest(methodExpr)) != null && result2.myPointer != null ? result2.myPointer.getElement() : null;
        if (element2 == methodExpr) {
            return result2.myTestInfo;
        }
        return null;
    }

    @Nullable
    public ResolveResult findFailedLineForTest(@NotNull PsiElement innerTestElement) {
        JSFile file;
        if (innerTestElement == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(4);
        }
        if ((file = (JSFile)ObjectUtils.tryCast((Object)innerTestElement.getContainingFile(), JSFile.class)) == null) {
            return null;
        }
        if (this.myMap.isEmpty()) {
            return null;
        }
        for (JsTestFrameworkDetector detector : JsTestFrameworkDetectors.Companion.getDetectorsSortedByDetectionPriority()) {
            FailedTestData data2;
            JsTestElementPath path2;
            AbstractTestFileStructure structure = detector.findTestsStructure(file);
            if (structure == null || (path2 = structure.findTestElementPath(innerTestElement.getTextRange())) == null || (data2 = this.findFailedTestData(path2)) == null) continue;
            ResolveResult result2 = data2.myResult;
            if (result2 == null) {
                JSTestFailedLineManager.resolveFailedLine(path2.getTestElement(), data2);
                result2 = Objects.requireNonNull(data2.myResult);
            }
            return result2;
        }
        return null;
    }

    @Nullable
    private FailedTestData findFailedTestData(@NotNull JsTestElementPath path2) {
        FailedTestData data2;
        if (path2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(5);
        }
        if ((data2 = this.myMap.get(JSTestFailedLineManager.locationUrl(path2, null))) != null) {
            return data2;
        }
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)path2.getTestElement());
        String filePath = file != null ? FileUtil.toSystemDependentName((String)file.getPath()) : null;
        return this.myMap.get(JSTestFailedLineManager.locationUrl(path2, filePath));
    }

    @NotNull
    private static String locationUrl(@NotNull JsTestElementPath path2, @Nullable String filePath) {
        List<String> testSuiteNames;
        if (path2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(6);
        }
        List<String> components = testSuiteNames = path2.getAllNames();
        if (filePath != null) {
            components = new ArrayList<String>(testSuiteNames.size() + 1);
            components.add(filePath);
            components.addAll(testSuiteNames);
        }
        String string = (path2.getTestName() == null ? "suite://" : "test://") + EscapeUtils.join(components, '.');
        if (string == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String locationUrl(@NotNull JsTestElementPath path2, boolean withTestFilePath) {
        VirtualFile file;
        if (path2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(8);
        }
        String filePath = null;
        if (withTestFilePath && (file = PsiUtilCore.getVirtualFile((PsiElement)path2.getTestElement())) != null) {
            filePath = FileUtil.toSystemDependentName((String)file.getPath());
        }
        return JSTestFailedLineManager.locationUrl(path2, filePath);
    }

    private static void resolveFailedLine(@NotNull PsiElement enclosingElement, @NotNull FailedTestData data2) {
        if (enclosingElement == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(9);
        }
        if (data2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(10);
        }
        String stacktrace = data2.myTestInfo.myStacktrace;
        String withoutAnsiStackTrace = JSTestFailedLineManager.clearAnsi(stacktrace);
        int stacktraceLength = withoutAnsiStackTrace.length();
        String[] lines = StringUtil.splitByLines((String)withoutAnsiStackTrace);
        PsiElement failedAssertionElement = null;
        OpenFileDescriptor failedAssertionDescriptor = null;
        for (String line : lines) {
            PsiElement element2;
            OpenFileDescriptor descriptor;
            HyperlinkInfo info;
            Filter.Result result2 = data2.myFilter.applyFilter(line, stacktraceLength);
            HyperlinkInfo hyperlinkInfo = info = result2 != null ? result2.getFirstHyperlinkInfo() : null;
            if (!(info instanceof FileHyperlinkInfo) || (descriptor = ((FileHyperlinkInfo)info).getDescriptor()) == null || (element2 = JSTestFailedLineManager.findElementAtOffsetIfInside(enclosingElement, descriptor)) == null) continue;
            failedAssertionElement = element2;
            failedAssertionDescriptor = descriptor;
        }
        data2.myResult = new ResolveResult((SmartPsiElementPointer<PsiElement>)(failedAssertionElement != null ? SmartPointerManager.createPointer(failedAssertionElement) : null), failedAssertionDescriptor, data2.myTestInfo);
    }

    @NotNull
    private static String clearAnsi(@NotNull String stacktrace) {
        if (stacktrace == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        new AnsiEscapeDecoder().escapeText(stacktrace, ProcessOutputTypes.STDOUT, (text, attributes) -> buffer.append(text));
        String string = buffer.toString();
        if (string == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static PsiElement findElementAtOffsetIfInside(@NotNull PsiElement enclosingElement, @NotNull OpenFileDescriptor descriptor) {
        int offset;
        PsiFile file;
        if (enclosingElement == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(13);
        }
        if (descriptor == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(14);
        }
        PsiFile psiFile = file = (file = enclosingElement.getContainingFile()) != null ? file.getOriginalFile() : null;
        if (file != null && descriptor.getFile().equals(file.getVirtualFile()) && (offset = descriptor.getOffset()) >= 0 && enclosingElement.getTextRange().contains(offset)) {
            return file.findElementAt(offset);
        }
        return null;
    }

    public void onTestConfigurationStarted(@NotNull GeneralTestEventsProcessor processor, final @NotNull Filter filter2, final @Nullable NodeTargetRun targetRun) {
        if (processor == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(15);
        }
        if (filter2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(16);
        }
        processor.addEventsListener((SMTRunnerEventsListener)new SMTRunnerEventsAdapter(){

            public void onTestStarted(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), null, null, filter2, targetRun);
            }

            public void onTestFinished(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (test.isPassed()) {
                    JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), null, null, filter2, targetRun);
                }
            }

            public void onTestFailed(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(2);
                }
                JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), test.getErrorMessage(), test.getStacktrace(), filter2, targetRun);
            }

            public void onTestIgnored(@NotNull SMTestProxy test) {
                if (test == null) {
                    1.$$$reportNull$$$0(3);
                }
                JSTestFailedLineManager.this.addInfo(test.getLocationUrl(), test.getErrorMessage(), test.getStacktrace(), filter2, targetRun);
            }

            public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
                if (testsRoot == null) {
                    1.$$$reportNull$$$0(4);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (JSTestFailedLineManager.this.myDaemonRestartRequested) {
                        JSTestFailedLineManager.this.myRestartDaemonAlarm.cancelAllRequests();
                        DaemonCodeAnalyzer.getInstance((Project)JSTestFailedLineManager.this.myProject).restart();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "test";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testsRoot";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/javascript/testing/JSTestFailedLineManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestFinished";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestFailed";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestIgnored";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTestingFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void addInfo(@Nullable @NonNls String locationUrl, @Nullable @InspectionMessage String errorMessage, @Nullable @NlsSafe String stacktrace, @NotNull Filter filter2, @Nullable NodeTargetRun targetRun) {
        boolean changed;
        String localLocationUrl;
        if (filter2 == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(17);
        }
        String string = localLocationUrl = locationUrl != null ? JSTestFailedLineManager.buildLocationUrlWithLocalPath(locationUrl, targetRun) : null;
        if (localLocationUrl == null) {
            return;
        }
        if (stacktrace == null || filter2 instanceof CompositeFilter && ((CompositeFilter)filter2).isEmpty()) {
            changed = this.myMap.remove(localLocationUrl) != null;
        } else {
            FailedTestData data2 = new FailedTestData(new FailedTestInfo(errorMessage, stacktrace), filter2);
            this.myMap.put(localLocationUrl, data2);
            changed = true;
        }
        if (changed) {
            this.requestDaemonRestart();
        }
    }

    @Nullable
    private static String buildLocationUrlWithLocalPath(@NotNull String locationUrl, @Nullable NodeTargetRun targetRun) {
        JSTestLocation testLocation;
        if (locationUrl == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(18);
        }
        if (targetRun == null || targetRun.getInterpreter() instanceof NodeJsLocalInterpreter) {
            return locationUrl;
        }
        try {
            testLocation = JSTestLocation.fromTestLocationUrl(locationUrl, targetRun);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Cannot build test coordinates by " + locationUrl, (Throwable)e);
            return null;
        }
        return testLocation.toLocationUrl();
    }

    private void requestDaemonRestart() {
        if (this.myRestartDaemonAlarm.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
            this.myRestartDaemonAlarm.addRequest(() -> {
                if (this.myDaemonRestartRequested) {
                    this.myRestartDaemonAlarm.cancelAllRequests();
                    this.myDaemonRestartRequested = false;
                    this.requestDaemonRestart();
                }
            }, 300);
        } else {
            this.myDaemonRestartRequested = true;
        }
    }

    @NotNull
    @NlsSafe
    private static String ansiToHtml(@NotNull @NlsSafe String text) {
        if (text == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(19);
        }
        StringBuilder buffer = new StringBuilder();
        new AnsiEscapeDecoder().escapeText(text, ProcessOutputTypes.STDOUT, (chunk, attributes) -> {
            boolean addColor;
            ConsoleViewContentType type2 = ConsoleViewContentType.getConsoleViewType((Key)attributes);
            boolean bl = addColor = type2 != ConsoleViewContentType.NORMAL_OUTPUT;
            if (addColor) {
                Color foregroundColor = type2.getAttributes().getForegroundColor();
                if (foregroundColor == null) {
                    foregroundColor = UIUtil.getLabelForeground();
                }
                buffer.append("<span style='color:#").append(ColorUtil.toHex((Color)foregroundColor)).append(";'>");
            }
            buffer.append(StringUtil.escapeXmlEntities((String)chunk));
            if (addColor) {
                buffer.append("</span>");
            }
        });
        String string = "<html><body><pre>" + String.valueOf(buffer) + "</pre></body></html>";
        if (string == null) {
            JSTestFailedLineManager.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 12, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JSTestFailedLineManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpr";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerTestElement";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationUrl";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JSTestFailedLineManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "locationUrl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "clearAnsi";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "ansiToHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 20: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFailedLineInfoForElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findFailedLineForTest";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFailedTestData";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "locationUrl";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveFailedLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "clearAnsi";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findElementAtOffsetIfInside";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "onTestConfigurationStarted";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addInfo";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildLocationUrlWithLocalPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "ansiToHtml";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 12, 20 -> new IllegalStateException(string);
        };
    }

    public static final class ResolveResult {
        @Nullable
        private final SmartPsiElementPointer<PsiElement> myPointer;
        @Nullable
        private final OpenFileDescriptor myDescriptor;
        private final FailedTestInfo myTestInfo;

        private ResolveResult(@Nullable SmartPsiElementPointer<PsiElement> pointer, @Nullable OpenFileDescriptor descriptor, @Nullable FailedTestInfo testInfo) {
            this.myPointer = pointer;
            this.myDescriptor = descriptor;
            this.myTestInfo = testInfo;
        }

        @Nullable
        public OpenFileDescriptor getDescriptor() {
            return this.myDescriptor;
        }
    }

    public static class FailedTestInfo {
        @Nullable
        private final @InspectionMessage String myMessage;
        @NotNull
        private final String myStacktrace;

        public FailedTestInfo(@Nullable @InspectionMessage String message, @NotNull String stacktrace) {
            if (stacktrace == null) {
                FailedTestInfo.$$$reportNull$$$0(0);
            }
            this.myMessage = message;
            this.myStacktrace = stacktrace;
        }

        @Nullable
        @InspectionMessage
        public String getMessage() {
            if (this.myMessage != null) {
                return JSTestFailedLineManager.ansiToHtml(this.myMessage);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stacktrace", "com/intellij/javascript/testing/JSTestFailedLineManager$FailedTestInfo", "<init>"));
        }
    }

    private static final class FailedTestData {
        private final FailedTestInfo myTestInfo;
        private final Filter myFilter;
        private ResolveResult myResult;

        private FailedTestData(@NotNull FailedTestInfo testInfo, @NotNull Filter filter2) {
            if (testInfo == null) {
                FailedTestData.$$$reportNull$$$0(0);
            }
            if (filter2 == null) {
                FailedTestData.$$$reportNull$$$0(1);
            }
            this.myFilter = filter2;
            this.myTestInfo = testInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "testInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "filter";
                    break;
                }
            }
            objectArray[1] = "com/intellij/javascript/testing/JSTestFailedLineManager$FailedTestData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

