/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.sql.generator;

import java.util.Collection;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.generator.SQLGeneratorTable;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorUpdateFrom
extends SQLGeneratorTable {
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, DBSEntity object) throws DBException {
        Collection keyAttributes = this.getKeyAttributes(monitor, object);
        String entityName = this.getEntityName(object);
        String separator = this.getLineSeparator();
        sql.append("UPDATE ").append(entityName).append(" AS tgt");
        sql.append(separator).append("SET ");
        boolean hasAttr = false;
        for (DBSAttributeBase attr : this.getValueAttributes(monitor, object, keyAttributes)) {
            if (DBUtils.isPseudoAttribute((DBSAttributeBase)attr) || DBUtils.isHiddenObject((Object)attr)) continue;
            if (hasAttr) {
                sql.append(", ");
            }
            sql.append(DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
            sql.append("src." + DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML));
            hasAttr = true;
        }
        sql.append(this.getLineSeparator()).append("FROM SOURCE_TABLE AS src");
        if (!CommonUtils.isEmpty((Collection)keyAttributes)) {
            sql.append(this.getLineSeparator()).append("WHERE ");
            hasAttr = false;
            for (DBSAttributeBase attr : keyAttributes) {
                if (hasAttr) {
                    sql.append(" AND ");
                }
                sql.append("tgt." + DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML)).append("=");
                sql.append("src." + DBUtils.getObjectFullName((DBPNamedObject)attr, (DBPEvaluationContext)DBPEvaluationContext.DML));
                hasAttr = true;
            }
        } else {
            sql.append("ON ('/* insert attributes equality here, e.g. tgt.ID = src.ID AND ... */')").append(this.getLineSeparator());
        }
        sql.append(";").append(this.getLineSeparator());
    }
}

