/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model.lock;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.model.admin.locks.DBAServerLock;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class PostgreLock
implements DBAServerLock {
    private int wait_pid;
    private String wait_user;
    private int hold_pid;
    private String hold_user;
    private String wait_statement;
    private String statement_in;
    private DBAServerLock hold = null;
    private List<DBAServerLock> waiters = new ArrayList<DBAServerLock>(0);

    public PostgreLock(ResultSet dbResult) {
        this.wait_pid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"blocked_pid");
        this.wait_user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"blocked_user");
        this.hold_pid = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"blocking_pid");
        this.hold_user = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"blocking_user");
        this.wait_statement = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"blocked_statement");
        this.statement_in = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"statement_in");
    }

    @Property(viewable=true, order=1)
    public int getWait_pid() {
        return this.wait_pid;
    }

    @Property(viewable=true, order=2)
    public String getWait_user() {
        return this.wait_user;
    }

    @Property(viewable=true, order=3)
    public int getHold_pid() {
        return this.hold_pid;
    }

    @Property(viewable=true, order=4)
    public String getHold_user() {
        return this.hold_user;
    }

    @Property(viewable=true, order=5)
    public String getWait_statement() {
        return this.wait_statement;
    }

    @Property(viewable=true, order=6)
    public String getStatement_in() {
        return this.statement_in;
    }

    public String getTitle() {
        return String.valueOf(this.wait_pid);
    }

    public DBAServerLock getHoldBy() {
        return this.hold;
    }

    public DBAServerLock getHold() {
        return this.hold;
    }

    public Integer getId() {
        return this.wait_pid;
    }

    public List<DBAServerLock> waitThis() {
        return this.waiters;
    }

    public Integer getHoldID() {
        return this.hold_pid;
    }

    public void setHoldBy(DBAServerLock lock) {
        this.hold = lock;
    }

    public String toString() {
        return String.format("Wait - %d (%s) Hold - %d (%s)", this.wait_pid, this.wait_user, this.hold_pid, this.hold_user);
    }
}

