/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class PostgreAuthPgPassConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    protected Text usernameText;
    private Text overriddenHostnameText;
    private Button overrideHostname;

    public void createControl(@NotNull Composite authPanel, Object object, @NotNull Runnable propertyChangeListener) {
        Label usernameLabel = UIUtils.createLabel((Composite)authPanel, (String)UIConnectionMessages.dialog_connection_auth_label_username);
        usernameLabel.setLayoutData((Object)new GridData(32));
        this.usernameText = new Text(authPanel, 2048);
        this.usernameText.addModifyListener(e -> propertyChangeListener.run());
        this.usernameText.setLayoutData((Object)new GridData(768));
        this.overrideHostname = UIUtils.createCheckbox((Composite)authPanel, (boolean)false);
        this.overrideHostname.setText(PostgreMessages.dialog_connection_pgpass_hostname_override);
        this.overrideHostname.setToolTipText(PostgreMessages.dialog_connection_pgpass_hostname_override_tip);
        this.overrideHostname.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreAuthPgPassConfigurator.this.overriddenHostnameText.setEnabled(PostgreAuthPgPassConfigurator.this.overrideHostname.getSelection());
            }
        });
        this.overrideHostname.setLayoutData((Object)new GridData(32));
        this.overriddenHostnameText = new Text(authPanel, 2048);
        this.overriddenHostnameText.setLayoutData((Object)new GridData(768));
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionConfiguration = dataSource.getConnectionConfiguration();
        this.overrideHostname.setSelection(!CommonUtils.isEmpty((String)connectionConfiguration.getProviderProperty("overriddenUsername")));
        this.overriddenHostnameText.setEnabled(this.overrideHostname.getSelection());
        if (this.overrideHostname.getSelection() && !CommonUtils.isEmpty((String)connectionConfiguration.getProviderProperty("overriddenUsername"))) {
            this.overriddenHostnameText.setText(connectionConfiguration.getProviderProperty("overriddenUsername"));
        }
        this.usernameText.setText(CommonUtils.notEmpty((String)connectionConfiguration.getUserName()));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        dataSource.getConnectionConfiguration().setUserName(this.usernameText.getText());
        if (this.overrideHostname.getSelection()) {
            dataSource.getConnectionConfiguration().setProviderProperty("overriddenUsername", this.overriddenHostnameText.getText());
        } else {
            dataSource.getConnectionConfiguration().setProviderProperty("overriddenUsername", null);
        }
        dataSource.setSavePassword(true);
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.loadSettings(dataSource);
    }

    public boolean isComplete() {
        return true;
    }
}

