/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.function.Consumer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.HistoryStore;

class SearchHistoryMenu
extends Dialog {
    private final Consumer<String> historyEntrySelectedCallback;
    private final HistoryStore history;
    private final ShellListener shellFocusListener = new ShellAdapter(){

        public void shellDeactivated(ShellEvent e) {
            if (!SearchHistoryMenu.this.getShell().isDisposed()) {
                SearchHistoryMenu.this.getShell().getDisplay().asyncExec(() -> ((SearchHistoryMenu)SearchHistoryMenu.this).close());
            }
        }
    };
    private Point location;
    private int width;
    private Table table;
    private TableColumn column;
    private int selectedIndexInTable = -1;

    public SearchHistoryMenu(Shell parent, HistoryStore history, Consumer<String> historyEntrySelectedCallback) {
        super(parent);
        this.setShellStyle(0);
        this.setBlockOnOpen(false);
        this.historyEntrySelectedCallback = historyEntrySelectedCallback;
        this.history = history;
    }

    public void setPosition(int x, int y, int width) {
        this.location = new Point(x, y);
        this.width = width;
    }

    public Control createContents(Composite parent) {
        this.table = new Table(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.table);
        this.column = new TableColumn(this.table, 0);
        if (this.history.size() == 0) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(FindReplaceMessages.SearchHistoryMenu_SEARCH_HISTORY_EMPTY_STRING);
            this.table.setEnabled(false);
        } else {
            for (String entry : this.history.get()) {
                TableItem item = new TableItem(this.table, 0);
                item.setText(entry);
            }
        }
        this.attachTableListeners();
        this.getShell().pack();
        this.getShell().layout();
        return this.table;
    }

    private void moveSelectionInTable(int indexShift) {
        this.selectedIndexInTable += indexShift;
        if (this.selectedIndexInTable < 0) {
            this.selectedIndexInTable = this.table.getItemCount() - 1;
        } else if (this.selectedIndexInTable > this.table.getItemCount() - 1) {
            this.selectedIndexInTable = 0;
        }
        this.table.setSelection(this.selectedIndexInTable);
        this.historyEntrySelectedCallback.accept(this.table.getSelection()[0].getText());
    }

    private void attachTableListeners() {
        this.table.addListener(5, event -> {
            Point point = new Point(event.x, event.y);
            TableItem item = this.table.getItem(point);
            if (item != null) {
                this.table.setSelection(item);
                this.selectedIndexInTable = this.table.getSelectionIndex();
            }
        });
        this.table.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.keyCode == 0x1000002) {
                this.moveSelectionInTable(1);
                e.doit = false;
            } else if (e.keyCode == 0x1000001) {
                this.moveSelectionInTable(-1);
                e.doit = false;
            } else if (e.keyCode == 13 || e.keyCode == 0x1000050) {
                this.notifyParentOfSelectionInput();
                this.close();
            }
        }));
        this.table.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.notifyParentOfSelectionInput()));
        this.table.addMouseListener(MouseListener.mouseDownAdapter(e -> {
            this.table.notifyListeners(13, null);
            this.close();
        }));
    }

    private void notifyParentOfSelectionInput() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length == 0) {
            this.historyEntrySelectedCallback.accept(null);
            return;
        }
        String text = selection[0].getText();
        if (text != null) {
            this.historyEntrySelectedCallback.accept(text);
        }
        this.historyEntrySelectedCallback.accept(null);
    }

    private void positionShell() {
        if (this.location != null && this.table.getItemCount() != 0) {
            this.getShell().setBounds(this.location.x, this.location.y, this.width, Math.min(this.table.getItemHeight() * 7, this.table.getItemHeight() * this.table.getItemCount() + 2));
        }
        int columnWidth = this.table.getSize().x;
        if (this.table.getVerticalBar() != null && this.table.getVerticalBar().isVisible()) {
            columnWidth = this.table.getSize().x - this.table.getVerticalBar().getSize().x;
        }
        this.column.setWidth(columnWidth);
    }

    public int open() {
        int code = super.open();
        this.getShell().addShellListener(this.shellFocusListener);
        this.positionShell();
        return code;
    }
}

