/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.config.migration.wizards.custom;

import java.io.File;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.config.migration.ImportConfigMessages;
import org.jkiss.dbeaver.ui.config.migration.wizards.custom.ConfigImportWizardCustom;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFile;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ConfigImportWizardPageCustomSettings
extends WizardPage {
    private TextWithOpenFile filePathText;
    private Button xmlButton;
    private Button csvButton;
    private File inputFile;
    private Combo encodingCombo;

    protected ConfigImportWizardPageCustomSettings() {
        super(ImportConfigMessages.config_import_wizard_custom_driver_settings);
        this.setTitle(ImportConfigMessages.config_import_wizard_custom_driver_import_settings_name);
        this.setDescription(ImportConfigMessages.config_import_wizard_custom_driver_import_settings_file_format_description);
    }

    public void createControl(Composite parent) {
        Composite placeholder = new Composite(parent, 0);
        placeholder.setLayout((Layout)new GridLayout(1, true));
        Group typeGroup = UIUtils.createControlGroup((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_custom_input_type, (int)2, (int)768, (int)-1);
        this.xmlButton = new Button((Composite)typeGroup, 16);
        this.xmlButton.setText("XML");
        this.xmlButton.setSelection(true);
        this.csvButton = new Button((Composite)typeGroup, 16);
        this.csvButton.setText("CSV");
        UIUtils.createControlLabel((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_custom_input_file);
        this.filePathText = new TextWithOpenFile(placeholder, ImportConfigMessages.config_import_wizard_custom_input_file_configuration, new String[]{"*", "*.csv", "*.xml", "*.*"});
        this.filePathText.setLayoutData((Object)new GridData(768));
        this.filePathText.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigImportWizardPageCustomSettings.this.inputFile = new File(ConfigImportWizardPageCustomSettings.this.filePathText.getText());
                if (!ConfigImportWizardPageCustomSettings.this.inputFile.exists()) {
                    ConfigImportWizardPageCustomSettings.this.setErrorMessage(NLS.bind((String)ImportConfigMessages.config_import_wizard_file_doesnt_exist_error, (Object)ConfigImportWizardPageCustomSettings.this.inputFile.getAbsolutePath()));
                } else {
                    ConfigImportWizardPageCustomSettings.this.setErrorMessage(null);
                }
                ConfigImportWizardPageCustomSettings.this.getWizard().getContainer().updateButtons();
            }
        });
        UIUtils.createControlLabel((Composite)placeholder, (String)ImportConfigMessages.config_import_wizard_file_encoding);
        this.encodingCombo = UIUtils.createEncodingCombo((Composite)placeholder, (String)GeneralUtils.DEFAULT_ENCODING);
        this.setControl((Control)placeholder);
    }

    public boolean isPageComplete() {
        return this.inputFile != null && this.inputFile.exists();
    }

    public ConfigImportWizardCustom.ImportType getImportType() {
        return this.csvButton.getSelection() ? ConfigImportWizardCustom.ImportType.CSV : ConfigImportWizardCustom.ImportType.XML;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public String getInputFileEncoding() {
        return this.encodingCombo.getText();
    }
}

