/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import com.dbeaver.jdbc.driver.libsql.LibSqlConnection;
import com.dbeaver.jdbc.driver.libsql.LibSqlStatement;
import com.dbeaver.jdbc.driver.libsql.client.LibSqlReaderInput;
import com.dbeaver.jdbc.driver.libsql.client.LibSqlStreamInput;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.jkiss.code.NotNull;

public class LibSqlPreparedStatement
extends LibSqlStatement
implements PreparedStatement {
    public LibSqlPreparedStatement(@NotNull LibSqlConnection connection, String sql) throws SQLException {
        super(connection);
        this.queryText = sql;
    }

    protected void addParameter(int parameterIndex, Object value) {
        this.parameters.put(parameterIndex, value);
    }

    protected void addParameter(String parameterName, Object value) {
        this.parameters.put(parameterName, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.addParameter(parameterIndex, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.addParameter(parameterIndex, (Object)Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, length));
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, length));
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.addParameter(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.addParameter(parameterIndex, x);
    }

    @Override
    public void addBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Batches not supported");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, length));
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("Statement resultset metadata not supported");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.addParameter(parameterIndex, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLFeatureNotSupportedException("Parameters metadata not supported");
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.addParameter(parameterIndex, (Object)x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.addParameter(parameterIndex, (Object)value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(value, length));
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.addParameter(parameterIndex, (Object)value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, length));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(inputStream, length));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, length));
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.addParameter(parameterIndex, (Object)xmlObject);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.addParameter(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, length));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, length));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, length));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, -1L));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(x, -1L));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, -1L));
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(value, -1L));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, -1L));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlStreamInput(inputStream, -1L));
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.addParameter(parameterIndex, (Object)new LibSqlReaderInput(reader, -1L));
    }
}

