/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.plan;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlanNode;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.utils.CommonUtils;

public class ExasolPlanNode
extends AbstractExecutionPlanNode {
    private static final String ATTR_STMT_ID = "STMT_ID";
    private static final String ATTR_COMMAND_NAME = "COMMAND_NAME";
    private static final String ATTR_COMMAND_CLASS = "COMMAND_CLASS";
    private static final String ATTR_PART_ID = "PART_ID";
    private static final String ATTR_PART_NAME = "PART_NAME";
    private static final String ATTR_PART_INFO = "PART_INFO";
    private static final String ATTR_OBJECT_SCHEMA = "OBJECT_SCHEMA";
    private static final String ATTR_OBJECT_NAME = "OBJECT_NAME";
    private static final String ATTR_OBJECT_ROWS = "OBJECT_ROWS";
    private static final String ATTR_OUT_ROWS = "OUT_ROWS";
    private static final String ATTR_DURATION = "DURATION";
    private static final String ATTR_CPU = "CPU";
    private static final String ATTR_TEMP_DB_RAM_PEAK = "TEMP_DB_RAM_PEAK";
    private static final String ATTR_HDD_READ = "HDD_READ";
    private static final String ATTR_HDD_WRITE = "HDD_WRITE";
    private static final String ATTR_NET = "NET";
    private static final String ATTR_REMARKS = "REMARKS";
    private ExasolPlanNode parent;
    private Collection<ExasolPlanNode> listNestedNodes = new ArrayList<ExasolPlanNode>(64);
    private int stmtId;
    private String commandName;
    private String commandClass;
    private int partId;
    private String partName;
    private String partInfo;
    private String objectSchema;
    private String objectName;
    private Double objectRows;
    private Double outRows;
    private Double duration;
    private Double cpu;
    private Double tempDbRamPeak;
    private Double hddRead;
    private Double hddWrite;
    private Double netTransfer;
    private String detailInfo;
    private Map<String, Object> attributes;

    public Collection<ExasolPlanNode> getListNestedNodes() {
        return this.listNestedNodes;
    }

    public ExasolPlanNode(ExasolPlanNode parent, ResultSet dbResult) {
        this.parent = parent;
        this.stmtId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)ATTR_STMT_ID);
        this.commandName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_COMMAND_NAME);
        this.commandClass = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_COMMAND_CLASS);
        this.partId = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)ATTR_PART_ID);
        this.partName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_PART_NAME);
        this.partInfo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_PART_INFO);
        this.objectSchema = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_OBJECT_SCHEMA);
        this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_OBJECT_NAME);
        this.objectRows = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_OBJECT_ROWS);
        this.outRows = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_OUT_ROWS);
        this.duration = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_DURATION);
        this.cpu = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_CPU);
        this.tempDbRamPeak = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_TEMP_DB_RAM_PEAK);
        this.hddRead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_HDD_READ);
        this.hddWrite = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_HDD_WRITE);
        this.netTransfer = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)ATTR_NET);
        this.detailInfo = JDBCUtils.safeGetString((ResultSet)dbResult, (String)ATTR_REMARKS);
        this.fillAttributes();
    }

    public ExasolPlanNode(ExasolPlanNode parent, Map<String, Object> attributes) {
        this.parent = parent;
        this.stmtId = JSONUtils.getInteger(attributes, (String)ATTR_STMT_ID);
        this.commandName = JSONUtils.getString(attributes, (String)ATTR_COMMAND_NAME);
        this.commandClass = JSONUtils.getString(attributes, (String)ATTR_COMMAND_CLASS);
        this.partId = JSONUtils.getInteger(attributes, (String)ATTR_PART_ID);
        this.partName = JSONUtils.getString(attributes, (String)ATTR_PART_NAME);
        this.partInfo = JSONUtils.getString(attributes, (String)ATTR_PART_INFO);
        this.objectSchema = JSONUtils.getString(attributes, (String)ATTR_OBJECT_SCHEMA);
        this.objectName = JSONUtils.getString(attributes, (String)ATTR_OBJECT_NAME);
        this.objectRows = JSONUtils.getDouble(attributes, (String)ATTR_OBJECT_ROWS);
        this.outRows = JSONUtils.getDouble(attributes, (String)ATTR_OUT_ROWS);
        this.duration = JSONUtils.getDouble(attributes, (String)ATTR_DURATION);
        this.cpu = JSONUtils.getDouble(attributes, (String)ATTR_CPU);
        this.tempDbRamPeak = JSONUtils.getDouble(attributes, (String)ATTR_TEMP_DB_RAM_PEAK);
        this.hddRead = JSONUtils.getDouble(attributes, (String)ATTR_HDD_READ);
        this.hddWrite = JSONUtils.getDouble(attributes, (String)ATTR_HDD_WRITE);
        this.netTransfer = JSONUtils.getDouble(attributes, (String)ATTR_NET);
        this.detailInfo = JSONUtils.getString(attributes, (String)ATTR_REMARKS);
        this.attributes = attributes;
    }

    public DBCPlanNode getParent() {
        return this.parent;
    }

    public Collection<ExasolPlanNode> getNested() {
        return this.listNestedNodes;
    }

    public String getNodeName() {
        return this.objectName;
    }

    public String getNodeType() {
        return this.commandName;
    }

    public String getNodeDescription() {
        return this.detailInfo;
    }

    @Property(order=0, viewable=true)
    public int getStmtId() {
        return this.stmtId;
    }

    @Property(order=1, viewable=true)
    public String getCommandName() {
        return this.commandName;
    }

    @Property(order=2, viewable=true)
    public String getCommandClass() {
        return this.commandClass;
    }

    @Property(order=3, viewable=true)
    public int getPartId() {
        return this.partId;
    }

    @Property(order=4, viewable=true)
    public String getPartName() {
        return this.partName;
    }

    @Property(order=5, viewable=true)
    public String getPartInfo() {
        return this.partInfo;
    }

    @Property(order=6, viewable=true)
    public String getObjectSchema() {
        return this.objectSchema;
    }

    @Property(order=7, viewable=true)
    public String getObjectName() {
        return this.objectName;
    }

    @Property(order=8, viewable=true)
    public Double getObjectRows() {
        return this.objectRows;
    }

    @Property(order=9, viewable=true)
    public Double getOutRows() {
        return this.outRows;
    }

    @Property(order=10, viewable=true)
    public Double getDuration() {
        return this.duration;
    }

    @Property(order=11, viewable=true)
    public Double getCpu() {
        return this.cpu;
    }

    @Property(order=12, viewable=true)
    public Double getTempDbRamPeak() {
        return this.tempDbRamPeak;
    }

    @Property(order=13, viewable=true)
    public Double getHddRead() {
        return this.hddRead;
    }

    @Property(order=14, viewable=true)
    public Double getHddWrite() {
        return this.hddWrite;
    }

    @Property(order=15, viewable=true)
    public Double getNetTransfer() {
        return this.netTransfer;
    }

    @Property(order=16, viewable=true)
    public String getDetailInfo() {
        return this.detailInfo;
    }

    private void fillAttributes() {
        this.attributes = new HashMap<String, Object>();
        this.attributes.put(ATTR_STMT_ID, this.stmtId);
        this.putNotNullStringInMap(ATTR_COMMAND_NAME, this.commandName);
        this.putNotNullStringInMap(ATTR_COMMAND_CLASS, this.commandClass);
        this.attributes.put(ATTR_PART_ID, this.partId);
        this.putNotNullStringInMap(ATTR_PART_NAME, this.partName);
        this.putNotNullStringInMap(ATTR_PART_INFO, this.partInfo);
        this.putNotNullStringInMap(ATTR_OBJECT_SCHEMA, this.objectSchema);
        this.putNotNullStringInMap(ATTR_OBJECT_NAME, this.objectName);
        this.attributes.put(ATTR_OBJECT_ROWS, this.objectRows);
        this.attributes.put(ATTR_OUT_ROWS, this.outRows);
        this.attributes.put(ATTR_DURATION, this.duration);
        this.attributes.put(ATTR_CPU, this.cpu);
        this.attributes.put(ATTR_TEMP_DB_RAM_PEAK, this.tempDbRamPeak);
        this.attributes.put(ATTR_HDD_READ, this.hddRead);
        this.attributes.put(ATTR_HDD_WRITE, this.hddWrite);
        this.attributes.put(ATTR_NET, this.netTransfer);
        this.putNotNullStringInMap(ATTR_REMARKS, this.detailInfo);
    }

    private void putNotNullStringInMap(@NotNull String key, @Nullable String object) {
        if (CommonUtils.isNotEmpty((String)object)) {
            this.attributes.put(key, object);
        }
    }

    Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

