/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.connection.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import net.schmizz.sshj.common.CircularBuffer;
import net.schmizz.sshj.common.ErrorNotifiable;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.Channel;
import net.schmizz.sshj.connection.channel.Window;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import org.slf4j.Logger;

public final class ChannelInputStream
extends InputStream
implements ErrorNotifiable {
    private final Logger log;
    private final Channel chan;
    private final Transport trans;
    private final Window.Local win;
    private final CircularBuffer.PlainCircularBuffer buf;
    private final byte[] b = new byte[1];
    private boolean eof;
    private SSHException error;

    public ChannelInputStream(Channel chan, Transport trans, Window.Local win) {
        this.chan = chan;
        this.log = chan.getLoggerFactory().getLogger(this.getClass());
        this.trans = trans;
        this.win = win;
        this.buf = new CircularBuffer.PlainCircularBuffer(chan.getLocalMaxPacketSize(), trans.getConfig().getMaxCircularBufferSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() {
        CircularBuffer.PlainCircularBuffer plainCircularBuffer = this.buf;
        synchronized (plainCircularBuffer) {
            return this.buf.available();
        }
    }

    @Override
    public void close() {
        this.eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eof() {
        CircularBuffer.PlainCircularBuffer plainCircularBuffer = this.buf;
        synchronized (plainCircularBuffer) {
            if (!this.eof) {
                this.eof = true;
                this.buf.notifyAll();
            }
        }
    }

    @Override
    public synchronized void notifyError(SSHException error) {
        this.error = error;
        this.eof();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        byte[] byArray = this.b;
        synchronized (this.b) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.read(this.b, 0, 1) == -1 ? -1 : this.b[0] & 0xFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        CircularBuffer.PlainCircularBuffer plainCircularBuffer = this.buf;
        synchronized (plainCircularBuffer) {
            while (this.buf.available() <= 0) {
                if (this.eof) {
                    if (this.error != null) {
                        throw this.error;
                    }
                    return -1;
                }
                try {
                    this.buf.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw (IOException)new InterruptedIOException().initCause(e);
                }
            }
            if (len > this.buf.available()) {
                len = this.buf.available();
            }
            this.buf.readRawBytes(b, off, len);
            if (!this.chan.getAutoExpand()) {
                this.checkWindow();
            }
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(byte[] data, int offset, int len) throws SSHException {
        if (this.eof) {
            throw new ConnectionException("Getting data on EOF'ed stream");
        }
        CircularBuffer.PlainCircularBuffer plainCircularBuffer = this.buf;
        synchronized (plainCircularBuffer) {
            this.buf.putRawBytes(data, offset, len);
            this.buf.notifyAll();
            this.win.consume(len);
            if (this.chan.getAutoExpand()) {
                this.checkWindow();
            }
        }
    }

    private void checkWindow() throws TransportException {
        long maxAdjustment = (long)this.buf.maxPossibleRemainingCapacity() - this.win.getSize();
        long adjustment = Math.min(this.win.neededAdjustment(), maxAdjustment);
        if (adjustment > 0L) {
            this.log.debug("Sending SSH_MSG_CHANNEL_WINDOW_ADJUST to #{} for {} bytes", (Object)this.chan.getRecipient(), (Object)adjustment);
            this.trans.write((SSHPacket)((SSHPacket)new SSHPacket(Message.CHANNEL_WINDOW_ADJUST).putUInt32FromInt(this.chan.getRecipient())).putUInt32(adjustment));
            this.win.expand(adjustment);
        }
    }

    public String toString() {
        return "< ChannelInputStream for Channel #" + this.chan.getID() + " >";
    }
}

