/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data;

import java.util.ArrayList;
import java.util.Map;
import java.util.StringJoiner;
import org.eclipse.core.runtime.Assert;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDInsertReplaceMethod;
import org.jkiss.dbeaver.model.data.DBDValueBinder;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.impl.sql.BaseInsertMethod;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.utils.CommonUtils;

public class ExecuteInsertBatchImpl
extends ExecuteBatchImpl {
    private DBCSession session;
    private final DBCExecutionSource source;
    private DBSTable table;
    private boolean useUpsert;
    private boolean allNulls;
    private boolean allColumnsDefault;

    public ExecuteInsertBatchImpl(@NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, boolean reuseStatement, @NotNull DBCSession session, @NotNull DBCExecutionSource source, @NotNull DBSTable table, boolean useUpsert) {
        super(attributes, keysReceiver, reuseStatement);
        this.session = session;
        this.source = source;
        this.table = table;
        this.useUpsert = useUpsert;
    }

    @Override
    protected int getNextUsedParamIndex(Object[] attributeValues, int paramIndex) {
        DBSAttributeBase attribute = this.attributes[++paramIndex];
        while (DBUtils.isPseudoAttribute(attribute) || !this.allNulls && DBUtils.isNullValue(attributeValues[paramIndex])) {
            ++paramIndex;
        }
        return paramIndex;
    }

    @Override
    @NotNull
    protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
        StringBuilder queryForStatement = this.prepareQueryForStatement(session, handlers, attributeValues, this.attributes, this.table, false, options);
        boolean skipBindValues = CommonUtils.toBoolean((Object)options.get("data.manipulate.skipBindValues"));
        DBCStatement dbStat = session.prepareStatement(skipBindValues ? DBCStatementType.SCRIPT : DBCStatementType.QUERY, queryForStatement.toString(), false, false, this.keysReceiver != null);
        dbStat.setStatementSource(this.source);
        return dbStat;
    }

    @Override
    protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
        if (this.allColumnsDefault) {
            return;
        }
        int paramIndex = 0;
        int k = 0;
        while (k < handlers.length) {
            DBSAttributeBase attribute = this.attributes[k];
            if (!(DBUtils.isPseudoAttribute(attribute) || !this.allNulls && DBUtils.isNullValue(attributeValues[k]) || this.allNulls && this.attributeHasDefaultValue(attribute))) {
                handlers[k].bindValueObject(statement.getSession(), statement, attribute, paramIndex++, attributeValues[k]);
                if (this.session.getProgressMonitor().isCanceled()) break;
            }
            ++k;
        }
    }

    StringBuilder prepareQueryForStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, DBSAttributeBase[] attributes, DBSTable table, boolean useMultiRowInsert, Map<String, Object> options) throws DBCException {
        this.allColumnsDefault = false;
        Assert.isLegal((attributes.length == handlers.length ? 1 : 0) != 0);
        Assert.isLegal((useMultiRowInsert || attributes.length == attributeValues.length ? 1 : 0) != 0);
        String tableName = DBUtils.getEntityScriptName(table, options);
        StringBuilder query = new StringBuilder(200);
        DBDInsertReplaceMethod method = (DBDInsertReplaceMethod)options.get("data.manipulate.insertReplaceMethod");
        if (method == null) {
            method = new BaseInsertMethod();
        }
        if (this.useUpsert) {
            query.append("UPSERT").append(" INTO");
        } else {
            query.append(method.getOpeningClause(table, session.getProgressMonitor()));
        }
        query.append(" ").append(tableName).append(" (");
        this.allNulls = true;
        int i = 0;
        while (i < attributes.length) {
            if (!DBUtils.isNullValue(attributeValues[i])) {
                this.allNulls = false;
                break;
            }
            ++i;
        }
        DBPDataSource dataSource = session.getDataSource();
        if (this.allNulls && !useMultiRowInsert && method instanceof BaseInsertMethod && !this.useUpsert && dataSource.getSQLDialect().supportsInsertAllDefaultValuesStatement()) {
            this.allColumnsDefault = true;
            query.setLength(0);
            query.append("INSERT INTO ").append(tableName).append(" DEFAULT VALUES");
            return query;
        }
        boolean hasKey = false;
        ArrayList<Integer> usedAttributes = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < attributes.length) {
            DBSAttributeBase attribute = attributes[i2];
            if (!DBUtils.isPseudoAttribute(attribute) && (useMultiRowInsert || this.allNulls || !DBUtils.isNullValue(attributeValues[i2]))) {
                if (hasKey) {
                    query.append(",");
                }
                hasKey = true;
                String attributeName = DBStructUtils.getAttributeName(attribute);
                query.append(attributeName);
                usedAttributes.add(i2);
            }
            ++i2;
        }
        query.append(")\n\tVALUES ");
        int[] usedAttributesArr = usedAttributes.stream().mapToInt(Integer::intValue).toArray();
        StringJoiner valuesPart = new StringJoiner(",");
        boolean skipBindValues = CommonUtils.toBoolean((Object)options.get("data.manipulate.skipBindValues"));
        int i3 = 0;
        while (i3 < attributeValues.length / attributes.length) {
            StringJoiner rowValuesPart = new StringJoiner(",", "(", ")");
            int[] nArray = usedAttributesArr;
            int n = usedAttributesArr.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                DBSAttributeBase attribute = attributes[j];
                DBDValueHandler valueHandler = handlers[j];
                int k = i3 * attributes.length + j;
                if (valueHandler instanceof DBDValueBinder) {
                    rowValuesPart.add(((DBDValueBinder)valueHandler).makeQueryBind(attribute, attributeValues[k]));
                } else if (skipBindValues) {
                    rowValuesPart.add(SQLUtils.convertValueToSQL(session.getDataSource(), attribute, valueHandler, attributeValues[k], DBDDisplayFormat.NATIVE, false));
                } else if (this.allNulls && this.attributeHasDefaultValue(attribute)) {
                    rowValuesPart.add("DEFAULT");
                } else {
                    rowValuesPart.add("?");
                }
                ++n2;
            }
            valuesPart.add(rowValuesPart.toString());
            ++i3;
        }
        query.append(valuesPart);
        String trailingClause = method.getTrailingClause(table, session.getProgressMonitor(), attributes);
        if (trailingClause != null) {
            query.append(trailingClause);
        }
        return query;
    }

    private boolean attributeHasDefaultValue(@NotNull DBSAttributeBase attribute) {
        if (DBUtils.isPseudoAttribute(attribute) || DBUtils.isHiddenObject(attribute)) {
            return false;
        }
        if (attribute instanceof DBDAttributeBinding) {
            DBSEntityAttribute entityAttribute = ((DBDAttributeBinding)attribute).getEntityAttribute();
            return entityAttribute != null && CommonUtils.isNotEmpty((String)entityAttribute.getDefaultValue());
        }
        return false;
    }
}

